/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.dashboard;

import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyEdgeDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyIfPairDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyNodeDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyVlanDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyVlanListDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyVsanDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyVsanListDO;
import com.cisco.dcbu.jaxws.san.wo.OperationStatusDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class TopologyHandler {
    private static TopologyHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");

    public static TopologyHandler getInstance() {
        if (_Instance == null) {
            _Instance = new TopologyHandler();
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardTopologyDO getDashboardTopology(DbFilterDO dbFilter) {
        DashboardTopologyDO ft = new DashboardTopologyDO();
        Connection con = null;
        try {
            Integer i;
            HashMap<String, Integer> map;
            con = ConnectionManager.getConnection();
            if (NavigationUtil.getInstance().getCountEntitiesInGroup(dbFilter.getGroupFilterXml(), 0) > 0) {
                ft.setSwitchList(this.getSwitchList(con, dbFilter));
                ft.setIslList(this.getIslList(con, dbFilter));
                ft.setNpvList(this.getNpvList(con, dbFilter));
                map = new HashMap<String, Integer>();
                for (DashboardTopologyNodeDO n : ft.getSwitchList()) {
                    i = (Integer)map.get(n.getGroupName());
                    if (i != null) continue;
                    map.put(n.getGroupName(), new Integer(1));
                }
                ft.setFabricCount(map.size());
            }
            if (NavigationUtil.getInstance().getCountEntitiesInGroup(dbFilter.getGroupFilterXml(), 1) > 0) {
                ft.setEthSwitchList(this.getEthSwitchList(con, dbFilter));
                ft.setEthIslList(this.getEthIslList(con, dbFilter));
                map = new HashMap();
                for (DashboardTopologyNodeDO n : ft.getEthSwitchList()) {
                    i = (Integer)map.get(n.getGroupName());
                    if (i != null) continue;
                    map.put(n.getGroupName(), new Integer(1));
                }
                ft.setLanCount(map.size());
            }
        }
        catch (SQLException e) {
            this._Log.error((Object)"SQL Exception in TopologyHandler.getDashboardTopology", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardTopologyVsanListDO getTopologyVsanList(DbFilterDO dbFilter) {
        DashboardTopologyVsanListDO vsanList;
        block28: {
            vsanList = new DashboardTopologyVsanListDO();
            HashMap<Long, DashboardTopologyVsanDO> map = new HashMap<Long, DashboardTopologyVsanDO>();
            HashMap<Long, ArrayList<Long>> switchMap = new HashMap<Long, ArrayList<Long>>();
            HashMap<Long, ArrayList<Long>> islMap = new HashMap<Long, ArrayList<Long>>();
            HashMap<Long, ArrayList<Long>> npvMap = new HashMap<Long, ArrayList<Long>>();
            if (NavigationUtil.getInstance().getCountEntitiesInGroup(dbFilter.getGroupFilterXml(), 0) > 0) {
                ResultSet rs;
                PreparedStatement stmt;
                block27: {
                    String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
                    Connection con = null;
                    stmt = null;
                    rs = null;
                    try {
                        con = ConnectionManager.getConnection();
                        if (groupFabricFilterSqlSuffix != null && groupFabricFilterSqlSuffix.length() > 0) {
                            int vsanId;
                            String vsanName;
                            DashboardTopologyVsanDO vsan;
                            long dbid;
                            String sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_VSANLIST_SWITCH");
                            stmt = con.prepareStatement(sql + groupFabricFilterSqlSuffix);
                            rs = SQLLoader.execute(stmt);
                            while (rs.next()) {
                                ArrayList<Long> switchList;
                                dbid = rs.getLong(3);
                                long switchId = rs.getLong(4);
                                vsan = (DashboardTopologyVsanDO)map.get(new Long(dbid));
                                if (vsan == null) {
                                    vsanName = rs.getString(1);
                                    vsanId = rs.getInt(2);
                                    vsan = new DashboardTopologyVsanDO();
                                    vsan.dbId = dbid;
                                    vsan.vsanId = vsanId;
                                    vsan.name = vsanName;
                                    map.put(new Long(dbid), vsan);
                                }
                                if ((switchList = (ArrayList<Long>)switchMap.get(new Long(dbid))) != null) {
                                    switchList.add(new Long(switchId));
                                    continue;
                                }
                                switchList = new ArrayList<Long>();
                                switchList.add(new Long(switchId));
                                switchMap.put(new Long(dbid), switchList);
                            }
                            rs.close();
                            stmt.close();
                            sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_VSANLIST_ISL");
                            stmt = con.prepareStatement(sql + groupFabricFilterSqlSuffix);
                            rs = SQLLoader.execute(stmt);
                            while (rs.next()) {
                                ArrayList<Long> islList;
                                dbid = rs.getLong(3);
                                long islId = rs.getLong(4);
                                vsan = (DashboardTopologyVsanDO)map.get(new Long(dbid));
                                if (vsan == null) {
                                    vsanName = rs.getString(1);
                                    vsanId = rs.getInt(2);
                                    vsan = new DashboardTopologyVsanDO();
                                    vsan.dbId = dbid;
                                    vsan.vsanId = vsanId;
                                    vsan.name = vsanName;
                                    map.put(new Long(dbid), vsan);
                                }
                                if ((islList = (ArrayList<Long>)islMap.get(new Long(dbid))) != null) {
                                    islList.add(new Long(islId));
                                    continue;
                                }
                                islList = new ArrayList<Long>();
                                islList.add(new Long(islId));
                                islMap.put(new Long(dbid), islList);
                            }
                            rs.close();
                            stmt.close();
                            sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_VSANLIST_NPV");
                            stmt = con.prepareStatement(sql + groupFabricFilterSqlSuffix);
                            rs = SQLLoader.execute(stmt);
                            while (rs.next()) {
                                ArrayList<Long> npvList;
                                dbid = rs.getLong(3);
                                long npvId = rs.getLong(4);
                                vsan = (DashboardTopologyVsanDO)map.get(new Long(dbid));
                                if (vsan == null) {
                                    vsanName = rs.getString(1);
                                    vsanId = rs.getInt(2);
                                    vsan = new DashboardTopologyVsanDO();
                                    vsan.dbId = dbid;
                                    vsan.vsanId = vsanId;
                                    vsan.name = vsanName;
                                    map.put(new Long(dbid), vsan);
                                }
                                if ((npvList = (ArrayList<Long>)npvMap.get(new Long(dbid))) != null) {
                                    npvList.add(new Long(npvId));
                                    continue;
                                }
                                npvList = new ArrayList<Long>();
                                npvList.add(new Long(npvId));
                                npvMap.put(new Long(dbid), npvList);
                            }
                            for (DashboardTopologyVsanDO vsan2 : map.values()) {
                                ArrayList npvList;
                                ArrayList islList;
                                ArrayList switchList = (ArrayList)switchMap.get(new Long(vsan2.dbId));
                                if (switchList != null && switchList.size() > 0) {
                                    long[] swList = new long[switchList.size()];
                                    int i = 0;
                                    for (Long n : switchList) {
                                        swList[i++] = n;
                                    }
                                    vsan2.switchDbIdList = swList;
                                }
                                if ((islList = (ArrayList)islMap.get(new Long(vsan2.dbId))) != null && islList.size() > 0) {
                                    long[] iList = new long[islList.size()];
                                    int j = 0;
                                    for (Long n : islList) {
                                        iList[j++] = n;
                                    }
                                    vsan2.islDbIdList = iList;
                                }
                                if ((npvList = (ArrayList)npvMap.get(new Long(vsan2.dbId))) == null || npvList.size() <= 0) continue;
                                long[] nList = new long[npvList.size()];
                                int k = 0;
                                for (Long n : npvList) {
                                    nList[k++] = n;
                                }
                                vsan2.npvDbIdList = nList;
                            }
                        }
                        vsanList.setVsanList(map.values().toArray(new DashboardTopologyVsanDO[map.values().size()]));
                        if (con == null) break block27;
                    }
                    catch (SQLException e) {
                        this._Log.error((Object)"SQL Exception in TopologyHandler.getTopologyVsanList", (Throwable)e);
                        break block28;
                    }
                    finally {
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                    }
                    DbUtil.close(con);
                }
                if (rs != null) {
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
            }
        }
        return vsanList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardTopologyVlanListDO getTopologyVlanList(DbFilterDO dbFilter) {
        DashboardTopologyVlanListDO vlanList = new DashboardTopologyVlanListDO();
        HashMap<Long, DashboardTopologyVlanDO> map = new HashMap<Long, DashboardTopologyVlanDO>();
        HashMap<Long, ArrayList<Long>> switchMap = new HashMap<Long, ArrayList<Long>>();
        HashMap<Long, ArrayList<Long>> islMap = new HashMap<Long, ArrayList<Long>>();
        if (NavigationUtil.getInstance().getCountEntitiesInGroup(dbFilter.getGroupFilterXml(), 1) > 0) {
            String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                if (groupLanFilterSqlSuffix != null && groupLanFilterSqlSuffix.length() > 0) {
                    int vlanId;
                    String vlanName;
                    DashboardTopologyVlanDO vlan;
                    long dbid;
                    String sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_VLANLIST_SWITCH");
                    stmt = con.prepareStatement(sql + " AND vs.ethswitch_id IN( " + groupLanFilterSqlSuffix + " )");
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        ArrayList<Long> switchList;
                        dbid = rs.getLong(3);
                        long switchId = rs.getLong(4);
                        vlan = (DashboardTopologyVlanDO)map.get(new Long(dbid));
                        if (vlan == null) {
                            vlanName = rs.getString(1);
                            vlanId = rs.getInt(2);
                            vlan = new DashboardTopologyVlanDO();
                            vlan.dbId = dbid;
                            vlan.vlanId = vlanId;
                            vlan.name = vlanName;
                            map.put(new Long(dbid), vlan);
                        }
                        if ((switchList = (ArrayList<Long>)switchMap.get(new Long(dbid))) != null) {
                            switchList.add(new Long(switchId));
                            continue;
                        }
                        switchList = new ArrayList<Long>();
                        switchList.add(new Long(switchId));
                        switchMap.put(new Long(dbid), switchList);
                    }
                    rs.close();
                    stmt.close();
                    sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_VLANLIST_ISL");
                    stmt = con.prepareStatement(sql + " AND vs.ethswitch_id  IN( " + groupLanFilterSqlSuffix + " )");
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        ArrayList<Long> islList;
                        dbid = rs.getLong(3);
                        long islId = rs.getLong(4);
                        vlan = (DashboardTopologyVlanDO)map.get(new Long(dbid));
                        if (vlan == null) {
                            vlanName = rs.getString(1);
                            vlanId = rs.getInt(2);
                            vlan = new DashboardTopologyVlanDO();
                            vlan.dbId = dbid;
                            vlan.vlanId = vlanId;
                            vlan.name = vlanName;
                            map.put(new Long(dbid), vlan);
                        }
                        if ((islList = (ArrayList<Long>)islMap.get(new Long(dbid))) != null) {
                            islList.add(new Long(islId));
                            continue;
                        }
                        islList = new ArrayList<Long>();
                        islList.add(new Long(islId));
                        islMap.put(new Long(dbid), islList);
                    }
                    for (DashboardTopologyVlanDO vlan2 : map.values()) {
                        ArrayList islList;
                        ArrayList switchList = (ArrayList)switchMap.get(new Long(vlan2.dbId));
                        if (switchList != null && switchList.size() > 0) {
                            long[] swList = new long[switchList.size()];
                            int i = 0;
                            for (Long n : switchList) {
                                swList[i++] = n;
                            }
                            vlan2.switchDbIdList = swList;
                        }
                        if ((islList = (ArrayList)islMap.get(new Long(vlan2.dbId))) == null || islList.size() <= 0) continue;
                        long[] iList = new long[islList.size()];
                        int j = 0;
                        for (Long n : islList) {
                            iList[j++] = n;
                        }
                        vlan2.islDbIdList = iList;
                    }
                }
                vlanList.setVlanList(map.values().toArray(new DashboardTopologyVlanDO[map.values().size()]));
            }
            catch (SQLException e) {
                this._Log.error((Object)"SQL Exception in TopologyHandler.getTopologyVlanList", (Throwable)e);
            }
            finally {
                if (con != null) {
                    DbUtil.close(con);
                }
                if (rs != null) {
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
            }
        }
        return vlanList;
    }

    private void setHiddenList(DashboardTopologyDO ft) {
        ArrayList<DashboardTopologyEdgeDO> hiddenList = new ArrayList<DashboardTopologyEdgeDO>();
        HashMap<Long, DashboardTopologyNodeDO> nodeMap = new HashMap<Long, DashboardTopologyNodeDO>();
        HashSet<DashboardTopologyNodeDO> freeNodes = new HashSet<DashboardTopologyNodeDO>();
        ArrayList graphList = new ArrayList();
        if (ft.getSwitchList() != null) {
            freeNodes.addAll(Arrays.asList(ft.getSwitchList()));
        }
        HashSet<DashboardTopologyEdgeDO> edges = new HashSet<DashboardTopologyEdgeDO>();
        if (ft.getIslList() != null) {
            edges.addAll(Arrays.asList(ft.getIslList()));
        }
        if (ft.getNpvList() != null) {
            edges.addAll(Arrays.asList(ft.getNpvList()));
        }
        for (DashboardTopologyNodeDO n : ft.getSwitchList()) {
            nodeMap.put(new Long(n.dbId), n);
        }
        for (DashboardTopologyNodeDO n : ft.getSwitchList()) {
            if (!freeNodes.contains(n)) continue;
            ArrayList<DashboardTopologyNodeDO> graph = new ArrayList<DashboardTopologyNodeDO>();
            graph.add(n);
            ArrayList<DashboardTopologyNodeDO> checkNodes = new ArrayList<DashboardTopologyNodeDO>();
            checkNodes.add(n);
            while (!checkNodes.isEmpty()) {
                DashboardTopologyNodeDO check = (DashboardTopologyNodeDO)checkNodes.remove(0);
                freeNodes.remove(check);
                Iterator edgeIt = edges.iterator();
                while (edgeIt.hasNext()) {
                    DashboardTopologyEdgeDO edge = (DashboardTopologyEdgeDO)edgeIt.next();
                    long partner = -1L;
                    if (edge.srcId == check.dbId) {
                        partner = edge.dstId;
                    } else if (edge.dstId == check.dbId) {
                        partner = edge.srcId;
                    }
                    if (partner <= -1L) continue;
                    edgeIt.remove();
                    DashboardTopologyNodeDO pNode = (DashboardTopologyNodeDO)nodeMap.get(partner);
                    if (graph.contains(pNode)) continue;
                    checkNodes.add(pNode);
                    graph.add(pNode);
                }
            }
            graphList.add(graph);
        }
        if (graphList.size() > 1) {
            DashboardTopologyNodeDO root = (DashboardTopologyNodeDO)((ArrayList)graphList.get(0)).get(0);
            for (int i = 1; i < graphList.size(); ++i) {
                DashboardTopologyNodeDO gRoot = (DashboardTopologyNodeDO)((ArrayList)graphList.get(i)).get(0);
                DashboardTopologyEdgeDO hidden = new DashboardTopologyEdgeDO();
                hidden.setEdgeType(2);
                hidden.source = root.name;
                hidden.dest = gRoot.name;
                hiddenList.add(hidden);
            }
        }
        ft.setHiddenList(hiddenList.toArray(new DashboardTopologyEdgeDO[hiddenList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DashboardTopologyNodeDO[] getSwitchList(Connection con, DbFilterDO dbFilter) throws SQLException {
        ArrayList<DashboardTopologyNodeDO> switchList = new ArrayList<DashboardTopologyNodeDO>();
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        if (groupFabricFilterSqlSuffix != null && groupFabricFilterSqlSuffix.length() > 0) {
            PreparedStatement stmt;
            block15: {
                stmt = null;
                ResultSet rs = null;
                try {
                    String sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_SWITCH_STMT");
                    stmt = con.prepareStatement(sql + groupFabricFilterSqlSuffix);
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        long npvId;
                        DashboardTopologyNodeDO ftn = new DashboardTopologyNodeDO();
                        String fabricName = rs.getString(1);
                        ftn.setGroupName(fabricName);
                        byte[] ipArray = rs.getBytes(5);
                        try {
                            ftn.setIp(InetAddress.getByAddress(ipArray).getHostAddress());
                        }
                        catch (UnknownHostException e) {
                            ftn.setIp("Unknown/Lookup-Error");
                        }
                        ftn.setModelName(rs.getString(9));
                        ftn.setName(rs.getString(10));
                        ftn.setVersion(rs.getString(17));
                        ftn.setNumPorts("" + rs.getInt(21));
                        ftn.setDbId(rs.getLong(22));
                        ftn.setCpu(rs.getInt(23));
                        ftn.setMem(rs.getInt(24));
                        long use = (long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 25));
                        if (ftn.getName() == null || ftn.getName().length() == 0) {
                            ftn.setName(ftn.getIp());
                        }
                        ftn.setBandwidth(use);
                        boolean isVdc = rs.getBoolean(26);
                        if (isVdc) {
                            ftn.setVdcId(rs.getLong(27));
                            ftn.setVdcMac(rs.getString(28));
                            ftn.setVdcName(rs.getString(29));
                            ftn.setVdcParentMac(rs.getString(30));
                        }
                        if ((npvId = rs.getLong(31)) > 0L) {
                            ftn.setNpv(true);
                        }
                        switchList.add(ftn);
                    }
                    if (rs == null) break block15;
                }
                catch (Exception ex) {
                    block16: {
                        try {
                            this._Log.error((Object)"Exception in TopologyHandler.getSwitchList", (Throwable)ex);
                            if (rs == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                DbUtil.close(rs);
                            }
                            if (stmt != null) {
                                DbUtil.close(stmt);
                            }
                            throw throwable;
                        }
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
        }
        return switchList.toArray(new DashboardTopologyNodeDO[switchList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DashboardTopologyEdgeDO[] getIslList(Connection con, DbFilterDO dbFilter) throws SQLException {
        PreparedStatement stmt;
        ArrayList<DashboardTopologyEdgeDO> islList;
        block20: {
            islList = new ArrayList<DashboardTopologyEdgeDO>();
            String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
            String sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_ISL_STMT");
            HashMap<String, DashboardTopologyEdgeDO> hmap = new HashMap<String, DashboardTopologyEdgeDO>();
            stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.prepareStatement(sql + groupFabricFilterSqlSuffix);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    DashboardTopologyIfPairDO[] ifList;
                    DashboardTopologyIfPairDO ifPair;
                    String src = rs.getString(1);
                    long srcId = rs.getLong(2);
                    long fid = rs.getLong(3);
                    long srcIfId = rs.getLong(5);
                    String dst = rs.getString(6);
                    long dstId = rs.getLong(7);
                    String srcdest = srcId + "-" + dstId;
                    String destsrc = dstId + "-" + srcId;
                    DashboardTopologyEdgeDO fte = (DashboardTopologyEdgeDO)hmap.get(srcdest);
                    if (fte == null) {
                        fte = (DashboardTopologyEdgeDO)hmap.get(destsrc);
                    }
                    if (fte == null) {
                        fte = new DashboardTopologyEdgeDO();
                        fte.setEdgeType(0);
                        fte.setSource(src);
                        fte.setDest(dst);
                        fte.setSrcId(srcId);
                        fte.setDstId(dstId);
                        fte.setSrcNId(fid);
                        fte.setType("ISL");
                        ifPair = new DashboardTopologyIfPairDO();
                        ifPair.setSource(src);
                        ifPair.setDest(dst);
                        ifPair.setSrcIf(rs.getString(4));
                        ifPair.setSrcIfId(srcIfId);
                        ifPair.setDestIf(rs.getString(8));
                        ifPair.setId(rs.getLong(10));
                        ifPair.setChannel(rs.getBoolean(11));
                        ifPair.setChannelId(rs.getLong(12));
                        ifPair.setSrcStat(rs.getInt(13));
                        ifPair.setDestStat(rs.getInt(14));
                        ifPair.setLabel("");
                        ifPair.setSpeed(this.formatSpeed(rs.getLong(9)));
                        ifPair.setCapacity(rs.getLong(9));
                        ifPair.setUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 15)));
                        ifPair.setRxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 16)));
                        ifPair.setTxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 17)));
                        if (!ifPair.isChannel()) {
                            fte.setCapacity(rs.getLong(9));
                            fte.setUtilization(ifPair.getUtilization());
                            fte.setRxUtilization(ifPair.getRxUtilization());
                            fte.setTxUtilization(ifPair.getTxUtilization());
                        }
                        ifList = new DashboardTopologyIfPairDO[]{ifPair};
                        fte.setIfList(ifList);
                        islList.add(fte);
                        hmap.put(srcdest, fte);
                        continue;
                    }
                    ifPair = new DashboardTopologyIfPairDO();
                    ifPair.setSource(src);
                    ifPair.setDest(dst);
                    ifPair.setSrcIf(rs.getString(4));
                    ifPair.setSrcIfId(srcIfId);
                    ifPair.setDestIf(rs.getString(8));
                    ifPair.setId(rs.getLong(10));
                    ifPair.setChannel(rs.getBoolean(11));
                    ifPair.setChannelId(rs.getLong(12));
                    ifPair.setSrcStat(rs.getInt(13));
                    ifPair.setDestStat(rs.getInt(14));
                    ifPair.setLabel("");
                    ifPair.setSpeed(this.formatSpeed(rs.getLong(9)));
                    ifPair.setCapacity(rs.getLong(9));
                    ifPair.setUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 15)));
                    ifPair.setRxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 16)));
                    ifPair.setTxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 17)));
                    ifList = new DashboardTopologyIfPairDO[fte.ifList.length + 1];
                    System.arraycopy(fte.ifList, 0, ifList, 0, fte.ifList.length);
                    ifList[fte.ifList.length] = ifPair;
                    if (!ifPair.isChannel()) {
                        fte.setCapacity(fte.getCapacity() + rs.getLong(9));
                        fte.setUtilization(fte.getUtilization() + ifPair.getUtilization());
                        fte.setRxUtilization(fte.getRxUtilization() + ifPair.getRxUtilization());
                        fte.setTxUtilization(fte.getTxUtilization() + ifPair.getTxUtilization());
                    }
                    fte.setIfList(ifList);
                }
                for (DashboardTopologyEdgeDO edge : islList) {
                    ArrayList<DashboardTopologyIfPairDO> pairList = new ArrayList<DashboardTopologyIfPairDO>(Arrays.asList(edge.ifList));
                    ArrayList<DashboardTopologyIfPairDO> orderedpairList = new ArrayList<DashboardTopologyIfPairDO>();
                    ArrayList<DashboardTopologyIfPairDO> channelList = new ArrayList<DashboardTopologyIfPairDO>();
                    ArrayList<DashboardTopologyIfPairDO> memberList = new ArrayList<DashboardTopologyIfPairDO>();
                    Iterator<DashboardTopologyIfPairDO> iter = pairList.iterator();
                    edge.setEdgeDown(true);
                    while (iter.hasNext()) {
                        DashboardTopologyIfPairDO ifpair = iter.next();
                        if (ifpair.getSrcStat() == 2 && ifpair.getDestStat() == 2) {
                            edge.setEdgeDown(false);
                        }
                        if (!ifpair.isChannel() && ifpair.channelId <= 0L) {
                            orderedpairList.add(ifpair);
                            iter.remove();
                            continue;
                        }
                        if (ifpair.isChannel()) {
                            channelList.add(ifpair);
                            iter.remove();
                            continue;
                        }
                        if (ifpair.getChannelId() <= 0L) continue;
                        memberList.add(ifpair);
                        iter.remove();
                    }
                    for (DashboardTopologyIfPairDO ifpair : channelList) {
                        orderedpairList.add(ifpair);
                        Iterator memiter = memberList.iterator();
                        while (memiter.hasNext()) {
                            DashboardTopologyIfPairDO mempair = (DashboardTopologyIfPairDO)memiter.next();
                            if (mempair.getChannelId() != ifpair.getId()) continue;
                            memiter.remove();
                            orderedpairList.add(mempair);
                        }
                    }
                    edge.setIfList(orderedpairList.toArray(edge.getIfList()));
                }
                if (rs == null) break block20;
            }
            catch (Exception ex) {
                block21: {
                    try {
                        this._Log.error((Object)"Exception in TopologyHandler.getIslList", (Throwable)ex);
                        if (rs == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        return islList.toArray(new DashboardTopologyEdgeDO[islList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private DashboardTopologyEdgeDO[] getNpvList(Connection con, DbFilterDO dbFilter) throws SQLException {
        block13: {
            islList = new ArrayList<DashboardTopologyEdgeDO>();
            groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
            sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_NPV_STMT");
            hmap = new HashMap<String, DashboardTopologyEdgeDO>();
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(sql + groupFabricFilterSqlSuffix);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    src = rs.getString(1);
                    srcId = rs.getLong(2);
                    fid = rs.getLong(3);
                    srcIfId = rs.getLong(5);
                    dst = rs.getString(6);
                    dstId = rs.getLong(7);
                    srcdest = srcId + "-" + dstId;
                    destsrc = dstId + "-" + srcId;
                    fte = (DashboardTopologyEdgeDO)hmap.get(srcdest);
                    if (fte == null) {
                        fte = (DashboardTopologyEdgeDO)hmap.get(destsrc);
                    }
                    if (fte == null) {
                        fte = new DashboardTopologyEdgeDO();
                        fte.setEdgeType(1);
                        fte.setSource(src);
                        fte.setSrcId(srcId);
                        fte.setSrcNId(fid);
                        fte.setDest(dst);
                        fte.setDstId(dstId);
                        fte.setType("NPV Link");
                        ifPair = new DashboardTopologyIfPairDO();
                        ifPair.setSource(src);
                        ifPair.setDest(dst);
                        ifPair.setSrcIf(rs.getString(4));
                        ifPair.setSrcIfId(srcIfId);
                        ifPair.setDestIf(rs.getString(8));
                        ifPair.setLabel("");
                        ifPair.setSpeed(this.formatSpeed(rs.getLong(9)));
                        ifPair.setCapacity(rs.getLong(9));
                        ifPair.setSrcStat(rs.getInt(10));
                        ifPair.setDestStat(rs.getInt(11));
                        ifPair.setId(rs.getLong(12));
                        ifPair.setUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 13)));
                        ifPair.setRxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 14)));
                        ifPair.setTxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 15)));
                        fte.setCapacity(rs.getLong(9));
                        fte.setUtilization(ifPair.getUtilization());
                        fte.setRxUtilization(ifPair.getRxUtilization());
                        fte.setTxUtilization(ifPair.getTxUtilization());
                        ifList = new DashboardTopologyIfPairDO[]{ifPair};
                        fte.setIfList(ifList);
                        islList.add(fte);
                        hmap.put(srcdest, fte);
                        continue;
                    }
                    ifPair = new DashboardTopologyIfPairDO();
                    ifPair.setSource(src);
                    ifPair.setDest(dst);
                    ifPair.setSrcIf(rs.getString(4));
                    ifPair.setDestIf(rs.getString(8));
                    ifPair.setLabel("");
                    ifPair.setSpeed(this.formatSpeed(rs.getLong(9)));
                    ifPair.setCapacity(rs.getLong(9));
                    ifPair.setSrcStat(rs.getInt(10));
                    ifPair.setDestStat(rs.getInt(11));
                    ifPair.setId(rs.getLong(12));
                    ifPair.setUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 13)));
                    ifPair.setRxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 14)));
                    ifPair.setTxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 15)));
                    fte.setCapacity(fte.getCapacity() + rs.getLong(9));
                    fte.setUtilization(fte.getUtilization() + ifPair.getUtilization());
                    fte.setRxUtilization(fte.getRxUtilization() + ifPair.getRxUtilization());
                    fte.setTxUtilization(fte.getTxUtilization() + ifPair.getTxUtilization());
                    ifList = new DashboardTopologyIfPairDO[fte.ifList.length + 1];
                    System.arraycopy(fte.ifList, 0, ifList, 0, fte.ifList.length);
                    ifList[fte.ifList.length] = ifPair;
                    fte.setIfList(ifList);
                }
                if (rs == null) break block13;
            }
            catch (Exception ex) {
                block14: {
                    try {
                        this._Log.error((Object)"Exception in TopologyHandler.getNpvList", (Throwable)ex);
                        if (rs == null) break block14;
                    }
                    catch (Throwable var24_23) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        throw var24_23;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                } else {
                    ** GOTO lbl101
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        for (DashboardTopologyEdgeDO edge : islList) {
            pairList = new ArrayList<DashboardTopologyIfPairDO>(Arrays.asList(edge.ifList));
            iter = pairList.iterator();
            edge.setEdgeDown(true);
            while (iter.hasNext()) {
                ifpair = iter.next();
                if (ifpair.getSrcStat() != 2 || ifpair.getDestStat() != 2) continue;
                edge.setEdgeDown(false);
            }
        }
        return islList.toArray(new DashboardTopologyEdgeDO[islList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DashboardTopologyNodeDO[] getEthSwitchList(Connection con, DbFilterDO dbFilter) throws SQLException {
        ArrayList<DashboardTopologyNodeDO> switchList;
        block14: {
            PreparedStatement stmt;
            block13: {
                switchList = new ArrayList<DashboardTopologyNodeDO>();
                String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
                stmt = null;
                ResultSet rs = null;
                try {
                    String sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_ETH_SWITCH_STMT");
                    stmt = con.prepareStatement(sql + " AND S.ID IN(" + groupLanFilterSqlSuffix + ")");
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        DashboardTopologyNodeDO ftn = new DashboardTopologyNodeDO();
                        String groupName = rs.getString(1);
                        byte[] ipArray = rs.getBytes(2);
                        try {
                            ftn.setIp(InetAddress.getByAddress(ipArray).getHostAddress());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ftn.setGroupName(groupName);
                        ftn.setModelName(rs.getString(3));
                        ftn.setName(rs.getString(4));
                        ftn.setVersion(rs.getString(5));
                        ftn.setNumPorts("" + rs.getInt(6));
                        ftn.setDbId(rs.getLong(7));
                        ftn.setCpu(rs.getInt(8));
                        ftn.setMem(rs.getInt(9));
                        boolean isVdc = rs.getBoolean(10);
                        if (isVdc) {
                            ftn.setVdcId(rs.getLong(11));
                            ftn.setVdcMac(rs.getString(12));
                            ftn.setVdcName(rs.getString(13));
                            byte[] parent = rs.getBytes(14);
                            if (parent != null && parent.length > 0) {
                                ftn.setVdcParentMac(new String(Hex.encodeHex((byte[])parent)));
                            }
                        }
                        ftn.setFex(rs.getBoolean(15));
                        switchList.add(ftn);
                    }
                    if (rs == null) break block13;
                }
                catch (Exception ex) {
                    this._Log.error((Object)"Exception in TopologyHandler.getEthSwitchList", (Throwable)ex);
                    break block14;
                }
                finally {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
        }
        return switchList.toArray(new DashboardTopologyNodeDO[switchList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DashboardTopologyEdgeDO[] getEthIslList(Connection con, DbFilterDO dbFilter) throws SQLException {
        ArrayList<DashboardTopologyEdgeDO> islList;
        block22: {
            PreparedStatement stmt;
            block21: {
                islList = new ArrayList<DashboardTopologyEdgeDO>();
                String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
                String sql = SQLLoader.getSql("DashboardFlex.TOPOLOGY_ETH_ISL_STMT");
                HashMap<String, DashboardTopologyEdgeDO> hmap = new HashMap<String, DashboardTopologyEdgeDO>();
                stmt = null;
                ResultSet rs = null;
                try {
                    stmt = con.prepareStatement(sql + " AND S1.ID IN (" + groupLanFilterSqlSuffix + ") AND S2.ID IN (" + groupLanFilterSqlSuffix + ")");
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        DashboardTopologyIfPairDO[] ifList;
                        DashboardTopologyIfPairDO ifPair;
                        String src = rs.getString(1);
                        long srcId = rs.getLong(2);
                        long lanid = rs.getLong(3);
                        long srcIfId = rs.getLong(5);
                        String dst = rs.getString(6);
                        long dstId = rs.getLong(7);
                        String srcdest = srcId + "-" + dstId;
                        String destsrc = dstId + "-" + srcId;
                        DashboardTopologyEdgeDO fte = (DashboardTopologyEdgeDO)hmap.get(srcdest);
                        if (fte == null) {
                            fte = (DashboardTopologyEdgeDO)hmap.get(destsrc);
                        }
                        if (fte == null) {
                            fte = new DashboardTopologyEdgeDO();
                            fte.setEdgeType(0);
                            fte.setSource(src);
                            fte.setSrcId(srcId);
                            fte.setSrcNId(lanid);
                            fte.setDest(dst);
                            fte.setDstId(dstId);
                            fte.setType("ISL");
                            ifPair = new DashboardTopologyIfPairDO();
                            ifPair.setSource(src);
                            ifPair.setDest(dst);
                            ifPair.setSrcIf(rs.getString(4));
                            ifPair.setSrcIfId(srcIfId);
                            ifPair.setDestIf(rs.getString(8));
                            ifPair.setLabel("");
                            ifPair.setSpeed(this.formatSpeed(rs.getLong(9)));
                            ifPair.setCapacity(rs.getLong(9));
                            ifPair.setUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 15)));
                            ifPair.setRxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 16)));
                            ifPair.setTxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 17)));
                            ifPair.setId(rs.getLong(10));
                            ifPair.setChannel(rs.getBoolean(11));
                            ifPair.setChannelId(rs.getLong(12));
                            ifPair.setSrcStat(rs.getInt(13));
                            ifPair.setDestStat(rs.getInt(14));
                            if (!ifPair.isChannel()) {
                                fte.setCapacity(rs.getLong(9));
                                fte.setUtilization(ifPair.getUtilization());
                                fte.setRxUtilization(ifPair.getRxUtilization());
                                fte.setTxUtilization(ifPair.getTxUtilization());
                            }
                            ifList = new DashboardTopologyIfPairDO[]{ifPair};
                            fte.setIfList(ifList);
                            islList.add(fte);
                            hmap.put(srcdest, fte);
                        } else {
                            ifPair = new DashboardTopologyIfPairDO();
                            ifPair.setSource(src);
                            ifPair.setDest(dst);
                            ifPair.setSrcIf(rs.getString(4));
                            ifPair.setSrcIfId(srcIfId);
                            ifPair.setDestIf(rs.getString(8));
                            ifPair.setLabel("");
                            ifPair.setSpeed(this.formatSpeed(rs.getLong(9)));
                            ifPair.setCapacity(rs.getLong(9));
                            ifPair.setUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 15)));
                            ifPair.setRxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 16)));
                            ifPair.setTxUtilization((long)DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 17)));
                            ifPair.setId(rs.getLong(10));
                            ifPair.setChannel(rs.getBoolean(11));
                            ifPair.setChannelId(rs.getLong(12));
                            ifPair.setSrcStat(rs.getInt(13));
                            ifPair.setDestStat(rs.getInt(14));
                            if (!ifPair.isChannel()) {
                                fte.setCapacity(fte.getCapacity() + rs.getLong(9));
                                fte.setUtilization(fte.getUtilization() + ifPair.getUtilization());
                                fte.setRxUtilization(fte.getRxUtilization() + ifPair.getRxUtilization());
                                fte.setTxUtilization(fte.getTxUtilization() + ifPair.getTxUtilization());
                            }
                            ifList = new DashboardTopologyIfPairDO[fte.ifList.length + 1];
                            System.arraycopy(fte.ifList, 0, ifList, 0, fte.ifList.length);
                            ifList[fte.ifList.length] = ifPair;
                            fte.setIfList(ifList);
                        }
                        boolean isFexS1 = rs.getBoolean(18);
                        boolean isFexS2 = rs.getBoolean(19);
                        if (!isFexS1 && !isFexS2) continue;
                        fte.setFex(true);
                    }
                    for (DashboardTopologyEdgeDO edge : islList) {
                        ArrayList<DashboardTopologyIfPairDO> pairList = new ArrayList<DashboardTopologyIfPairDO>(Arrays.asList(edge.ifList));
                        ArrayList<DashboardTopologyIfPairDO> orderedpairList = new ArrayList<DashboardTopologyIfPairDO>();
                        ArrayList<DashboardTopologyIfPairDO> channelList = new ArrayList<DashboardTopologyIfPairDO>();
                        ArrayList<DashboardTopologyIfPairDO> memberList = new ArrayList<DashboardTopologyIfPairDO>();
                        Iterator<DashboardTopologyIfPairDO> iter = pairList.iterator();
                        edge.setEdgeDown(true);
                        while (iter.hasNext()) {
                            DashboardTopologyIfPairDO ifpair = iter.next();
                            if (ifpair.getSrcStat() == 2 && ifpair.getDestStat() == 2) {
                                edge.setEdgeDown(false);
                            }
                            if (!ifpair.isChannel() && ifpair.channelId <= 0L) {
                                orderedpairList.add(ifpair);
                                iter.remove();
                                continue;
                            }
                            if (ifpair.isChannel()) {
                                channelList.add(ifpair);
                                iter.remove();
                                continue;
                            }
                            if (ifpair.getChannelId() <= 0L) continue;
                            memberList.add(ifpair);
                            iter.remove();
                        }
                        for (DashboardTopologyIfPairDO ifpair : channelList) {
                            orderedpairList.add(ifpair);
                            Iterator memiter = memberList.iterator();
                            while (memiter.hasNext()) {
                                DashboardTopologyIfPairDO mempair = (DashboardTopologyIfPairDO)memiter.next();
                                if (mempair.getChannelId() != ifpair.getId()) continue;
                                memiter.remove();
                                orderedpairList.add(mempair);
                            }
                        }
                        edge.setIfList(orderedpairList.toArray(edge.getIfList()));
                    }
                    if (rs == null) break block21;
                }
                catch (Exception ex) {
                    this._Log.error((Object)"Exception in TopologyHandler.getEthIslList", (Throwable)ex);
                    break block22;
                }
                finally {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
        }
        return islList.toArray(new DashboardTopologyEdgeDO[islList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTopologyNodes(String owner, String topologyName) {
        Connection con;
        ResultSet rs;
        PreparedStatement stmt;
        block12: {
            block13: {
                String string;
                block10: {
                    block11: {
                        String sql = "SELECT DATA FROM FLEX_DASHBOARD_TOPO_NODES WHERE USER_NAME=? AND VIEW_NAME=?";
                        stmt = null;
                        rs = null;
                        con = null;
                        try {
                            con = ConnectionManager.getConnection();
                            stmt = con.prepareStatement(sql);
                            stmt.setString(1, owner);
                            stmt.setString(2, topologyName);
                            rs = SQLLoader.execute(stmt);
                            if (rs.next()) {
                                String xml;
                                string = xml = rs.getString("DATA");
                                if (rs == null) break block10;
                                break block11;
                            }
                            if (rs == null) break block12;
                            break block13;
                        }
                        catch (Exception ex) {
                            this._Log.error((Object)"Exception in TopologyHandler.getTopologyNodes", (Throwable)ex);
                            return "";
                        }
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                DbUtil.close(con);
                return string;
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        DbUtil.close(con);
        return "";
        finally {
            if (rs != null) {
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatusDO setTopologyNodes(String owner, String topologyName, String nodesXml) {
        OperationStatusDO status;
        block14: {
            Connection con;
            PreparedStatement stmt2;
            PreparedStatement stmt1;
            block13: {
                String INSERT_STMT = "INSERT INTO FLEX_DASHBOARD_TOPO_NODES(USER_NAME, VIEW_NAME, DATA) VALUES(?,?,?) ";
                String DELETE_STMT = "DELETE FROM FLEX_DASHBOARD_TOPO_NODES WHERE USER_NAME = ? AND VIEW_NAME = ?";
                status = new OperationStatusDO();
                status.setStatus(false);
                if (!SQLLoader.canExecute()) {
                    return status;
                }
                stmt1 = null;
                stmt2 = null;
                ResultSet rs = null;
                con = null;
                try {
                    con = ConnectionManager.getConnection();
                    stmt1 = con.prepareStatement("DELETE FROM FLEX_DASHBOARD_TOPO_NODES WHERE USER_NAME = ? AND VIEW_NAME = ?");
                    stmt1.setString(1, owner);
                    stmt1.setString(2, topologyName);
                    int result = SQLLoader.executeUpdate(stmt1);
                    stmt2 = con.prepareStatement("INSERT INTO FLEX_DASHBOARD_TOPO_NODES(USER_NAME, VIEW_NAME, DATA) VALUES(?,?,?) ");
                    stmt2.setString(1, owner);
                    stmt2.setString(2, topologyName);
                    stmt2.setString(3, nodesXml);
                    int inres = SQLLoader.executeUpdate(stmt2);
                    status.setStatus(true);
                    if (rs == null) break block13;
                }
                catch (SQLException ex) {
                    this._Log.error((Object)"SQL Exception in TopologyHandler.setTopologyNodes ", (Throwable)ex);
                    break block14;
                }
                finally {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt1 != null) {
                        DbUtil.close(stmt1);
                    }
                    if (stmt2 != null) {
                        DbUtil.close(stmt2);
                    }
                    if (con != null) {
                        DbUtil.close(con);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt1 != null) {
                DbUtil.close(stmt1);
            }
            if (stmt2 != null) {
                DbUtil.close(stmt2);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return status;
    }

    public static void main(String[] args) {
        DashboardTopologyDO ft = new DashboardTopologyDO();
        ArrayList<DashboardTopologyNodeDO> nodes = new ArrayList<DashboardTopologyNodeDO>();
        ArrayList<DashboardTopologyEdgeDO> edges = new ArrayList<DashboardTopologyEdgeDO>();
        DashboardTopologyNodeDO n1 = new DashboardTopologyNodeDO();
        n1.name = "n1";
        nodes.add(n1);
        DashboardTopologyNodeDO n2 = new DashboardTopologyNodeDO();
        n2.name = "n2";
        nodes.add(n2);
        DashboardTopologyNodeDO n3 = new DashboardTopologyNodeDO();
        n3.name = "n3";
        nodes.add(n3);
        DashboardTopologyNodeDO n4 = new DashboardTopologyNodeDO();
        n4.name = "n4";
        nodes.add(n4);
        DashboardTopologyNodeDO n5 = new DashboardTopologyNodeDO();
        n5.name = "n5";
        nodes.add(n5);
        DashboardTopologyNodeDO n6 = new DashboardTopologyNodeDO();
        n6.name = "n6";
        nodes.add(n6);
        DashboardTopologyEdgeDO e1 = new DashboardTopologyEdgeDO();
        e1.source = n1.name;
        e1.dest = n5.name;
        edges.add(e1);
        DashboardTopologyEdgeDO e2 = new DashboardTopologyEdgeDO();
        e2.source = n3.name;
        e2.dest = n4.name;
        edges.add(e2);
        DashboardTopologyEdgeDO e3 = new DashboardTopologyEdgeDO();
        e3.source = n6.name;
        e3.dest = n5.name;
        edges.add(e3);
        ft.setIslList(edges.toArray(new DashboardTopologyEdgeDO[edges.size()]));
        ft.setSwitchList(nodes.toArray(new DashboardTopologyNodeDO[nodes.size()]));
        TopologyHandler.getInstance().setHiddenList(ft);
        if (ft.getHiddenList() != null) {
            System.out.println("HiddenEdges:");
            for (DashboardTopologyEdgeDO e : ft.getHiddenList()) {
                System.out.println("    " + e.source + " - " + e.dest);
            }
        } else {
            System.out.println("Failure, empty list");
        }
    }

    private String formatSpeed(long speed) {
        if (speed >= 0L) {
            return DefaultSnmpNumberRenderer.formatLong(speed, DefaultSnmpNumberRenderer.NUM_FORMAT_0_PREC) + "b";
        }
        return "n/a";
    }
}

