/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.PerfUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class EthIslStatHandler {
    private static EthIslStatHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private DateFormat _dateFormat;

    public static EthIslStatHandler getInstance() {
        if (_Instance == null) {
            _Instance = new EthIslStatHandler();
        }
        return _Instance;
    }

    private EthIslStatHandler() {
    }

    public String ifIndexToName(int index, int switchType) {
        if (FRUConstants.isN5K(switchType)) {
            return IfIndexUtil.ifIndexToNameForN5K(index, switchType);
        }
        switch (switchType) {
            case 601: {
                return IfIndexUtil.ifIndexToNameInagua(index);
            }
            case 606: 
            case 773: {
                return IfIndexUtil.ifIndexToNameChester(index);
            }
            case 843: {
                return IfIndexUtil.ifIndexToNameCassino(index);
            }
        }
        return IfIndexUtil.ifIndexToName(index);
    }

    public ArrayList<StatisticsDataDO> getEthIslStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        this.getEthIslStatList(records, dbFilter, interval, startIdx, recordSize, false);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEthIslStatList(ArrayList<StatisticsDataDO> records, DbFilterDO dbFilter, String interval, int startIdx, int recordSize, boolean lengthOnly) {
        String suffix = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval);
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            Hashtable info = new Hashtable();
            String sql = null;
            String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
            String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
            String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
            String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
            String errorCol = PerfUtil.getErrorIntervalColumn(interval);
            String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
            String totalCol = PerfUtil.getTotalIntervalColumn(interval);
            int[] indices = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
            String[] columns = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, totalCol};
            String prefix = "PerformanceAction.";
            String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
            if (groupLanFilterSqlSuffix != null && groupLanFilterSqlSuffix.length() > 0) {
                groupLanFilterSqlSuffix = " AND (S1.ID IN (" + groupLanFilterSqlSuffix + ") OR S2.ID IN (" + groupLanFilterSqlSuffix + "))";
            }
            sql = SQLLoader.getSql(prefix + "ISL_LAN_STMT", indices, columns);
            sql = sql + groupLanFilterSqlSuffix + suffix;
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            rs = SQLLoader.execute((PreparedStatement)stmt);
            if (lengthOnly) {
                rs.last();
                int n = rs.getRow();
                return n;
            }
            rs = SQLLoader.execute((PreparedStatement)stmt);
            Hashtable group = new Hashtable();
            ArrayList tpList = new ArrayList();
            ArrayList luList = new ArrayList();
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                long srcId = rs.getLong(2);
                long dstId = rs.getLong(3);
                double rx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                double tx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                double maxRx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                double maxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                double errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 8));
                double discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 9));
                long speed = rs.getLong(10) / 10L;
                long sourceId = rs.getLong(11);
                String xml = rs.getString(12);
                String rrd = rs.getString(13);
                String name = "Unknown";
                String src = rs.getString(14);
                byte[] srcWwn = rs.getBytes(15);
                String dst = rs.getString(16);
                byte[] dstWwn = rs.getBytes(17);
                double rxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 18));
                int paramType = rs.getInt(19);
                Timestamp lastUpdated = rs.getTimestamp(20);
                int switchType1 = rs.getInt(21);
                int switchType2 = rs.getInt(22);
                byte[] s1Wwn = rs.getBytes(23);
                byte[] s2Wwn = rs.getBytes(24);
                int chdrnCnt = rs.getInt(25);
                long fid = rs.getLong(26);
                int utzn = 0;
                ArrayList membersOf = (ArrayList)info.get(sourceId + "");
                StatisticsDataDO wrapper = null;
                boolean grouped = false;
                double tp = Double.isNaN(rxTx) ? 0.0 : rxTx;
                double util = tp == 0.0 ? 0.0 : tp / (double)(2L * speed) * 100.0;
                wrapper = new StatisticsDataDO(0L, 0L);
                int index1 = Integer.parseInt(src.substring(src.lastIndexOf(58) + 1).trim());
                src = src.substring(0, src.lastIndexOf(58)) + " " + this.ifIndexToName(index1, switchType1);
                int index2 = Integer.parseInt(dst.substring(dst.lastIndexOf(58) + 1).trim());
                dst = dst.substring(0, dst.lastIndexOf(58)) + " " + this.ifIndexToName(index2, switchType2);
                if (src != null) {
                    name = dst != null ? src + "<->" + dst : src;
                }
                wrapper.setRrdFile(rrd);
                wrapper.setPmtype(paramType);
                wrapper.setEntityName(name);
                wrapper.setFid(fid);
                wrapper.setChdCnt(chdrnCnt);
                wrapper.setDbId(sourceId);
                wrapper.setInterval(interval);
                if (chdrnCnt > 0) {
                    name = "<a href=\"/s313b.do?islId=" + sourceId + "&currentScreenID=s313b&interval=" + interval + "&islName=" + name + "\" target=\"_blank\">" + name + "</a>";
                }
                if (speed != 0L) {
                    utzn = Math.round(Math.round(rxTx) / (2L * speed) * 100L);
                }
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                if (grouped) {
                    speed = (long)((double)speed + wrapper.getSpeed());
                    rx += wrapper.getLastDayAvgRx();
                    tx += wrapper.getLastDayAvgTx();
                    maxRx += wrapper.getLastDayMaxRx();
                    maxTx += wrapper.getLastDayMaxTx();
                    errors += wrapper.getError();
                    discards += wrapper.getDiscard();
                    rxTx += wrapper.getLastDayAvgRx() + wrapper.getLastDayAvgTx();
                }
                wrapper.setTitle(name);
                wrapper.setFabric(fabric);
                wrapper.setSpeed(speed);
                wrapper.setLastDayAvgRx(rx);
                wrapper.setLastDayAvgTx(tx);
                wrapper.setLastDayMaxRx(maxRx);
                wrapper.setLastDayMaxTx(maxTx);
                wrapper.setError(errors);
                wrapper.setDiscard(discards);
                wrapper.setRxTx(rxTx);
                wrapper.setSpeedStr(DefaultSnmpNumberRenderer.formatLong(speed));
                if (speed == 0L) {
                    wrapper.setSpeedStr("n/a");
                }
                wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                wrapper.setIndex(curIdx + startIdx + 1);
                records.add(wrapper);
                if (++curIdx < recordSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            this._Log.error((Object)"failed to get isl stat", (Throwable)ex);
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
        }
        return 0;
    }

    public int getEthIslStatDataLength(DbFilterDO dbFilter, String interval) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        return this.getEthIslStatList(records, dbFilter, interval, 0, 1, true);
    }

    private String getSqlSortSuffix(String sortField, String sortType, String interval) {
        StringBuilder sortStr = new StringBuilder(" ORDER BY ");
        if (sortField.equals("avgRxStr")) {
            sortStr.append(PerfUtil.getAvgIntervalColumn(interval)).append("RX");
        } else if (sortField.equals("avgTxStr")) {
            sortStr.append(PerfUtil.getAvgIntervalColumn(interval)).append("TX");
        } else if (sortField.equals("maxRxStr")) {
            sortStr.append(PerfUtil.getMaxIntervalColumn(interval)).append("RX");
        } else if (sortField.equals("maxTxStr")) {
            sortStr.append(PerfUtil.getMaxIntervalColumn(interval)).append("TX");
        } else if (sortField.equals("errorStr")) {
            sortStr.append(PerfUtil.getErrorIntervalColumn(interval));
        } else if (sortField.equals("discardStr")) {
            sortStr.append(PerfUtil.getDiscardIntervalColumn(interval));
        } else if (sortField.equals("rxTxStr")) {
            sortStr.append(PerfUtil.getTotalIntervalColumn(interval));
        } else if (sortField.equals("speedStr")) {
            sortStr.append("SP1.IF_SPEED");
        } else {
            sortStr.append(PerfUtil.getTotalIntervalColumn(interval));
        }
        if (sortType == null || sortType.trim().length() == 0) {
            sortType = "DESC";
        }
        return sortStr.toString();
    }

    private DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return this._dateFormat;
    }
}

