/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import com.cisco.dcbu.jaxws.san.wo.IslDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.sm.server.web.util.WebUtil;
import com.cisco.dcbu.web.client.util.LogService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class IslHandler {
    private static IslHandler _Instance = null;
    public static final int CONN_UNIT_WARNING = 4;
    private Logger _Log = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();
    private Map<String, String> _FilterHash = new HashMap<String, String>();
    private int sanDataLength;
    private int lanDataLength;

    public static IslHandler getInstance() {
        if (_Instance == null) {
            _Instance = new IslHandler();
        }
        return _Instance;
    }

    private IslHandler() {
        this.initSqlSortSuffix();
        this.sanDataLength = 0;
        this.lanDataLength = 0;
    }

    public int getIslDataLength(DbFilterDO dbFilter, String swStatus) {
        String colFilterSqlSuffix;
        int totalLength = 0;
        if (dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("SAN")) {
            this.sanDataLength = this.getSanIslDataLength(dbFilter, swStatus);
            totalLength += this.sanDataLength;
        }
        if ((dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("LAN")) && (colFilterSqlSuffix = WebUtil.getColFilterSql(dbFilter.getColFilterStr(), this._FilterHash)).length() < 1) {
            this.lanDataLength = this.getLanIslDataLength(dbFilter, swStatus);
            totalLength += this.lanDataLength;
        }
        return totalLength;
    }

    public ArrayList<IslDO> getIslList(DbFilterDO dbFilter, String swStatus, int startIdx, int recordSize) {
        String networkType = dbFilter.getNetworkType();
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField()) + dbFilter.getSortType();
        ArrayList<IslDO> totalList = new ArrayList<IslDO>();
        int sanStartIdx = 0;
        int lanStartIdx = 0;
        int sanRecordSize = 0;
        int lanRecordSize = 0;
        if (networkType != null && networkType.equals("Data Center")) {
            if (startIdx < this.sanDataLength) {
                sanStartIdx = startIdx;
                int retrieveSize = sanStartIdx + recordSize;
                if (retrieveSize < this.sanDataLength) {
                    sanRecordSize = recordSize;
                } else {
                    sanRecordSize = this.sanDataLength - sanStartIdx;
                    lanRecordSize = recordSize - sanRecordSize;
                    lanStartIdx = 0;
                }
            } else {
                sanStartIdx = this.sanDataLength;
                sanRecordSize = 0;
                lanStartIdx = startIdx - this.sanDataLength;
                lanRecordSize = recordSize;
            }
        } else {
            sanStartIdx = lanStartIdx = startIdx;
            sanRecordSize = lanRecordSize = recordSize;
        }
        if (networkType != null && (networkType.equals("SAN") || networkType.equals("Data Center"))) {
            totalList.addAll(this.getSanIslList(dbFilter, swStatus, sanStartIdx, sanRecordSize, sortSqlSuffix));
        }
        if (networkType != null && (networkType.equals("LAN") || networkType.equals("Data Center"))) {
            String colFilterSqlSuffix;
            String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
            if (groupLanFilterSqlSuffix != null && groupLanFilterSqlSuffix.length() > 0) {
                groupLanFilterSqlSuffix = " AND (S1.ID IN (" + groupLanFilterSqlSuffix + ") OR S2.ID IN (" + groupLanFilterSqlSuffix + "))";
            }
            if ((colFilterSqlSuffix = WebUtil.getColFilterSql(dbFilter.getColFilterStr(), this._FilterHash)).length() < 1) {
                totalList.addAll(this.getLanIslList(lanStartIdx, swStatus, lanRecordSize, groupLanFilterSqlSuffix + sortSqlSuffix, networkType.equals("LAN")));
            }
        }
        return totalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IslDO> getLanIslList(int startIdx, String swStatus, int recordSize, String sortSql, boolean lanOnly) {
        ArrayList<IslDO> lanList;
        block16: {
            lanList = new ArrayList<IslDO>();
            String testSql = "SELECT\tS1.ID, S1.SYS_NAME,  SP1.IF_NAME, S2.ID, S2.SYS_NAME, SP2.IF_NAME, ISL.OPER_MODE, ISL.ID, ISL.IS_PRESENT, ISL.LAST_SCAN_TIME, SP1.IF_SPEED, SP2.IF_SPEED, SP1.ID, SP2.ID FROM   \tETHSWITCH S1, ETHSWITCH_PORT SP1, ETHSWITCH S2, ETHSWITCH_PORT SP2, ETHISL ISL WHERE (S1.ID = SP1.SWITCH_ID) AND (SP1.ID = ISL.PORT1_ID) AND (S2.ID = SP2.SWITCH_ID) AND (SP2.ID = ISL.PORT2_ID)";
            Connection con = null;
            PreparedStatement stmt = null;
            String sql = testSql;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                Hashtable info = IslHandler.getVlanIslInfo();
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSql, 1004, 1007);
                rs = SQLLoader.execute(stmt);
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    long speed2;
                    long s1Id = rs.getLong(1);
                    String fromSwitch = rs.getString(2);
                    String fromInterface = rs.getString(3);
                    long s2Id = rs.getLong(4);
                    String toSwitch = rs.getString(5);
                    String toInterface = rs.getString(6);
                    int operMode = rs.getInt(7);
                    long islId = rs.getLong(8);
                    boolean isPresent = rs.getBoolean(9);
                    long lastScanTime = rs.getLong(10);
                    long speed1 = rs.getLong(11);
                    long speed = speed1 < (speed2 = rs.getLong(12)) ? speed1 : speed2;
                    long sp1Id = rs.getLong(13);
                    long sp2Id = rs.getLong(14);
                    if (speed <= 0L) {
                        speed = speed1 > 0L ? speed1 : speed2;
                    }
                    ArrayList vlans = (ArrayList)info.get(islId + "");
                    IslDO wrapper = new IslDO();
                    wrapper.setNetwork("LAN");
                    String groupName1 = null;
                    String groupName2 = null;
                    groupName1 = NavigationUtil.getInstance().getGroupNameByLanSw(s1Id);
                    groupName2 = NavigationUtil.getInstance().getGroupNameByLanSw(s2Id);
                    if (groupName1 != null && groupName2 != null) {
                        if (groupName1.equalsIgnoreCase(groupName2)) {
                            wrapper.setFabricName(groupName1);
                        } else {
                            wrapper.setFabricName(groupName1 + "<->" + groupName2);
                        }
                    } else if (groupName1 == null) {
                        wrapper.setFabricName(groupName2);
                    } else {
                        wrapper.setFabricName(groupName1);
                    }
                    wrapper.setVsanStr(IslHandler.convertArrayListToString(vlans, ","));
                    wrapper.setFromSwitch(fromSwitch);
                    wrapper.setFromInterface(fromInterface);
                    wrapper.setToSwitch(toSwitch);
                    wrapper.setToInterface(toInterface);
                    wrapper.setSw1Id(s1Id);
                    wrapper.setSw2Id(s2Id);
                    wrapper.setStatus(DisplayUtil.getEthIslOperStatusCause(operMode, isPresent, lastScanTime));
                    if (speed <= 0L) {
                        wrapper.setSpeedStr("n/a");
                    } else {
                        wrapper.setSpeedStr(DisplayUtil.formatSpeed(speed));
                    }
                    wrapper.setIndex(curIdx + startIdx + 1 + (lanOnly ? 0 : this.sanDataLength));
                    wrapper.setupMapping();
                    wrapper.setSwitchPort1Id(sp1Id);
                    wrapper.setSwitchPort2Id(sp2Id);
                    if (!SQLLoader.isKeywordPresent(wrapper.getStatus(), swStatus)) continue;
                    lanList.add(wrapper);
                    if (++curIdx < recordSize || swStatus != null && (swStatus == null || swStatus.equalsIgnoreCase("Warning"))) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                LogService.log(LogService._SEVERE, ex);
                break block16;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return lanList;
    }

    public int getLanIslDataLength(DbFilterDO dbFilter, String swStatus) {
        ArrayList<IslDO> list;
        String networkType = dbFilter.getNetworkType();
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField()) + dbFilter.getSortType();
        String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
        if (groupLanFilterSqlSuffix != null && groupLanFilterSqlSuffix.length() > 0) {
            groupLanFilterSqlSuffix = " AND (S1.ID IN (" + groupLanFilterSqlSuffix + ") OR S2.ID IN (" + groupLanFilterSqlSuffix + "))";
        }
        if ((list = this.getLanIslList(0, swStatus, Integer.MAX_VALUE, sortSqlSuffix = groupLanFilterSqlSuffix + (sortSqlSuffix == null ? "" : sortSqlSuffix), networkType.equals("LAN"))) != null) {
            return list.size();
        }
        return 0;
    }

    public ArrayList<IslDO> getSanIslList(DbFilterDO dbFilter, String swStatus, int startIdx, int recordSize, String sortSqlSuffix) {
        long vsanDbId = dbFilter.getVsanDbId();
        long fabricDbId = dbFilter.getFabricDbId();
        long groupDbId = dbFilter.getGroupId();
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String colFilterSqlSuffix = WebUtil.getColFilterSql(dbFilter.getColFilterStr(), this._FilterHash);
        return this.getSanIslList(vsanDbId, fabricDbId, groupDbId, swStatus, startIdx, recordSize, groupFabricFilterSqlSuffix + colFilterSqlSuffix + sortSqlSuffix);
    }

    public ArrayList<IslDO> getIslList(long islDbId) {
        ArrayList<IslDO> lanList;
        String sqlSuffix = " AND ISL.ID =" + islDbId;
        ArrayList<IslDO> resultList = new ArrayList<IslDO>();
        ArrayList<IslDO> sanList = this.getSanIslList(-1L, -1L, -1L, "All", 0, 31, sqlSuffix);
        if (sanList.size() > 0) {
            resultList.add(sanList.get(0));
        }
        if ((lanList = this.getLanIslList(0, "All", 31, sqlSuffix, true)).size() > 0) {
            resultList.add(lanList.get(0));
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IslDO> getSanIslList(long vsanDbId, long fabricDbId, long groupDbId, String swStatus, int startIdx, int recordSize, String sqlSuffix) {
        ArrayList<IslDO> resultList;
        block14: {
            resultList = new ArrayList<IslDO>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                con = ConnectionManager.getConnection();
                Hashtable info = IslHandler.getVsanIslInfo();
                if (vsanDbId != -1L) {
                    sql = SQLLoader.getSqlStmt("ISLAction.ISL_VSAN_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                    stmt.setLong(1, fabricDbId);
                    stmt.setLong(2, vsanDbId);
                } else if (fabricDbId >= 0L) {
                    if (groupDbId != -1L) {
                        sql = SQLLoader.getSqlStmt("ISLAction.ISL_GROUP_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                        stmt.setLong(1, groupDbId);
                        stmt.setLong(2, groupDbId);
                    } else {
                        sql = SQLLoader.getSqlStmt("ISLAction.ISL_FABRIC_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                        stmt.setLong(1, fabricDbId);
                    }
                } else {
                    sql = SQLLoader.getSqlStmt("ISLAction.ISL_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                }
                rs = SQLLoader.execute(stmt);
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    long speed2;
                    String fabric = rs.getString(1);
                    String srcSwitch = rs.getString(2);
                    int srcInterfaceIndex = rs.getInt(3);
                    String dstSwitch = rs.getString(4);
                    int dstInterfaceIndex = rs.getInt(5);
                    int operStatusCause = rs.getInt(6);
                    long islId = rs.getLong(7);
                    boolean isPresent = rs.getBoolean(8);
                    int configChildCount = rs.getInt(9);
                    int currentChildCount = rs.getInt(10);
                    long lastScanTime = rs.getLong(11);
                    long speed1 = rs.getLong(12);
                    long speed = speed1 < (speed2 = rs.getLong(13)) ? speed1 : speed2;
                    int switchType1 = rs.getInt(14);
                    int switchType2 = rs.getInt(15);
                    String src_dispalyName = rs.getString(16);
                    String des_dispalyName = rs.getString(17);
                    byte[] wwn1 = rs.getBytes(18);
                    byte[] wwn2 = rs.getBytes(19);
                    long sw1Id = rs.getLong(20);
                    long sw2Id = rs.getLong(21);
                    long sp1Id = rs.getLong(22);
                    long sp2Id = rs.getLong(23);
                    if (speed <= 0L) {
                        speed = speed1 > 0L ? speed1 : speed2;
                    }
                    ArrayList vsans = (ArrayList)info.get(islId + "");
                    IslDO islDo = new IslDO();
                    islDo.setFabricName(fabric);
                    islDo.setVsanStr(IslHandler.convertArrayListToString(vsans, ","));
                    islDo.setNetwork("SAN");
                    islDo.setFromSwitch(srcSwitch);
                    islDo.setFromInterface(src_dispalyName);
                    islDo.setToSwitch(dstSwitch);
                    islDo.setToInterface(des_dispalyName);
                    islDo.setSpeedStr(speed <= 0L ? "n/a" : DisplayUtil.formatSpeed(speed));
                    islDo.setSpeed(speed);
                    islDo.setStatus(DisplayUtil.getIslOperStatusCause(operStatusCause, isPresent, configChildCount, currentChildCount, lastScanTime));
                    islDo.setIndex(curIdx + startIdx + 1);
                    islDo.setupMapping();
                    islDo.setSw1Wwn(new WwnDO(wwn1));
                    islDo.setSw2Wwn(new WwnDO(wwn2));
                    islDo.setSw1Id(sw1Id);
                    islDo.setSw2Id(sw2Id);
                    islDo.setSwitchPort1Id(sp1Id);
                    islDo.setSwitchPort2Id(sp2Id);
                    islDo.setFromInterfaceIndex(srcInterfaceIndex);
                    islDo.setToInterfaceIndex(dstInterfaceIndex);
                    if (!SQLLoader.isKeywordPresent(islDo.getStatus(), swStatus)) continue;
                    resultList.add(islDo);
                    if (++curIdx < recordSize || swStatus != null && (swStatus == null || swStatus.equalsIgnoreCase("Warning"))) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block14;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return resultList;
    }

    public int getSanIslDataLength(DbFilterDO dbFilter, String swStatus) {
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField());
        sortSqlSuffix = sortSqlSuffix == null ? "" : sortSqlSuffix + dbFilter.getSortType();
        ArrayList<IslDO> list = this.getSanIslList(dbFilter, swStatus, 0, Integer.MAX_VALUE, sortSqlSuffix);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getVlanIslInfo() throws Exception {
        Hashtable<String, ArrayList> info = new Hashtable<String, ArrayList>();
        if (!SQLLoader.canExecute()) {
            return info;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = SQLLoader.getSqlStmt("PerformanceAction.ISL_LAN_INFO_STMT");
            stmt = con.prepareStatement(sql);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                long islId = rs.getLong(1);
                long vlanId = rs.getLong(2);
                String strIslId = islId + "";
                String strVlanId = vlanId + "";
                if (info.get(strIslId) == null) {
                    info.put(strIslId, new ArrayList());
                }
                ArrayList belongsTo = (ArrayList)info.get(strIslId);
                belongsTo.add(strVlanId);
                info.put(strIslId, belongsTo);
            }
        }
        catch (SQLException ex) {
            try {
                LogService.log(LogService._SEVERE, ex);
            }
            catch (Throwable throwable) {
                ConnectionManager.returnConnection(con);
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        ConnectionManager.returnConnection(con);
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<Long, ArrayList<Integer>> getVsanNPVLInfo() throws Exception {
        HashMap<Long, ArrayList<Integer>> info = new HashMap<Long, ArrayList<Integer>>();
        if (!SQLLoader.canExecute()) {
            return info;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = SQLLoader.getSqlStmt("NpvLinkAction.NPVL_VSAN_STMT");
            stmt = con.prepareStatement(sql);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                Long linkId = rs.getLong(1);
                Integer vsanId = rs.getInt(2);
                if (!info.containsKey(linkId)) {
                    info.put(linkId, new ArrayList());
                }
                ArrayList<Integer> belongsTo = info.get(linkId);
                belongsTo.add(vsanId);
                info.put(linkId, belongsTo);
            }
        }
        catch (SQLException ex) {
            try {
                LogService.log(LogService._SEVERE, ex);
            }
            catch (Throwable throwable) {
                ConnectionManager.returnConnection(con);
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        ConnectionManager.returnConnection(con);
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getVsanIslInfo() throws Exception {
        Hashtable<String, ArrayList> info = new Hashtable<String, ArrayList>();
        if (!SQLLoader.canExecute()) {
            return info;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = SQLLoader.getSqlStmt("ISLAction.ISL_SUB_STMT");
            stmt = con.prepareStatement(sql);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                long islId = rs.getLong(1);
                long vsanId = rs.getLong(2);
                String strIslId = islId + "";
                String strVsanId = vsanId + "";
                if (info.get(strIslId) == null) {
                    info.put(strIslId, new ArrayList());
                }
                ArrayList belongsTo = (ArrayList)info.get(strIslId);
                belongsTo.add(strVsanId);
                info.put(strIslId, belongsTo);
            }
        }
        catch (SQLException ex) {
            try {
                LogService.log(LogService._SEVERE, ex);
            }
            catch (Throwable throwable) {
                ConnectionManager.returnConnection(con);
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        ConnectionManager.returnConnection(con);
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return info;
    }

    public static String convertArrayListToString(ArrayList list, String sep) {
        StringBuffer result = new StringBuffer();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size() - 1; ++i) {
                result.append(list.get(i) + sep);
            }
            result.append(list.get(list.size() - 1));
        }
        return result.toString();
    }

    private void initSqlSortSuffix() {
        this._Name2SqlHash.put("displayName", " ORDER BY S1.SYS_NAME ");
        this._Name2SqlHash.put("Name", " ORDER BY S1.SYS_NAME ");
        this._Name2SqlHash.put("fromSwitch", " ORDER BY S1.SYS_NAME ");
        this._Name2SqlHash.put("toSwitch", " ORDER BY S2.SYS_NAME ");
    }

    public static void main(String[] args) {
        DbFilterDO dbFilter = new DbFilterDO();
        dbFilter.setSortField("Name");
        dbFilter.setSortType("ASC");
        IslHandler.getInstance().getIslDataLength(dbFilter, "All");
        ArrayList<IslDO> rstList = IslHandler.getInstance().getIslList(dbFilter, "All", 0, 31);
        boolean i = false;
    }

    public String printIslTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<IslDO> rstList = IslHandler.getInstance().getIslList(dbFilter, status, startIdx, recordSize);
        return JasperPrintGenerator.getInstance().generatePrintReport("ISLs", columnHeader, rstList);
    }

    public String exportIslTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<IslDO> rstList = IslHandler.getInstance().getIslList(dbFilter, status, startIdx, recordSize);
        return JasperPrintGenerator.getInstance().generateExcelReport("ISLs", columnHeader, rstList);
    }
}

