/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import com.cisco.dcbu.jaxws.san.wo.ModuleDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ModuleHandler {
    private static ModuleHandler _Instance = null;
    private Logger _Logger = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();

    public static ModuleHandler getInstance() {
        if (_Instance == null) {
            _Instance = new ModuleHandler();
        }
        return _Instance;
    }

    ModuleHandler() {
        this._Name2SqlHash.put("sw", "SYS_NAME ");
        this._Name2SqlHash.put("name", "MODEL_NAME ");
        this._Name2SqlHash.put("network", "NETWORK_NAME");
        this._Name2SqlHash.put("sysName", "SYS_NAME");
        this._Name2SqlHash.put("modelName", "HW_NAME");
    }

    public DBEntryDO getList(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String groupLanFilterSQLSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
        return this.getList(dbFilter.getNetworkType(), dbFilter.getFabricDbId(), dbFilter.getVsanDbId(), dbFilter.isGroup(), startIdx, recordSize, status, sortSqlSuffix, groupFabricFilterSqlSuffix, groupLanFilterSQLSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getListBySwitch(DbFilterDO dbFilter) throws Exception {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"Index", "Network", "Fabric", "Switch", "Name", "ModelName", "SerialNum", "2nd SerialNum", "Type", "Slot", "Hardware Revision", "Software Revision", "AssetID", "operStatus", "SwitchID", "isLAN"});
        Connection con = null;
        PreparedStatement stmt = null;
        String sql = null;
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        int curIdx = 0;
        long switchId = dbFilter.getSwitchDbId();
        String networkType = dbFilter.getNetworkType();
        try {
            con = ConnectionManager.getConnection();
            if ("SAN".equals(networkType)) {
                sql = SQLLoader.getSql("ModuleAction.SAN_MODULE_BY_SWITCH_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, switchId);
            } else if ("LAN".equals(networkType)) {
                sql = SQLLoader.getSql("ModuleAction.LAN_MODULE_BY_SWITCH_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, switchId);
            }
            try {
                this.executeQuery(0, -1, "All", stmt, rList, curIdx);
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(stmt);
            dto.setRow(rList.toArray(new DBRowDO[0]));
        }
        catch (SQLException ex) {
            this._Logger.error((Object)ex);
            throw ex;
        }
        finally {
            ConnectionManager.returnConnection(con);
        }
        return dto;
    }

    public DBEntryDO getList(String networkType, long fDbId, long vsanId, boolean isGroup, int startIdx, int recordSize, String statusFilter, String sortSqlSuffix) throws Exception {
        return this.getList(networkType, fDbId, vsanId, isGroup, startIdx, recordSize, statusFilter, sortSqlSuffix, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getList(String networkType, long fDbId, long vsanId, boolean isGroup, int startIdx, int recordSize, String statusFilter, String sortSqlSuffix, String sanFilterSuffix, String lanFilterSuffix) throws Exception {
        String sortSuffix = sortSqlSuffix;
        sortSuffix = sortSuffix == null ? "SYS_NAME ASC, HW_COMPONENT.RELATIVE_POSITION ASC" : sortSuffix + ", HW_COMPONENT.RELATIVE_POSITION ASC";
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"Index", "Network", "Group", "Switch", "Name", "ModelName", "SerialNum", "2nd SerialNum", "Type", "Slot", "Hardware Revision", "Software Revision", "AssetID", "OperStatus", "SwitchID", "isLAN"});
        Connection con = null;
        PreparedStatement stmt = null;
        String sql = null;
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        int curIdx = 0;
        try {
            con = ConnectionManager.getConnection();
            if (vsanId != -1L) {
                sql = SQLLoader.getSql("ModuleAction.MODULE_VSAN_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + (sortSuffix != null ? ", " + sortSuffix : ""), 1004, 1007);
                stmt.setLong(1, fDbId);
                stmt.setLong(2, vsanId);
            } else if (fDbId != -1L) {
                if (isGroup) {
                    sql = SQLLoader.getSql("ModuleAction.MODULE_GROUP_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + (sortSuffix != null ? ", " + sortSuffix : ""), 1004, 1007);
                    stmt.setLong(1, fDbId);
                } else {
                    sql = SQLLoader.getSql("ModuleAction.MODULE_FABRIC_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + (sortSuffix != null ? ", " + sortSuffix : ""), 1004, 1007);
                    stmt.setLong(1, fDbId);
                }
            } else if ("SAN".equals(networkType)) {
                sql = SQLLoader.getSql("ModuleAction.SAN_MODULE_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + (sortSuffix != null ? ", " + sortSuffix : ""), 1004, 1007);
            } else if ("LAN".equals(networkType)) {
                sql = SQLLoader.getSql("ModuleAction.LAN_MODULE_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + (sortSuffix != null ? ", " + sortSuffix : ""), 1004, 1007);
            } else {
                String defaultSort = "NETWORK_NAME ASC, SYS_NAME ASC, RELATIVE_POSITION ASC";
                String suffix = "";
                suffix = sortSqlSuffix == null ? " ORDER BY " + defaultSort : " ORDER BY " + sortSqlSuffix + ", " + defaultSort;
                String sqlSAN = SQLLoader.getSql("ModuleAction.NEW_GROUP_SAN_MODULE_STMT") + sanFilterSuffix;
                String sqlLAN = SQLLoader.getSql("ModuleAction.NEW_GROUP_LAN_MODULE_STMT") + lanFilterSuffix;
                sql = "(" + sqlSAN + ") UNION (" + sqlLAN + ")";
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + suffix, 1004, 1007);
            }
            try {
                this.executeQuery(startIdx, recordSize, statusFilter, stmt, rList, curIdx);
            }
            finally {
                DbUtil.close(stmt);
            }
            dto.setRow(rList.toArray(new DBRowDO[0]));
        }
        catch (SQLException ex) {
            this._Logger.error((Object)ex);
            throw ex;
        }
        finally {
            ConnectionManager.returnConnection(con);
        }
        return dto;
    }

    private int executeQuery(int startIdx, int recordSize, String statusFilter, PreparedStatement stmt, List<DBRowDO> rList, int curIdx) throws SQLException {
        ResultSet rs = null;
        if (recordSize > 0 && curIdx > 0 && curIdx >= recordSize) {
            return curIdx;
        }
        try {
            rs = SQLLoader.execute(stmt);
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            boolean getAllForWarning = false;
            while (rs.next()) {
                DBRowDO row = new DBRowDO();
                String fabric = rs.getString(1);
                String switchName = rs.getString(2);
                String moduleName = rs.getString(3);
                String cardStatus = rs.getString(4);
                String hwType = rs.getString(5);
                String hwVersion = rs.getString(6);
                String swVersion = rs.getString(7);
                String serialNumber = rs.getString(8);
                String assetId = rs.getString(9);
                String detailName = rs.getString(10);
                boolean isSwitchPresent = rs.getBoolean(11);
                long switchLastScanTime = rs.getLong(12);
                int slotNumber = rs.getInt(13);
                String secSerialNumber = rs.getString(14);
                long switchId = rs.getLong(15);
                int isLan = rs.getInt(16);
                String network = "LAN";
                network = isLan == 1 ? "LAN" : "SAN";
                String index = curIdx + startIdx + 1 + "";
                String hardwareType = HwInventoryType.getType(Integer.parseInt(hwType)).toString();
                String slot = "";
                if ("9".equals(hwType)) {
                    slot = slotNumber + "";
                }
                String[] data = new String[]{index, network, fabric, switchName, detailName, moduleName, serialNumber, secSerialNumber == null ? "" : secSerialNumber, hardwareType, slot, hwVersion, swVersion, assetId, cardStatus, switchId + "", isLan + ""};
                row.setEntry(data);
                if (statusFilter == null || statusFilter.equals("All")) {
                    rList.add(row);
                    ++curIdx;
                } else if (SQLLoader.isKeywordPresent(cardStatus, statusFilter)) {
                    rList.add(row);
                    ++curIdx;
                    getAllForWarning = true;
                }
                if (getAllForWarning || recordSize <= 0 || curIdx <= 0 || curIdx < recordSize) continue;
                break;
            }
        }
        catch (SQLException ex) {
            this._Logger.error((Object)ex);
            throw ex;
        }
        finally {
            DbUtil.close(rs);
        }
        return curIdx;
    }

    public List getLanModuleBySwitch(long switchId) throws Exception {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String sql = null;
        Connection con = null;
        ArrayList<ModuleDO> rstList = new ArrayList<ModuleDO>();
        int curIdx = 0;
        try {
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSql("ModuleAction.LAN_MODULE_BY_SWITCH_STMT");
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1003, 1007);
            stmt.setLong(1, switchId);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                ModuleDO row = new ModuleDO();
                String fabric = rs.getString(1);
                String switchName = rs.getString(2);
                String moduleName = rs.getString(3);
                String cardStatus = rs.getString(4);
                String hwType = rs.getString(5);
                String hwVersion = rs.getString(6);
                String swVersion = rs.getString(7);
                String serialNumber = rs.getString(8);
                String assetId = rs.getString(9);
                String detailName = rs.getString(10);
                int slotNumber = rs.getInt(13);
                String secSerialNumber = rs.getString(14);
                String hardwareType = HwInventoryType.getType(Integer.parseInt(hwType)).toString();
                String slot = "";
                if ("9".equals(hwType)) {
                    slot = slotNumber + "";
                }
                String index = curIdx + 1 + "";
                row.setIndex(index);
                row.setName(detailName);
                row.setModelName(moduleName);
                row.setSerialNum(serialNumber);
                row.setSndSerialNum(secSerialNumber == null ? "" : secSerialNumber);
                row.setType(hardwareType);
                row.setSlot(slot);
                row.setHwRevision(hwVersion);
                row.setSwRevision(swVersion);
                row.setAssetId(assetId);
                row.setOpStatus(cardStatus);
                rstList.add(row);
                ++curIdx;
            }
        }
        catch (SQLException ex) {
            try {
                this._Logger.error((Object)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return rstList;
    }

    public int getDataLength(DbFilterDO dbFilter, String statusFilter) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        long vsanDbId = dbFilter.getVsanDbId();
        long fabricDbId = dbFilter.getFabricDbId();
        String networkType = dbFilter.getNetworkType();
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
        int recordSize = -1;
        DBEntryDO result = this.getList(networkType, fabricDbId, vsanDbId, dbFilter.isGroup(), 0, recordSize, statusFilter, sortSqlSuffix, groupFabricFilterSqlSuffix, groupLanFilterSqlSuffix);
        return result.getRowSize();
    }

    private String getSortStmt(DbFilterDO dbFilter) {
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField());
        if (sortSqlSuffix != null) {
            sortSqlSuffix = sortSqlSuffix + " " + dbFilter.getSortType();
        }
        return sortSqlSuffix;
    }

    public String printModuleTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
        DBEntryDO dbEntryDO = this.getList(dbFilter.getNetworkType(), dbFilter.getFabricDbId(), dbFilter.getVsanDbId(), dbFilter.isGroup(), startIdx, recordSize, status, sortSqlSuffix, groupFabricFilterSqlSuffix, groupLanFilterSqlSuffix);
        return JasperPrintGenerator.getInstance().generatePrintReport("Modules", columnHeader, dbEntryDO);
    }

    public String exportModuleTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
        DBEntryDO dbEntryDO = this.getList(dbFilter.getNetworkType(), dbFilter.getFabricDbId(), dbFilter.getVsanDbId(), dbFilter.isGroup(), startIdx, recordSize, status, sortSqlSuffix, groupFabricFilterSqlSuffix, groupLanFilterSqlSuffix);
        return JasperPrintGenerator.getInstance().generateExcelReport("Modules", columnHeader, dbEntryDO);
    }
}

