/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import com.cisco.dcbu.jaxws.san.wo.N3KBufferStatDataDO;
import com.cisco.dcbu.jaxws.san.wo.N3KBufferStatItemDataDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class N3KBufferStatHandler {
    private static N3KBufferStatHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private DateFormat _dateFormat;

    public static N3KBufferStatHandler getInstance() {
        if (_Instance == null) {
            _Instance = new N3KBufferStatHandler();
        }
        return _Instance;
    }

    private N3KBufferStatHandler() {
    }

    public int getN3KBufferStatDataLength(DbFilterDO dbFilter) {
        ArrayList<N3KBufferStatDataDO> records = new ArrayList<N3KBufferStatDataDO>();
        return this.getN3KBufferStatList(records, dbFilter, 0, 1, true);
    }

    public ArrayList<N3KBufferStatDataDO> getN3KBufferStatList(DbFilterDO dbFilter, int startIdx, int recordSize) {
        ArrayList<N3KBufferStatDataDO> records = new ArrayList<N3KBufferStatDataDO>();
        this.getN3KBufferStatList(records, dbFilter, startIdx, recordSize, false);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getN3KBufferStatList(ArrayList<N3KBufferStatDataDO> records, DbFilterDO dbFilter, int startIdx, int recordSize, boolean lengthOnly) {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String groupLanFilterSqlSuffix;
            con = ConnectionManager.getConnection();
            String sql = null;
            String prefix = "PerformanceAction.";
            String sortString = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType());
            String filterStr = groupLanFilterSqlSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
            int[] ind = new int[]{1, 2};
            String[] rep = new String[]{filterStr, sortString};
            sql = SQLLoader.getSql(prefix + "N3K_BUFFER_STMT", ind, rep);
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            rs = SQLLoader.execute(stmt);
            if (lengthOnly) {
                rs.last();
                int n = rs.getRow();
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(con);
                return n;
            }
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String groupName = rs.getString(1);
                long lan_id = rs.getLong(2);
                long switch_id = rs.getLong(3);
                String switchName = rs.getString(4);
                int ifIndex = rs.getInt(5);
                String ifName = rs.getString(6);
                double avg_count = rs.getDouble(7);
                int max_count = rs.getInt(8);
                long total_count = rs.getLong(9);
                Timestamp lastUpdated = rs.getTimestamp(10);
                double avg_count_round = (double)Math.round(avg_count * 100.0) / 100.0;
                N3KBufferStatDataDO wrapper = new N3KBufferStatDataDO(switch_id, ifIndex);
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                wrapper.setGroupName(groupName);
                wrapper.setLanId(lan_id);
                wrapper.setSwitchName(switchName);
                wrapper.setSwIfName(ifName);
                wrapper.setAvgCount(avg_count_round);
                wrapper.setMaxCount(max_count);
                wrapper.setTotalCount(total_count);
                wrapper.setIndex(curIdx + startIdx + 1);
                records.add(wrapper);
                if (++curIdx < recordSize) continue;
            }
            DbUtil.close(stmt);
        }
        catch (SQLException ex) {
            this._Log.error((Object)"N3KBufferStatHandler.getN3KBufferStatList", (Throwable)ex);
            return records.size();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception x) {
                this._Log.error((Object)"N3KBufferStatHandler.getN3KBufferStatList", (Throwable)x);
                return records.size();
            }
        }
        finally {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(con);
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ArrayList<N3KBufferStatItemDataDO> getN3KBufferStatItem(long switchId, long ifIndex) {
        ArrayList<N3KBufferStatItemDataDO> records;
        block8: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            records = new ArrayList<N3KBufferStatItemDataDO>();
            try {
                con = ConnectionManager.getConnection();
                String sql = null;
                String prefix = "PerformanceAction.";
                sql = SQLLoader.getSql(prefix + "N3K_BUFFER_SWITCH_IFINDEX_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, switchId);
                stmt.setLong(2, ifIndex);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    long switch_id = rs.getLong(1);
                    int if_index = rs.getInt(2);
                    int count = rs.getInt(3);
                    Timestamp lastUpdated = rs.getTimestamp(4);
                    N3KBufferStatItemDataDO wrapper = new N3KBufferStatItemDataDO(switch_id, if_index);
                    wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                    wrapper.setCount(count);
                    records.add(wrapper);
                }
                DbUtil.close(stmt);
            }
            catch (SQLException ex) {
                this._Log.error((Object)"N3KBufferStatHandler.getN3KBufferStatItem", (Throwable)ex);
                break block8;
            }
            catch (Exception x) {
                this._Log.error((Object)"N3KBufferStatHandler.getN3KBufferStatItem", (Throwable)x);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(con);
            }
            DbUtil.close(rs);
            DbUtil.close(con);
        }
        return records;
    }

    private String getSqlSortSuffix(String sortField, String sortType) {
        if (sortField == null || sortField.equals("")) {
            return null;
        }
        StringBuilder sortStr = new StringBuilder();
        if (sortField.equals("avgCount")) {
            sortStr.append("avg(count)");
        } else if (sortField.equals("maxCount")) {
            sortStr.append("max(count)");
        } else if (sortField.equals("totalCount")) {
            sortStr.append("sum(count)");
        } else if (sortField.equals("swIfName")) {
            sortStr.append("if_name");
        } else if (sortField.equals("switchName")) {
            sortStr.append("sys_name");
        } else {
            sortStr.append("avg(count)");
        }
        if (sortType == null || sortType.trim().length() == 0) {
            sortType = "DESC";
        }
        sortStr.append(" ").append(sortType);
        return sortStr.toString();
    }

    private DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return this._dateFormat;
    }

    public static void main(String[] args) throws Exception {
        GenUtil.loadServerProperties(null);
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "avgCount", "DESC");
        dbFilter.setSortField("avgCount");
        System.out.println("*********get N3K Buffer Stat ************ :");
        int length = N3KBufferStatHandler.getInstance().getN3KBufferStatDataLength(dbFilter);
        System.out.println("length is : " + length);
        ArrayList<N3KBufferStatDataDO> rstList = N3KBufferStatHandler.getInstance().getN3KBufferStatList(dbFilter, 1, 30);
        int count = 0;
        for (N3KBufferStatDataDO e : rstList) {
            System.out.println(count++ + " : " + e.getGroupName() + ":" + e.getSwitchName() + " : " + e.getLastUpdateTimeStr() + ":" + e.getSwIfName() + ":" + e.getIfIndex() + ":" + e.getAvgCount() + ":" + e.getMaxCount() + ":" + e.getTotalCount() + " : " + e.getLanId());
        }
    }

    public String printN3KBufferStatTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<N3KBufferStatDataDO> rstList = N3KBufferStatHandler.getInstance().getN3KBufferStatList(dbFilter, startIdx, recordSize);
        String title = "Performance N3K Buffer Usage";
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, rstList);
    }

    public String exportN3KBufferStatTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<N3KBufferStatDataDO> rstList = N3KBufferStatHandler.getInstance().getN3KBufferStatList(dbFilter, startIdx, recordSize);
        String title = "Performance N3K Buffer Usage";
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, rstList);
    }
}

