/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.jasper.report;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.handler.SecurityHandler;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.common.model.TableColumn;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperReportBuilder;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperReportGenerator;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperReportUtil;
import com.cisco.dcbu.sm.server.web.jasper.report.PerformanceChartReportBuilder;
import com.cisco.dcbu.sm.server.web.jasper.report.RawTextReportBuilder;
import com.cisco.dcbu.sm.server.web.jasper.report.SimpleTextReportBuilder;
import com.cisco.dcbu.sm.server.web.jasper.report.TableReportBuilder;
import com.cisco.dcbu.sm.server.web.jasper.report.TitleReportBuilder;
import com.cisco.dcbu.sm.server.web.jasper.report.TocReportBuilder;
import com.cisco.dcbu.sm.server.web.report.ColumnSet;
import com.cisco.dcbu.sm.server.web.report.CustomReport;
import com.cisco.dcbu.sm.server.web.report.ReportGroup;
import com.cisco.dcbu.sm.server.web.report.ReportInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class JasperPrintGenerator {
    public static final String _DOWNLOAD_DIR = ClientCache.getInstallLocation() + "download" + File.separator;
    public static final String _PRINT = "print";
    public static final String _XLS = "xls";
    public static final String _HTML_FILE_EXTENSION = ".html";
    public static final String _XLS_FILE_EXTENSION = ".xls";
    public static final String _NO_RECORDS = " -- No records found.";
    public SimpleDateFormat dateformat = new SimpleDateFormat("ddMMMyyyy_HHmmss");
    private static Logger _Logger = Logger.getLogger((String)"fms");
    private static final JasperPrintGenerator instance = new JasperPrintGenerator();

    private JasperPrintGenerator() {
    }

    public static JasperPrintGenerator getInstance() {
        return instance;
    }

    public String generatePrintReport(String title, String[] columnHeader, HashMap<String, HorizontalAlign> columnAlignment, Collection dataObjects) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Generating Print Report !!!");
            _Logger.info((Object)("Title: " + title));
            _Logger.info((Object)("ColumnHeader Length: " + columnHeader.length));
            _Logger.info((Object)("DataObjects Size: " + dataObjects.size()));
            _Logger.info((Object)("Download Directory: " + _DOWNLOAD_DIR));
            _Logger.info((Object)("Token: " + SecurityHandler.getToken()));
        }
        ArrayList<JasperReportBuilder> list = new ArrayList<JasperReportBuilder>();
        TableReportBuilder reportBuilder = null;
        if (this.noRecordsFound(dataObjects)) {
            list.add(new TitleReportBuilder("" + new Date() + _NO_RECORDS));
        } else {
            reportBuilder = JasperReportUtil.isNestedColumn(columnHeader) ? (columnAlignment != null ? new TableReportBuilder("" + new Date(), this.getColumnSetList(columnHeader), columnAlignment, dataObjects) : new TableReportBuilder("" + new Date(), this.getColumnSetList(columnHeader), dataObjects)) : (columnAlignment != null ? new TableReportBuilder("" + new Date(), JasperReportUtil.getColumnTitle(columnHeader), JasperReportUtil.getColumnProperty(columnHeader), columnAlignment, dataObjects) : new TableReportBuilder("" + new Date(), JasperReportUtil.getColumnTitle(columnHeader), JasperReportUtil.getColumnProperty(columnHeader), dataObjects));
            if (reportBuilder != null) {
                list.add(reportBuilder);
            }
        }
        String printDir = _DOWNLOAD_DIR + _PRINT + File.separator + this.getCurrentUsername() + File.separator;
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Print Directory: " + printDir));
        }
        if (!new File(printDir).exists()) {
            new File(printDir).mkdirs();
        }
        Date date = new Date();
        String printFile = "print_" + this.dateformat.format(date);
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Print Filename: " + printFile));
        }
        JasperReportGenerator generator = new JasperReportGenerator(title, list, printDir + printFile);
        generator.generatePrintReport();
        return "/fmserver/download/print/" + this.getCurrentUsername() + "/" + printFile + _HTML_FILE_EXTENSION;
    }

    public String generatePrintReport(String title, String[] columnHeader, Collection dataObjects) {
        return this.generatePrintReport(title, columnHeader, null, dataObjects);
    }

    public String generatePrintReport(String title, String[] columnHeader, DBEntryDO dbObject) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("DBEntryDO.size(): " + dbObject.getRowSize()));
        }
        ArrayList<DBEntryDO> dataObjects = new ArrayList<DBEntryDO>();
        dataObjects.add(dbObject);
        return this.generatePrintReport(title, columnHeader, dataObjects);
    }

    public String generatePrintReport(String title, String[] columnHeader, HashMap<String, HorizontalAlign> columnAlignment, DBEntryDO dbObject) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("DBEntryDO.size(): " + dbObject.getRowSize()));
        }
        ArrayList<DBEntryDO> dataObjects = new ArrayList<DBEntryDO>();
        dataObjects.add(dbObject);
        return this.generatePrintReport(title, columnHeader, columnAlignment, dataObjects);
    }

    public String generateExcelReport(String title, String[] columnHeader, HashMap<String, HorizontalAlign> columnAlignment, Collection dataObjects) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Generating Excel Report");
            _Logger.info((Object)("Title: " + title));
            _Logger.info((Object)("ColumnHeader Length: " + columnHeader.length));
            _Logger.info((Object)("Data Objects Size(): " + dataObjects.size()));
            _Logger.info((Object)("Download Directory: " + _DOWNLOAD_DIR));
            _Logger.info((Object)("Token: " + SecurityHandler.getToken()));
        }
        ArrayList<JasperReportBuilder> list = new ArrayList<JasperReportBuilder>();
        TableReportBuilder reportBuilder = null;
        if (this.noRecordsFound(dataObjects)) {
            list.add(new TitleReportBuilder("" + new Date() + _NO_RECORDS));
        } else {
            reportBuilder = JasperReportUtil.isNestedColumn(columnHeader) ? (columnAlignment != null ? new TableReportBuilder("" + new Date(), this.getColumnSetList(columnHeader), columnAlignment, dataObjects) : new TableReportBuilder("" + new Date(), this.getColumnSetList(columnHeader), dataObjects)) : (columnAlignment != null ? new TableReportBuilder("" + new Date(), JasperReportUtil.getColumnTitle(columnHeader), JasperReportUtil.getColumnProperty(columnHeader), columnAlignment, dataObjects) : new TableReportBuilder("" + new Date(), JasperReportUtil.getColumnTitle(columnHeader), JasperReportUtil.getColumnProperty(columnHeader), dataObjects));
            if (reportBuilder != null) {
                list.add(reportBuilder);
            }
        }
        String excelDir = _DOWNLOAD_DIR + _XLS + File.separator + this.getCurrentUsername() + File.separator;
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Excel Directory: " + excelDir));
        }
        if (!new File(excelDir).exists()) {
            new File(excelDir).mkdirs();
        }
        Date date = new Date();
        String excelFile = "xls_" + this.dateformat.format(date);
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Excel Filename: " + excelFile));
        }
        JasperReportGenerator generator = new JasperReportGenerator(title, list, excelDir + excelFile);
        generator.generateExcelReport();
        return "/fmserver/download/xls/" + this.getCurrentUsername() + "/" + excelFile + _XLS_FILE_EXTENSION;
    }

    public String generateExcelReport(String title, String[] columnHeader, Collection dataObjects) {
        return this.generateExcelReport(title, columnHeader, null, dataObjects);
    }

    public String generateExcelReport(String title, String[] columnHeader, DBEntryDO dbObject) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("DBEntryDO.size(): " + dbObject.getRowSize()));
        }
        ArrayList<DBEntryDO> dataObjects = new ArrayList<DBEntryDO>();
        dataObjects.add(dbObject);
        return this.generateExcelReport(title, columnHeader, dataObjects);
    }

    public String generateExcelReport(String title, String[] columnHeader, HashMap<String, HorizontalAlign> columnAlignment, DBEntryDO dbObject) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("DBEntryDO.size(): " + dbObject.getRowSize()));
        }
        ArrayList<DBEntryDO> dataObjects = new ArrayList<DBEntryDO>();
        dataObjects.add(dbObject);
        return this.generateExcelReport(title, columnHeader, columnAlignment, dataObjects);
    }

    public JasperReportBuilder generateSubReport(String title, String[] columnHeader, DBEntryDO dbObject) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("DBEntryDO.size(): " + dbObject.getRowSize()));
        }
        ArrayList<DBEntryDO> dataObjects = new ArrayList<DBEntryDO>();
        dataObjects.add(dbObject);
        return this.generateSubReport(title, columnHeader, null, dataObjects);
    }

    public JasperReportBuilder generateSubReport(String title, String[] columnHeader, HashMap<String, HorizontalAlign> columnAlignment, DBEntryDO dbObject) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("DBEntryDO.size(): " + dbObject.getRowSize()));
        }
        ArrayList<DBEntryDO> dataObjects = new ArrayList<DBEntryDO>();
        dataObjects.add(dbObject);
        return this.generateSubReport(title, columnHeader, columnAlignment, dataObjects);
    }

    public JasperReportBuilder generateSubReport(String title, String[] columnHeader, Collection dataObjects) {
        return this.generateSubReport(title, columnHeader, null, dataObjects);
    }

    public JasperReportBuilder generateSubReport(String title, String[] columnHeader, HashMap<String, HorizontalAlign> columnAlignment, Collection dataObjects) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Generating subreport !!!");
            _Logger.info((Object)("Title: " + title));
            _Logger.info((Object)("ColumnHeader Length: " + columnHeader.length));
            _Logger.info((Object)("DataObjects Size: " + dataObjects.size()));
            _Logger.info((Object)("Download Directory: " + _DOWNLOAD_DIR));
            _Logger.info((Object)("Token: " + SecurityHandler.getToken()));
        }
        TableReportBuilder reportBuilder = null;
        reportBuilder = JasperReportUtil.isNestedColumn(columnHeader) ? (columnAlignment != null ? new TableReportBuilder(title, this.getColumnSetList(columnHeader), columnAlignment, dataObjects) : new TableReportBuilder(title, this.getColumnSetList(columnHeader), dataObjects)) : (columnAlignment != null ? new TableReportBuilder(title, JasperReportUtil.getColumnTitle(columnHeader), JasperReportUtil.getColumnProperty(columnHeader), columnAlignment, dataObjects) : new TableReportBuilder(title, JasperReportUtil.getColumnTitle(columnHeader), JasperReportUtil.getColumnProperty(columnHeader), dataObjects));
        return reportBuilder;
    }

    public String generateMultiTableReport(String title, ArrayList<JasperReportBuilder> list) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Generating Print Report !!!");
            _Logger.info((Object)("Title: " + title));
            if (list != null) {
                _Logger.info((Object)("list: " + list.size()));
            }
        }
        String printDir = _DOWNLOAD_DIR + _PRINT + File.separator + this.getCurrentUsername() + File.separator;
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Print Directory: " + printDir));
        }
        if (!new File(printDir).exists()) {
            new File(printDir).mkdirs();
        }
        Date date = new Date();
        String printFile = "print_" + this.dateformat.format(date);
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Print Filename: " + printFile));
        }
        JasperReportGenerator generator = new JasperReportGenerator(title, list, printDir + printFile);
        generator.generatePrintReport();
        return "/fmserver/download/print/" + this.getCurrentUsername() + "/" + printFile + _HTML_FILE_EXTENSION;
    }

    public String generateExcelMutiTableReport(String title, ArrayList<JasperReportBuilder> list) {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Generating Excel Report");
            _Logger.info((Object)("Title: " + title));
            _Logger.info((Object)("Token: " + SecurityHandler.getToken()));
        }
        String excelDir = _DOWNLOAD_DIR + _XLS + File.separator + this.getCurrentUsername() + File.separator;
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Excel Directory: " + excelDir));
        }
        if (!new File(excelDir).exists()) {
            new File(excelDir).mkdirs();
        }
        Date date = new Date();
        String excelFile = "xls_" + this.dateformat.format(date);
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Excel Filename: " + excelFile));
        }
        JasperReportGenerator generator = new JasperReportGenerator(title, list, excelDir + excelFile);
        generator.generateExcelReport();
        return "/fmserver/download/xls/" + this.getCurrentUsername() + "/" + excelFile + _XLS_FILE_EXTENSION;
    }

    public void generateJasperReport(CustomReport customReport, String absoluteFileName) {
        String dir;
        boolean isGoldReport = false;
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Inside generateJasperReport()");
        }
        JasperReportUtil.deleteExistingReport(absoluteFileName);
        ArrayList<JasperReportBuilder> list = new ArrayList<JasperReportBuilder>();
        LinkedList<ReportGroup> groups = customReport.getGroups();
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Report group size: " + groups.size()));
        }
        int groupIndex = 1;
        for (ReportGroup group : groups) {
            int reportIndex = 1;
            if (_Logger.isTraceEnabled()) {
                _Logger.info((Object)("group.getReports(): " + group.getReports().size()));
            }
            for (ReportInfo reportInfo : group.getReports()) {
                if (_Logger.isTraceEnabled() && reportInfo != null) {
                    _Logger.info((Object)("reportInfo.getName(): " + reportInfo.getName()));
                    _Logger.info((Object)("reportInfo.getDataList().size(): " + reportInfo.getDataList().size()));
                    if (reportInfo.getHasToc()) {
                        _Logger.info((Object)("reportInfo.getTocContent().size(): " + reportInfo.getTocContent().size()));
                    }
                }
                if (reportInfo == null) continue;
                if (reportInfo.getReportType() == 4) {
                    TocReportBuilder tocReportBuilder = new TocReportBuilder(customReport.getScope() + customReport.getCreationTime(), reportInfo.getTocContent());
                    if (tocReportBuilder != null) {
                        list.add(tocReportBuilder);
                    }
                } else if (reportInfo.getReportType() == 5 && reportInfo.getDataList() != null) {
                    RawTextReportBuilder rawTextReportBuilder = new RawTextReportBuilder(customReport.getScope() + customReport.getCreationTime(), reportInfo.getNote());
                    list.add(rawTextReportBuilder);
                    isGoldReport = true;
                } else if (reportInfo.getDataList() != null && reportInfo.getName() != null && reportInfo.getColumnSets() != null) {
                    if (this.noRecordsFound(reportInfo.getDataList())) {
                        list.add(new TitleReportBuilder(groupIndex + "." + reportIndex++ + "   " + reportInfo.getName() + _NO_RECORDS));
                    } else {
                        try {
                            boolean export2Xls;
                            PerformanceChartReportBuilder chartReportBuilder;
                            TableReportBuilder reportBuilder = new TableReportBuilder(groupIndex + "." + reportIndex++ + "   " + reportInfo.getName(), reportInfo);
                            list.add(reportBuilder);
                            if (reportInfo.getHasChart() && (chartReportBuilder = new PerformanceChartReportBuilder(reportInfo, export2Xls = absoluteFileName.endsWith(_XLS_FILE_EXTENSION))) != null) {
                                list.add(chartReportBuilder);
                            }
                        }
                        catch (Exception ex) {
                            _Logger.error((Object)("Exception in JasperPrintGenerator for TableReportBuilder: " + ex.getMessage()));
                        }
                    }
                }
                if (reportInfo.getDetails() == null) continue;
                Collection detailReportInfoCol = reportInfo.getDetails();
                for (ReportInfo detailReportInfo : detailReportInfoCol) {
                    if (detailReportInfo != null && detailReportInfo.getReportType() == 6) {
                        SimpleTextReportBuilder simpleTextReportBuilder = new SimpleTextReportBuilder(detailReportInfo.getNote());
                        list.add(simpleTextReportBuilder);
                        continue;
                    }
                    if (detailReportInfo != null && detailReportInfo.getReportType() == 4) {
                        TocReportBuilder tocReportBuilder = absoluteFileName.contains("Diagnostic") ? new TocReportBuilder(customReport.getScope() + customReport.getCreationTime(), reportInfo.getTocContent(), true) : new TocReportBuilder(customReport.getScope() + customReport.getCreationTime(), reportInfo.getTocContent());
                        if (tocReportBuilder == null) continue;
                        list.add(tocReportBuilder);
                        continue;
                    }
                    if (detailReportInfo == null || detailReportInfo.getDataList() == null || detailReportInfo.getDataList().size() <= 0 || detailReportInfo.getName() == null) continue;
                    if (_Logger.isTraceEnabled()) {
                        _Logger.info((Object)("detailReportInfo.getName(): " + detailReportInfo.getName()));
                        _Logger.info((Object)("detailReportInfo.getDataList().size(): " + detailReportInfo.getDataList().size()));
                    }
                    JasperReportBuilder detailReportBuilder = null;
                    if (this.noRecordsFound(detailReportInfo.getDataList())) {
                        detailReportBuilder = new TitleReportBuilder(detailReportInfo.getSwitchName() + " " + detailReportInfo.getName() + _NO_RECORDS);
                    } else {
                        Object obj = detailReportInfo.getDataList().toArray()[0];
                        if (obj != null && obj instanceof DBEntryDO) {
                            Collection columns = detailReportInfo.getColumnSets();
                            if (columns != null) {
                                Iterator iter = columns.iterator();
                                ArrayList<String> headers = new ArrayList<String>();
                                while (iter.hasNext()) {
                                    ColumnSet colSet = (ColumnSet)iter.next();
                                    Collection tabColumns = colSet.getColumnSet();
                                    for (Object nextCol : tabColumns) {
                                        if (!(nextCol instanceof TableColumn)) continue;
                                        headers.add(((TableColumn)nextCol).getName());
                                    }
                                }
                                if (headers.size() > 0) {
                                    String[] headerStr = headers.toArray(new String[headers.size()]);
                                    detailReportBuilder = new TableReportBuilder(detailReportInfo.getSwitchName() + " " + detailReportInfo.getName(), headerStr, headerStr, detailReportInfo);
                                }
                            }
                        } else {
                            detailReportBuilder = new TableReportBuilder(detailReportInfo.getSwitchName() + " " + detailReportInfo.getName(), detailReportInfo);
                        }
                    }
                    if (detailReportBuilder == null) continue;
                    list.add(detailReportBuilder);
                    if (!detailReportInfo.getHasChart()) continue;
                    boolean export2Xls = absoluteFileName.endsWith(_XLS_FILE_EXTENSION);
                    PerformanceChartReportBuilder chartReportBuilder = new PerformanceChartReportBuilder(detailReportInfo.getCharts(), export2Xls);
                    if (chartReportBuilder == null) continue;
                    list.add(chartReportBuilder);
                }
            }
            ++groupIndex;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("JasperReportBuilder List size: " + list.size()));
            _Logger.info((Object)("JasperReportBuilder absoluteFileName: " + absoluteFileName));
        }
        if (!new File(dir = absoluteFileName.substring(0, absoluteFileName.lastIndexOf(File.separator))).exists()) {
            new File(dir).mkdir();
        }
        JasperReportGenerator generator = null;
        generator = isGoldReport ? new JasperReportGenerator("GOLD Diagnostics Report" + customReport.getCreationTime(), list, absoluteFileName) : new JasperReportGenerator(customReport.getScope() + customReport.getCreationTime(), list, absoluteFileName);
        generator.generateJasperReport();
    }

    private Collection<ColumnSet> getColumnSetList(String[] columnHeader) {
        ArrayList<ColumnSet> columnSetCol = new ArrayList<ColumnSet>();
        for (int idx = 0; idx < columnHeader.length; ++idx) {
            TableColumn tableColumn;
            String columnTxt = columnHeader[idx];
            String[] strArray = columnTxt.split(":");
            String header = strArray[0];
            String property = strArray[1];
            String parent = strArray[2];
            if (header.equals("null") && property.equals("null") && parent.equals("null")) continue;
            ColumnSet columnSet = new ColumnSet();
            if (parent.equals("null")) {
                if (property.equals("null")) {
                    columnSet.setHeader(header);
                } else {
                    tableColumn = new TableColumn(header, property);
                    ArrayList<TableColumn> tableColumnCol = new ArrayList<TableColumn>();
                    tableColumnCol.add(tableColumn);
                    columnSet.setColumnSet(tableColumnCol);
                }
                columnSetCol.add(columnSet);
                continue;
            }
            if (property.equals("null")) {
                columnSet.setHeader(header);
                this.addToParentColumnSet(columnSetCol, columnSet, parent);
                continue;
            }
            tableColumn = new TableColumn(header, property);
            this.addToParentColumnSet(columnSetCol, tableColumn, parent);
        }
        return columnSetCol;
    }

    private String getCurrentUsername() {
        String token = SecurityHandler.getToken();
        if (token != null) {
            return IdentityManager.getInstance().extractToken(token).getUsername();
        }
        _Logger.error((Object)"Unable to get logged in Username, returning default username Admin!!!!");
        return "admin";
    }

    private void addToParentColumnSet(Collection columnSetCol, Object column, String parent) {
        for (Object obj : columnSetCol) {
            if (!(obj instanceof ColumnSet)) continue;
            ColumnSet columnSet = (ColumnSet)obj;
            if (columnSet.getHeader() != null && columnSet.getHeader().equals(parent)) {
                if (columnSet.getColumnSet() == null) {
                    columnSet.setColumnSet(new ArrayList());
                }
                if (this.getDuplicate(column, columnSet)) break;
                columnSet.getColumnSet().add(column);
                break;
            }
            if (columnSet.getColumnSet() == null) continue;
            this.addToParentColumnSet(columnSet.getColumnSet(), column, parent);
        }
    }

    private boolean getDuplicate(Object column, ColumnSet columnSet) {
        boolean duplicate = false;
        for (Object temp : columnSet.getColumnSet()) {
            if (column instanceof ColumnSet) {
                if (!(temp instanceof ColumnSet) || !((ColumnSet)temp).getHeader().equals(((ColumnSet)column).getHeader())) continue;
                duplicate = true;
                break;
            }
            if (!(temp instanceof TableColumn) || !((TableColumn)temp).getName().equals(((TableColumn)column).getName())) continue;
            duplicate = true;
            break;
        }
        return duplicate;
    }

    public String[] replaceColumnHeaderString(String[] columnHeader, String oldString, String newString) {
        if (columnHeader != null && columnHeader.length > 0) {
            for (int idx = 0; idx < columnHeader.length; ++idx) {
                if (!columnHeader[idx].contains(oldString)) continue;
                columnHeader[idx] = columnHeader[idx].replace(oldString, newString);
                break;
            }
        }
        return columnHeader;
    }

    public boolean noRecordsFound(Collection dataObjects) {
        DBEntryDO dbEntryDO;
        Object obj;
        if (dataObjects != null && dataObjects.size() == 0) {
            return true;
        }
        return dataObjects != null && dataObjects.size() == 1 && (obj = dataObjects.toArray()[0]) != null && obj instanceof DBEntryDO && (dbEntryDO = (DBEntryDO)obj).getRows().length == 0;
    }
}

