/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.jasper.report;

import com.cisco.dcbu.sm.server.web.jasper.report.JasperReportBuilder;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperReportUtil;
import java.awt.Color;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.log4j.Logger;

public class TocReport {
    private static final int WIDTH = 600;
    private static Logger _Logger = Logger.getLogger((String)"fms");
    private JasperReportBuilder tocReportBuilder;
    private JasperDesign jasperDesign;

    public TocReport(JasperReportBuilder tocReportBuilder) {
        this.tocReportBuilder = tocReportBuilder;
    }

    public JasperDesign getJasperDesign() throws JRException {
        this.jasperDesign = JRXmlLoader.load((String)JasperReportUtil.getFullPath("/conf/template.jrxml"));
        this.jasperDesign.setName("DCNM TOC Report");
        this.jasperDesign.setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
        this.createDetailBand();
        return this.jasperDesign;
    }

    private void createDetailBand() throws JRException {
        if (this.tocReportBuilder != null && this.tocReportBuilder.getTocList() != null) {
            List<String[]> tocList = this.tocReportBuilder.getTocList();
            for (String[] tocElement : tocList) {
                JRDesignBand band = new JRDesignBand();
                band.setHeight(25);
                JRDesignTextField textField = this.createTocLink(0, tocElement[0], tocElement[1], tocElement[2]);
                band.addElement((JRDesignElement)textField);
                ((JRDesignSection)this.jasperDesign.getDetailSection()).addBand((JRBand)band);
            }
        }
    }

    private JRDesignTextField createHeader() {
        JRDesignTextField textField = new JRDesignTextField();
        textField.setWidth(600);
        textField.setHeight(25);
        textField.setFontName("Arial");
        textField.setFontSize(13);
        textField.setBold(true);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(String.class);
        exp.setText("\"Table Of Contents\"");
        textField.setExpression((JRExpression)exp);
        return textField;
    }

    private JRDesignTextField createTocLink(int y, String text, String anchorText, String indexLevel) {
        JRDesignTextField textField = new JRDesignTextField();
        textField.setY(y);
        textField.setWidth(600);
        textField.setHeight(25);
        textField.setFontName("Arial");
        textField.setFontSize(12);
        textField.setBold(false);
        int indentX = 0;
        if (indexLevel != null) {
            try {
                int level = new Integer(indexLevel);
                for (int i = 0; i < level; ++i) {
                    indentX += 12;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(String.class);
        exp.setText("\"" + text + "\"");
        textField.setExpression((JRExpression)exp);
        textField.setX(indentX);
        if (anchorText != null) {
            textField.setHyperlinkType(HyperlinkTypeEnum.LOCAL_ANCHOR);
            textField.setForecolor(Color.blue);
            JRDesignExpression hyperlinkAnchorExpression = new JRDesignExpression();
            hyperlinkAnchorExpression.setValueClass(String.class);
            hyperlinkAnchorExpression.setText("\"" + anchorText + "\"");
            textField.setHyperlinkAnchorExpression((JRExpression)hyperlinkAnchorExpression);
        }
        return textField;
    }
}

