/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.lan.persister;

import com.cisco.dcbu.dcm.common.Assert;
import com.cisco.dcbu.sm.server.web.lan.persister.DefaultUnitOfWork;
import com.cisco.dcbu.sm.server.web.lan.persister.SessionPersisterFactory;
import com.cisco.dcbu.sm.server.web.lan.persister.UnitOfWork;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitOfWorkFactory {
    private static final Log log = LogFactory.getLog(UnitOfWorkFactory.class);
    public static final String DB_CFG_RESOURCE_PNAME = "cisco.dcbu.dcm.dbCfgResource";
    public static final String MAPPING_CFG_RESOURCE_PNAME = "cisco.dcbu.dcm.mappingCfgResource";
    public static final String HIBERNATE_HBM2DDL_EXPORT = "cisco.dcbu.dcm.hbm2ddl";
    public static final UnitOfWorkFactory INSTANCE = new UnitOfWorkFactory();
    private String dbCfgResource;
    private boolean initFlag = false;
    private String mappingCfgResource;
    private String jdbcUrlString;
    private SessionPersisterFactory publicSessionPersisterFactory;
    private Properties hibernateProperties;
    Map unitOfWorks;

    private UnitOfWorkFactory() {
        log.info((Object)"Creates a singleton unit of work factory");
        this.unitOfWorks = new Hashtable();
    }

    public void init() {
        Assert.isTrue((!this.initFlag ? 1 : 0) != 0, (String)"init() has been already called");
        log.info((Object)"Initializes a singleton unit of work factory");
        this.createPublicSessionPersisterFactory();
        this.initFlag = true;
    }

    public UnitOfWork getUnitOfWork() {
        Assert.isTrue((boolean)this.initFlag, (String)"init() must be called first");
        DefaultUnitOfWork uow = new DefaultUnitOfWork();
        log.info((Object)("Created a unit of work #" + uow.getId()));
        this.unitOfWorks.put(uow, Boolean.TRUE);
        return uow;
    }

    public String getDbCfgResource() {
        return this.dbCfgResource;
    }

    public void setDbCfgResource(String aDbCfgResource) {
        this.dbCfgResource = aDbCfgResource;
    }

    public String getJdbcUrlString() {
        return this.jdbcUrlString;
    }

    public void setJdbcUrlString(String aJdbcUrlString) {
        Assert.isNull((Object)this.jdbcUrlString, (String)"jdbcUrlString is already set");
        this.jdbcUrlString = aJdbcUrlString;
    }

    public String getMappingCfgResource() {
        return this.mappingCfgResource;
    }

    public void setMappingCfgResource(String aMappingCfgResource) {
        Assert.isNull((Object)this.mappingCfgResource, (String)"mappingCfgResource is already set");
        this.mappingCfgResource = aMappingCfgResource;
    }

    private void createPublicSessionPersisterFactory() {
        this.publicSessionPersisterFactory = new SessionPersisterFactory(this.dbCfgResource, this.jdbcUrlString, this.mappingCfgResource, this.hibernateProperties);
    }

    public SessionPersisterFactory getPublicSessionPersisterFactory() {
        return this.publicSessionPersisterFactory;
    }

    public boolean isInitFlag() {
        return this.initFlag;
    }

    public Properties getHibernateProperties() {
        return this.hibernateProperties;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }
}

