/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.lib.sshexec.IGoldDiagAdapter;
import com.cisco.dcbu.lib.sshexec.impl.GoldDiagAdapter;
import com.cisco.dcbu.sm.common.util.StopWatch;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.web.report.GoldDO;
import com.cisco.dcbu.sm.server.web.report.GoldModuleDO;
import com.cisco.dcbu.sm.server.web.report.GoldReport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DiagnosticExecutor
implements Callable {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.disc"), false, false, false, false);
    SwitchDO swDO = null;
    int index = 0;
    GoldReport gReport = null;
    EthSwitchImpl eswImpl = null;
    String username = null;
    String password = null;
    CountDownLatch latch = null;
    Long switch_id = null;

    public DiagnosticExecutor(SwitchDO swDO, EthSwitchImpl eswImpl, GoldReport report, CountDownLatch latch) {
        this.swDO = swDO;
        this.gReport = report;
        this.eswImpl = eswImpl;
        this.switch_id = eswImpl.getDBID();
        this.latch = latch;
    }

    public DiagnosticExecutor(SwitchDO swDO, String username, String password, Long switch_id, GoldReport report, CountDownLatch latch) {
        this.swDO = swDO;
        this.gReport = report;
        this.username = username;
        this.password = password;
        this.switch_id = switch_id;
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() {
        IGoldDiagAdapter adapter;
        String ip;
        StopWatch sw;
        block52: {
            Set<Integer> keys;
            HashMap<Integer, String> moduleMap;
            GoldDO gDO;
            block53: {
                String i$;
                block54: {
                    String rs;
                    block50: {
                        String ex2;
                        block51: {
                            block48: {
                                String string;
                                block49: {
                                    sw = new StopWatch();
                                    ip = null;
                                    adapter = null;
                                    sw.start();
                                    this.swDO.setLinkName("#Switch_" + this.swDO.getName());
                                    ip = this.swDO.getIpAddress();
                                    _Tracer.log(Level.INFO, "Running Diagnostic Executor for IP: " + ip + " with switch_id: " + this.switch_id);
                                    if (this.eswImpl != null) {
                                        adapter = new GoldDiagAdapter(this.eswImpl);
                                    } else if (this.username != null && this.password != null) {
                                        adapter = new GoldDiagAdapter(ip, this.username, this.password);
                                    }
                                    _Tracer.log(Level.INFO, "Fetched the Adapter for IP: " + ip + " with switch_id: " + this.switch_id);
                                    if (adapter != null) break block48;
                                    string = "Could not get Adapter in DiagnosticExecutor for ip: " + ip;
                                    sw.stop();
                                    _Tracer.log(Level.INFO, "Time taken by ip: " + ip + " with switch_id: " + this.switch_id + " is: " + sw.getElapsedTimeInSeconds());
                                    this.latch.countDown();
                                    if (adapter == null) break block49;
                                    try {
                                        adapter.close();
                                    }
                                    catch (Exception ex2) {
                                        _Tracer.log(Level.ERROR, "Exception while closing Adapter connection for ip: " + ip + " with switch_id: " + this.switch_id + " -> " + ex2.getMessage());
                                    }
                                }
                                return string;
                            }
                            rs = adapter.showModuleDiagnosticAll();
                            _Tracer.log(Level.INFO, "Got module diagnostic result command output for IP: " + ip + " with switch_id: " + this.switch_id);
                            if (rs != null) break block50;
                            ex2 = "Exception while running GOLD query in DiagnosticExecutor for ip: " + ip;
                            sw.stop();
                            _Tracer.log(Level.INFO, "Time taken by ip: " + ip + " with switch_id: " + this.switch_id + " is: " + sw.getElapsedTimeInSeconds());
                            this.latch.countDown();
                            if (adapter == null) break block51;
                            try {
                                adapter.close();
                            }
                            catch (Exception ex3) {
                                _Tracer.log(Level.ERROR, "Exception while closing Adapter connection for ip: " + ip + " with switch_id: " + this.switch_id + " -> " + ex3.getMessage());
                            }
                        }
                        return ex2;
                    }
                    gDO = null;
                    int numberOfFaultyModules = 0;
                    GoldReport goldReport = this.gReport;
                    synchronized (goldReport) {
                        this.gReport.addSwitchMap(ip, new GoldDO());
                        this.gReport.addSwitch(this.swDO);
                        this.gReport.generate(ip, rs);
                        gDO = this.gReport.getSwitchMap().get(ip);
                        if (gDO != null && (numberOfFaultyModules = gDO.getModuleTestStatusMap().size()) > 0) {
                            _Tracer.log(Level.INFO, "Faulty modules present for IP: " + ip + " with switch_id: " + this.switch_id);
                            _Tracer.log(Level.INFO, "Number of Faulty modules for IP: " + ip + " with switch_id: " + this.switch_id + " is: " + numberOfFaultyModules);
                            int index = this.gReport.getIndex();
                            Integer i = new Integer(index);
                            gDO.setIndex(i.toString());
                            this.gReport.setIndex(index + 1);
                        }
                    }
                    if (gDO == null || numberOfFaultyModules <= 0) break block52;
                    gDO.setSwitchName(this.swDO.getName());
                    Integer num = new Integer(numberOfFaultyModules);
                    gDO.setNumberOfFaultyModules(num.toString());
                    moduleMap = this.getModules(gDO.getModuleTestStatusMap().keySet());
                    String faultyModules = "";
                    keys = moduleMap.keySet();
                    for (Integer modNum : keys) {
                        String moduleName = moduleMap.get(modNum).trim();
                        faultyModules = faultyModules + modNum + "(" + moduleName + "), ";
                    }
                    if (faultyModules.length() > 0) {
                        faultyModules = faultyModules.trim();
                        faultyModules = faultyModules.substring(0, faultyModules.length() - 1);
                    } else {
                        faultyModules = "-";
                    }
                    gDO.setFaultyModules(faultyModules);
                    if (!faultyModules.equals("-")) break block53;
                    i$ = "No Faulty Modules in DiagnosticExecutor for ip: " + ip;
                    sw.stop();
                    _Tracer.log(Level.INFO, "Time taken by ip: " + ip + " with switch_id: " + this.switch_id + " is: " + sw.getElapsedTimeInSeconds());
                    this.latch.countDown();
                    if (adapter == null) break block54;
                    try {
                        adapter.close();
                    }
                    catch (Exception ex) {
                        _Tracer.log(Level.ERROR, "Exception while closing Adapter connection for ip: " + ip + " with switch_id: " + this.switch_id + " -> " + ex.getMessage());
                    }
                }
                return i$;
            }
            try {
                keys = gDO.getModuleTestMap().keySet();
                for (Integer modNum : keys) {
                    String failedTests = "";
                    String errorDisabledTests = "";
                    if (!gDO.getModuleTestStatusMap().containsKey(modNum)) continue;
                    GoldModuleDO moduleDO = new GoldModuleDO();
                    String moduleName = moduleMap.get(modNum).trim();
                    moduleDO.setModuleName(modNum + "(" + moduleName + ")");
                    Set<String> testNames = gDO.getModuleTestMap().get(modNum).keySet();
                    for (String test : testNames) {
                        String status = gDO.getModuleTestMap().get(modNum).get(test);
                        if (status.equals("Fail")) {
                            failedTests = failedTests + test + ", ";
                            continue;
                        }
                        if (!status.equals("Error disabled")) continue;
                        errorDisabledTests = errorDisabledTests + test + ", ";
                    }
                    Set<String> portTestNames = gDO.getModulePortTestMap().get(modNum).keySet();
                    for (String test : portTestNames) {
                        String tempFailedTests = new String(failedTests);
                        String tempErrorDisabledTests = new String(errorDisabledTests);
                        List<String> ports = gDO.getModulePortTestMap().get(modNum).get(test);
                        int portNum = 1;
                        boolean failed = false;
                        boolean errorDisabled = false;
                        for (String portStatus : ports) {
                            if (portStatus.equals("Fail")) {
                                if (!failed) {
                                    failedTests = failedTests + test + "(" + portNum + ",";
                                    failed = true;
                                } else {
                                    failedTests = failedTests + portNum + ",";
                                }
                            } else if (portStatus.equals("Error disabled")) {
                                if (!errorDisabled) {
                                    errorDisabledTests = errorDisabledTests + test + "(" + portNum + ",";
                                    errorDisabled = true;
                                } else {
                                    errorDisabledTests = errorDisabledTests + portNum + ",";
                                }
                            }
                            ++portNum;
                        }
                        if (!tempFailedTests.equals(failedTests)) {
                            failedTests = failedTests.trim();
                            failedTests = failedTests.substring(0, failedTests.length() - 1) + "), ";
                        }
                        if (tempErrorDisabledTests.equals(errorDisabledTests)) continue;
                        errorDisabledTests = errorDisabledTests.trim();
                        errorDisabledTests = errorDisabledTests.substring(0, errorDisabledTests.length() - 1) + "), ";
                    }
                    if (failedTests.length() > 0) {
                        failedTests = failedTests.trim();
                        failedTests = failedTests.substring(0, failedTests.length() - 1);
                    } else {
                        failedTests = "-";
                    }
                    if (errorDisabledTests.length() > 0) {
                        errorDisabledTests = errorDisabledTests.trim();
                        errorDisabledTests = errorDisabledTests.substring(0, errorDisabledTests.length() - 1);
                    } else {
                        errorDisabledTests = "-";
                    }
                    moduleDO.setFailedTests(failedTests);
                    moduleDO.setErrorDisabledTests(errorDisabledTests);
                    gDO.addModule(moduleDO);
                }
            }
            catch (Exception ex) {
                String string;
                block55: {
                    try {
                        _Tracer.log(Level.ERROR, "Exception caught in DiagnosticExecutor for ip: " + ip + " with switch_id: " + this.switch_id + " -> " + ex.getMessage());
                        string = "Exception caught in DiagnosticExecutor for ip: " + ip;
                        sw.stop();
                        _Tracer.log(Level.INFO, "Time taken by ip: " + ip + " with switch_id: " + this.switch_id + " is: " + sw.getElapsedTimeInSeconds());
                        this.latch.countDown();
                        if (adapter == null) break block55;
                    }
                    catch (Throwable throwable) {
                        sw.stop();
                        _Tracer.log(Level.INFO, "Time taken by ip: " + ip + " with switch_id: " + this.switch_id + " is: " + sw.getElapsedTimeInSeconds());
                        this.latch.countDown();
                        if (adapter != null) {
                            try {
                                adapter.close();
                            }
                            catch (Exception ex4) {
                                _Tracer.log(Level.ERROR, "Exception while closing Adapter connection for ip: " + ip + " with switch_id: " + this.switch_id + " -> " + ex4.getMessage());
                            }
                        }
                        throw throwable;
                    }
                    try {
                        adapter.close();
                    }
                    catch (Exception ex5) {
                        _Tracer.log(Level.ERROR, "Exception while closing Adapter connection for ip: " + ip + " with switch_id: " + this.switch_id + " -> " + ex5.getMessage());
                    }
                }
                return string;
            }
        }
        sw.stop();
        _Tracer.log(Level.INFO, "Time taken by ip: " + ip + " with switch_id: " + this.switch_id + " is: " + sw.getElapsedTimeInSeconds());
        this.latch.countDown();
        if (adapter != null) {
            try {
                adapter.close();
            }
            catch (Exception ex) {
                _Tracer.log(Level.ERROR, "Exception while closing Adapter connection for ip: " + ip + " with switch_id: " + this.switch_id + " -> " + ex.getMessage());
            }
        }
        return "Exception Successful in DiagnosticExecutor for ip: " + ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HashMap<Integer, String> getModules(Set<Integer> keySet) {
        HashMap<Integer, String> moduleMap = new HashMap<Integer, String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            for (Integer key : keySet) {
                block11: {
                    int modNum = key;
                    try {
                        String moduleQuery = "SELECT MODEL_NAME FROM HW_COMPONENT WHERE SWITCH_ID=" + this.switch_id + " AND RELATIVE_POSITION=" + modNum + " AND HW_TYPE=9";
                        stmt = con.prepareStatement(moduleQuery);
                        rs = stmt.executeQuery();
                        boolean modulePresent = false;
                        while (rs.next()) {
                            String model_name = rs.getString(1);
                            moduleMap.put(key, model_name);
                            modulePresent = true;
                        }
                        if (modulePresent) break block11;
                        _Tracer.log(Level.ERROR, "Could not fetch Module name from HW_COMPONENT for module number: " + modNum + " of switch id: " + this.switch_id);
                    }
                    catch (SQLException ex) {
                        try {
                            _Tracer.log(Level.ERROR, "Exception in running SQL query to table: HW_COMPONENT for module number: " + modNum + " of switch id: " + this.switch_id);
                        }
                        catch (Throwable throwable) {
                            DbUtil.close(rs);
                            DbUtil.close(stmt);
                            throw throwable;
                            return moduleMap;
                        }
                        DbUtil.close(rs);
                        DbUtil.close(stmt);
                        continue;
                    }
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        catch (Exception ex) {
            _Tracer.log(Level.ERROR, "Exception in getting SQL connection to table: HW_COMPONENT of switch id: " + this.switch_id);
            return moduleMap;
        }
        finally {
            DbUtil.close(con);
        }
    }
}

