/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.web.report.ColumnSet;
import com.cisco.dcbu.sm.server.web.report.DiagnosticModuleDetailReport;
import com.cisco.dcbu.sm.server.web.report.DiagnosticSimpleTextReport;
import com.cisco.dcbu.sm.server.web.report.DiagnosticSwitchDetailReport;
import com.cisco.dcbu.sm.server.web.report.DiagnosticTocReport;
import com.cisco.dcbu.sm.server.web.report.GoldDO;
import com.cisco.dcbu.sm.server.web.report.GoldModuleDO;
import com.cisco.dcbu.sm.server.web.report.GoldReport;
import com.cisco.dcbu.sm.server.web.report.GoldReportHelper;
import com.cisco.dcbu.sm.server.web.report.ReportInfo;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DiagnosticRawTextReport
extends ReportInfo {
    private Logger _Log = Logger.getLogger((String)"fms.lanReport");
    private Collection detailList;
    private String markingLink;
    private String note;
    private String switchName;
    private Collection headers;
    protected Collection<ColumnSet> columnSets = null;
    private boolean _HasHeader = false;
    private int _HeaderType = 0;
    private GoldReport gReport = new GoldReport();
    private String scopeXML;
    private int totalSwitches = 0;
    private DiagnosticTocReport tocReport;
    private GoldReportHelper reportHelper = null;
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.disc"), false, false, false, false);

    public int getHeaderType() {
        return this._HeaderType;
    }

    public void setHeaderType(int headerType) {
        this._HeaderType = headerType;
    }

    public DiagnosticRawTextReport(Object[] objs) {
        super("");
        if (objs == null || objs.length < 3) {
            throw new RuntimeException("Construction error, the data passed in is in wrong format.");
        }
        this.setName((String)objs[1]);
        this.markingLink = (String)objs[0];
        if (this.markingLink != null && this.markingLink.startsWith("#")) {
            this.markingLink = this.markingLink.substring(1);
            if (this.markingLink.length() > 0) {
                this.setAnchor(this.markingLink);
            }
        }
        this.note = (String)objs[2];
        this.switchName = (String)objs[3];
        this.scopeXML = (String)objs[4];
        this.reportHelper = new GoldReportHelper();
    }

    public String getMarkingLink() {
        return this.markingLink;
    }

    @Override
    public int getReportType() {
        return 5;
    }

    public void setHeaders(Collection headers) {
        this.headers = headers;
    }

    @Override
    public Collection getColumns() {
        return this.headers;
    }

    public void setHasHeader(boolean b) {
        this._HasHeader = b;
    }

    public boolean isHasHeader() {
        return this._HasHeader;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public String getSwitchName() {
        return this.switchName;
    }

    @Override
    public Collection getDataList() {
        if (this.dataList == null) {
            try {
                this.dataList = new ArrayList();
                boolean isLan = (Boolean)this.getFilterValue("Is_Lan");
                boolean isGroup = (Boolean)this.getFilterValue("Is_Group");
                if (!isLan && !isGroup) {
                    this.getLanAndSanSwitches();
                } else if (isLan) {
                    this.getLanSwitches();
                } else if (isGroup) {
                    this.getSanSwitches();
                }
                this.detailList = new ArrayList();
                this.populateDetailList();
            }
            catch (Exception e) {
                this._Log.warn((Object)e.getMessage(), (Throwable)e);
                this.handleException(e);
                this.dataList = new ArrayList();
            }
        }
        return this.dataList;
    }

    @Override
    public List<String[]> getTocContent() {
        return this.tocReport.getTocContent();
    }

    @Override
    public Collection getDetails() {
        return this.detailList;
    }

    private void populateDetailList() throws Exception {
        ArrayList<GoldDO> rstList;
        _Tracer.log(Level.INFO, "Done fetching Report data. Populating Details...");
        this.tocReport = new DiagnosticTocReport(this.gReport);
        this.detailList.add(this.tocReport);
        int totalModules = 0;
        int faultyModules = 0;
        Set<String> keys = this.gReport.getSwitchMap().keySet();
        for (String key : keys) {
            GoldDO gDO = this.gReport.getSwitchMap().get(key);
            if (gDO.getModuleTestStatusMap().size() <= 0) continue;
            ++this.totalSwitches;
            totalModules += gDO.getModuleNameMap().size();
            faultyModules += Integer.parseInt(gDO.getNumberOfFaultyModules());
        }
        _Tracer.log(Level.INFO, "Total # of Switches : " + this.totalSwitches);
        if (this.totalSwitches > 0) {
            String note = "Total # of Switches : " + this.totalSwitches;
            note = note + "\n\n" + "Total # of Modules : " + totalModules + "   Total # of Faulty Modules : " + faultyModules;
            _Tracer.log(Level.INFO, note);
            DiagnosticSimpleTextReport simpleTextReportHolder = new DiagnosticSimpleTextReport(new Object[]{"", "", note, ""});
            this.detailList.add(simpleTextReportHolder);
        }
        if (this.totalSwitches > 0) {
            rstList = new ArrayList<GoldDO>();
            ArrayList<SwitchDO> switches = this.gReport.getSwitches();
            for (SwitchDO sw : switches) {
                String ipAddress = sw.getIpAddress();
                GoldDO goldDO = this.gReport.getSwitchMap().get(ipAddress);
                if (goldDO == null || goldDO.getModuleTestStatusMap().size() <= 0) continue;
                rstList.add(goldDO);
            }
            _Tracer.log(Level.INFO, "Populating summary table");
            DiagnosticSwitchDetailReport switchReportHolder = new DiagnosticSwitchDetailReport(new Object[]{"", "Summary Table", rstList, ""});
            switchReportHolder.setHeaders(GoldDO.getColumns());
            this.detailList.add(switchReportHolder);
            _Tracer.log(Level.INFO, "Completed populating summary table");
            _Tracer.log(Level.INFO, "Populating Device speicific tables");
            rstList = new ArrayList();
            for (SwitchDO sw : switches) {
                String swName = sw.getName();
                String ipAddress = sw.getIpAddress();
                GoldDO goldDO = this.gReport.getSwitchMap().get(ipAddress);
                if (goldDO == null || goldDO.getModuleTestStatusMap().size() <= 0 || goldDO.getModules().size() <= 0) continue;
                ArrayList<GoldModuleDO> tempList = new ArrayList<GoldModuleDO>();
                tempList.addAll(goldDO.getModules());
                DiagnosticModuleDetailReport moduleReportHolder = new DiagnosticModuleDetailReport(new Object[]{"#Switch_" + swName, swName, tempList, ""});
                moduleReportHolder.setHeaders(GoldModuleDO.getModuleColumns());
                this.detailList.add(moduleReportHolder);
            }
            _Tracer.log(Level.INFO, "Completed populating device specific tables");
        } else {
            rstList = new ArrayList();
            _Tracer.log(Level.INFO, "No switches with faulty modules");
            GoldDO gDO = new GoldDO();
            gDO.setIndex("");
            gDO.setSwitchName("");
            gDO.setFaultyModules("");
            gDO.setNumberOfFaultyModules("");
            rstList.add(gDO);
            DiagnosticSwitchDetailReport switchReportHolder = new DiagnosticSwitchDetailReport(new Object[]{"", "Summary Table", rstList, ""});
            switchReportHolder.setHeaders(GoldDO.getColumns());
            this.detailList.add(switchReportHolder);
        }
    }

    @Override
    public boolean getShowFilter() {
        return true;
    }

    @Override
    public Collection getColumnSets() {
        if (this.columnSets == null) {
            if (this.columns == null) {
                this.getColumns();
            }
            this.columnSets = new ArrayList<ColumnSet>();
            ColumnSet set = null;
            Iterator itr = this.columns.iterator();
            set = DisplayUtil.initSet(itr, this.columns.size(), "");
            this.columnSets.add(set);
        }
        return this.columnSets;
    }

    private void getLanSwitches() {
        try {
            String[] lanSwIdArr;
            ArrayList<SwitchDO> rstList = new ArrayList<SwitchDO>();
            long swId = -1L;
            String lanSwIdsInStr = NavigationUtil.getInstance().getEntitiesInGroup(this.scopeXML, 1);
            for (String lanSwId : lanSwIdArr = lanSwIdsInStr.split(",")) {
                swId = Long.parseLong(lanSwId);
                if (swId < 0L) continue;
                rstList.add(NavigationUtil.getInstance().getLanSwitchDetail(swId));
            }
            _Tracer.log(Level.INFO, "Fetched LAN SwitchDO list");
            ArrayList<SwitchDO> toRemoveList = new ArrayList<SwitchDO>();
            for (SwitchDO swDO : rstList) {
                String ip = swDO.getIpAddress();
                if (ip == null || !ip.isEmpty()) continue;
                toRemoveList.add(swDO);
            }
            if (toRemoveList.size() > 0) {
                rstList.removeAll(toRemoveList);
            }
            this.reportHelper.execute(this.gReport, rstList, true, false);
        }
        catch (Exception e) {
            _Tracer.log(Level.ERROR, "Exception caught in getLanSwitches: " + e.getMessage());
        }
    }

    private void getSanSwitches() {
        try {
            ArrayList<SwitchDO> rstList = new ArrayList<SwitchDO>();
            String fidsInStr = NavigationUtil.getInstance().getEntitiesInGroup(this.scopeXML, 0);
            String[] fidArr = fidsInStr.split(",");
            long swId = -1L;
            for (String fidStr : fidArr) {
                swId = Long.parseLong(fidStr);
                if (swId < 0L) continue;
                rstList.addAll(NavigationUtil.getInstance().getSwitchList(swId));
            }
            _Tracer.log(Level.INFO, "Fetched SAN SwitchDO list");
            ArrayList<SwitchDO> toRemoveList = new ArrayList<SwitchDO>();
            for (SwitchDO swDO : rstList) {
                String ip = swDO.getIpAddress();
                if (ip == null || !ip.isEmpty()) continue;
                toRemoveList.add(swDO);
            }
            if (toRemoveList.size() > 0) {
                rstList.removeAll(toRemoveList);
            }
            this.reportHelper.execute(this.gReport, rstList, false, true);
        }
        catch (Exception e) {
            _Tracer.log(Level.ERROR, "Exception caught in getSanSwitches: " + e.getMessage());
        }
    }

    private void getLanAndSanSwitches() {
        try {
            String[] fidArr;
            String[] lanSwIdArr;
            ArrayList<SwitchDO> rstList = new ArrayList<SwitchDO>();
            long swId = -1L;
            String lanSwIdsInStr = NavigationUtil.getInstance().getEntitiesInGroup(this.scopeXML, 1);
            for (String lanSwId : lanSwIdArr = lanSwIdsInStr.split(",")) {
                swId = Long.parseLong(lanSwId);
                if (swId < 0L) continue;
                rstList.add(NavigationUtil.getInstance().getLanSwitchDetail(swId));
            }
            _Tracer.log(Level.INFO, "Fetched LAN SwitchDO list");
            String fidsInStr = NavigationUtil.getInstance().getEntitiesInGroup(this.scopeXML, 0);
            for (String fidStr : fidArr = fidsInStr.split(",")) {
                swId = Long.parseLong(fidStr);
                if (swId < 0L) continue;
                rstList.addAll(NavigationUtil.getInstance().getSwitchList(swId));
            }
            _Tracer.log(Level.INFO, "Fetched SAN SwitchDO list");
            ArrayList<SwitchDO> toRemoveList = new ArrayList<SwitchDO>();
            for (SwitchDO swDO : rstList) {
                String ip = swDO.getIpAddress();
                if (ip == null || !ip.isEmpty()) continue;
                toRemoveList.add(swDO);
            }
            if (toRemoveList.size() > 0) {
                rstList.removeAll(toRemoveList);
            }
            _Tracer.log(Level.INFO, "Triggering Execution for Gold Report now...");
            this.reportHelper.execute(this.gReport, rstList, true, true);
        }
        catch (Exception e) {
            _Tracer.log(Level.ERROR, "Exception caught in getLanAndSanSwitches: " + e.getMessage());
        }
    }
}

