/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.web.report.GoldDO;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class GoldParser {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.disc"), false, false, false, false);

    void parse(GoldDO goldDO, String output) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(output.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String currentBootLevel = "Current bootup diagnostic level:";
            String diagnosticLevel = null;
            String input = this.getLine(br);
            while (input != null) {
                int module = 0;
                if (input.startsWith(currentBootLevel)) {
                    diagnosticLevel = input.substring(input.indexOf(currentBootLevel) + currentBootLevel.length(), input.length());
                }
                if ((input = this.getLine(br)) != null && input.contains("Module ")) {
                    int startIndex = input.indexOf("Module ") + "Module ".length();
                    int endIndex = input.indexOf(":");
                    try {
                        module = Integer.parseInt(input.substring(startIndex, endIndex).trim());
                        goldDO.addModuleDiagnosticLevelMap(module, diagnosticLevel);
                        startIndex = endIndex + 1;
                        endIndex = input.length();
                        String moduleName = input.substring(startIndex, endIndex);
                        goldDO.addModuleNameMap(module, moduleName);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if ((input = this.getLine(br)) != null && input.contains("Test results: (. = Pass, F = Fail, I = Incomplete,")) {
                    input = this.getLine(br);
                }
                HashMap<String, String> testMap = new HashMap<String, String>();
                input = this.getLine(br);
                while (input != null && input.contains("->")) {
                    int startIndex = input.indexOf(")") + 1;
                    int endIndex = input.indexOf("-");
                    String testName = input.substring(startIndex, endIndex).trim();
                    startIndex = input.indexOf(">") + 1;
                    String status = this.getTestStatus(input.substring(startIndex, endIndex = input.length()).trim());
                    if (status.equals("Fail") || status.equals("Error disabled")) {
                        goldDO.addModuleTestStatusMap(module, status);
                    }
                    testMap.put(testName, status);
                    input = this.getLine(br);
                }
                goldDO.addModuleTestMap(module, testMap);
                HashMap<String, List<String>> portTestMap = new HashMap<String, List<String>>();
                while (input != null && !input.startsWith(currentBootLevel) && input.contains(":")) {
                    int startIndex = input.indexOf(")") + 1;
                    int endIndex = input.indexOf(":");
                    String testName = input.substring(startIndex, endIndex).trim();
                    ArrayList<String> testStatusList = new ArrayList<String>();
                    input = this.getLine(br);
                    while (input != null && input.startsWith("Port")) {
                        input = this.getLine(br);
                        input = this.getLine(br);
                        StringTokenizer str = new StringTokenizer(input, " ");
                        while (str.hasMoreTokens()) {
                            String status = this.getTestStatus(str.nextToken().trim());
                            if (status.equals("Fail") || status.equals("Error disabled")) {
                                goldDO.addModuleTestStatusMap(module, status);
                            }
                            testStatusList.add(status);
                        }
                        input = this.getLine(br);
                    }
                    portTestMap.put(testName, testStatusList);
                }
                goldDO.addModulePortTestMap(module, portTestMap);
            }
            br.close();
        }
        catch (Exception ex) {
            _Tracer.log(Level.ERROR, "Exception caught in GoldParser parsing: " + ex.getMessage());
        }
    }

    String getLine(BufferedReader br) {
        try {
            String input = br.readLine();
            while (input != null && input.length() == 0) {
                input = br.readLine();
            }
            if (input != null) {
                return input.trim();
            }
        }
        catch (Exception ex) {
            _Tracer.log(Level.ERROR, "Exception caught in GoldParser getLine: " + ex.getMessage());
        }
        return null;
    }

    String getTestStatus(String status) {
        if (status.equals(".")) {
            return "Pass";
        }
        if (status.equals("F")) {
            return "Fail";
        }
        if (status.equals("I")) {
            return "Incomplete";
        }
        if (status.equals("U")) {
            return "Untested";
        }
        if (status.equals("A")) {
            return "Abort";
        }
        if (status.equals("E")) {
            return "Error disabled";
        }
        return null;
    }
}

