/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.jaxws.san.wo.ModuleDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.sm.common.model.TableColumn;
import com.cisco.dcbu.sm.server.web.inventory.LicenseHandler;
import com.cisco.dcbu.sm.server.web.inventory.ModuleHandler;
import com.cisco.dcbu.sm.server.web.inventory.SwitchHandler;
import com.cisco.dcbu.sm.server.web.report.ColumnSet;
import com.cisco.dcbu.sm.server.web.report.LanSwitchDetailReport;
import com.cisco.dcbu.sm.server.web.report.ReportInfo;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class LanSwitchReport
extends ReportInfo {
    private Collection detailList;
    private Logger _Log = Logger.getLogger((String)"fms.lanReport");
    protected Collection<ColumnSet> columnSets = null;
    private Collection licTableColumns = null;

    public LanSwitchReport(String reportName) {
        super(reportName);
    }

    public LanSwitchReport(String reportName, boolean showDetails) {
        super(reportName);
    }

    @Override
    public int getReportType() {
        return 1;
    }

    @Override
    public String getWrapperClass() {
        return "com.cisco.dcbu.jaxws.san.wo.SwitchDO";
    }

    @Override
    public Collection getColumns() {
        if (this.columns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("Name", "logicalName"), new TableColumn("IP Address", "ipAddress"), new TableColumn("Chassis Id", "serialNumber"), new TableColumn("Used Ports", "usedPortsStr", 1, 3), new TableColumn("Avail Ports", "availPortsStr"), new TableColumn("Total Ports", "numberOfPortsStr"), new TableColumn("Status", "status"), new TableColumn("Vendor", "vendor"), new TableColumn("Model", "model"), new TableColumn("Release", "release"), new TableColumn("Location", "location"), new TableColumn("Contact", "contact"), new TableColumn("UpTime", "upTimeStr", 2, true)};
            this.columns = Arrays.asList(tCols);
        }
        return this.columns;
    }

    private Collection getLicenseTableColumns() {
        if (this.licTableColumns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("", "index"), new TableColumn("Switch", "switch"), new TableColumn("Feature", "feature"), new TableColumn("Status", "status"), new TableColumn("Type", "type"), new TableColumn("Warnings", "warnings")};
            this.licTableColumns = Arrays.asList(tCols);
        }
        return this.licTableColumns;
    }

    @Override
    public Collection getDataList() {
        if (this.dataList == null) {
            try {
                long lanGroupId = (Long)this.getFilterValue("Lan_Group_Id");
                this.dataList = SwitchHandler.getInstance().getLanSwitchList(lanGroupId);
                this.detailList = new ArrayList();
                this.populateDetailList();
            }
            catch (Exception e) {
                this._Log.warn((Object)e.getMessage(), (Throwable)e);
                this.handleException(e);
                this.dataList = new ArrayList();
            }
        }
        return this.dataList;
    }

    private void populateDetailList() throws Exception {
        for (Object swObj : this.dataList) {
            SwitchDO swDo = (SwitchDO)swObj;
            long switchId = swDo.getSwitchDbID();
            if (swDo.getLinkName() == null) continue;
            List rstList = ModuleHandler.getInstance().getLanModuleBySwitch(switchId);
            LanSwitchDetailReport reportHolder = new LanSwitchDetailReport(new Object[]{"#Modules_" + switchId, "Modules", rstList, swDo.getLogicalName()});
            reportHolder.setHeaders(ModuleDO.getColumns());
            this.detailList.add(reportHolder);
            DbFilterDO dbFilter = new DbFilterDO();
            dbFilter.setNetworkType("LAN");
            dbFilter.setSwitchDbId(switchId);
            DBEntryDO licEntryDo = LicenseHandler.getInstance().getList(dbFilter);
            if (licEntryDo.getRows().length <= 0) continue;
            ArrayList<DBEntryDO> dataObjects = new ArrayList<DBEntryDO>();
            dataObjects.add(licEntryDo);
            reportHolder = new LanSwitchDetailReport(new Object[]{null, "Licenses", dataObjects, swDo.getLogicalName()});
            reportHolder.setHeaders(this.getLicenseTableColumns());
            this.detailList.add(reportHolder);
        }
    }

    @Override
    public Collection getDetails() {
        return this.detailList;
    }

    @Override
    public String getNote() {
        return null;
    }

    @Override
    public boolean getShowFilter() {
        return true;
    }

    @Override
    public Collection getColumnSets() {
        if (this.columnSets == null) {
            if (this.columns == null) {
                this.getColumns();
            }
            this.columnSets = new ArrayList<ColumnSet>();
            ColumnSet set = null;
            Iterator itr = this.columns.iterator();
            set = DisplayUtil.initSet(itr, this.columns.size(), "");
            this.columnSets.add(set);
        }
        return this.columnSets;
    }
}

