/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.util;

import com.cisco.dcbu.jaxws.san.wo.EndPortDO;
import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneMemberFormat;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.PropertyWrapper;
import com.cisco.dcbu.lib.util.ReportUtil;
import com.cisco.dcbu.sm.common.model.NameValuePair;
import com.cisco.dcbu.sm.common.model.TableColumn;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.web.report.ColumnSet;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class DisplayUtil {
    public static final String EXPORT_UNITLESS = "export.unitless";
    public static final String EXPORT_UNIT = "export.unit";
    public static final int STANDBY_HOT = 9;
    private static final DecimalFormat NUM_FORMAT = new DecimalFormat("0");
    private static final DecimalFormat NUM_FORMAT_Three_Decimal = new DecimalFormat("0.000");

    public static Wwn getWwn(byte[] w) {
        if (w != null) {
            return new Wwn(w);
        }
        return null;
    }

    public static String getFormattedFcId(int fcid) {
        String str = Integer.toHexString(fcid);
        int length = str.length();
        switch (length) {
            case 0: {
                str = "000000";
            }
            case 1: {
                str = "00000" + str;
            }
            case 2: {
                str = "0000" + str;
            }
            case 3: {
                str = "0000" + str;
            }
            case 4: {
                str = "00" + str;
            }
            case 5: {
                str = "0" + str;
            }
        }
        return "0x" + str;
    }

    public static String formatSpeed(long l) {
        double d = 0.0;
        String suffix = null;
        if (l >= 1000000000L) {
            d = (double)l / 1.0E9;
            suffix = "Gb";
        } else if (l >= 1000000L) {
            d = (double)l / 1000000.0;
            suffix = "Mb";
        } else if (l >= 1000L) {
            d = (double)l / 1000.0;
            suffix = "Kb";
        } else {
            d = l;
            suffix = "b";
        }
        if (suffix != null) {
            return NUM_FORMAT.format(d) + suffix;
        }
        return Long.toString(l);
    }

    public static String getEndPortStatus(boolean isPresent, int operStatusCause, long lastScanTime) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("kk:mm MM/dd/yyyy z ");
        String tstamp = dateFmt.format(lastScanTime);
        if (!isPresent) {
            return "Link not connected, " + tstamp;
        }
        if (operStatusCause != 2) {
            return MibVariableFormat.toCauseString(operStatusCause) + "," + tstamp;
        }
        return "ok";
    }

    public static ColumnSet initSet(Iterator itr, int round, String header) {
        TableColumn[] columnArray = new TableColumn[round];
        ColumnSet set = new ColumnSet();
        for (int i = 0; i < round; ++i) {
            columnArray[i] = (TableColumn)itr.next();
        }
        set.setHeader(header);
        set.setColumnSet(Arrays.asList(columnArray));
        return set;
    }

    public static String getNpvLinkOperStatusCause(int operStatusCause, boolean isPresent, long lastSeen) {
        if (!isPresent) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(lastSeen));
        }
        if (operStatusCause == 108) {
            return "Trunk Not Fully Active";
        }
        if (operStatusCause != 2) {
            return "unknown";
        }
        return "ok";
    }

    public static String getZoneMemberId(int memberType, byte[] memberId) {
        String name = "";
        switch (memberType) {
            case 1: 
            case 11: {
                name = SnmpString.toHexString(memberId);
                break;
            }
            case 3: 
            case 12: {
                name = SnmpFcAddressId.toHexString(memberId);
                break;
            }
            case 2: {
                name = "0x" + Integer.toHexString(0xFF & memberId[0]) + ", port:0x" + Integer.toHexString(0xFF & memberId[1]);
                break;
            }
            case 4: {
                name = SnmpString.toHexString(memberId);
                break;
            }
            case 5: {
                name = new String(memberId);
                break;
            }
            case 6: {
                byte[] b2 = null;
                if (memberId.length > 4 && memberId.length <= 12) {
                    b2 = new byte[8];
                    System.arraycopy(memberId, 4, b2, 0, 8);
                }
                String swwn = null;
                if (b2 != null) {
                    swwn = SnmpString.toHexString(b2);
                }
                if (swwn != null) {
                    name = swwn + " " + IfIndexUtil.ifIndexToName(ZoneMemberFormat.getIfFormatIfIndex(memberId, 0));
                    break;
                }
                name = IfIndexUtil.ifIndexToName(ZoneMemberFormat.getIfFormatIfIndex(memberId, 0));
                break;
            }
            case 7: {
                int tmp = memberId[1] << 24 & 0xFF000000 | memberId[2] << 16 & 0xFF0000 | memberId[3] << 8 & 0xFF00 | memberId[4] & 0xFF;
                String fcid = IfIndexUtil.ifIndexToName(tmp);
                name = "0x" + Integer.toHexString(memberId[0] & 0xFF) + " port:" + fcid;
                break;
            }
            case 8: {
                byte[] add = new byte[4];
                byte[] mask = new byte[4];
                System.arraycopy(memberId, 0, add, 0, 4);
                if (memberId.length > 4) {
                    System.arraycopy(memberId, 4, mask, 0, 4);
                    name = SnmpIpAddress.toString(add) + "/" + SnmpIpAddress.toString(mask);
                    break;
                }
                name = SnmpIpAddress.toString(add);
                break;
            }
            default: {
                if (memberId == null) break;
                return new String(memberId);
            }
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public static String getZoneMemberWwn(int vsanId, int memberType, byte[] memberId, Hashtable table) {
        String memberName = DisplayUtil.getZoneMemberId(memberType, memberId);
        String name = "";
        block0 : switch (memberType) {
            case 10: {
                EndPortDO device = EndPortDO.getDeviceByAlias(table.values(), new String(memberId));
                if (device != null && device.getPortWwn() != null) {
                    name = device.getPortWwn().toString();
                    break;
                }
                name = "";
                break;
            }
            case 1: 
            case 11: {
                EndPortDO wr = (EndPortDO)table.get(memberName);
                if (wr != null) {
                    if (wr.getPortWwn() != null) {
                        name = wr.getPortWwn().toString();
                        break;
                    }
                    name = SnmpString.toHexString(memberId);
                    break;
                }
                name = SnmpString.toHexString(memberId);
                break;
            }
            case 3: 
            case 12: {
                Enumeration keys = table.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    EndPortDO wr1 = (EndPortDO)table.get(key);
                    if (wr1 == null || !wr1.getFcIdStr().equals(memberName) || wr1.getPortWwn() == null) continue;
                    name = wr1.getPortWwn().toString();
                    break block0;
                }
                break;
            }
            default: {
                name = "";
            }
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public static String getZoneMemberName(int vsanId, int memberType, byte[] memberId, Hashtable table) {
        String memberName = DisplayUtil.getZoneMemberId(memberType, memberId);
        String name = ZoneMember.getZoneMemberName(vsanId, memberType, memberId, null).toString();
        block0 : switch (memberType) {
            case 10: {
                EndPortDO device = EndPortDO.getDeviceByAlias(table.values(), new String(memberId));
                if (device == null) break;
                name = device.getAlias();
                break;
            }
            case 1: 
            case 11: {
                EndPortDO wr = (EndPortDO)table.get(memberName);
                if (wr == null) {
                    wr = EndPortDO.getDeviceByWwn(table.values(), memberId);
                }
                if (wr != null) {
                    name = wr.getPortWwn().toString();
                    if (wr.getAlias() == null || wr.getAlias().trim().length() <= 0) break;
                    name = wr.getAlias();
                    break;
                }
                if (name != null && name.trim().length() != 0) break;
                name = SnmpString.toHexString(memberId);
                break;
            }
            case 3: 
            case 12: {
                name = "";
                Enumeration enm = table.keys();
                while (enm.hasMoreElements()) {
                    Object key = enm.nextElement();
                    EndPortDO wr = (EndPortDO)table.get(key);
                    if (!wr.getFcIdStr().equals(SnmpFcAddressId.toHexString(memberId))) continue;
                    name = wr.getAlias();
                    break block0;
                }
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                name = SnmpString.toHexString(memberId);
                break;
            }
            case 5: {
                name = new String(memberId);
                break;
            }
            case 6: {
                byte[] b2 = null;
                if (memberId.length > 4 && memberId.length <= 12) {
                    b2 = new byte[8];
                    System.arraycopy(memberId, 4, b2, 0, 8);
                }
                String swwn = null;
                if (b2 != null) {
                    swwn = SnmpString.toHexString(b2);
                }
                if (swwn != null) {
                    name = swwn + " " + IfIndexUtil.ifIndexToName(ZoneMemberFormat.getIfFormatIfIndex(memberId, 0));
                    break;
                }
                name = IfIndexUtil.ifIndexToName(ZoneMemberFormat.getIfFormatIfIndex(memberId, 0));
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                byte[] add = new byte[4];
                byte[] mask = new byte[4];
                System.arraycopy(memberId, 0, add, 0, 4);
                if (memberId.length > 4) {
                    System.arraycopy(memberId, 4, mask, 0, 4);
                    name = SnmpIpAddress.toString(add) + "/" + SnmpIpAddress.toString(mask);
                    break;
                }
                name = SnmpIpAddress.toString(add);
                break;
            }
        }
        if (name == null || name.equals("null")) {
            name = "";
        }
        return name;
    }

    public static byte[] getByteLunArray(long l) {
        return ZoneMemberBase.getByteLunArray(l);
    }

    public static String getZoneMemberFcId(int memberType, byte[] id, Hashtable table) {
        String memberName = DisplayUtil.getZoneMemberId(memberType, id);
        String name = "";
        switch (memberType) {
            case 10: {
                EndPortDO device = EndPortDO.getDeviceByAlias(table.values(), new String(id));
                if (device == null) break;
                name = device.getFcIdStr();
                break;
            }
            case 1: 
            case 11: {
                EndPortDO wr = (EndPortDO)table.get(memberName);
                if (wr == null) {
                    wr = EndPortDO.getDeviceByWwn(table.values(), id);
                }
                if (wr == null) break;
                name = wr.getFcIdStr();
                break;
            }
            case 3: 
            case 12: {
                name = memberName;
            }
        }
        return name;
    }

    public static String getZoneMemberSwitchInterface(int memberType, byte[] id, Hashtable table, int vsan, Hashtable domainInfo) {
        String memberName = DisplayUtil.getZoneMemberId(memberType, id);
        String name = "";
        block0 : switch (memberType) {
            case 10: {
                EndPortDO device = EndPortDO.getDeviceByAlias(table.values(), new String(id));
                if (device == null) break;
                name = device.getSwitchInterface();
                break;
            }
            case 1: 
            case 11: {
                EndPortDO wr = (EndPortDO)table.get(memberName);
                if (wr == null) {
                    wr = EndPortDO.getDeviceByWwn(table.values(), id);
                }
                if (wr == null) break;
                name = wr.getSwitchInterface();
                break;
            }
            case 3: 
            case 12: {
                Enumeration keys = table.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    EndPortDO wr = (EndPortDO)table.get(key);
                    if (wr == null || !wr.getFcIdStr().equals(memberName)) continue;
                    name = wr.getSwitchInterface();
                    break block0;
                }
                break;
            }
            case 4: {
                byte[] wwn = IfIndexUtil.ifWwn2SwWwn(id);
                String tmp = SnmpString.toHexString(id);
                name = DisplayUtil.getSwitchFromWwn(wwn) + " " + tmp;
                break;
            }
            case 2: {
                name = memberName;
                break;
            }
            case 6: {
                byte[] ifIn = new byte[4];
                System.arraycopy(id, 0, ifIn, 0, ifIn.length);
                int index = SnmpIntList.valueOf(ifIn)[0];
                byte[] wwn = null;
                if (id.length == 12 || id.length == 10) {
                    wwn = new byte[8];
                    System.arraycopy(id, id.length - wwn.length, wwn, 0, wwn.length);
                }
                String tmp = IfIndexUtil.ifIndexToName(index);
                name = DisplayUtil.getSwitchFromWwn(wwn) + " " + tmp;
                break;
            }
            case 7: {
                int domainId = 0xFF & id[0];
                String ip = (String)domainInfo.get(vsan + ":" + domainId);
                int tmp = id[1] << 24 & 0xFF000000 | id[2] << 16 & 0xFF0000 | id[3] << 8 & 0xFF00 | id[4] & 0xFF;
                String fcid = IfIndexUtil.ifIndexToName(tmp);
                if (ip != null) {
                    name = ip + " " + fcid;
                    break;
                }
                name = memberName;
                break;
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSwitchFromWwn(byte[] wwn) {
        String ip = "";
        if (!SQLLoader.canExecute()) {
            return ip;
        }
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = null;
            sql = SQLLoader.getSql("ZoneAction.SWITCH_STMT");
            stmt = con.prepareStatement(sql);
            stmt.setBytes(1, wwn);
            rs = SQLLoader.execute((PreparedStatement)stmt);
            if (rs.next()) {
                byte[] b = rs.getBytes(1);
                String sysName = rs.getString(2);
                String addr = null;
                if (b != null) {
                    addr = InetAddress.getByAddress(b).getHostAddress();
                }
                ip = sysName != null ? sysName : addr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    ConnectionManager.returnConnection(con);
                }
            }
            catch (Exception re) {
                re.printStackTrace();
            }
        }
        return ip;
    }

    public static String getEthSwitchStatus(SwitchDO wrapper) {
        StringBuffer sb;
        String status = "";
        if (!wrapper.isPresent()) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(wrapper.getLastScanTime()));
        }
        StringBuffer msg = new StringBuffer();
        if (!wrapper.isManagable()) {
            if (wrapper.getIpAddress() == null) {
                return "No IP Address";
            }
            if (wrapper.getUnmanagableCause() != null) {
                return wrapper.getUnmanagableCause();
            }
        }
        if ((sb = new StringBuffer()).length() > 0) {
            sb.setLength(sb.length() - 1);
            status = sb.toString();
            return status;
        }
        status = "ok";
        return status;
    }

    public static String getEndPortStatus(boolean isPresent, int operStatusCause) {
        if (!isPresent) {
            return "Not Present";
        }
        if (operStatusCause != 2) {
            return MibVariableFormat.toCauseString(operStatusCause);
        }
        return "ok";
    }

    public static String getSearchCondition(String dbIdStr, String field) {
        return DisplayUtil.getSearchCondition(dbIdStr, field, null, null);
    }

    public static String getSearchCondition(String dbIdStr, String field, String dbDstIdStr, String dstField) {
        String condition = "";
        if (dbIdStr != null) {
            condition = " AND " + field + "=" + dbIdStr + " ";
        }
        if (dbDstIdStr != null) {
            condition = condition + " AND " + dstField + "=" + dbDstIdStr + " ";
        }
        return condition;
    }

    public static double formatPmStat(double value) {
        return DisplayUtil.formatPmStat(value, false);
    }

    public static double formatEthPmStat(double value) {
        return DisplayUtil.formatPmStat(value, true);
    }

    public static double formatPmStat(double value, boolean eth) {
        double formatValue = value < 0.0 ? Double.NaN : (eth ? value * 10.0 / 8.0 : value);
        formatValue = Math.floor(formatValue);
        return formatValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getGroupType(Connection con, long groupId) {
        int groupType;
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            stmt = null;
            String sql = null;
            rs = null;
            groupType = -1;
            try {
                sql = SQLLoader.getSqlStmt("Inventory.GROUP_TYPE");
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, groupId);
                rs = SQLLoader.execute(stmt);
                if (!rs.next()) break block4;
                groupType = rs.getInt(1);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return groupType;
    }

    public static String getSwitchModel(SwitchDO wrapper) {
        if (wrapper.getNonMdsModel() != null) {
            return wrapper.getNonMdsModel();
        }
        return DisplayUtil.getSwitchModelString(wrapper.getModelType(), wrapper.getSwWwn());
    }

    public static String getSwitchModelString(int type, WwnDO wwn) {
        String model = FRUConstants.getMDSModelName(type);
        if (model == null) {
            if (wwn != null) {
                model = WwnDictionary.getVendor(wwn.toWwn().getValue());
                return model == null ? "Other" : model;
            }
            return "Other";
        }
        return model;
    }

    public static String getSwitchVendor(SwitchDO wrapper) {
        String vendor = "";
        WwnDO wwn = wrapper.getSwWwn();
        vendor = WwnDictionary.isCiscoWwn(wwn.toWwn().getValue()) || DisplayUtil.isSN5428(wrapper) ? "Cisco" : WwnDictionary.getVendor(wwn.toWwn().getValue());
        return vendor;
    }

    public static boolean isSN5428(SwitchDO wrapper) {
        return wrapper.getModelType() == 475 || wrapper.getModelType() == 529;
    }

    public static boolean isMdsDirector(SwitchDO switchDo) {
        return switchDo.getModelType() == 375 || switchDo.getModelType() == 376 || switchDo.getModelType() == 377;
    }

    public static boolean isHotStandby(SwitchDO switchDo) {
        return switchDo.getStandbySupState() == 9;
    }

    public static boolean equal(byte[] wwn1, byte[] wwn2) {
        return SnmpString.toHexString(wwn1).equals(SnmpString.toHexString(wwn2));
    }

    public static String getIslOperStatusCause(int operStatusCause, boolean isPresent, long lastSeen) {
        return DisplayUtil.getIslOperStatusCause(operStatusCause, isPresent, 0, 0, lastSeen);
    }

    public static String getIslOperStatusCause(int operStatusCause, boolean isPresent, int total, int actual, long lastSeen) {
        if (!isPresent) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(lastSeen));
        }
        if (operStatusCause == 108) {
            return "Trunk Not Fully Active";
        }
        if (isPresent && total - actual > 0) {
            return total - actual + " member(s) down";
        }
        if (operStatusCause != 2) {
            return MibVariableFormat.toCauseString(operStatusCause);
        }
        return "ok";
    }

    public static String ifIndexToName(int index) {
        return IfIndexUtil.ifIndexToName(index);
    }

    public static String ifIndexToName(int index, int switchType) {
        if (FRUConstants.isN5K(switchType)) {
            return IfIndexUtil.ifIndexToNameForN5K(index, switchType);
        }
        switch (switchType) {
            case 601: {
                return IfIndexUtil.ifIndexToNameInagua(index);
            }
            case 606: 
            case 773: {
                return IfIndexUtil.ifIndexToNameChester(index);
            }
            case 843: {
                return IfIndexUtil.ifIndexToNameCassino(index);
            }
        }
        return IfIndexUtil.ifIndexToName(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<NameValuePair> getTemplatesFromDb() throws Exception {
        ArrayList<NameValuePair> tempList;
        block6: {
            tempList = new ArrayList<NameValuePair>();
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            String suffix = "";
            String queryTemplatesSql = "select document_name, user_name from xmlDocs";
            try {
                conn = ConnectionManager.getConnection();
                ps = conn.prepareStatement(queryTemplatesSql + suffix);
                rs = ps.executeQuery();
                String userName = null;
                String docName = null;
                while (rs.next()) {
                    docName = ReportUtil.formatTemplateName(rs.getString(1));
                    userName = rs.getString(2);
                    tempList.add(new NameValuePair(userName + "." + docName + "-localhost", ReportUtil.formatUserName(userName) + "." + docName));
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(ps);
                DbUtil.close(conn);
            }
            DbUtil.close(ps);
            DbUtil.close(conn);
        }
        return tempList;
    }

    public static String formatLongString(String str, int chars) {
        String NL = "<BR/>";
        StringBuffer result = new StringBuffer();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.length() > chars) {
                    int to = line.length() / chars;
                    if (line.length() % chars != 0) {
                        ++to;
                    }
                    int start = 0;
                    int end = chars;
                    for (int i = 0; i < to; ++i) {
                        String subLine = end < line.length() ? line.substring(start, end) : line.substring(start);
                        result.append(subLine + NL);
                        start = end;
                        end += chars;
                    }
                    if (end >= line.length()) continue;
                    result.append(NL + line.substring(start));
                    continue;
                }
                result.append(line);
            }
        }
        return result.toString();
    }

    public static String getEthIslOperStatusCause(int operStatusCause, boolean isPresent, long lastSeen) {
        if (!isPresent) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(lastSeen));
        }
        return "ok";
    }

    public static void populateAAAProperties(ArrayList<String> aaaProperties) {
        aaaProperties.add("authentication.mode");
        aaaProperties.add("proxy.mds.primary");
        aaaProperties.add("proxy.mds.secondary");
        aaaProperties.add("proxy.mds.tertiary");
        aaaProperties.add("aaa.server.primary.name");
        aaaProperties.add("aaa.server.primary.secret");
        aaaProperties.add("aaa.server.primary.auth-method");
        aaaProperties.add("radius.server.primary.auth-port");
        aaaProperties.add("radius.server.primary.acct-port");
        aaaProperties.add("tacacs.server.primary.port");
        aaaProperties.add("aaa.server.secondary.name");
        aaaProperties.add("aaa.server.secondary.secret");
        aaaProperties.add("aaa.server.secondary.auth-method");
        aaaProperties.add("radius.server.secondary.auth-port");
        aaaProperties.add("radius.server.secondary.acct-port");
        aaaProperties.add("tacacs.server.secondary.port");
        aaaProperties.add("aaa.server.tertiary.name");
        aaaProperties.add("aaa.server.tertiary.secret");
        aaaProperties.add("aaa.server.tertiary.auth-method");
        aaaProperties.add("radius.server.tertiary.auth-port");
        aaaProperties.add("radius.server.tertiary.acct-port");
        aaaProperties.add("tacacs.server.tertiary.port");
        aaaProperties.add("ldap.provider.host");
        aaaProperties.add("ldap.provider.port");
        aaaProperties.add("ldap.ssl.enable");
        aaaProperties.add("ldap.baseDN");
        aaaProperties.add("ldap.filter");
        aaaProperties.add("ldap.role.attribute");
        aaaProperties.add("ldap.role.admingroup");
        aaaProperties.add("ldap.fmgrp");
        aaaProperties.add("ldap.auth.nonrestricted");
    }

    public static ArrayList<PropertyWrapper> propertyFilter(ArrayList<PropertyWrapper> allProperties, ArrayList<String> filterProperties, boolean displayAAA) {
        ArrayList<PropertyWrapper> aaaProperties = new ArrayList<PropertyWrapper>();
        ArrayList<PropertyWrapper> serverProperties = new ArrayList<PropertyWrapper>();
        for (PropertyWrapper property : allProperties) {
            if (property == null) continue;
            String key = property.getKey();
            if (filterProperties.contains(key)) {
                aaaProperties.add(property);
                continue;
            }
            serverProperties.add(property);
        }
        return displayAAA ? aaaProperties : serverProperties;
    }

    public static String formatToG(double dd, boolean isByte) {
        if (Double.isNaN(dd)) {
            return "n/a";
        }
        double d = 0.0;
        String suffix = "G";
        d = dd / 1.0E9;
        if (isByte) {
            return NUM_FORMAT_Three_Decimal.format(d) + suffix + "B";
        }
        return NUM_FORMAT_Three_Decimal.format(d) + suffix + "b";
    }

    public static String formatToM(double dd, boolean isByte) {
        if (Double.isNaN(dd)) {
            return "n/a";
        }
        double d = 0.0;
        String suffix = "M";
        d = dd / 1000000.0;
        if (isByte) {
            return NUM_FORMAT_Three_Decimal.format(d) + suffix + "B";
        }
        return NUM_FORMAT_Three_Decimal.format(d) + suffix + "b";
    }

    public static String formatToK(double dd, boolean isByte) {
        if (Double.isNaN(dd)) {
            return "n/a";
        }
        double d = 0.0;
        String suffix = "K";
        d = dd / 1000.0;
        if (isByte) {
            return NUM_FORMAT_Three_Decimal.format(d) + suffix + "B";
        }
        return NUM_FORMAT_Three_Decimal.format(d) + suffix + "b";
    }

    public static String formatToB(double dd, boolean isByte) {
        if (Double.isNaN(dd)) {
            return "n/a";
        }
        double d = 0.0;
        d = dd / 1.0;
        if (isByte) {
            return NUM_FORMAT_Three_Decimal.format(d) + "B";
        }
        return NUM_FORMAT_Three_Decimal.format(d) + "b";
    }

    public static void convertToExportUnit(ArrayList<StatisticsDataDO> statDO, String unit) {
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        if (!unit.trim().equals("GB")) break block8;
                                        for (int i = 0; i < statDO.size(); ++i) {
                                            StatisticsDataDO data = statDO.get(i);
                                            String speedStr = DisplayUtil.formatToG(data.getSpeed(), true);
                                            data.setSpeedStr(speedStr);
                                            String avgRxStr = DisplayUtil.formatToG(data.getLastDayAvgRx(), true);
                                            data.setAvgRxStr(avgRxStr);
                                            String avgTxStr = DisplayUtil.formatToG(data.getLastDayAvgTx(), true);
                                            data.setAvgTxStr(avgTxStr);
                                            String rxTxStr = DisplayUtil.formatToG(data.getRxTx(), true);
                                            data.setRxTxStr(rxTxStr);
                                            String maxRxStr = DisplayUtil.formatToG(data.getLastDayMaxRx(), true);
                                            data.setMaxRxStr(maxRxStr);
                                            String maxTxStr = DisplayUtil.formatToG(data.getLastDayMaxTx(), true);
                                            data.setMaxTxStr(maxTxStr);
                                        }
                                        break block9;
                                    }
                                    if (!unit.trim().equals("Gb")) break block10;
                                    for (int i = 0; i < statDO.size(); ++i) {
                                        StatisticsDataDO data = statDO.get(i);
                                        String speedStr = DisplayUtil.formatToG(data.getSpeed() * 10.0, false);
                                        data.setSpeedStr(speedStr);
                                        String avgRxStr = DisplayUtil.formatToG(data.getLastDayAvgRx() * 10.0, false);
                                        data.setAvgRxStr(avgRxStr);
                                        String avgTxStr = DisplayUtil.formatToG(data.getLastDayAvgTx() * 10.0, false);
                                        data.setAvgTxStr(avgTxStr);
                                        String rxTxStr = DisplayUtil.formatToG(data.getRxTx() * 10.0, false);
                                        data.setRxTxStr(rxTxStr);
                                        String maxRxStr = DisplayUtil.formatToG(data.getLastDayMaxRx() * 10.0, false);
                                        data.setMaxRxStr(maxRxStr);
                                        String maxTxStr = DisplayUtil.formatToG(data.getLastDayMaxTx() * 10.0, false);
                                        data.setMaxTxStr(maxTxStr);
                                    }
                                    break block9;
                                }
                                if (!unit.trim().equals("MB")) break block11;
                                for (int i = 0; i < statDO.size(); ++i) {
                                    StatisticsDataDO data = statDO.get(i);
                                    String speedStr = DisplayUtil.formatToM(data.getSpeed(), true);
                                    data.setSpeedStr(speedStr);
                                    String avgRxStr = DisplayUtil.formatToM(data.getLastDayAvgRx(), true);
                                    data.setAvgRxStr(avgRxStr);
                                    String avgTxStr = DisplayUtil.formatToM(data.getLastDayAvgTx(), true);
                                    data.setAvgTxStr(avgTxStr);
                                    String rxTxStr = DisplayUtil.formatToM(data.getRxTx(), true);
                                    data.setRxTxStr(rxTxStr);
                                    String maxRxStr = DisplayUtil.formatToM(data.getLastDayMaxRx(), true);
                                    data.setMaxRxStr(maxRxStr);
                                    String maxTxStr = DisplayUtil.formatToM(data.getLastDayMaxTx(), true);
                                    data.setMaxTxStr(maxTxStr);
                                }
                                break block9;
                            }
                            if (!unit.trim().equals("Mb")) break block12;
                            for (int i = 0; i < statDO.size(); ++i) {
                                StatisticsDataDO data = statDO.get(i);
                                String speedStr = DisplayUtil.formatToM(data.getSpeed() * 10.0, false);
                                data.setSpeedStr(speedStr);
                                String avgRxStr = DisplayUtil.formatToM(data.getLastDayAvgRx() * 10.0, false);
                                data.setAvgRxStr(avgRxStr);
                                String avgTxStr = DisplayUtil.formatToM(data.getLastDayAvgTx() * 10.0, false);
                                data.setAvgTxStr(avgTxStr);
                                String rxTxStr = DisplayUtil.formatToM(data.getRxTx() * 10.0, false);
                                data.setRxTxStr(rxTxStr);
                                String maxRxStr = DisplayUtil.formatToM(data.getLastDayMaxRx() * 10.0, false);
                                data.setMaxRxStr(maxRxStr);
                                String maxTxStr = DisplayUtil.formatToM(data.getLastDayMaxTx() * 10.0, false);
                                data.setMaxTxStr(maxTxStr);
                            }
                            break block9;
                        }
                        if (!unit.trim().equals("KB")) break block13;
                        for (int i = 0; i < statDO.size(); ++i) {
                            StatisticsDataDO data = statDO.get(i);
                            String speedStr = DisplayUtil.formatToK(data.getSpeed(), true);
                            data.setSpeedStr(speedStr);
                            String avgRxStr = DisplayUtil.formatToK(data.getLastDayAvgRx(), true);
                            data.setAvgRxStr(avgRxStr);
                            String avgTxStr = DisplayUtil.formatToK(data.getLastDayAvgTx(), true);
                            data.setAvgTxStr(avgTxStr);
                            String rxTxStr = DisplayUtil.formatToK(data.getRxTx(), true);
                            data.setRxTxStr(rxTxStr);
                            String maxRxStr = DisplayUtil.formatToK(data.getLastDayMaxRx(), true);
                            data.setMaxRxStr(maxRxStr);
                            String maxTxStr = DisplayUtil.formatToK(data.getLastDayMaxTx(), true);
                            data.setMaxTxStr(maxTxStr);
                        }
                        break block9;
                    }
                    if (!unit.trim().equals("Kb")) break block14;
                    for (int i = 0; i < statDO.size(); ++i) {
                        StatisticsDataDO data = statDO.get(i);
                        String speedStr = DisplayUtil.formatToK(data.getSpeed() * 10.0, false);
                        data.setSpeedStr(speedStr);
                        String avgRxStr = DisplayUtil.formatToK(data.getLastDayAvgRx() * 10.0, false);
                        data.setAvgRxStr(avgRxStr);
                        String avgTxStr = DisplayUtil.formatToK(data.getLastDayAvgTx() * 10.0, false);
                        data.setAvgTxStr(avgTxStr);
                        String rxTxStr = DisplayUtil.formatToK(data.getRxTx() * 10.0, false);
                        data.setRxTxStr(rxTxStr);
                        String maxRxStr = DisplayUtil.formatToK(data.getLastDayMaxRx() * 10.0, false);
                        data.setMaxRxStr(maxRxStr);
                        String maxTxStr = DisplayUtil.formatToK(data.getLastDayMaxTx() * 10.0, false);
                        data.setMaxTxStr(maxTxStr);
                    }
                    break block9;
                }
                if (!unit.trim().equals("B")) break block15;
                for (int i = 0; i < statDO.size(); ++i) {
                    StatisticsDataDO data = statDO.get(i);
                    String speedStr = DisplayUtil.formatToB(data.getSpeed(), true);
                    data.setSpeedStr(speedStr);
                    String avgRxStr = DisplayUtil.formatToB(data.getLastDayAvgRx(), true);
                    data.setAvgRxStr(avgRxStr);
                    String avgTxStr = DisplayUtil.formatToB(data.getLastDayAvgTx(), true);
                    data.setAvgTxStr(avgTxStr);
                    String rxTxStr = DisplayUtil.formatToB(data.getRxTx(), true);
                    data.setRxTxStr(rxTxStr);
                    String maxRxStr = DisplayUtil.formatToB(data.getLastDayMaxRx(), true);
                    data.setMaxRxStr(maxRxStr);
                    String maxTxStr = DisplayUtil.formatToB(data.getLastDayMaxTx(), true);
                    data.setMaxTxStr(maxTxStr);
                }
                break block9;
            }
            if (!unit.trim().equals("b")) break block9;
            for (int i = 0; i < statDO.size(); ++i) {
                StatisticsDataDO data = statDO.get(i);
                String speedStr = DisplayUtil.formatToB(data.getSpeed() * 10.0, false);
                data.setSpeedStr(speedStr);
                String avgRxStr = DisplayUtil.formatToB(data.getLastDayAvgRx() * 10.0, false);
                data.setAvgRxStr(avgRxStr);
                String avgTxStr = DisplayUtil.formatToB(data.getLastDayAvgTx() * 10.0, false);
                data.setAvgTxStr(avgTxStr);
                String rxTxStr = DisplayUtil.formatToB(data.getRxTx() * 10.0, false);
                data.setRxTxStr(rxTxStr);
                String maxRxStr = DisplayUtil.formatToB(data.getLastDayMaxRx() * 10.0, false);
                data.setMaxRxStr(maxRxStr);
                String maxTxStr = DisplayUtil.formatToB(data.getLastDayMaxTx() * 10.0, false);
                data.setMaxTxStr(maxTxStr);
            }
        }
    }

    public static void convertGigEToExportUnit(ArrayList<StatisticsDataDO> statDO, String unit) {
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        if (!unit.trim().equals("GB")) break block8;
                                        for (int i = 0; i < statDO.size(); ++i) {
                                            StatisticsDataDO data = statDO.get(i);
                                            String speedStr = DisplayUtil.formatToG(data.getSpeed() / 8.0, true);
                                            data.setSpeedStr(speedStr);
                                            String avgRxStr = DisplayUtil.formatToG(data.getLastDayAvgRx(), true);
                                            data.setAvgRxStr(avgRxStr);
                                            String avgTxStr = DisplayUtil.formatToG(data.getLastDayAvgTx(), true);
                                            data.setAvgTxStr(avgTxStr);
                                            String rxTxStr = DisplayUtil.formatToG(data.getRxTx(), true);
                                            data.setRxTxStr(rxTxStr);
                                            String maxRxStr = DisplayUtil.formatToG(data.getLastDayMaxRx(), true);
                                            data.setMaxRxStr(maxRxStr);
                                            String maxTxStr = DisplayUtil.formatToG(data.getLastDayMaxTx(), true);
                                            data.setMaxTxStr(maxTxStr);
                                        }
                                        break block9;
                                    }
                                    if (!unit.trim().equals("Gb")) break block10;
                                    for (int i = 0; i < statDO.size(); ++i) {
                                        StatisticsDataDO data = statDO.get(i);
                                        String speedStr = DisplayUtil.formatToG(data.getSpeed(), false);
                                        data.setSpeedStr(speedStr);
                                        String avgRxStr = DisplayUtil.formatToG(data.getLastDayAvgRx() * 8.0, false);
                                        data.setAvgRxStr(avgRxStr);
                                        String avgTxStr = DisplayUtil.formatToG(data.getLastDayAvgTx() * 8.0, false);
                                        data.setAvgTxStr(avgTxStr);
                                        String rxTxStr = DisplayUtil.formatToG(data.getRxTx() * 8.0, false);
                                        data.setRxTxStr(rxTxStr);
                                        String maxRxStr = DisplayUtil.formatToG(data.getLastDayMaxRx() * 8.0, false);
                                        data.setMaxRxStr(maxRxStr);
                                        String maxTxStr = DisplayUtil.formatToG(data.getLastDayMaxTx() * 8.0, false);
                                        data.setMaxTxStr(maxTxStr);
                                    }
                                    break block9;
                                }
                                if (!unit.trim().equals("MB")) break block11;
                                for (int i = 0; i < statDO.size(); ++i) {
                                    StatisticsDataDO data = statDO.get(i);
                                    String speedStr = DisplayUtil.formatToM(data.getSpeed() / 8.0, true);
                                    data.setSpeedStr(speedStr);
                                    String avgRxStr = DisplayUtil.formatToM(data.getLastDayAvgRx(), true);
                                    data.setAvgRxStr(avgRxStr);
                                    String avgTxStr = DisplayUtil.formatToM(data.getLastDayAvgTx(), true);
                                    data.setAvgTxStr(avgTxStr);
                                    String rxTxStr = DisplayUtil.formatToM(data.getRxTx(), true);
                                    data.setRxTxStr(rxTxStr);
                                    String maxRxStr = DisplayUtil.formatToM(data.getLastDayMaxRx(), true);
                                    data.setMaxRxStr(maxRxStr);
                                    String maxTxStr = DisplayUtil.formatToM(data.getLastDayMaxTx(), true);
                                    data.setMaxTxStr(maxTxStr);
                                }
                                break block9;
                            }
                            if (!unit.trim().equals("Mb")) break block12;
                            for (int i = 0; i < statDO.size(); ++i) {
                                StatisticsDataDO data = statDO.get(i);
                                String speedStr = DisplayUtil.formatToM(data.getSpeed(), false);
                                data.setSpeedStr(speedStr);
                                String avgRxStr = DisplayUtil.formatToM(data.getLastDayAvgRx() * 8.0, false);
                                data.setAvgRxStr(avgRxStr);
                                String avgTxStr = DisplayUtil.formatToM(data.getLastDayAvgTx() * 8.0, false);
                                data.setAvgTxStr(avgTxStr);
                                String rxTxStr = DisplayUtil.formatToM(data.getRxTx() * 8.0, false);
                                data.setRxTxStr(rxTxStr);
                                String maxRxStr = DisplayUtil.formatToM(data.getLastDayMaxRx() * 8.0, false);
                                data.setMaxRxStr(maxRxStr);
                                String maxTxStr = DisplayUtil.formatToM(data.getLastDayMaxTx() * 8.0, false);
                                data.setMaxTxStr(maxTxStr);
                            }
                            break block9;
                        }
                        if (!unit.trim().equals("KB")) break block13;
                        for (int i = 0; i < statDO.size(); ++i) {
                            StatisticsDataDO data = statDO.get(i);
                            String speedStr = DisplayUtil.formatToK(data.getSpeed() / 8.0, true);
                            data.setSpeedStr(speedStr);
                            String avgRxStr = DisplayUtil.formatToK(data.getLastDayAvgRx(), true);
                            data.setAvgRxStr(avgRxStr);
                            String avgTxStr = DisplayUtil.formatToK(data.getLastDayAvgTx(), true);
                            data.setAvgTxStr(avgTxStr);
                            String rxTxStr = DisplayUtil.formatToK(data.getRxTx(), true);
                            data.setRxTxStr(rxTxStr);
                            String maxRxStr = DisplayUtil.formatToK(data.getLastDayMaxRx(), true);
                            data.setMaxRxStr(maxRxStr);
                            String maxTxStr = DisplayUtil.formatToK(data.getLastDayMaxTx(), true);
                            data.setMaxTxStr(maxTxStr);
                        }
                        break block9;
                    }
                    if (!unit.trim().equals("Kb")) break block14;
                    for (int i = 0; i < statDO.size(); ++i) {
                        StatisticsDataDO data = statDO.get(i);
                        String speedStr = DisplayUtil.formatToK(data.getSpeed(), false);
                        data.setSpeedStr(speedStr);
                        String avgRxStr = DisplayUtil.formatToK(data.getLastDayAvgRx() * 8.0, false);
                        data.setAvgRxStr(avgRxStr);
                        String avgTxStr = DisplayUtil.formatToK(data.getLastDayAvgTx() * 8.0, false);
                        data.setAvgTxStr(avgTxStr);
                        String rxTxStr = DisplayUtil.formatToK(data.getRxTx() * 8.0, false);
                        data.setRxTxStr(rxTxStr);
                        String maxRxStr = DisplayUtil.formatToK(data.getLastDayMaxRx() * 8.0, false);
                        data.setMaxRxStr(maxRxStr);
                        String maxTxStr = DisplayUtil.formatToK(data.getLastDayMaxTx() * 8.0, false);
                        data.setMaxTxStr(maxTxStr);
                    }
                    break block9;
                }
                if (!unit.trim().equals("B")) break block15;
                for (int i = 0; i < statDO.size(); ++i) {
                    StatisticsDataDO data = statDO.get(i);
                    String speedStr = DisplayUtil.formatToB(data.getSpeed() / 8.0, true);
                    data.setSpeedStr(speedStr);
                    String avgRxStr = DisplayUtil.formatToB(data.getLastDayAvgRx(), true);
                    data.setAvgRxStr(avgRxStr);
                    String avgTxStr = DisplayUtil.formatToB(data.getLastDayAvgTx(), true);
                    data.setAvgTxStr(avgTxStr);
                    String rxTxStr = DisplayUtil.formatToB(data.getRxTx(), true);
                    data.setRxTxStr(rxTxStr);
                    String maxRxStr = DisplayUtil.formatToB(data.getLastDayMaxRx(), true);
                    data.setMaxRxStr(maxRxStr);
                    String maxTxStr = DisplayUtil.formatToB(data.getLastDayMaxTx(), true);
                    data.setMaxTxStr(maxTxStr);
                }
                break block9;
            }
            if (!unit.trim().equals("b")) break block9;
            for (int i = 0; i < statDO.size(); ++i) {
                StatisticsDataDO data = statDO.get(i);
                String speedStr = DisplayUtil.formatToB(data.getSpeed(), false);
                data.setSpeedStr(speedStr);
                String avgRxStr = DisplayUtil.formatToB(data.getLastDayAvgRx() * 8.0, false);
                data.setAvgRxStr(avgRxStr);
                String avgTxStr = DisplayUtil.formatToB(data.getLastDayAvgTx() * 8.0, false);
                data.setAvgTxStr(avgTxStr);
                String rxTxStr = DisplayUtil.formatToB(data.getRxTx() * 8.0, false);
                data.setRxTxStr(rxTxStr);
                String maxRxStr = DisplayUtil.formatToB(data.getLastDayMaxRx() * 8.0, false);
                data.setMaxRxStr(maxRxStr);
                String maxTxStr = DisplayUtil.formatToB(data.getLastDayMaxTx() * 8.0, false);
                data.setMaxTxStr(maxTxStr);
            }
        }
    }
}

