/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.util;

import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.util.PropertyWrapper;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.server.ServerMonitor;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import com.cisco.dcbu.sm.server.web.util.EventTreeWrapper;
import com.cisco.dcbu.sm.server.web.util.EventtreeFabricHolder;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class WebUtil {
    public static final int NORMAL_TYPE = 1;
    public static final int GROUP_TYPE = 2;
    private static Logger _Logger = Logger.getLogger((String)"fms.ws");

    private WebUtil() {
    }

    public static String getFabricSwitchNavInXml() throws Exception {
        List<EventtreeFabricHolder> list = WebUtil.getFilterTree();
        StringBuilder bldr = new StringBuilder();
        bldr.append("<folders label=\"Scope\" type=\"root\">\n");
        bldr.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"Data Center\" \tparent=\"Scope\" group=\"Scope\" selection=\"Data Center\" type=\"datacenter\">\n");
        bldr.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"SAN\" \tparent=\"Data Center\" group=\"Scope\" selection=\"SAN\" type=\"san\">\n");
        for (EventtreeFabricHolder hldr : list) {
            String fName = hldr.getName();
            bldr.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"" + fName + "\"  fdbid=\"" + hldr.getId() + "\"\tparent=\"SAN\" fabricId=\"" + hldr.getFid() + "\" seed=\"" + hldr.getSeedSwitchAddress() + "\" group=\"Scope\" selection=\"Fabric\" type=\"fabric\">\n");
            for (EventTreeWrapper wrapper : hldr.getSwitches()) {
                bldr.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + wrapper.getSwitchName() + "\" ipAddress=\"" + wrapper.getSwitchAddress() + "\"  fdbid=\"" + hldr.getId() + "\" parent=\"" + fName + "\" swDbId=\"" + wrapper.getSwitchId() + "\" fabricId=\"" + hldr.getFid() + "\" group=\"Scope\" selection=\"Switch\" type=\"switch\"/>\n");
            }
            bldr.append("</folder>\n");
        }
        bldr.append("</folder>\n");
        bldr.append("</folder>\n");
        bldr.append("</folders>");
        return bldr.toString();
    }

    public static String getFabricSwitchNavECHInXml() throws Exception {
        Set<Long> emcExcludedSwList = null;
        try {
            emcExcludedSwList = SwitchImpl.getNoECHSupportList();
        }
        catch (Exception ex) {
            _Logger.error((Object)("getFabricSwitchNavECHInXml(),  ignore SwitchImpl.getNoECHSupportList()  exception: " + ex.getMessage()));
        }
        List<EventtreeFabricHolder> list = WebUtil.getFilterTree();
        int fabricCheckedCt = 0;
        ArrayList<StringBuilder> fabrics = new ArrayList<StringBuilder>();
        for (EventtreeFabricHolder hldr : list) {
            String fName = hldr.getName();
            ArrayList<String> sws = new ArrayList<String>();
            int swCheckedCt = 0;
            for (EventTreeWrapper wrapper : hldr.getSwitches()) {
                String st;
                int swType = wrapper.getSwType();
                if (!FRUConstants.isMdsFamilyType(swType) && !FRUConstants.isN7K(swType) && (!FRUConstants.isN5K(swType) || FRUConstants.isUCS(swType))) continue;
                long switchId = wrapper.getSwitchId();
                if (emcExcludedSwList != null && emcExcludedSwList.contains(switchId)) {
                    st = "<folder state=\"unchecked\" isBranch=\"false\" label=\"" + wrapper.getSwitchName() + "\" ipAddress=\"" + wrapper.getSwitchAddress() + "\"  fdbid=\"" + hldr.getId() + "\" parent=\"" + fName + "\" swDbId=\"" + wrapper.getSwitchId() + "\" fabricId=\"" + hldr.getFid() + "\" group=\"Scope\" selection=\"Switch\" type=\"switch\"/>\n";
                } else {
                    st = "<folder state=\"checked\" isBranch=\"false\" label=\"" + wrapper.getSwitchName() + "\" ipAddress=\"" + wrapper.getSwitchAddress() + "\"  fdbid=\"" + hldr.getId() + "\" parent=\"" + fName + "\" swDbId=\"" + wrapper.getSwitchId() + "\" fabricId=\"" + hldr.getFid() + "\" group=\"Scope\" selection=\"Switch\" type=\"switch\"/>\n";
                    ++swCheckedCt;
                }
                sws.add(st);
            }
            StringBuilder fabricBldr = new StringBuilder();
            if (swCheckedCt == sws.size()) {
                fabricBldr.append("<folder state=\"checked\" isBranch=\"true\" label=\"" + fName + "\"  fdbid=\"" + hldr.getId() + "\"\tparent=\"SAN\" fabricId=\"" + hldr.getFid() + "\" seed=\"" + hldr.getSeedSwitchAddress() + "\" group=\"Scope\" selection=\"Fabric\" type=\"fabric\">\n");
                ++fabricCheckedCt;
            } else {
                fabricBldr.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"" + fName + "\"  fdbid=\"" + hldr.getId() + "\"\tparent=\"SAN\" fabricId=\"" + hldr.getFid() + "\" seed=\"" + hldr.getSeedSwitchAddress() + "\" group=\"Scope\" selection=\"Fabric\" type=\"fabric\">\n");
            }
            for (String sw : sws) {
                fabricBldr.append(sw);
            }
            fabricBldr.append("</folder>\n");
            fabrics.add(fabricBldr);
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("<folders label=\"Scope\" type=\"root\">\n");
        if (fabricCheckedCt == fabrics.size()) {
            bldr.append("<folder state=\"checked\" isBranch=\"true\" label=\"Data Center\" \tparent=\"Scope\" group=\"Scope\" selection=\"Data Center\" type=\"datacenter\">\n");
            bldr.append("<folder state=\"checked\" isBranch=\"true\" label=\"SAN\" \tparent=\"Data Center\" group=\"Scope\" selection=\"SAN\" type=\"san\">\n");
        } else {
            bldr.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"Data Center\" \tparent=\"Scope\" group=\"Scope\" selection=\"Data Center\" type=\"datacenter\">\n");
            bldr.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"SAN\" \tparent=\"Data Center\" group=\"Scope\" selection=\"SAN\" type=\"san\">\n");
        }
        for (StringBuilder fabric : fabrics) {
            bldr.append((CharSequence)fabric);
        }
        bldr.append("</folder>\n");
        bldr.append("</folder>\n");
        bldr.append("</folders>");
        return bldr.toString();
    }

    public static String getColFilterSql(String colFilterStr, Map<String, String> filterHash) {
        String filterSql = "";
        if (colFilterStr != null && colFilterStr.length() > 0) {
            String[] pairs = colFilterStr.split(";");
            for (int i = 0; i < pairs.length; ++i) {
                String item = pairs[i];
                if (item.split(":")[0] == null || item.split(":").length < 2) continue;
                String key = item.split(":")[0];
                String vlu = item.split(":")[1];
                if (!filterHash.containsKey(key)) continue;
                filterSql = filterSql + " AND " + filterHash.get(key) + (key.equals("vsanId") || key.equals("ISLvsanId") || key.equals("ISLvlanId") || key.equals("vsanStrForEP") ? "'" + vlu + "' " : "'%" + vlu + "%' ");
            }
        }
        return filterSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<EventtreeFabricHolder> getFilterTree() throws Exception {
        ArrayList<EventtreeFabricHolder> all = new ArrayList<EventtreeFabricHolder>();
        String roleFilter = "";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = SQLLoader.getSqlWithoutLicensingCheck("EventTree.EVENT_STMT");
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long fabricId = rs.getLong(1);
                String fabricName = rs.getString(2);
                long switchId = rs.getLong(3);
                String sysName = rs.getString(4);
                byte[] b = rs.getBytes(5);
                byte[] b1 = rs.getBytes(6);
                boolean licensed = rs.getInt(7) > 1;
                int fid = rs.getInt(8);
                int swType = rs.getInt(9);
                String switchName = null;
                String seedSwitchName = null;
                EventTreeWrapper wrapper = new EventTreeWrapper();
                if (b != null) {
                    InetAddress switchAddress = InetAddress.getByAddress(b);
                    wrapper.setSwitchAddress(switchAddress);
                    switchName = switchAddress.getHostAddress();
                }
                if (b1 != null) {
                    InetAddress seedSwitchAddress = InetAddress.getByAddress(b1);
                    wrapper.setSeedSwitchAddress(seedSwitchAddress);
                    seedSwitchName = seedSwitchAddress.getHostAddress();
                }
                wrapper.setFabricId(fabricId);
                wrapper.setFabricName(fabricName);
                wrapper.setSeedSwitchName(seedSwitchName);
                wrapper.setSwitchId(switchId);
                wrapper.setSwitchName(sysName == null ? switchName : sysName);
                wrapper.setLicensed(licensed);
                wrapper.setFid(fid);
                wrapper.setSwType(swType);
                WebUtil.getFabricHolder(wrapper, all);
            }
        }
        catch (Exception ex) {
            try {
                _Logger.error((Object)ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        return all;
    }

    private static EventtreeFabricHolder getFabricHolder(EventTreeWrapper row, List<EventtreeFabricHolder> all) {
        boolean newSan = false;
        boolean newFabric = false;
        boolean newSwitch = false;
        EventtreeFabricHolder fholder = null;
        EventTreeWrapper wrapper = null;
        for (int i = 0; i < all.size(); ++i) {
            EventtreeFabricHolder holder = all.get(i);
            if (holder.getId() != row.getFabricId()) continue;
            fholder = holder;
            break;
        }
        if (fholder == null) {
            newFabric = true;
            fholder = new EventtreeFabricHolder();
            fholder.setId(row.getFabricId());
            fholder.setName(row.getFabricName());
            fholder.setSeedSwitchAddress(row.getSeedSwitchName());
            fholder.setLicensed(row.isLicensed());
            fholder.setFid(row.getFid());
        }
        List<EventTreeWrapper> v = fholder.getSwitches();
        for (int i = 0; i < v.size(); ++i) {
            EventTreeWrapper holder = v.get(i);
            if (holder.getSwitchId() != row.getSwitchId()) continue;
            wrapper = holder;
            break;
        }
        if (wrapper == null) {
            newSwitch = true;
            wrapper = new EventTreeWrapper();
            wrapper.setSwitchId(row.getSwitchId());
            wrapper.setSwitchName(row.getSwitchName());
            wrapper.setSwitchAddress(row.getSwitchAddress());
            wrapper.setFid(row.getFid());
            wrapper.setSwType(row.getSwType());
        }
        if (newFabric) {
            all.add(fholder);
        }
        if (newSwitch) {
            fholder.getSwitches().add(wrapper);
        }
        return fholder;
    }

    public static String updateServerProperties(String[] keys, String[] values) throws Exception {
        _Logger.info((Object)"WebUtil updateServerProperties...");
        String callhomeProperty = "server.callhome.enable";
        String callhomePropertyDir = "server.callhome.xmlDir";
        String forwaringProperty = "server.forward.event.enable";
        String syslogProperty = "syslog.disable";
        String emcCallhomeExcludedList = "emcCallhomeExcludedList";
        String enableNpvDiscovery = "fabric.enableNpvDiscovery";
        boolean setEnableNpvDiscoveryValue = false;
        boolean enableNpvDiscoveryValue = false;
        int[] services = new int[3];
        String[] logMsg = new String[]{"", "", ""};
        ArrayList<String> updateKeyList = new ArrayList<String>();
        ArrayList<String> updateValueList = new ArrayList<String>();
        ArrayList<String> updateKeyList2AllServers = new ArrayList<String>();
        ArrayList<String> updateValueList2AllServers = new ArrayList<String>();
        try {
            ArrayList<PropertyWrapper> nu = ServerPropertyUtil.readServerProperties();
            for (int i = 0; i < keys.length; ++i) {
                PropertyWrapper property = ServerPropertyUtil.getProperty(keys[i], nu);
                if (!keys[i].equals("emcCallhomeExcludedList") && (property == null || property.getValue().equals(values[i]))) continue;
                _Logger.info((Object)("WebUtil updateServerProperties, update properties: " + keys[i]));
                if (keys[i].equals("server.callhome.enable") || keys[i].equals("server.callhome.xmlDir")) {
                    services[0] = 1;
                    logMsg[0] = new String(keys[i] + " " + values[i]);
                } else if (keys[i].equals("server.forward.event.enable")) {
                    services[1] = 4;
                    logMsg[1] = new String(keys[i] + " " + values[i]);
                } else if (keys[i].equals("syslog.disable")) {
                    services[2] = 2;
                    logMsg[2] = new String(keys[i] + " " + values[i]);
                } else if (keys[i].equals("fabric.enableNpvDiscovery")) {
                    setEnableNpvDiscoveryValue = true;
                    enableNpvDiscoveryValue = values[i].equals("true");
                    _Logger.warn((Object)("WebUtil updateServerProperties(), enableNpvDiscoveryValue=" + enableNpvDiscoveryValue));
                } else if (keys[i].equals("emcCallhomeExcludedList")) {
                    try {
                        SwitchImpl.setNoECHSupportList(WebUtil.parseList(values[i]));
                    }
                    catch (Exception ex) {
                        _Logger.warn((Object)("WebUtil caught exception in updateServerProperties(), ignore exception on SwitchImpl.setNoECHSupportList: " + ex.getMessage()));
                    }
                }
                if (keys[i].equals("emcCallhomeExcludedList")) continue;
                _Logger.info((Object)("WebUtil updateServerProperties, update properties(2): " + keys[i]));
                updateKeyList.add(keys[i]);
                updateValueList.add(values[i]);
                boolean skip = false;
                for (String skipProperties : ServerPropertyUtil.SkipPersistCollection) {
                    if (!keys[i].equals(skipProperties)) continue;
                    skip = true;
                    break;
                }
                if (!skip) {
                    _Logger.info((Object)("WebUtil updateServerProperties, update properties to update other servers: " + keys[i]));
                    updateKeyList2AllServers.add(keys[i]);
                    updateValueList2AllServers.add(values[i]);
                    continue;
                }
                _Logger.info((Object)("WebUtil updateServerProperties, skip properties to update other servers: " + keys[i]));
            }
            String[] updateKeys = updateKeyList.toArray(new String[0]);
            String[] updateValues = updateValueList.toArray(new String[0]);
            String[] updateKeys2AllServers = updateKeyList2AllServers.toArray(new String[0]);
            String[] updateValues2AllServers = updateValueList2AllServers.toArray(new String[0]);
            if (updateKeys2AllServers != null && updateKeys2AllServers.length > 0) {
                List<String> servers = ServerMonitor.getInstance().getActiveServerNodes();
                for (int j = 0; j < servers.size(); ++j) {
                    FMServerRif fmServer = WebUtil.getFMServer(servers.get(j));
                    if (fmServer == null) continue;
                    long systime = fmServer.getServerTime();
                    boolean isManageableforNpvSwitchesOnServer = fmServer.isManageableforNpvSwitches();
                    _Logger.warn((Object)("WebUtil updateServerProperties(), enableNpvDiscoveryValue/isManageableforNpvSwitchesOnServer=" + enableNpvDiscoveryValue + '/' + isManageableforNpvSwitchesOnServer));
                    fmServer.updateServerPropertyWOStore(updateKeys2AllServers, updateValues2AllServers, false, SecurityManager.getSSOToken("serverproperty", systime));
                    if (!setEnableNpvDiscoveryValue) continue;
                    if (enableNpvDiscoveryValue && !isManageableforNpvSwitchesOnServer) {
                        _Logger.warn((Object)"WebUtil updateServerProperties(), calling fmServer.setManageableforNpvSwitches...");
                        fmServer.setManageableforNpvSwitches();
                        continue;
                    }
                    if (enableNpvDiscoveryValue || !isManageableforNpvSwitchesOnServer) continue;
                    _Logger.warn((Object)"WebUtil updateServerProperties(), calling fmServer.setUnManageableforNpvSwitches...");
                    fmServer.setUnManageableforNpvSwitches();
                }
            }
            ServerPropertyUtil.updateServerProperty(updateKeys, updateValues, false);
            try {
                for (int i = 0; i < services.length; ++i) {
                    if (services[i] == 0) continue;
                    List<String> serverList = ClusterMapping.getInstance().qALlIPStrings();
                    for (int j = 0; j < serverList.size(); ++j) {
                        FMServerRif fmServer = null;
                        String fmServerIP = serverList.get(j);
                        if (fmServerIP == null || fmServerIP.equals("")) {
                            _Logger.warn((Object)"WebUtil updateServerProperties(), fmServerIP null or blank");
                            continue;
                        }
                        try {
                            fmServer = ClusterProcessor.getInstance().getFmsByIp(fmServerIP);
                        }
                        catch (Exception ex) {
                            _Logger.warn((Object)"WebUtil updateServerProperties() caught exception in getFmsByIp(), ex :", (Throwable)ex);
                            continue;
                        }
                        if (fmServer == null) {
                            _Logger.warn((Object)"WebUtil updateServerProperties(), fmServer null");
                            continue;
                        }
                        try {
                            fmServer.restart(services[i]);
                            continue;
                        }
                        catch (Exception ex) {
                            _Logger.warn((Object)"WebUtil updateServerProperties() caught exception in restart(), ex :", (Throwable)ex);
                        }
                    }
                }
            }
            catch (Exception exRestart) {
                _Logger.warn((Object)"WebUtil caught exception in updateServerProperties():", (Throwable)exRestart);
                return "Failed to restart: " + exRestart.getMessage();
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)"WebUtil caught exception in updateServerProperties():", (Throwable)e);
            return "Cannot update properties " + e.getMessage();
        }
        _Logger.info((Object)"WebUtil updateServerProperties DONE");
        return null;
    }

    private static List<Long> parseList(String excludedSwList) {
        if (excludedSwList == null || excludedSwList.equals("")) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        StringTokenizer st = new StringTokenizer(excludedSwList, ",", false);
        while (st.hasMoreTokens()) {
            String sw = st.nextToken().trim();
            list.add(new Long(Long.parseLong(sw)));
        }
        return list;
    }

    private static FMServerRif getFMServer(String server) {
        _Logger.warn((Object)"WebUtil getFMServer...");
        FMServerRif fmRif = null;
        String defaultRmiPort = System.getProperty("server.port", "9099");
        if (server == null || server.equals("")) {
            server = "localhost";
        }
        _Logger.warn((Object)("WebUtil getFMServer for server " + server));
        int rmiPort = Integer.parseInt(defaultRmiPort);
        try {
            EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
            String localServer = rif.getFMServer().whereami();
            if (rif != null) {
                fmRif = server.equals("localhost") || localServer.equals(server) ? rif.getFMServer() : (FMServerRif)rif.getRemoteService(server, "FMServerBean");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        _Logger.warn((Object)"WebUtil getFMServer DONE");
        return fmRif;
    }
}

