/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.zone;

import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.wo.EnclosurePairDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnEnclosureDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnEndPortDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnEndPortDataDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnFabricDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnHstPortStgPortListDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnSwitchDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnVsanDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnVsancliDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnZoneDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnZoneMemberDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZncliDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.snmp.transport.UdpTransportOptions;
import com.cisco.dcbu.sm.common.rif.WebZoneRif;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.facade.WebZoneManagerImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PolicyBasedZoning {
    public static final String ENCLOSURE_DATA = "select ec.id, ec.enc_type, ec.is_virtual, ec.ip_address, ec.name,ec.is_vm_host,  ep.id, ep.is_present, ep.fabric_id, ep.name, ep.wwn, ep.alias,ep.if_name, sw.sys_name,  sw.ip_address, v.name, v.id, v.vsan_id, f.name   from enclosure ec, end_port ep, switch_port swp, switch sw, vsan_endport_info vinfo, vsan v, fabric f  where ep.enclosure_id=ec.id AND swp.id=ep.switch_port_id AND f.id=ep.fabric_id   AND swp.switch_id=sw.id AND vinfo.endport_id = ep.id AND v.id=vinfo.vsan_id ORDER BY ec.id, ep.id ASC";
    public static final String SWITCH_DATA = "select sw.id, sw.ip_address, sw.sys_name from switch sw where ";
    public static final String VSAN_PRICIPAL_SWITCH = "select sw.id, sw.ip_address, v.id from switch sw, vsan v where sw.id=v.principal_sw_id";
    ArrayList<EnclosurePairDO> encPairList;
    static Logger _Logger = LogManager.getLogger((String)"FM.WebReport");
    public static final String ENCLOSURE_END_PORT = "select * FROM (select en.id AS enid, en.ip_address AS enipaddress, ep.id AS epid, ep.wwn AS epwwn, ep.name AS epname, ep.switch_port_id, ep.fc4_features, ep.if_name, ep.is_present, en.is_virtual, ep.fabric_id AS epfdbid, f.name AS fname, f.seed_switch_id, sw.sys_name, swp.if_index, sw.ip_address, v.id, v.name vname, sw.id AS swid, v.vsan_id AS vsaid, v.principal_sw_id AS vpswid, v.is_disjoint  from ENCLOSURE en, FABRIC f, VSAN v, SWITCH_PORT swp, SWITCH sw, VSAN_ENDPORT_INFO vin, End_port ep where  ep.enclosure_id=en.id AND ep.is_present='1' AND ep.fabric_id=f.id AND swp.id=ep.switch_port_id AND swp.switch_id=sw.id AND en.id=?  AND vin.endport_id=ep.id AND v.id=vin.vsan_id ) fepp LEFT JOIN (select wwn AS dawwn, alias, fabric_id AS dafabricid FROM DEVICE_ALIAS) damod  ON fepp.epwwn=damod.dawwn  AND damod.dafabricid=fepp.epfdbid";
    public static final String VSANDBID_END_PORT = "select en.id, en.ip_address, ep.id, ep.wwn, ep.name, ep.switch_port_id, ep.fc4_features, ep.if_name, ep.is_present, en.is_virtual, ep.fabric_id, f.name, f.seed_switch_id, sw.sys_name, swp.if_index, sw.ip_address, v.id, v.name, en.name from ENCLOSURE en, END_PORT ep, FABRIC f, VSAN v, SWITCH_PORT swp, SWITCH sw, VSAN_ENDPORT_INFO vin where  ep.enclosure_id=en.id AND ep.is_present=1 AND ep.fabric_id=f.id AND swp.id=ep.switch_port_id AND swp.switch_id=sw.id AND vin.endport_id=ep.id AND v.id=vin.vsan_id  AND v.id= ? ";
    public static final String STORAGE_EP_QUERY_APPEND = " AND ep.fc4_features=1";
    public static final String HOST_EP_QUERY_APPEND = " AND ep.fc4_features!=1";
    public static final String VSAN_ACTIVE_ZONES = "select zn.id, zn.name, zm.id, zm.member_id, zm.endport_id, zm.name, zm.type  from zone_member zm, zone zn where zm.endport_id!=-1 AND (zm.TYPE=1 OR zm.TYPE=10) AND zm.zone_id=zn.id AND zn.parent_id=?  ORDER BY zn.id ASC";
    public static final String ENCL_EPORT_ACTIVE_ZONES_COUNT = "select zm.endport_id, count(zm.zone_id) FROM  END_PORT ep, zone_member zm where ep.id=zm.endport_id AND ep.enclosure_id=?   AND (zm.TYPE=1 OR zm.TYPE=10) GROUP BY zm.endport_id  ORDER BY zm.endport_id ASC";
    public static final String ENCL_EPORT_RXTX = "select s.src_id, SUM(s.max_rx), SUM(s.max_tx) FROM  END_PORT ep, STATISTICS s where ep.id=s.src_id AND ep.enclosure_id=? GROUP BY s.src_id  ORDER BY s.src_id ASC";
    public static final String STRG_ENC_FOR_ENCID_WITH_VSAN1_PORT = "select DISTINCT ec.id, ec.name,ec.ip_address, count(ec.id) from enclosure ec, end_port ecp, vsan_endport_info eve,(select DISTINCT vd.vsan_id AS mvid from vsan_domain_info vd, (select DISTINCT  sw.sys_name, sw.id, v.vsan_id, ec.name from enclosure ec, end_port ecp, SWITCH_PORT swp, SWITCH sw, vsan_endport_info vinfo, VSAN v  where ecp.enclosure_id=ec.id AND swp.id=ecp.switch_port_id AND swp.switch_id=sw.id  and EC.ID=? AND vinfo.endport_id = ecp.id AND v.id=vinfo.vsan_id AND v.vsan_id=1 ORDER BY sw.id ASC  ) modsw  where modsw.id=vd.switch_id) modvsan   where eve.endport_id=ecp.id AND modvsan.mvid=eve.vsan_id AND ecp.enclosure_id=ec.id    AND ecp.fc4_features=1   group by  ec.id, ec.name,ec.ip_address ORDER BY ec.name ASC ";
    public static final String STRG_ENC_FOR_ENCID = "select DISTINCT ec.id, ec.name,ec.ip_address, count(ec.id)  from enclosure ec, end_port ecp, vsan_endport_info eve,  (select distinct ve.vsan_id AS mvid from end_port ep, vsan_endport_info ve where ve.endport_id=ep.id  AND ep.enclosure_id=?) modvsan  where eve.endport_id=ecp.id AND modvsan.mvid=eve.vsan_id AND ecp.enclosure_id=ec.id  AND ecp.fc4_features=1  group by  ec.id, ec.name,ec.ip_address ORDER BY ec.name ASC ";
    public static final String SWITCH_VSANS = "select DISTINCT vd.switch_id, vd.vsan_id from vsan_domain_info vd where ";
    public static final String UNZONED_HOST_ENCLOSURE_SQL = "select eid , enm, eip, eos, etp, count(eid) from (select DISTINCT ecc.id as eid, ecc.name as enm, ecc.ip_address as eip, ecc.os_info as eos, ecc.enc_type as etp FROM enclosure ecc where ecc.id NOT IN (select DISTINCT ec.id from   zone_member zm,end_port ep, enclosure ec where ep.enclosure_id=ec.id AND zm.endport_id=ep.id ) ORDER BY ecc.name) ecls, end_port epp where epp.enclosure_id=ecls.eid group by eid , enm, eip, eos, etp";
    public static boolean standalone = false;
    static HashMap idToGenerator = new HashMap();
    private static Timer _Timer = null;
    private static int exIntMin;
    public static final int minZoneDBKey = 20;
    public static final int EXPIRY_TIME_MIN;

    public static void createLargeZoneDB() {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("c:\\clizonescript")));
            writer.write("conf t");
            writer.newLine();
            writer.write("zoneset name LargeZnst vsan 250");
            writer.newLine();
            for (int i = 0; i < 4000; ++i) {
                writer.write("zone name zone" + i);
                writer.newLine();
                writer.write(" member pwwn 21:00:00:01:05:08:01:02 ");
                writer.newLine();
                writer.write(" member pwwn 21:00:00:01:05:08:31:02 ");
                writer.newLine();
                writer.write(" member pwwn 21:00:00:01:05:08:50:12 ");
                writer.newLine();
                writer.write(" member pwwn 21:00:00:01:05:09:00:11 ");
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void main(String[] arg) {
        PolicyBasedZoning.createLargeZoneDB();
        try {
            long hclDBID;
            standalone = true;
            SnmpPeer prr = PolicyBasedZoning.getPeer("172.20.150.84");
            MibNode.load("com/cisco/dcbu/lib/mds/mib.dat");
            WebZnEnclosureDO[] encs = PolicyBasedZoning.getUnzonedHostEnclosures();
            HashMap<Long, String> enc2Name = new HashMap<Long, String>();
            if (encs != null) {
                System.out.println("Unzoned Enclosures");
                for (int i = 0; i < encs.length; ++i) {
                    System.out.println("DBID:" + encs[i].getDbid() + "  Name:" + encs[i].getName());
                    enc2Name.put(encs[i].getDbid(), encs[i].getName());
                }
            }
            System.out.println("Input Host Encl DBID:");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String usrInput = "";
            try {
                usrInput = bufferedReader.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!usrInput.equalsIgnoreCase("quit") && (encs = PolicyBasedZoning.getEligibleStorageEnclosuresForHostEnclosure(hclDBID = Long.parseLong(usrInput))) != null) {
                System.out.println("Eligible Storage Enclosures");
                for (int i = 0; i < encs.length; ++i) {
                    System.out.println("DBID:" + encs[i].getDbid() + "  Name:" + encs[i].getName());
                    enc2Name.put(encs[i].getDbid(), encs[i].getName());
                }
            }
            System.out.println("Input Host Encl DBID For Paths:");
            try {
                usrInput = bufferedReader.readLine();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            hclDBID = Long.parseLong(usrInput);
            System.out.println("Input Storage Encl DBID:");
            String usrInput2 = "";
            try {
                usrInput2 = bufferedReader.readLine();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            long stgDBID = Long.parseLong(usrInput2);
            Object[] ob = PolicyBasedZoning.buildHost2StorageList(hclDBID, stgDBID);
            WebZnEndPortDO[] hPorts = (WebZnEndPortDO[])ob[0];
            WebZnEndPortDO[] sPorts = (WebZnEndPortDO[])ob[1];
            Object[] elVsanData = (Object[])ob[2];
            HashMap elVsanMap = (HashMap)elVsanData[2];
            HashMap vDBID2VDO = (HashMap)ob[3];
            HashMap faDBID2faDO = (HashMap)ob[4];
            HashMap swDBID2SWDO = (HashMap)ob[5];
            HashMap<Long, WebZnEndPortDO> hPortDBIDtoHostPort = new HashMap<Long, WebZnEndPortDO>();
            WebZnEndPortDO refPrt = null;
            if (hPorts != null) {
                for (int i = 0; i < hPorts.length; ++i) {
                    refPrt = hPorts[i];
                    WebZnSwitchDO swrefdo = (WebZnSwitchDO)swDBID2SWDO.get(refPrt.attSwDBID);
                    WebZnVsanDO vDo = (WebZnVsanDO)vDBID2VDO.get(refPrt.vsanDBID);
                    System.out.println("H:" + refPrt.DBID + "   " + refPrt.da + "   " + vDo.name + "   " + (swrefdo != null ? swrefdo.sys_name : "Unknown") + " " + refPrt.ifName + "   " + refPrt.numZones + "   " + refPrt.avgRx + "  " + refPrt.avgTx);
                    hPortDBIDtoHostPort.put(refPrt.DBID, refPrt);
                    if (sPorts == null) continue;
                    long[] vLst = hPorts[i].eligibleVsanDBIDList;
                    if (vLst == null) {
                        System.out.println("     No eligible Storage Ports.");
                        continue;
                    }
                    int sportsDetected = 0;
                    for (int k = 0; k < vLst.length; ++k) {
                        long vDBID = vLst[k];
                        for (int j = 0; j < sPorts.length; ++j) {
                            refPrt = sPorts[j];
                            if (hPortDBIDtoHostPort.get(refPrt.DBID) == null) {
                                hPortDBIDtoHostPort.put(refPrt.DBID, refPrt);
                            }
                            vDo = (WebZnVsanDO)vDBID2VDO.get(refPrt.vsanDBID);
                            WebZnSwitchDO swsrefdo = (WebZnSwitchDO)swDBID2SWDO.get(refPrt.attSwDBID);
                            if (vDBID != vDo.DBID) continue;
                            ++sportsDetected;
                            System.out.println("   S:" + refPrt.DBID + "   " + refPrt.da + "   " + vDo.name + "   " + (swsrefdo != null ? swsrefdo.sys_name : "Unknown") + " " + refPrt.ifName + "   " + refPrt.numZones + "   " + vDo.name + "   " + refPrt.avgRx + "  " + refPrt.avgTx);
                        }
                    }
                    if (sportsDetected == 0) {
                        System.out.println("     No eligible Storage Ports.");
                        continue;
                    }
                    hPorts[i].newZnName = "VSAN-" + vDo.vsanIndex + "-" + enc2Name.get(hclDBID) + "-" + enc2Name.get(stgDBID) + "-";
                }
                System.out.println("Input Host Port DBID,Storag Port DBIDs and zone name with tag z- nad DONE to indicate all added:");
                usrInput = "";
                HashMap hPrt2StgList = new HashMap();
                while (!(usrInput = bufferedReader.readLine()).equalsIgnoreCase("DONE")) {
                    StringTokenizer token = new StringTokenizer(usrInput, ",");
                    long hprtDBID = Long.parseLong(token.nextToken().trim());
                    WebZnEndPortDO hPortDO = (WebZnEndPortDO)hPortDBIDtoHostPort.get(hprtDBID);
                    ArrayList<WebZnEndPortDO> sprtDBIDList = new ArrayList<WebZnEndPortDO>();
                    String nxtStr = "";
                    nxtStr = token.nextToken();
                    while (nxtStr.indexOf("z-") == -1) {
                        WebZnEndPortDO sPortDO = (WebZnEndPortDO)hPortDBIDtoHostPort.get(Long.parseLong(nxtStr.trim()));
                        sprtDBIDList.add(sPortDO);
                        nxtStr = token.nextToken();
                    }
                    hPortDO.newZnName = nxtStr;
                    hPrt2StgList.put(hPortDO, sprtDBIDList);
                }
                HashMap vsan2SwitchCliMap = PolicyBasedZoning.generateCLICmds(hPrt2StgList, vDBID2VDO);
                for (Map.Entry obEntry : vsan2SwitchCliMap.entrySet()) {
                    Long vsanDBID = (Long)obEntry.getKey();
                    WebZnVsanDO vdoo = (WebZnVsanDO)vDBID2VDO.get(vsanDBID);
                    System.out.println("CLI FOR VSAN : " + vsanDBID + " " + vdoo.name);
                    Object[] obCli = (Object[])obEntry.getValue();
                    if (obCli == null || obCli.length != 2) continue;
                    ArrayList vChLst = (ArrayList)obCli[0];
                    if (vChLst != null && vChLst.size() > 0) {
                        System.out.println("HOST PORT VSAN CHANGE");
                        for (int k = 0; k < vChLst.size(); ++k) {
                            WebZncliDO vcCli = (WebZncliDO)vChLst.get(k);
                            if (vcCli.cliCmds == null || vcCli.cliCmds.length <= 0) continue;
                            WebZnSwitchDO swdo = (WebZnSwitchDO)swDBID2SWDO.get(vcCli.swDBID);
                            System.out.println("VSAN Change on Switch : " + (swdo == null ? "null" : swdo.ipAddress));
                            for (int c = 0; c < vcCli.cliCmds.length; ++c) {
                                System.out.println(vcCli.cliCmds[c]);
                            }
                        }
                    }
                    WebZncliDO znCli = (WebZncliDO)obCli[1];
                    if (znCli.cliCmds == null || znCli.cliCmds.length <= 0) continue;
                    WebZnSwitchDO swdo = (WebZnSwitchDO)swDBID2SWDO.get(znCli.swDBID);
                    System.out.println("Zoning CLI Principal Switch:" + swdo.ipAddress);
                    for (int k = 0; k < znCli.cliCmds.length; ++k) {
                        System.out.println(znCli.cliCmds[k]);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void updateZoneSwitchProperties(WebZnSwitchDO swdo, WebZnVsanDO vDo) throws SnmpException {
        SnmpPeer peer;
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("zoneDbEnforcedEqualsLocal").getOid(), vDo.vsanIndex);
        vbl.add(MibNode.get("czseOperationMode").getOid(), vDo.vsanIndex);
        vbl.add(MibNode.get("czseSessionOwnerType").getOid(), vDo.vsanIndex);
        vbl.add(MibNode.get("czseSessionOwner").getOid(), vDo.vsanIndex);
        vbl.add(MibNode.get("zoneEnforcedZoneSetName").getOid(), vDo.vsanIndex);
        SwitchImpl swImpl = null;
        try {
            swImpl = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(swdo.ipAddress));
        }
        catch (UnknownHostException ex) {
            _Logger.error((Object)("Failed to find Switch " + swdo.ipAddress));
        }
        SnmpPeer snmpPeer = swImpl != null && swImpl.getPeer() != null ? swImpl.getPeer() : (peer = standalone ? PolicyBasedZoning.getPeer(swdo.ipAddress) : null);
        if (peer != null) {
            VarBindList vbPut = SnmpFetch.get(peer, vbl).getVariables();
            SnmpVarBind sVar = vbPut.get(0);
            if (!sVar.isNull()) {
                vDo.isActLocalEqualOnPrSw = sVar.intValue() == 1;
            }
            vDo.isEnhancedPrSw = !vbPut.get(1).isNull() && vbPut.intValue(1) == 2;
            int ownerType = vbPut.getVb(2).getVar().getType() != 5 ? vbPut.intValue(2) : -1;
            vDo.isLockedPrSw = ownerType != -1;
            vDo.actZnst = vbPut.getVb(4).getVar().getType() != 5 ? vbPut.stringValue(4) : "";
        }
    }

    public static SnmpPeer getPeer(String ipAddress) {
        UsmUser snmpUser = new UsmUser("admin", 0, "nbv_12345");
        try {
            SnmpSession ses = SnmpSession.getInstance();
            ses.open("udp", new UdpTransportOptions(null, 0));
            SnmpPeer peer = SnmpPeer.getSnmpPeer(InetAddress.getByName(ipAddress), ses, snmpUser);
            return peer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<WebZnVsancliDO> generateCLICmds(WebZnEndPortDataDO[][] portPairData) throws Exception {
        HashMap<String, ArrayList<Object[]>> vDBID2Zoning = new HashMap<String, ArrayList<Object[]>>();
        ArrayList<WebZnVsancliDO> wbvchLst = new ArrayList<WebZnVsancliDO>();
        if (portPairData != null) {
            for (int i = 0; i < portPairData.length; ++i) {
                WebZnEndPortDataDO[] pairLst = portPairData[i];
                if (pairLst.length < 2) continue;
                WebZnEndPortDataDO hPort = pairLst[0];
                WebZnEndPortDataDO sPort1 = pairLst[1];
                int vsanIndex = -1;
                WebZncliDO vccli = null;
                if (hPort.vsanDBID != sPort1.vsanDBID) {
                    vccli = new WebZncliDO();
                    vccli.swDBID = hPort.attSwDBID;
                    vccli.swIpAddress = hPort.attSwIpAddress;
                    vccli.isVsanChangeCli = true;
                    String tmpCmd = " vsan " + sPort1.vsanIndex + " interface " + hPort.ifName;
                    String notmpCmd = " vsan " + hPort.vsanIndex + " interface " + hPort.ifName;
                    vccli.cliCmds = new WebZncliDO.cliCmdDO[]{new WebZncliDO.cliCmdDO("#Apply to " + vccli.swIpAddress, "S", 100), new WebZncliDO.cliCmdDO("conf t", "S", 1), new WebZncliDO.cliCmdDO("vsan database", "S", 3), new WebZncliDO.cliCmdDO(tmpCmd, notmpCmd, 4), new WebZncliDO.cliCmdDO("end", "S", 2)};
                }
                vsanIndex = sPort1.vsanIndex;
                ArrayList<WebZnVsancliDO.HostStgZone> znHSZoneNameLst = new ArrayList<WebZnVsancliDO.HostStgZone>();
                ArrayList<WebZncliDO.cliCmdDO> znCliCmdLst = new ArrayList<WebZncliDO.cliCmdDO>();
                String tmpCmd = "zone name " + hPort.newZnName + " vsan " + vsanIndex;
                znCliCmdLst.add(new WebZncliDO.cliCmdDO(tmpCmd, "no " + tmpCmd, 6));
                znHSZoneNameLst.add(new WebZnVsancliDO.HostStgZone(hPort.enclosureName, sPort1.enclosureName, hPort.newZnName));
                if (hPort.da != null && hPort.da.trim().length() > 0) {
                    znCliCmdLst.add(new WebZncliDO.cliCmdDO(" member device-alias " + hPort.da, "I", 8));
                } else {
                    znCliCmdLst.add(new WebZncliDO.cliCmdDO(" member pwwn " + SnmpString.toHexString(hPort.wwn), "I", 8));
                }
                for (int j = 1; j < pairLst.length; ++j) {
                    WebZnEndPortDataDO stgPrt = pairLst[j];
                    if (vsanIndex != stgPrt.vsanIndex) {
                        throw new Exception("Selected storage Ports in different VSAN");
                    }
                    if (stgPrt.da != null && stgPrt.da.trim().length() > 0) {
                        znCliCmdLst.add(new WebZncliDO.cliCmdDO(" member device-alias " + stgPrt.da, "I", 8));
                        continue;
                    }
                    znCliCmdLst.add(new WebZncliDO.cliCmdDO(" member pwwn " + SnmpString.toHexString(stgPrt.wwn), "I", 8));
                }
                znCliCmdLst.add(new WebZncliDO.cliCmdDO("end ", "S", 2));
                ArrayList<Object[]> data = (ArrayList<Object[]>)vDBID2Zoning.get(Long.toString(sPort1.vsanDBID));
                if (data == null) {
                    data = new ArrayList<Object[]>();
                    vDBID2Zoning.put(Long.toString(sPort1.vsanDBID), data);
                }
                data.add(new Object[]{vccli, sPort1, znCliCmdLst, znHSZoneNameLst});
            }
            for (Map.Entry obEntry : vDBID2Zoning.entrySet()) {
                long vsanDBID = Long.parseLong((String)obEntry.getKey());
                ArrayList znVal = (ArrayList)obEntry.getValue();
                if (znVal == null || znVal.size() <= 0) continue;
                ArrayList<WebZncliDO> vsanChangeCliCmdLst = new ArrayList<WebZncliDO>();
                ArrayList<WebZncliDO.cliCmdDO> allZnCliCmdLst = new ArrayList<WebZncliDO.cliCmdDO>();
                ArrayList allZnHSZoneNameLst = new ArrayList();
                WebZnVsancliDO vsancli = null;
                WebZnEndPortDataDO sPrt = null;
                for (int i = 0; i < znVal.size(); ++i) {
                    Object[] dataVal = (Object[])znVal.get(i);
                    WebZncliDO vcCli = (WebZncliDO)dataVal[0];
                    sPrt = (WebZnEndPortDataDO)dataVal[1];
                    ArrayList znCliCmdLst = (ArrayList)dataVal[2];
                    ArrayList znHSZoneNameLst = (ArrayList)dataVal[3];
                    if (znCliCmdLst == null || znCliCmdLst.size() <= 0) continue;
                    if (vcCli != null) {
                        vsanChangeCliCmdLst.add(vcCli);
                    }
                    if (i == 0) {
                        vsancli = new WebZnVsancliDO();
                        vsancli.vsanDBID = sPrt.vsanDBID;
                        vsancli.vsanName = sPrt.vsanName;
                        vsancli.fabricDBID = sPrt.fabricDBID;
                        vsancli.fabricName = sPrt.fabricName;
                        vsancli.actZnst = "";
                        vsancli.vsanIndex = sPrt.vsanIndex;
                        vsancli.principalSwIpAddress = GlobalFabricManager.getInstance().getIpAddressOfSwitch(sPrt.principalSwDBID);
                        try {
                            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(sPrt.fabricDBID);
                            vsancli = rif.updateZoneSwitchProperties(vsancli.principalSwIpAddress, vsancli);
                            if (allZnCliCmdLst.size() == 0) {
                                String znstName;
                                allZnCliCmdLst.add(new WebZncliDO.cliCmdDO("#Apply to " + vsancli.principalSwIpAddress, "S", 100));
                                allZnCliCmdLst.add(new WebZncliDO.cliCmdDO("conf t", "S", 1));
                                vsancli.appliedZnstName = znstName = vsancli.actZnst == null || vsancli.actZnst.trim().length() == 0 ? "ZS-VSAN-" + vsancli.vsanIndex + "-" + vsancli.principalSwIpAddress : vsancli.actZnst;
                                String tmpCmd = "zoneset name " + znstName + " vsan " + vsancli.vsanIndex;
                                allZnCliCmdLst.add(new WebZncliDO.cliCmdDO(tmpCmd, "no " + tmpCmd, 5));
                            }
                        }
                        catch (Exception ex) {
                            _Logger.error((Object)ex.getMessage());
                            throw new SanServiceException(ex.getMessage());
                        }
                        if (!wbvchLst.contains(vsancli)) {
                            wbvchLst.add(vsancli);
                        }
                    }
                    allZnCliCmdLst.addAll(znCliCmdLst);
                    if (znHSZoneNameLst == null) continue;
                    allZnHSZoneNameLst.addAll(znHSZoneNameLst);
                }
                if (vsancli == null || sPrt == null) continue;
                WebZncliDO znClicmd = new WebZncliDO();
                znClicmd.swDBID = sPrt.principalSwDBID;
                znClicmd.swIpAddress = sPrt.principalSwIpAddress;
                WebZncliDO znActClicmd = new WebZncliDO();
                znActClicmd.swDBID = sPrt.principalSwDBID;
                znActClicmd.swIpAddress = sPrt.principalSwIpAddress;
                ArrayList<WebZncliDO.cliCmdDO> actZnCliCmdLst = new ArrayList<WebZncliDO.cliCmdDO>();
                String znstName = vsancli.actZnst == null || vsancli.actZnst.trim().length() == 0 ? "ZS-VSAN-" + vsancli.vsanIndex + "-" + vsancli.principalSwIpAddress : vsancli.actZnst;
                actZnCliCmdLst.add(new WebZncliDO.cliCmdDO("conf t", "S", 1));
                actZnCliCmdLst.add(new WebZncliDO.cliCmdDO("zoneset activate name " + znstName + " vsan " + vsancli.vsanIndex, "S", 7));
                actZnCliCmdLst.add(new WebZncliDO.cliCmdDO("end", "S", 2));
                if (vsancli.isEnhancedPrSw) {
                    actZnCliCmdLst.add(new WebZncliDO.cliCmdDO("conf t", "S", 1));
                    actZnCliCmdLst.add(new WebZncliDO.cliCmdDO("zone commit vsan " + vsancli.vsanIndex + " force", "S", 10));
                    actZnCliCmdLst.add(new WebZncliDO.cliCmdDO("end", "S", 2));
                }
                znActClicmd.cliCmds = actZnCliCmdLst.toArray(new WebZncliDO.cliCmdDO[0]);
                znClicmd.cliCmds = allZnCliCmdLst.toArray(new WebZncliDO.cliCmdDO[0]);
                vsanChangeCliCmdLst.add(znClicmd);
                vsancli.cliCmdsDO = vsanChangeCliCmdLst.toArray(new WebZncliDO[0]);
                vsancli.hostStgZone = allZnHSZoneNameLst.toArray(new WebZnVsancliDO.HostStgZone[0]);
                vsancli.activationCliCmdsDO = new WebZncliDO[]{znActClicmd};
            }
        }
        return wbvchLst;
    }

    public static HashMap generateCLICmds(HashMap hPrt2StgList, HashMap vDBID2VDO) {
        HashMap<Long, Object[]> vsan2SwitchCliMap = new HashMap<Long, Object[]>();
        for (Map.Entry entry : hPrt2StgList.entrySet()) {
            WebZnEndPortDO hPrt = (WebZnEndPortDO)entry.getKey();
            WebZnVsanDO hvDo = (WebZnVsanDO)vDBID2VDO.get(hPrt.vsanDBID);
            boolean vsanChanged = false;
            ArrayList stgPrtLst = (ArrayList)entry.getValue();
            if (stgPrtLst == null || stgPrtLst.size() <= 0) continue;
            WebZnEndPortDO stgprt = (WebZnEndPortDO)stgPrtLst.get(0);
            WebZnVsanDO vDo = (WebZnVsanDO)vDBID2VDO.get(stgprt.vsanDBID);
            int vsanIndex = vDo.vsanIndex;
            Object[] obb = (Object[])vsan2SwitchCliMap.get(vDo.DBID);
            if (obb == null) {
                ArrayList wbvchLst = new ArrayList();
                obb = new Object[]{wbvchLst, new WebZncliDO(), new ArrayList()};
                ((WebZncliDO)obb[1]).swDBID = vDo.principalSwDBID;
                vsan2SwitchCliMap.put(vDo.DBID, obb);
            }
            ArrayList znCliCmdLst = (ArrayList)obb[2];
            if (hvDo.DBID != vDo.DBID && !vsanChanged) {
                ArrayList wbvchLst = (ArrayList)obb[0];
                WebZncliDO vccli = new WebZncliDO();
                vccli.swDBID = hPrt.attSwDBID;
                vccli.isVsanChangeCli = true;
                wbvchLst.add(vccli);
                vsanChanged = true;
            }
            WebZncliDO wbZnCLI = (WebZncliDO)obb[1];
            wbZnCLI.swDBID = vDo.principalSwDBID;
            wbZnCLI.swIpAddress = vDo.prinswName;
            znCliCmdLst.add(0, "conf t");
            znCliCmdLst.add("zone name " + hPrt.newZnName + " vsan " + vsanIndex);
            if (hPrt.da != null && hPrt.da.trim().length() > 0) {
                znCliCmdLst.add("member device-alias " + hPrt.da);
            } else {
                znCliCmdLst.add("member pwwn " + SnmpString.toHexString(hPrt.wwn));
            }
            for (int i = 0; i < stgPrtLst.size(); ++i) {
                WebZnEndPortDO stPrt = (WebZnEndPortDO)stgPrtLst.get(i);
                if (stPrt.da != null && stPrt.da.trim().length() > 0) {
                    znCliCmdLst.add("member device-alias " + stPrt.da);
                    continue;
                }
                znCliCmdLst.add("member pwwn " + SnmpString.toHexString(stPrt.wwn));
            }
            znCliCmdLst.add("end");
            if (znCliCmdLst.size() <= 0) continue;
            znCliCmdLst.add(0, "conf t");
            znCliCmdLst.add(" zoneset activate " + vDo.actZnst + " vsan " + vDo.vsanIndex);
            znCliCmdLst.add("end");
        }
        for (Map.Entry entry : vsan2SwitchCliMap.entrySet()) {
            Object[] obb = (Object[])entry.getValue();
            WebZncliDO wbZnCLI = (WebZncliDO)obb[1];
            ArrayList znCliCmdLst = (ArrayList)obb[2];
            wbZnCLI.cliCmds = znCliCmdLst.toArray(new WebZncliDO.cliCmdDO[znCliCmdLst.size()]);
            entry.setValue(new Object[]{obb[0], wbZnCLI});
        }
        return vsan2SwitchCliMap;
    }

    public StringBuffer validatePortPairForVSAN(HashMap hPrt2StgList) {
        StringBuffer error = new StringBuffer();
        for (Map.Entry obEntry : hPrt2StgList.entrySet()) {
            ArrayList stgPrtLst = (ArrayList)obEntry.getValue();
            if (stgPrtLst == null) continue;
            long vsanDBID = -1L;
            for (int i = 0; i < stgPrtLst.size(); ++i) {
                WebZnEndPortDO stPrt = (WebZnEndPortDO)stgPrtLst.get(i);
                if (vsanDBID == -1L) {
                    vsanDBID = stPrt.vsanDBID;
                    continue;
                }
                if (vsanDBID == stPrt.vsanDBID) continue;
                error.append("Selected Storage Ports in 2 VSANs " + vsanDBID + " and " + stPrt.vsanDBID);
                return error;
            }
        }
        return error;
    }

    public static WebZnEnclosureDO[] getUnzonedHostEnclosures() throws SQLException {
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        ArrayList<WebZnEnclosureDO> encDoLst = new ArrayList<WebZnEnclosureDO>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(UNZONED_HOST_ENCLOSURE_SQL);
            rs = stat.executeQuery();
            while (rs.next()) {
                WebZnEnclosureDO encDo = new WebZnEnclosureDO();
                encDo.setDbid(rs.getLong(1));
                encDo.setName(rs.getString(2));
                byte[] ipAdd = rs.getBytes(3);
                encDo.setIpaddress(ipAdd != null ? new SnmpIpAddress(ipAdd).toString() : "");
                encDo.setOs(rs.getString(4) == null ? "" : rs.getString(4));
                encDo.isStorage = rs.getInt(5) != 47;
                encDo.setNumPorts(rs.getInt(6));
                if (encDo.isStorage()) continue;
                encDoLst.add(encDo);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"getUnzonedEnclosures: caught exception", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return encDoLst.toArray(new WebZnEnclosureDO[encDoLst.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebZnEnclosureDO[] getEligibleStorageEnclosuresForHostEnclosure(long hostEncDBID) {
        ArrayList<WebZnEnclosureDO> encDoLst;
        block8: {
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            encDoLst = new ArrayList<WebZnEnclosureDO>();
            try {
                byte[] ipAdd;
                WebZnEnclosureDO encDo;
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(STRG_ENC_FOR_ENCID);
                stat.setLong(1, hostEncDBID);
                rs = stat.executeQuery();
                while (rs.next()) {
                    encDo = new WebZnEnclosureDO();
                    encDo.setDbid(rs.getLong(1));
                    encDo.setName(rs.getString(2));
                    ipAdd = rs.getBytes(3);
                    encDo.setIpaddress(ipAdd != null ? new SnmpIpAddress(ipAdd).toString() : "");
                    encDo.setNumPorts(rs.getInt(4));
                    encDoLst.add(encDo);
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(STRG_ENC_FOR_ENCID_WITH_VSAN1_PORT);
                stat.setLong(1, hostEncDBID);
                rs = stat.executeQuery();
                while (rs.next()) {
                    encDo = new WebZnEnclosureDO();
                    encDo.setDbid(rs.getLong(1));
                    encDo.setName(rs.getString(2));
                    ipAdd = rs.getBytes(3);
                    encDo.setNumPorts(rs.getInt(4));
                    encDo.setIpaddress(ipAdd != null ? new SnmpIpAddress(ipAdd).toString() : "");
                    int obIndex = encDoLst.indexOf(encDo);
                    if (obIndex == -1) {
                        encDoLst.add(encDo);
                        continue;
                    }
                    WebZnEnclosureDO enDoEx = (WebZnEnclosureDO)encDoLst.get(obIndex);
                    enDoEx.setNumPorts(enDoEx.getNumPorts() + rs.getInt(4));
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                _Logger.warn((Object)"getEndPortsForVSAN: caught exception", (Throwable)e);
                break block8;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return encDoLst.toArray(new WebZnEnclosureDO[encDoLst.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getEligibleVsansForHostEnclosure(long henclId, WebZnEndPortDO[] enPrt) {
        HashMap hpDBIDtoEligibleVSANDBIDListMap;
        HashMap<Long, Long> hpDBIDtoSwitchDBIDMap;
        HashMap swDBIDtoVsanDBIDListMap;
        block19: {
            swDBIDtoVsanDBIDListMap = new HashMap();
            hpDBIDtoSwitchDBIDMap = new HashMap<Long, Long>();
            hpDBIDtoEligibleVSANDBIDListMap = new HashMap();
            ArrayList<Long> swLst = new ArrayList<Long>();
            StringBuffer swQuery = new StringBuffer();
            if (enPrt != null) {
                int i;
                for (i = 0; i < enPrt.length; ++i) {
                    if (enPrt[i].vsanIndex != 1) {
                        enPrt[i].eligibleVsanDBIDList = new long[]{enPrt[i].vsanDBID};
                        continue;
                    }
                    hpDBIDtoSwitchDBIDMap.put(enPrt[i].DBID, enPrt[i].attSwDBID);
                    if (swLst.contains(enPrt[i].attSwDBID)) continue;
                    swLst.add(enPrt[i].attSwDBID);
                }
                if (swLst.size() > 0) {
                    swQuery.append("( ");
                }
                for (i = 0; i < swLst.size(); ++i) {
                    Long swdoDBID = (Long)swLst.get(i);
                    if (i > 0) {
                        swQuery.append(" OR ");
                    }
                    swQuery.append("vd.switch_id=" + swdoDBID);
                }
                if (swLst.size() > 0) {
                    swQuery.append(" )");
                }
            }
            if (swQuery.length() > 0) {
                Connection con = null;
                ResultSet rs = null;
                PreparedStatement stat = null;
                ArrayList encDoLst = new ArrayList();
                try {
                    con = ConnectionManager.getConnection();
                    stat = con.prepareStatement(SWITCH_VSANS + swQuery + " ORDER BY vd.switch_id ASC ");
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        long swDBID = rs.getLong(1);
                        long vsanDBID = rs.getLong(2);
                        ArrayList<Long> vsanLst = (ArrayList<Long>)swDBIDtoVsanDBIDListMap.get(swDBID);
                        if (vsanLst == null) {
                            vsanLst = new ArrayList<Long>();
                            swDBIDtoVsanDBIDListMap.put(swDBID, vsanLst);
                        }
                        if (vsanLst.contains(vsanDBID)) continue;
                        vsanLst.add(vsanDBID);
                    }
                    if (enPrt != null) {
                        for (int i = 0; i < enPrt.length; ++i) {
                            if (enPrt[i].vsanIndex != 1) continue;
                            long swDbid = (Long)hpDBIDtoSwitchDBIDMap.get(enPrt[i].DBID);
                            ArrayList vLst = (ArrayList)swDBIDtoVsanDBIDListMap.get(swDbid);
                            Long[] vLLong = vLst.toArray(new Long[vLst.size()]);
                            long[] vLs = new long[]{};
                            if (vLLong != null) {
                                vLs = new long[vLLong.length];
                                for (int j = 0; j < vLLong.length; ++j) {
                                    vLs[j] = vLLong[j];
                                }
                            }
                            enPrt[i].eligibleVsanDBIDList = vLs;
                        }
                    }
                    DbUtil.close(rs);
                }
                catch (SQLException e) {
                    _Logger.warn((Object)"getEligibleVsansForHostEnclosure: caught exception", (Throwable)e);
                    break block19;
                }
                finally {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                }
                DbUtil.close(stat);
                DbUtil.close(con);
            }
        }
        return new Object[]{hpDBIDtoSwitchDBIDMap, swDBIDtoVsanDBIDListMap, hpDBIDtoEligibleVSANDBIDListMap};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateZoneCount(long enclID, WebZnEndPortDO[] enPrt) {
        block8: {
            HashMap<Long, Integer> epDBIDToZnCount = new HashMap<Long, Integer>();
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            ArrayList encDoLst = new ArrayList();
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(ENCL_EPORT_ACTIVE_ZONES_COUNT);
                stat.setLong(1, enclID);
                rs = stat.executeQuery();
                while (rs.next()) {
                    WebZnEnclosureDO encDo = new WebZnEnclosureDO();
                    epDBIDToZnCount.put(rs.getLong(1), rs.getInt(2));
                }
                if (enPrt != null && epDBIDToZnCount.size() > 0) {
                    for (int i = 0; i < enPrt.length; ++i) {
                        Integer numZones = (Integer)epDBIDToZnCount.get(enPrt[i].DBID);
                        enPrt[i].numZones = numZones != null ? numZones : 0;
                    }
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                _Logger.warn((Object)"getEndPortsForVSAN: caught exception", (Throwable)e);
                break block8;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateTrafficForEnclosure(long enclID, WebZnEndPortDO[] enPrt) {
        block8: {
            HashMap<Long, Object[]> epDBIDToZnCount = new HashMap<Long, Object[]>();
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            ArrayList encDoLst = new ArrayList();
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(ENCL_EPORT_RXTX);
                stat.setLong(1, enclID);
                rs = stat.executeQuery();
                while (rs.next()) {
                    WebZnEnclosureDO encDo = new WebZnEnclosureDO();
                    epDBIDToZnCount.put(rs.getLong(1), new Object[]{rs.getDouble(2), rs.getDouble(3)});
                }
                if (enPrt != null && epDBIDToZnCount.size() > 0) {
                    for (int i = 0; i < enPrt.length; ++i) {
                        Object[] rxTx = (Object[])epDBIDToZnCount.get(enPrt[i].DBID);
                        enPrt[i].avgRx = DefaultSnmpNumberRenderer.formatFloat((Double)rxTx[0] == Double.NaN ? 0.0 : (Double)rxTx[0]);
                        enPrt[i].avgTx = DefaultSnmpNumberRenderer.formatFloat((Double)rxTx[1] == Double.NaN ? 0.0 : (Double)rxTx[1]);
                    }
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                _Logger.warn((Object)"getEndPortsForVSAN: caught exception", (Throwable)e);
                break block8;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    private static WebZnEndPortDataDO buildDoforWeb(WebZnEndPortDO refPrt, WebZnSwitchDO swrefdo, WebZnVsanDO vDo, WebZnFabricDO fDo, WebZnSwitchDO swPrinsdo) {
        WebZnEndPortDataDO epH = new WebZnEndPortDataDO();
        epH.attSwDBID = swrefdo != null ? swrefdo.DBID : -1L;
        epH.attSwName = swrefdo != null ? swrefdo.sys_name : "";
        epH.attSwIpAddress = swrefdo != null ? swrefdo.ipAddress : "";
        epH.avgRx = refPrt.avgRx;
        epH.avgTx = refPrt.avgTx;
        epH.DBID = refPrt.DBID;
        epH.fabricName = fDo.name;
        epH.fabricDBID = fDo.DBID;
        String appendStr = "";
        String string = vDo.prinswName = swPrinsdo != null ? swPrinsdo.sys_name : "";
        if (vDo.name.indexOf(vDo.vsanIndex) == -1) {
            appendStr = "(" + vDo.vsanIndex + ")";
        }
        if (vDo.isSegmented) {
            appendStr = "(Seg@" + vDo.prinswName + ")";
        }
        epH.vsanName = vDo.name + appendStr;
        epH.ifName = refPrt.ifName;
        epH.name = refPrt.name;
        epH.numZones = refPrt.numZones;
        epH.principalSwDBID = vDo.principalSwDBID;
        epH.principalSwName = vDo.prinswName;
        epH.vsanDBID = vDo.DBID;
        epH.vsanIndex = vDo.vsanIndex;
        epH.wwn = refPrt.wwn;
        epH.da = refPrt.da;
        epH.isSegmentedVSAN = vDo.isSegmented;
        return epH;
    }

    public static Object[] buildHost2StorageList(WebZnEnclosureDO hsEncdo, WebZnEnclosureDO stgEncdo) {
        return PolicyBasedZoning.buildHost2StorageList(hsEncdo.getDbid(), stgEncdo.getDbid());
    }

    public static WebZnHstPortStgPortListDO[] getHost2StoragePortsMapping(long hclDBID, long stgDBID) {
        Object[] ob = PolicyBasedZoning.buildHost2StorageList(hclDBID, stgDBID);
        WebZnEndPortDO[] hPorts = (WebZnEndPortDO[])ob[0];
        WebZnEndPortDO[] sPorts = (WebZnEndPortDO[])ob[1];
        Object[] elVsanData = (Object[])ob[2];
        HashMap elVsanMap = (HashMap)elVsanData[2];
        HashMap vDBID2VDO = (HashMap)ob[3];
        HashMap faDBID2faDO = (HashMap)ob[4];
        HashMap swDBID2SWDO = (HashMap)ob[5];
        HashMap<Long, WebZnEndPortDO> hPortDBIDtoHostPort = new HashMap<Long, WebZnEndPortDO>();
        WebZnEndPortDO refPrt = null;
        if (hPorts != null) {
            ArrayList<WebZnHstPortStgPortListDO> h2StgList = new ArrayList<WebZnHstPortStgPortListDO>();
            for (int i = 0; i < hPorts.length; ++i) {
                refPrt = hPorts[i];
                WebZnHstPortStgPortListDO refPrtDO = new WebZnHstPortStgPortListDO();
                WebZnSwitchDO swrefdo = (WebZnSwitchDO)swDBID2SWDO.get(refPrt.attSwDBID);
                WebZnVsanDO vDo = (WebZnVsanDO)vDBID2VDO.get(refPrt.vsanDBID);
                WebZnSwitchDO swPrnco = (WebZnSwitchDO)swDBID2SWDO.get(vDo.principalSwDBID);
                WebZnFabricDO fDo = (WebZnFabricDO)faDBID2faDO.get(vDo.fabDBID);
                refPrtDO.hstPort = PolicyBasedZoning.buildDoforWeb(refPrt, swrefdo, vDo, fDo, swPrnco);
                System.out.println("H:" + refPrt.DBID + "   " + refPrt.da + "   " + vDo.name + "   " + (swrefdo != null ? swrefdo.sys_name : "Unknown") + " " + refPrt.ifName + "   " + refPrt.numZones + "   " + refPrt.avgRx + "  " + refPrt.avgTx);
                hPortDBIDtoHostPort.put(refPrt.DBID, refPrt);
                if (sPorts == null) continue;
                long[] vLst = hPorts[i].eligibleVsanDBIDList;
                if (vLst == null) {
                    System.out.println("     No eligible Storage Ports.");
                    continue;
                }
                int sportsDetected = 0;
                ArrayList<WebZnEndPortDataDO> stgPrtList = new ArrayList<WebZnEndPortDataDO>();
                for (int k = 0; k < vLst.length; ++k) {
                    long vDBID = vLst[k];
                    for (int j = 0; j < sPorts.length; ++j) {
                        refPrt = sPorts[j];
                        if (hPortDBIDtoHostPort.get(refPrt.DBID) == null) {
                            hPortDBIDtoHostPort.put(refPrt.DBID, refPrt);
                        }
                        vDo = (WebZnVsanDO)vDBID2VDO.get(refPrt.vsanDBID);
                        WebZnSwitchDO swsrefdo = (WebZnSwitchDO)swDBID2SWDO.get(refPrt.attSwDBID);
                        WebZnSwitchDO swsPrnco = (WebZnSwitchDO)swDBID2SWDO.get(vDo.principalSwDBID);
                        if (vDBID != vDo.DBID) continue;
                        ++sportsDetected;
                        stgPrtList.add(PolicyBasedZoning.buildDoforWeb(refPrt, swrefdo, vDo, fDo, swsPrnco));
                        System.out.println("   S:" + refPrt.DBID + "   " + refPrt.da + "   " + vDo.name + "   " + (swsrefdo != null ? swsrefdo.sys_name : "Unknown") + " " + refPrt.ifName + "   " + refPrt.numZones + "   " + vDo.name + "   " + refPrt.avgRx + "  " + refPrt.avgTx);
                    }
                }
                if (sportsDetected == 0) {
                    System.out.println("     No eligible Storage Ports.");
                    continue;
                }
                char[] sugZnName = ("Z-VSAN-" + vDo.vsanIndex + "-" + hPorts[i].name).toCharArray();
                char[] chZn = new char[sugZnName.length];
                for (int j = 0; j < sugZnName.length; ++j) {
                    chZn[j] = sugZnName[j] >= 'a' && sugZnName[j] <= 'z' || sugZnName[j] >= 'A' && sugZnName[j] <= 'Z' || sugZnName[j] >= '0' && sugZnName[j] <= '9' || sugZnName[j] == '-' || sugZnName[j] == '^' || sugZnName[j] == '_' || sugZnName[j] == '$' ? sugZnName[j] : 45;
                }
                hPorts[i].newZnName = String.valueOf(chZn);
                refPrtDO.hstPort.newZnName = hPorts[i].newZnName.replace(' ', '-');
                refPrtDO.stgPrtList = stgPrtList.toArray(new WebZnEndPortDataDO[0]);
                if (refPrtDO.stgPrtList != null) {
                    Arrays.sort(refPrtDO.stgPrtList);
                }
                h2StgList.add(refPrtDO);
            }
            Object[] outData = h2StgList.toArray(new WebZnHstPortStgPortListDO[0]);
            if (outData != null) {
                Arrays.sort(outData);
            }
            return outData;
        }
        return new WebZnHstPortStgPortListDO[0];
    }

    public static String getCLIResultForZoning(int id, long fabricDBID) throws Exception {
        String out = "";
        RunCLIThread runcli = PolicyBasedZoning.getRunCLIThread(id);
        if (runcli != null) {
            if (runcli.isError() && runcli.errException != null) {
                throw runcli.errException;
            }
            return runcli.getOutput().toString();
        }
        throw new Exception("Unable to find cli generator with id:" + id + " for fabric " + fabricDBID);
    }

    public static boolean isCliCmdFinished(int id, long fabricDBID) throws Exception {
        RunCLIThread runcli = PolicyBasedZoning.getRunCLIThread(id);
        if (runcli != null) {
            if (runcli.isError() && runcli.errException != null) {
                throw runcli.errException;
            }
            return runcli.isFinished();
        }
        throw new Exception("Unable to find cli generator with id:" + id + " for fabric " + fabricDBID);
    }

    public static String getZoneActDeact(int id, long fabricDBID) throws Exception {
        RunCLIThread runcli = PolicyBasedZoning.getRunCLIThread(id);
        if (runcli != null) {
            runcli.getActivationStatus();
            if (runcli.isError() && runcli.errException != null) {
                throw runcli.errException;
            }
            String out = runcli.getOutput().toString();
            runcli.getOutput().setLength(0);
            return out;
        }
        throw new Exception("Unable to find cli generator with id:" + id + " for fabric " + fabricDBID);
    }

    public static int createRunCLIForZoning(WebZnVsancliDO cliData) throws Exception {
        RunCLIThread runcli = new RunCLIThread(cliData, false);
        Thread th = new Thread(runcli);
        th.start();
        return runcli.getId();
    }

    public static int runActivationCommitCmds(WebZnVsancliDO cliData) throws Exception {
        RunCLIThread runcli = new RunCLIThread(cliData, true);
        Thread th = new Thread(runcli);
        th.start();
        return runcli.getId();
    }

    private static VshBase getVshConnection(String swIpAddress, StringBuffer output) {
        VshBase vsh = null;
        try {
            SnmpPeer prr;
            SwitchImpl swImpl = null;
            swImpl = SanManager.getInstance().findSwitchByIP(InetAddress.getByName(swIpAddress));
            SnmpPeer snmpPeer = prr = swImpl != null && swImpl.getPeer() != null ? swImpl.getPeer() : null;
            if (prr != null && (vsh = VshBase.getNew(null, prr.getAddress().getHostAddress(), prr.getUserName(), prr.getAuthPassword(), ExternalTools._UseSSH, null)) == null) {
                _Logger.error((Object)("Unable to open connection to Switch " + prr));
                output.append("Unable to open connection to Switch " + prr + "\n");
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            if (ex instanceof IOException) {
                _Logger.error((Object)"FMS may have lost network connectivity");
            }
            output.append(ex.getMessage() + "\n");
        }
        return vsh;
    }

    public static Object[] buildHost2StorageList(long hsEncdo, long stgEncdo) {
        HashMap vDBID2VDO = new HashMap();
        HashMap faDBID2faDO = new HashMap();
        HashMap swDBID2SWDO = new HashMap();
        Object[] hostPortsOb = PolicyBasedZoning.getEndPortsForEnclosure(hsEncdo, vDBID2VDO, faDBID2faDO, swDBID2SWDO);
        WebZnEndPortDO[] hostPorts = (WebZnEndPortDO[])hostPortsOb[0];
        Object[] stgPortsOb = PolicyBasedZoning.getEndPortsForEnclosure(stgEncdo, vDBID2VDO, faDBID2faDO, swDBID2SWDO);
        WebZnEndPortDO[] stgPorts = (WebZnEndPortDO[])stgPortsOb[0];
        PolicyBasedZoning.populateZoneCount(stgEncdo, stgPorts);
        PolicyBasedZoning.populateTrafficForEnclosure(stgEncdo, stgPorts);
        Object[] obv = PolicyBasedZoning.getEligibleVsansForHostEnclosure(hsEncdo, hostPorts);
        return new Object[]{hostPorts, stgPorts, obv, vDBID2VDO, faDBID2faDO, swDBID2SWDO};
    }

    public static StringBuffer updateZoneSwitchProperties(HashMap vDBID2VDO, HashMap swDBID2SWDO) {
        StringBuffer errMsg = new StringBuffer();
        for (Map.Entry obEntry : vDBID2VDO.entrySet()) {
            Long vDBid = (Long)obEntry.getKey();
            WebZnVsanDO hvDo = (WebZnVsanDO)vDBID2VDO.get(vDBid);
            WebZnSwitchDO swdo = (WebZnSwitchDO)swDBID2SWDO.get(hvDo.principalSwDBID);
            try {
                PolicyBasedZoning.updateZoneSwitchProperties(swdo, hvDo);
            }
            catch (SnmpException ex) {
                errMsg.append(ex.getMessage() + "\n");
            }
        }
        return errMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getEndPortsForEnclosure(long enclosureDBID, HashMap vDBID2VDO, HashMap faDBID2faDO, HashMap swDBID2SWDO) {
        ArrayList<Long> pSwDBIDLst;
        ArrayList<WebZnEndPortDO> wbepLst;
        block12: {
            wbepLst = new ArrayList<WebZnEndPortDO>();
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            pSwDBIDLst = new ArrayList<Long>();
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(ENCLOSURE_END_PORT);
                stat.setLong(1, enclosureDBID);
                rs = stat.executeQuery();
                while (rs.next()) {
                    WebZnEndPortDO epzn = new WebZnEndPortDO();
                    epzn.DBID = rs.getLong(3);
                    epzn.wwn = rs.getBytes(4);
                    epzn.name = rs.getString(5);
                    WebZnSwitchDO attSw = new WebZnSwitchDO();
                    epzn.attSwDBID = rs.getLong(19);
                    attSw.sys_name = rs.getString(14);
                    attSw.DBID = epzn.attSwDBID;
                    byte[] ipAdd = rs.getBytes(16);
                    attSw.ipAddress = ipAdd != null ? new SnmpIpAddress(ipAdd).toString() : "";
                    attSw.type = -1;
                    epzn.zonesDBID = null;
                    epzn.ifName = rs.getString(8);
                    WebZnVsanDO vDo = new WebZnVsanDO();
                    vDo.actZnst = null;
                    vDo.DBID = rs.getLong(17);
                    vDo.name = rs.getString(18);
                    vDo.vsanIndex = rs.getInt(20);
                    epzn.vsanDBID = vDo.DBID;
                    epzn.vsanIndex = vDo.vsanIndex;
                    WebZnFabricDO fabDO = new WebZnFabricDO();
                    fabDO.DBID = rs.getLong(11);
                    fabDO.name = rs.getString(12);
                    fabDO.serverIP = null;
                    fabDO.crd = null;
                    vDo.principalSwDBID = rs.getLong(21);
                    vDo.fabDBID = fabDO.DBID;
                    if (vDo.vsanIndex == 6) {
                        boolean nnn = true;
                    }
                    vDo.isSegmented = rs.getBoolean(22);
                    epzn.newVsanDBID = epzn.vsanDBID;
                    epzn.avgRx = "0";
                    epzn.avgTx = "0";
                    if (vDo.fabDBID == rs.getLong(25)) {
                        epzn.da = rs.getString(24);
                    }
                    if (vDBID2VDO.get(vDo.DBID) == null) {
                        vDBID2VDO.put(vDo.DBID, vDo);
                    }
                    if (faDBID2faDO.get(fabDO.DBID) == null) {
                        faDBID2faDO.put(fabDO.DBID, fabDO);
                    }
                    if (swDBID2SWDO.get(epzn.attSwDBID) == null) {
                        swDBID2SWDO.put(epzn.attSwDBID, attSw);
                    }
                    if (swDBID2SWDO.get(vDo.principalSwDBID) == null) {
                        pSwDBIDLst.add(vDo.principalSwDBID);
                    }
                    wbepLst.add(epzn);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                _Logger.warn((Object)"getEndPortsForEnclosure(): caught exception", (Throwable)e);
                break block12;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        PolicyBasedZoning.updateSwHashMap(swDBID2SWDO, pSwDBIDLst);
        return new Object[]{wbepLst.toArray(new WebZnEndPortDO[wbepLst.size()]), vDBID2VDO, faDBID2faDO, swDBID2SWDO};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSwHashMap(HashMap swDBID2SWDO, ArrayList<Long> pSwDBIDLst) {
        block10: {
            String buf = "";
            if (pSwDBIDLst != null && pSwDBIDLst.size() > 0) {
                for (int i = 0; i < pSwDBIDLst.size(); ++i) {
                    if (i == 0) {
                        buf = buf + "(";
                    }
                    if (i > 0) {
                        buf = buf + " or ";
                    }
                    buf = buf + "id=" + pSwDBIDLst.get(i);
                }
                buf = buf + ")";
                Connection con = null;
                ResultSet rs = null;
                PreparedStatement stat = null;
                try {
                    con = ConnectionManager.getConnection();
                    stat = con.prepareStatement(SWITCH_DATA + buf);
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        WebZnSwitchDO swdo = new WebZnSwitchDO();
                        swdo.DBID = rs.getLong(1);
                        byte[] ipAdd = rs.getBytes(2);
                        swdo.ipAddress = ipAdd != null ? new SnmpIpAddress(ipAdd).toString() : "";
                        swdo.sys_name = rs.getString(3);
                        swDBID2SWDO.put(swdo.DBID, swdo);
                    }
                    DbUtil.close(rs);
                }
                catch (SQLException e) {
                    _Logger.warn((Object)"updateSwHashMap: caught exception", (Throwable)e);
                    break block10;
                }
                finally {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                }
                DbUtil.close(stat);
                DbUtil.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getActiveZones(WebZnVsanDO vsando) {
        HashMap epId2Zonesmap;
        block9: {
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            epId2Zonesmap = new HashMap();
            HashMap znDBID2ZoneDO = new HashMap();
            HashMap<Long, WebZnZoneMemberDO> zmDBID2ZoneMemDO = new HashMap<Long, WebZnZoneMemberDO>();
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(VSAN_ACTIVE_ZONES);
                stat.setLong(1, vsando.DBID);
                rs = stat.executeQuery();
                WebZnZoneDO prevZnId = null;
                while (rs.next()) {
                    ArrayList<WebZnZoneDO> znlst;
                    if (prevZnId == null || rs.getLong(1) != prevZnId.DBID) {
                        WebZnZoneDO zn = new WebZnZoneDO();
                        zn.DBID = rs.getLong(1);
                        zn.name = rs.getString(2);
                        prevZnId = zn;
                        prevZnId.mems = new ArrayList();
                    }
                    WebZnZoneMemberDO zmem = new WebZnZoneMemberDO();
                    zmem.DBID = rs.getLong(3);
                    zmem.id = rs.getBytes(4);
                    zmem.endportid = rs.getLong(5);
                    zmem.name = rs.getString(6);
                    zmem.type = rs.getInt(7);
                    prevZnId.mems.add(zmem.DBID);
                    if (zmDBID2ZoneMemDO.get(zmem.DBID) == null) {
                        zmDBID2ZoneMemDO.put(zmem.DBID, zmem);
                    }
                    if ((znlst = (ArrayList<WebZnZoneDO>)epId2Zonesmap.get(zmem.id)) == null) {
                        znlst = new ArrayList<WebZnZoneDO>();
                    }
                    znlst.add(prevZnId);
                }
                DbUtil.close(rs);
            }
            catch (SQLException e) {
                _Logger.warn((Object)"getEndPortsForVSAN: caught exception", (Throwable)e);
                break block9;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return epId2Zonesmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateActiveZones(WebZnEndPortDO[] eps) {
        if (eps != null && eps.length > 0) {
            HashMap ePort2ZoneList = new HashMap();
            StringBuffer appBuf = new StringBuffer();
            appBuf.append("select zm.endport_id, zn.id, zn.name from zone zn, zone_member zm where zm.zone_id=zn.id AND (");
            for (int i = 0; i < eps.length; ++i) {
                if (i > 0) {
                    appBuf.append("  OR  ");
                }
                appBuf.append("zm.endport_id=" + eps[i].DBID);
            }
            appBuf.append(")");
            appBuf.append("  ORDER BY zm.endport_id ASC ");
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement stat = null;
            ArrayList encDoLst = new ArrayList();
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(appBuf.toString());
                rs = stat.executeQuery();
                while (rs.next()) {
                    long ePortDBID = rs.getLong(1);
                    long zoneDBID = rs.getLong(2);
                    String epZname = rs.getString(3);
                    WebZnZoneDO wbznDO = new WebZnZoneDO();
                    wbznDO.DBID = zoneDBID;
                    wbznDO.name = epZname;
                    ArrayList<WebZnZoneDO> znLst = (ArrayList<WebZnZoneDO>)ePort2ZoneList.get(ePortDBID);
                    if (znLst == null) {
                        znLst = new ArrayList<WebZnZoneDO>();
                    }
                    znLst.add(wbznDO);
                }
                for (int i = 0; i < eps.length; ++i) {
                    ArrayList vLst = (ArrayList)ePort2ZoneList.get(eps[i].DBID);
                    eps[i].zonesDBID = ArrayUtils.toPrimitive((Long[])vLst.toArray(new Long[vLst.size()]));
                }
            }
            catch (SQLException e) {
                try {
                    _Logger.warn((Object)"getEndPortsForVSAN: caught exception", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    public static void clearExpiredObjects() {
        Iterator itr = idToGenerator.entrySet().iterator();
        while (itr.hasNext()) {
            long curTime;
            Map.Entry obEntry = itr.next();
            RunCLIThread data = (RunCLIThread)obEntry.getValue();
            if (data == null || ((curTime = System.currentTimeMillis()) - data.getCreationTime()) / 1000L / 60L <= (long)EXPIRY_TIME_MIN) continue;
            data.cleanUpVSH();
            itr.remove();
        }
    }

    protected static void startTimer() {
        block3: {
            try {
                if (_Timer != null) {
                    _Timer.cancel();
                    _Timer = null;
                }
                _Timer = new Timer();
                ZoneDataSyncTask _SyncTask = new ZoneDataSyncTask();
                _Timer.schedule((TimerTask)_SyncTask, 60000 * EXPIRY_TIME_MIN);
            }
            catch (Exception ex) {
                if (_Logger == null) break block3;
                _Logger.info((Object)("Timer failed. " + ex));
            }
        }
    }

    public static RunCLIThread getRunCLIThread(int id) {
        return (RunCLIThread)idToGenerator.get(id);
    }

    public static boolean cleanupCliRunID(int id) {
        RunCLIThread clTh = (RunCLIThread)idToGenerator.get(id);
        if (clTh != null) {
            clTh.cleanUpVSH();
            idToGenerator.remove(id);
            return true;
        }
        return false;
    }

    public static int getNextId() {
        int nextZoneDBKey = 21;
        ArrayList<Integer> reportNums = new ArrayList<Integer>();
        for (Map.Entry obEntry : idToGenerator.entrySet()) {
            int key = (Integer)obEntry.getKey();
            reportNums.add(new Integer(key));
        }
        Collections.sort(reportNums);
        for (int i = 0; i < reportNums.size(); ++i) {
            int key = (Integer)reportNums.get(i);
            if (key != nextZoneDBKey) continue;
            ++nextZoneDBKey;
        }
        return nextZoneDBKey;
    }

    static {
        EXPIRY_TIME_MIN = exIntMin = 30;
        String exTime = System.getProperty("WEB_ZONE_WIZARD_OBJECT_EXPIRY_TIME", "360");
        try {
            exIntMin = Integer.parseInt(exTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class RunCLIThread
    implements Runnable {
        boolean finished;
        boolean isError;
        Exception errException;
        StringBuffer output = new StringBuffer();
        int id;
        WebZnVsancliDO cliData;
        long creationTime = -1L;
        VshBase vshPri = null;
        boolean activationCmd;

        public RunCLIThread(WebZnVsancliDO cli, boolean activationCmd) {
            this.cliData = cli;
            this.id = PolicyBasedZoning.getNextId();
            this.activationCmd = activationCmd;
            this.creationTime = System.currentTimeMillis();
            if (idToGenerator.size() == 0) {
                PolicyBasedZoning.startTimer();
            }
            idToGenerator.put(this.id, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StringBuffer getActivationStatus() {
            try {
                this.output.setLength(0);
                if (this.vshPri == null && !this.vshPri.ping()) {
                    this.vshPri = PolicyBasedZoning.getVshConnection(this.cliData.principalSwIpAddress, this.output);
                }
                this.vshPri.send("do show zone status  vsan " + this.cliData.vsanIndex + " | inc Status \n");
                this.vshPri.expect(this.vshPri.getPrompt(), this.output);
                _Logger.info((Object)this.output.toString());
            }
            catch (Exception ex) {
                _Logger.error((Object)ex.getMessage());
                this.errException = new SanServiceException(ex.getMessage());
                this.isError = true;
            }
            return this.output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runActivationCommitCmds() {
            VshBase vshChange = null;
            try {
                if (this.vshPri == null || !this.vshPri.ping()) {
                    this.vshPri = PolicyBasedZoning.getVshConnection(this.cliData.principalSwIpAddress, this.output);
                }
                if (this.cliData.activationCliCmdsDO != null) {
                    for (int i = 0; i < this.cliData.activationCliCmdsDO.length; ++i) {
                        if (this.cliData.activationCliCmdsDO[i].isVsanChangeCli || this.cliData.activationCliCmdsDO[i].cliCmds == null || this.cliData.activationCliCmdsDO[i].cliCmds.length <= 0) continue;
                        for (int j = 0; j < this.cliData.activationCliCmdsDO[i].cliCmds.length; ++j) {
                            this.output.append(this.handleCLICommand(this.cliData.activationCliCmdsDO[i].cliCmds[j], this.vshPri));
                        }
                    }
                }
            }
            catch (Exception ex) {
                _Logger.error((Object)this.output);
                _Logger.error((Object)ex.getMessage());
                this.errException = new SanServiceException(ex.getMessage());
                this.isError = true;
            }
            finally {
                if (vshChange != null) {
                    vshChange.disconnect();
                    vshChange = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runCLICommands() throws Exception {
            VshBase vshChange = null;
            HashMap<String, ArrayList<WebZncliDO>> vMap = new HashMap<String, ArrayList<WebZncliDO>>();
            try {
                for (int i = 0; i < this.cliData.cliCmdsDO.length; ++i) {
                    if (!this.cliData.cliCmdsDO[i].isVsanChangeCli) continue;
                    ArrayList<WebZncliDO> vCmdLst = (ArrayList<WebZncliDO>)vMap.get(this.cliData.cliCmdsDO[i].swIpAddress);
                    if (vCmdLst == null) {
                        vCmdLst = new ArrayList<WebZncliDO>();
                        vMap.put(this.cliData.cliCmdsDO[i].swIpAddress, vCmdLst);
                    }
                    vCmdLst.add(this.cliData.cliCmdsDO[i]);
                }
                for (Map.Entry obEntry : vMap.entrySet()) {
                    String swIpAddress = (String)obEntry.getKey();
                    ArrayList vCmdLst = (ArrayList)obEntry.getValue();
                    if (vCmdLst == null || vCmdLst.size() <= 0) continue;
                    vshChange = PolicyBasedZoning.getVshConnection(swIpAddress, this.output);
                    if (vshChange != null) {
                        for (int i = 0; i < vCmdLst.size(); ++i) {
                            WebZncliDO clido = (WebZncliDO)vCmdLst.get(i);
                            if (clido.cliCmds == null || clido.cliCmds.length <= 0) continue;
                            for (int j = 0; j < clido.cliCmds.length; ++j) {
                                if (clido.cliCmds[j].cmdType == 100) {
                                    this.output.append(clido.cliCmds[j].cmd);
                                    continue;
                                }
                                this.output.append(this.handleCLICommand(clido.cliCmds[j], vshChange));
                            }
                        }
                    } else {
                        throw new Exception("Unable to open telnet/ssh connection to Switch " + swIpAddress);
                    }
                    vshChange.disconnect();
                    vshChange = null;
                }
            }
            catch (Exception ex) {
                _Logger.error((Object)this.output);
                _Logger.error((Object)ex.getMessage());
                this.errException = new SanServiceException(ex.getMessage());
                this.isError = true;
            }
            finally {
                if (vshChange != null) {
                    vshChange.disconnect();
                    vshChange = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.finished = false;
            this.output.setLength(0);
            VshBase vshChange = null;
            StringBuffer output = new StringBuffer();
            try {
                if (this.activationCmd) {
                    this.runActivationCommitCmds();
                } else {
                    this.runCLICommands();
                }
            }
            catch (Exception ex) {
                _Logger.error((Object)output);
                _Logger.error((Object)ex.getMessage());
                this.errException = new SanServiceException(ex.getMessage());
                this.isError = true;
            }
            finally {
                if (vshChange != null) {
                    vshChange.disconnect();
                    vshChange = null;
                }
                this.finished = true;
            }
        }

        private StringBuffer handleCLICommand(WebZncliDO.cliCmdDO cmdDo, VshBase vsh) throws Exception {
            StringBuffer lcloutput = new StringBuffer();
            ArrayList<String> pmtLst = new ArrayList<String>();
            String prompt = vsh.getPrompt();
            pmtLst.add(prompt);
            boolean confirmneeded = false;
            String promptLessHash = prompt.substring(0, prompt.length() > 1 ? prompt.length() - 1 : prompt.length());
            pmtLst.add(promptLessHash + "(config)#");
            switch (cmdDo.cmdType) {
                case 3: {
                    pmtLst.add(promptLessHash + "(config-vsan-db)#");
                    break;
                }
                case 4: {
                    pmtLst.add(promptLessHash + "(config-vsan-db)#");
                    pmtLst.add("(y/n");
                    confirmneeded = true;
                    break;
                }
                case 6: {
                    pmtLst.add(promptLessHash + "(config-zoneset)#");
                    pmtLst.add(promptLessHash + "(config-zoneset-zone)#");
                    break;
                }
                case 8: {
                    pmtLst.add(promptLessHash + "(config-zoneset-zone)#");
                    break;
                }
                case 10: {
                    break;
                }
                case 5: {
                    pmtLst.add(promptLessHash + "(config)#");
                    pmtLst.add(promptLessHash + "(config-zoneset)#");
                    break;
                }
            }
            _Logger.info((Object)("Sending Command to switch" + vsh.getHost() + ":" + cmdDo.cmd + "\n"));
            vsh.send(cmdDo.cmd + "\n");
            String[] possiblePrmts = pmtLst.toArray(new String[0]);
            vsh.expect(possiblePrmts, lcloutput);
            if (confirmneeded && lcloutput.indexOf("(y/n") != -1) {
                _Logger.info((Object)"Sending Command:y \n");
                vsh.send("y\n");
                vsh.expect(possiblePrmts, lcloutput);
            }
            _Logger.info((Object)lcloutput.toString());
            this.output.append(lcloutput);
            if (lcloutput.indexOf("invalid") != -1 || lcloutput.indexOf("error") != -1 || lcloutput.indexOf("fail") != -1) {
                throw new Exception(lcloutput + " Please see logs.");
            }
            return lcloutput;
        }

        public void cleanUpVSH() {
            if (this.vshPri != null) {
                this.vshPri.disconnect();
                this.vshPri = null;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public boolean isError() {
            return this.isError;
        }

        public void setError(boolean isError) {
            this.isError = isError;
        }

        public Exception getErrException() {
            return this.errException;
        }

        public void setErrException(Exception errException) {
            this.errException = errException;
        }

        public StringBuffer getOutput() {
            return this.output;
        }

        public void setOutput(StringBuffer output) {
            this.output = output;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public WebZnVsancliDO getCliData() {
            return this.cliData;
        }

        public void setCliData(WebZnVsancliDO cliData) {
            this.cliData = cliData;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public void setCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }
    }

    static class ZoneDataSyncTask
    extends TimerTask {
        @Override
        public void run() {
            PolicyBasedZoning.clearExpiredObjects();
            if (idToGenerator.size() == 0) {
                _Timer.cancel();
                _Timer = null;
            } else {
                PolicyBasedZoning.startTimer();
            }
        }
    }
}

