/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.accounting;

import com.cisco.dcbu.sme.accounting.AccountingOperationEnum;
import com.cisco.dcbu.sme.accounting.AccountingStatusEnum;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@NamedQueries(value={@NamedQuery(name="deleteAllLogEntries", query="DELETE FROM AccountingLogEntry"), @NamedQuery(name="deleteAllLogEntriesBefore", query="DELETE FROM AccountingLogEntry As k WHERE k.timestamp < :archiveTime"), @NamedQuery(name="getAllLogEntries", query="SELECT k FROM AccountingLogEntry As k ORDER BY k.timestamp ASC"), @NamedQuery(name="getAllLogEntriesBefore", query="SELECT k FROM AccountingLogEntry As k WHERE k.timestamp < :archiveTime ORDER BY k.timestamp ASC"), @NamedQuery(name="getAllLogEntriesByCluster", query="SELECT k FROM AccountingLogEntry As k WHERE k.clusterName = :clusterName ORDER BY k.timestamp ASC"), @NamedQuery(name="getAllLogEntriesByClusterDateRange", query="SELECT k FROM AccountingLogEntry As k WHERE k.clusterName = :clusterName AND k.timestamp >= :from AND k.timestamp <= :to ORDER BY k.timestamp ASC"), @NamedQuery(name="getAllLogEntriesByClusterUser", query="SELECT k FROM AccountingLogEntry As k WHERE k.clusterName = :clusterName AND k.username = :user ORDER BY k.timestamp ASC"), @NamedQuery(name="getAllLogEntriesByUser", query="SELECT k FROM AccountingLogEntry As k WHERE k.username = :username ORDER BY k.timestamp ASC"), @NamedQuery(name="getAllLogEntriesByClusterStatus", query="SELECT k FROM AccountingLogEntry As k WHERE k.clusterName = :clusterName AND status = :status ORDER BY k.timestamp ASC"), @NamedQuery(name="getAllLogEntriesByClusterOperation", query="SELECT k FROM AccountingLogEntry As k WHERE k.clusterName = :clusterName AND operation = :operation ORDER BY k.timestamp ASC")})
@Entity
@Table(name="SME_ACCOUNTING_LOG")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class AccountingLogEntry {
    private long id;
    private Timestamp timestamp;
    private String hostname;
    private String username;
    private String clusterName;
    private String clusterId;
    private AccountingOperationEnum operation;
    private AccountingStatusEnum status;
    private String details;

    public AccountingLogEntry() {
    }

    public AccountingLogEntry(String username, String hostname, String clusterName, String clusterId, AccountingOperationEnum operation, AccountingStatusEnum status, String details) {
        this.hostname = hostname;
        this.timestamp = new Timestamp(System.currentTimeMillis());
        this.username = username;
        this.clusterName = clusterName;
        this.clusterId = clusterId;
        this.operation = operation;
        this.status = status;
        this.details = details;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="LOG_ID", nullable=false)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="USER_NAME")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Column(name="TIME_STAMP")
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Column(name="HOST_NAME")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Column(name="CLUSTER_NAME")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Column(name="CLUSTER_ID")
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Column(name="OPERATION")
    @Enumerated(value=EnumType.STRING)
    public AccountingOperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(AccountingOperationEnum operation) {
        this.operation = operation;
    }

    @Column(name="STATUS")
    @Enumerated(value=EnumType.STRING)
    public AccountingStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(AccountingStatusEnum status) {
        this.status = status;
    }

    @Column(name="DETAILS")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public int hashCode() {
        int hashCode = (int)this.id;
        if (this.timestamp != null) {
            hashCode += 29 * hashCode + (int)this.timestamp.getTime();
        }
        return hashCode += this.hostname.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AccountingLogEntry) {
            AccountingLogEntry that = (AccountingLogEntry)o;
            if (this.hashCode() == that.hashCode()) {
                return true;
            }
        }
        return false;
    }
}

