/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.ejb.impl;

import com.cisco.dcbu.sme.ckmc.ejb.api.OfflineKeyMgrCKMC;
import com.cisco.dcbu.sme.ckmc.security.ByteArrayPacker;
import com.cisco.dcbu.sme.ckmc.security.KeyMaterial;
import com.cisco.dcbu.sme.ckmc.security.SaltGenerator;
import com.cisco.dcbu.sme.ckmc.security.Tss;
import com.cisco.dcbu.sme.ckmc.security.TssShare;
import com.cisco.dcbu.sme.ckmc.security.TssStatusEnum;
import com.cisco.dcbu.sme.common.ClusterRecoveryShareInfo;
import com.cisco.dcbu.sme.common.KeyPairInfo;
import com.cisco.dcbu.sme.common.mapper.GuidSMEMapper;
import com.cisco.dcbu.sme.common.mapper.SMEAsymmetricCryptoAlgoMapper;
import com.cisco.dcbu.sme.common.mapper.SMEAuthAlgoMapper;
import com.cisco.dcbu.sme.common.mapper.SMEPasswordSchemeMapper;
import com.cisco.dcbu.sme.common.mapper.SMESymmetricCryptoAlgoMapper;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.exception.SMEProcessingException;
import com.cisco.dcbu.sme.exception.SMEUnsupportedValueException;
import com.cisco.dcbu.sme.xml.SMEKey;
import com.cisco.dcbu.sme.xml.SMEKeyData;
import com.cisco.dcbu.sme.xml.SMEKeyEntity;
import com.cisco.dcbu.sme.xml.SMEKeyIndex;
import com.cisco.dcbu.sme.xml.SMEKeyStatusEnum;
import com.cisco.dcbu.sme.xml.SMEKeyTypeEnum;
import com.cisco.dcbu.sme.xml.SMEMasterKeyIndex;
import com.cisco.dcbu.sme.xml.SMEMediaEncryptedData;
import com.cisco.dcbu.sme.xml.SMEMediaKey;
import com.cisco.dcbu.sme.xml.SMEMediaKeyDataTypeEnum;
import com.cisco.dcbu.sme.xml.SMEMsgAsymmetricCryptoAlgoEnum;
import com.cisco.dcbu.sme.xml.SMEMsgAsymmetricKeyData;
import com.cisco.dcbu.sme.xml.SMEMsgAuthAlgoEnum;
import com.cisco.dcbu.sme.xml.SMEMsgPasswordKeyData;
import com.cisco.dcbu.sme.xml.SMEMsgPasswordSchemeEnum;
import com.cisco.dcbu.sme.xml.SMEMsgPlaintextKeyData;
import com.cisco.dcbu.sme.xml.SMEMsgSymmetricCryptoAlgoEnum;
import com.cisco.dcbu.sme.xml.SMEMsgSymmetricKeyData;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.ejb.Stateless;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@Stateless
public class OfflineKeyMgrCKMCBean
implements Serializable,
OfflineKeyMgrCKMC {
    static Logger _Logger = Logger.getLogger((String)"KMC");
    private static final int SME_PASSWORD_KEY_WRAP_ITERATION_COUNT_MIN = 2048;
    private static final int SME_KEY_OBJECT_DATA_SALT_LENGTH_DEFAULT = 8;
    private static final int SME_DEFAULT_AUTH_KEY_LENGTH = 32;
    private static final int SME_DEFAULT_MEDIA_KEY_LENGTH = 32;
    private static final int SME_SYMMETRIC_KEY_IV_AES_CBC_LEN = 16;
    private static final int SME_KEY_OBJECT_DATA_PASSWORD_WRAP_KEY_MATERIAL_MAX_LEN = 128;
    private int passwordWrapBatchCount = 32;
    private int passwordWrapUseCount = 0;
    private int passwordWrapIterationCount = 0;
    private String passwordWrapCipherPassword = "";
    private Cipher passwordWrapCipher = null;
    private byte[] passwordWrapAuthKey = null;
    private byte[] passwordWrapSalt = null;

    @Override
    public SMEKey assembleMasterkey(ArrayList<ClusterRecoveryShareInfo> recoveryShares, int recoveryThreshold) throws SMEException {
        _Logger.debug((Object)"KeyMgrCKMC.assembleMasterKey - entry");
        Tss tss = new Tss();
        TssStatusEnum status = tss.tss_init();
        _Logger.debug((Object)("Init status " + (Object)((Object)status)));
        int numShares = recoveryShares.size();
        if (numShares < recoveryThreshold) {
            _Logger.error((Object)("KeyMgrCKMC.assembleMasterKey - not enough shares, only found " + numShares));
            throw new SMEProcessingException("No enough shares to assemble master key.");
        }
        TssShare[] share = new TssShare[numShares];
        for (int i = 0; i < numShares; ++i) {
            byte[] data = Base64.decodeBase64((byte[])recoveryShares.get(i).getShare().getBytes());
            if (data.length < 5 || data[0] != 0) {
                _Logger.error((Object)"Unexpected data in shares");
                throw new SMEProcessingException("Master key share type unsupported");
            }
            int len = data[4];
            if (len > data.length - 5) {
                len = data.length - 5;
            }
            if (len < 0) {
                len = data.length;
            }
            byte[] d = new byte[len];
            System.arraycopy(data, 6, d, 0, len);
            share[i] = new TssShare();
            share[i].set(data[5], d, d.length);
        }
        int secretLen = share[0].share.length - 1;
        int[] recon = new int[secretLen];
        status = tss.tss_reconstruct_secret(share, recoveryThreshold, secretLen + 1, recon);
        if (status != TssStatusEnum.Ok) {
            _Logger.error((Object)("Secret reconstruction failed with status " + (Object)((Object)status)));
            throw new SMEProcessingException("Master key reassembly failed.");
        }
        byte[] reconBytes = new byte[recon.length];
        for (int i = 0; i < recon.length; ++i) {
            reconBytes[i] = (byte)(0xFF & recon[i]);
        }
        byte keyDataLen = reconBytes[4];
        byte authKeyLen = reconBytes[2];
        byte[] plainKeyData = new byte[keyDataLen];
        System.arraycopy(reconBytes, 5, plainKeyData, 0, keyDataLen);
        SMEKey key = new SMEKey();
        SMEKeyIndex index = new SMEKeyIndex();
        index.setGUID(recoveryShares.get(0).getMasterKeyGUID());
        index.setCluster_Name(recoveryShares.get(0).getClusterName());
        key.setIndex(index);
        SMEMsgPlaintextKeyData plain = new SMEMsgPlaintextKeyData();
        plain.setPlaintextKey_Data(new String(Base64.encodeBase64((byte[])plainKeyData)));
        plain.setKey_Data_Length(Integer.valueOf(keyDataLen));
        plain.setAuth_Key_Len(Integer.valueOf(authKeyLen));
        plain.setHdr_Version(Integer.valueOf(0));
        SMEMediaEncryptedData encryptedData = new SMEMediaEncryptedData();
        encryptedData.setPlaintext_Key_Data(plain);
        SMEMediaKey mediaKey = new SMEMediaKey();
        mediaKey.setEncrypted_Data(encryptedData);
        mediaKey.setKey_Data_Type(SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___CLEAR);
        mediaKey.setKey_Length(Integer.valueOf(share[0].share.length - 1));
        mediaKey.setEncrypted_Data(encryptedData);
        SMEMasterKeyIndex mkeyIndex = new SMEMasterKeyIndex();
        mkeyIndex.setCluster_ID(recoveryShares.get(0).getClusterName());
        mkeyIndex.setCluster_Name(recoveryShares.get(0).getClusterName());
        mkeyIndex.setMaster_Key_Version(recoveryShares.get(0).getMasterKeyVersion());
        SMEKeyEntity keyEntity = new SMEKeyEntity();
        keyEntity.setMasterKey_Key(mkeyIndex);
        SMEKeyData data = new SMEKeyData();
        data.setKey_Data(mediaKey);
        data.setKey_Entity(keyEntity);
        data.setKey_Type(SMEKeyTypeEnum.KEY___TYPE___MASTER___KEY);
        data.setMaster_Key_GUID(recoveryShares.get(0).getMasterKeyGUID());
        data.setVersion(recoveryShares.get(0).getMasterKeyVersion());
        data.setStatus(SMEKeyStatusEnum.SME___KEY___ACTIVE);
        key.setData(data);
        _Logger.info((Object)"Returning assembled key");
        return key;
    }

    @Override
    public KeyPairInfo generateKeyPair(String algo) {
        _Logger.debug((Object)"KeyMgrCKMC.generateKeyPair - entry");
        return null;
    }

    @Override
    public SMEKey unwrapKey(SMEKey sourceKey, SMEKey wrapKey) throws SMEException {
        _Logger.debug((Object)"KeyMgrCKMC.unwrapKey - entry");
        SMEMediaKeyDataTypeEnum keyType = sourceKey.getData().getKey_Data().getKey_Data_Type();
        if (keyType == SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___PASSWORD___WRAP) {
            return this.unwrapPasswordKey(sourceKey, wrapKey.getData().getKey_Data().getEncrypted_Data().getPlaintext_Key_Data().getPlaintextKey_Data());
        }
        if (keyType == SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___SYMMETRIC___KEY___WRAP) {
            return this.unwrapSymmetricKey(sourceKey, wrapKey);
        }
        if (keyType == SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___RSA___KEY___WRAP) {
            return this.unwrapRsaKey(sourceKey, wrapKey);
        }
        if (keyType == SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___CLEAR) {
            return sourceKey;
        }
        throw new SMEProcessingException("Unsupported key type in unwrap key.");
    }

    @Override
    public SMEKey unwrapPasswordKey(SMEKey sourceKey, String password) throws SMEException {
        _Logger.debug((Object)" unwrapPasswordKey - entry");
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        _Logger.debug((Object)("unwrap password - " + password));
        if (password == null) {
            throw new SMEProcessingException("Invalid Password.");
        }
        this.keyDump("sourceKey", sourceKey);
        SMEMediaKeyDataTypeEnum keyType = sourceKey.getData().getKey_Data().getKey_Data_Type();
        if (keyType != SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___PASSWORD___WRAP) {
            _Logger.error((Object)"unwrapPasswordKey - sourceKey not encrypted w/ password.");
            throw new SMEProcessingException("Error, source key not encrypted with password.");
        }
        SMEMsgPasswordKeyData keyData = sourceKey.getData().getKey_Data().getEncrypted_Data().getPassword_Key_Data();
        if (keyData.getPwd_Scheme() != SMEMsgPasswordSchemeEnum.SME___MSG___PASSWORD___SCHEME___PKCS_5___2) {
            _Logger.error((Object)"unwrapPasswordKey - unsupported password scheme.");
            throw new SMEProcessingException("Password scheme not supported.");
        }
        if (keyData.getPwd_Digest_Algo() != SMEMsgAuthAlgoEnum.SME___MSG___AUTH___ALGO___SHA_1) {
            _Logger.error((Object)"unwrapPasswordKey - unsupported auth algo.");
            throw new SMEProcessingException("Key authentication algorithm unsupported.");
        }
        if (keyData.getSalt_Len() == 0) {
            _Logger.error((Object)"unwrapPasswordKey - salt length == 0.");
            throw new SMEProcessingException("Wrapped key contains invalid data.");
        }
        if (keyData.getCrypto_Algo() != SMEMsgSymmetricCryptoAlgoEnum.SME___MSG___SYMMETRIC___CRYPTO___ALGO___AES___CBC) {
            _Logger.error((Object)"unwrapPasswordKey - unsupported encryption algo.");
            throw new SMEProcessingException("Key encryption algorithm unsupported.");
        }
        if (keyData.getAuth_Key_Len() == 0) {
            _Logger.error((Object)"unwrapPasswordKey - auth key length == 0.");
            throw new SMEProcessingException("Wrapped key missing authentication data.");
        }
        if (keyData.getEncrypt_Key_Length() == 0) {
            _Logger.error((Object)"unwrapPasswordKey - encryption key length == 0.");
            throw new SMEProcessingException("Wrapped key contains invalid data.");
        }
        if (keyData.getIV_Length() == 0) {
            _Logger.error((Object)"unwrapPasswordKey - iv length == 0.");
            throw new SMEProcessingException("Wrapped key contains invalid data.");
        }
        if (keyData.getIteration_Count() < 2048) {
            _Logger.error((Object)("unwrapPasswordKey - iteration count of " + keyData.getIteration_Count() + " is less than the required " + 2048));
            throw new SMEProcessingException("Wrapped key contains invalid data.");
        }
        byte[] pBytes = PKCS5S2ParametersGenerator.PKCS5PasswordToBytes((char[])password.toCharArray());
        byte[] salt = Base64.decodeBase64((byte[])keyData.getSalt_Data().getBytes());
        byte[] salt2 = new byte[keyData.getSalt_Len().intValue()];
        System.arraycopy(salt, 0, salt2, 0, keyData.getSalt_Len());
        KeyMaterial keyMaterial = new KeyMaterial();
        keyMaterial.init(pBytes, salt2, keyData.getIteration_Count(), 1024);
        SecretKeySpec skeySpec = keyMaterial.getSecretKeySpec(0, 32);
        IvParameterSpec ivSpec = keyMaterial.getIvSpec(32, 16);
        byte[] authKey = keyMaterial.getAuthKey(48, 32);
        byte[] authHeader = this.packHeaderPassAuth(keyData.getHdr_Version(), keyData.getPwd_Scheme(), keyData.getPwd_Digest_Algo(), keyData.getSalt_Len(), Base64.decodeBase64((byte[])keyData.getSalt_Data().getBytes()), keyData.getAuth_Algo(), keyData.getAuth_Key_Len(), keyData.getCrypto_Algo(), keyData.getEncrypt_Key_Length(), keyData.getIV_Length(), keyData.getIteration_Count(), keyData.getKey_Data_Length());
        byte[] buf_decoded = Base64.decodeBase64((byte[])keyData.getEncrypted_Data().getBytes());
        byte[] buf_encrypted = new byte[keyData.getKey_Data_Length().intValue()];
        System.arraycopy(buf_decoded, 0, buf_encrypted, 0, keyData.getKey_Data_Length());
        Mac hMac = null;
        try {
            hMac = Mac.getInstance("HMacSHA256", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            _Logger.error((Object)"unwrapPasswordKey - BC says no such algorithm");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchProviderException e) {
            _Logger.error((Object)"unwrapPasswordKey - HMAC provider invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        SecretKeySpec hMacKey = new SecretKeySpec(authKey, "HMacSHA256");
        try {
            hMac.init(hMacKey);
        }
        catch (InvalidKeyException e) {
            _Logger.error((Object)"unwrapSymmetricKey - cipher key invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Key authentication failure.");
        }
        hMac.update(authHeader);
        byte[] hash = hMac.doFinal(buf_encrypted);
        String authDataString = keyData.getAuth_Data();
        byte[] authDataBytes = Base64.decodeBase64((byte[])authDataString.getBytes());
        byte[] auth = new byte[32];
        System.arraycopy(authDataBytes, 0, auth, 0, 32);
        if (!MessageDigest.isEqual(hash, auth)) {
            _Logger.error((Object)"unwrapPasswordKey - authentication failed - fixme");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "BC");
        }
        catch (NoSuchPaddingException e) {
            _Logger.error((Object)"unwrapPasswordKey - cipher padding invalid.");
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchAlgorithmException e) {
            _Logger.error((Object)"unwrapPasswordKey - cipher algorithm invalid.");
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchProviderException e) {
            _Logger.error((Object)("unwrapPasswordKey " + e.getMessage()));
            _Logger.error((Object)"unwrapPasswordKey - cipher provider invalid.");
            throw new SMEProcessingException("Java security provider not installed.");
        }
        try {
            cipher.init(2, (Key)skeySpec, ivSpec);
        }
        catch (InvalidKeyException e) {
            _Logger.error((Object)"unwrapPasswordKey - cipher key invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Unwrapping password protected key failed.");
        }
        catch (InvalidAlgorithmParameterException e) {
            _Logger.error((Object)"unwrapPasswordKey - cipher algorithm parameter invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Unwrapping password protected key failed.");
        }
        byte[] buf_decrypt = null;
        try {
            buf_decrypt = cipher.doFinal(buf_encrypted);
        }
        catch (IllegalBlockSizeException e) {
            _Logger.error((Object)"unwrapPasswordKey - cipher illegal block size.");
            e.printStackTrace();
            throw new SMEProcessingException("Unwrapping password protected key failed.");
        }
        catch (BadPaddingException e) {
            _Logger.error((Object)"unwrapPasswordKey - cipher bad padding.");
            e.printStackTrace();
            throw new SMEProcessingException("Unwrapping password protected key failed.");
        }
        SMEMsgPlaintextKeyData plainText = new SMEMsgPlaintextKeyData();
        plainText.setPlaintextKey_Data(new String(Base64.encodeBase64((byte[])buf_decrypt)));
        plainText.setKey_Data_Length(Integer.valueOf(buf_decrypt.length));
        plainText.setAuth_Key_Len(sourceKey.getData().getKey_Data().getEncrypted_Data().getPassword_Key_Data().getAuth_Key_Len());
        SMEMediaEncryptedData encryptedData = new SMEMediaEncryptedData();
        encryptedData.setPlaintext_Key_Data(plainText);
        SMEMediaKey destMediaKey = new SMEMediaKey();
        destMediaKey.setKey_Data_Type(SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___CLEAR);
        destMediaKey.setKey_Length(new Integer(buf_decrypt.length));
        destMediaKey.setEncrypted_Data(encryptedData);
        SMEKeyData destKeyData = new SMEKeyData();
        destKeyData.setKey_Type(SMEKeyTypeEnum.KEY___TYPE___NONE);
        destKeyData.setKey_Entity(sourceKey.getData().getKey_Entity());
        destKeyData.setKey_Data(destMediaKey);
        SMEKey destKey = new SMEKey();
        destKey.setIndex(sourceKey.getIndex());
        destKey.setData(destKeyData);
        _Logger.debug((Object)"unwrapPasswordKey - completed");
        this.keyDump("destKey", destKey);
        return destKey;
    }

    public SMEKey unwrapSymmetricKey(SMEKey sourceKey, SMEKey wrapKey) throws SMEException {
        SMEMediaKeyDataTypeEnum wrapKeyType;
        _Logger.debug((Object)"KeyMgrCKMC.unwrapSymmetricKey - entry");
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if ((wrapKeyType = wrapKey.getData().getKey_Data().getKey_Data_Type()) != SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___CLEAR) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - wrapKey not clear.");
            throw new SMEProcessingException("Unwrapping key failure.");
        }
        SMEMediaKeyDataTypeEnum keyType = sourceKey.getData().getKey_Data().getKey_Data_Type();
        if (keyType != SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___SYMMETRIC___KEY___WRAP) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - source key not wrapped with symmetric key.");
            return null;
        }
        this.keyDump("sourceKey", sourceKey);
        this.keyDump("wrapKey", wrapKey);
        String plainString = wrapKey.getData().getKey_Data().getEncrypted_Data().getPlaintext_Key_Data().getPlaintextKey_Data();
        byte[] plainBytes = Base64.decodeBase64((byte[])plainString.getBytes());
        int plainLength = wrapKey.getData().getKey_Data().getEncrypted_Data().getPlaintext_Key_Data().getKey_Data_Length();
        int authKeyLength = wrapKey.getData().getKey_Data().getEncrypted_Data().getPlaintext_Key_Data().getAuth_Key_Len();
        int keyDataLength = plainLength - authKeyLength;
        byte[] keyDataBytes = new byte[keyDataLength];
        byte[] authKeyBytes = new byte[authKeyLength];
        System.arraycopy(plainBytes, 0, keyDataBytes, 0, keyDataLength);
        System.arraycopy(plainBytes, keyDataLength, authKeyBytes, 0, authKeyLength);
        int symmDataLen = sourceKey.getData().getKey_Data().getEncrypted_Data().getSymmetric_Key_Data().getKey_Data_Length();
        _Logger.debug((Object)("KeyMgrCKMC.unwrapSymmetricKey - symmetric key data length " + symmDataLen));
        String encryptedDataString = sourceKey.getData().getKey_Data().getEncrypted_Data().getSymmetric_Key_Data().getEncrypted_Data();
        byte[] encryptedData = Base64.decodeBase64((byte[])encryptedDataString.getBytes());
        byte[] encrBytes = new byte[symmDataLen];
        System.arraycopy(encryptedData, 0, encrBytes, 0, symmDataLen);
        SMEMsgSymmetricKeyData keyData = sourceKey.getData().getKey_Data().getEncrypted_Data().getSymmetric_Key_Data();
        String ivString = keyData.getIV();
        byte[] ivByteDecode = Base64.decodeBase64((byte[])ivString.getBytes());
        int ivLength = keyData.getIV_Length();
        byte[] ivBytes = new byte[ivLength];
        for (int i = 0; i < ivLength; ++i) {
            ivBytes[i] = ivByteDecode[i];
        }
        if (keyData.getAuth_Algo() != SMEMsgAuthAlgoEnum.SME___MSG___AUTH___ALGO___SHA_256) {
            _Logger.error((Object)("KeyMgrCKMC.unwrapSymmetricKey - unsupported algorithm " + keyData.getAuth_Algo()));
            return null;
        }
        if (keyData.getCrypto_Algo() != SMEMsgSymmetricCryptoAlgoEnum.SME___MSG___SYMMETRIC___CRYPTO___ALGO___AES___CBC) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - unknown crypto algorithm.");
            return null;
        }
        Mac hMac = null;
        try {
            hMac = Mac.getInstance("HMacSHA256", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - BC says no such algorithm");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchProviderException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - HMAC provider invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        SecretKeySpec hMacKey = new SecretKeySpec(authKeyBytes, "HMacSHA256");
        try {
            hMac.init(hMacKey);
        }
        catch (InvalidKeyException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher key invalid.");
            e.printStackTrace();
            return null;
        }
        byte[] authHeader = this.packHeaderSymmAuth(keyData.getHdr_Version(), keyData.getCrypto_Algo(), keyData.getAuth_Algo(), keyData.getIV_Length(), ivBytes, GuidSMEMapper.mapStringToArray(keyData.getWrapped_By_GUID()), keyData.getKey_Data_Length());
        hMac.update(authHeader);
        byte[] hash = hMac.doFinal(encrBytes);
        String authDataString = keyData.getAuth_Data();
        byte[] authDataBytes = Base64.decodeBase64((byte[])authDataString.getBytes());
        if (!MessageDigest.isEqual(hash, authDataBytes)) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - auth result doesn't match expected - FIXME skipping ERROR for now");
        }
        IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
        SecretKeySpec key = new SecretKeySpec(keyDataBytes, "AES");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/NoPadding", "BC");
        }
        catch (NoSuchPaddingException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher padding invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchAlgorithmException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher algorithm invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchProviderException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher provider invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        byte[] plainText = new byte[symmDataLen];
        try {
            cipher.init(2, (Key)key, ivSpec);
        }
        catch (InvalidKeyException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher key invalid.");
            e.printStackTrace();
            return null;
        }
        catch (InvalidAlgorithmParameterException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher algorithm parameter invalid.");
            e.printStackTrace();
            return null;
        }
        try {
            int ptLength = 0;
            ptLength = cipher.doFinal(encrBytes, 0, symmDataLen, plainText, 0);
            if (ptLength != symmDataLen) {
                _Logger.error((Object)("KeyMgrCKMC.unwrapSymmetricKey - unexpected return length from cipher: " + ptLength));
            }
        }
        catch (IllegalBlockSizeException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher illegal block size.");
            e.printStackTrace();
            throw new SMEProcessingException("Encryption failed.");
        }
        catch (BadPaddingException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher bad padding.");
            e.printStackTrace();
            throw new SMEProcessingException("Encryption failed.");
        }
        catch (ShortBufferException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - short buffer.");
            e.printStackTrace();
            throw new SMEProcessingException("Encryption failed.");
        }
        if (plainText[0] != 0 || plainText[1] != 0 || plainText[3] != 0) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - decoded data doesn't look as expected.");
            throw new SMEProcessingException("Unsupported key.");
        }
        byte writeAuthKeyLength = plainText[2];
        byte writeKeyDataLength = plainText[4];
        byte[] encrKey = new byte[writeKeyDataLength];
        System.arraycopy(plainText, 5, encrKey, 0, writeKeyDataLength);
        SMEMsgPlaintextKeyData plain = new SMEMsgPlaintextKeyData();
        plain.setPlaintextKey_Data(new String(Base64.encodeBase64((byte[])encrKey)));
        plain.setKey_Data_Length(Integer.valueOf(writeKeyDataLength));
        plain.setAuth_Key_Len(Integer.valueOf(writeAuthKeyLength));
        plain.setHdr_Version(new Integer(0));
        SMEMediaEncryptedData mediaEncryptedData = new SMEMediaEncryptedData();
        mediaEncryptedData.setPlaintext_Key_Data(plain);
        SMEMediaKey medkeyData = new SMEMediaKey();
        medkeyData.setKey_Data_Type(SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___CLEAR);
        medkeyData.setKey_Length(Integer.valueOf(writeKeyDataLength - writeAuthKeyLength));
        medkeyData.setEncrypted_Data(mediaEncryptedData);
        SMEKeyData data = new SMEKeyData();
        data.setKey_Entity(sourceKey.getData().getKey_Entity());
        data.setKey_Type(sourceKey.getData().getKey_Type());
        data.setMaster_Key_GUID(sourceKey.getData().getMaster_Key_GUID());
        data.setStatus(sourceKey.getData().getStatus());
        data.setVersion(sourceKey.getData().getVersion());
        data.setKey_Data(medkeyData);
        data.setCloned_By_GUID(sourceKey.getData().getCloned_By_GUID());
        data.setCreation_Time(sourceKey.getData().getCreation_Time());
        data.setDeletion_Time(sourceKey.getData().getDeletion_Time());
        SMEKey unwrappedKey = new SMEKey();
        unwrappedKey.setIndex(sourceKey.getIndex());
        unwrappedKey.setData(data);
        this.keyDump("unwrappedKey", unwrappedKey);
        return unwrappedKey;
    }

    public SMEKey unwrapRsaKey(SMEKey sourceKey, SMEKey wrapKey) throws SMEException {
        _Logger.debug((Object)"KeyMgrCKMC.unwrapRsaKey - entry");
        SMEMsgAsymmetricKeyData keyData = sourceKey.getData().getKey_Data().getEncrypted_Data().getAsymmetric_Key_Data();
        byte[] encryptedData = Base64.decodeBase64((byte[])keyData.getEncrypted_Data().getBytes());
        int asymmDataLen = keyData.getKey_Data_Length();
        _Logger.debug((Object)("KeyMgrCKMC.unwrapRsaKey - asymmetric key data length " + asymmDataLen));
        byte[] encrBytes = new byte[asymmDataLen];
        System.arraycopy(encryptedData, 0, encrBytes, 0, asymmDataLen);
        MessageDigest hasher = null;
        try {
            hasher = MessageDigest.getInstance("SHA1", "BC");
        }
        catch (NoSuchAlgorithmException e2) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - No such algorithm.");
            e2.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchProviderException e2) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - No such provider.");
            e2.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        byte[] authHeader = this.packHeaderAsymmAuth(keyData.getHdr_Version(), keyData.getCrypto_Algo(), keyData.getDigest_Algo(), keyData.getKey_Data_Length());
        hasher.update(authHeader);
        hasher.update(encrBytes);
        byte[] hash = hasher.digest();
        String authDataString = keyData.getDigest_Data();
        byte[] authDataBytes = Base64.decodeBase64((byte[])authDataString.getBytes());
        if (!MessageDigest.isEqual(hash, authDataBytes)) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - auth result doesn't match expected.");
            throw new SMEProcessingException("Authentication failed, your key is invalid.");
        }
        Cipher cipher = null;
        KeyFactory keyFactory = null;
        try {
            cipher = Cipher.getInstance("RSA/PKCS1", "BC");
            keyFactory = KeyFactory.getInstance("RSA", "BC");
        }
        catch (NoSuchProviderException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - No such provider.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchAlgorithmException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - No Such Algorithm.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchPaddingException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - No Such padding.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        RSAPrivateKeySpec privKeySpec = new RSAPrivateKeySpec(new BigInteger("d46f473a2d746537de2056ae3092c451", 16), new BigInteger("57791d5430d593164082036ad8b29fb1", 16));
        RSAPrivateKey privKey = null;
        try {
            privKey = (RSAPrivateKey)keyFactory.generatePrivate(privKeySpec);
        }
        catch (InvalidKeySpecException e1) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - Invalid Key Spec.");
            e1.printStackTrace();
            throw new SMEProcessingException("Invalid RSA key.");
        }
        try {
            cipher.init(2, privKey);
        }
        catch (InvalidKeyException e1) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - Invalid Key.");
            e1.printStackTrace();
            throw new SMEProcessingException("Invalid RSA key.");
        }
        byte[] plainText = null;
        try {
            plainText = cipher.doFinal(encrBytes);
        }
        catch (BadPaddingException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - BadPadding.");
            e.printStackTrace();
            throw new SMEProcessingException(".");
        }
        catch (IllegalBlockSizeException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapRsaKey - IllegalBlockSize.");
            e.printStackTrace();
            throw new SMEProcessingException(".");
        }
        int writeKeyDataLength = 64;
        int writeAuthKeyLength = 32;
        byte[] encrKey = new byte[writeKeyDataLength];
        System.arraycopy(plainText, 5, encrKey, 0, writeKeyDataLength);
        SMEMsgPlaintextKeyData plain = new SMEMsgPlaintextKeyData();
        plain.setPlaintextKey_Data(new String(Base64.encodeBase64((byte[])encrKey)));
        plain.setKey_Data_Length(Integer.valueOf(writeKeyDataLength));
        plain.setAuth_Key_Len(Integer.valueOf(writeAuthKeyLength));
        plain.setHdr_Version(new Integer(0));
        SMEMediaEncryptedData mediaEncryptedData = new SMEMediaEncryptedData();
        mediaEncryptedData.setPlaintext_Key_Data(plain);
        SMEMediaKey medkeyData = new SMEMediaKey();
        medkeyData.setKey_Data_Type(SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___CLEAR);
        medkeyData.setKey_Length(Integer.valueOf(writeKeyDataLength - writeAuthKeyLength));
        medkeyData.setEncrypted_Data(mediaEncryptedData);
        SMEKeyData data = new SMEKeyData();
        data.setKey_Entity(sourceKey.getData().getKey_Entity());
        data.setKey_Type(sourceKey.getData().getKey_Type());
        data.setMaster_Key_GUID(sourceKey.getData().getMaster_Key_GUID());
        data.setStatus(sourceKey.getData().getStatus());
        data.setVersion(sourceKey.getData().getVersion());
        data.setKey_Data(medkeyData);
        SMEKey unwrappedKey = new SMEKey();
        unwrappedKey.setIndex(sourceKey.getIndex());
        unwrappedKey.setData(data);
        this.keyDump("unwrappedKey", unwrappedKey);
        return unwrappedKey;
    }

    @Override
    public SMEKey wrapKey(SMEKey sourceKey, SMEKey wrapKey) throws SMEException {
        _Logger.debug((Object)"KeyMgrCKMC.wrapKey - entry");
        SMEMediaKeyDataTypeEnum keyType = sourceKey.getData().getKey_Data().getKey_Data_Type();
        if (keyType == SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___PASSWORD___WRAP) {
            return this.wrapPasswordKey(sourceKey, wrapKey.getData().getKey_Data().getEncrypted_Data().getPlaintext_Key_Data().getPlaintextKey_Data());
        }
        if (keyType == SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___SYMMETRIC___KEY___WRAP) {
            return this.wrapSymmetricKey(sourceKey, wrapKey);
        }
        if (keyType == SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___RSA___KEY___WRAP) {
            return this.wrapRsaKey(sourceKey, wrapKey);
        }
        if (keyType == SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___CLEAR) {
            return sourceKey;
        }
        _Logger.debug((Object)("KeyMgrCKMC.wrapKey - unsupported key type: " + keyType));
        throw new SMEProcessingException("Unsupported key type: " + keyType);
    }

    @Override
    public SMEKey wrapPasswordKey(SMEKey sourceKey, String password) throws SMEException {
        SMEMediaKeyDataTypeEnum keyType;
        _Logger.debug((Object)"KeyMgrCKMC.wrapPasswordKey - entry");
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if ((keyType = sourceKey.getData().getKey_Data().getKey_Data_Type()) != SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___CLEAR) {
            _Logger.error((Object)"KeyMgrCKMC.wrapPasswordKey - sourceKey not clear.");
            throw new SMEProcessingException("Unexpected key type in password wrap.");
        }
        SMEMsgPasswordKeyData keyData = new SMEMsgPasswordKeyData();
        keyData.setIteration_Count(new Integer(2048));
        keyData.setPwd_Scheme(SMEMsgPasswordSchemeEnum.SME___MSG___PASSWORD___SCHEME___PKCS_5___2);
        keyData.setPwd_Digest_Algo(SMEMsgAuthAlgoEnum.SME___MSG___AUTH___ALGO___SHA_1);
        keyData.setCrypto_Algo(SMEMsgSymmetricCryptoAlgoEnum.SME___MSG___SYMMETRIC___CRYPTO___ALGO___AES___CBC);
        keyData.setAuth_Algo(SMEMsgAuthAlgoEnum.SME___MSG___AUTH___ALGO___SHA_256);
        keyData.setAuth_Key_Len(new Integer(32));
        keyData.setIV_Length(new Integer(16));
        keyData.setHdr_Version(Integer.valueOf(0));
        keyData.setEncrypt_Key_Length(Integer.valueOf(32));
        if (this.passwordWrapUseCount >= this.passwordWrapBatchCount || this.passwordWrapCipher == null || this.passwordWrapIterationCount != keyData.getIteration_Count() || this.passwordWrapCipherPassword == null || !this.passwordWrapCipherPassword.equals(password)) {
            this.passwordWrapCipherPassword = password;
            this.passwordWrapIterationCount = keyData.getIteration_Count();
            this.passwordWrapUseCount = 1;
            SaltGenerator saltGen = new SaltGenerator();
            this.passwordWrapSalt = saltGen.generateSalt(8);
            byte[] pBytes = PKCS5S2ParametersGenerator.PKCS5PasswordToBytes((char[])password.toCharArray());
            KeyMaterial keyMaterial = new KeyMaterial();
            keyMaterial.init(pBytes, this.passwordWrapSalt, this.passwordWrapIterationCount, 1024);
            SecretKeySpec skeySpec = keyMaterial.getSecretKeySpec(0, 32);
            IvParameterSpec ivSpec = keyMaterial.getIvSpec(32, 16);
            this.passwordWrapAuthKey = keyMaterial.getAuthKey(48, 32);
            try {
                this.passwordWrapCipher = Cipher.getInstance("AES/CBC/NoPadding", "BC");
            }
            catch (NoSuchPaddingException e) {
                _Logger.error((Object)"KeyMgrCKMC.wrapPasswordKey - cipher padding invalid.");
                throw new SMEProcessingException("Java security provider not installed.");
            }
            catch (NoSuchAlgorithmException e) {
                _Logger.error((Object)"KeyMgrCKMC.wrapPasswordKey - cipher algorithm invalid.");
                throw new SMEProcessingException("Java security provider not installed.");
            }
            catch (NoSuchProviderException e) {
                _Logger.error((Object)"KeyMgrCKMC.wrapPasswordKey - cipher provider invalid.");
                e.printStackTrace();
                throw new SMEProcessingException("Java security provider not installed.");
            }
            try {
                this.passwordWrapCipher.init(1, (Key)skeySpec, ivSpec);
            }
            catch (InvalidKeyException e) {
                _Logger.error((Object)"KeyMgrCKMC.wrapPasswordKey - cipher key invalid.");
                e.printStackTrace();
                throw new SMEProcessingException("Password wrap failed.");
            }
            catch (InvalidAlgorithmParameterException e) {
                _Logger.error((Object)"KeyMgrCKMC.wrapPasswordKey - cipher algorithm parameter invalid.");
                e.printStackTrace();
                throw new SMEProcessingException("Password wrap failed.");
            }
        }
        ++this.passwordWrapUseCount;
        keyData.setSalt_Data(new String(Base64.encodeBase64((byte[])this.passwordWrapSalt)));
        keyData.setSalt_Len(new Integer(8));
        byte[] secret = Base64.decodeBase64((byte[])sourceKey.getData().getKey_Data().getEncrypted_Data().getPlaintext_Key_Data().getPlaintextKey_Data().getBytes());
        byte[] secretTotal = null;
        if (sourceKey.getData().getKey_Type() == SMEKeyTypeEnum.KEY___TYPE___MASTER___KEY___SHARE) {
            int dataLength = secret.length + 11;
            int wrapLength = dataLength + 15 & 0xF0;
            secretTotal = new byte[wrapLength];
            int offset = 0;
            try {
                offset = ByteArrayPacker.packBytes(secretTotal, offset, 0, 1);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, 0, 2);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, keyData.getEncrypt_Key_Length() + keyData.getAuth_Key_Len(), 2);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, 1, 1);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, 0, 1);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, keyData.getAuth_Key_Len(), 2);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, keyData.getEncrypt_Key_Length() + keyData.getAuth_Key_Len(), 2);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, secret, 0, secret.length);
            }
            catch (SMEUnsupportedValueException e) {
                _Logger.error((Object)("KeyMgrCKMC.wrapPasswordKey - Unsupported Value Exception at offset " + offset + " : " + e.getMessage()));
            }
        } else if (sourceKey.getData().getKey_Type() == SMEKeyTypeEnum.KEY___TYPE___TAPE___VOLUMEGROUP___WRAP___KEY || sourceKey.getData().getKey_Type() == SMEKeyTypeEnum.KEY___TYPE___TAPE___VOLUME___KEY || sourceKey.getData().getKey_Type() == SMEKeyTypeEnum.KEY___TYPE___DISK___KEY || sourceKey.getData().getKey_Type() == SMEKeyTypeEnum.KEY___TYPE___MASTER___KEY) {
            int dataLength = secret.length + 5;
            int wrapLength = dataLength + 15 & 0xF0;
            secretTotal = new byte[wrapLength];
            int offset = 0;
            try {
                offset = ByteArrayPacker.packBytes(secretTotal, offset, 0, 1);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, keyData.getAuth_Key_Len(), 2);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, keyData.getEncrypt_Key_Length() + keyData.getAuth_Key_Len(), 2);
                offset = ByteArrayPacker.packBytes(secretTotal, offset, secret, 0, secret.length);
            }
            catch (SMEUnsupportedValueException e) {
                _Logger.error((Object)("KeyMgrCKMC.wrapPasswordKey - Unsupported Value Exception at offset " + offset + " : " + e.getMessage()));
            }
        } else {
            secretTotal = secret;
        }
        byte[] buf_encrypt = null;
        try {
            buf_encrypt = this.passwordWrapCipher.doFinal(secretTotal);
        }
        catch (IllegalBlockSizeException e) {
            _Logger.error((Object)"KeyMgrCKMC.wrapPasswordKey - cipher illegal block size.");
            throw new SMEProcessingException("Password wrap failed.");
        }
        catch (BadPaddingException e) {
            _Logger.error((Object)"KeyMgrCKMC.wrapPasswordKey - cipher bad padding.");
            throw new SMEProcessingException("Password wrap failed.");
        }
        keyData.setEncrypted_Data(new String(Base64.encodeBase64((byte[])buf_encrypt)));
        keyData.setKey_Data_Length(Integer.valueOf(secretTotal.length));
        byte[] authHeader = this.packHeaderPassAuth(keyData.getHdr_Version(), keyData.getPwd_Scheme(), keyData.getPwd_Digest_Algo(), keyData.getSalt_Len(), Base64.decodeBase64((byte[])keyData.getSalt_Data().getBytes()), keyData.getAuth_Algo(), keyData.getAuth_Key_Len(), keyData.getCrypto_Algo(), keyData.getEncrypt_Key_Length(), keyData.getIV_Length(), keyData.getIteration_Count(), keyData.getKey_Data_Length());
        Mac hMac = null;
        try {
            hMac = Mac.getInstance("HMacSHA256", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapPasswordKey - BC says no such algorithm");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        catch (NoSuchProviderException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapPasswordKey - HMAC provider invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Java security provider not installed.");
        }
        SecretKeySpec hMacKey = new SecretKeySpec(this.passwordWrapAuthKey, "HMacSHA256");
        try {
            hMac.init(hMacKey);
        }
        catch (InvalidKeyException e) {
            _Logger.error((Object)"KeyMgrCKMC.unwrapSymmetricKey - cipher key invalid.");
            e.printStackTrace();
            throw new SMEProcessingException("Authentication cipher key invalid.");
        }
        hMac.update(authHeader);
        byte[] hash = hMac.doFinal(buf_encrypt);
        String authDataString = new String(Base64.encodeBase64((byte[])hash));
        keyData.setAuth_Data(authDataString);
        SMEMediaEncryptedData encryptedData = new SMEMediaEncryptedData();
        encryptedData.setPassword_Key_Data(keyData);
        SMEMediaKey destMediaKey = new SMEMediaKey();
        destMediaKey.setKey_Data_Type(SMEMediaKeyDataTypeEnum.KEY___DATA___TYPE___PASSWORD___WRAP);
        destMediaKey.setKey_Length(Integer.valueOf(32));
        destMediaKey.setEncrypted_Data(encryptedData);
        SMEKeyData destKeyData = new SMEKeyData();
        destKeyData.setKey_Type(sourceKey.getData().getKey_Type());
        destKeyData.setKey_Entity(sourceKey.getData().getKey_Entity());
        destKeyData.setKey_Data(destMediaKey);
        destKeyData.setStatus(sourceKey.getData().getStatus());
        if (sourceKey.getData().getCloned_By_GUID().equals("0000000000000000-0000000000000000")) {
            destKeyData.setCloned_By_GUID(sourceKey.getIndex().getGUID());
        } else {
            destKeyData.setCloned_By_GUID(sourceKey.getData().getCloned_By_GUID());
        }
        destKeyData.setMaster_Key_GUID("0000000000000000-0000000000000000");
        destKeyData.setCreation_Time(sourceKey.getData().getCreation_Time());
        destKeyData.setDeletion_Time("Thu Jan  1 00:00:00 1970");
        SMEKey destKey = new SMEKey();
        destKey.setIndex(sourceKey.getIndex());
        destKey.setData(destKeyData);
        return destKey;
    }

    public SMEKey wrapSymmetricKey(SMEKey sourceKey, SMEKey wrapKey) throws SMEException {
        throw new SMEProcessingException("Symmetric key wrap not implemented.");
    }

    public SMEKey wrapRsaKey(SMEKey sourceKey, SMEKey wrapKey) throws SMEException {
        throw new SMEProcessingException("RSA key wrap not implemented.");
    }

    private void keyDump(String identifier, SMEKey key) {
        _Logger.debug((Object)("KeyMgrCKMC.keyDump - dumping key " + identifier));
        _Logger.debug((Object)"index = ");
        _Logger.debug((Object)("     clusterName: " + key.getIndex().getCluster_Name()));
        _Logger.debug((Object)("     GUID: " + key.getIndex().getGUID()));
        _Logger.debug((Object)"data = ");
        _Logger.debug((Object)("     Key_Type: " + key.getData().getKey_Type()));
        _Logger.debug((Object)("     Key_Data_Type: " + key.getData().getKey_Data().getKey_Data_Type()));
    }

    private byte[] packHeaderSymmAuth(int version, SMEMsgSymmetricCryptoAlgoEnum cryptoAlgo, SMEMsgAuthAlgoEnum authAlgo, int ivLength, byte[] iv, byte[] guid, int keyDatalength) {
        int ivlen = iv.length;
        if (ivlen > 32) {
            ivlen = 32;
        }
        byte[] iv32 = new byte[32];
        Arrays.fill(iv32, (byte)0);
        System.arraycopy(iv, 0, iv32, 0, iv.length);
        byte[] guid16 = new byte[16];
        Arrays.fill(guid16, (byte)0);
        System.arraycopy(guid, 0, guid16, 0, guid.length);
        byte[] packed = new byte[55];
        Arrays.fill(packed, (byte)0);
        int offset = 0;
        try {
            offset = ByteArrayPacker.packBytes(packed, offset, version, 1);
            offset = ByteArrayPacker.packBytes(packed, offset, SMESymmetricCryptoAlgoMapper.mapToC(cryptoAlgo), 1);
            offset = ByteArrayPacker.packBytes(packed, offset, SMEAuthAlgoMapper.mapToC(authAlgo), 1);
            offset = ByteArrayPacker.packBytes(packed, offset, ivlen, 2);
            offset = ByteArrayPacker.packBytes(packed, offset, iv32, 0, 32);
            offset = ByteArrayPacker.packBytes(packed, offset, guid16, 0, 16);
            offset = ByteArrayPacker.packBytes(packed, offset, keyDatalength, 2);
        }
        catch (SMEUnsupportedValueException e) {
            _Logger.error((Object)("  Unsupported Value Exception at offset " + offset + " : " + e.getMessage()));
        }
        return packed;
    }

    private byte[] packHeaderPassAuth(int version, SMEMsgPasswordSchemeEnum scheme, SMEMsgAuthAlgoEnum digestAlgo, int saltlen, byte[] saltData, SMEMsgAuthAlgoEnum authAlgo, int authKeyLen, SMEMsgSymmetricCryptoAlgoEnum cryptoAlgo, int encrKeyLen, int ivLength, int iterCount, int keyDatalength) {
        int saltlength = saltData.length;
        if (saltlength > 16) {
            saltlength = 16;
        }
        byte[] salt16 = new byte[16];
        Arrays.fill(salt16, (byte)0);
        System.arraycopy(saltData, 0, salt16, 0, saltlength);
        byte[] packed = new byte[33];
        Arrays.fill(packed, (byte)0);
        int offset = 0;
        try {
            offset = ByteArrayPacker.packBytes(packed, offset, version, 1);
            offset = ByteArrayPacker.packBytes(packed, offset, SMEPasswordSchemeMapper.mapToC(scheme), 1);
            offset = ByteArrayPacker.packBytes(packed, offset, SMEAuthAlgoMapper.mapToC(digestAlgo), 1);
            offset = ByteArrayPacker.packBytes(packed, offset, saltlen, 2);
            offset = ByteArrayPacker.packBytes(packed, offset, salt16, 0, 16);
            offset = ByteArrayPacker.packBytes(packed, offset, SMEAuthAlgoMapper.mapToC(authAlgo), 1);
            offset = ByteArrayPacker.packBytes(packed, offset, authKeyLen, 2);
            offset = ByteArrayPacker.packBytes(packed, offset, SMESymmetricCryptoAlgoMapper.mapToC(cryptoAlgo), 1);
            offset = ByteArrayPacker.packBytes(packed, offset, encrKeyLen, 2);
            offset = ByteArrayPacker.packBytes(packed, offset, ivLength, 2);
            offset = ByteArrayPacker.packBytes(packed, offset, iterCount, 2);
            offset = ByteArrayPacker.packBytes(packed, offset, keyDatalength, 2);
        }
        catch (SMEUnsupportedValueException e) {
            _Logger.error((Object)("  Unsupported Value Exception at offset " + offset + " : " + e.getMessage()));
        }
        return packed;
    }

    private byte[] packHeaderAsymmAuth(int version, SMEMsgAsymmetricCryptoAlgoEnum cryptoAlgo, SMEMsgAuthAlgoEnum digestAlgo, int keyDatalength) {
        byte[] packed = new byte[5];
        Arrays.fill(packed, (byte)0);
        int offset = 0;
        try {
            offset = ByteArrayPacker.packBytes(packed, offset, version, 1);
            offset = ByteArrayPacker.packBytes(packed, offset, SMEAsymmetricCryptoAlgoMapper.mapToC(cryptoAlgo), 1);
            offset = ByteArrayPacker.packBytes(packed, offset, SMEAuthAlgoMapper.mapToC(digestAlgo), 1);
            offset = ByteArrayPacker.packBytes(packed, offset, keyDatalength, 2);
        }
        catch (SMEUnsupportedValueException e) {
            _Logger.error((Object)("  Unsupported Value Exception at offset " + offset + " : " + e.getMessage()));
        }
        return packed;
    }
}

