/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.replication;

import com.cisco.dcbu.sme.replication.ReplicationCtxOperEnum;
import com.cisco.dcbu.sme.replication.SMEReplicationContext;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ReplicationContextFactory {
    private static ReplicationContextFactory s_instance = null;
    private static ConcurrentHashMap<String, SMEReplicationContext> ReplicationCtxMap = new ConcurrentHashMap();
    static Logger _Logger = Logger.getLogger((String)"KMC");

    private ReplicationContextFactory() {
    }

    public static synchronized ReplicationContextFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ReplicationContextFactory();
        }
        return s_instance;
    }

    public synchronized SMEReplicationContext replicationCtx(ReplicationCtxOperEnum oper, String clusterName, SMEReplicationContext inCtx) {
        switch (oper) {
            case GET: {
                _Logger.debug((Object)("Get replication Context for cluster " + clusterName));
                return ReplicationCtxMap.get(clusterName);
            }
            case SET: {
                _Logger.debug((Object)("Store replication Context for cluster " + clusterName));
                ReplicationCtxMap.put(clusterName, inCtx);
                break;
            }
            case DELETE: {
                _Logger.debug((Object)("Remove replication Context for cluster " + clusterName));
                if (!ReplicationCtxMap.get(clusterName).equals(inCtx)) break;
                ReplicationCtxMap.remove(clusterName);
            }
        }
        return null;
    }
}

