/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public final class SaltGenerator {
    private static final String ALGORITHM = "SHA1PRNG";
    private SecureRandom rand = null;
    private boolean isInitialized = false;
    static Logger _Logger = Logger.getLogger((String)"SME");

    public SaltGenerator() {
        try {
            this.rand = SecureRandom.getInstance(ALGORITHM);
            this.rand.setSeed(System.currentTimeMillis());
            this.isInitialized = true;
        }
        catch (NoSuchAlgorithmException e) {
            _Logger.error((Object)("Exception in SaltGenerator: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateSalt(int length) {
        byte[] salt = new byte[length];
        if (this.isInitialized) {
            SecureRandom secureRandom = this.rand;
            synchronized (secureRandom) {
                this.rand.nextBytes(salt);
            }
        } else {
            _Logger.error((Object)"ERROR: SaltGenerator was not initialized successfully.");
        }
        return salt;
    }
}

