/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.security;

import com.cisco.dcbu.sme.ckmc.security.TssShare;
import com.cisco.dcbu.sme.ckmc.security.TssStatusEnum;
import java.util.Random;

public class Tss {
    Random rand;
    int[] exp = new int[]{1, 3, 5, 15, 17, 51, 85, 255, 26, 46, 114, 150, 161, 248, 19, 53, 95, 225, 56, 72, 216, 115, 149, 164, 247, 2, 6, 10, 30, 34, 102, 170, 229, 52, 92, 228, 55, 89, 235, 38, 106, 190, 217, 112, 144, 171, 230, 49, 83, 245, 4, 12, 20, 60, 68, 204, 79, 209, 104, 184, 211, 110, 178, 205, 76, 212, 103, 169, 224, 59, 77, 215, 98, 166, 241, 8, 24, 40, 120, 136, 131, 158, 185, 208, 107, 189, 220, 127, 129, 152, 179, 206, 73, 219, 118, 154, 181, 196, 87, 249, 16, 48, 80, 240, 11, 29, 39, 105, 187, 214, 97, 163, 254, 25, 43, 125, 135, 146, 173, 236, 47, 113, 147, 174, 233, 32, 96, 160, 251, 22, 58, 78, 210, 109, 183, 194, 93, 231, 50, 86, 250, 21, 63, 65, 195, 94, 226, 61, 71, 201, 64, 192, 91, 237, 44, 116, 156, 191, 218, 117, 159, 186, 213, 100, 172, 239, 42, 126, 130, 157, 188, 223, 122, 142, 137, 128, 155, 182, 193, 88, 232, 35, 101, 175, 234, 37, 111, 177, 200, 67, 197, 84, 252, 31, 33, 99, 165, 244, 7, 9, 27, 45, 119, 153, 176, 203, 70, 202, 69, 207, 74, 222, 121, 139, 134, 145, 168, 227, 62, 66, 198, 81, 243, 14, 18, 54, 90, 238, 41, 123, 141, 140, 143, 138, 133, 148, 167, 242, 13, 23, 57, 75, 221, 124, 132, 151, 162, 253, 28, 36, 108, 180, 199, 82, 246, 1};
    int[] log = new int[]{144, 0, 25, 1, 50, 2, 26, 198, 75, 199, 27, 104, 51, 238, 223, 3, 100, 4, 224, 14, 52, 141, 129, 239, 76, 113, 8, 200, 248, 105, 28, 193, 125, 194, 29, 181, 249, 185, 39, 106, 77, 228, 166, 114, 154, 201, 9, 120, 101, 47, 138, 5, 33, 15, 225, 36, 18, 240, 130, 69, 53, 147, 218, 142, 150, 143, 219, 189, 54, 208, 206, 148, 19, 92, 210, 241, 64, 70, 131, 56, 102, 221, 253, 48, 191, 6, 139, 98, 179, 37, 226, 152, 34, 136, 145, 16, 126, 110, 72, 195, 163, 182, 30, 66, 58, 107, 40, 84, 250, 133, 61, 186, 43, 121, 10, 21, 155, 159, 94, 202, 78, 212, 172, 229, 243, 115, 167, 87, 175, 88, 168, 80, 244, 234, 214, 116, 79, 174, 233, 213, 231, 230, 173, 232, 44, 215, 117, 122, 235, 22, 11, 245, 89, 203, 95, 176, 156, 169, 81, 160, 127, 12, 246, 111, 23, 196, 73, 236, 216, 67, 31, 45, 164, 118, 123, 183, 204, 187, 62, 90, 251, 96, 177, 134, 59, 82, 161, 108, 170, 85, 41, 157, 151, 178, 135, 144, 97, 190, 220, 252, 188, 149, 207, 205, 55, 63, 91, 209, 83, 57, 132, 60, 65, 162, 109, 71, 20, 42, 158, 93, 86, 242, 211, 171, 68, 17, 146, 217, 35, 32, 46, 137, 180, 124, 184, 38, 119, 153, 227, 165, 103, 74, 237, 222, 197, 49, 254, 24, 13, 99, 140, 128, 192, 247, 112, 7};

    int gf2_8_mult(int x, int y) {
        if (x == 0 || y == 0) {
            return 0;
        }
        int tmp = this.log[x] + this.log[y];
        return this.exp[tmp % 255];
    }

    int gf2_8_invert(int x) {
        if (x == 0) {
            return 0;
        }
        return this.exp[255 - this.log[x]];
    }

    int gf2_8_divide(int x, int y) {
        if (y == 0) {
            return 0;
        }
        if (x == 0) {
            return 0;
        }
        int tmp = this.log[x] - this.log[y];
        if (tmp < 0) {
            tmp = 255 + tmp;
        }
        return this.exp[tmp];
    }

    int tss_poly_eval(int[] a, int degree, int x) {
        int y = a[0];
        int z = x;
        for (int i = 1; i <= degree; ++i) {
            y ^= this.gf2_8_mult(a[i], z);
            z = this.gf2_8_mult(x, z);
        }
        return y;
    }

    int gf2_8_lagrange(int i, int[] L, int n, int x) {
        int top = 1;
        int bottom = 1;
        for (int j = 0; j < n; ++j) {
            if (j == i) continue;
            top = this.gf2_8_mult(top, x ^ L[j]);
            bottom = this.gf2_8_mult(bottom, L[i] ^ L[j]);
        }
        return this.gf2_8_divide(top, bottom);
    }

    public TssStatusEnum tss_init() {
        this.rand = new Random();
        return TssStatusEnum.Ok;
    }

    public TssStatusEnum tss_create_shares(int[] secret, int octets_in_secret, int threshold, int num_shares, TssShare[] share) {
        int i;
        int[] a = new int[128];
        int[] point = new int[128];
        if (secret.length == 0) {
            return TssStatusEnum.Failure;
        }
        if (num_shares > 128) {
            return TssStatusEnum.Too_many_shares;
        }
        if (octets_in_secret > 1024) {
            return TssStatusEnum.Too_long;
        }
        int x = 1;
        for (i = 0; i < num_shares; ++i) {
            point[i] = x;
            share[i].share[0] = x++;
        }
        for (int j = 1; j <= octets_in_secret; ++j) {
            a[0] = secret[j - 1];
            for (int k = 1; k < threshold - 1; ++k) {
                a[k] = this.rand.nextInt(256);
            }
            for (i = 0; i < num_shares; ++i) {
                share[i].share[j] = this.tss_poly_eval(a, threshold - 1, point[i]);
            }
        }
        return TssStatusEnum.Ok;
    }

    public TssStatusEnum tss_reconstruct_secret(TssShare[] share, int num_shares, int octets_in_share, int[] secret) {
        int i;
        int[] point = new int[128];
        for (i = 0; i < num_shares; ++i) {
            point[i] = share[i].share[0];
        }
        for (int j = 1; j < octets_in_share; ++j) {
            int s = 0;
            for (i = 1; i <= num_shares; ++i) {
                s ^= this.gf2_8_mult(this.gf2_8_lagrange(i - 1, point, num_shares, 0), share[i - 1].share[j]);
            }
            secret[j - 1] = s;
        }
        return TssStatusEnum.Ok;
    }
}

