/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.comm;

import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sme.comm.SwitchCommFactory;
import com.cisco.dcbu.sme.comm.Vsh;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.exception.SMESwitchCommunicationException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SmeCLIHandler {
    private String clusterName = null;
    private String switchIP = null;
    private String user = null;
    private String pwd = null;
    private boolean isEncrypted = true;
    private String msgIn = null;
    static Logger _Logger = Logger.getLogger((String)"SME");

    public String sendReceive(String msgOut) throws SMEException {
        Vsh _vsh = null;
        msgOut = msgOut + "\n";
        _Logger.debug((Object)("Obtaining a session for user " + this.user + " cluster " + this.clusterName + " to switch " + this.switchIP));
        try {
            SwitchCommFactory commFactory = SwitchCommFactory.getInstance();
            _vsh = commFactory.getCLISshSession(this.clusterName, this.switchIP, this.user, this.pwd, this.isEncrypted);
        }
        catch (SMESwitchCommunicationException swe) {
            if (_vsh != null) {
                _vsh.disconnect();
            }
            throw swe;
        }
        catch (SMEException se) {
            if (_vsh != null) {
                _vsh.disconnect();
            }
            throw se;
        }
        if (_vsh != null) {
            try {
                _Logger.debug((Object)("Sending message to " + _vsh.getHost()));
                _vsh.send(msgOut);
                this.msgIn = _vsh.readPrompt();
                _Logger.debug((Object)("Received message from " + _vsh.getHost()));
                _vsh.disconnect();
            }
            catch (IOException ioe) {
                if (_vsh != null) {
                    _vsh.disconnect();
                }
                throw new SMESwitchCommunicationException(ioe.getMessage());
            }
        } else {
            _Logger.warn((Object)("No Session could be obtained for user " + this.user + " cluster " + this.clusterName + " to switch " + this.switchIP));
            throw new SMESwitchCommunicationException("No Session can be initialized for switch: " + this.switchIP + "for user: " + this.user);
        }
        return this.msgIn;
    }

    public SmeCLIHandler(String clusterName, String switchIP, String userName, String password) {
        this.clusterName = clusterName;
        this.user = userName;
        try {
            this.pwd = StringEncrypter.DESedeDecrypt(password);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.switchIP = switchIP;
    }
}

