/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.comm.service;

import com.cisco.dcbu.sme.ckmc.ejb.api.CKMCMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.ClusterMgrCKMC;
import com.cisco.dcbu.sme.comm.service.CKMCMsgs;
import com.cisco.dcbu.sme.comm.service.CKMCWorkerInterface;
import com.cisco.dcbu.sme.common.CKMCClusterStateEnum;
import com.cisco.dcbu.sme.common.ClusterBase;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.Config;
import com.cisco.dcbu.sme.common.DiskInfo;
import com.cisco.dcbu.sme.common.DiskStatusEnum;
import com.cisco.dcbu.sme.common.KeyTypeEnum;
import com.cisco.dcbu.sme.common.Limits;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.mapper.LunStatusMapper;
import com.cisco.dcbu.sme.common.mapper.OperationStatusSMEMapper;
import com.cisco.dcbu.sme.message.CKMCMessage;
import com.cisco.dcbu.sme.xml.SMECKMCInitResp;
import com.cisco.dcbu.sme.xml.SMECKMCKeepaliveResp;
import com.cisco.dcbu.sme.xml.SMECKMCKeyObjectOperEnum;
import com.cisco.dcbu.sme.xml.SMEDiskIndex;
import com.cisco.dcbu.sme.xml.SMEDiskKeyEntityTypeEnum;
import com.cisco.dcbu.sme.xml.SMEDiskStatusCKMCSetResp;
import com.cisco.dcbu.sme.xml.SMEDiskVPD;
import com.cisco.dcbu.sme.xml.SMEKey;
import com.cisco.dcbu.sme.xml.SMEKeyData;
import com.cisco.dcbu.sme.xml.SMEKeyEntity;
import com.cisco.dcbu.sme.xml.SMEKeyEntityObjectCKMCGetResp;
import com.cisco.dcbu.sme.xml.SMEKeyIndex;
import com.cisco.dcbu.sme.xml.SMEKeyObjectCKMCGetResp;
import com.cisco.dcbu.sme.xml.SMEKeyObjectCKMCUpdateEntry;
import com.cisco.dcbu.sme.xml.SMEKeyObjectCKMCUpdateResp;
import com.cisco.dcbu.sme.xml.SMEKeyObjectGetReq;
import com.cisco.dcbu.sme.xml.SMEKeyObjectGetResp;
import com.cisco.dcbu.sme.xml.SMEKeyStatusEnum;
import com.cisco.dcbu.sme.xml.SMEKeyTypeEnum;
import com.cisco.dcbu.sme.xml.SMELunStatusEnum;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEMsgHeader;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEResponseStatusEnum;
import com.cisco.dcbu.sme.xml.SMETableData;
import com.cisco.dcbu.sme.xml.SMETableEnum;
import com.cisco.dcbu.sme.xml.SMETableReqHeader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class CKMCWorker
extends Thread
implements CKMCWorkerInterface {
    private Socket sock;
    boolean _keepRunning;
    private CKMCMgr ckmcBean;
    private ClusterMgrCKMC clusterBean;
    private String clusterName;
    private String clusterId;
    private boolean isMaster;
    CKMCMsgs ckmcMsgs;
    protected boolean logXMLMessages = false;
    static Logger _Logger = Logger.getLogger((String)"KMC");

    @EJB
    public void setCkmcBean(CKMCMgr ckmcBean) {
        this.ckmcBean = ckmcBean;
    }

    @EJB
    public void setClusterCKMCBean(ClusterMgrCKMC clusterBean) {
        this.clusterBean = clusterBean;
    }

    CKMCWorker(Socket sock) {
        this.sock = sock;
        this._keepRunning = true;
        Config conf = Config.getInstance();
        this.logXMLMessages = conf.isLogXMLMessages();
        this.ckmcMsgs = CKMCMsgs.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shut() {
        block5: {
            this._keepRunning = false;
            try {
                if (this.keepRunning() || this.sock == null) break block5;
                this.sock.close();
                CKMCWorker cKMCWorker = this;
                synchronized (cKMCWorker) {
                    this.notifyAll();
                }
            }
            catch (Exception e) {
                _Logger.warn((Object)("Failed to close listener socket: " + this.sock + ". Error:" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    boolean keepRunning() {
        return this._keepRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.clusterName = null;
        this.clusterId = null;
        this.isMaster = false;
        CKMCClusterStateEnum state = CKMCClusterStateEnum.None;
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            InitialContext ctx = new InitialContext();
            CKMCMgr ckmcBean = (CKMCMgr)ctx.lookup("java:global/dcm/dcm/CKMCMgrBean!" + CKMCMgr.class.getName());
            this.setCkmcBean(ckmcBean);
            ClusterMgrCKMC clusterBean = (ClusterMgrCKMC)ctx.lookup("java:global/dcm/dcm/ClusterMgrCKMCBean!" + ClusterMgrCKMC.class.getName());
            this.setClusterCKMCBean(clusterBean);
        }
        catch (NamingException e) {
            _Logger.warn((Object)("Failed to locate KMC manager. " + e.getMessage()));
            e.printStackTrace();
        }
        StringBuffer _buff1 = new StringBuffer();
        try {
            _Logger.info((Object)"Started new worker");
            in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            out = new PrintWriter(new OutputStreamWriter(this.sock.getOutputStream()));
            String msgIn = null;
            String msgOut = null;
            while (this.keepRunning()) {
                CKMCMessage ckmcMessage;
                SMEMessage smeMessage;
                int b;
                _buff1.setLength(0);
                while ((b = in.read()) != -1) {
                    String totest;
                    _buff1.append((char)b);
                    if (_buff1.length() <= 15 || !(totest = _buff1.substring(_buff1.length() - 15, _buff1.length())).equalsIgnoreCase("</SME_MESSAGE>\n")) continue;
                    break;
                }
                if (b == -1) {
                    _Logger.warn((Object)("End of stream received from switch: " + this.sock.getRemoteSocketAddress() + ". Closing the connection."));
                    break;
                }
                msgIn = _buff1.toString();
                msgOut = null;
                _Logger.info((Object)("Message received from switch: " + this.sock.getRemoteSocketAddress()));
                if (this.logXMLMessages) {
                    _Logger.info((Object)("Messsage: " + msgIn));
                }
                if ((smeMessage = (ckmcMessage = new CKMCMessage()).parseCKMCMessage(new ByteArrayInputStream(msgIn.getBytes()))) != null) {
                    SMECKMCInitResp ckmcInitResp;
                    SMETableReqHeader tableHeader;
                    SMETableData tableData;
                    SMEMsgHeader msgHeader;
                    SMEOperationEnum operation = smeMessage.getMsg_Header().getOperation();
                    SMEOpcodeEnum opCode = smeMessage.getTable_Req_Header().getOpcode();
                    SMETableEnum table = smeMessage.getTable_Req_Header().getTable();
                    String cookie = smeMessage.getCKMC_Msg_Header().getSender_Cookie();
                    _Logger.info((Object)("Operation: " + operation + ", table: " + table + ", opcode: " + opCode + ", sender cookie: " + cookie));
                    if (opCode.equals((Object)SMEOpcodeEnum.GET___REPLICATION___CONTEXT) || opCode.equals((Object)SMEOpcodeEnum.CREATE___REPLICATION___CONTEXT) || opCode.equals((Object)SMEOpcodeEnum.DELETE___REPLICATION___CONTEXT) || opCode.equals((Object)SMEOpcodeEnum.EXPORT___TRANSLATED___KEY) || opCode.equals((Object)SMEOpcodeEnum.IMPORT___TRANSLATED___KEY)) {
                        if (cookie != null) {
                            if (CKMCMsgs.pendingRequests.containsKey(cookie)) {
                                CKMCMsgs.pendingRequests.remove(cookie);
                                if (!CKMCMsgs.pendingResponses.containsKey(cookie)) {
                                    CKMCMsgs.pendingResponses.put(cookie, msgIn);
                                    CKMCWorker cKMCWorker = this;
                                    synchronized (cKMCWorker) {
                                        this.notifyAll();
                                        continue;
                                    }
                                }
                                _Logger.info((Object)("Cookie " + cookie + " already exists in queue. Unique cookie not generated."));
                                continue;
                            }
                        }
                        _Logger.warn((Object)("Cookie " + cookie + " does not exists in queue."));
                        continue;
                    }
                    if (opCode.equals((Object)SMEOpcodeEnum.CKMC___GET___KEY___ENTITY___OBJECT)) {
                        SMEKeyEntity entity;
                        boolean diskError = true;
                        if (operation.equals((Object)SMEOperationEnum.SME___OP___GET) && !smeMessage.getMsg_Header().isIS_Resp() && (entity = smeMessage.getTable_Data().getKey_Entity_Object_CKMC_Get_Req().getKey_Entity()).isSetDisk_Key()) {
                            SMEKeyEntityObjectCKMCGetResp getKeyResp;
                            SMEMsgHeader msgHeader2;
                            SMEDiskIndex diskIndex = entity.getDisk_Key();
                            String clusterName = diskIndex.getCluster_Name();
                            SMEDiskKeyEntityTypeEnum type = diskIndex.getKey_Entity_Type();
                            SMEKey diskKey = null;
                            SMEContext ctx = null;
                            if (diskIndex.getCluster_ID() != null && diskIndex.getCluster_ID().length() > 0) {
                                ctx = new SMEContext();
                                ClusterBase cluster = new ClusterBase();
                                cluster.setClusterId(diskIndex.getCluster_ID());
                                cluster.setClusterName(diskIndex.getCluster_Name());
                                ctx.setCluster(cluster);
                            }
                            if (type.equals((Object)SMEDiskKeyEntityTypeEnum.DISK___KEY___ENTITY___TYPE___PRIMARY) || type.equals((Object)SMEDiskKeyEntityTypeEnum.DISK___KEY___ENTITY___TYPE___SECONDARY)) {
                                DiskInfo diskInfo;
                                SMEDiskVPD vpd;
                                if (type.equals((Object)SMEDiskKeyEntityTypeEnum.DISK___KEY___ENTITY___TYPE___PRIMARY)) {
                                    String diskGroupName = diskIndex.getDisk_Group_Name();
                                    String diskName = diskIndex.getDisk_Name();
                                    String entityIndexWC = clusterName + ":" + diskGroupName + ":" + diskName + ":%";
                                    diskKey = this.ckmcBean.getBestKeybyEntity(ctx, entityIndexWC, KeyTypeEnum.DiskKey);
                                    if (diskKey != null) {
                                        vpd = diskKey.getData().getKey_Entity().getDisk_Key().getDisk_VPD();
                                        diskIndex.setDisk_VPD(vpd);
                                    }
                                } else if (type.equals((Object)SMEDiskKeyEntityTypeEnum.DISK___KEY___ENTITY___TYPE___SECONDARY)) {
                                    String vendorId = diskIndex.getDisk_VPD().getVendor_ID();
                                    String productId = diskIndex.getDisk_VPD().getProduct_ID();
                                    String deviceId = diskIndex.getDisk_VPD().getDevice_ID();
                                    String entityIndexWC = clusterName + ":%:%:" + vendorId + ":" + productId + ":" + deviceId;
                                    diskKey = this.ckmcBean.getBestKeybyEntity(ctx, entityIndexWC, KeyTypeEnum.DiskKey);
                                    if (diskKey != null) {
                                        String diskName = diskKey.getData().getKey_Entity().getDisk_Key().getDisk_Name();
                                        String diskGroupName = diskKey.getData().getKey_Entity().getDisk_Key().getDisk_Group_Name();
                                        diskIndex.setDisk_Name(diskName);
                                        diskIndex.setDisk_Group_Name(diskGroupName);
                                    }
                                }
                                msgHeader2 = smeMessage.getMsg_Header();
                                msgHeader2.setIS_Resp(true);
                                getKeyResp = new SMEKeyEntityObjectCKMCGetResp();
                                if (diskKey == null) {
                                    diskInfo = null;
                                    if (type.equals((Object)SMEDiskKeyEntityTypeEnum.DISK___KEY___ENTITY___TYPE___PRIMARY)) {
                                        diskInfo = this.ckmcBean.getDisk(null, diskIndex.getCluster_Name(), diskIndex.getDisk_Group_Name(), diskIndex.getDisk_Name());
                                        if (diskInfo != null && diskInfo.getVpd() != null) {
                                            if (diskInfo.getVpd().getVendorId() == null || diskInfo.getVpd().getVendorId().length() == 0 || diskInfo.getVpd().getProductId() == null || diskInfo.getVpd().getProductId().length() == 0 || diskInfo.getVpd().getDeviceId() == null || diskInfo.getVpd().getDeviceId().length() == 0) {
                                                diskInfo = null;
                                            } else {
                                                vpd = new SMEDiskVPD();
                                                vpd.setVendor_ID(diskInfo.getVpd().getVendorId());
                                                vpd.setProduct_ID(diskInfo.getVpd().getProductId());
                                                vpd.setDevice_ID(diskInfo.getVpd().getDeviceId());
                                                diskIndex.setDisk_VPD(vpd);
                                            }
                                        }
                                    } else if (type.equals((Object)SMEDiskKeyEntityTypeEnum.DISK___KEY___ENTITY___TYPE___SECONDARY)) {
                                        String vendorId = diskIndex.getDisk_VPD().getVendor_ID();
                                        String productId = diskIndex.getDisk_VPD().getProduct_ID();
                                        String deviceId = diskIndex.getDisk_VPD().getDevice_ID();
                                        diskInfo = this.ckmcBean.getDisk(null, diskIndex.getCluster_Name(), vendorId, productId, deviceId);
                                        if (diskInfo != null) {
                                            diskIndex.setDisk_Name(diskInfo.getDiskName());
                                            diskIndex.setDisk_Group_Name(diskInfo.getDiskGroupName());
                                        }
                                    }
                                    if (diskInfo != null) {
                                        getKeyResp.setStatus(LunStatusMapper.convertStatusToLun(diskInfo.getStatus()));
                                        msgHeader2.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                    } else {
                                        msgHeader2.setResponse_Status(SMEResponseStatusEnum.SME___ENOMOREOBJECTS);
                                    }
                                    getKeyResp.setKey_Entity(entity);
                                    msgHeader2.setResponse_Status_Desc("no key found for diskKey");
                                    getKeyResp.setKey_Object(null);
                                } else if (!SMEKeyStatusEnum.SME___KEY___ACTIVE.equals((Object)diskKey.getData().getStatus())) {
                                    getKeyResp.setKey_Entity(diskKey.getData().getKey_Entity());
                                    SMEKey dummy = new SMEKey();
                                    SMEKeyIndex dummyIndex = new SMEKeyIndex();
                                    dummyIndex.setGUID(null);
                                    dummy.setIndex(dummyIndex);
                                    SMEKeyData dummyData = new SMEKeyData();
                                    dummy.setData(dummyData);
                                    dummyData.setStatus(SMEKeyStatusEnum.SME___KEY___ARCHIVED);
                                    getKeyResp.setKey_Object(dummy);
                                    DiskInfo diskInfo2 = this.ckmcBean.getDisk(null, diskIndex.getCluster_Name(), diskIndex.getDisk_Group_Name(), diskIndex.getDisk_Name());
                                    if (diskInfo2 != null) {
                                        getKeyResp.setStatus(LunStatusMapper.convertStatusToLun(diskInfo2.getStatus()));
                                    }
                                    msgHeader2.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                    msgHeader2.setResponse_Status_Desc("No active key found, archive key available.");
                                } else {
                                    getKeyResp.setKey_Entity(diskKey.getData().getKey_Entity());
                                    getKeyResp.setKey_Object(diskKey);
                                    diskInfo = this.ckmcBean.getDisk(null, diskIndex.getCluster_Name(), diskIndex.getDisk_Group_Name(), diskIndex.getDisk_Name());
                                    if (diskInfo != null) {
                                        getKeyResp.setStatus(LunStatusMapper.convertStatusToLun(diskInfo.getStatus()));
                                    }
                                    msgHeader2.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                    msgHeader2.setResponse_Status_Desc("Success");
                                }
                                smeMessage.setMsg_Header(msgHeader2);
                                SMETableData tableData2 = new SMETableData();
                                tableData2.setKey_Entity_Object_CKMC_Get_Resp(getKeyResp);
                                smeMessage.setTable_Data(tableData2);
                                diskError = false;
                            } else if (type.equals((Object)SMEDiskKeyEntityTypeEnum.DISK___KEY___ENTITY___TYPE___PRIMARY___SECONDARY)) {
                                DiskInfo diskInfo;
                                SMEKeyData dummyData;
                                SMEKeyIndex dummyIndex;
                                SMEKey dummy;
                                msgHeader2 = smeMessage.getMsg_Header();
                                msgHeader2.setIS_Resp(true);
                                getKeyResp = new SMEKeyEntityObjectCKMCGetResp();
                                String diskGroupName = diskIndex.getDisk_Group_Name();
                                String diskName = diskIndex.getDisk_Name();
                                String vendorId = diskIndex.getDisk_VPD().getVendor_ID();
                                String productId = diskIndex.getDisk_VPD().getProduct_ID();
                                String deviceId = diskIndex.getDisk_VPD().getDevice_ID();
                                String entityIndexWC = clusterName + ":" + diskGroupName + ":" + diskName + ":" + vendorId + ":" + productId + ":" + deviceId;
                                diskKey = this.ckmcBean.getBestKeybyEntity(ctx, entityIndexWC, KeyTypeEnum.DiskKey);
                                SMEResponseStatusEnum keyStatus = SMEResponseStatusEnum.SME___ENOMOREOBJECTS;
                                msgHeader2.setResponse_Status(keyStatus);
                                if (diskKey != null) {
                                    keyStatus = SMEResponseStatusEnum.SME___SUCCESS;
                                    getKeyResp.setKey_Entity(diskKey.getData().getKey_Entity());
                                    if (SMEKeyStatusEnum.SME___KEY___ACTIVE.equals((Object)diskKey.getData().getStatus())) {
                                        getKeyResp.setKey_Object(diskKey);
                                    } else {
                                        dummy = new SMEKey();
                                        dummyIndex = new SMEKeyIndex();
                                        dummyIndex.setGUID(null);
                                        dummy.setIndex(dummyIndex);
                                        dummyData = new SMEKeyData();
                                        dummy.setData(dummyData);
                                        dummyData.setStatus(SMEKeyStatusEnum.SME___KEY___ARCHIVED);
                                        getKeyResp.setKey_Object(dummy);
                                    }
                                    msgHeader2.setResponse_Status(keyStatus);
                                }
                                if (diskKey == null && (diskKey = this.ckmcBean.getBestKeybyEntity(ctx, entityIndexWC = clusterName + ":" + diskGroupName + ":" + diskName + ":%", KeyTypeEnum.DiskKey)) != null) {
                                    keyStatus = SMEResponseStatusEnum.SME___FAILURE___SK___MISMATCH;
                                    getKeyResp.setKey_Entity(diskKey.getData().getKey_Entity());
                                    if (SMEKeyStatusEnum.SME___KEY___ACTIVE.equals((Object)diskKey.getData().getStatus())) {
                                        getKeyResp.setKey_Object(diskKey);
                                    } else {
                                        dummy = new SMEKey();
                                        dummyIndex = new SMEKeyIndex();
                                        dummyIndex.setGUID(null);
                                        dummy.setIndex(dummyIndex);
                                        dummyData = new SMEKeyData();
                                        SMEKeyEntity dummyKeyEntity = new SMEKeyEntity();
                                        dummyData.setKey_Entity(dummyKeyEntity);
                                        SMEDiskIndex dummyDiskKeyIndex = new SMEDiskIndex();
                                        dummyDiskKeyIndex.setDisk_VPD(diskKey.getData().getKey_Entity().getDisk_Key().getDisk_VPD());
                                        dummyKeyEntity.setDisk_Key(dummyDiskKeyIndex);
                                        dummy.setData(dummyData);
                                        dummyData.setStatus(SMEKeyStatusEnum.SME___KEY___ARCHIVED);
                                        getKeyResp.setKey_Object(dummy);
                                    }
                                    msgHeader2.setResponse_Status(keyStatus);
                                }
                                if (diskKey == null && (diskKey = this.ckmcBean.getBestKeybyEntity(ctx, entityIndexWC = clusterName + ":%:%:" + vendorId + ":" + productId + ":" + deviceId, KeyTypeEnum.DiskKey)) != null) {
                                    keyStatus = SMEResponseStatusEnum.SME___FAILURE___PK___MISMATCH;
                                    getKeyResp.setKey_Entity(entity);
                                    msgHeader2.setResponse_Status(keyStatus);
                                }
                                if ((diskInfo = this.ckmcBean.getDisk(null, diskIndex.getCluster_Name(), diskIndex.getDisk_Group_Name(), diskIndex.getDisk_Name())) != null && diskKey == null) {
                                    if (diskInfo.getVpd().getVendorId().equals(vendorId) && diskInfo.getVpd().getProductId().equals(productId) && diskInfo.getVpd().getDeviceId().equals(deviceId)) {
                                        msgHeader2.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                    } else {
                                        msgHeader2.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE___SK___MISMATCH);
                                    }
                                }
                                if (diskInfo == null && (diskInfo = this.ckmcBean.getDisk(null, clusterName, vendorId, productId, deviceId)) != null && diskKey == null) {
                                    msgHeader2.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE___PK___MISMATCH);
                                    getKeyResp.setKey_Entity(entity);
                                }
                                if (diskInfo != null) {
                                    getKeyResp.setStatus(LunStatusMapper.convertStatusToLun(diskInfo.getStatus()));
                                    if (getKeyResp.getKey_Entity() == null) {
                                        SMEKeyEntity noKeyEntity = new SMEKeyEntity();
                                        getKeyResp.setKey_Entity(noKeyEntity);
                                        SMEDiskIndex noKeyDiskIndex = new SMEDiskIndex();
                                        noKeyEntity.setDisk_Key(noKeyDiskIndex);
                                        noKeyDiskIndex.setCluster_Name(clusterName);
                                        noKeyDiskIndex.setDisk_Group_Name(diskInfo.getDiskGroupName());
                                        noKeyDiskIndex.setDisk_Name(diskInfo.getDiskName());
                                        SMEDiskVPD noKeyVPD = new SMEDiskVPD();
                                        noKeyDiskIndex.setDisk_VPD(noKeyVPD);
                                        noKeyVPD.setVendor_ID(diskInfo.getVpd().getVendorId());
                                        noKeyVPD.setProduct_ID(diskInfo.getVpd().getProductId());
                                        noKeyVPD.setDevice_ID(diskInfo.getVpd().getDeviceId());
                                    }
                                }
                                if (diskInfo == null && diskKey == null) {
                                    getKeyResp.setKey_Entity(entity);
                                }
                                smeMessage.setMsg_Header(msgHeader2);
                                SMETableData tableData3 = new SMETableData();
                                tableData3.setKey_Entity_Object_CKMC_Get_Resp(getKeyResp);
                                smeMessage.setTable_Data(tableData3);
                                diskError = false;
                            }
                        }
                        if (diskError) {
                            _Logger.warn((Object)"Unrecognized CKMC___GET___KEY___ENTITY___OBJECT request");
                            msgHeader = smeMessage.getMsg_Header();
                            msgHeader.setIS_Resp(true);
                            msgHeader.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                            msgHeader.setResponse_Status_Desc("Unrecognized request");
                            smeMessage.setMsg_Header(msgHeader);
                        }
                    } else if (opCode.equals((Object)SMEOpcodeEnum.CKMC___MODIFY___DISK___STATUS)) {
                        boolean diskError = true;
                        if (operation.equals((Object)SMEOperationEnum.SME___OP___SET) && !smeMessage.getMsg_Header().isIS_Resp()) {
                            SMEDiskIndex diskIndex = smeMessage.getTable_Data().getSME_Disk_Status_CKMC_Set_Req().getDisk_Index();
                            SMELunStatusEnum status = smeMessage.getTable_Data().getSME_Disk_Status_CKMC_Set_Req().getStatus();
                            String clusterName = diskIndex.getCluster_Name();
                            String diskGroupName = diskIndex.getDisk_Group_Name();
                            String diskName = diskIndex.getDisk_Name();
                            String vendor = diskIndex.getDisk_VPD().getVendor_ID();
                            String product = diskIndex.getDisk_VPD().getProduct_ID();
                            String device = diskIndex.getDisk_VPD().getDevice_ID();
                            OperationStatus ret = this.ckmcBean.updateDisk(null, clusterName, diskGroupName, diskName, vendor, product, device, LunStatusMapper.convertStatusToDisk(status));
                            SMEMsgHeader msgHeader3 = smeMessage.getMsg_Header();
                            msgHeader3.setIS_Resp(true);
                            SMEDiskStatusCKMCSetResp setResp = new SMEDiskStatusCKMCSetResp();
                            setResp.setDisk_Index(diskIndex);
                            setResp.setStatus(status);
                            msgHeader3.setResponse_Status(OperationStatusSMEMapper.mapResponseStatusCode(ret.getStatus()));
                            msgHeader3.setResponse_Status_Desc(ret.getDescription());
                            smeMessage.setMsg_Header(msgHeader3);
                            SMETableData tableData4 = new SMETableData();
                            tableData4.setSME_Disk_Status_CKMC_Set_Resp(setResp);
                            smeMessage.setTable_Data(tableData4);
                            diskError = false;
                        }
                        if (diskError) {
                            _Logger.warn((Object)"Unrecognized CKMC___MODIFY___DISK___STATUS request");
                            msgHeader = smeMessage.getMsg_Header();
                            msgHeader.setIS_Resp(true);
                            msgHeader.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                            msgHeader.setResponse_Status_Desc("Unrecognized request");
                            smeMessage.setMsg_Header(msgHeader);
                        }
                    } else if (operation.equals((Object)SMEOperationEnum.SME___OP___GET)) {
                        if (!smeMessage.getMsg_Header().isIS_Resp() && table.equals((Object)SMETableEnum.KEY___OBJECT___TABLE) && opCode.equals((Object)SMEOpcodeEnum.CKMC___GET___KEY___OBJECT)) {
                            _Logger.debug((Object)"Received Key Lookup Message");
                            ClusterInfo clusterInfo = this.clusterBean.getClusterInfo(smeMessage.getTable_Data().getKey_Object_CKMC_Get_Req().getIndex().getCluster_Name());
                            if (clusterInfo.getCkmcState() == CKMCClusterStateEnum.Synchronized) {
                                _Logger.debug((Object)"Cluster is synchronized... do key lookup");
                                SMEKeyIndex index = smeMessage.getTable_Data().getKey_Object_CKMC_Get_Req().getIndex();
                                SMEKey keyObj = this.ckmcBean.getKey(null, index.getCluster_Name(), this.clusterId, index.getGUID());
                                if (keyObj == null) {
                                    _Logger.warn((Object)("Key " + index.getGUID() + " not found in cluster " + index.getCluster_Name()));
                                    _Logger.info((Object)"Searching Key as cloned from key ");
                                    keyObj = this.ckmcBean.getKeysbyClonedFromGUID(null, index.getCluster_Name(), this.clusterId, index.getGUID());
                                }
                                if (keyObj != null) {
                                    _Logger.info((Object)("Key " + index.getGUID() + " found in cluster " + index.getCluster_Name()));
                                    String wrapGuid = keyObj.getData().getKey_Data().getEncrypted_Data().getSymmetric_Key_Data().getWrapped_By_GUID();
                                    SMEKey wrapkeyObj = this.ckmcBean.getKey(null, index.getCluster_Name(), this.clusterId, wrapGuid);
                                    if (wrapkeyObj == null) {
                                        _Logger.warn((Object)("Wrap Key " + wrapGuid + " not found in cluster " + index.getCluster_Name()));
                                        _Logger.info((Object)"Searching Key as cloned from key ");
                                        wrapkeyObj = this.ckmcBean.getKeysbyClonedFromGUID(null, index.getCluster_Name(), this.clusterId, wrapGuid);
                                    }
                                    if (wrapkeyObj != null) {
                                        _Logger.info((Object)("Wrap Key " + wrapGuid + " found in cluster " + index.getCluster_Name()));
                                        SMEKeyObjectCKMCGetResp getKeyResp = new SMEKeyObjectCKMCGetResp();
                                        getKeyResp.setKey_Object(keyObj);
                                        getKeyResp.setWrap_Key_Object(wrapkeyObj);
                                        SMEMsgHeader msgHeader4 = smeMessage.getMsg_Header();
                                        msgHeader4.setIS_Resp(true);
                                        msgHeader4.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                        msgHeader4.setResponse_Status_Desc("Success");
                                        smeMessage.setMsg_Header(msgHeader4);
                                        tableData = new SMETableData();
                                        tableData.setKey_Object_CKMC_Get_Resp(getKeyResp);
                                        smeMessage.setTable_Data(tableData);
                                    } else {
                                        _Logger.warn((Object)("Wrap Key " + wrapGuid + " not found in cluster " + index.getCluster_Name()));
                                        SMEMsgHeader msgHeader5 = smeMessage.getMsg_Header();
                                        msgHeader5.setIS_Resp(true);
                                        msgHeader5.setResponse_Status(SMEResponseStatusEnum.SME___ENOMOREOBJECTS);
                                        msgHeader5.setResponse_Status_Desc("Wrap Key " + wrapGuid + " not found in cluster " + index.getCluster_Name());
                                        smeMessage.setMsg_Header(msgHeader5);
                                    }
                                } else {
                                    _Logger.warn((Object)("Key " + index.getGUID() + " not found in cluster " + index.getCluster_Name()));
                                    SMEMsgHeader msgHeader6 = smeMessage.getMsg_Header();
                                    msgHeader6.setIS_Resp(true);
                                    msgHeader6.setResponse_Status(SMEResponseStatusEnum.SME___ENOMOREOBJECTS);
                                    msgHeader6.setResponse_Status_Desc("Key " + index.getGUID() + " not found in cluster " + index.getCluster_Name());
                                    smeMessage.setMsg_Header(msgHeader6);
                                }
                            } else {
                                _Logger.warn((Object)"Cluster is not synchronized. Key lookup not allowed");
                                msgHeader = smeMessage.getMsg_Header();
                                msgHeader.setIS_Resp(true);
                                msgHeader.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                msgHeader.setResponse_Status_Desc("Cluster is not synchronized. Key lookup not allowed");
                                smeMessage.setMsg_Header(msgHeader);
                            }
                        }
                    } else if (operation.equals((Object)SMEOperationEnum.SME___OP___GET___NEXT)) {
                        if (smeMessage.getMsg_Header().isIS_Resp() && table.equals((Object)SMETableEnum.KEY___OBJECT___TABLE) && opCode.equals((Object)SMEOpcodeEnum.GET___KEY___OBJECT)) {
                            _Logger.debug((Object)"Received Sync Get Key Response Message");
                            if (smeMessage.getMsg_Header().getResponse_Status() == SMEResponseStatusEnum.SME___SUCCESS) {
                                SMETableReqHeader tableHeader2;
                                SMEMsgHeader msgHeader7;
                                _Logger.info((Object)"Received key objects... Update the database");
                                SMEKeyObjectGetResp getKeyResp = smeMessage.getTable_Data().getKey_Object_Get_Resp();
                                SMEKey keyObject = getKeyResp.getKey_Object();
                                String lastGUID = keyObject.getIndex().getGUID();
                                _Logger.info((Object)("Cluster: " + this.clusterName + " GUID: " + lastGUID));
                                OperationStatus ret = this.ckmcBean.updateKey(null, keyObject);
                                if (ret.getStatus() != OperationStatusEnum.Success) {
                                    _Logger.warn((Object)("Update failed for Cluster: " + this.clusterName + " GUID: " + lastGUID));
                                    msgHeader7 = smeMessage.getMsg_Header();
                                    tableHeader2 = smeMessage.getTable_Req_Header();
                                    smeMessage = new SMEMessage();
                                    msgHeader7.setOperation(SMEOperationEnum.SME___OP___SET);
                                    msgHeader7.setIS_Resp(true);
                                    msgHeader7.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                    msgHeader7.setResponse_Status_Desc("Update failed for Cluster: " + this.clusterName + " GUID: " + lastGUID);
                                    smeMessage.setMsg_Header(msgHeader7);
                                    tableHeader2.setOpcode(SMEOpcodeEnum.CKMC___INIT___MSG);
                                    tableHeader2.setTable(SMETableEnum.CKMC___TABLE);
                                    smeMessage.setTable_Req_Header(tableHeader2);
                                    SMECKMCInitResp ckmcInitResp2 = new SMECKMCInitResp();
                                    ckmcInitResp2.setCluster_Name(this.clusterName);
                                    tableData = new SMETableData();
                                    tableData.setCKMC_Init_Resp(ckmcInitResp2);
                                    smeMessage.setTable_Data(tableData);
                                } else {
                                    _Logger.info((Object)("Get more keys for Cluster: " + this.clusterName + " GUID: " + lastGUID));
                                    msgHeader7 = smeMessage.getMsg_Header();
                                    tableHeader2 = smeMessage.getTable_Req_Header();
                                    smeMessage = new SMEMessage();
                                    msgHeader7.setOperation(SMEOperationEnum.SME___OP___GET___NEXT);
                                    msgHeader7.setIS_Resp(false);
                                    smeMessage.setMsg_Header(msgHeader7);
                                    tableHeader2.setGet_Next_Count(Integer.valueOf(Limits.MAX_KEYS_IN_REQUEST));
                                    tableHeader2.setOpcode(SMEOpcodeEnum.GET___KEY___OBJECT);
                                    tableHeader2.setTable(SMETableEnum.KEY___OBJECT___TABLE);
                                    smeMessage.setTable_Req_Header(tableHeader2);
                                    SMEKeyIndex index = new SMEKeyIndex();
                                    index.setCluster_Name(this.clusterName);
                                    index.setGUID(lastGUID);
                                    SMEKeyObjectGetReq getKeyReq = new SMEKeyObjectGetReq();
                                    getKeyReq.setIndex(index);
                                    SMETableData tableData5 = new SMETableData();
                                    tableData5.setKey_Object_Get_Req(getKeyReq);
                                    smeMessage.setTable_Data(tableData5);
                                }
                            } else if (smeMessage.getMsg_Header().getResponse_Status() == SMEResponseStatusEnum.SME___ENOMOREOBJECTS) {
                                SMETableData tableData6;
                                SMECKMCInitResp ckmcInitResp3;
                                _Logger.info((Object)"Sync complete for the cluster. No more Key objects");
                                state = CKMCClusterStateEnum.Synchronized;
                                OperationStatus ret = this.clusterBean.updateClusterCKMCState(this.clusterName, this.clusterId, CKMCClusterStateEnum.Synchronized);
                                if (ret.getStatus() != OperationStatusEnum.Success) {
                                    _Logger.warn((Object)("Failed to update Cluster CKMC state to Synchronized for cluster " + this.clusterName));
                                    msgHeader = smeMessage.getMsg_Header();
                                    tableHeader = smeMessage.getTable_Req_Header();
                                    smeMessage = new SMEMessage();
                                    msgHeader.setOperation(SMEOperationEnum.SME___OP___SET);
                                    msgHeader.setIS_Resp(true);
                                    msgHeader.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                    msgHeader.setResponse_Status_Desc("Failed to update Cluster CKMC state to Synchronized for cluster " + this.clusterName);
                                    smeMessage.setMsg_Header(msgHeader);
                                    tableHeader.setOpcode(SMEOpcodeEnum.CKMC___INIT___MSG);
                                    tableHeader.setTable(SMETableEnum.CKMC___TABLE);
                                    smeMessage.setTable_Req_Header(tableHeader);
                                    ckmcInitResp3 = new SMECKMCInitResp();
                                    ckmcInitResp3.setCluster_Name(this.clusterName);
                                    tableData6 = new SMETableData();
                                    tableData6.setCKMC_Init_Resp(ckmcInitResp3);
                                    smeMessage.setTable_Data(tableData6);
                                } else {
                                    _Logger.info((Object)("Synchronization complete for Cluster: " + this.clusterName));
                                    msgHeader = smeMessage.getMsg_Header();
                                    tableHeader = smeMessage.getTable_Req_Header();
                                    smeMessage = new SMEMessage();
                                    msgHeader.setOperation(SMEOperationEnum.SME___OP___SET);
                                    msgHeader.setIS_Resp(true);
                                    msgHeader.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                    msgHeader.setResponse_Status_Desc("Success");
                                    smeMessage.setMsg_Header(msgHeader);
                                    tableHeader.setOpcode(SMEOpcodeEnum.CKMC___INIT___MSG);
                                    tableHeader.setTable(SMETableEnum.CKMC___TABLE);
                                    smeMessage.setTable_Req_Header(tableHeader);
                                    ckmcInitResp3 = new SMECKMCInitResp();
                                    ckmcInitResp3.setCluster_Name(this.clusterName);
                                    tableData6 = new SMETableData();
                                    tableData6.setCKMC_Init_Resp(ckmcInitResp3);
                                    smeMessage.setTable_Data(tableData6);
                                }
                            } else if (smeMessage.getMsg_Header().getResponse_Status() == SMEResponseStatusEnum.SME___FAILURE) {
                                _Logger.warn((Object)"Cluster Key Database Synchronization failed");
                                SMEMsgHeader msgHeader8 = smeMessage.getMsg_Header();
                                SMETableReqHeader tableHeader3 = smeMessage.getTable_Req_Header();
                                smeMessage = new SMEMessage();
                                msgHeader8.setOperation(SMEOperationEnum.SME___OP___SET);
                                msgHeader8.setIS_Resp(true);
                                msgHeader8.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                msgHeader8.setResponse_Status_Desc("Cluster Key Database Synchronization failed");
                                smeMessage.setMsg_Header(msgHeader8);
                                tableHeader3.setOpcode(SMEOpcodeEnum.CKMC___INIT___MSG);
                                tableHeader3.setTable(SMETableEnum.CKMC___TABLE);
                                smeMessage.setTable_Req_Header(tableHeader3);
                                ckmcInitResp = new SMECKMCInitResp();
                                ckmcInitResp.setCluster_Name(this.clusterName);
                                SMETableData tableData7 = new SMETableData();
                                tableData7.setCKMC_Init_Resp(ckmcInitResp);
                                smeMessage.setTable_Data(tableData7);
                            }
                        }
                    } else if (operation.equals((Object)SMEOperationEnum.SME___OP___SET)) {
                        SMETableData tableData8;
                        if (table.equals((Object)SMETableEnum.CKMC___TABLE)) {
                            SMETableData tableData9;
                            if (opCode.equals((Object)SMEOpcodeEnum.CKMC___KEEPALIVE)) {
                                _Logger.debug((Object)("Received CKMC___KEEPALIVE request from " + this.sock.getInetAddress()));
                                SMEMsgHeader msgHeader9 = smeMessage.getMsg_Header();
                                msgHeader9.setIS_Resp(true);
                                msgHeader9.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                msgHeader9.setResponse_Status_Desc("Success");
                                smeMessage.setMsg_Header(msgHeader9);
                                SMECKMCKeepaliveResp ckmcKeepAliveResp = new SMECKMCKeepaliveResp();
                                ckmcKeepAliveResp.setCluster_Name(this.clusterName);
                                tableData9 = new SMETableData();
                                tableData9.setCKMC_Keepalive_Resp(ckmcKeepAliveResp);
                                smeMessage.setTable_Data(tableData9);
                                state = CKMCClusterStateEnum.Init_Replied;
                            } else if (opCode.equals((Object)SMEOpcodeEnum.CKMC___INIT___MSG)) {
                                _Logger.info((Object)("Received CKMC___INIT___MSG request from " + this.sock.getInetAddress()));
                                if (state != CKMCClusterStateEnum.None) {
                                    _Logger.warn((Object)("Invalid CKMC___INIT___MSG Request from " + this.sock.getInetAddress()));
                                    SMEMsgHeader msgHeader10 = smeMessage.getMsg_Header();
                                    msgHeader10.setIS_Resp(true);
                                    msgHeader10.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                    msgHeader10.setResponse_Status_Desc("Invalid CKMC___INIT___MSG Request");
                                    smeMessage.setMsg_Header(msgHeader10);
                                    SMECKMCInitResp ckmcInitResp4 = new SMECKMCInitResp();
                                    ckmcInitResp4.setCluster_Name(this.clusterName);
                                    tableData9 = new SMETableData();
                                    tableData9.setCKMC_Init_Resp(ckmcInitResp4);
                                    smeMessage.setTable_Data(tableData9);
                                } else {
                                    SMETableData tableData10;
                                    OperationStatus ret;
                                    state = CKMCClusterStateEnum.Init_Received;
                                    this.clusterName = smeMessage.getTable_Data().getCKMC_Init_Req().getCluster_Name();
                                    this.clusterId = smeMessage.getTable_Data().getCKMC_Init_Req().getCluster_ID();
                                    this.isMaster = smeMessage.getTable_Data().getCKMC_Init_Req().isIs_Master();
                                    ClusterInfo clusterInfo = this.clusterBean.getClusterInfo(smeMessage.getTable_Data().getCKMC_Init_Req().getCluster_Name());
                                    if (this.isMaster && (clusterInfo == null || clusterInfo.getMasterIPAddr() == null || clusterInfo.getMasterIPAddr().compareTo(this.sock.getInetAddress().getHostAddress()) != 0) && (ret = this.clusterBean.updateClusterCKMCMasterIPAddress(this.clusterName, this.clusterId, this.sock.getInetAddress().getHostAddress())).getStatus() != OperationStatusEnum.Success) {
                                        _Logger.warn((Object)("Failed to update master IP address " + this.sock.getInetAddress().getHostAddress() + " in KMC database for cluster " + this.clusterName + ". Error: " + ret.getDescription()));
                                    }
                                    if (clusterInfo.getCkmcState() != CKMCClusterStateEnum.Synchronized) {
                                        if (this.isMaster) {
                                            _Logger.info((Object)("Cluster is not synchronized. Starting synchronization using socket: " + this.sock.getInetAddress()));
                                            msgHeader = smeMessage.getMsg_Header();
                                            tableHeader = smeMessage.getTable_Req_Header();
                                            smeMessage = new SMEMessage();
                                            msgHeader.setOperation(SMEOperationEnum.SME___OP___GET___NEXT);
                                            msgHeader.setIS_Resp(false);
                                            smeMessage.setMsg_Header(msgHeader);
                                            tableHeader.setGet_Next_Count(Integer.valueOf(Limits.MAX_KEYS_IN_REQUEST));
                                            tableHeader.setOpcode(SMEOpcodeEnum.GET___KEY___OBJECT);
                                            tableHeader.setTable(SMETableEnum.KEY___OBJECT___TABLE);
                                            smeMessage.setTable_Req_Header(tableHeader);
                                            SMEKeyIndex index = new SMEKeyIndex();
                                            index.setCluster_Name(this.clusterName);
                                            SMEKeyObjectGetReq getKeyReq = new SMEKeyObjectGetReq();
                                            getKeyReq.setIndex(index);
                                            tableData8 = new SMETableData();
                                            tableData8.setKey_Object_Get_Req(getKeyReq);
                                            smeMessage.setTable_Data(tableData8);
                                        } else {
                                            _Logger.warn((Object)("Cluster is not synchronized. CKMC___INIT___MSG Request no allowed from " + this.sock.getInetAddress()));
                                            msgHeader = smeMessage.getMsg_Header();
                                            msgHeader.setIS_Resp(true);
                                            msgHeader.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                            msgHeader.setResponse_Status_Desc("Cluster is not synchronized. CKMC___INIT___MSG Request no allowed");
                                            smeMessage.setMsg_Header(msgHeader);
                                            ckmcInitResp = new SMECKMCInitResp();
                                            ckmcInitResp.setCluster_Name(this.clusterName);
                                            tableData10 = new SMETableData();
                                            tableData10.setCKMC_Init_Resp(ckmcInitResp);
                                            smeMessage.setTable_Data(tableData10);
                                            state = CKMCClusterStateEnum.Init_Replied;
                                        }
                                    } else {
                                        msgHeader = smeMessage.getMsg_Header();
                                        msgHeader.setIS_Resp(true);
                                        msgHeader.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                        msgHeader.setResponse_Status_Desc("Success");
                                        smeMessage.setMsg_Header(msgHeader);
                                        ckmcInitResp = new SMECKMCInitResp();
                                        ckmcInitResp.setCluster_Name(this.clusterName);
                                        tableData10 = new SMETableData();
                                        tableData10.setCKMC_Init_Resp(ckmcInitResp);
                                        smeMessage.setTable_Data(tableData10);
                                        state = CKMCClusterStateEnum.Init_Replied;
                                    }
                                }
                            } else if (opCode.equals((Object)SMEOpcodeEnum.CKMC___LOG___MSG___OBJECT)) {
                                _Logger.debug((Object)("Received CKMC___LOG___MESSAGE request from " + this.sock.getInetAddress()));
                                String clusterName = smeMessage.getTable_Data().getCKMC_Log_Message_Req().getCluster_Name();
                                String clusterId = smeMessage.getTable_Data().getCKMC_Log_Message_Req().getCluster_ID();
                                String message = smeMessage.getTable_Data().getCKMC_Log_Message_Req().getMessage();
                                this.ckmcBean.logMessage(null, clusterName, clusterId, message);
                                continue;
                            }
                        } else if (table.equals((Object)SMETableEnum.KEY___OBJECT___TABLE)) {
                            SMETableData tableData11;
                            SMEKeyObjectCKMCUpdateResp keyUpdateResp;
                            if (opCode.equals((Object)SMEOpcodeEnum.CKMC___UPDATE___KEY___OBJECT)) {
                                _Logger.info((Object)("Update key request is received from " + this.sock.getInetAddress()));
                                ClusterInfo clusterInfo = this.clusterBean.getClusterInfo(smeMessage.getTable_Data().getKey_Object_CKMC_Update_Req().getCluster_Name());
                                if (clusterInfo.getCkmcState() != CKMCClusterStateEnum.Synchronized) {
                                    _Logger.warn((Object)("Cluster is not synchronized. Update key requests are not allowed from " + this.sock.getInetAddress()));
                                    msgHeader = smeMessage.getMsg_Header();
                                    msgHeader.setIS_Resp(true);
                                    msgHeader.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                    msgHeader.setResponse_Status_Desc("Cluster is not synchronized. Update key requests are not allowed.");
                                    smeMessage.setMsg_Header(msgHeader);
                                    SMEKeyObjectCKMCUpdateResp keyUpdateResp2 = new SMEKeyObjectCKMCUpdateResp();
                                    keyUpdateResp2.setCluster_Name(this.clusterName);
                                    SMETableData tableData12 = new SMETableData();
                                    tableData12.setKey_Object_CKMC_Update_Resp(keyUpdateResp2);
                                    smeMessage.setTable_Data(tableData12);
                                } else {
                                    List keyUpdatEntryList = smeMessage.getTable_Data().getKey_Object_CKMC_Update_Req().getUpdate_Key_Context();
                                    Iterator it = keyUpdatEntryList.iterator();
                                    boolean specialCase = false;
                                    String specialCaseBarcode = null;
                                    if (keyUpdatEntryList.size() == 2 && SMECKMCKeyObjectOperEnum.SME___CKMC___KEY___OBJECT___OP___CREATE.equals((Object)((SMEKeyObjectCKMCUpdateEntry)keyUpdatEntryList.get(0)).getOperation()) && SMECKMCKeyObjectOperEnum.SME___CKMC___KEY___OBJECT___OP___PURGE.equals((Object)((SMEKeyObjectCKMCUpdateEntry)keyUpdatEntryList.get(1)).getOperation())) {
                                        specialCase = true;
                                    }
                                    while (it.hasNext()) {
                                        String guid;
                                        SMEKeyObjectCKMCUpdateEntry updateKeyEntry = (SMEKeyObjectCKMCUpdateEntry)it.next();
                                        SMECKMCKeyObjectOperEnum keyOperation = updateKeyEntry.getOperation();
                                        SMEKey keyObject = updateKeyEntry.getKey_Object();
                                        String archivalTime = updateKeyEntry.getDeletion_Time();
                                        SMEMsgHeader msgHeader11 = smeMessage.getMsg_Header();
                                        msgHeader11.setIS_Resp(true);
                                        SMEKeyEntity entity = keyObject.getData().getKey_Entity();
                                        if (entity.isSetDisk_Key()) {
                                            String keyClusterId = entity.getDisk_Key().getCluster_ID();
                                            if (!clusterInfo.getClusterId().equals(keyClusterId)) {
                                                msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE___CLUSTER___ID___MISMATCH);
                                                msgHeader11.setResponse_Status_Desc("ClusterId mismatch on GUID " + keyObject.getIndex().getGUID());
                                                _Logger.warn((Object)("ClusterId mismatch on key update for GUID " + keyObject.getIndex().getGUID()));
                                                while (it.hasNext()) {
                                                    it.next();
                                                }
                                                break;
                                            }
                                        }
                                        if (keyOperation == SMECKMCKeyObjectOperEnum.SME___CKMC___KEY___OBJECT___OP___CREATE) {
                                            String entityIndexWC;
                                            SMEKey testKey;
                                            OperationStatus ret = new OperationStatus();
                                            boolean dupSkipActive = false;
                                            if (SMEKeyTypeEnum.KEY___TYPE___DISK___KEY.equals((Object)keyObject.getData().getKey_Type()) && SMEKeyStatusEnum.SME___KEY___ACTIVE.equals((Object)keyObject.getData().getStatus()) && (testKey = this.ckmcBean.getBestKeybyEntity(null, entityIndexWC = this.clusterName + ":" + keyObject.getData().getKey_Entity().getDisk_Key().getDisk_Group_Name() + ":" + keyObject.getData().getKey_Entity().getDisk_Key().getDisk_Name() + ":%", KeyTypeEnum.DiskKey)) != null && SMEKeyStatusEnum.SME___KEY___ACTIVE.equals((Object)testKey.getData().getStatus()) && !testKey.getIndex().getGUID().equals(keyObject.getIndex().getGUID())) {
                                                dupSkipActive = true;
                                                ret.set(OperationStatusEnum.Failure, "Active Key exists for " + entityIndexWC);
                                            }
                                            if (!dupSkipActive) {
                                                ret = this.ckmcBean.updateKey(null, keyObject);
                                            }
                                            if (ret.getStatus() == OperationStatusEnum.Success) {
                                                if (SMEKeyTypeEnum.KEY___TYPE___DISK___KEY.equals((Object)keyObject.getData().getKey_Type())) {
                                                    SMEDiskIndex di = keyObject.getData().getKey_Entity().getDisk_Key();
                                                    ret = this.ckmcBean.updateDisk(null, this.clusterName, di.getDisk_Group_Name(), di.getDisk_Name(), di.getDisk_VPD().getVendor_ID(), di.getDisk_VPD().getProduct_ID(), di.getDisk_VPD().getDevice_ID(), DiskStatusEnum.Crypto);
                                                }
                                                msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                                msgHeader11.setResponse_Status_Desc("Success");
                                                _Logger.info((Object)("Update key successful for cluster " + this.clusterName + " GUID " + keyObject.getIndex().getGUID()));
                                                try {
                                                    if (specialCase) {
                                                        specialCaseBarcode = keyObject.getData().getKey_Entity().getTape_Volume_Key().getBarcode();
                                                    }
                                                }
                                                catch (Exception e) {
                                                    _Logger.info((Object)("CKMC Worker exception in special case test " + this.clusterName + " GUID " + keyObject.getIndex().getGUID()), (Throwable)e);
                                                }
                                            } else {
                                                msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                                msgHeader11.setResponse_Status_Desc(ret.getDescription());
                                                _Logger.warn((Object)("Update key failed for cluster " + this.clusterName + " GUID " + keyObject.getIndex().getGUID() + " reason: " + ret.getDescription()));
                                                if (specialCase) {
                                                    _Logger.warn((Object)"Skipping subsequent updates and returning ERROR.");
                                                    while (it.hasNext()) {
                                                        it.next();
                                                    }
                                                }
                                            }
                                        } else if (keyOperation == SMECKMCKeyObjectOperEnum.SME___CKMC___KEY___OBJECT___OP___DELETE) {
                                            guid = keyObject.getIndex().getGUID();
                                            OperationStatus ret = this.ckmcBean.archiveKey(null, this.clusterName, this.clusterId, guid, archivalTime);
                                            if (ret.getStatus() == OperationStatusEnum.Success) {
                                                if (SMEKeyTypeEnum.KEY___TYPE___DISK___KEY.equals((Object)keyObject.getData().getKey_Type())) {
                                                    SMEDiskIndex di = keyObject.getData().getKey_Entity().getDisk_Key();
                                                    ret = this.ckmcBean.updateDisk(null, this.clusterName, di.getDisk_Group_Name(), di.getDisk_Name(), di.getDisk_VPD().getVendor_ID(), di.getDisk_VPD().getProduct_ID(), di.getDisk_VPD().getDevice_ID(), DiskStatusEnum.Clear);
                                                }
                                                msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                                msgHeader11.setResponse_Status_Desc("Success");
                                                _Logger.info((Object)("Archive key successful for cluster " + this.clusterName + " GUID " + guid));
                                            } else if (ret.getStatus() == OperationStatusEnum.NoMoreObjects) {
                                                msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___ENOMOREOBJECTS);
                                                msgHeader11.setResponse_Status_Desc("No More Objects");
                                                _Logger.info((Object)("Archive key not found for cluster " + this.clusterName + " GUID " + guid));
                                            } else {
                                                msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                                msgHeader11.setResponse_Status_Desc(ret.getDescription());
                                                _Logger.warn((Object)("Archive key failed for cluster " + this.clusterName + " GUID " + guid));
                                            }
                                        } else if (keyOperation == SMECKMCKeyObjectOperEnum.SME___CKMC___KEY___OBJECT___OP___PURGE) {
                                            guid = keyObject.getIndex().getGUID();
                                            boolean purgeFail = true;
                                            boolean specialCaseSkipPurge = false;
                                            if (specialCase) {
                                                String checkBarcode = null;
                                                try {
                                                    SMEKey purgeKey = this.ckmcBean.getKey(null, this.clusterName, this.clusterId, guid);
                                                    if (purgeKey != null) {
                                                        checkBarcode = purgeKey.getData().getKey_Entity().getTape_Volume_Key().getBarcode();
                                                    }
                                                }
                                                catch (Exception e) {
                                                    _Logger.info((Object)("Purge key attempt to get key failed for cluster " + this.clusterName + " GUID " + guid), (Throwable)e);
                                                }
                                                if (specialCaseBarcode == null || checkBarcode == null || !specialCaseBarcode.equals(checkBarcode)) {
                                                    specialCaseSkipPurge = true;
                                                    _Logger.info((Object)("Purge key SKIPPED for cluster " + this.clusterName + " GUID: " + guid + " due to barcode mismatch create:" + specialCaseBarcode + " purge: " + checkBarcode));
                                                }
                                            }
                                            if (specialCaseSkipPurge) {
                                                msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                                msgHeader11.setResponse_Status_Desc("Success");
                                            } else {
                                                OperationStatus ret = this.ckmcBean.purgeKey(null, this.clusterName, this.clusterId, guid);
                                                if (ret.getStatus() == OperationStatusEnum.Success) {
                                                    msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                                    msgHeader11.setResponse_Status_Desc("Success");
                                                    _Logger.info((Object)("Purge key successful for cluster " + this.clusterName + " GUID " + guid));
                                                    purgeFail = false;
                                                } else {
                                                    msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                                    msgHeader11.setResponse_Status_Desc(ret.getDescription());
                                                    _Logger.warn((Object)("Purge key failed for cluster " + this.clusterName + " GUID " + guid));
                                                }
                                                ret = this.ckmcBean.purgeKeyByClonedGuid(null, this.clusterName, this.clusterId, guid);
                                                if (ret.getStatus() == OperationStatusEnum.Success) {
                                                    msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                                    msgHeader11.setResponse_Status_Desc("Success");
                                                    _Logger.info((Object)("Purge key successful for cluster " + this.clusterName + " Cloned GUID " + guid));
                                                    purgeFail = false;
                                                } else {
                                                    msgHeader11.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                                    msgHeader11.setResponse_Status_Desc(ret.getDescription());
                                                    _Logger.warn((Object)("Purge key failed for cluster " + this.clusterName + " Cloned GUID " + guid));
                                                }
                                                if (specialCase && purgeFail) {
                                                    SMEKey keyObjectPurge = ((SMEKeyObjectCKMCUpdateEntry)keyUpdatEntryList.get(0)).getKey_Object();
                                                    _Logger.warn((Object)"Both purges failed, backing out last key update.");
                                                    this.ckmcBean.purgeKey(null, this.clusterName, this.clusterId, keyObjectPurge.getIndex().getGUID());
                                                }
                                            }
                                        }
                                        smeMessage.setMsg_Header(msgHeader11);
                                    }
                                    keyUpdateResp = new SMEKeyObjectCKMCUpdateResp();
                                    keyUpdateResp.setCluster_Name(this.clusterName);
                                    tableData11 = new SMETableData();
                                    tableData11.setKey_Object_CKMC_Update_Resp(keyUpdateResp);
                                    smeMessage.setTable_Data(tableData11);
                                }
                            } else if (opCode.equals((Object)SMEOpcodeEnum.CKMC___DELETE___ALL___KEY___OBJECTS___BY___KEY___ENTITY)) {
                                SMEMsgHeader msgHeader12;
                                _Logger.info((Object)("Archive all keys for entity request is received from " + this.sock.getInetAddress()));
                                SMEKeyEntity entity = smeMessage.getTable_Data().getKey_Object_CKMC_Delete_Req().getReq_Index().getKey_Entity();
                                String archivalTime = smeMessage.getTable_Data().getKey_Object_CKMC_Delete_Req().getDeletion_Time();
                                ClusterInfo clusterInfo = this.clusterBean.getClusterInfo(this.clusterName);
                                if (clusterInfo.getCkmcState() != CKMCClusterStateEnum.Synchronized) {
                                    _Logger.warn((Object)("Cluster is not synchronized. Archive key requests are not allowed from " + this.sock.getInetAddress()));
                                    msgHeader12 = smeMessage.getMsg_Header();
                                    msgHeader12.setIS_Resp(true);
                                    msgHeader12.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                    msgHeader12.setResponse_Status_Desc("Cluster is not synchronized. Archive key requests are not allowed.");
                                    smeMessage.setMsg_Header(msgHeader12);
                                    SMEKeyObjectCKMCUpdateResp keyUpdateResp3 = new SMEKeyObjectCKMCUpdateResp();
                                    keyUpdateResp3.setCluster_Name(this.clusterName);
                                    tableData8 = new SMETableData();
                                    tableData8.setKey_Object_CKMC_Update_Resp(keyUpdateResp3);
                                    smeMessage.setTable_Data(tableData8);
                                } else {
                                    msgHeader12 = smeMessage.getMsg_Header();
                                    msgHeader12.setIS_Resp(true);
                                    OperationStatus ret = this.ckmcBean.archiveAllKeysforEntity(null, this.clusterId, entity, archivalTime);
                                    if (ret.getStatus() == OperationStatusEnum.Success) {
                                        msgHeader12.setResponse_Status(SMEResponseStatusEnum.SME___SUCCESS);
                                        msgHeader12.setResponse_Status_Desc("Success");
                                        _Logger.info((Object)("Archive key successful for cluster " + this.clusterName));
                                    } else {
                                        msgHeader12.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                        msgHeader12.setResponse_Status_Desc(ret.getDescription());
                                        _Logger.warn((Object)("Archive key failed for cluster " + this.clusterName));
                                    }
                                    smeMessage.setMsg_Header(msgHeader12);
                                    keyUpdateResp = new SMEKeyObjectCKMCUpdateResp();
                                    keyUpdateResp.setCluster_Name(this.clusterName);
                                    tableData11 = new SMETableData();
                                    tableData11.setKey_Object_CKMC_Update_Resp(keyUpdateResp);
                                    smeMessage.setTable_Data(tableData11);
                                }
                            } else {
                                _Logger.warn((Object)("Invalid Request received from " + this.sock.getInetAddress()));
                                SMEMsgHeader msgHeader13 = smeMessage.getMsg_Header();
                                msgHeader13.setIS_Resp(true);
                                msgHeader13.setResponse_Status(SMEResponseStatusEnum.SME___FAILURE);
                                msgHeader13.setResponse_Status_Desc("Invalid Request");
                                smeMessage.setMsg_Header(msgHeader13);
                            }
                        }
                    }
                }
                msgOut = ckmcMessage.prepareCKMCMessage(smeMessage);
                _Logger.info((Object)("Sending message to switch: " + this.sock.getRemoteSocketAddress()));
                if (this.logXMLMessages) {
                    _Logger.info((Object)("Message: " + msgOut));
                }
                this.send(out, msgOut);
            }
        }
        catch (SocketException se) {
            _Logger.warn((Object)("Failed to process request. SocketException. Buffer contents:" + _buff1), (Throwable)se);
        }
        catch (Exception e) {
            _Logger.warn((Object)("Failed to process request. Error:" + e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                _Logger.warn((Object)("Stopped worker for socket " + this.sock.getRemoteSocketAddress()));
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (IOException ioe) {
                _Logger.warn((Object)("Failed to process request. Error:" + ioe.getMessage()), (Throwable)ioe);
            }
        }
    }

    @Override
    public OperationStatus send(String message, String token) {
        OperationStatus ret = new OperationStatus();
        if (CKMCMsgs.pendingRequests.containsKey(token)) {
            _Logger.info((Object)("Token (" + token + ") has already been processed for pending requests."));
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("Token (" + token + ") has already been processed for pending requests.");
        } else {
            ret = this.send(message);
            if (ret.getStatus().equals(OperationStatusEnum.Success)) {
                CKMCMsgs.pendingRequests.put(token, message);
                _Logger.info((Object)("Token (" + token + ") has been added to pending requests queue."));
            } else {
                _Logger.info((Object)"Token not added to request queue: Send message failed.");
            }
        }
        return ret;
    }

    @Override
    public String receive(String token) {
        if (CKMCMsgs.pendingResponses.containsKey(token)) {
            String message = CKMCMsgs.pendingResponses.get(token);
            CKMCMsgs.pendingResponses.remove(token);
            return message;
        }
        _Logger.info((Object)("Token (" + token + ") was not found in response queue."));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus send(String message) {
        OperationStatus ret = new OperationStatus();
        ret.setStatus(OperationStatusEnum.Success);
        PrintWriter out = null;
        try {
            if (out == null) {
                out = new PrintWriter(new OutputStreamWriter(this.sock.getOutputStream()));
            }
            _Logger.info((Object)("Sending message to switch: " + this.sock.getRemoteSocketAddress()));
            if (this.logXMLMessages) {
                _Logger.info((Object)("Message: " + message));
            }
            this.send(out, message);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Failed to send message: " + ex.getMessage()), (Throwable)ex);
            ret.setStatus(OperationStatusEnum.Failure);
        }
        finally {
            if (out != null && out.checkError()) {
                out.close();
            }
        }
        return ret;
    }

    public synchronized void send(PrintWriter out, String message) {
        out.println(message);
        out.flush();
    }

    @Override
    public OperationStatus cancel(String token) {
        if (CKMCMsgs.pendingResponses.containsKey(token)) {
            CKMCMsgs.pendingResponses.remove(token);
        }
        if (CKMCMsgs.pendingRequests.containsKey(token)) {
            CKMCMsgs.pendingRequests.remove(token);
        }
        OperationStatus ret = new OperationStatus();
        ret.setStatus(OperationStatusEnum.Success);
        return ret;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public boolean isConnected() {
        return !this.sock.isClosed();
    }
}

