/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.common;

import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sme.common.ClusterBase;
import com.cisco.dcbu.sme.common.ClusterStatusEnum;
import com.cisco.dcbu.sme.common.Config;
import com.cisco.dcbu.sme.common.DiskGroupStatusEnum;
import com.cisco.dcbu.sme.common.DiskStatusEnum;
import com.cisco.dcbu.sme.common.TapeGroupStatusEnum;
import com.cisco.dcbu.sme.common.TapeVolumeGroupStatusEnum;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

public class SMEContext
implements Serializable {
    private static final long serialVersionUID = -3262971863671513184L;
    private String userName;
    private String password;
    private List<String> roles;
    private String sessionId;
    private ClusterBase cluster;
    private ClusterStatusEnum clusterStatus;
    private TapeGroupStatusEnum tapeGroupStatus;
    private TapeVolumeGroupStatusEnum tapeVolumeGroupStatus;
    private DiskGroupStatusEnum diskGroupStatus;
    private DiskStatusEnum diskStatus;
    static Logger _Logger = Logger.getLogger((String)"SME");
    private boolean limitRole = false;

    public ClusterStatusEnum getClusterStatus() {
        return this.clusterStatus;
    }

    public void setClusterStatus(ClusterStatusEnum clusterStatus) {
        this.clusterStatus = clusterStatus;
    }

    public DiskGroupStatusEnum getDiskGroupStatus() {
        return this.diskGroupStatus;
    }

    public void setDiskGroupStatus(DiskGroupStatusEnum diskGroupStatus) {
        this.diskGroupStatus = diskGroupStatus;
    }

    public DiskStatusEnum getDiskStatus() {
        return this.diskStatus;
    }

    public void setDiskStatus(DiskStatusEnum diskStatus) {
        this.diskStatus = diskStatus;
    }

    public TapeGroupStatusEnum getTapeGroupStatus() {
        return this.tapeGroupStatus;
    }

    public void setTapeGroupStatus(TapeGroupStatusEnum tapeGroupStatus) {
        this.tapeGroupStatus = tapeGroupStatus;
    }

    public TapeVolumeGroupStatusEnum getTapeVolumeGroupStatus() {
        return this.tapeVolumeGroupStatus;
    }

    public void setTapeVolumeGroupStatus(TapeVolumeGroupStatusEnum tapeVolumeGroupStatus) {
        this.tapeVolumeGroupStatus = tapeVolumeGroupStatus;
    }

    public ClusterBase getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterBase cluster) {
        this.cluster = cluster;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public SMEContext() {
        this.clusterStatus = ClusterStatusEnum.None;
        this.tapeGroupStatus = TapeGroupStatusEnum.None;
        this.tapeVolumeGroupStatus = TapeVolumeGroupStatusEnum.None;
        this.diskGroupStatus = DiskGroupStatusEnum.None;
        this.diskStatus = DiskStatusEnum.None;
    }

    public SMEContext(FMUserBase credentials) {
        Config conf = Config.getInstance();
        this.clusterStatus = ClusterStatusEnum.None;
        this.tapeGroupStatus = TapeGroupStatusEnum.None;
        this.tapeVolumeGroupStatus = TapeVolumeGroupStatusEnum.None;
        this.diskGroupStatus = DiskGroupStatusEnum.None;
        this.diskStatus = DiskStatusEnum.None;
        if (credentials != null) {
            this.setUserName(credentials.getUsername());
            this.setPassword(credentials.getEncryptedPassword());
            this.setRoles(credentials.getRoles());
        } else {
            this.userName = conf.getUserName();
            this.password = conf.getPassword();
        }
        this.limitRole = conf.isLimitKeyAdminRole();
    }

    public boolean loggedOut() {
        return this.userName == null || this.password == null || this.userName.length() == 0 || this.password.length() == 0;
    }

    public boolean isKeyView() {
        return this.roles.contains("sme-kmc-admin") || this.roles.contains("sme-admin") || this.roles.contains("network-admin") || this.roles.contains("SAN-Admin") || this.roles.contains("Global-Admin") || this.roles.contains("san-network-admin");
    }

    public boolean isKeyAdmin() {
        if (this.limitRole) {
            return this.roles.contains("sme-kmc-admin");
        }
        return this.isKeyView();
    }

    public boolean isStorageAdmin() {
        return this.roles.contains("sme-stg-admin") || this.roles.contains("sme-admin") || this.roles.contains("network-admin") || this.roles.contains("SAN-Admin") || this.roles.contains("Global-Admin") || this.roles.contains("san-network-admin");
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }
}

