/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.common.mapper;

import com.cisco.dcbu.sme.common.KeyTypeEnum;
import com.cisco.dcbu.sme.xml.SMEKeyTypeEnum;

public class KeyTypeSMEMapper {
    public static KeyTypeEnum mapKeyType(SMEKeyTypeEnum smeKeyType) {
        KeyTypeEnum keyType = KeyTypeEnum.None;
        if (smeKeyType == null) {
            return keyType;
        }
        switch (smeKeyType) {
            case KEY___TYPE___NONE: {
                keyType = KeyTypeEnum.None;
                break;
            }
            case KEY___TYPE___MASTER___KEY: {
                keyType = KeyTypeEnum.MasterKey;
                break;
            }
            case KEY___TYPE___MASTER___KEY___SHARE: {
                keyType = KeyTypeEnum.MasterKeyShare;
                break;
            }
            case KEY___TYPE___DISK___KEY: {
                keyType = KeyTypeEnum.DiskKey;
                break;
            }
            case KEY___TYPE___DISK___GROUP___SHARED___KEY: {
                keyType = KeyTypeEnum.DiskGroupSharedKey;
                break;
            }
            case KEY___TYPE___TAPE___VOLUMEGROUP___WRAP___KEY: {
                keyType = KeyTypeEnum.TapeVolumeGroupWrapKey;
                break;
            }
            case KEY___TYPE___TAPE___VOLUMEGROUP___SHARED___KEY: {
                keyType = KeyTypeEnum.TapeVolumeGroupSharedKey;
                break;
            }
            case KEY___TYPE___TAPE___VOLUME___KEY: {
                keyType = KeyTypeEnum.TapeVolumeKey;
            }
        }
        return keyType;
    }

    public static SMEKeyTypeEnum mapKeyType(KeyTypeEnum keyType) {
        SMEKeyTypeEnum smeKeyType = SMEKeyTypeEnum.KEY___TYPE___NONE;
        if (keyType == null) {
            return smeKeyType;
        }
        switch (keyType) {
            case None: {
                smeKeyType = SMEKeyTypeEnum.KEY___TYPE___NONE;
                break;
            }
            case MasterKey: {
                smeKeyType = SMEKeyTypeEnum.KEY___TYPE___MASTER___KEY;
                break;
            }
            case MasterKeyShare: {
                smeKeyType = SMEKeyTypeEnum.KEY___TYPE___MASTER___KEY___SHARE;
                break;
            }
            case DiskKey: {
                smeKeyType = SMEKeyTypeEnum.KEY___TYPE___DISK___KEY;
                break;
            }
            case DiskGroupSharedKey: {
                smeKeyType = SMEKeyTypeEnum.KEY___TYPE___DISK___GROUP___SHARED___KEY;
                break;
            }
            case TapeVolumeGroupWrapKey: {
                smeKeyType = SMEKeyTypeEnum.KEY___TYPE___TAPE___VOLUMEGROUP___WRAP___KEY;
                break;
            }
            case TapeVolumeGroupSharedKey: {
                smeKeyType = SMEKeyTypeEnum.KEY___TYPE___TAPE___VOLUMEGROUP___SHARED___KEY;
                break;
            }
            case TapeVolumeKey: {
                smeKeyType = SMEKeyTypeEnum.KEY___TYPE___TAPE___VOLUME___KEY;
            }
        }
        return smeKeyType;
    }
}

