/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ejb.impl;

import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.comm.SmeXmlHandler;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.ClusterLockEnum;
import com.cisco.dcbu.sme.common.ClusterSmartcardInfo;
import com.cisco.dcbu.sme.common.ClusterStatusEnum;
import com.cisco.dcbu.sme.common.ClusterTypeEnum;
import com.cisco.dcbu.sme.common.DiskDetailInfo;
import com.cisco.dcbu.sme.common.DiskDiscoveryInfo;
import com.cisco.dcbu.sme.common.DiskGroupImport;
import com.cisco.dcbu.sme.common.DiskGroupInfo;
import com.cisco.dcbu.sme.common.DiskGroupStatusEnum;
import com.cisco.dcbu.sme.common.DiskInfo;
import com.cisco.dcbu.sme.common.DiskOperation;
import com.cisco.dcbu.sme.common.DiskOperationDisable;
import com.cisco.dcbu.sme.common.DiskOperationEnable;
import com.cisco.dcbu.sme.common.DiskOperationModifyKey;
import com.cisco.dcbu.sme.common.DiskOperationReWrap;
import com.cisco.dcbu.sme.common.DiskOperationReadOnly;
import com.cisco.dcbu.sme.common.DiskOperationRecover;
import com.cisco.dcbu.sme.common.DiskOperationRekey;
import com.cisco.dcbu.sme.common.DiskOperationResume;
import com.cisco.dcbu.sme.common.DiskOperationSignature;
import com.cisco.dcbu.sme.common.DiskOperationSuspend;
import com.cisco.dcbu.sme.common.DiskPathInfo;
import com.cisco.dcbu.sme.common.DiskSignatureInfo;
import com.cisco.dcbu.sme.common.DiskStatusEnum;
import com.cisco.dcbu.sme.common.DiskVPD;
import com.cisco.dcbu.sme.common.FabricInfo;
import com.cisco.dcbu.sme.common.FilterInfo;
import com.cisco.dcbu.sme.common.ITInfo;
import com.cisco.dcbu.sme.common.Initiator;
import com.cisco.dcbu.sme.common.KeyInfo;
import com.cisco.dcbu.sme.common.Limits;
import com.cisco.dcbu.sme.common.MasterkeyRekeyInfo;
import com.cisco.dcbu.sme.common.MasterkeyRekeyStateEnum;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.PathInfo;
import com.cisco.dcbu.sme.common.RKCFilterInfo;
import com.cisco.dcbu.sme.common.RKCFilterTypeEnum;
import com.cisco.dcbu.sme.common.RKCRelationshipInfo;
import com.cisco.dcbu.sme.common.RKCRelationshipMapInfo;
import com.cisco.dcbu.sme.common.RKCRelationshipStatusEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.SignatureModeConversionInfo;
import com.cisco.dcbu.sme.common.SignatureModeConversionStateEnum;
import com.cisco.dcbu.sme.common.Target;
import com.cisco.dcbu.sme.common.VsanInfo;
import com.cisco.dcbu.sme.common.ZoneInfo;
import com.cisco.dcbu.sme.common.mapper.EncryptionAlgoMapper;
import com.cisco.dcbu.sme.common.mapper.LunStatusMapper;
import com.cisco.dcbu.sme.common.mapper.OperationStatusSMEMapper;
import com.cisco.dcbu.sme.common.mapper.PathStatusMapper;
import com.cisco.dcbu.sme.ejb.api.ClusterMgr;
import com.cisco.dcbu.sme.ejb.api.DiskGroupMgr;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.ejb.api.PathMgr;
import com.cisco.dcbu.sme.ejb.api.RKCMgr;
import com.cisco.dcbu.sme.ejb.impl.MgrHelper;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.exception.SMEInvalidMessageException;
import com.cisco.dcbu.sme.exception.SMEProcessingException;
import com.cisco.dcbu.sme.message.ClusterMessage;
import com.cisco.dcbu.sme.message.DiskGroupMessage;
import com.cisco.dcbu.sme.message.ITNexusMessage;
import com.cisco.dcbu.sme.replication.SMEReplicationRelationship;
import com.cisco.dcbu.sme.tree.DiskGroupTreeNode;
import com.cisco.dcbu.sme.tree.DiskTreeNode;
import com.cisco.dcbu.sme.xml.SMEDiskData;
import com.cisco.dcbu.sme.xml.SMEDiskGroupData;
import com.cisco.dcbu.sme.xml.SMEDiskGroupIndex;
import com.cisco.dcbu.sme.xml.SMEDiskGroupObject;
import com.cisco.dcbu.sme.xml.SMEDiskIndex;
import com.cisco.dcbu.sme.xml.SMEDiskList;
import com.cisco.dcbu.sme.xml.SMEDiskObject;
import com.cisco.dcbu.sme.xml.SMEDiskPathIndex;
import com.cisco.dcbu.sme.xml.SMEDiskPathObject;
import com.cisco.dcbu.sme.xml.SMEITLObject;
import com.cisco.dcbu.sme.xml.SMEITLStatusEnum;
import com.cisco.dcbu.sme.xml.SMEITNexusObject;
import com.cisco.dcbu.sme.xml.SMELunMapEntry;
import com.cisco.dcbu.sme.xml.SMELunPathConfigEnum;
import com.cisco.dcbu.sme.xml.SMELunPathUserConfig;
import com.cisco.dcbu.sme.xml.SMELunStatusEnum;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEPath;
import com.cisco.dcbu.sme.xml.SMEResponseStatusEnum;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class DiskGroupMgrBean
extends MgrHelper
implements Serializable,
DiskGroupMgr {
    static Logger _Logger = Logger.getLogger((String)"SME");
    protected PathMgr pathBean;
    protected RKCMgr rkcBean;

    @EJB
    public void setRKCMgrBean(RKCMgr rkcBean) {
        this.rkcBean = rkcBean;
    }

    @EJB
    public void setModelMgrBean(ModelMgr modelBean) {
        this.modelBean = modelBean;
    }

    @EJB
    public void setClusterMgrBean(ClusterMgr clusterBean) {
        this.clusterBean = clusterBean;
    }

    @EJB
    public void setPathMgrBean(PathMgr pathBean) {
        this.pathBean = pathBean;
    }

    @Override
    public OperationStatus createDiskGroup(SMEContext ctx, DiskGroupInfo diskGroupInfo) {
        OperationStatus ret = new OperationStatus();
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, diskGroupInfo.getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(diskGroupInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskGroupSetReq(diskGroupInfo, SMEOpcodeEnum.CREATE___DISK___GROUP);
        String msgIn = null;
        _Logger.debug((Object)("Sending createDiskGroup for " + diskGroupInfo.getClusterName() + " " + diskGroupInfo.getDiskGroupName()));
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)"Failed to send message to switch", (Throwable)se);
        }
        if (msgIn != null) {
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().isIS_Resp()) {
                ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
            } else {
                ret.setStatus(OperationStatusEnum.Failure);
                ret.setDescription("Failed to create Disk Group: " + diskGroupInfo.getDiskGroupName());
            }
        } else {
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("Failed to create Disk Group: " + diskGroupInfo.getDiskGroupName());
        }
        _Logger.debug((Object)("Operation createDiskGroup returning " + ret.getStatus() + " " + ret.getDescription()));
        return ret;
    }

    @Override
    public OperationStatus deleteDiskGroup(SMEContext ctx, String clusterName, String diskGroupName) {
        OperationStatus ret = new OperationStatus();
        DiskGroupInfo diskGroupInfo = new DiskGroupInfo();
        diskGroupInfo.setClusterName(clusterName);
        diskGroupInfo.setDiskGroupName(diskGroupName);
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskGroupSetReq(diskGroupInfo, SMEOpcodeEnum.DELETE___DISK___GROUP);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().isIS_Resp()) {
                ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
            } else {
                ret.setStatus(OperationStatusEnum.Failure);
                ret.setDescription("Failed to delete Disk Group: " + diskGroupInfo.getDiskGroupName());
            }
        } else {
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("Failed to delete Disk Group: " + diskGroupInfo.getDiskGroupName());
        }
        return ret;
    }

    @Override
    public OperationStatus modifyDiskGroup(SMEContext ctx, DiskGroupInfo diskGroupInfo, DiskOperation oper) {
        OperationStatus status = new OperationStatus();
        status.set(OperationStatusEnum.Failure, "Operation error: not implemented");
        String clusterName = diskGroupInfo.getClusterName();
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        SMEOpcodeEnum opCode = null;
        if (oper instanceof DiskOperationSuspend) {
            opCode = SMEOpcodeEnum.SUSPEND___DISK___GROUP;
        } else if (oper instanceof DiskOperationResume) {
            opCode = SMEOpcodeEnum.RESUME___DISK___GROUP;
        } else if (oper instanceof DiskOperationEnable) {
            opCode = SMEOpcodeEnum.ENABLE___DISK___GROUP;
        } else if (oper instanceof DiskOperationDisable) {
            opCode = SMEOpcodeEnum.DISABLE___DISK___GROUP;
        }
        _Logger.debug((Object)("modifyDiskGroup - " + diskGroupInfo.getDiskGroupName() + " operation=" + opCode.toString()));
        if (opCode != null) {
            SMEMessage smeMessage;
            String msgOut = diskGroupMessage.prepareDiskGroupSetReq(diskGroupInfo, opCode);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null && (smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp()) {
                String reason = smeMessage.getMsg_Header().getResponse_Status_Desc();
                if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                    _Logger.warn((Object)("modifyDiskGroup - Switch returned failure response: " + reason));
                    status.set(OperationStatusEnum.Failure, reason);
                } else {
                    _Logger.debug((Object)("modifyDiskGroup - Switch returned success response: " + reason));
                    status.set(OperationStatusEnum.Success, reason);
                }
            }
        }
        return status;
    }

    @Override
    public DiskGroupInfo getDiskGroup(SMEContext ctx, String clusterName, String diskGroupName) {
        SMEMessage smeMessage;
        DiskGroupInfo diskGroupInfo = null;
        diskGroupInfo = new DiskGroupInfo();
        diskGroupInfo.setClusterName(clusterName);
        diskGroupInfo.setDiskGroupName(diskGroupName);
        diskGroupInfo.setStatus(null);
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskGroupGetReq(diskGroupInfo, SMEOperationEnum.SME___OP___GET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null && (smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp()) {
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"getDiskGroup - Switch returned failure response.");
                return diskGroupInfo;
            }
            List diskGroupList = smeMessage.getTable_Data().getDiskGroup_Get_Resp().getDisk_Group();
            Iterator it = diskGroupList.iterator();
            if (it.hasNext()) {
                SMEDiskGroupObject diskGroupObject = (SMEDiskGroupObject)it.next();
                SMEDiskGroupIndex index = diskGroupObject.getIndex();
                SMEDiskGroupData data = diskGroupObject.getData();
                diskGroupInfo.setClusterName(index.getCluster_Name());
                diskGroupInfo.setDiskGroupName(index.getDisk_Group_Name());
                diskGroupInfo.setId("" + data.getID());
                diskGroupInfo.setStatus(LunStatusMapper.convertStatusToDiskGroup(data.getLuns_Status()));
                diskGroupInfo.setProgress(data.getProgress());
                diskGroupInfo.setTotalDisks(data.getTotal_Disks());
            }
        }
        return diskGroupInfo;
    }

    @Override
    public ArrayList<DiskGroupInfo> getDiskGroupInfoList(SMEContext ctx, String clusterName) {
        ArrayList<DiskGroupInfo> diskGroups = null;
        diskGroups = new ArrayList<DiskGroupInfo>();
        DiskGroupInfo diskGroupInfo = new DiskGroupInfo();
        diskGroupInfo.setClusterName(clusterName);
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = diskGroupMessage.prepareDiskGroupGetReq(diskGroupInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_DISK_GROUPS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"Switch returned failure response.");
                return diskGroups;
            }
            List diskGroupList = smeMessage.getTable_Data().getDiskGroup_Get_Resp().getDisk_Group();
            for (SMEDiskGroupObject diskGroupObject : diskGroupList) {
                SMEDiskGroupIndex index = diskGroupObject.getIndex();
                SMEDiskGroupData data = diskGroupObject.getData();
                DiskGroupInfo dgi = new DiskGroupInfo();
                dgi.setClusterName(clusterName);
                dgi.setClusterName(index.getCluster_Name());
                dgi.setDiskGroupName(index.getDisk_Group_Name());
                dgi.setId("" + data.getID());
                dgi.setStatus(LunStatusMapper.convertStatusToDiskGroup(data.getLuns_Status()));
                dgi.setProgress(data.getProgress());
                dgi.setTotalDisks(data.getTotal_Disks());
                diskGroups.add(dgi);
                diskGroupInfo = dgi;
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_DISK_GROUPS_IN_REQUEST);
        return diskGroups;
    }

    @Override
    public ArrayList<DiskGroupTreeNode> getDiskGroupTreeNodes(SMEContext ctx) {
        ArrayList<DiskGroupTreeNode> diskGroups = null;
        diskGroups = new ArrayList<DiskGroupTreeNode>();
        DiskGroupInfo diskGroupInfo = new DiskGroupInfo();
        diskGroupInfo.setClusterName(ctx.getCluster().getClusterName());
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = diskGroupMessage.prepareDiskGroupGetReq(diskGroupInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_DISK_GROUPS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"getDiskGroupTreeNodes - Switch returned failure response.");
                return diskGroups;
            }
            List diskGroupList = smeMessage.getTable_Data().getDiskGroup_Get_Resp().getDisk_Group();
            Iterator it = diskGroupList.iterator();
            while (it.hasNext()) {
                DiskGroupTreeNode diskGroupTreeNode = new DiskGroupTreeNode();
                SMEDiskGroupObject diskGroupObject = (SMEDiskGroupObject)it.next();
                diskGroupTreeNode.setClusterName(diskGroupObject.getIndex().getCluster_Name());
                diskGroupTreeNode.setDiskGroupName(diskGroupObject.getIndex().getDisk_Group_Name());
                diskGroupTreeNode.setStatus(LunStatusMapper.convertStatusToDiskGroup(diskGroupObject.getData().getLuns_Status()));
                diskGroupTreeNode.setDisks(this.getDiskTreeNodes(ctx, diskGroupTreeNode.getDiskGroupName()));
                diskGroups.add(diskGroupTreeNode);
                diskGroupInfo.setClusterName(diskGroupTreeNode.getClusterName());
                diskGroupInfo.setDiskGroupName(diskGroupTreeNode.getDiskGroupName());
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_DISK_GROUPS_IN_REQUEST);
        return diskGroups;
    }

    @Override
    public OperationStatus addDisk(SMEContext ctx, DiskInfo diskInfo) {
        OperationStatus ret = new OperationStatus();
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, diskInfo.getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(diskInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskSetReq(diskInfo, SMEOpcodeEnum.CREATE___DISK, null);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().isIS_Resp()) {
                ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
            } else {
                ret.setStatus(OperationStatusEnum.Failure);
                ret.setDescription("Failed to add Disk : " + diskInfo.getDiskName() + " to Disk Group: " + diskInfo.getDiskGroupName());
            }
        } else {
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("Failed to add Disk : " + diskInfo.getDiskName() + " to Disk Group: " + diskInfo.getDiskGroupName());
        }
        return ret;
    }

    @Override
    public OperationStatus deleteDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        OperationStatus ret = new OperationStatus();
        DiskInfo diskInfo = new DiskInfo();
        diskInfo.setClusterName(clusterName);
        diskInfo.setDiskGroupName(diskGroupName);
        diskInfo.setDiskName(diskName);
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskSetReq(diskInfo, SMEOpcodeEnum.DELETE___DISK, null);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().isIS_Resp()) {
                ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
            } else {
                ret.setStatus(OperationStatusEnum.Failure);
                ret.setDescription("Failed to delete Disk : " + diskInfo.getDiskName() + " from Disk Group: " + diskInfo.getDiskGroupName());
            }
        } else {
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("Failed to delete Disk : " + diskInfo.getDiskName() + " from Disk Group: " + diskInfo.getDiskGroupName());
        }
        return ret;
    }

    @Override
    public void diskCleanup(SMEContext ctx) {
        this.sendITNexusClear(ctx);
    }

    @Override
    public OperationStatus modifyDisk(SMEContext ctx, DiskInfo diskInfo, DiskOperation oper) {
        return this.modifyDisk(ctx, diskInfo, oper, true);
    }

    @Override
    public OperationStatus modifyDisk(SMEContext ctx, DiskInfo diskInfo, DiskOperation oper, boolean checkRKC) {
        DiskOperation dor;
        DiskOperation doe;
        OperationStatus status = new OperationStatus();
        status.set(OperationStatusEnum.Failure, "Operation error: not implemented");
        String clusterName = diskInfo.getClusterName();
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        SMEOpcodeEnum opCode = null;
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        RKCRelationshipMapInfo rkcMap = new RKCRelationshipMapInfo();
        try {
            rkcMap = ckmcBean.getRKCRelationshipMap(diskInfo.getClusterName(), diskInfo.getVpd().getVendorId(), diskInfo.getVpd().getProductId(), diskInfo.getWwn());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (rkcMap.isActiveSource()) {
            if (oper instanceof DiskOperationEnable) {
                doe = (DiskOperationEnable)oper;
                if (((DiskOperationEnable)doe).isPrepareData()) {
                    status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk.");
                    return status;
                }
            } else if (oper instanceof DiskOperationDisable) {
                doe = (DiskOperationDisable)oper;
                if (((DiskOperationDisable)doe).isPrepareData()) {
                    status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk.");
                    return status;
                }
            } else if (oper instanceof DiskOperationRekey) {
                status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk.");
                return status;
            }
        }
        if (oper instanceof DiskOperationSuspend) {
            opCode = SMEOpcodeEnum.SUSPEND___DISK;
            if (checkRKC && rkcMap.isActiveDestination()) {
                status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk as a destination.");
                return status;
            }
        } else if (oper instanceof DiskOperationResume) {
            opCode = SMEOpcodeEnum.RESUME___DISK;
        } else if (oper instanceof DiskOperationEnable) {
            opCode = SMEOpcodeEnum.ENABLE___DISK;
            if (checkRKC && rkcMap.isActiveDestination()) {
                status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk as a destination.");
                return status;
            }
            doe = (DiskOperationEnable)oper;
            if (((DiskOperationEnable)doe).getGUID() != null && ((DiskOperationEnable)doe).getGUID().length() > 0 && !ckmcBean.isValidDiskKey(ctx, clusterName, ((DiskOperationEnable)doe).getGUID())) {
                status.set(OperationStatusEnum.Failure, "GUID: " + ((DiskOperationEnable)doe).getGUID() + " not found.");
                return status;
            }
        } else if (oper instanceof DiskOperationDisable) {
            opCode = SMEOpcodeEnum.DISABLE___DISK;
            if (checkRKC && rkcMap.isActiveDestination()) {
                status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk as a destination.");
                return status;
            }
        } else if (oper instanceof DiskOperationModifyKey) {
            opCode = SMEOpcodeEnum.MODIFY___KEY___DISK;
            if (checkRKC && rkcMap.isActiveDestination()) {
                status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk as a destination.");
                return status;
            }
        } else if (oper instanceof DiskOperationRecover) {
            opCode = SMEOpcodeEnum.RECOVER___DISK;
            dor = (DiskOperationRecover)oper;
            if (((DiskOperationRecover)dor).getGUID() != null && ((DiskOperationRecover)dor).getGUID().length() > 0 && !ckmcBean.isValidDiskKey(ctx, clusterName, ((DiskOperationRecover)dor).getGUID())) {
                status.set(OperationStatusEnum.Failure, "GUID: " + ((DiskOperationRecover)dor).getGUID() + " not found.");
                return status;
            }
            if (checkRKC && rkcMap.isActiveDestination()) {
                status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk as a destination.");
                return status;
            }
        } else if (oper instanceof DiskOperationRekey) {
            opCode = SMEOpcodeEnum.REKEY___DISK;
            if (checkRKC && rkcMap.isActiveDestination()) {
                status.set(OperationStatusEnum.Failure, "Operation not permitted at this time.  You must first disable all Disk Key Replication relationships involving this disk as a destination.");
                return status;
            }
        } else if (oper instanceof DiskOperationReadOnly) {
            opCode = SMEOpcodeEnum.UPDATE___DISK___READ___ONLY___KEY;
            dor = (DiskOperationReadOnly)oper;
            if (((DiskOperationReadOnly)dor).getGUID() != null && ((DiskOperationReadOnly)dor).getGUID().length() > 0 && !ckmcBean.isValidDiskKey(ctx, clusterName, ((DiskOperationReadOnly)dor).getGUID())) {
                status.set(OperationStatusEnum.Failure, "GUID: " + ((DiskOperationReadOnly)dor).getGUID() + " not found.");
                return status;
            }
        } else if (oper instanceof DiskOperationSignature) {
            opCode = SMEOpcodeEnum.UPDATE___DISK___METADATA;
        }
        _Logger.debug((Object)("modifyDisk - " + diskInfo.getDiskGroupName() + ":" + diskInfo.getDiskName() + " operation=" + opCode.toString()));
        if (rkcMap.isActiveSource()) {
            OperationStatus suspendStatus;
            _Logger.debug((Object)"modifyDisk - is active Source Disk in Disk Key Replication, suspending Destination disks");
            if ((oper instanceof DiskOperationEnable || oper instanceof DiskOperationDisable || oper instanceof DiskOperationModifyKey || oper instanceof DiskOperationRekey || oper instanceof DiskOperationRecover) && !OperationStatusEnum.Success.equals((suspendStatus = this.suspendChain(ctx, rkcMap)).getStatus())) {
                return suspendStatus;
            }
        }
        if (opCode != null) {
            SMEMessage smeMessage;
            String msgOut = diskGroupMessage.prepareDiskSetReq(diskInfo, opCode, oper);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null && (smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp()) {
                String reason = smeMessage.getMsg_Header().getResponse_Status_Desc();
                if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                    _Logger.warn((Object)("modifyDisk - Switch returned failure response: " + reason));
                    status.set(OperationStatusEnum.Failure, reason);
                } else {
                    _Logger.debug((Object)("modifyDisk - Switch returned success response: " + reason));
                    status.set(OperationStatusEnum.Success, reason);
                }
            }
        }
        if (OperationStatusEnum.Success.equals(status.getStatus()) && rkcMap.isActiveSource()) {
            _Logger.debug((Object)"modifyDisk - is active Source Disk in Disk Key Replication, suspending Destination disks");
            if (oper instanceof DiskOperationEnable || oper instanceof DiskOperationDisable || oper instanceof DiskOperationModifyKey || oper instanceof DiskOperationRekey || oper instanceof DiskOperationRecover) {
                boolean somefailed = false;
                for (RKCRelationshipInfo ri : rkcMap.getSourceList()) {
                    if (!RKCRelationshipStatusEnum.Active.equals((Object)ri.getStatus())) continue;
                    ArrayList<OperationStatus> res = this.rkcBean.sync(ctx, ri);
                    for (OperationStatus os : res) {
                        if (OperationStatusEnum.Success.equals(os.getStatus())) continue;
                        somefailed = true;
                    }
                }
                if (somefailed) {
                    status.setDescription("Primary operation succeeded.  One or more Sync operations failed.  Check the status of your Disk Key Replication relationships and associated disks.");
                }
            }
        }
        return status;
    }

    private OperationStatus suspendChain(SMEContext ctx, RKCRelationshipMapInfo rkcMap) {
        HashMap<String, CKMCFacade> cluster2ckmcList = new HashMap<String, CKMCFacade>();
        for (RKCRelationshipInfo rel : rkcMap.getSourceList()) {
            OperationStatus suspendStatus;
            OperationStatus stat;
            if (!RKCRelationshipStatusEnum.Active.equals((Object)rel.getStatus())) continue;
            DiskInfo di = this.getDisk(ctx, rel.getDestClusterName(), rel.getDestGroupName(), rel.getDestName());
            if (!(di.getStatus().equals((Object)DiskStatusEnum.Failure) || di.getStatus().equals((Object)DiskStatusEnum.Suspend) || OperationStatusEnum.Success.equals((stat = this.modifyDisk(ctx, di, new DiskOperationSuspend(), false)).getStatus()))) {
                _Logger.info((Object)("Warning: There was a problem suspending disk for " + rel.getDestClusterName() + " " + rel.getDestGroupName() + " " + rel.getDestName()));
                stat.setDescription("Failed to suspend Disk " + rel.getDestClusterName() + " " + rel.getDestGroupName() + " " + rel.getDestName() + " in active Disk Key Replication relationship: " + stat.getDescription());
                return stat;
            }
            CKMCFacade ckmcBean = (CKMCFacade)cluster2ckmcList.get(rel.getDestClusterName());
            if (ckmcBean == null) {
                ckmcBean = this.getCKMCBean(ctx, rel.getDestClusterName());
                cluster2ckmcList.put(rel.getDestClusterName(), ckmcBean);
            }
            RKCRelationshipMapInfo recurseMap = ckmcBean.getRKCRelationshipMap(rel.getDestClusterName(), rel.getDestVendor(), rel.getDestProduct(), rel.getDestWwn());
            if (!rkcMap.isActiveSource() || OperationStatusEnum.Success.equals((suspendStatus = this.suspendChain(ctx, recurseMap)).getStatus())) continue;
            return suspendStatus;
        }
        OperationStatus stat = new OperationStatus();
        stat.set(OperationStatusEnum.Success, "Success");
        return stat;
    }

    @Override
    public OperationStatus stopDiskDataPreparation(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        OperationStatus stat = new OperationStatus();
        stat.set(OperationStatusEnum.Success, "Request sent, refresh Disk page to verify");
        DiskInfo di = this.getDisk(ctx, clusterName, diskGroupName, diskName);
        if (DiskStatusEnum.Preparing.equals((Object)di.getStatus())) {
            DiskOperationDisable operation = new DiskOperationDisable();
            operation.setPrepareData(true);
            OperationStatus modstat = this.modifyDisk(ctx, di, operation, false);
            if (OperationStatusEnum.Success != modstat.getStatus()) {
                return modstat;
            }
        } else {
            stat.set(OperationStatusEnum.Failure, "Disk " + diskName + " is not in data preparation");
        }
        return stat;
    }

    @Override
    public DiskInfo getDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        SMEMessage smeMessage;
        DiskInfo diskInfo = null;
        diskInfo = new DiskInfo();
        diskInfo.setClusterName(clusterName);
        diskInfo.setDiskGroupName(diskGroupName);
        diskInfo.setDiskName(diskName);
        diskInfo.setStatus(null);
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskGetReq(diskInfo, SMEOperationEnum.SME___OP___GET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null && (smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp()) {
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"getDisk - Switch returned failure response.");
                return diskInfo;
            }
            List diskGroupList = smeMessage.getTable_Data().getDiskGroup_Get_Resp().getDisk();
            Iterator it = diskGroupList.iterator();
            if (it.hasNext()) {
                SMEDiskObject diskObject = (SMEDiskObject)it.next();
                SMEDiskIndex index = diskObject.getIndex();
                SMEDiskData data = diskObject.getData();
                diskInfo.setClusterName(index.getCluster_Name());
                diskInfo.setDiskGroupName(index.getDisk_Group_Name());
                diskInfo.setDiskName(index.getDisk_Name());
                DiskVPD vpd = new DiskVPD(index.getDisk_VPD().getVendor_ID(), index.getDisk_VPD().getProduct_ID(), index.getDisk_VPD().getDevice_ID());
                diskInfo.setVpd(vpd);
                diskInfo.setId("" + data.getID());
                diskInfo.setProgress(data.getProgress());
                diskInfo.setPrepareDataTimeLeft(data.getPrepare_Data_Remaining_Time());
                diskInfo.setDataPreparationDescription(data.getDP_Status_Desc());
                diskInfo.setWwn(data.getDisk_Device_ID());
                diskInfo.setStatus(LunStatusMapper.convertStatusToDisk(data.getStatus()));
                diskInfo.setStatusDescription(data.getStatus_Desc());
                if (diskInfo.getStatusDescription() == null || diskInfo.getStatusDescription().length() == 0) {
                    diskInfo.setStatusDescription(diskInfo.getStatus().toString());
                    if (DiskStatusEnum.Preparing.equals((Object)diskInfo.getStatus())) {
                        diskInfo.setStatusDescription(diskInfo.getStatus().toString() + " " + diskInfo.getProgress() + "% Complete");
                    }
                }
                diskInfo.setTotalPaths(data.getTotal_Paths());
                diskInfo.setCapacity(this.mapCapacity(data.getCapacity()));
            }
        }
        return diskInfo;
    }

    @Override
    public OperationStatus verifyDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        SMEMessage smeMessage;
        OperationStatus stat = new OperationStatus();
        stat.set(OperationStatusEnum.Failure, "Disk not verified.");
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskVerifyReq(clusterName, diskGroupName, diskName);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            return stat;
        }
        if (msgIn != null && (smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp()) {
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"verify Disk returned failure response.");
                stat.set(OperationStatusEnum.Failure, smeMessage.getMsg_Header().getResponse_Status_Desc());
            } else {
                stat.set(OperationStatusEnum.Success, smeMessage.getMsg_Header().getResponse_Status_Desc());
            }
        }
        return stat;
    }

    @Override
    public DiskDetailInfo getDiskDetailInfo(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        SMEMessage smeMessage;
        DiskInfo diskInfo = new DiskInfo();
        diskInfo.setClusterName(clusterName);
        diskInfo.setDiskGroupName(diskGroupName);
        diskInfo.setDiskName(diskName);
        DiskDetailInfo ddi = new DiskDetailInfo();
        ddi.setClusterName(diskInfo.getClusterName());
        ddi.setDiskGroupName(diskInfo.getDiskGroupName());
        ddi.setDiskName(diskInfo.getDiskName());
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskGetReq(diskInfo, SMEOperationEnum.SME___OP___GET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null && (smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp()) {
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"getDisk - Switch returned failure response.");
                ddi.setStatus(null);
                return ddi;
            }
            List diskGroupList = smeMessage.getTable_Data().getDiskGroup_Get_Resp().getDisk();
            Iterator it = diskGroupList.iterator();
            if (it.hasNext()) {
                ClusterInfo ci;
                SMEDiskObject diskObject = (SMEDiskObject)it.next();
                SMEDiskIndex index = diskObject.getIndex();
                SMEDiskData data = diskObject.getData();
                ddi.setClusterName(index.getCluster_Name());
                ddi.setDiskGroupName(index.getDisk_Group_Name());
                ddi.setDiskName(index.getDisk_Name());
                DiskVPD vpd = new DiskVPD(index.getDisk_VPD().getVendor_ID(), index.getDisk_VPD().getProduct_ID(), index.getDisk_VPD().getDevice_ID());
                ddi.setVpd(vpd);
                ddi.setId("" + data.getID());
                ddi.setProgress(data.getProgress());
                ddi.setPrepareDataTimeLeft(data.getPrepare_Data_Remaining_Time());
                ddi.setDataPreparationDescription(data.getDP_Status_Desc());
                ddi.setStatus(LunStatusMapper.convertStatusToDisk(data.getStatus()));
                ddi.setStatusDescription(data.getStatus_Desc());
                if (ddi.getStatusDescription() == null || ddi.getStatusDescription().length() == 0) {
                    ddi.setStatusDescription(ddi.getStatus().toString());
                    if (DiskStatusEnum.Preparing.equals((Object)ddi.getStatus())) {
                        ddi.setStatusDescription(ddi.getStatus().toString() + " " + ddi.getProgress() + "% Complete");
                    }
                }
                ddi.setTotalPaths(data.getTotal_Paths());
                ddi.setGUID(data.getGUID());
                ddi.setCapacity(this.mapCapacity(data.getCapacity()));
                ddi.setWwn(data.getDisk_Device_ID());
                if (data.isSetSig_Info() && data.getSig_Info() != null) {
                    DiskSignatureInfo sig = new DiskSignatureInfo();
                    sig.setAlgorithm(EncryptionAlgoMapper.mapTo(data.getSig_Info().getEncrypt_Algo()));
                    sig.setClusterName(data.getSig_Info().getCluster_Name());
                    sig.setCloneGUID(data.getSig_Info().getClone_GUID());
                    sig.setGUID(data.getSig_Info().getGUID());
                    sig.setStatus(LunStatusMapper.convertStatusToDisk(data.getSig_Info().getStatus()));
                    ddi.setSignature(sig);
                }
                if (ClusterTypeEnum.DiskSignature.equals((Object)(ci = this.clusterBean.getClusterInfo(ctx, clusterName)).getType())) {
                    ddi.setSignatureMode(true);
                } else {
                    ddi.setSignatureMode(false);
                }
            }
        }
        ArrayList<DiskPathInfo> dpl = this.getDiskPathInfoList(ctx, clusterName, diskGroupName, diskName);
        ArrayList<PathInfo> pathList = new ArrayList<PathInfo>();
        if (dpl != null) {
            for (DiskPathInfo dpi : dpl) {
                PathInfo pi = dpi.getPath();
                ITNexusMessage itNexusMessage = new ITNexusMessage();
                msgOut = itNexusMessage.prepareITNexusGetReq(ctx, pi, SMEOperationEnum.SME___OP___GET, Limits.MAX_DISK_PATHS_IN_REQUEST);
                msgIn = null;
                try {
                    msgIn = smeXmlHandler.sendReceive(msgOut);
                }
                catch (SMEException se) {
                    _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                    continue;
                }
                if (msgIn == null) continue;
                SMEMessage smeMessage2 = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    List itnexusobjList;
                    if (itNexusMessage.analyzeResponse(smeMessage2) && (itnexusobjList = smeMessage2.getTable_Data().getI_T_Nexus_Get_Resp().getI_T_Nexuses()).size() == 1) {
                        SMEITNexusObject itnobj = (SMEITNexusObject)itnexusobjList.get(0);
                        String intf = itnobj.getData().getInterface().getNode_Name() + "-";
                        intf = intf + itnobj.getData().getInterface().getIf_Index();
                        pi.setSmeInterface(intf);
                        if (itnobj.getData().getLunMap() != null && itnobj.getData().getLunMap().getLun_Entry() != null) {
                            List lunMap = itnobj.getData().getLunMap().getLun_Entry();
                            for (SMELunMapEntry me : lunMap) {
                                String dpStr;
                                if (me == null || me.getLUN_Path() == null || me.getLUN_Path().getLun() == null || me.getLUN_Path().getLun().getDisk_Device_ID() == null || !me.getLUN_Path().getLun().getDisk_Device_ID().equals(ddi.getWwn()) || (dpStr = me.getLUN_Path().getIsDPLunPath()) == null || dpStr.length() <= 0) continue;
                                pi.setDataPreparePath(true);
                            }
                        }
                    }
                }
                catch (SMEException e) {
                    _Logger.warn((Object)("TapeDeviceDetails - problem fetching interface info: " + e.getMessage()));
                }
                pathList.add(pi);
            }
        }
        ddi.setPaths(pathList);
        return ddi;
    }

    @Override
    public ArrayList<DiskInfo> getDiskInfoList(SMEContext ctx, String clusterName, String diskGroupName) {
        ArrayList<DiskInfo> disks = null;
        disks = new ArrayList<DiskInfo>();
        DiskInfo diskInfoLast = new DiskInfo();
        diskInfoLast.setClusterName(clusterName);
        diskInfoLast.setDiskGroupName(diskGroupName);
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = diskGroupMessage.prepareDiskGetReq(diskInfoLast, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_DISKS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"Switch returned failure response.");
                return disks;
            }
            List diskGroupList = smeMessage.getTable_Data().getDiskGroup_Get_Resp().getDisk();
            for (SMEDiskObject diskObject : diskGroupList) {
                SMEDiskIndex index = diskObject.getIndex();
                SMEDiskData data = diskObject.getData();
                DiskInfo diskInfo = new DiskInfo();
                diskInfo.setClusterName(clusterName);
                diskInfo.setDiskGroupName(diskGroupName);
                diskInfo.setClusterName(index.getCluster_Name());
                diskInfo.setDiskGroupName(index.getDisk_Group_Name());
                diskInfo.setDiskName(index.getDisk_Name());
                DiskVPD vpd = new DiskVPD(index.getDisk_VPD().getVendor_ID(), index.getDisk_VPD().getProduct_ID(), index.getDisk_VPD().getDevice_ID());
                diskInfo.setVpd(vpd);
                diskInfo.setId("" + data.getID());
                diskInfo.setProgress(data.getProgress());
                diskInfo.setPrepareDataTimeLeft(data.getPrepare_Data_Remaining_Time());
                diskInfo.setDataPreparationDescription(data.getDP_Status_Desc());
                diskInfo.setStatus(LunStatusMapper.convertStatusToDisk(data.getStatus()));
                diskInfo.setStatusDescription(data.getStatus_Desc());
                if (diskInfo.getStatusDescription() == null || diskInfo.getStatusDescription().length() == 0) {
                    diskInfo.setStatusDescription(diskInfo.getStatus().toString());
                    if (DiskStatusEnum.Preparing.equals((Object)diskInfo.getStatus())) {
                        diskInfo.setStatusDescription(diskInfo.getStatus().toString() + " " + diskInfo.getProgress() + "% Complete");
                    }
                }
                diskInfo.setTotalPaths(data.getTotal_Paths());
                diskInfo.setCapacity(this.mapCapacity(data.getCapacity()));
                diskInfo.setWwn(data.getDisk_Device_ID());
                disks.add(diskInfo);
                diskInfoLast = diskInfo;
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_DISK_GROUPS_IN_REQUEST);
        return disks;
    }

    @Override
    public ArrayList<DiskTreeNode> getDiskTreeNodes(SMEContext ctx, String diskGroupName) {
        ArrayList<DiskTreeNode> disks = new ArrayList<DiskTreeNode>();
        DiskInfo diskInfo = new DiskInfo();
        String clusterName = ctx.getCluster().getClusterName();
        diskInfo.setClusterName(clusterName);
        diskInfo.setDiskGroupName(diskGroupName);
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = diskGroupMessage.prepareDiskListGetReq(diskInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_DISKS_IN_LIST_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                _Logger.warn((Object)"getDiskTreeNodes - Switch returned failure response.");
                return disks;
            }
            SMEDiskList diskList = smeMessage.getTable_Data().getDiskGroup_Get_Resp().getDisk_List();
            List nameList = diskList.getData().getDisk_Name();
            for (String diskName : nameList) {
                if (diskName == null) continue;
                DiskTreeNode diskTreeNode = new DiskTreeNode();
                diskTreeNode.setDiskName(diskName);
                disks.add(diskTreeNode);
                diskInfo.setClusterName(clusterName);
                diskInfo.setDiskGroupName(diskGroupName);
                diskInfo.setDiskName(diskName);
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_DISKS_IN_LIST_REQUEST);
        return disks;
    }

    @Override
    public ArrayList<PathInfo> getCandidatePathsForDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName, ArrayList<ZoneInfo> zoneList) {
        ArrayList<PathInfo> pathList = new ArrayList<PathInfo>();
        ArrayList<VsanInfo> vsanList = new ArrayList<VsanInfo>();
        DiskDetailInfo diskDetail = this.getDiskDetailInfo(ctx, clusterName, diskGroupName, diskName);
        ArrayList<FabricInfo> fabricList = this.modelBean.getFabricsByCluster(ctx, clusterName);
        for (FabricInfo fi : fabricList) {
            ArrayList<VsanInfo> fabvsanList = this.modelBean.getVsansForFabric(ctx, fi);
            for (VsanInfo vi : fabvsanList) {
                if (vsanList.contains(vi)) continue;
                vsanList.add(vi);
            }
        }
        ArrayList<Initiator> initList = this.modelBean.getHostsByVsan(ctx, vsanList, zoneList);
        ArrayList<Target> targetList = this.modelBean.getTargetsZonedforHosts(ctx, initList, 2, zoneList);
        DiskDiscoveryInfo ddInfo = this.pathBean.getPathsByHostandTargetsforDisks(ctx, initList, targetList);
        ArrayList<DiskDetailInfo> diskList = ddInfo.getDiskList();
        for (DiskDetailInfo ddi : diskList) {
            if (ddi.getVpd() == null || !diskDetail.getVpd().equals(ddi.getVpd())) continue;
            ArrayList<PathInfo> allPaths = ddi.getPaths();
            ArrayList<PathInfo> currentPaths = diskDetail.getPaths();
            for (PathInfo pi : allPaths) {
                if (pi.isConfigured() && currentPaths.contains(pi)) continue;
                pathList.add(pi);
            }
        }
        return pathList;
    }

    @Override
    public OperationStatus addDiskPath(SMEContext ctx, DiskPathInfo diskPathInfo) {
        OperationStatus ret = new OperationStatus();
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, diskPathInfo.getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(diskPathInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = diskGroupMessage.prepareDiskPathSetReq(diskPathInfo, SMEOpcodeEnum.CREATE___DISK___PATH);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().isIS_Resp()) {
                ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
            } else {
                ret.setStatus(OperationStatusEnum.Failure);
                ret.setDescription("Failed to add Path to disk: " + diskPathInfo.getDiskName());
            }
        } else {
            ret.setStatus(OperationStatusEnum.Failure);
            ret.setDescription("Failed to add Path to disk: " + diskPathInfo.getDiskName());
        }
        return ret;
    }

    @Override
    public OperationStatus removeDiskPath(SMEContext ctx, DiskPathInfo diskPathInfo) {
        OperationStatus ret;
        block8: {
            ret = new OperationStatus();
            DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, diskPathInfo.getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(diskPathInfo.getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = diskGroupMessage.prepareDiskPathSetReq(diskPathInfo, SMEOpcodeEnum.DELETE___DISK___PATH);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (diskGroupMessage.analyzeResponse(smeMessage)) {
                        ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                        ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                        break block8;
                    }
                    String logMsg = "Failed to delete Path Disk: " + diskPathInfo.getDiskName() + ", Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
                catch (SMEInvalidMessageException se) {
                    String logMsg = "Failed to delete Path Disk: " + diskPathInfo.getDiskName() + ", Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
                catch (SMEException se) {
                    String logMsg = "Failed to delete Path Disk: " + diskPathInfo.getDiskName() + ", Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                }
            } else {
                String logMsg = "Failed to delete Path Path Disk: " + diskPathInfo.getDiskName() + ". Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    @Override
    public ArrayList<DiskPathInfo> getDiskPathInfoList(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        ArrayList<DiskPathInfo> diskPathList = new ArrayList<DiskPathInfo>();
        DiskPathInfo diskPathInfo = new DiskPathInfo();
        diskPathInfo.setClusterName(clusterName);
        diskPathInfo.setDiskGroupName(diskGroupName);
        diskPathInfo.setDiskName(diskName);
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = diskGroupMessage.prepareDiskPathGetReq(diskPathInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_DISK_PATHS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (!smeMessage.getMsg_Header().isIS_Resp()) continue;
            if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) break;
            List respPathList = smeMessage.getTable_Data().getDiskGroup_Get_Resp().getDisk_Path();
            for (SMEDiskPathObject diskPathObject : respPathList) {
                DiskPathInfo diskPath = new DiskPathInfo();
                SMEDiskPathIndex index = diskPathObject.getIndex();
                diskPath.setClusterName(index.getCluster_Name());
                diskPath.setDiskGroupName(index.getDisk_Group_Name());
                diskPath.setDiskName(index.getDisk_Name());
                SMELunPathUserConfig lunPath = index.getPath();
                SMEPath smePath = lunPath.getPath();
                PathInfo path = new PathInfo();
                path.setInitiator(smePath.getInitiator());
                path.setHostName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getInitiator()));
                if (path.getHostName() == null || path.getHostName().length() == 0) {
                    path.setHostName(path.getInitiator());
                }
                path.setTarget(smePath.getTarget());
                path.setTargetName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getTarget()));
                if (path.getTargetName() == null || path.getTargetName().length() == 0) {
                    path.setTargetName(path.getTarget());
                }
                path.setVsanId(smePath.getVSAN());
                path.setFabricName(smePath.getFabric());
                path.setLunId(lunPath.getLun());
                diskPath.setPath(path);
                diskPathList.add(diskPath);
                diskPathInfo.setPath(path);
                ++receivedCount;
            }
        } while (receivedCount == Limits.MAX_DISK_PATHS_IN_REQUEST);
        ITNexusMessage itNexusMessage = new ITNexusMessage();
        for (DiskPathInfo dpi : diskPathList) {
            List itlobjList;
            SMEMessage smeMessage;
            PathInfo pi = dpi.getPath();
            String msgOut = itNexusMessage.prepareITLGetReq(ctx, clusterName, pi, SMEOperationEnum.SME___OP___GET, Limits.MAX_DISK_PATHS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null || !(smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()))).getMsg_Header().isIS_Resp() || (itlobjList = smeMessage.getTable_Data().getI_T_Nexus_Get_Resp().getI_T_Ls()).size() != 1) continue;
            SMEITLObject itlobj = (SMEITLObject)itlobjList.get(0);
            SMEITLStatusEnum statusEnum = itlobj.getData().getLun_Path().getStatus();
            pi.setStatus(PathStatusMapper.mapPathStatusCode(statusEnum));
            pi.setDescription(itlobj.getData().getLun_Path().getStatus_Desc());
            SMELunStatusEnum lunStatusEnum = itlobj.getData().getLun_Path().getLun().getStatus();
            if (pi.getStatus() == null) {
                pi.setStatus(PathStatusMapper.mapPathStatusCode(lunStatusEnum));
            }
            SMEDiskIndex data = itlobj.getData().getLun_Path().getLun().getLUN_Crypto_Info().getDisk_Index();
            DiskVPD vpd = new DiskVPD(data.getDisk_VPD().getVendor_ID(), data.getDisk_VPD().getProduct_ID(), data.getDisk_VPD().getDevice_ID());
            dpi.setVpd(vpd);
            SMELunPathConfigEnum confEnum = itlobj.getData().getLun_Path().getIsConfigured();
            if (SMELunPathConfigEnum.SME___LUN___PATH___CONFIGURED.equals((Object)confEnum)) {
                pi.setConfigured(true);
                continue;
            }
            pi.setConfigured(false);
        }
        return diskPathList;
    }

    @Override
    public byte[] doExport(SMEContext ctx, String clusterId, ArrayList<DiskInfo> diskList, String password) throws SMEException {
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            return ckmcBean.doExport(ctx, clusterId, diskList, password);
        }
        String logMsg = "Export Failed. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
        _Logger.warn((Object)logMsg);
        throw new SMEProcessingException(logMsg);
    }

    @Override
    public byte[] doExportFilter(SMEContext ctx, String clusterId, ArrayList<DiskInfo> diskList, String password, FilterInfo filter) throws SMEException {
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            return ckmcBean.doExportFilter(ctx, clusterId, diskList, password, filter);
        }
        String logMsg = "Export Failed. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
        _Logger.warn((Object)logMsg);
        throw new SMEProcessingException(logMsg);
    }

    @Override
    public OperationStatus doImport(SMEContext ctx, DiskGroupImport importObject, String password) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            DiskGroupInfo destDiskGroup = importObject.getDestDiskGroup();
            ArrayList<DiskInfo> diskList = this.getDiskInfoList(ctx, destDiskGroup.getClusterName(), destDiskGroup.getDiskGroupName());
            ret = ckmcBean.doImport(ctx, importObject, password, diskList);
        } else {
            String logMsg = "Import Failed. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus rekeyDiskGroup(SMEContext ctx, String clusterName, String diskGroupName) {
        OperationStatus ret;
        block13: {
            ret = new OperationStatus();
            if (ctx.getClusterStatus() == ClusterStatusEnum.Offline) {
                ret.setStatus(OperationStatusEnum.Failure);
                ret.setDescription("Failed to rotate keys for Disk Group: switch communication failed.");
                return ret;
            }
            if (ctx.getClusterStatus() == ClusterStatusEnum.Online && ctx.getDiskGroupStatus() == DiskGroupStatusEnum.Ready) {
                DiskGroupInfo diskGroupInfo = this.getDiskGroup(ctx, clusterName, diskGroupName);
                if (diskGroupInfo != null && diskGroupInfo.getStatus() == DiskGroupStatusEnum.Ready) {
                    DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
                    String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
                    SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
                    String msgOut = diskGroupMessage.prepareDiskGroupSetReq(diskGroupInfo, SMEOpcodeEnum.REKEY___DISK___GROUP);
                    String msgIn = null;
                    try {
                        msgIn = smeXmlHandler.sendReceive(msgOut);
                    }
                    catch (SMEException se) {
                        _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                    }
                    if (msgIn != null) {
                        SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                        try {
                            if (diskGroupMessage.analyzeResponse(smeMessage)) {
                                ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                                ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                                break block13;
                            }
                            String logMsg = "Failed to rotate keys for DiskGroup: " + diskGroupInfo.getDiskGroupName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                        }
                        catch (SMEInvalidMessageException se) {
                            String logMsg = "Failed to rotate keys for DiskGroup: " + diskGroupInfo.getDiskGroupName() + ". Error: " + se.getMessage();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusEnum.Failure, logMsg);
                        }
                        catch (SMEException se) {
                            String logMsg = "Failed to rotate keys for DiskGroup: " + diskGroupInfo.getDiskGroupName() + ". Error: " + se.getMessage();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                        }
                    } else {
                        String logMsg = "Failed to rotate keys for DiskGroup: " + diskGroupInfo.getDiskGroupName() + ". Unable to communicate with switch.";
                        _Logger.warn((Object)logMsg);
                        ret.set(OperationStatusEnum.Failure, logMsg);
                    }
                } else {
                    String logMsg = "Rotating keys for deactivated disk group key is not allowed.";
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
            } else {
                String logMsg = "Rotating keys for deactivated disk group key is not allowed.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus rekeyDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        OperationStatus ret;
        block13: {
            ctx.setClusterStatus(ClusterStatusEnum.Online);
            ret = new OperationStatus();
            if (ctx.getClusterStatus() == ClusterStatusEnum.Offline) {
                String logMsg = "Failed to rotate key for Disk: switch communication failed.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
                return ret;
            }
            if (ctx.getClusterStatus() == ClusterStatusEnum.Online) {
                DiskInfo diskInfo = this.getDisk(ctx, clusterName, diskGroupName, diskName);
                if (diskInfo != null && diskInfo.getStatus() == DiskStatusEnum.Crypto) {
                    DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
                    String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
                    SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
                    String msgOut = diskGroupMessage.prepareDiskSetReq(diskInfo, SMEOpcodeEnum.REKEY___DISK, null);
                    String msgIn = null;
                    try {
                        msgIn = smeXmlHandler.sendReceive(msgOut);
                    }
                    catch (SMEException se) {
                        _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                    }
                    if (msgIn != null) {
                        SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
                        try {
                            if (diskGroupMessage.analyzeResponse(smeMessage)) {
                                ret.setStatus(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()));
                                ret.setDescription(smeMessage.getMsg_Header().getResponse_Status_Desc());
                                break block13;
                            }
                            String logMsg = "Failed to rotate keys for DiskGroup: " + diskInfo.getDiskGroupName() + " Disk " + diskInfo.getDiskName() + ". Error: " + smeMessage.getMsg_Header().getResponse_Status_Desc();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                        }
                        catch (SMEInvalidMessageException se) {
                            String logMsg = "Failed to rotate keys for DiskGroup: " + diskInfo.getDiskGroupName() + " Disk " + diskInfo.getDiskName() + ". Error: " + se.getMessage();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusEnum.Failure, logMsg);
                        }
                        catch (SMEException se) {
                            String logMsg = "Failed to rotate keys for DiskGroup: " + diskInfo.getDiskGroupName() + " Disk " + diskInfo.getDiskName() + ". Error: " + se.getMessage();
                            _Logger.warn((Object)logMsg);
                            ret.set(OperationStatusSMEMapper.mapOperationStatusCode(smeMessage.getMsg_Header().getResponse_Status()), logMsg);
                        }
                    } else {
                        String logMsg = "Failed to rotate keys for DiskGroup: " + diskInfo.getDiskGroupName() + " Disk " + diskInfo.getDiskName() + ". Unable to communicate with switch.";
                        _Logger.warn((Object)logMsg);
                        ret.set(OperationStatusEnum.Failure, logMsg);
                    }
                } else {
                    String logMsg = "Rotating key for Disk: disk must be in crypto state.";
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                }
            } else {
                String logMsg = "Failed to rotate key for Disk: cluster must be online.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
            }
        }
        return ret;
    }

    @Override
    public OperationStatus archiveDiskKey(SMEContext ctx, String clusterName, String diskGroupName, String diskName, String guid) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            ret = ckmcBean.archiveDiskKey(ctx, clusterName, diskGroupName, diskName, guid);
        } else {
            String logMsg = "Failed to access KMC server for Cluster " + clusterName;
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus purgeDiskKey(SMEContext ctx, String clusterName, String diskGroupName, String diskName, String guid) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            ret = ckmcBean.purgeDiskKey(ctx, clusterName, diskGroupName, diskName, guid);
        } else {
            String logMsg = "Failed to access KMC server for Cluster " + clusterName;
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public ArrayList<KeyInfo> getDiskKeyList(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            return ckmcBean.getDiskKeyList(ctx, clusterName, diskGroupName, diskName);
        }
        return new ArrayList<KeyInfo>();
    }

    @Override
    public ArrayList<KeyInfo> getDiskGroupDiskKeyList(SMEContext ctx, String clusterName, String diskGroupName) {
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean != null) {
            return ckmcBean.getDiskGroupDiskKeyList(ctx, clusterName, diskGroupName);
        }
        return new ArrayList<KeyInfo>();
    }

    public ArrayList<OperationStatus> diskStatusCheck(SMEContext ctx, String masterKeyGuid) {
        String clusterName = ctx.getCluster().getClusterName();
        String entityIndexWC = clusterName + ":%";
        _Logger.debug((Object)("diskStatusCheck - entry for cluster " + clusterName + " checking disks based on old guid " + masterKeyGuid));
        ArrayList<OperationStatus> statusList = new ArrayList<OperationStatus>();
        return statusList;
    }

    @Override
    public OperationStatus masterKeyRekeyLock(SMEContext ctx, String clusterName) {
        _Logger.warn((Object)("Lock SET request for cluster" + clusterName));
        return this.masterKeyRekeySetLock(ctx, clusterName, true);
    }

    @Override
    public OperationStatus masterKeyRekeyUnLock(SMEContext ctx, String clusterName) {
        _Logger.warn((Object)("Lock CLEAR request for cluster" + clusterName));
        return this.masterKeyRekeySetLock(ctx, clusterName, false);
    }

    private OperationStatus masterKeyRekeySetLock(SMEContext ctx, String clusterName, boolean lock) {
        ClusterInfo clCheck;
        OperationStatus status = new OperationStatus();
        String action = "lock";
        if (!lock) {
            action = "unlock";
        }
        status.set(OperationStatusEnum.Failure, "Failed to " + action + " the KMC for cluster " + clusterName + ".  Verify CKMC connection and try again.");
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean == null) {
            _Logger.warn((Object)status.getDescription());
            return status;
        }
        if (lock && !ClusterLockEnum.None.equals((Object)(clCheck = ckmcBean.getClusterInfo(clusterName)).getLockState())) {
            status.set(OperationStatusEnum.Failure, "Cluster is already locked for an operation.  Refresh page and verify status.");
            _Logger.warn((Object)status.getDescription());
            return status;
        }
        ClusterMessage clusterMessage = new ClusterMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = clusterMessage.prepareUpdateClusterLockSetReq(clusterName, lock);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = clusterMessage.parseSMEClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().isIS_Resp()) {
                if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                    status.set(OperationStatusEnum.Failure, "Cluster " + action + " failed: " + smeMessage.getMsg_Header().getResponse_Status_Desc());
                } else {
                    status.set(OperationStatusEnum.Success, "Cluster " + clusterName + " " + action + "ed.");
                }
            } else {
                status.set(OperationStatusEnum.Failure, "Cluster " + action + " failed due to unknown response.  Please refresh and verify status.");
            }
        } else {
            status.set(OperationStatusEnum.Failure, "Cluster " + action + " failed due to empty response.  Please refresh and verify status.");
        }
        _Logger.warn((Object)status.getDescription());
        if (status.getStatus().equals(OperationStatusEnum.Success)) {
            _Logger.warn((Object)("Lock update for cluster " + clusterName + " succeeded.  Setting local LOCK"));
            ClusterLockEnum lockState = ClusterLockEnum.None;
            if (lock) {
                lockState = ClusterLockEnum.Rekey;
            }
            ckmcBean.setClusterLock(clusterName, lockState);
        }
        return status;
    }

    private OperationStatus rewrapActiveDiskKey(SMEContext ctx, DiskInfo di, String clonedGuid) {
        OperationStatus ret = new OperationStatus();
        ret.set(OperationStatusEnum.Failure, "Unknown error, please try again.");
        String clusterName = di.getClusterName();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean == null) {
            String logMsg = "KMC server access failed for Cluster " + clusterName;
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            return ret;
        }
        KeyInfo ki = ckmcBean.getActiveDiskKey(ctx, clusterName, di.getDiskGroupName(), di.getDiskName());
        if (ki == null) {
            ret.set(OperationStatusEnum.Success, "No active key skipping for disk " + di.getDiskName());
            return ret;
        }
        String currentMkeyGUID = ckmcBean.getCurrentMasterKeyGuid(di);
        if (ki.getWrapByGuid() != null && ki.getWrapByGuid().equals(currentMkeyGUID)) {
            ret.set(OperationStatusEnum.Success, "Active Key for " + di.getDiskName() + " already wrapped by current master key");
            return ret;
        }
        DiskGroupMessage diskGroupMessage = new DiskGroupMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, clusterName);
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(clusterName, masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        DiskOperationReWrap dor = new DiskOperationReWrap();
        dor.setGuid(clonedGuid);
        String msgOut = diskGroupMessage.prepareDiskSetReq(di, SMEOpcodeEnum.UPDATE___DISK___KEY, dor);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = diskGroupMessage.parseSMEDiskGroupResponse(new ByteArrayInputStream(msgIn.getBytes()));
            if (smeMessage.getMsg_Header().isIS_Resp()) {
                if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___SUCCESS) {
                    ret.set(OperationStatusEnum.Failure, "DiskKey rewrap - Switch returned failure response. " + smeMessage.getMsg_Header().getResponse_Status_Desc());
                } else {
                    ret.set(OperationStatusEnum.Success, "DiskKey rewrap succeeded for disk " + di.getDiskName());
                }
            } else {
                ret.set(OperationStatusEnum.Failure, "Disk Key rewrap failed for disk " + di.getDiskName() + " due to unknown response.  Please refresh the disk list and verify status.");
            }
        } else {
            ret.set(OperationStatusEnum.Failure, "Disk Key rewrap failed for disk " + di.getDiskName() + " due to empty response.  Please refresh the disk list and verify status.");
        }
        _Logger.warn((Object)ret.getDescription());
        return ret;
    }

    @Override
    public MasterkeyRekeyInfo masterKeyRekey(SMEContext ctx, String masterKeyGuid) {
        MasterkeyRekeyInfo stateMgr = new MasterkeyRekeyInfo();
        String clusterName = ctx.getCluster().getClusterName();
        String entityIndexWC = clusterName + ":%";
        String currentMasterKeyGuid = null;
        stateMgr = new MasterkeyRekeyInfo();
        stateMgr.setState(MasterkeyRekeyStateEnum.None);
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean == null) {
            String logMsg = "KMC server access failed for Cluster " + clusterName;
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        ClusterInfo cluster = this.clusterBean.getClusterInfo(ctx, clusterName);
        if (cluster != null) {
            currentMasterKeyGuid = cluster.getMasterKeyGuid();
            stateMgr.setNewMasterKeyGUID(currentMasterKeyGuid);
        }
        if (currentMasterKeyGuid == null) {
            String logMsg = "Query of new master key for " + clusterName + "failed";
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        if (masterKeyGuid == null || masterKeyGuid.length() == 0) {
            ArrayList<ClusterSmartcardInfo> cscList = ckmcBean.getClusterSmarcardInfo(clusterName, currentMasterKeyGuid);
            int currentVersion = 0;
            for (ClusterSmartcardInfo csci : cscList) {
                if (!csci.getMasterKeyGUID().equals(currentMasterKeyGuid)) continue;
                currentVersion = Integer.valueOf(csci.getMasterKeyVersion());
            }
            for (ClusterSmartcardInfo csci : cscList) {
                int thisKeyVersion = Integer.valueOf(csci.getMasterKeyVersion());
                if (thisKeyVersion != currentVersion - 1) continue;
                masterKeyGuid = csci.getMasterKeyGUID();
            }
        }
        stateMgr.setOldMasterKeyGUID(masterKeyGuid);
        if (masterKeyGuid == null) {
            String logMsg = "Query of old master key for " + clusterName + "failed.";
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        if (masterKeyGuid.equals(currentMasterKeyGuid)) {
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, "The Old and New MasterKey GUID's are identical!  MasterKey Rekey must have failed.");
            _Logger.warn((Object)ret.getDescription());
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        if (!cluster.getLockState().equals((Object)ClusterLockEnum.None)) {
            _Logger.error((Object)"We should be locked at this point, doesn't seem so.");
        }
        ArrayList<KeyInfo> activeDiskKeyList = ckmcBean.getActiveDiskKeysWrappedByGUID(ctx, entityIndexWC, masterKeyGuid);
        int activeKeys = activeDiskKeyList.size();
        stateMgr.setTotalActiveKeys(activeKeys);
        ArrayList<KeyInfo> allDiskKeyList = ckmcBean.getDiskKeysWrappedByGUID(ctx, entityIndexWC, masterKeyGuid);
        int archivedKeys = allDiskKeyList.size() - activeKeys;
        stateMgr.setTotalArchivedKeys(archivedKeys);
        _Logger.debug((Object)("initial setup returning with count of " + activeKeys + " active and " + archivedKeys + " archived keys"));
        stateMgr.setState(MasterkeyRekeyStateEnum.Initializing);
        return stateMgr;
    }

    @Override
    public MasterkeyRekeyInfo masterKeyRekey(SMEContext ctx, MasterkeyRekeyInfo stateMgr) {
        if (stateMgr == null || MasterkeyRekeyStateEnum.None.equals((Object)stateMgr.getState())) {
            stateMgr = new MasterkeyRekeyInfo();
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, "Failed to initialize object");
            _Logger.error((Object)ret.getDescription());
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setState(MasterkeyRekeyStateEnum.None);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        stateMgr.setErrorFlag(false);
        stateMgr.setErrorStatus(null);
        String clusterName = ctx.getCluster().getClusterName();
        String entityIndexWC = clusterName + ":%";
        String currentMasterKeyGuid = stateMgr.getNewMasterKeyGUID();
        String masterKeyGuid = stateMgr.getOldMasterKeyGUID();
        _Logger.debug((Object)("masterKeyRekey - entry for cluster " + clusterName + " rewrapping from old guid " + masterKeyGuid + " to new guid " + currentMasterKeyGuid));
        long startTime = System.currentTimeMillis();
        _Logger.debug((Object)("masterKeyRekey state: " + (Object)((Object)stateMgr.getState())));
        currentMasterKeyGuid = stateMgr.getNewMasterKeyGUID();
        if (currentMasterKeyGuid == null) {
            String logMsg = "Missing new master key, suggest retry";
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, clusterName);
        if (ckmcBean == null) {
            String logMsg = "KMC server access failed for Cluster " + clusterName;
            OperationStatus ret = new OperationStatus();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            stateMgr.getErrorStatus().add(ret);
            stateMgr.setErrorFlag(true);
            return stateMgr;
        }
        if (MasterkeyRekeyStateEnum.Initializing.equals((Object)stateMgr.getState())) {
            stateMgr.setState(MasterkeyRekeyStateEnum.Active);
        }
        if (MasterkeyRekeyStateEnum.Active.equals((Object)stateMgr.getState())) {
            ArrayList<KeyInfo> activeDiskKeyList = ckmcBean.getActiveDiskKeysWrappedByGUID(ctx, entityIndexWC, masterKeyGuid);
            int activeKeys = activeDiskKeyList.size();
            int activeKeyCount = 0;
            _Logger.debug((Object)("processing " + activeKeys + " active disk keys wrapped by the old guid " + masterKeyGuid));
            for (KeyInfo k : activeDiskKeyList) {
                OperationStatus ret;
                OperationStatus ret2;
                String[] entityIndex = k.getEntityIndex().split(":");
                if (entityIndex == null || entityIndex.length != 6) {
                    OperationStatus ret3 = new OperationStatus();
                    ret3.set(OperationStatusEnum.Failure, "Unrecoverable error processing key " + k.getGuid() + " skipping (bad index)");
                    _Logger.warn((Object)ret3.getDescription());
                    stateMgr.getErrorStatus().add(ret3);
                    stateMgr.setErrorFlag(true);
                    continue;
                }
                String diskClusterName = entityIndex[0];
                String diskGroupName = entityIndex[1];
                String diskName = entityIndex[2];
                if (diskClusterName == null || !diskClusterName.equals(clusterName)) {
                    OperationStatus ret4 = new OperationStatus();
                    ret4.set(OperationStatusEnum.Failure, "Unrecoverable error processing key " + k.getGuid() + " skipping (null or non-matching cluster name)");
                    _Logger.warn((Object)ret4.getDescription());
                    stateMgr.getErrorStatus().add(ret4);
                    stateMgr.setErrorFlag(true);
                    continue;
                }
                boolean bypassActive = false;
                DiskInfo di = this.getDisk(ctx, clusterName, diskGroupName, diskName);
                if (di.getStatus() == null) {
                    ret2 = new OperationStatus();
                    ret2.set(OperationStatusEnum.Failure, "Lookup of disk failed for: " + diskGroupName + " : " + diskName + " attempting to process active key to archived state.");
                    _Logger.warn((Object)ret2.getDescription());
                    stateMgr.getErrorStatus().add(ret2);
                    stateMgr.setErrorFlag(true);
                    bypassActive = true;
                }
                if (DiskStatusEnum.Failure.equals((Object)di.getStatus())) {
                    ret2 = new OperationStatus();
                    ret2.set(OperationStatusEnum.Failure, "Disk in failed state, can't do anything, skipping: " + diskGroupName + " : " + diskName);
                    _Logger.warn((Object)ret2.getDescription());
                    stateMgr.getErrorStatus().add(ret2);
                    stateMgr.setErrorFlag(true);
                    continue;
                }
                KeyInfo imported = ckmcBean.cloneDiskKey(ctx, k, currentMasterKeyGuid);
                if (imported == null) {
                    ret = new OperationStatus();
                    ret.set(OperationStatusEnum.Failure, "Key import failed for " + k.getGuid());
                    _Logger.warn((Object)ret.getDescription());
                    stateMgr.getErrorStatus().add(ret);
                    stateMgr.setErrorFlag(true);
                    continue;
                }
                if (!bypassActive) {
                    ret = this.rewrapActiveDiskKey(ctx, di, imported.getGuid());
                    ckmcBean.purgeDiskKey(ctx, clusterName, diskGroupName, diskName, imported.getGuid());
                    if (!ret.getStatus().equals(OperationStatusEnum.Success)) {
                        _Logger.warn((Object)ret.getDescription());
                        stateMgr.getErrorStatus().add(ret);
                        stateMgr.setErrorFlag(true);
                        continue;
                    }
                }
                _Logger.debug((Object)("Modification complete for: " + diskGroupName + " : " + diskName));
                OperationStatus origPurge = ckmcBean.purgeDiskKey(ctx, clusterName, diskGroupName, diskName, k.getGuid());
                _Logger.debug((Object)("Attempt to purge original key " + k.getGuid() + " returned status: " + origPurge.getStatus() + " - " + origPurge.getDescription()));
                ++activeKeyCount;
                long currentTime = System.currentTimeMillis();
                if (currentTime - startTime <= 10000L) continue;
                _Logger.info((Object)("Processed " + activeKeyCount + " keys this time, returning"));
                stateMgr.setProcessedActiveKeys(stateMgr.getProcessedActiveKeys() + activeKeyCount);
                return stateMgr;
            }
            _Logger.info((Object)"finished with active keys lets return");
            stateMgr.setState(MasterkeyRekeyStateEnum.ActiveComplete);
            return stateMgr;
        }
        if (MasterkeyRekeyStateEnum.ActiveComplete.equals((Object)stateMgr.getState())) {
            stateMgr.setState(MasterkeyRekeyStateEnum.Archived);
        }
        if (MasterkeyRekeyStateEnum.Archived.equals((Object)stateMgr.getState())) {
            stateMgr = ckmcBean.cloneArchivedDiskKeys(ctx, stateMgr);
            return stateMgr;
        }
        OperationStatus ret = new OperationStatus();
        ret.set(OperationStatusEnum.Failure, "Unexpected state.");
        _Logger.warn((Object)ret.getDescription());
        stateMgr.getErrorStatus().add(ret);
        stateMgr.setErrorFlag(true);
        return stateMgr;
    }

    @Override
    public SignatureModeConversionInfo signatureModeConversion(SMEContext ctx, SignatureModeConversionInfo stateMgr) {
        ArrayList<DiskInfo> dList;
        ArrayList<DiskGroupInfo> dgList;
        int fsmUpdateCnt;
        ArrayList<DiskInfo> retryList;
        ClusterInfo ci = this.clusterBean.getClusterInfo(ctx, ctx.getCluster().getClusterName());
        if (stateMgr != null) {
            _Logger.info((Object)"SignatureModeConversion re-entry: sanity check");
            if (!ClusterTypeEnum.DiskSignature.equals((Object)ci.getType())) {
                _Logger.warn((Object)"SignatureModeConversion re-entry: sanity check indicates this is not a signature cluster yet.  resetting state.");
                stateMgr = null;
            } else {
                stateMgr.setErrorFlag(false);
                stateMgr.setErrorStatus(null);
                if (stateMgr.getDiskList() == null || stateMgr.getDiskList().isEmpty()) {
                    _Logger.info((Object)"SignatureModeConversion re-entry: sanity check indicates the disk list is empty.  rechecking");
                    retryList = new ArrayList();
                    fsmUpdateCnt = 0;
                    dgList = this.getDiskGroupInfoList(ctx, ctx.getCluster().getClusterName());
                    for (DiskGroupInfo dgi : dgList) {
                        dList = this.getDiskInfoList(ctx, dgi.getClusterName(), dgi.getDiskGroupName());
                        for (DiskInfo di : dList) {
                            if (di.getStatusDescription() != null && di.getStatusDescription().startsWith("metadata update pending")) {
                                retryList.add(di);
                            }
                            if (di.getStatusDescription() == null || !di.getStatusDescription().startsWith("fsm update pending")) continue;
                            ++fsmUpdateCnt;
                        }
                    }
                    stateMgr.setDiskList(retryList);
                    if (retryList.isEmpty() && fsmUpdateCnt == stateMgr.getFSMCount()) {
                        _Logger.info((Object)"SignatureModeConversion re-entry: sanity check indicates the disk list is still empty. Indicates we must be done.");
                        stateMgr.setState(SignatureModeConversionStateEnum.Complete);
                        stateMgr.setDescription("The conversion process is complete.");
                        stateMgr.setTotal(0);
                        stateMgr.setProcessed(0);
                    } else {
                        stateMgr.setTotal(retryList.size() + fsmUpdateCnt);
                        stateMgr.setProcessed(0);
                    }
                    stateMgr.setFSMCount(fsmUpdateCnt);
                }
                if (!stateMgr.isCopyRsDone()) {
                    _Logger.warn((Object)"SignatureModeConversion re-entry: sanity check indicates copy rs did not complete, retrying.");
                    OperationStatus stat = new OperationStatus();
                    stat = this.clusterBean.saveClusterConfig(ctx, ctx.getCluster().getClusterName());
                    if (!OperationStatusEnum.Success.equals(stat.getStatus())) {
                        stat.setDescription("Unable to save config on one or more nodes.  Perform \"copy r s\" on all nodes manually.");
                        stateMgr.getErrorStatus().add(stat);
                        stateMgr.setErrorFlag(true);
                    } else {
                        stateMgr.setCopyRsDone(true);
                    }
                }
            }
        }
        if (stateMgr == null) {
            _Logger.info((Object)"SignatureModeConversion init");
            stateMgr = new SignatureModeConversionInfo();
            stateMgr.setState(SignatureModeConversionStateEnum.Initializing);
            CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
            if (ckmcBean == null) {
                OperationStatus stat = new OperationStatus();
                stat.set(OperationStatusEnum.Failure, "Unable to reach Key Manager.  Retry or check your network connectivity.");
                stateMgr.getErrorStatus().add(stat);
                stateMgr.setErrorFlag(true);
                stateMgr.setState(SignatureModeConversionStateEnum.Failure);
                _Logger.warn((Object)("SignatureModeConversion issue: " + stat.getDescription()));
                return stateMgr;
            }
            ArrayList<RKCFilterInfo> filterList = new ArrayList<RKCFilterInfo>();
            RKCFilterInfo clusterFilter = new RKCFilterInfo();
            clusterFilter.setType(RKCFilterTypeEnum.Cluster);
            clusterFilter.setValue(ctx.getCluster().getClusterName());
            filterList.add(clusterFilter);
            ArrayList<RKCRelationshipInfo> relationships = ckmcBean.getRKCRelationshipList(filterList);
            boolean foundActive = false;
            for (RKCRelationshipInfo dkr : relationships) {
                if (!RKCRelationshipStatusEnum.Active.equals((Object)dkr.getStatus())) continue;
                foundActive = true;
            }
            if (foundActive) {
                OperationStatus stat = new OperationStatus();
                stat.set(OperationStatusEnum.Failure, "Unable to proceed.  Disable all active Disk Key Replication relationships for this cluster and try again.");
                stateMgr.getErrorStatus().add(stat);
                stateMgr.setErrorFlag(true);
                stateMgr.setState(SignatureModeConversionStateEnum.Failure);
                _Logger.warn((Object)("SignatureModeConversion issue: " + stat.getDescription()));
                return stateMgr;
            }
            ArrayList<DiskGroupInfo> dgList2 = this.getDiskGroupInfoList(ctx, ctx.getCluster().getClusterName());
            stateMgr.setGroupList(dgList2);
            int total = 0;
            for (DiskGroupInfo dgi : dgList2) {
                total += dgi.getTotalDisks();
            }
            stateMgr.setTotal(total);
            OperationStatus stat = new OperationStatus();
            if (!ClusterTypeEnum.DiskSignature.equals((Object)ci.getType()) && !OperationStatusEnum.Success.equals((stat = this.clusterBean.enableClusterDiskMetaDataMode(ctx, ctx.getCluster().getClusterName())).getStatus())) {
                stateMgr.getErrorStatus().add(stat);
                stateMgr.setErrorFlag(true);
                stateMgr.setState(SignatureModeConversionStateEnum.Failure);
                _Logger.warn((Object)("SignatureModeConversion issue: " + stat.getDescription()));
                return stateMgr;
            }
            stat = this.clusterBean.saveClusterConfig(ctx, ctx.getCluster().getClusterName());
            if (!OperationStatusEnum.Success.equals(stat.getStatus())) {
                stat.setDescription("Unable to save config on one or more nodes.  Perform \"copy r s\" on all nodes manually.");
                stateMgr.getErrorStatus().add(stat);
                stateMgr.setErrorFlag(true);
                _Logger.warn((Object)("SignatureModeConversion issue: " + stat.getDescription()));
            } else {
                stateMgr.setCopyRsDone(true);
                _Logger.info((Object)"SignatureModeConversion: copy rs completed successfully.");
            }
            return stateMgr;
        }
        _Logger.info((Object)"SignatureModeConversion re-entry: processing.");
        stateMgr.setState(SignatureModeConversionStateEnum.Active);
        if (stateMgr.getDiskList() == null || stateMgr.getDiskList().isEmpty()) {
            _Logger.info((Object)"SignatureModeConversion re-entry: list is empty, lets recheck switch.");
            retryList = new ArrayList<DiskInfo>();
            fsmUpdateCnt = 0;
            dgList = this.getDiskGroupInfoList(ctx, ctx.getCluster().getClusterName());
            for (DiskGroupInfo dgi : dgList) {
                dList = this.getDiskInfoList(ctx, dgi.getClusterName(), dgi.getDiskGroupName());
                for (DiskInfo di : dList) {
                    if (di.getStatusDescription() != null && di.getStatusDescription().startsWith("metadata update pending")) {
                        retryList.add(di);
                    }
                    if (di.getStatusDescription() == null || !di.getStatusDescription().startsWith("fsm update pending")) continue;
                    ++fsmUpdateCnt;
                }
            }
            if (retryList.isEmpty() && fsmUpdateCnt == stateMgr.getFSMCount()) {
                _Logger.info((Object)"SignatureModeConversion re-entry: switch also says done, lets exit!");
                stateMgr.setState(SignatureModeConversionStateEnum.Complete);
                stateMgr.setDescription("The conversion process is complete.");
                return stateMgr;
            }
            stateMgr.setDiskList(retryList);
            stateMgr.setTotal(retryList.size() + fsmUpdateCnt);
            stateMgr.setProcessed(0);
            stateMgr.setFSMCount(fsmUpdateCnt);
        }
        ArrayList<DiskInfo> failedList = new ArrayList<DiskInfo>();
        for (int cnt = 0; !stateMgr.getDiskList().isEmpty() && cnt < 100; ++cnt) {
            DiskInfo di = stateMgr.getDiskList().remove(0);
            try {
                OperationStatus modStat = this.modifyDisk(ctx, di, new DiskOperationSignature());
                if (!OperationStatusEnum.Success.equals(modStat.getStatus())) {
                    stateMgr.getErrorStatus().add(modStat);
                    if (stateMgr.isErrorFlag()) continue;
                    stateMgr.setDescription("Disk " + di.getDiskName() + " failed the conversion process.");
                    stateMgr.setErrorFlag(true);
                    failedList.add(di);
                    continue;
                }
                stateMgr.incrProcessed();
                continue;
            }
            catch (Exception e) {
                OperationStatus exc = new OperationStatus();
                exc.set(OperationStatusEnum.Failure, "An exception occurred processing a disk see log for details");
                stateMgr.getErrorStatus().add(exc);
                if (!stateMgr.isErrorFlag()) {
                    stateMgr.setDescription("One or more Disk failed the conversion process.");
                    stateMgr.setErrorFlag(true);
                }
                _Logger.error((Object)"Exception during disk conversion", (Throwable)e);
            }
        }
        return stateMgr;
    }

    @Override
    public SignatureModeConversionInfo signatureModeConversionInitRetry(SMEContext ctx) {
        SignatureModeConversionInfo stateMgr = new SignatureModeConversionInfo();
        stateMgr.setState(SignatureModeConversionStateEnum.Active);
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean == null) {
            OperationStatus stat = new OperationStatus();
            stat.set(OperationStatusEnum.Failure, "Unable to reach Key Manager.  Retry or check your network connectivity.");
            stateMgr.getErrorStatus().add(stat);
            stateMgr.setErrorFlag(true);
            stateMgr.setState(SignatureModeConversionStateEnum.Failure);
            return stateMgr;
        }
        ArrayList<RKCFilterInfo> filterList = new ArrayList<RKCFilterInfo>();
        RKCFilterInfo clusterFilter = new RKCFilterInfo();
        clusterFilter.setType(RKCFilterTypeEnum.Cluster);
        clusterFilter.setValue(ctx.getCluster().getClusterName());
        filterList.add(clusterFilter);
        ArrayList<RKCRelationshipInfo> relationships = ckmcBean.getRKCRelationshipList(filterList);
        boolean foundActive = false;
        for (RKCRelationshipInfo dkr : relationships) {
            if (!RKCRelationshipStatusEnum.Active.equals((Object)dkr.getStatus())) continue;
            foundActive = true;
        }
        if (foundActive) {
            OperationStatus stat = new OperationStatus();
            stat.set(OperationStatusEnum.Failure, "Unable to proceed.  Disable all active Disk Key Replication relationships for this cluster and try again.");
            stateMgr.getErrorStatus().add(stat);
            stateMgr.setErrorFlag(true);
            stateMgr.setState(SignatureModeConversionStateEnum.Failure);
            return stateMgr;
        }
        ArrayList<DiskInfo> retryList = new ArrayList<DiskInfo>();
        ArrayList<DiskGroupInfo> dgList = this.getDiskGroupInfoList(ctx, ctx.getCluster().getClusterName());
        for (DiskGroupInfo dgi : dgList) {
            ArrayList<DiskInfo> dList = this.getDiskInfoList(ctx, dgi.getClusterName(), dgi.getDiskGroupName());
            for (DiskInfo di : dList) {
                if (di.getStatusDescription() == null || !di.getStatusDescription().startsWith("metadata update pending")) continue;
                retryList.add(di);
            }
        }
        stateMgr.setDiskList(retryList);
        int total = retryList.size();
        if (total == 0) {
            stateMgr.setState(SignatureModeConversionStateEnum.Complete);
            stateMgr.setDescription("The conversion process is complete.");
            stateMgr.setTotal(0);
            stateMgr.setProcessed(0);
        } else {
            stateMgr.setTotal(total);
            stateMgr.setProcessed(0);
        }
        return stateMgr;
    }

    @Override
    public OperationStatus createReplicationRelationship(SMEContext ctx, DiskInfo source, DiskInfo destination) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            ret = ckmcBean.createReplicationRelationship(ctx, source, destination);
        } else {
            String logMsg = "Failed to create replication relationship. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus deleteReplicationRelationship(SMEContext ctx, DiskInfo source, DiskInfo destination) {
        OperationStatus ret = new OperationStatus();
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            ret = ckmcBean.deleteReplicationRelationship(ctx, source, destination);
        } else {
            String logMsg = "Failed to delete replication relationship. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
        }
        return ret;
    }

    @Override
    public ArrayList<SMEReplicationRelationship> getReplicationRelationships(SMEContext ctx, DiskInfo source) {
        ArrayList<SMEReplicationRelationship> list = null;
        CKMCFacade ckmcBean = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        if (ckmcBean != null) {
            list = ckmcBean.getReplicationRelationships(source);
        } else {
            String logMsg = "Failed to get replication relationship. Failed to access KMC server for Cluster " + ctx.getCluster().getClusterName();
            _Logger.warn((Object)logMsg);
        }
        return list;
    }

    public void sendITNexusClear(SMEContext ctx) {
        this.sendITNexusClear(ctx, null);
    }

    public void sendITNexusClear(SMEContext ctx, ITInfo info) {
        _Logger.debug((Object)"sendITNexusClear - entry");
        ITNexusMessage itNexusMessage = new ITNexusMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = itNexusMessage.prepareITNexusClearReq(ctx, info, SMEOperationEnum.SME___OP___SET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (itNexusMessage.analyzeResponse(smeMessage)) {
                    _Logger.warn((Object)"IT Nexus Clear Successful");
                }
            }
            catch (SMEException se) {
                _Logger.warn((Object)("SMEException during IT Nexus Clear" + se.getMessage()));
            }
        } else {
            _Logger.warn((Object)"Failed to clear ITNexus discovery. Unable to communicate with switch.");
        }
    }

    private String mapCapacity(String capacity) {
        if (capacity == null || capacity.length() == 0) {
            return "";
        }
        String preconv = "0x" + capacity;
        try {
            long blocks = Long.decode(preconv);
            if (blocks <= 2L) {
                return blocks * 512L + "B";
            }
            long kbytes = blocks / 2L;
            if (kbytes < 1024L) {
                return kbytes + "KB";
            }
            long mbytes = kbytes / 1024L;
            if (mbytes < 1024L) {
                return mbytes + "MB";
            }
            long gbytes = mbytes / 1024L;
            if (gbytes < 1024L) {
                return gbytes + "GB";
            }
            long tbytes = gbytes / 1024L;
            return tbytes + "TB";
        }
        catch (NumberFormatException e) {
            return "";
        }
    }
}

