/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ejb.impl;

import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sme.comm.SmeXmlHandler;
import com.cisco.dcbu.sme.common.DiskDetailInfo;
import com.cisco.dcbu.sme.common.DiskVPD;
import com.cisco.dcbu.sme.common.HostDetailInfo;
import com.cisco.dcbu.sme.common.HostInfo;
import com.cisco.dcbu.sme.common.HostMembershipInfo;
import com.cisco.dcbu.sme.common.HostMembershipTypeEnum;
import com.cisco.dcbu.sme.common.ITInfo;
import com.cisco.dcbu.sme.common.Initiator;
import com.cisco.dcbu.sme.common.Limits;
import com.cisco.dcbu.sme.common.PathInfo;
import com.cisco.dcbu.sme.common.PathStatusEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.TapeGroupStatusEnum;
import com.cisco.dcbu.sme.common.TapeInfo;
import com.cisco.dcbu.sme.common.TapeStatusEnum;
import com.cisco.dcbu.sme.common.Target;
import com.cisco.dcbu.sme.common.mapper.LunStatusMapper;
import com.cisco.dcbu.sme.common.mapper.PathStatusMapper;
import com.cisco.dcbu.sme.ejb.api.ClusterMgr;
import com.cisco.dcbu.sme.ejb.api.HostMgr;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.ejb.impl.MgrHelper;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.message.ClusterMessage;
import com.cisco.dcbu.sme.message.ITNexusMessage;
import com.cisco.dcbu.sme.tree.HostTreeNode;
import com.cisco.dcbu.sme.xml.SMEClusterHostIndex;
import com.cisco.dcbu.sme.xml.SMEClusterHostObject;
import com.cisco.dcbu.sme.xml.SMEDiskIndex;
import com.cisco.dcbu.sme.xml.SMEITLStatusEnum;
import com.cisco.dcbu.sme.xml.SMEITNexusObject;
import com.cisco.dcbu.sme.xml.SMELunInfo;
import com.cisco.dcbu.sme.xml.SMELunMapEntry;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMETapeDeviceIndex;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class HostMgrBean
extends MgrHelper
implements Serializable,
HostMgr {
    static Logger _Logger = Logger.getLogger((String)"SME");

    @EJB
    public void setModelBean(ModelMgr modelBean) {
        this.modelBean = modelBean;
    }

    @EJB
    public void setClusterBean(ClusterMgr clusterBean) {
        this.clusterBean = clusterBean;
    }

    public boolean createHost(SMEContext ctx, HostInfo hostInfo) {
        return false;
    }

    @Override
    public ArrayList<HostInfo> getHostInfoList(SMEContext ctx) {
        ArrayList<HostInfo> hosts = new ArrayList<HostInfo>();
        SMEClusterHostIndex hostInfoMarker = new SMEClusterHostIndex();
        hostInfoMarker.setCluster_Name(ctx.getCluster().getClusterName());
        ClusterMessage clusterMessage = new ClusterMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = clusterMessage.prepareClusterHostGetReq(hostInfoMarker, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_CLUSTER_HOSTS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = clusterMessage.parseSMEClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!clusterMessage.analyzeResponse(smeMessage)) break;
                List clusterHostList = smeMessage.getTable_Data().getCluster_Get_Resp().getHost();
                Iterator it = clusterHostList.iterator();
                while (it.hasNext()) {
                    HostInfo hostInfo = new HostInfo();
                    SMEClusterHostObject clusterHostObject = (SMEClusterHostObject)it.next();
                    hostInfo.setClusterName(clusterHostObject.getIndex().getCluster_Name());
                    hosts.add(hostInfo);
                    hostInfoMarker.setCluster_Name(clusterHostObject.getIndex().getCluster_Name());
                    ++receivedCount;
                }
            }
            catch (SMEException e) {
                _Logger.warn((Object)("Exception getHostTreeNodes: " + e.getMessage()));
            }
        } while (receivedCount == Limits.MAX_CLUSTER_HOSTS_IN_REQUEST);
        return hosts;
    }

    @Override
    public ArrayList<HostTreeNode> getHostTreeNodes(SMEContext ctx) {
        String clusterName = ctx.getCluster().getClusterName();
        ArrayList<String> wwnList = new ArrayList<String>();
        SMEClusterHostIndex hostInfo = new SMEClusterHostIndex();
        hostInfo.setCluster_Name(ctx.getCluster().getClusterName());
        ClusterMessage clusterMessage = new ClusterMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        do {
            receivedCount = 0;
            String msgOut = clusterMessage.prepareClusterHostGetReq(hostInfo, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_CLUSTER_HOSTS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = clusterMessage.parseSMEClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!clusterMessage.analyzeResponse(smeMessage)) break;
                List clusterHostList = smeMessage.getTable_Data().getCluster_Get_Resp().getHost();
                for (SMEClusterHostObject clusterHostObject : clusterHostList) {
                    wwnList.add(clusterHostObject.getIndex().getHost_Pwwn());
                    hostInfo.setCluster_Name(clusterHostObject.getIndex().getCluster_Name());
                    hostInfo.setHost_Pwwn(clusterHostObject.getIndex().getHost_Pwwn());
                    ++receivedCount;
                }
            }
            catch (SMEException e) {
                _Logger.warn((Object)("Exception getHostTreeNodes: " + e.getMessage()));
            }
        } while (receivedCount == Limits.MAX_CLUSTER_HOSTS_IN_REQUEST);
        ArrayList<EnclosureBase> hostEnclosureList = this.modelBean.findHostsForCluster(ctx, clusterName);
        ArrayList<HostTreeNode> hosts = new ArrayList<HostTreeNode>();
        Iterator<EnclosureBase> it = hostEnclosureList.iterator();
        while (it.hasNext()) {
            HostTreeNode hostNode = new HostTreeNode();
            EnclosureBase enc = it.next();
            boolean found = false;
            if (enc.getEndPortPKs() != null) {
                for (int i = 0; i < enc.getEndPortPKs().size() && !found; ++i) {
                    String testWwn = SnmpString.toHexString(enc.getEndPortPKs().get((int)i)._wwn.getValue());
                    for (int j = 0; j < wwnList.size(); ++j) {
                        if (testWwn.compareTo((String)wwnList.get(j)) != 0) continue;
                        found = true;
                    }
                }
            }
            if (!found) continue;
            hostNode.setClusterName(clusterName);
            hostNode.setHostName(enc.getEnclosureName());
            hosts.add(hostNode);
        }
        return hosts;
    }

    @Override
    public HostInfo getHostInfo(SMEContext ctx, String hostName) {
        return null;
    }

    @Override
    public HostDetailInfo getHostDetailInfo(SMEContext ctx, String hostName) {
        String clusterName = ctx.getCluster().getClusterName();
        HostDetailInfo info = new HostDetailInfo();
        ArrayList<HostMembershipInfo> membershipList = new ArrayList<HostMembershipInfo>();
        info.setMembershipList(membershipList);
        ArrayList<TapeInfo> tapeInfoList = new ArrayList<TapeInfo>();
        info.setTapeInfoList(tapeInfoList);
        ArrayList<DiskDetailInfo> diskInfoList = new ArrayList<DiskDetailInfo>();
        info.setDiskInfoList(diskInfoList);
        ArrayList<EnclosureBase> hostEnclosureList = this.modelBean.findHostsForCluster(ctx, clusterName);
        EnclosureBase ours = null;
        for (EnclosureBase test : hostEnclosureList) {
            if (hostName.compareTo(test.getEnclosureName()) != 0) continue;
            ours = test;
        }
        if (ours == null) {
            _Logger.warn((Object)"Failed to find device by that name");
            info.setHostName(hostName);
            return info;
        }
        HashSet<HostMembershipInfo> membershipSet = new HashSet<HostMembershipInfo>();
        ITNexusMessage itNexusMessage = new ITNexusMessage();
        int receivedCount = 0;
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        ITInfo marker = null;
        do {
            receivedCount = 0;
            String msgOut = itNexusMessage.prepareITNexusGetReq(ctx, marker, SMEOperationEnum.SME___OP___GET___NEXT, Limits.MAX_I_T_NEXUSES);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            SMEMessage smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!itNexusMessage.analyzeResponse(smeMessage)) break;
                List itlList = smeMessage.getTable_Data().getI_T_Nexus_Get_Resp().getI_T_Nexuses();
                for (SMEITNexusObject itlObject : itlList) {
                    for (int i = 0; i < ours.getEndPortPKs().size(); ++i) {
                        String wwn = SnmpString.toHexString(ours.getEndPortPKs().get((int)i)._wwn.getValue());
                        if (wwn.compareTo(itlObject.getIndex().getI_T_Nexus_Path().getInitiator()) != 0) continue;
                        HostMembershipInfo hmi = new HostMembershipInfo();
                        for (int j = 0; j < itlObject.getData().getLunMap().getLun_Entry().size(); ++j) {
                            ArrayList<PathInfo> paths;
                            if (!((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(j)).getLUN_Path().getLun().isIsConfigured()) continue;
                            SMETapeDeviceIndex tidx = ((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(j)).getLUN_Path().getLun().getLUN_Crypto_Info().getTape_Device_Index();
                            if (tidx != null) {
                                PathInfo path;
                                hmi.setMembership(tidx.getTape_BackupGroup_Name());
                                hmi.setMembershipType(HostMembershipTypeEnum.Tape);
                                hmi.setStatus(TapeGroupStatusEnum.Active);
                                membershipSet.add(hmi);
                                TapeInfo ti = null;
                                for (TapeInfo test : tapeInfoList) {
                                    if (test.getTapeDeviceName().compareTo(tidx.getTape_Device_Name()) != 0) continue;
                                    ti = test;
                                }
                                if (ti == null) {
                                    ti = new TapeInfo();
                                    ti.setStatus(TapeStatusEnum.Offline);
                                    ti.setTapeDeviceName(tidx.getTape_Device_Name());
                                    SMELunInfo sli = ((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(j)).getLUN_Path().getLun();
                                    ti.setDescription(sli.getDescription());
                                    ti.setSerialNumber(sli.getSerial_Number());
                                    paths = new ArrayList();
                                    ti.setPaths(paths);
                                    tapeInfoList.add(ti);
                                }
                                if ((path = this.makePathInfo(ctx, itlObject, j)).getStatus() == PathStatusEnum.Online) {
                                    ti.setStatus(TapeStatusEnum.Online);
                                }
                                ti.getPaths().add(path);
                                continue;
                            }
                            SMEDiskIndex didx = ((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(j)).getLUN_Path().getLun().getLUN_Crypto_Info().getDisk_Index();
                            if (didx == null) {
                                _Logger.warn((Object)"Its neither a disk or tape device");
                                continue;
                            }
                            hmi.setMembership(didx.getDisk_Group_Name());
                            hmi.setMembershipType(HostMembershipTypeEnum.Disk);
                            membershipSet.add(hmi);
                            DiskDetailInfo di = null;
                            for (DiskDetailInfo test : diskInfoList) {
                                if (!test.getDiskName().equals(didx.getDisk_Name()) || !test.getDiskGroupName().equals(didx.getDisk_Group_Name())) continue;
                                di = test;
                            }
                            if (di == null) {
                                di = new DiskDetailInfo();
                                di.setDiskGroupName(didx.getDisk_Group_Name());
                                di.setDiskName(didx.getDisk_Name());
                                if (didx.getDisk_VPD() != null) {
                                    DiskVPD vpd = new DiskVPD(didx.getDisk_VPD().getVendor_ID(), didx.getDisk_VPD().getProduct_ID(), ((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(j)).getLUN_Path().getLun().getDisk_Device_ID());
                                    di.setVpd(vpd);
                                }
                                paths = new ArrayList<PathInfo>();
                                di.setPaths(paths);
                                diskInfoList.add(di);
                                di.setStatus(LunStatusMapper.convertStatusToDisk(((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(j)).getLUN_Path().getLun().getStatus()));
                                di.setStatusDescription(((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(j)).getLUN_Path().getLun().getStatus_Desc());
                            }
                            PathInfo path = this.makePathInfo(ctx, itlObject, j);
                            di.getPaths().add(path);
                        }
                    }
                    if (marker == null) {
                        marker = new ITInfo(new Initiator(), new Target());
                    }
                    marker.getInitiator().setFabricName(itlObject.getIndex().getI_T_Nexus_Path().getFabric());
                    marker.getInitiator().setVsanId(itlObject.getIndex().getI_T_Nexus_Path().getVSAN());
                    marker.getInitiator().setWwn(itlObject.getIndex().getI_T_Nexus_Path().getInitiator());
                    marker.getTarget().setWwn(itlObject.getIndex().getI_T_Nexus_Path().getTarget());
                    ++receivedCount;
                }
            }
            catch (SMEException e) {
                _Logger.warn((Object)("Exception getHostDetailInfo: " + e.getMessage()));
            }
        } while (receivedCount == Limits.MAX_CLUSTER_HOSTS_IN_REQUEST);
        Iterator it = membershipSet.iterator();
        while (it.hasNext()) {
            membershipList.add((HostMembershipInfo)it.next());
        }
        return info;
    }

    private PathInfo makePathInfo(SMEContext ctx, SMEITNexusObject itlObject, int iter) {
        PathInfo path = new PathInfo();
        path.setFabricName(itlObject.getIndex().getI_T_Nexus_Path().getFabric());
        path.setInitiator(itlObject.getIndex().getI_T_Nexus_Path().getInitiator());
        path.setHostName(this.modelBean.getEndPortNameByWwn(ctx, path.getFabricName(), path.getInitiator()));
        path.setTarget(itlObject.getIndex().getI_T_Nexus_Path().getTarget());
        path.setTargetName(this.modelBean.getEndPortNameByWwn(ctx, path.getFabricName(), path.getTarget()));
        path.setVsanId(itlObject.getIndex().getI_T_Nexus_Path().getVSAN());
        path.setLunId(((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(iter)).getID());
        path.setSerialNumber(((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(iter)).getLUN_Path().getLun().getSerial_Number());
        SMEITLStatusEnum status = ((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(iter)).getLUN_Path().getStatus();
        path.setStatus(PathStatusMapper.mapPathStatusCode(status));
        path.setDescription(((SMELunMapEntry)itlObject.getData().getLunMap().getLun_Entry().get(iter)).getLUN_Path().getStatus_Desc());
        return path;
    }
}

