/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ejb.impl;

import com.cisco.dcbu.sm.common.registry.EjbRegistry;
import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.ClusterSourceEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.ejb.api.ClusterMgr;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import org.apache.log4j.Logger;

class MgrHelper {
    static Logger _Logger = Logger.getLogger((String)"SME");
    protected ModelMgr modelBean;
    protected ClusterMgr clusterBean;

    MgrHelper() {
    }

    protected String getSMEClusterMaster(SMEContext ctx, String clusterName) {
        _Logger.debug((Object)"getClusterMaster - entry");
        String switchIP = null;
        ClusterInfo clusterInfo = this.modelBean.getClusterInfo(ctx, clusterName);
        if (clusterInfo != null) {
            switchIP = clusterInfo.getMasterIPAddr();
        } else {
            _Logger.debug((Object)("Cluster " + clusterName + " does not exists in FM model."));
            CKMCFacade ckmcBean = this.getCKMCBean();
            if (ckmcBean != null && (clusterInfo = ckmcBean.getClusterInfo(clusterName)) != null) {
                switchIP = clusterInfo.getMasterIPAddr();
            }
        }
        if (switchIP == null) {
            _Logger.info((Object)("No switch IP address for the cluster" + clusterName + " could be obtained."));
        }
        return switchIP;
    }

    protected CKMCFacade getCKMCBean(String ipAddr) {
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        if (ipAddr == null || ipAddr.length() == 0) {
            return this.getCKMCBean();
        }
        String rmiPort = System.getProperty("server.port", "4447");
        CKMCFacade ckmcBean = this.getCKMCBean(ipAddr, rmiPort, _useSsl);
        return ckmcBean;
    }

    private CKMCFacade getCKMCBean(String ipAddr, String port, boolean _useSsl) {
        try {
            return (CKMCFacade)EjbRegistry.getInstance().getRemoteService(ipAddr, port, _useSsl, "CKMCFacadeBean", CKMCFacade.class.getName());
        }
        catch (Exception e) {
            _Logger.error((Object)("Error looking up Key Manager implementation connecting to " + ipAddr + ":" + port), (Throwable)e);
            return null;
        }
    }

    private CKMCFacade getPrimaryCKMCBean(SMEContext ctx, ClusterInfo clusterInfo) {
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        if (clusterInfo.getPrimaryKeyMgmtServer() == null || clusterInfo.getPrimaryKeyMgmtServer().length() == 0) {
            _Logger.error((Object)("Error looking up Key Manager implementation for cluster " + clusterInfo.getClusterName() + ". Error: Primary KMC address is null/empty"));
            return null;
        }
        CKMCFacade ckmcBean = this.getCKMCBean(clusterInfo.getPrimaryKeyMgmtServer(), "4447", _useSsl);
        if (ckmcBean == null) {
            _Logger.error((Object)("Error looking up Key Manager implementation for cluster " + clusterInfo.getClusterName()));
        }
        return ckmcBean;
    }

    private CKMCFacade getSecondaryCKMCBean(SMEContext ctx, ClusterInfo clusterInfo) {
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        if (clusterInfo.getSecondaryKeyMgmtServer() == null || clusterInfo.getSecondaryKeyMgmtServer().length() == 0) {
            _Logger.error((Object)("Error looking up Key Manager implementation for cluster " + clusterInfo.getClusterName() + ". Error: Secondary KMC address is null/empty"));
            return null;
        }
        CKMCFacade ckmcBean = this.getCKMCBean(clusterInfo.getSecondaryKeyMgmtServer(), "4447", _useSsl);
        if (ckmcBean == null) {
            _Logger.error((Object)("Error looking up Key Manager implementation for cluster " + clusterInfo.getClusterName()));
        }
        return ckmcBean;
    }

    protected CKMCFacade getCKMCBean(SMEContext ctx, ClusterInfo clusterInfo) {
        CKMCFacade ckmc = null;
        if (this.clusterBean == null) {
            this.clusterBean = (ClusterMgr)((Object)this);
        }
        if (clusterInfo == null || clusterInfo.getSource() == ClusterSourceEnum.KMC || clusterInfo.getPrimaryKeyMgmtServer() == null && clusterInfo.getSecondaryKeyMgmtServer() == null) {
            return this.getCKMCBean();
        }
        ckmc = this.getPrimaryCKMCBean(ctx, clusterInfo);
        if (ckmc == null) {
            ckmc = this.getSecondaryCKMCBean(ctx, clusterInfo);
        }
        return ckmc;
    }

    protected CKMCFacade getCKMCBean(SMEContext ctx, String clusterName) {
        ClusterInfo clusterInfo;
        CKMCFacade ckmc = null;
        if (clusterName == null) {
            return this.getCKMCBean();
        }
        if (this.clusterBean == null) {
            this.clusterBean = (ClusterMgr)((Object)this);
        }
        if ((clusterInfo = this.clusterBean.getClusterInfo(ctx, clusterName)) == null || clusterInfo.getSource() == ClusterSourceEnum.KMC || clusterInfo.getPrimaryKeyMgmtServer() == null && clusterInfo.getSecondaryKeyMgmtServer() == null) {
            return this.getCKMCBean();
        }
        ckmc = this.getPrimaryCKMCBean(ctx, clusterInfo);
        if (ckmc == null) {
            ckmc = this.getSecondaryCKMCBean(ctx, clusterInfo);
        }
        return ckmc;
    }

    protected CKMCFacade getCKMCBean() {
        try {
            return EjbRegistry.getInstance().getCKMCFacade();
        }
        catch (Exception e) {
            _Logger.error((Object)("Error looking up Key Manager implementation in MH " + e.getMessage()));
            return null;
        }
    }
}

