/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ejb.impl;

import com.cisco.dcbu.sm.common.rif.SanServiceRif;
import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.comm.SmeXmlHandler;
import com.cisco.dcbu.sme.common.Config;
import com.cisco.dcbu.sme.common.DiskDetailInfo;
import com.cisco.dcbu.sme.common.DiskDiscoveryInfo;
import com.cisco.dcbu.sme.common.DiskInfo;
import com.cisco.dcbu.sme.common.DiskPathDiscoveryInfo;
import com.cisco.dcbu.sme.common.DiskPathInfo;
import com.cisco.dcbu.sme.common.DiskStatusEnum;
import com.cisco.dcbu.sme.common.DiskVPD;
import com.cisco.dcbu.sme.common.ITDiscoveryInfo;
import com.cisco.dcbu.sme.common.ITInfo;
import com.cisco.dcbu.sme.common.Initiator;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.PathInfo;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.TapeDiscoveryInfo;
import com.cisco.dcbu.sme.common.TapeInfo;
import com.cisco.dcbu.sme.common.Target;
import com.cisco.dcbu.sme.common.mapper.PathStatusMapper;
import com.cisco.dcbu.sme.ejb.api.ClusterMgr;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.ejb.api.PathMgr;
import com.cisco.dcbu.sme.ejb.impl.MgrHelper;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.message.ITNexusMessage;
import com.cisco.dcbu.sme.xml.SMEDiskIndex;
import com.cisco.dcbu.sme.xml.SMEDiskVPD;
import com.cisco.dcbu.sme.xml.SMEITLStatusEnum;
import com.cisco.dcbu.sme.xml.SMEITNexusData;
import com.cisco.dcbu.sme.xml.SMEITNexusIndex;
import com.cisco.dcbu.sme.xml.SMEITNexusObject;
import com.cisco.dcbu.sme.xml.SMELunMap;
import com.cisco.dcbu.sme.xml.SMELunMapEntry;
import com.cisco.dcbu.sme.xml.SMELunPathConfigEnum;
import com.cisco.dcbu.sme.xml.SMELunPathInfo;
import com.cisco.dcbu.sme.xml.SMELunStatusEnum;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEPath;
import com.cisco.dcbu.sme.xml.SMEResponseStatusEnum;
import com.cisco.dcbu.sme.xml.SMESCSITypeEnum;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class PathMgrBean
extends MgrHelper
implements Serializable,
PathMgr {
    static Logger _Logger = Logger.getLogger((String)"SME");
    private SanServiceRif sanServiceBean;
    private long sleepTime = 90000L;
    private long diskSleepTime = 120000L;
    private long sleepInterval = 10000L;
    private long diskSleepInterval = 15000L;
    private boolean clearDiscovery = false;

    @EJB
    public void setModelBean(ModelMgr modelBean) {
        this.modelBean = modelBean;
    }

    @EJB
    public void setClusterBean(ClusterMgr clusterBean) {
        this.clusterBean = clusterBean;
    }

    @EJB
    public void setSanServiceBean(SanServiceRif sanServiceBean) {
        this.sanServiceBean = sanServiceBean;
    }

    public PathMgrBean() {
        Config conf = Config.getInstance();
        this.sleepTime = conf.getItNexsusDiscoverySleepTime();
        this.clearDiscovery = conf.isClearDiscovery();
        if (this.sleepTime < this.sleepInterval) {
            _Logger.warn((Object)"PathMgr - sleepTime < sleepInterval - we will never retry path discovery");
        }
    }

    @Override
    public DiskDiscoveryInfo getPathsByHostandTargetsforDisks(SMEContext ctx, ArrayList<Initiator> initiators, ArrayList<Target> targets) {
        ArrayList<DiskDetailInfo> diskList = new ArrayList<DiskDetailInfo>();
        ArrayList<DiskPathDiscoveryInfo> paths = new ArrayList<DiskPathDiscoveryInfo>();
        ArrayList<DiskVPD> vpdList = new ArrayList<DiskVPD>();
        DiskDiscoveryInfo ddi = new DiskDiscoveryInfo();
        ddi.setDiskList(diskList);
        ArrayList<ITDiscoveryInfo> failList = new ArrayList<ITDiscoveryInfo>();
        ddi.setFailedPairs(failList);
        ArrayList<ITInfo> itInfos = new ArrayList<ITInfo>();
        ArrayList<ITInfo> waitingList = new ArrayList<ITInfo>();
        long startTime = System.currentTimeMillis();
        _Logger.debug((Object)"getPathsByHostandTargetsforDisks - entry");
        for (Initiator in : initiators) {
            for (Target tg : targets) {
                if (!in.getFabricName().equals(tg.getFabricName()) || in.getVsanId() != tg.getVsanId()) continue;
                for (int j = 0; j < tg.getZonedInitiatorList().size(); ++j) {
                    if (!tg.getZonedInitiatorList().get(j).equals(in.getWwn())) continue;
                    ITInfo it = new ITInfo(in, tg);
                    itInfos.add(it);
                }
            }
        }
        int itInfosCount = itInfos.size();
        _Logger.info((Object)("Zoning indicates there are " + itInfosCount + " pairs to initiate discovery for."));
        for (int i = 0; i < itInfosCount; ++i) {
            long checkTime = System.currentTimeMillis();
            if (checkTime > startTime + 120000L) {
                _Logger.warn((Object)"Time constrained.  Did not finish init all discovery");
                break;
            }
            ITNexusMessage itNexusMessage = new ITNexusMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = itNexusMessage.prepareITNexusSetReq(ctx, (ITInfo)itInfos.get(i), SMEOpcodeEnum.DISCOVER___I___T___NEXUSES);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (itNexusMessage.analyzeResponse(smeMessage)) {
                        _Logger.warn((Object)"*****Started discovery Successfully...");
                        waitingList.add((ITInfo)itInfos.get(i));
                        continue;
                    }
                    _Logger.warn((Object)"*****Start discovery Failed...");
                }
                catch (SMEException se) {
                    _Logger.warn((Object)("SMEException during ITNexus Discovery Init: " + se.getMessage()));
                    if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___FAILURE) continue;
                    OperationStatus failed = new OperationStatus();
                    failed.set(OperationStatusEnum.Failure, smeMessage.getMsg_Header().getResponse_Status_Desc());
                    ITDiscoveryInfo itd = new ITDiscoveryInfo();
                    itd.setItinfo((ITInfo)itInfos.get(i));
                    itd.setStatus(failed);
                    failList.add(itd);
                }
                continue;
            }
            _Logger.warn((Object)"Failed to initiate ITNexus discovery. Unable to communicate with switch.");
        }
        try {
            Thread.sleep(35000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        long sleptTime = System.currentTimeMillis();
        long finishTime = sleptTime + this.diskSleepTime;
        _Logger.debug((Object)("TIMERDEBUG Init " + sleptTime + " exp finish " + finishTime));
        while (waitingList.size() > 0 && sleptTime < finishTime) {
            _Logger.debug((Object)("TIMERDEBUG loop check " + sleptTime));
            waitingList = this.requestDiskITs(ctx, waitingList, paths);
            long checkTime = System.currentTimeMillis();
            long interval = this.diskSleepInterval - (checkTime - sleptTime);
            _Logger.debug((Object)("TIMERDEBUG Post req " + checkTime + " interval " + interval));
            if (interval > 1000L) {
                _Logger.warn((Object)("Sleeping for an interval, waiting on " + waitingList.size() + " pairs."));
                try {
                    Thread.sleep(interval);
                    _Logger.debug((Object)"TIMERDEBUG woke up");
                }
                catch (InterruptedException e) {
                    _Logger.warn((Object)"sleep timer issue, bailing after next try");
                    e.printStackTrace();
                    sleptTime = finishTime;
                }
            }
            sleptTime = System.currentTimeMillis();
        }
        if (!waitingList.isEmpty()) {
            _Logger.warn((Object)("Ran out of time waiting for " + waitingList.size() + " pairs."));
        }
        ArrayList<DiskPathInfo> dpList = new ArrayList<DiskPathInfo>();
        for (DiskPathDiscoveryInfo dpdi : paths) {
            if (dpdi.getStatus().getStatus().equals(OperationStatusEnum.Success)) {
                dpList.add(dpdi.getPath());
                continue;
            }
            ITDiscoveryInfo itd = new ITDiscoveryInfo();
            itd.setItinfo(dpdi.getItinfo());
            itd.setStatus(dpdi.getStatus());
            failList.add(itd);
        }
        int i = 0;
        int pathCount = dpList.size();
        for (i = 0; i < pathCount; ++i) {
            DiskVPD vpd = ((DiskPathInfo)dpList.get(i)).getVpd();
            if (vpdList.contains(vpd)) continue;
            vpdList.add(vpd);
        }
        i = 0;
        CKMCFacade ckmc = null;
        try {
            ckmc = this.getCKMCBean(ctx, ctx.getCluster().getClusterName());
        }
        catch (Exception e) {
            _Logger.warn((Object)"Exception looking up CKMC in pathMgr.", (Throwable)e);
        }
        for (DiskVPD vpd : vpdList) {
            DiskDetailInfo di = new DiskDetailInfo();
            DiskInfo diCheck = null;
            try {
                if (ckmc != null) {
                    diCheck = ckmc.getDisk(ctx, ctx.getCluster().getClusterName(), vpd.getVendorId(), vpd.getProductId(), vpd.getDeviceId());
                }
            }
            catch (Exception e) {
                _Logger.warn((Object)"Exception looking up disk by VPD in pathMgr.", (Throwable)e);
            }
            if (diCheck != null) {
                di.setDiskName(di.getDiskName());
                di.setStatus(DiskStatusEnum.Archived);
            } else {
                di.setDiskName("Disk" + i++);
            }
            di.setVpd(vpd);
            ArrayList<PathInfo> diskPaths = new ArrayList<PathInfo>();
            for (DiskPathInfo path : dpList) {
                if (!path.getVpd().equals(vpd)) continue;
                diskPaths.add(path.getPath());
                di.setWwn(path.getWwn());
            }
            di.setPaths(diskPaths);
            _Logger.debug((Object)("Adding disk " + di.getDiskName() + " with " + di.getPaths().size() + " paths"));
            diskList.add(di);
        }
        ddi.setWaitListedPairs(waitingList);
        ddi.setFailedPairs(failList);
        ddi.setTotalPairs(itInfos.size());
        ddi.setDiscoveredPairs(itInfos.size() - waitingList.size());
        return ddi;
    }

    private ArrayList<ITInfo> requestDiskITs(SMEContext ctx, ArrayList<ITInfo> waitingList, ArrayList<DiskPathDiscoveryInfo> paths) {
        ArrayList<ITInfo> stillWaiting = new ArrayList<ITInfo>();
        long wrapTime = System.currentTimeMillis() + this.diskSleepInterval;
        long currentTime = System.currentTimeMillis();
        int waitingCount = waitingList.size();
        for (int i = 0; i < waitingCount; ++i) {
            currentTime = System.currentTimeMillis();
            if (currentTime > wrapTime) {
                stillWaiting.add(waitingList.get(i));
                continue;
            }
            ITNexusMessage itNexusMessage = new ITNexusMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = itNexusMessage.prepareITNexusGetReq(ctx, waitingList.get(i), SMEOperationEnum.SME___OP___GET, 1);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (itNexusMessage.analyzeResponse(smeMessage)) {
                        SMELunPathInfo lunPath;
                        _Logger.debug((Object)"*****Get discovery - successful message response...");
                        SMEITNexusObject itNexus = (SMEITNexusObject)smeMessage.getTable_Data().getI_T_Nexus_Get_Resp().getI_T_Nexuses().get(0);
                        SMEITNexusIndex index = itNexus.getIndex();
                        SMEPath smePath = index.getI_T_Nexus_Path();
                        SMEITNexusData data = itNexus.getData();
                        SMELunMap lunMap = data.getLunMap();
                        ArrayList luns = (ArrayList)lunMap.getLun_Entry();
                        if (luns == null || luns.size() == 0) {
                            _Logger.debug((Object)"Empty lun map, adding to retry list.");
                            stillWaiting.add(waitingList.get(i));
                            continue;
                        }
                        boolean retry = true;
                        for (SMELunMapEntry lun : luns) {
                            SMEDiskVPD vpd;
                            lunPath = lun.getLUN_Path();
                            String logStr = "Lun id: " + lun.getID() + " Lun configured: " + lunPath.getLun().isIsConfigured() + " Type: " + lunPath.getLun().getType();
                            if (lunPath.getLun().getType() == SMESCSITypeEnum.DIRECT___ACCESS && (vpd = lunPath.getLun().getLUN_Crypto_Info().getDisk_Index().getDisk_VPD()) != null) {
                                logStr = logStr + " VPD : " + vpd.getVendor_ID() + " / " + vpd.getProduct_ID() + " / " + vpd.getDevice_ID();
                            }
                            logStr = logStr + " Description : " + lunPath.getLun().getDescription() + " Status : " + lunPath.getLun().getStatus();
                            _Logger.info((Object)logStr);
                            if (lunPath.getStatus() != SMEITLStatusEnum.SME___ITL___ONLINE && lunPath.getStatus() != SMEITLStatusEnum.SME___ITL___FAILURE) continue;
                            retry = false;
                            break;
                        }
                        if (retry) {
                            _Logger.debug((Object)"No discovered luns found, adding to retry list.");
                            stillWaiting.add(waitingList.get(i));
                            continue;
                        }
                        _Logger.info((Object)"*****Get discovery IT Success...");
                        _Logger.info((Object)("Initiator: " + smePath.getInitiator() + " Target: " + smePath.getTarget() + " Luns :" + luns.size()));
                        for (SMELunMapEntry lun : luns) {
                            lunPath = lun.getLUN_Path();
                            if (lunPath.getLun().getType().equals((Object)SMESCSITypeEnum.STORAGE___ARRAY___CONTROL)) {
                                _Logger.info((Object)("Storage Array Control detected, Lun id: " + lun.getID() + " skipping to check next"));
                                continue;
                            }
                            if (!lunPath.getLun().getType().equals((Object)SMESCSITypeEnum.DIRECT___ACCESS)) {
                                _Logger.info((Object)("Non Disk, skipping Lun id: " + lun.getID() + " Lun configured: " + lunPath.getLun().isIsConfigured() + " Type: " + lunPath.getLun().getType() + " Description : " + lunPath.getLun().getDescription() + " Status : " + lunPath.getLun().getStatus()));
                            }
                            if (lunPath.getLun().getType() == SMESCSITypeEnum.DIRECT___ACCESS) {
                                if (!lunPath.isSetIsConfigured()) continue;
                                if (lunPath.getIsConfigured() == SMELunPathConfigEnum.SME___LUN___PATH___NOT___CONFIGURED) {
                                    PathInfo path = new PathInfo();
                                    path.setFabricName(smePath.getFabric());
                                    path.setVsanId(smePath.getVSAN());
                                    path.setInitiator(smePath.getInitiator());
                                    path.setHostName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getInitiator()));
                                    path.setHostHBAName(" ");
                                    path.setTarget(smePath.getTarget());
                                    path.setTargetName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getTarget()));
                                    path.setTargetPortName(" ");
                                    path.setLunId(lun.getID());
                                    path.setDescription(lunPath.getLun().getDescription());
                                    path.setStatus(PathStatusMapper.mapPathStatusCode(lunPath.getStatus()));
                                    SMEDiskIndex diskIndex = lun.getLUN_Path().getLun().getLUN_Crypto_Info().getDisk_Index();
                                    String vendor = diskIndex.getDisk_VPD().getVendor_ID();
                                    String product = diskIndex.getDisk_VPD().getProduct_ID();
                                    String device = diskIndex.getDisk_VPD().getDevice_ID();
                                    DiskVPD vpd = new DiskVPD(vendor, product, device);
                                    String wwn = lunPath.getLun().getDisk_Device_ID();
                                    DiskPathInfo dpi = new DiskPathInfo();
                                    dpi.setVpd(vpd);
                                    dpi.setPath(path);
                                    dpi.setWwn(wwn);
                                    DiskPathDiscoveryInfo dpdi = new DiskPathDiscoveryInfo();
                                    OperationStatus done = new OperationStatus();
                                    done.set(OperationStatusEnum.Success, "");
                                    dpdi.setPath(dpi);
                                    dpdi.setStatus(done);
                                    paths.add(dpdi);
                                    continue;
                                }
                                _Logger.info((Object)("Skipping path. Lun Id: " + lun.getID() + " Lun path configured: " + lunPath.getIsConfigured()));
                                continue;
                            }
                            _Logger.info((Object)("Skipping path. Lun Id: " + lun.getID() + " lun type: " + lunPath.getLun().getType()));
                        }
                        continue;
                    }
                    _Logger.warn((Object)"*****Get discovery Failed... empty");
                    stillWaiting.add(waitingList.get(i));
                }
                catch (SMEException se) {
                    _Logger.warn((Object)("SMEException during IT Nexus Get Discovery: " + se.getMessage()));
                    if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___FAILURE) continue;
                    OperationStatus failed = new OperationStatus();
                    failed.set(OperationStatusEnum.Failure, smeMessage.getMsg_Header().getResponse_Status_Desc());
                    DiskPathDiscoveryInfo dpdi = new DiskPathDiscoveryInfo();
                    dpdi.setStatus(failed);
                    dpdi.setItinfo(waitingList.get(i));
                    paths.add(dpdi);
                }
                continue;
            }
            _Logger.warn((Object)"Failed to get ITNexus discovery results. Unable to communicate with switch.");
            stillWaiting.add(waitingList.get(i));
        }
        int retrieved = waitingList.size() - stillWaiting.size();
        _Logger.debug((Object)("Retrieved " + retrieved + " pairs"));
        return stillWaiting;
    }

    @Override
    public TapeDiscoveryInfo getPathsByHostandTargetsforTapeDevices(SMEContext ctx, ArrayList<Initiator> initiators, ArrayList<Target> targets) {
        TapeDiscoveryInfo tdi = new TapeDiscoveryInfo();
        ArrayList<PathInfo> paths = new ArrayList<PathInfo>();
        ArrayList<TapeInfo> tapeDevices = new ArrayList<TapeInfo>();
        HashSet<String> serialNumberList = new HashSet<String>();
        ArrayList<ITDiscoveryInfo> failList = new ArrayList<ITDiscoveryInfo>();
        tdi.setTapeDeviceList(tapeDevices);
        tdi.setFailedPairs(failList);
        ArrayList<ITInfo> itInfos = new ArrayList<ITInfo>();
        ArrayList<ITInfo> waitingList = new ArrayList<ITInfo>();
        _Logger.debug((Object)"getPathsByHostandTargetsforTapeDevices - entry");
        for (Initiator in : initiators) {
            for (Target tg : targets) {
                ITInfo it;
                int j;
                if (in.getFabricName().equals(tg.getFabricName()) && in.getVsanId() == tg.getVsanId()) {
                    for (j = 0; j < tg.getZonedInitiatorList().size(); ++j) {
                        if (!tg.getZonedInitiatorList().get(j).equals(in.getWwn())) continue;
                        it = new ITInfo(in, tg);
                        itInfos.add(it);
                    }
                }
                if (!in.getFabricName().equals(tg.getFabricName()) || in.getVsanId() == tg.getVsanId()) continue;
                for (j = 0; j < tg.getZonedInitiatorList().size(); ++j) {
                    if (!tg.getZonedInitiatorList().get(j).equals(in.getWwn())) continue;
                    it = new ITInfo(in, tg);
                    itInfos.add(it);
                }
            }
        }
        int itInfosCount = itInfos.size();
        for (int i = 0; i < itInfosCount; ++i) {
            ITNexusMessage itNexusMessage = new ITNexusMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = itNexusMessage.prepareITNexusSetReq(ctx, (ITInfo)itInfos.get(i), SMEOpcodeEnum.DISCOVER___I___T___NEXUSES);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (itNexusMessage.analyzeResponse(smeMessage)) {
                        _Logger.warn((Object)"*****Started discovery Successfully...");
                        waitingList.add((ITInfo)itInfos.get(i));
                        continue;
                    }
                    _Logger.warn((Object)"*****Start discovery Failed...");
                }
                catch (SMEException se) {
                    _Logger.warn((Object)("SMEException during ITNexus Discovery Init: " + se.getMessage()));
                    if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___FAILURE) continue;
                    OperationStatus failed = new OperationStatus();
                    failed.set(OperationStatusEnum.Failure, smeMessage.getMsg_Header().getResponse_Status_Desc());
                    ITDiscoveryInfo itd = new ITDiscoveryInfo();
                    itd.setItinfo((ITInfo)itInfos.get(i));
                    itd.setStatus(failed);
                    failList.add(itd);
                }
                continue;
            }
            _Logger.warn((Object)"Failed to initiate ITNexus discovery. Unable to communicate with switch.");
        }
        for (long sleptTime = 0L; waitingList.size() > 0 && sleptTime < this.sleepTime; sleptTime += this.sleepInterval) {
            float seconds = this.sleepInterval / 1000L;
            _Logger.warn((Object)("Sleeping for " + seconds + " seconds, waiting on " + waitingList.size() + " pairs."));
            try {
                Thread.sleep(this.sleepInterval);
            }
            catch (InterruptedException e) {
                _Logger.warn((Object)"sleep timer issue, bailing after next try");
                e.printStackTrace();
                sleptTime = this.sleepTime;
            }
            waitingList = this.requestITs(ctx, waitingList, failList, paths);
        }
        int i = 0;
        int pathCount = paths.size();
        for (i = 0; i < pathCount; ++i) {
            serialNumberList.add(((PathInfo)paths.get(i)).getSerialNumber());
        }
        i = 0;
        for (String sn : serialNumberList) {
            TapeInfo ti = new TapeInfo();
            ArrayList<PathInfo> tapePaths = new ArrayList<PathInfo>();
            for (PathInfo path : paths) {
                if (!path.getSerialNumber().equals(sn)) continue;
                tapePaths.add(path);
            }
            ti.setPaths(tapePaths);
            ti.setSerialNumber(sn);
            ti.setTapeDeviceName("td" + i++);
            _Logger.debug((Object)("Adding tape device " + ti.getTapeDeviceName() + " with " + ti.getPaths().size() + " paths"));
            tapeDevices.add(ti);
        }
        if (this.clearDiscovery) {
            this.sendITNexusClear(ctx);
        }
        Collections.sort(tapeDevices);
        tdi.setWaitListedPairs(waitingList);
        tdi.setTotalPairs(itInfos.size());
        tdi.setDiscoveredPairs(itInfos.size() - waitingList.size());
        return tdi;
    }

    private ArrayList<ITInfo> requestITs(SMEContext ctx, ArrayList<ITInfo> waitingList, ArrayList<ITDiscoveryInfo> failList, ArrayList<PathInfo> paths) {
        ArrayList<ITInfo> stillWaiting = new ArrayList<ITInfo>();
        int waitingCount = waitingList.size();
        for (int i = 0; i < waitingCount; ++i) {
            ITNexusMessage itNexusMessage = new ITNexusMessage();
            String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
            SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
            String msgOut = itNexusMessage.prepareITNexusGetReq(ctx, waitingList.get(i), SMEOperationEnum.SME___OP___GET, 1);
            String msgIn = null;
            try {
                msgIn = smeXmlHandler.sendReceive(msgOut);
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn != null) {
                SMEMessage smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (itNexusMessage.analyzeResponse(smeMessage)) {
                        SMELunPathInfo lunPath;
                        _Logger.debug((Object)"*****Get discovery - successful message response...");
                        SMEITNexusObject itNexus = (SMEITNexusObject)smeMessage.getTable_Data().getI_T_Nexus_Get_Resp().getI_T_Nexuses().get(0);
                        SMEITNexusIndex index = itNexus.getIndex();
                        SMEPath smePath = index.getI_T_Nexus_Path();
                        SMEITNexusData data = itNexus.getData();
                        SMELunMap lunMap = data.getLunMap();
                        ArrayList luns = (ArrayList)lunMap.getLun_Entry();
                        if (luns == null || luns.size() == 0) {
                            _Logger.debug((Object)"Empty lun map, adding to retry list.");
                            stillWaiting.add(waitingList.get(i));
                            continue;
                        }
                        boolean retry = false;
                        for (SMELunMapEntry lun : luns) {
                            lunPath = lun.getLUN_Path();
                            _Logger.info((Object)("Lun id: " + lun.getID() + " Lun configured: " + lunPath.getLun().isIsConfigured() + " Type: " + lunPath.getLun().getType() + " Serial Number: " + lunPath.getLun().getSerial_Number() + " Description : " + lunPath.getLun().getDescription() + " Status : " + lunPath.getLun().getStatus()));
                            if (lunPath.getLun().getStatus() != SMELunStatusEnum.SME___LUN___OFFLINE) continue;
                            retry = true;
                            break;
                        }
                        if (retry) {
                            _Logger.debug((Object)"No discovered luns found, adding to retry list.");
                            stillWaiting.add(waitingList.get(i));
                            continue;
                        }
                        _Logger.info((Object)"*****Get discovery IT Success...");
                        _Logger.info((Object)("Initiator: " + smePath.getInitiator() + " Target: " + smePath.getTarget() + " Luns :" + luns.size()));
                        for (SMELunMapEntry lun : luns) {
                            lunPath = lun.getLUN_Path();
                            _Logger.info((Object)("Lun id: " + lun.getID() + " Lun configured: " + lunPath.getLun().isIsConfigured() + " Type: " + lunPath.getLun().getType() + " Serial Number: " + lunPath.getLun().getSerial_Number() + " Description : " + lunPath.getLun().getDescription() + " Status : " + lunPath.getLun().getStatus()));
                            if (lunPath.getLun().getType() == SMESCSITypeEnum.SEQUENTIAL) {
                                PathInfo path;
                                if (lunPath.isSetIsConfigured()) {
                                    if (lunPath.getIsConfigured() == SMELunPathConfigEnum.SME___LUN___PATH___NOT___CONFIGURED) {
                                        path = new PathInfo();
                                        path.setFabricName(smePath.getFabric());
                                        path.setVsanId(smePath.getVSAN());
                                        path.setInitiator(smePath.getInitiator());
                                        path.setHostName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getInitiator()));
                                        path.setHostHBAName(" ");
                                        path.setTarget(smePath.getTarget());
                                        path.setTargetName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getTarget()));
                                        path.setTargetPortName(" ");
                                        path.setLunId(lun.getID());
                                        path.setDescription(lunPath.getLun().getDescription());
                                        path.setSerialNumber(lunPath.getLun().getSerial_Number());
                                        path.setStatus(PathStatusMapper.mapPathStatusCode(lunPath.getStatus()));
                                        paths.add(path);
                                        continue;
                                    }
                                    _Logger.info((Object)("Skipping path. Lun Id: " + lun.getID() + " Lun path configured: " + lunPath.getIsConfigured()));
                                    continue;
                                }
                                if (!lunPath.getLun().isIsConfigured()) {
                                    path = new PathInfo();
                                    path.setFabricName(smePath.getFabric());
                                    path.setVsanId(smePath.getVSAN());
                                    path.setInitiator(smePath.getInitiator());
                                    path.setHostName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getInitiator()));
                                    path.setHostHBAName(" ");
                                    path.setTarget(smePath.getTarget());
                                    path.setTargetName(this.modelBean.getEndPortNameByWwn(ctx, smePath.getFabric(), smePath.getTarget()));
                                    path.setTargetPortName(" ");
                                    path.setLunId(lun.getID());
                                    path.setDescription(lunPath.getLun().getDescription());
                                    path.setSerialNumber(lunPath.getLun().getSerial_Number());
                                    path.setStatus(PathStatusMapper.mapPathStatusCode(lunPath.getStatus()));
                                    paths.add(path);
                                    continue;
                                }
                                _Logger.info((Object)("Skipping path. Lun Id: " + lun.getID() + " Lun configured: " + lunPath.getLun().isIsConfigured()));
                                continue;
                            }
                            _Logger.info((Object)("Skipping path. Lun Id: " + lun.getID() + " lun type: " + lunPath.getLun().getType()));
                        }
                        continue;
                    }
                    _Logger.warn((Object)"*****Get discovery Failed... empty");
                    stillWaiting.add(waitingList.get(i));
                }
                catch (SMEException se) {
                    _Logger.warn((Object)("SMEException during IT Nexus Get Discovery: " + se.getMessage()));
                    if (smeMessage.getMsg_Header().getResponse_Status() != SMEResponseStatusEnum.SME___FAILURE) continue;
                    OperationStatus failed = new OperationStatus();
                    failed.set(OperationStatusEnum.Failure, smeMessage.getMsg_Header().getResponse_Status_Desc());
                    ITDiscoveryInfo itd = new ITDiscoveryInfo();
                    itd.setItinfo(waitingList.get(i));
                    itd.setStatus(failed);
                    failList.add(itd);
                }
                continue;
            }
            _Logger.warn((Object)"Failed to get ITNexus discovery results. Unable to communicate with switch.");
            stillWaiting.add(waitingList.get(i));
        }
        int retrieved = waitingList.size() - stillWaiting.size();
        _Logger.debug((Object)("Retrieved " + retrieved + " pairs"));
        return stillWaiting;
    }

    @Override
    public void sendITNexusClear(SMEContext ctx) {
        this.sendITNexusClear(ctx, null);
    }

    public void sendITNexusClear(SMEContext ctx, ITInfo info) {
        _Logger.debug((Object)"sendITNexusClear - entry");
        ITNexusMessage itNexusMessage = new ITNexusMessage();
        String masterSwitchIP = this.getSMEClusterMaster(ctx, ctx.getCluster().getClusterName());
        SmeXmlHandler smeXmlHandler = new SmeXmlHandler(ctx.getCluster().getClusterName(), masterSwitchIP, ctx.getUserName(), ctx.getPassword());
        String msgOut = itNexusMessage.prepareITNexusClearReq(ctx, info, SMEOperationEnum.SME___OP___SET, 1);
        String msgIn = null;
        try {
            msgIn = smeXmlHandler.sendReceive(msgOut);
        }
        catch (SMEException se) {
            _Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
        }
        if (msgIn != null) {
            SMEMessage smeMessage = itNexusMessage.parseSMEITNexusResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (itNexusMessage.analyzeResponse(smeMessage)) {
                    _Logger.warn((Object)"IT Nexus Clear Successful");
                }
            }
            catch (SMEException se) {
                _Logger.warn((Object)("SMEException during IT Nexus Clear" + se.getMessage()));
            }
        } else {
            _Logger.warn((Object)"Failed to clear ITNexus discovery. Unable to communicate with switch.");
        }
    }
}

