/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.message;

import com.cisco.dcbu.sme.message.SMEMessageBase;
import com.cisco.dcbu.sme.replication.SMEReplicationContext;
import com.cisco.dcbu.sme.replication.SMEReplicationRelationship;
import com.cisco.dcbu.sme.xml.SMECKMCExportReplicatedKeyReq;
import com.cisco.dcbu.sme.xml.SMECKMCImportReplicatedKeyReq;
import com.cisco.dcbu.sme.xml.SMECKMCMsgHeader;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextData;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextGetReq;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextIndex;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextObject;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextSetReq;
import com.cisco.dcbu.sme.xml.SMEKey;
import com.cisco.dcbu.sme.xml.SMEKeyEntity;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEMessageRSACert;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMETableData;
import com.cisco.dcbu.sme.xml.SMETableEnum;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupIndex;
import com.cisco.dcbu.sme.xml.SMETapeVolumeIndex;
import java.io.InputStream;

public class CKMCMessage
extends SMEMessageBase {
    public String prepareCKMCMessage(SMEMessage smeMessage) {
        return this.buildSmeMessage(smeMessage);
    }

    public SMEMessage parseCKMCMessage(InputStream msg) {
        return this.parseSmeMessage(msg);
    }

    public String prepareReplicationContextGetReq(String clusterName, String sender_cookie) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.KEY___OBJECT___TABLE, SMEOpcodeEnum.GET___REPLICATION___CONTEXT));
        SMECKMCMsgHeader ckmcHdr = new SMECKMCMsgHeader();
        ckmcHdr.setSender_Cookie(sender_cookie);
        smeMessage.setCKMC_Msg_Header(ckmcHdr);
        SMETableData tableData = new SMETableData();
        SMECKMCReplicationContextGetReq repCtxGetReq = new SMECKMCReplicationContextGetReq();
        SMECKMCReplicationContextIndex index = new SMECKMCReplicationContextIndex();
        index.setCluster_Name(clusterName);
        repCtxGetReq.setIndex(index);
        tableData.setCKMC_Replication_Context_Get_Req(repCtxGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDeleteReplicationContextSetReq(String clusterName, String id, String sender_cookie) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.KEY___OBJECT___TABLE, SMEOpcodeEnum.DELETE___REPLICATION___CONTEXT));
        SMECKMCMsgHeader ckmcHdr = new SMECKMCMsgHeader();
        ckmcHdr.setSender_Cookie(sender_cookie);
        smeMessage.setCKMC_Msg_Header(ckmcHdr);
        SMETableData tableData = new SMETableData();
        SMECKMCReplicationContextSetReq repCtxSetReq = new SMECKMCReplicationContextSetReq();
        SMECKMCReplicationContextIndex index = new SMECKMCReplicationContextIndex();
        index.setCluster_Name(clusterName);
        index.setID(id);
        repCtxSetReq.setIndex(index);
        tableData.setCKMC_Replication_Context_Set_Req(repCtxSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " id " + index.getID()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareCreateReplicationContextSetReq(String clusterName, String sender_cookie) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.CREATE___REPLICATION___CONTEXT));
        SMECKMCMsgHeader ckmcHdr = new SMECKMCMsgHeader();
        ckmcHdr.setSender_Cookie(sender_cookie);
        smeMessage.setCKMC_Msg_Header(ckmcHdr);
        SMETableData tableData = new SMETableData();
        SMECKMCReplicationContextSetReq repCtxSetReq = new SMECKMCReplicationContextSetReq();
        SMECKMCReplicationContextIndex index = new SMECKMCReplicationContextIndex();
        index.setCluster_Name(clusterName);
        repCtxSetReq.setIndex(index);
        tableData.setCKMC_Replication_Context_Set_Req(repCtxSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " id " + index.getID()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareExportReplicatedKeySetReq(SMEReplicationContext replicationCtx, SMEReplicationRelationship relation, SMEKey key, SMEKey wrapKey, String sender_cookie) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.KEY___OBJECT___TABLE, SMEOpcodeEnum.EXPORT___TRANSLATED___KEY));
        SMECKMCMsgHeader ckmcHdr = new SMECKMCMsgHeader();
        ckmcHdr.setSender_Cookie(sender_cookie);
        smeMessage.setCKMC_Msg_Header(ckmcHdr);
        SMETableData tableData = new SMETableData();
        SMECKMCExportReplicatedKeyReq exportReplicatedKeySetReq = new SMECKMCExportReplicatedKeyReq();
        SMECKMCReplicationContextObject repContext = new SMECKMCReplicationContextObject();
        SMECKMCReplicationContextIndex ctxIndex = new SMECKMCReplicationContextIndex();
        ctxIndex.setCluster_Name(replicationCtx.getClusterName());
        ctxIndex.setID(replicationCtx.getContextindex());
        SMECKMCReplicationContextData ctxData = new SMECKMCReplicationContextData();
        SMEMessageRSACert cert = new SMEMessageRSACert();
        cert.setValid(true);
        cert.setCert(replicationCtx.getPubkey());
        cert.setLength(Integer.valueOf(cert.getCert().length()));
        ctxData.setCert(cert);
        repContext.setIndex(ctxIndex);
        repContext.setData(ctxData);
        exportReplicatedKeySetReq.setCluster_Name(key.getIndex().getCluster_Name());
        exportReplicatedKeySetReq.setContext(repContext);
        exportReplicatedKeySetReq.setGUID(key.getIndex().getGUID());
        exportReplicatedKeySetReq.setKey_Object(key);
        exportReplicatedKeySetReq.setWrap_Key_Object(wrapKey);
        tableData.setCKMC_Export_Replicated_Key_Req(exportReplicatedKeySetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + exportReplicatedKeySetReq.getCluster_Name() + " guid " + exportReplicatedKeySetReq.getGUID() + " for destination cluster" + relation.getDestClusterName() + " tape group " + relation.getDestTapeGroupName() + " tape volume group " + relation.getDestTapeVolumeGroupName()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareImportReplicatedKeySetReq(SMEReplicationContext replicationCtx, SMEReplicationRelationship relation, SMEKey key, SMEKey wrapKey, String sender_cookie) {
        SMETapeVolumeGroupIndex index;
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.KEY___OBJECT___TABLE, SMEOpcodeEnum.IMPORT___TRANSLATED___KEY));
        SMECKMCMsgHeader ckmcHdr = new SMECKMCMsgHeader();
        ckmcHdr.setSender_Cookie(sender_cookie);
        smeMessage.setCKMC_Msg_Header(ckmcHdr);
        SMETableData tableData = new SMETableData();
        SMECKMCImportReplicatedKeyReq importReplicatedKeySetReq = new SMECKMCImportReplicatedKeyReq();
        SMEKeyEntity destination = new SMEKeyEntity();
        switch (key.getData().getKey_Type()) {
            case KEY___TYPE___TAPE___VOLUMEGROUP___SHARED___KEY: {
                index = new SMETapeVolumeGroupIndex();
                index.setCluster_Name(relation.getDestClusterName());
                index.setTape_BackupGroup_Name(relation.getDestTapeGroupName());
                index.setTape_VolumeGroup_Name(relation.getDestTapeVolumeGroupName());
                destination.setTape_Volume_Group_Shared_Key(index);
                break;
            }
            case KEY___TYPE___TAPE___VOLUMEGROUP___WRAP___KEY: {
                index = new SMETapeVolumeGroupIndex();
                index.setCluster_Name(relation.getDestClusterName());
                index.setTape_BackupGroup_Name(relation.getDestTapeGroupName());
                index.setTape_VolumeGroup_Name(relation.getDestTapeVolumeGroupName());
                destination.setTape_Volume_Group_Wrap_Key(index);
                break;
            }
            case KEY___TYPE___TAPE___VOLUME___KEY: {
                index = new SMETapeVolumeIndex();
                index.setCluster_Name(relation.getDestClusterName());
                index.setTape_BackupGroup_Name(relation.getDestTapeGroupName());
                index.setTape_VolumeGroup_Name(relation.getDestTapeVolumeGroupName());
                index.setBarcode(key.getData().getKey_Entity().getTape_Volume_Key().getBarcode());
                destination.setTape_Volume_Key((SMETapeVolumeIndex)index);
                break;
            }
        }
        index = new SMECKMCReplicationContextIndex();
        index.setCluster_Name(replicationCtx.getClusterName());
        index.setID(replicationCtx.getContextindex());
        importReplicatedKeySetReq.setCluster_Name(relation.getDestClusterName());
        importReplicatedKeySetReq.setDestination_Key_Entity(destination);
        importReplicatedKeySetReq.setGUID(key.getIndex().getGUID());
        importReplicatedKeySetReq.setContext((SMECKMCReplicationContextIndex)index);
        importReplicatedKeySetReq.setKey_Object(key);
        importReplicatedKeySetReq.setWrap_Key_Object(wrapKey);
        tableData.setCKMC_Import_Replicated_Key_Req(importReplicatedKeySetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + importReplicatedKeySetReq.getCluster_Name() + " guid " + importReplicatedKeySetReq.getGUID() + " from source cluster" + relation.getSourceClusterName() + " tape group " + relation.getSourceTapeGroupName() + " tape volume group " + relation.getSourceTapeVolumeGroupName()));
        return this.buildSmeMessage(smeMessage);
    }
}

