/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.message;

import com.cisco.dcbu.sme.common.ClusterBasicModeMasterKeyFile;
import com.cisco.dcbu.sme.common.ClusterBasicModeOfficerInfo;
import com.cisco.dcbu.sme.common.ClusterConfigEnum;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.ClusterNodeInfo;
import com.cisco.dcbu.sme.common.ClusterRecoveryOfficerInfo;
import com.cisco.dcbu.sme.common.ClusterTypeEnum;
import com.cisco.dcbu.sme.common.Config;
import com.cisco.dcbu.sme.common.InterfaceInfo;
import com.cisco.dcbu.sme.common.mapper.ClusterConfigSMEMapper;
import com.cisco.dcbu.sme.common.mapper.ClusterSecurityModeSMEMapper;
import com.cisco.dcbu.sme.message.SMEMessageBase;
import com.cisco.dcbu.sme.xml.SMECKMC;
import com.cisco.dcbu.sme.xml.SMEClusterCapabilityEnum;
import com.cisco.dcbu.sme.xml.SMEClusterData;
import com.cisco.dcbu.sme.xml.SMEClusterFabricIndex;
import com.cisco.dcbu.sme.xml.SMEClusterFabricObject;
import com.cisco.dcbu.sme.xml.SMEClusterGetReq;
import com.cisco.dcbu.sme.xml.SMEClusterHostIndex;
import com.cisco.dcbu.sme.xml.SMEClusterIndex;
import com.cisco.dcbu.sme.xml.SMEClusterInterfaceData;
import com.cisco.dcbu.sme.xml.SMEClusterInterfaceIndex;
import com.cisco.dcbu.sme.xml.SMEClusterInterfaceObject;
import com.cisco.dcbu.sme.xml.SMEClusterMasterKeyFile;
import com.cisco.dcbu.sme.xml.SMEClusterNodeData;
import com.cisco.dcbu.sme.xml.SMEClusterNodeIndex;
import com.cisco.dcbu.sme.xml.SMEClusterNodeObject;
import com.cisco.dcbu.sme.xml.SMEClusterObject;
import com.cisco.dcbu.sme.xml.SMEClusterRecoveryData;
import com.cisco.dcbu.sme.xml.SMEClusterRecoveryIndex;
import com.cisco.dcbu.sme.xml.SMEClusterRecoveryObject;
import com.cisco.dcbu.sme.xml.SMEClusterRecoveryOfficerSignatureObject;
import com.cisco.dcbu.sme.xml.SMEClusterReplaceSmartcardAbortReq;
import com.cisco.dcbu.sme.xml.SMEClusterReplaceSmartcardCommitReq;
import com.cisco.dcbu.sme.xml.SMEClusterReplaceSmartcardGetTransactionReq;
import com.cisco.dcbu.sme.xml.SMEClusterReplaceSmartcardReq;
import com.cisco.dcbu.sme.xml.SMEClusterReplaceSmartcardSetReq;
import com.cisco.dcbu.sme.xml.SMEClusterReplaceSmartcardStartReq;
import com.cisco.dcbu.sme.xml.SMEClusterSetReq;
import com.cisco.dcbu.sme.xml.SMEClusterTapeCfgEnum;
import com.cisco.dcbu.sme.xml.SMEClusterTransportSecurityData;
import com.cisco.dcbu.sme.xml.SMEClusterTransportSecurityIndex;
import com.cisco.dcbu.sme.xml.SMEClusterTransportSecurityObject;
import com.cisco.dcbu.sme.xml.SMEDigitalSignature;
import com.cisco.dcbu.sme.xml.SMEDiskMetadataModeEnum;
import com.cisco.dcbu.sme.xml.SMEGlobalGetReq;
import com.cisco.dcbu.sme.xml.SMEInterfaceIndex;
import com.cisco.dcbu.sme.xml.SMEMasterKeyInfo;
import com.cisco.dcbu.sme.xml.SMEMasterRekeyProcessEnum;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEMessageRSACert;
import com.cisco.dcbu.sme.xml.SMEMsgAuthAlgoEnum;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEPasswordContext;
import com.cisco.dcbu.sme.xml.SMERecoveryOfficerBasicIdentity;
import com.cisco.dcbu.sme.xml.SMERecoveryOfficerIdentity;
import com.cisco.dcbu.sme.xml.SMERecoveryOfficerSCIdentity;
import com.cisco.dcbu.sme.xml.SMEReplaceSmartcardTypeEnum;
import com.cisco.dcbu.sme.xml.SMETableData;
import com.cisco.dcbu.sme.xml.SMETableEnum;
import com.cisco.dcbu.sme.xml.SMETransportSecurityGetReq;
import com.cisco.dcbu.sme.xml.SMETransportSecuritySetReq;
import com.cisco.dcbu.sme.xml.SMEUserIndex;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ClusterMessage
extends SMEMessageBase {
    static Logger _Logger = Logger.getLogger((String)"SME");

    public String prepareCreateClusterSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.CREATE___CLUSTER));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        object.setIndex(index);
        SMEClusterData data = new SMEClusterData();
        SMECKMC primaryCKMCServer = new SMECKMC();
        primaryCKMCServer.setName(clusterInfo.getPKMS());
        SMEMessageRSACert pRSACert = new SMEMessageRSACert();
        if (clusterInfo.getPrimaryKeyMgmtServerRSACert() != null) {
            pRSACert.setValid(true);
            pRSACert.setLength(Integer.valueOf(clusterInfo.getPrimaryKeyMgmtServerRSACert().length()));
            pRSACert.setCert(clusterInfo.getPrimaryKeyMgmtServerRSACert());
        }
        primaryCKMCServer.setSME_RSA_Cert(pRSACert);
        data.setPrimary_CKMC_Server(primaryCKMCServer);
        SMECKMC secondaryCKMCServer = new SMECKMC();
        secondaryCKMCServer.setName(clusterInfo.getSecondaryKeyMgmtServer());
        SMEMessageRSACert sRSACert = new SMEMessageRSACert();
        if (clusterInfo.getSecondaryKeyMgmtServerRSACert() != null) {
            sRSACert.setValid(true);
            sRSACert.setLength(Integer.valueOf(clusterInfo.getSecondaryKeyMgmtServerRSACert().length()));
            sRSACert.setCert(clusterInfo.getSecondaryKeyMgmtServerRSACert());
        }
        secondaryCKMCServer.setSME_RSA_Cert(sRSACert);
        data.setSecondary_CKMC_Server(secondaryCKMCServer);
        data.setPSK(clusterInfo.getPsk());
        if (clusterInfo.getType().equals((Object)ClusterTypeEnum.Disk) || clusterInfo.getType().equals((Object)ClusterTypeEnum.DiskSignature)) {
            data.setCluster_Capability(SMEClusterCapabilityEnum.SME___CLUSTER___CAPABILITY___DISK);
        } else {
            data.setCluster_Capability(SMEClusterCapabilityEnum.SME___CLUSTER___CAPABILITY___TAPE);
        }
        data.setRecovery_Scheme_Threshold(Integer.valueOf(clusterInfo.getRecoverySchemeThreshold()));
        data.setRecovery_Scheme_Total(Integer.valueOf(clusterInfo.getRecoverySchemeTotal()));
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterFabricSetReq(String clusterName, String fabricName) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___FABRIC));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterFabricObject object = new SMEClusterFabricObject();
        SMEClusterFabricIndex index = new SMEClusterFabricIndex();
        index.setCluster_Name(clusterName);
        index.setFabric(fabricName);
        object.setIndex(index);
        clusterSetReq.setFabric(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " fabric: " + index.getFabric()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterNodeSetReq(ClusterNodeInfo clusterNodeInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___NODE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterNodeObject object = new SMEClusterNodeObject();
        SMEClusterNodeIndex index = new SMEClusterNodeIndex();
        index.setCluster_Name(clusterNodeInfo.getClusterName());
        index.setNode_Name(clusterNodeInfo.getSwitchInfo().getSwitchName());
        object.setIndex(index);
        SMEClusterNodeData data = new SMEClusterNodeData();
        data.setFabric(clusterNodeInfo.getSwitchInfo().getFabricName());
        data.setIs_Master(clusterNodeInfo.getSwitchInfo().isMaster());
        data.setIs_Member_Local(clusterNodeInfo.getSwitchInfo().isMemberLocal());
        object.setData(data);
        clusterSetReq.setNode(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterNodeFabricSetReq(ClusterNodeInfo clusterNodeInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___NODE___FABRIC));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterNodeObject object = new SMEClusterNodeObject();
        SMEClusterNodeIndex index = new SMEClusterNodeIndex();
        index.setCluster_Name(clusterNodeInfo.getClusterName());
        index.setNode_Name(clusterNodeInfo.getSwitchInfo().getSwitchName());
        object.setIndex(index);
        SMEClusterNodeData data = new SMEClusterNodeData();
        data.setFabric(clusterNodeInfo.getSwitchInfo().getFabricName());
        object.setData(data);
        clusterSetReq.setNode(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name() + " fabric: " + data.getFabric()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterInterfaceSetReq(InterfaceInfo clusterInterfaceInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___INTERFACE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterInterfaceObject object = new SMEClusterInterfaceObject();
        SMEClusterInterfaceIndex index = new SMEClusterInterfaceIndex();
        index.setCluster_Name(clusterInterfaceInfo.getClusterName());
        index.setNode_Name(clusterInterfaceInfo.getSwitchInfo().getSwitchName());
        index.setIf_Index(clusterInterfaceInfo.getInterfaceId());
        object.setIndex(index);
        SMEClusterInterfaceData data = new SMEClusterInterfaceData();
        data.setIs_Master(clusterInterfaceInfo.getSwitchInfo().isMaster());
        data.setIs_Member_Local(clusterInterfaceInfo.getSwitchInfo().isMemberLocal());
        data.setForce(true);
        object.setData(data);
        clusterSetReq.setInterface(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name() + " interface: " + index.getIf_Index()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterPSKSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___TRANSPORT___PSK));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterTransportSecurityObject object = new SMEClusterTransportSecurityObject();
        SMEClusterTransportSecurityIndex index = new SMEClusterTransportSecurityIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterTransportSecurityData data = new SMEClusterTransportSecurityData();
        data.setPSK(clusterInfo.getPsk());
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setPSK(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterSharedKeyModeSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___SHARED___KEYMODE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        if (clusterInfo.getUniqueKeyPerMedia() == ClusterConfigEnum.Yes) {
            data.setShared_Keymode(SMEClusterTapeCfgEnum.SME___CFG___NOT___ENABLED);
        } else if (clusterInfo.getUniqueKeyPerMedia() == ClusterConfigEnum.No) {
            data.setShared_Keymode(SMEClusterTapeCfgEnum.SME___CFG___ENABLED);
        } else {
            data.setShared_Keymode(SMEClusterTapeCfgEnum.SME___CFG___NOT___SET);
        }
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " key mode: " + data.getShared_Keymode()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterKeyOnTapeModeSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___KEY___ONTAPE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        data.setKey_Ontape(ClusterConfigSMEMapper.mapClusterConfig(clusterInfo.getKeyOnTape()));
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " key on tape: " + data.getKey_Ontape()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterAutoVolumeGroupModeSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___AUTO___VOLUME___GROUP));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        data.setAuto_Volume_Group(ClusterConfigSMEMapper.mapClusterConfig(clusterInfo.getAutoVolumeGrouping()));
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " auto volume group: " + data.getAuto_Volume_Group()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterTapeCompressionModeSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___TAPE___COMPRESSION));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        data.setTape_Compression(ClusterConfigSMEMapper.mapClusterConfig(clusterInfo.getCompression()));
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tape compression: " + data.getTape_Compression()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterTapeRecycleModeSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___TAPE___KEYRECYCLE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        data.setTape_Keyrecycle(ClusterConfigSMEMapper.mapClusterConfig(clusterInfo.getTapeRecycle()));
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " tape key recycle: " + data.getTape_Keyrecycle()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterSecurityModeSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___SME___SECURITY___MODE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        data.setSecurity_Mode(ClusterSecurityModeSMEMapper.mapOperationStatusCode(clusterInfo.getMode()));
        data.setRecovery_Scheme_Threshold(Integer.valueOf(clusterInfo.getRecoverySchemeThreshold()));
        data.setRecovery_Scheme_Total(Integer.valueOf(clusterInfo.getRecoverySchemeTotal()));
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " security mode: " + data.getSecurity_Mode()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterPrimaryCKMCSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___PRIMARY___CKMC));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        SMECKMC primaryCKMCServer = new SMECKMC();
        primaryCKMCServer.setName(clusterInfo.getPrimaryKeyMgmtServer());
        primaryCKMCServer.setPort_Number(Integer.valueOf(Config.getInstance().getKmcPort()));
        primaryCKMCServer.setSSL_Port_Number(Integer.valueOf(Config.getInstance().getKmcSSLPort()));
        SMEMessageRSACert pRSACert = new SMEMessageRSACert();
        if (clusterInfo.getPrimaryKeyMgmtServerRSACert() != null) {
            pRSACert.setValid(true);
            pRSACert.setLength(Integer.valueOf(clusterInfo.getPrimaryKeyMgmtServerRSACert().length()));
            pRSACert.setCert(clusterInfo.getPrimaryKeyMgmtServerRSACert());
        }
        primaryCKMCServer.setSME_RSA_Cert(pRSACert);
        data.setPrimary_CKMC_Server(primaryCKMCServer);
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " primary KMC: " + data.getPrimary_CKMC_Server().getName() + " port: " + data.getPrimary_CKMC_Server().getPort_Number() + " secure port: " + data.getPrimary_CKMC_Server().getSSL_Port_Number()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterDiskSupportSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___CAPABILITY));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        data.setCluster_Capability(SMEClusterCapabilityEnum.SME___CLUSTER___CAPABILITY___DISK);
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " disk support: " + data.getCluster_Capability().toString()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterDiskMetaDataModeSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___DISK___METADATA___MODE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        if (clusterInfo.getType().equals((Object)ClusterTypeEnum.DiskSignature)) {
            data.setDisk_Metadata_Mode(SMEDiskMetadataModeEnum.SME___CLUSTER___DISK___METADATA);
        } else {
            data.setDisk_Metadata_Mode(SMEDiskMetadataModeEnum.SME___CLUSTER___DISK___NO___METADATA);
        }
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " metadata mode: " + data.getDisk_Metadata_Mode().toString()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterSecondayCKMCSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___SECONDARY___CKMC));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        SMECKMC secondaryCKMCServer = new SMECKMC();
        secondaryCKMCServer.setName(clusterInfo.getSecondaryKeyMgmtServer());
        secondaryCKMCServer.setPort_Number(Integer.valueOf(Config.getInstance().getKmcPort()));
        secondaryCKMCServer.setSSL_Port_Number(Integer.valueOf(Config.getInstance().getKmcSSLPort()));
        SMEMessageRSACert sRSACert = new SMEMessageRSACert();
        if (clusterInfo.getSecondaryKeyMgmtServerRSACert() != null) {
            sRSACert.setValid(true);
            sRSACert.setLength(Integer.valueOf(clusterInfo.getSecondaryKeyMgmtServerRSACert().length()));
            sRSACert.setCert(clusterInfo.getSecondaryKeyMgmtServerRSACert());
        }
        secondaryCKMCServer.setSME_RSA_Cert(sRSACert);
        data.setSecondary_CKMC_Server(secondaryCKMCServer);
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " secondary KMC: " + data.getSecondary_CKMC_Server().getName() + " port: " + data.getSecondary_CKMC_Server().getPort_Number()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterCKMCPairSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___CKMC___PAIR));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        SMEClusterData data = new SMEClusterData();
        SMECKMC primaryCKMCServer = new SMECKMC();
        primaryCKMCServer.setName(clusterInfo.getPKMS());
        primaryCKMCServer.setPort_Number(Integer.valueOf(Config.getInstance().getKmcPort()));
        primaryCKMCServer.setSSL_Port_Number(Integer.valueOf(Config.getInstance().getKmcSSLPort()));
        SMEMessageRSACert pRSACert = new SMEMessageRSACert();
        if (clusterInfo.getPrimaryKeyMgmtServerRSACert() != null) {
            pRSACert.setValid(true);
            pRSACert.setLength(Integer.valueOf(clusterInfo.getPrimaryKeyMgmtServerRSACert().length()));
            pRSACert.setCert(clusterInfo.getPrimaryKeyMgmtServerRSACert());
        }
        primaryCKMCServer.setSME_RSA_Cert(pRSACert);
        SMECKMC secondaryCKMCServer = new SMECKMC();
        secondaryCKMCServer.setName(clusterInfo.getSecondaryKeyMgmtServer());
        secondaryCKMCServer.setPort_Number(Integer.valueOf(Config.getInstance().getKmcPort()));
        secondaryCKMCServer.setSSL_Port_Number(Integer.valueOf(Config.getInstance().getKmcSSLPort()));
        SMEMessageRSACert sRSACert = new SMEMessageRSACert();
        if (clusterInfo.getSecondaryKeyMgmtServerRSACert() != null) {
            sRSACert.setValid(true);
            sRSACert.setLength(Integer.valueOf(clusterInfo.getSecondaryKeyMgmtServerRSACert().length()));
            sRSACert.setCert(clusterInfo.getSecondaryKeyMgmtServerRSACert());
        }
        secondaryCKMCServer.setSME_RSA_Cert(sRSACert);
        data.setPrimary_CKMC_Server(primaryCKMCServer);
        data.setSecondary_CKMC_Server(secondaryCKMCServer);
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " primary KMC: " + data.getPrimary_CKMC_Server().getName() + " port: " + data.getPrimary_CKMC_Server().getPort_Number() + " secure port: " + data.getPrimary_CKMC_Server().getSSL_Port_Number()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateClusterLockSetReq(String clusterName, boolean lock) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.MASTER___REKEY___PROCESS));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterName);
        object.setIndex(index);
        SMEClusterData data = new SMEClusterData();
        if (lock) {
            data.setMaster_Rekey_Process(SMEMasterRekeyProcessEnum.SME___MASTER___REKEY___PROCESS___BEGIN);
        } else {
            data.setMaster_Rekey_Process(SMEMasterRekeyProcessEnum.SME___MASTER___REKEY___PROCESS___END);
        }
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDeleteClusterSetReq(ClusterInfo clusterInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.DELETE___CLUSTER));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        object.setIndex(index);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDeleteClusterFabricSetReq(String clusterName, String fabricName) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.DELETE___CLUSTER___FABRIC));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterFabricObject object = new SMEClusterFabricObject();
        SMEClusterFabricIndex index = new SMEClusterFabricIndex();
        index.setCluster_Name(clusterName);
        index.setFabric(fabricName);
        object.setIndex(index);
        clusterSetReq.setFabric(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " fabric: " + index.getFabric()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDeleteClusterNodeSetReq(ClusterNodeInfo clusterNodeInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.DELETE___CLUSTER___NODE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterNodeObject object = new SMEClusterNodeObject();
        SMEClusterNodeIndex index = new SMEClusterNodeIndex();
        index.setCluster_Name(clusterNodeInfo.getClusterName());
        index.setNode_Name(clusterNodeInfo.getSwitchInfo().getSwitchName());
        object.setIndex(index);
        clusterSetReq.setNode(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDeleteClusterNodeFabricSetReq(ClusterNodeInfo clusterNodeInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.DELETE___CLUSTER___NODE___FABRIC));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterNodeObject object = new SMEClusterNodeObject();
        SMEClusterNodeIndex index = new SMEClusterNodeIndex();
        index.setCluster_Name(clusterNodeInfo.getClusterName());
        index.setNode_Name(clusterNodeInfo.getSwitchInfo().getSwitchName());
        SMEClusterNodeData data = new SMEClusterNodeData();
        data.setFabric(clusterNodeInfo.getSwitchInfo().getFabricName());
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setNode(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name() + " fabric: " + data.getFabric()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDeleteClusterInterfaceSetReq(InterfaceInfo interfaceInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.DELETE___CLUSTER___INTERFACE));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterInterfaceObject object = new SMEClusterInterfaceObject();
        SMEClusterInterfaceIndex index = new SMEClusterInterfaceIndex();
        index.setCluster_Name(interfaceInfo.getClusterName());
        index.setNode_Name(interfaceInfo.getSwitchInfo().getSwitchName());
        index.setIf_Index(interfaceInfo.getInterfaceId());
        object.setIndex(index);
        SMEClusterInterfaceData data = new SMEClusterInterfaceData();
        object.setData(data);
        clusterSetReq.setInterface(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name() + " interface: " + index.getIf_Index()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareClusterGetReq(ClusterInfo clusterInfo, SMEOperationEnum operation) {
        return this.prepareClusterGetReq(clusterInfo, operation, 1);
    }

    public String prepareClusterGetReq(ClusterInfo clusterInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        if (operation.equals((Object)SMEOperationEnum.SME___OP___GET)) {
            smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER));
        } else if (operation.equals((Object)SMEOperationEnum.SME___OP___GET___NEXT)) {
            smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER, count));
        }
        SMETableData tableData = new SMETableData();
        SMEClusterGetReq clusterGetReq = new SMEClusterGetReq();
        SMEClusterIndex index = new SMEClusterIndex();
        index.setCluster_Name(clusterInfo.getClusterName());
        clusterGetReq.setIndex(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareClusterNodeGetReq(ClusterNodeInfo clusterNode, SMEOperationEnum operation) {
        return this.prepareClusterNodeGetReq(clusterNode, operation, 1);
    }

    public String prepareClusterNodeGetReq(ClusterNodeInfo clusterNode, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        if (operation.equals((Object)SMEOperationEnum.SME___OP___GET)) {
            smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER___NODE));
        } else if (operation.equals((Object)SMEOperationEnum.SME___OP___GET___NEXT)) {
            smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER___NODE, count));
        }
        SMETableData tableData = new SMETableData();
        SMEClusterGetReq clusterGetReq = new SMEClusterGetReq();
        SMEClusterNodeIndex index = new SMEClusterNodeIndex();
        index.setCluster_Name(clusterNode.getClusterName());
        index.setNode_Name(clusterNode.getSwitchInfo().getSwitchName());
        clusterGetReq.setNode_Index(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareClusterInterfaceGetReq(InterfaceInfo interfaceInfo, SMEOperationEnum operation) {
        return this.prepareClusterInterfaceGetReq(interfaceInfo, operation, 1);
    }

    public String prepareClusterInterfaceGetReq(InterfaceInfo interfaceInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        if (operation.equals((Object)SMEOperationEnum.SME___OP___GET)) {
            smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER___INTERFACE));
        } else if (operation.equals((Object)SMEOperationEnum.SME___OP___GET___NEXT)) {
            smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER___INTERFACE, count));
        }
        SMETableData tableData = new SMETableData();
        SMEClusterGetReq clusterGetReq = new SMEClusterGetReq();
        SMEClusterInterfaceIndex index = new SMEClusterInterfaceIndex();
        index.setCluster_Name(interfaceInfo.getClusterName());
        if (interfaceInfo.getSwitchInfo() != null) {
            index.setNode_Name(interfaceInfo.getSwitchInfo().getSwitchName());
        }
        if (interfaceInfo.getInterfaceId() != null) {
            index.setIf_Index(interfaceInfo.getInterfaceId());
        }
        clusterGetReq.setInterface_Index(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name() + " interface: " + index.getIf_Index()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareClusterHostGetReq(SMEClusterHostIndex hostInfo, SMEOperationEnum operation) {
        return this.prepareClusterHostGetReq(hostInfo, operation, 1);
    }

    public String prepareClusterHostGetReq(SMEClusterHostIndex hostInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        if (operation.equals((Object)SMEOperationEnum.SME___OP___GET)) {
            smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER___HOST));
        } else if (operation.equals((Object)SMEOperationEnum.SME___OP___GET___NEXT)) {
            smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER___HOST, count));
        }
        SMETableData tableData = new SMETableData();
        SMEClusterGetReq clusterGetReq = new SMEClusterGetReq();
        SMEClusterHostIndex index = new SMEClusterHostIndex();
        index.setCluster_Name(hostInfo.getCluster_Name());
        index.setHost_Pwwn(hostInfo.getHost_Pwwn());
        clusterGetReq.setHost_Index(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " host pwwn: " + index.getHost_Pwwn()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareGetRecoveryShareGetReq(ClusterRecoveryOfficerInfo clusterRecoveryOfficerInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER___RECOVERY___SHARE));
        SMETableData tableData = new SMETableData();
        SMEClusterGetReq clusterGetReq = new SMEClusterGetReq();
        SMEClusterRecoveryIndex index = new SMEClusterRecoveryIndex();
        index.setCluster_Name(clusterRecoveryOfficerInfo.getClusterName());
        index.setShare_Index(Integer.valueOf(clusterRecoveryOfficerInfo.getShareIndex()));
        clusterGetReq.setRecovery_Share_Index(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " share: " + index.getShare_Index()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareGetRecoveryShareGetReq(ClusterBasicModeOfficerInfo officerInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.GET___CLUSTER___RECOVERY___SHARE));
        SMETableData tableData = new SMETableData();
        SMEClusterGetReq clusterGetReq = new SMEClusterGetReq();
        SMEClusterRecoveryIndex index = new SMEClusterRecoveryIndex();
        index.setCluster_Name(officerInfo.getClusterName());
        index.setShare_Index(Integer.valueOf(1));
        clusterGetReq.setRecovery_Share_Index(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " share: " + index.getShare_Index()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateRecoveryOfficerSetReq(ClusterRecoveryOfficerInfo clusterRecoveryOfficerInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___RECOVERY___OFFICER));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterRecoveryIndex index = new SMEClusterRecoveryIndex();
        index.setCluster_Name(clusterRecoveryOfficerInfo.getClusterName());
        index.setShare_Index(Integer.valueOf(clusterRecoveryOfficerInfo.getShareIndex()));
        SMERecoveryOfficerIdentity roId = new SMERecoveryOfficerIdentity();
        SMERecoveryOfficerSCIdentity roSCId = new SMERecoveryOfficerSCIdentity();
        roSCId.setLabel(clusterRecoveryOfficerInfo.getSmartcardLabel());
        roSCId.setSmartcard_Serial_Number(clusterRecoveryOfficerInfo.getSmartcardSerialNumber());
        SMEMessageRSACert sRSACert = new SMEMessageRSACert();
        sRSACert.setValid(true);
        String cert = clusterRecoveryOfficerInfo.getSmartcardRSACert().replaceAll("\r\n", "\n");
        sRSACert.setLength(Integer.valueOf(cert.length()));
        sRSACert.setCert(cert);
        roSCId.setSME_RSA_Cert(sRSACert);
        roId.setSC_Identity(roSCId);
        SMEClusterRecoveryData data = new SMEClusterRecoveryData();
        data.setValid(true);
        data.setRecovery_Officer_Id(roId);
        SMEClusterRecoveryObject object = new SMEClusterRecoveryObject();
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setRecovery_Officer(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " share: " + index.getShare_Index() + " label: " + data.getRecovery_Officer_Id().getSC_Identity().getLabel() + " serial number: " + data.getRecovery_Officer_Id().getSC_Identity().getSmartcard_Serial_Number()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUpdateRecoveryOfficerSetReq(ClusterBasicModeOfficerInfo officerInfo) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, SMEOpcodeEnum.UPDATE___CLUSTER___RECOVERY___OFFICER));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterRecoveryIndex index = new SMEClusterRecoveryIndex();
        index.setCluster_Name(officerInfo.getClusterName());
        index.setShare_Index(Integer.valueOf(1));
        SMERecoveryOfficerIdentity roId = new SMERecoveryOfficerIdentity();
        SMERecoveryOfficerBasicIdentity roBasicId = new SMERecoveryOfficerBasicIdentity();
        roBasicId.setLabel(officerInfo.getUserName());
        SMEPasswordContext passwordCtx = new SMEPasswordContext();
        passwordCtx.setPassword(officerInfo.getFilePassword());
        passwordCtx.setPassword_Label(officerInfo.getUserName());
        roBasicId.setPassword_Context(passwordCtx);
        roId.setBasic_Identity(roBasicId);
        SMEClusterRecoveryData data = new SMEClusterRecoveryData();
        data.setValid(true);
        data.setRecovery_Officer_Id(roId);
        SMEClusterRecoveryObject object = new SMEClusterRecoveryObject();
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setRecovery_Officer(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " share: " + index.getShare_Index() + " user: " + data.getRecovery_Officer_Id().getBasic_Identity().getLabel()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareMasterKeyFile(ClusterBasicModeMasterKeyFile masterKeyFile) {
        SMEClusterMasterKeyFile smeMasterKeyFile = new SMEClusterMasterKeyFile();
        SMERecoveryOfficerBasicIdentity basicIdentity = new SMERecoveryOfficerBasicIdentity();
        basicIdentity.setLabel(masterKeyFile.getLabel());
        SMEPasswordContext passwordCtx = new SMEPasswordContext();
        passwordCtx.setPassword_Label(masterKeyFile.getPasswordLabel());
        basicIdentity.setPassword_Context(passwordCtx);
        SMEMasterKeyInfo smeMasterKeyInfo = new SMEMasterKeyInfo();
        smeMasterKeyInfo.setCluster_Name(masterKeyFile.getClusterName());
        smeMasterKeyInfo.setMaster_Key_GUID(masterKeyFile.getMasterKeyGUID());
        smeMasterKeyInfo.setMaster_Key_Version(masterKeyFile.getMasterKeyVersion());
        smeMasterKeyInfo.setData(masterKeyFile.getData());
        smeMasterKeyFile.setBasic_Identity(basicIdentity);
        smeMasterKeyFile.setMaster_Key_Info(smeMasterKeyInfo);
        return this.buildMasterKeyFile(smeMasterKeyFile);
    }

    public String prepareReplaceSmartCardStartReq(String clusterName, int shareIndex) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.REPLACE___SMARTCARD___TABLE, SMEOpcodeEnum.REPLACE___SMARTCARD___INITIATE));
        SMETableData tableData = new SMETableData();
        SMEClusterReplaceSmartcardReq replaceSmartcardReq = new SMEClusterReplaceSmartcardReq();
        SMEClusterReplaceSmartcardStartReq startReq = new SMEClusterReplaceSmartcardStartReq();
        replaceSmartcardReq.setReplace_Smartcard_Start_Req(startReq);
        startReq.setCluster_Name(clusterName);
        startReq.setShare_Index(Integer.valueOf(shareIndex));
        startReq.setType(SMEReplaceSmartcardTypeEnum.SME___REPLACE___SMARTCARD___TYPE___SINGLE);
        tableData.setReplace_Smartcard_Req(replaceSmartcardReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + startReq.getCluster_Name() + " share: " + startReq.getShare_Index() + " type: " + startReq.getType()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareReplaceSmartCardStartReKeyReq(String clusterName, int shareIndex) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.REPLACE___SMARTCARD___TABLE, SMEOpcodeEnum.REPLACE___SMARTCARD___INITIATE));
        SMETableData tableData = new SMETableData();
        SMEClusterReplaceSmartcardReq replaceSmartcardReq = new SMEClusterReplaceSmartcardReq();
        SMEClusterReplaceSmartcardStartReq startReq = new SMEClusterReplaceSmartcardStartReq();
        replaceSmartcardReq.setReplace_Smartcard_Start_Req(startReq);
        startReq.setCluster_Name(clusterName);
        startReq.setShare_Index(Integer.valueOf(shareIndex));
        startReq.setType(SMEReplaceSmartcardTypeEnum.SME___REPLACE___SMARTCARD___TYPE___MASTER___KEY___REKEY);
        tableData.setReplace_Smartcard_Req(replaceSmartcardReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + startReq.getCluster_Name() + " share: " + startReq.getShare_Index() + " type: " + startReq.getType()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareReplaceSmartCardAbortReq(String clusterName, String transactionId) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.REPLACE___SMARTCARD___TABLE, SMEOpcodeEnum.REPLACE___SMARTCARD___ABORT));
        SMETableData tableData = new SMETableData();
        SMEClusterReplaceSmartcardReq replaceSmartcardReq = new SMEClusterReplaceSmartcardReq();
        SMEClusterReplaceSmartcardAbortReq abortReq = new SMEClusterReplaceSmartcardAbortReq();
        replaceSmartcardReq.setReplace_Smartcard_Abort_Req(abortReq);
        abortReq.setCluster_Name(clusterName);
        abortReq.setTransaction_ID(transactionId);
        tableData.setReplace_Smartcard_Req(replaceSmartcardReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + abortReq.getCluster_Name() + " id: " + abortReq.getTransaction_ID()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareReplaceSmartCardCommitReq(String clusterName, String transactionId) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.REPLACE___SMARTCARD___TABLE, SMEOpcodeEnum.REPLACE___SMARTCARD___COMMIT));
        SMETableData tableData = new SMETableData();
        SMEClusterReplaceSmartcardReq replaceSmartcardReq = new SMEClusterReplaceSmartcardReq();
        SMEClusterReplaceSmartcardCommitReq commitReq = new SMEClusterReplaceSmartcardCommitReq();
        replaceSmartcardReq.setReplace_Smartcard_Commit_Req(commitReq);
        commitReq.setCluster_Name(clusterName);
        commitReq.setTransaction_ID(transactionId);
        tableData.setReplace_Smartcard_Req(replaceSmartcardReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + commitReq.getCluster_Name() + " id: " + commitReq.getTransaction_ID()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareReplaceSmartCardSetReq(String clusterName, String transactionId, int shareIndex, ClusterRecoveryOfficerInfo newClusterRecoveryOfficerInfo, ArrayList<ClusterRecoveryOfficerInfo> existingRecoveryOfficerInfo, ArrayList<String> signatures, boolean force) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.REPLACE___SMARTCARD___TABLE, SMEOpcodeEnum.REPLACE___SMARTCARD___SET___RECOVERY___OFFICER));
        SMETableData tableData = new SMETableData();
        SMEClusterReplaceSmartcardReq replaceSmartcardReq = new SMEClusterReplaceSmartcardReq();
        SMEClusterReplaceSmartcardSetReq setReq = new SMEClusterReplaceSmartcardSetReq();
        replaceSmartcardReq.setReplace_Smartcard_Set_Req(setReq);
        setReq.setCluster_Name(clusterName);
        setReq.setTransaction_ID(transactionId);
        setReq.setShare_Index(Integer.valueOf(shareIndex));
        SMEClusterRecoveryObject cro = new SMEClusterRecoveryObject();
        SMEClusterRecoveryIndex index = new SMEClusterRecoveryIndex();
        index.setCluster_Name(newClusterRecoveryOfficerInfo.getClusterName());
        index.setShare_Index(Integer.valueOf(shareIndex));
        SMERecoveryOfficerIdentity roId = new SMERecoveryOfficerIdentity();
        SMERecoveryOfficerSCIdentity roSCId = new SMERecoveryOfficerSCIdentity();
        roSCId.setLabel(newClusterRecoveryOfficerInfo.getSmartcardLabel());
        roSCId.setSmartcard_Serial_Number(newClusterRecoveryOfficerInfo.getSmartcardSerialNumber());
        SMEMessageRSACert cert = new SMEMessageRSACert();
        cert.setCert(newClusterRecoveryOfficerInfo.getSmartcardRSACert());
        cert.setLength(Integer.valueOf(newClusterRecoveryOfficerInfo.getSmartcardRSACert().length()));
        cert.setValid(true);
        roSCId.setSME_RSA_Cert(cert);
        roId.setSC_Identity(roSCId);
        SMEClusterRecoveryData data = new SMEClusterRecoveryData();
        data.setValid(true);
        data.setRecovery_Officer_Id(roId);
        cro.setIndex(index);
        cro.setData(data);
        setReq.setNew_Recovery_Officer(cro);
        setReq.setSignature_Context_Version(Integer.valueOf(0));
        if (force) {
            setReq.setBypass_Quorum(true);
        } else {
            setReq.setBypass_Quorum(false);
        }
        if (existingRecoveryOfficerInfo != null) {
            ArrayList quoromList = (ArrayList)setReq.getQuorum_Signatures();
            int quorom = existingRecoveryOfficerInfo.size();
            for (int i = 0; i < quorom; ++i) {
                SMEClusterRecoveryOfficerSignatureObject quoromItem = new SMEClusterRecoveryOfficerSignatureObject();
                ClusterRecoveryOfficerInfo quoromOfficer = existingRecoveryOfficerInfo.get(i);
                quoromItem.setRecovery_Officer_Index(Integer.valueOf(quoromOfficer.getShareIndex()));
                quoromItem.setRecovery_Officer_Serial_No(quoromOfficer.getSmartcardSerialNumber());
                if (i < signatures.size()) {
                    SMEDigitalSignature signature = new SMEDigitalSignature();
                    if (signatures.get(i) != null) {
                        signature.setSignature(signatures.get(i));
                        signature.setSignature_Algo(SMEMsgAuthAlgoEnum.SME___MSG___AUTH___ALGO___NONE);
                        signature.setSignature_Datalen(Integer.valueOf(signature.getSignature().length()));
                        quoromItem.setSignature(signature);
                    }
                }
                quoromList.add(quoromItem);
            }
        }
        tableData.setReplace_Smartcard_Req(replaceSmartcardReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + setReq.getCluster_Name() + " share: " + setReq.getShare_Index() + " id: " + setReq.getTransaction_ID() + " label: " + data.getRecovery_Officer_Id().getSC_Identity().getLabel() + " serial number: " + data.getRecovery_Officer_Id().getSC_Identity().getSmartcard_Serial_Number()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareReplaceSmartCardGetTransactionReq(String clusterName) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.REPLACE___SMARTCARD___TABLE, SMEOpcodeEnum.REPLACE___SMARTCARD___GET___TRANSACTION));
        SMETableData tableData = new SMETableData();
        SMEClusterReplaceSmartcardReq replaceSmartcardReq = new SMEClusterReplaceSmartcardReq();
        SMEClusterReplaceSmartcardGetTransactionReq req = new SMEClusterReplaceSmartcardGetTransactionReq();
        req.setCluster_Name(clusterName);
        replaceSmartcardReq.setReplace_Smartcard_Get_Transaction_Req(req);
        tableData.setReplace_Smartcard_Req(replaceSmartcardReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + req.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareGetTrustpointsGetReq(SMEOpcodeEnum opcode) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.GLOBAL___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMETransportSecurityGetReq transportGetReq = new SMETransportSecurityGetReq();
        tableData.setTransport_Security_Get_Req(transportGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareTrustpointsSetReq(String trustPoint) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.GLOBAL___TABLE, SMEOpcodeEnum.UPDATE___TRANSPORT___SECURITY));
        SMETableData tableData = new SMETableData();
        SMETransportSecuritySetReq transportSetReq = new SMETransportSecuritySetReq();
        transportSetReq.setSME_Trust_Point(trustPoint);
        tableData.setTransport_Security_Set_Req(transportSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " Trustpoint: " + trustPoint));
        return this.buildSmeMessage(smeMessage);
    }

    public SMEMessage parseSMEClusterResponse(InputStream msg) {
        return this.parseSmeMessage(msg);
    }

    public SMEClusterMasterKeyFile parseSMEMasterKeyFile(InputStream msg) {
        return this.parseMasterKeyFile(msg);
    }

    public String prepareGetInterfaceStatsGetReq(String ifIndex, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.GLOBAL___TABLE, SMEOpcodeEnum.GET___INTERFACE, count));
        SMETableData tableData = new SMETableData();
        SMEGlobalGetReq globalGetReq = new SMEGlobalGetReq();
        SMEInterfaceIndex index = new SMEInterfaceIndex();
        if (ifIndex != null) {
            index.setIf_Index(ifIndex);
        }
        globalGetReq.setInterface_Index(index);
        tableData.setGlobal_Get_Req(globalGetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareEnableSSLSetReq(String clusterName, SMEOpcodeEnum opcode, boolean value) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.CLUSTER___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMEClusterSetReq clusterSetReq = new SMEClusterSetReq();
        SMEClusterObject object = new SMEClusterObject();
        SMEClusterIndex index = new SMEClusterIndex();
        SMEClusterData data = new SMEClusterData();
        index.setCluster_Name(clusterName);
        if (opcode == SMEOpcodeEnum.ENABLE___CLUSTER___KMC___TRANSPORT___SECURITY) {
            data.setCluster_Kmc_Transport(value);
        } else if (opcode == SMEOpcodeEnum.ENABLE___INTRA___CLUSTER___TRANSPORT___SECURITY) {
            data.setIntra_Cluster_Transport(value);
        }
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareUserRoleGetReq(String userName) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.GLOBAL___TABLE, SMEOpcodeEnum.GET___USER___ROLE));
        SMETableData tableData = new SMETableData();
        SMEUserIndex index = new SMEUserIndex();
        index.setSME_User_Name(userName);
        SMEGlobalGetReq globalGetReq = new SMEGlobalGetReq();
        globalGetReq.setUser_Index(index);
        tableData.setGlobal_Get_Req(globalGetReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " User Name: " + userName));
        return this.buildSmeMessage(smeMessage);
    }
}

