/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.message;

import com.cisco.dcbu.sme.common.DiskGroupInfo;
import com.cisco.dcbu.sme.common.DiskInfo;
import com.cisco.dcbu.sme.common.DiskOperation;
import com.cisco.dcbu.sme.common.DiskOperationDisable;
import com.cisco.dcbu.sme.common.DiskOperationEnable;
import com.cisco.dcbu.sme.common.DiskOperationModifyKey;
import com.cisco.dcbu.sme.common.DiskOperationReWrap;
import com.cisco.dcbu.sme.common.DiskOperationReadOnly;
import com.cisco.dcbu.sme.common.DiskOperationRecover;
import com.cisco.dcbu.sme.common.DiskOperationRekey;
import com.cisco.dcbu.sme.common.DiskPathInfo;
import com.cisco.dcbu.sme.common.DiskRecoverOptionEnum;
import com.cisco.dcbu.sme.common.mapper.DiskPrepareDataMapper;
import com.cisco.dcbu.sme.common.mapper.DiskPrepareSpeedMapper;
import com.cisco.dcbu.sme.message.SMEMessageBase;
import com.cisco.dcbu.sme.xml.SMEDiskConfigFlagsEnum;
import com.cisco.dcbu.sme.xml.SMEDiskData;
import com.cisco.dcbu.sme.xml.SMEDiskGroupData;
import com.cisco.dcbu.sme.xml.SMEDiskGroupGetReq;
import com.cisco.dcbu.sme.xml.SMEDiskGroupIndex;
import com.cisco.dcbu.sme.xml.SMEDiskGroupObject;
import com.cisco.dcbu.sme.xml.SMEDiskGroupSetReq;
import com.cisco.dcbu.sme.xml.SMEDiskIndex;
import com.cisco.dcbu.sme.xml.SMEDiskObject;
import com.cisco.dcbu.sme.xml.SMEDiskPathIndex;
import com.cisco.dcbu.sme.xml.SMEDiskPathObject;
import com.cisco.dcbu.sme.xml.SMEDkrRelationEnum;
import com.cisco.dcbu.sme.xml.SMELunPathUserConfig;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEPath;
import com.cisco.dcbu.sme.xml.SMEPrepareDataEnum;
import com.cisco.dcbu.sme.xml.SMEPrepareDataSpeedEnum;
import com.cisco.dcbu.sme.xml.SMETableData;
import com.cisco.dcbu.sme.xml.SMETableEnum;
import java.io.InputStream;

public class DiskGroupMessage
extends SMEMessageBase {
    public String prepareDiskGroupSetReq(DiskGroupInfo diskGroupInfo, SMEOpcodeEnum opcode) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.DISKGROUP___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMEDiskGroupSetReq diskGroupSetReq = new SMEDiskGroupSetReq();
        SMEDiskGroupObject object = new SMEDiskGroupObject();
        SMEDiskGroupIndex index = new SMEDiskGroupIndex();
        index.setCluster_Name(diskGroupInfo.getClusterName());
        index.setCluster_ID(diskGroupInfo.getClusterName());
        index.setDisk_Group_Name(diskGroupInfo.getDiskGroupName());
        object.setIndex(index);
        if (!opcode.equals((Object)SMEOpcodeEnum.DELETE___DISK___GROUP)) {
            SMEDiskGroupData data = new SMEDiskGroupData();
            object.setData(data);
            if (opcode.equals((Object)SMEOpcodeEnum.UPDATE___DISK___GROUP)) {
                // empty if block
            }
        }
        diskGroupSetReq.setDisk_Group(object);
        tableData.setDiskGroup_Set_Req(diskGroupSetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDiskSetReq(DiskInfo diskInfo, SMEOpcodeEnum opcode, DiskOperation oper) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.DISKGROUP___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMEDiskGroupSetReq diskGroupSetReq = new SMEDiskGroupSetReq();
        SMEDiskObject object = new SMEDiskObject();
        SMEDiskIndex index = new SMEDiskIndex();
        index.setCluster_Name(diskInfo.getClusterName());
        index.setDisk_Group_Name(diskInfo.getDiskGroupName());
        index.setDisk_Name(diskInfo.getDiskName());
        object.setIndex(index);
        if (!opcode.equals((Object)SMEOpcodeEnum.DELETE___DISK)) {
            SMEDiskData data = new SMEDiskData();
            object.setData(data);
            if (opcode.equals((Object)SMEOpcodeEnum.ENABLE___DISK)) {
                DiskOperationEnable en = (DiskOperationEnable)oper;
                data.setPrepare_Data_Speed(DiskPrepareSpeedMapper.mapTo(en.getSpeed()));
                if (en.isPrepareData()) {
                    data.setPrepareData(DiskPrepareDataMapper.mapTo(en.isPrepareData(), en.isDoOnline()));
                }
                data.setGUID(en.getGUID());
                if (en.isDkrSync()) {
                    data.setRKC_Relation_Config(SMEDkrRelationEnum.SME___DISK___RKC___RELATION___DEST___DISK);
                }
            } else if (opcode.equals((Object)SMEOpcodeEnum.DISABLE___DISK)) {
                DiskOperationDisable dd = (DiskOperationDisable)oper;
                data.setPrepareData(DiskPrepareDataMapper.mapTo(dd.isPrepareData(), dd.isDoOnline()));
                data.setPrepare_Data_Speed(DiskPrepareSpeedMapper.mapTo(dd.getSpeed()));
                if (dd.isDkrSync()) {
                    data.setRKC_Relation_Config(SMEDkrRelationEnum.SME___DISK___RKC___RELATION___DEST___DISK);
                }
            } else if (opcode.equals((Object)SMEOpcodeEnum.MODIFY___KEY___DISK)) {
                DiskOperationModifyKey mk = (DiskOperationModifyKey)oper;
                data.setPrepareData(null);
                data.setGUID(mk.getGUID());
                if (mk.isDkrSync()) {
                    data.setRKC_Relation_Config(SMEDkrRelationEnum.SME___DISK___RKC___RELATION___DEST___DISK);
                }
            } else if (opcode.equals((Object)SMEOpcodeEnum.REKEY___DISK)) {
                DiskOperationRekey rk = (DiskOperationRekey)oper;
                data.setPrepare_Data_Speed(SMEPrepareDataSpeedEnum.SME___DATA___PREPARE___FAST);
                data.setPrepareData(SMEPrepareDataEnum.SME___DATA___PREPARE___OFFLINE);
                data.setGUID(rk.getGUID());
            } else if (opcode.equals((Object)SMEOpcodeEnum.RECOVER___DISK)) {
                DiskOperationRecover r = (DiskOperationRecover)oper;
                data.setPrepareData(null);
                if (r.isDkrSync()) {
                    data.setRKC_Relation_Config(SMEDkrRelationEnum.SME___DISK___RKC___RELATION___DEST___DISK);
                }
                if (DiskRecoverOptionEnum.Crypto.equals((Object)r.getOption())) {
                    data.setGUID(r.getGUID());
                } else if (DiskRecoverOptionEnum.Signature.equals((Object)r.getOption())) {
                    data.setConfig_Flags(SMEDiskConfigFlagsEnum.SME___DISK___RECOVER___FROM___METADATA);
                } else if (DiskRecoverOptionEnum.KeyManager.equals((Object)r.getOption())) {
                    data.setConfig_Flags(SMEDiskConfigFlagsEnum.SME___DISK___RECOVER___FROM___KMC);
                }
            } else if (opcode.equals((Object)SMEOpcodeEnum.UPDATE___DISK___KEY)) {
                DiskOperationReWrap dor = (DiskOperationReWrap)oper;
                data.setGUID(dor.getGuid());
            } else if (opcode.equals((Object)SMEOpcodeEnum.UPDATE___DISK___READ___ONLY___KEY)) {
                DiskOperationReadOnly dor = (DiskOperationReadOnly)oper;
                data.setGUID(dor.getGUID());
            }
        }
        diskGroupSetReq.setDisk(object);
        tableData.setDiskGroup_Set_Req(diskGroupSetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDiskPathSetReq(DiskPathInfo diskPathInfo, SMEOpcodeEnum opcode) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___SET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.DISKGROUP___TABLE, opcode));
        SMETableData tableData = new SMETableData();
        SMEDiskGroupSetReq diskGroupSetReq = new SMEDiskGroupSetReq();
        SMEDiskPathObject object = new SMEDiskPathObject();
        SMEDiskPathIndex index = new SMEDiskPathIndex();
        index.setCluster_Name(diskPathInfo.getClusterName());
        index.setDisk_Group_Name(diskPathInfo.getDiskGroupName());
        index.setDisk_Name(diskPathInfo.getDiskName());
        SMELunPathUserConfig lunPath = new SMELunPathUserConfig();
        lunPath.setLun(diskPathInfo.getPath().getLunId());
        SMEPath path = new SMEPath();
        path.setInitiator(diskPathInfo.getPath().getInitiator());
        path.setTarget(diskPathInfo.getPath().getTarget());
        path.setFabric(diskPathInfo.getPath().getFabricName());
        path.setVSAN(Integer.valueOf(diskPathInfo.getPath().getVsanId()));
        lunPath.setPath(path);
        index.setPath(lunPath);
        object.setIndex(index);
        diskGroupSetReq.setDisk_Path(object);
        tableData.setDiskGroup_Set_Req(diskGroupSetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDiskGroupGetReq(DiskGroupInfo diskGroupInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.DISKGROUP___TABLE, SMEOpcodeEnum.GET___DISK___GROUP, count));
        SMETableData tableData = new SMETableData();
        SMEDiskGroupGetReq diskGroupGetReq = new SMEDiskGroupGetReq();
        SMEDiskGroupIndex index = new SMEDiskGroupIndex();
        index.setCluster_Name(diskGroupInfo.getClusterName());
        index.setDisk_Group_Name(diskGroupInfo.getDiskGroupName());
        diskGroupGetReq.setDisk_Group_Index(index);
        tableData.setDiskGroup_Get_Req(diskGroupGetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDiskGetReq(DiskInfo diskInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.DISKGROUP___TABLE, SMEOpcodeEnum.GET___DISK, count));
        SMETableData tableData = new SMETableData();
        SMEDiskGroupGetReq diskGroupGetReq = new SMEDiskGroupGetReq();
        SMEDiskIndex index = new SMEDiskIndex();
        index.setCluster_Name(diskInfo.getClusterName());
        index.setDisk_Group_Name(diskInfo.getDiskGroupName());
        index.setDisk_Name(diskInfo.getDiskName());
        diskGroupGetReq.setDisk_Index(index);
        tableData.setDiskGroup_Get_Req(diskGroupGetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDiskVerifyReq(String clusterName, String diskGroupName, String diskName) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.DISKGROUP___TABLE, SMEOpcodeEnum.VERIFY___DISK___METADATA, 1));
        SMETableData tableData = new SMETableData();
        SMEDiskGroupGetReq diskGroupGetReq = new SMEDiskGroupGetReq();
        SMEDiskIndex index = new SMEDiskIndex();
        index.setCluster_Name(clusterName);
        index.setDisk_Group_Name(diskGroupName);
        index.setDisk_Name(diskName);
        diskGroupGetReq.setDisk_Index(index);
        tableData.setDiskGroup_Get_Req(diskGroupGetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDiskListGetReq(DiskInfo diskInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.DISKGROUP___TABLE, SMEOpcodeEnum.GET___DISK___LIST, count));
        SMETableData tableData = new SMETableData();
        SMEDiskGroupGetReq diskGroupGetReq = new SMEDiskGroupGetReq();
        SMEDiskIndex index = new SMEDiskIndex();
        index.setCluster_Name(diskInfo.getClusterName());
        index.setDisk_Group_Name(diskInfo.getDiskGroupName());
        index.setDisk_Name(diskInfo.getDiskName());
        diskGroupGetReq.setDisk_Index(index);
        tableData.setDiskGroup_Get_Req(diskGroupGetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public String prepareDiskPathGetReq(DiskPathInfo diskPathInfo, SMEOperationEnum operation, int count) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", operation));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.DISKGROUP___TABLE, SMEOpcodeEnum.GET___DISK___PATH, count));
        SMETableData tableData = new SMETableData();
        SMEDiskGroupGetReq diskGroupGetReq = new SMEDiskGroupGetReq();
        SMEDiskPathIndex index = new SMEDiskPathIndex();
        index.setCluster_Name(diskPathInfo.getClusterName());
        index.setDisk_Group_Name(diskPathInfo.getDiskGroupName());
        index.setDisk_Name(diskPathInfo.getDiskName());
        if (diskPathInfo.getPath() != null) {
            SMELunPathUserConfig lunPath = new SMELunPathUserConfig();
            lunPath.setLun(diskPathInfo.getPath().getLunId());
            SMEPath path = new SMEPath();
            path.setInitiator(diskPathInfo.getPath().getHostName());
            path.setTarget(diskPathInfo.getPath().getTargetName());
            path.setFabric(diskPathInfo.getPath().getFabricName());
            path.setVSAN(Integer.valueOf(diskPathInfo.getPath().getVsanId()));
            lunPath.setPath(path);
            index.setPath(lunPath);
        }
        diskGroupGetReq.setDisk_Path_Index(index);
        tableData.setDiskGroup_Get_Req(diskGroupGetReq);
        smeMessage.setTable_Data(tableData);
        return this.buildSmeMessage(smeMessage);
    }

    public SMEMessage parseSMEDiskGroupResponse(InputStream msg) {
        return this.parseSmeMessage(msg);
    }
}

