/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.message;

import com.cisco.dcbu.sme.common.TapeVolumeGroupInfo;
import com.cisco.dcbu.sme.message.SMEMessageBase;
import com.cisco.dcbu.sme.xml.SMEClusterIndex;
import com.cisco.dcbu.sme.xml.SMEEIMsgHeader;
import com.cisco.dcbu.sme.xml.SMEEITableData;
import com.cisco.dcbu.sme.xml.SMEExportImportMessage;
import com.cisco.dcbu.sme.xml.SMEExportKeyReq;
import com.cisco.dcbu.sme.xml.SMEExportKeyReqData;
import com.cisco.dcbu.sme.xml.SMEExportKeyReqIndex;
import com.cisco.dcbu.sme.xml.SMEImportKeyEntry;
import com.cisco.dcbu.sme.xml.SMEImportKeyReq;
import com.cisco.dcbu.sme.xml.SMEImportKeyReqData;
import com.cisco.dcbu.sme.xml.SMEImportKeyReqIndex;
import com.cisco.dcbu.sme.xml.SMEKey;
import com.cisco.dcbu.sme.xml.SMEKeyExportObjectReq;
import com.cisco.dcbu.sme.xml.SMEKeyImportObjectReq;
import com.cisco.dcbu.sme.xml.SMEKeyTypeEnum;
import com.cisco.dcbu.sme.xml.SMEMessage;
import com.cisco.dcbu.sme.xml.SMEOpcodeEnum;
import com.cisco.dcbu.sme.xml.SMEOperationEnum;
import com.cisco.dcbu.sme.xml.SMEPasswordContext;
import com.cisco.dcbu.sme.xml.SMETableData;
import com.cisco.dcbu.sme.xml.SMETableEnum;
import com.cisco.dcbu.sme.xml.SMETapeBackupGroupIndex;
import com.cisco.dcbu.sme.xml.SMETapeGroupEI;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupEI;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupIndex;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ExportImportMessage
extends SMEMessageBase {
    public String prepareExportMessage(TapeVolumeGroupInfo tapeVolumeGroup, ArrayList<SMEKey> xkeys, String password) {
        SMEExportImportMessage smeEIMessage = new SMEExportImportMessage();
        SMEEIMsgHeader msg_header = new SMEEIMsgHeader();
        msg_header.setVersion("1.0");
        Date today = new Date();
        msg_header.setExport_TimeStamp(today.toString());
        smeEIMessage.setMsg_Header(msg_header);
        SMEClusterIndex cluster = new SMEClusterIndex();
        cluster.setCluster_Name(tapeVolumeGroup.getClusterName());
        smeEIMessage.setCluster(cluster);
        SMETapeBackupGroupIndex bgIndex = new SMETapeBackupGroupIndex();
        bgIndex.setCluster_Name(tapeVolumeGroup.getClusterName());
        bgIndex.setTape_BackupGroup_Name(tapeVolumeGroup.getTapeGroupName());
        SMETapeVolumeGroupIndex tvgIndex = new SMETapeVolumeGroupIndex();
        tvgIndex.setCluster_Name(tapeVolumeGroup.getClusterName());
        tvgIndex.setTape_BackupGroup_Name(tapeVolumeGroup.getTapeGroupName());
        tvgIndex.setTape_VolumeGroup_Name(tapeVolumeGroup.getVolumeGroupName());
        SMETapeVolumeGroupEI tapeVolumeGroupEI = new SMETapeVolumeGroupEI();
        tapeVolumeGroupEI.setTape_VolumeGroup(tvgIndex);
        for (SMEKey key : xkeys) {
            if (key.getData().getKey_Type() == SMEKeyTypeEnum.KEY___TYPE___TAPE___VOLUMEGROUP___SHARED___KEY) {
                tapeVolumeGroupEI.getShare_Key_Object().add(key);
                continue;
            }
            if (key.getData().getKey_Type() == SMEKeyTypeEnum.KEY___TYPE___TAPE___VOLUMEGROUP___WRAP___KEY) {
                tapeVolumeGroupEI.getWrap_Key_Object().add(key);
                continue;
            }
            if (key.getData().getKey_Type() != SMEKeyTypeEnum.KEY___TYPE___TAPE___VOLUME___KEY) continue;
            tapeVolumeGroupEI.getTape_Volume_Key_Object().add(key);
        }
        SMETapeGroupEI tapeGroup = new SMETapeGroupEI();
        tapeGroup.setTape_BackupGroup(bgIndex);
        tapeGroup.setTape_VolumeGroup(tapeVolumeGroupEI);
        SMEEITableData table_data = new SMEEITableData();
        table_data.setTapeGroup(tapeGroup);
        smeEIMessage.setTable_Data(table_data);
        return this.buildSmeEIMessage(smeEIMessage);
    }

    public ByteArrayOutputStream prepareSmeTapeVolumeKeyObjectFragment(ByteArrayOutputStream msgS, SMEKey smeKey) {
        return this.buildSmeTapeVolumeKeyObjectFragment(msgS, smeKey);
    }

    public ByteArrayOutputStream prepareSmeWrapKeyObjectFragment(ByteArrayOutputStream msgS, SMEKey smeKey) {
        return this.buildSmeWrapKeyObjectFragment(msgS, smeKey);
    }

    public ByteArrayOutputStream prepareSmeSharedKeyObjectFragment(ByteArrayOutputStream msgS, SMEKey smeKey) {
        return this.buildSmeSharedKeyObjectFragment(msgS, smeKey);
    }

    public void prepareSmeDiskKeyObjectFragment(ByteArrayOutputStream msgS, SMEKey smeKey) {
        this.buildSmeDiskKeyObjectFragment(msgS, smeKey);
    }

    public SMEExportImportMessage parseImportMessage(InputStream msg) {
        return this.parseSmeEIMessage(msg);
    }

    public String prepareSMEExportReq(String clusterName, List<SMEKey> keyArray, ArrayList<SMEKey> wrapKeyArray, String password) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.KEY___OBJECT___TABLE, SMEOpcodeEnum.EXPORT___KEY___OBJECT));
        SMEExportKeyReqIndex index = new SMEExportKeyReqIndex();
        index.setCluster_Name(clusterName);
        SMEExportKeyReqData data = new SMEExportKeyReqData();
        SMEPasswordContext passwordCtx = new SMEPasswordContext();
        passwordCtx.setPassword(password);
        data.setPassword_Context(passwordCtx);
        Iterator<SMEKey> keyIter = keyArray.iterator();
        while (keyIter.hasNext()) {
            data.getKey_Objects().add(keyIter.next());
        }
        Iterator<SMEKey> wrapKeyIter = wrapKeyArray.iterator();
        while (wrapKeyIter.hasNext()) {
            data.getWrap_Key_Objects().add(wrapKeyIter.next());
        }
        SMEExportKeyReq exportKeyReq = new SMEExportKeyReq();
        exportKeyReq.setIndex(index);
        exportKeyReq.setData(data);
        SMEKeyExportObjectReq exportObjectReq = new SMEKeyExportObjectReq();
        exportObjectReq.setKey_Export_Object(exportKeyReq);
        SMETableData tableData = new SMETableData();
        tableData.setKey_Export_Object_Req(exportObjectReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public SMEMessage parseSMEExportResp(InputStream msg) {
        return this.parseSmeMessage(msg);
    }

    public String prepareSMEImportReq(String clusterName, ArrayList<SMEImportKeyEntry> keyArray, SMEKey wrapKey, String password) {
        SMEMessage smeMessage = new SMEMessage();
        smeMessage.setMsg_Header(this.smeMessageHeader("1.0", SMEOperationEnum.SME___OP___GET));
        smeMessage.setTable_Req_Header(this.smeTableHeader(SMETableEnum.KEY___OBJECT___TABLE, SMEOpcodeEnum.IMPORT___KEY___OBJECT));
        SMEImportKeyReqIndex index = new SMEImportKeyReqIndex();
        index.setCluster_Name(clusterName);
        SMEImportKeyReqData data = new SMEImportKeyReqData();
        if (password != null) {
            SMEPasswordContext passwordCtx = new SMEPasswordContext();
            passwordCtx.setPassword(password);
            data.setPassword_Context(passwordCtx);
        }
        for (SMEImportKeyEntry keyEntry : keyArray) {
            data.getImport_Key_Context().add(keyEntry);
        }
        data.setImport_Wrap_Key_Object(wrapKey);
        SMEImportKeyReq importKeyReq = new SMEImportKeyReq();
        importKeyReq.setIndex(index);
        importKeyReq.setData(data);
        SMEKeyImportObjectReq importObjectReq = new SMEKeyImportObjectReq();
        importObjectReq.setKey_Import_Object(importKeyReq);
        SMETableData tableData = new SMETableData();
        tableData.setKey_Import_Object_Req(importObjectReq);
        smeMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + smeMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildSmeMessage(smeMessage);
    }

    public SMEMessage parseSMEImportResp(InputStream msg) {
        return this.parseSmeMessage(msg);
    }
}

