/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.smartcard;

import com.cisco.dcbu.sme.smartcard.CryptokiVersion;
import com.cisco.dcbu.sme.smartcard.Smartcard;
import com.cisco.dcbu.sme.smartcard.SmartcardLogger;
import com.cisco.dcbu.sme.smartcard.SmartcardTLV;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.Data;

public class SmartcardInfo {
    Smartcard smartcard;
    private String label;
    private String rsaCert;
    private Data data;
    private static final String TLV_TYPE_LABEL = "LABEL";
    public static final long MAX_PIN_ATTEMPTS = 6L;

    public CryptokiVersion getFirmwareVersion() {
        return new CryptokiVersion(this.getTokenInfo().getFirmwareVersion());
    }

    public long getFreePrivateMemory() {
        return this.getTokenInfo().getFreePrivateMemory();
    }

    public long getFreePublicMemory() {
        return this.getTokenInfo().getFreePublicMemory();
    }

    public CryptokiVersion getHardwareVersion() {
        return new CryptokiVersion(this.getTokenInfo().getHardwareVersion());
    }

    public String getManufacturerId() {
        return this.getTokenInfo().getManufacturerID();
    }

    public long getMaxPinLen() {
        return this.getTokenInfo().getMaxPinLen();
    }

    public long getMinPinLen() {
        return this.getTokenInfo().getMinPinLen();
    }

    public String getModel() {
        return this.getTokenInfo().getModel();
    }

    public String getSerialNumber() {
        return this.getTokenInfo().getSerialNumber();
    }

    public long getTotalPrivateMemory() {
        return this.getTokenInfo().getTotalPrivateMemory();
    }

    public long getTotalPublicMemory() {
        return this.getTokenInfo().getTotalPublicMemory();
    }

    public String getLabel() {
        return this.label;
    }

    public void clearLabel() {
        this.label = null;
        this.data = null;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getRsaCert() {
        return this.rsaCert;
    }

    public void setRsaCert(String rsaCert) {
        this.rsaCert = rsaCert;
    }

    public TokenInfo getTokenInfo() {
        try {
            return this.smartcard.getSmartcardSlot().getSlot().getToken().getTokenInfo();
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception reading smartcard token info:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
            return null;
        }
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public SmartcardInfo(Smartcard smartcard) {
        this.smartcard = smartcard;
    }

    public long getPinAttemptsLeft() {
        long deviceError = 0L;
        long pinAttemptsLeft = 0L;
        try {
            deviceError = this.smartcard.getSession().getSessionInfo().getDeviceError();
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception reading deviceError in session:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
        }
        pinAttemptsLeft = deviceError >> 16 & 0xFFL;
        if (pinAttemptsLeft == 255L) {
            pinAttemptsLeft = 6L;
        }
        return pinAttemptsLeft;
    }

    public void addPKCS11Object(Smartcard smartcard) {
        try {
            Session session = smartcard.getSession();
            Data dataObjectTemplate = this.data;
            if (dataObjectTemplate == null) {
                dataObjectTemplate = new Data();
                dataObjectTemplate.getApplication().setCharArrayValue(smartcard.getUser().toCharArray());
                dataObjectTemplate.getLabel().setCharArrayValue("GLOBAL".toCharArray());
                dataObjectTemplate.getToken().setBooleanValue(Boolean.TRUE);
            }
            dataObjectTemplate.getValue().setByteArrayValue(null);
            SmartcardTLV.addTLV(TLV_TYPE_LABEL, this.label, dataObjectTemplate.getValue());
            Data oldData = this.data;
            this.data = (Data)session.createObject(dataObjectTemplate);
            if (oldData != null) {
                session.destroyObject(oldData);
            }
        }
        catch (Exception e) {
            SmartcardLogger.warn("Exception initializing smartcard:" + e.getMessage());
            SmartcardLogger.stackTrace(e);
        }
    }

    public void restorePKCS11Object(Smartcard smartcard, Data data) {
        this.label = SmartcardTLV.getTLV(TLV_TYPE_LABEL, data.getValue());
    }

    public void print() {
        SmartcardLogger.info(this.getTokenInfo().toString());
        SmartcardLogger.info("SME Label: " + this.label);
    }
}

