/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.smartcard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SmartcardLogger {
    private static final String NEWLINE = "\n";
    private static final String INIT = "******INIT LOG******";
    private static final String END = "******END LOG******";
    private static final int debug = 4;
    private static final int info = 3;
    private static final int warn = 2;
    private static final int error = 1;
    static int level = 3;
    static File f;
    static FileOutputStream fos;

    public static void init() {
        String configFile = System.getenv("HOMEPATH") + "\\ciscosmartcardapplet.log";
        System.out.println("Log file is:" + configFile);
        f = new File(configFile);
        try {
            fos = new FileOutputStream(f, true);
            fos.write(INIT.getBytes());
            fos.write(NEWLINE.getBytes());
            fos.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void close() {
        if (fos != null) {
            try {
                fos.write(END.getBytes());
                fos.write(NEWLINE.getBytes());
                fos.flush();
                fos.close();
                fos = null;
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    public static void debug(String msg) {
        msg = SmartcardLogger.appender(msg);
        if (level >= 4) {
            System.out.println(msg);
            if (fos != null) {
                try {
                    fos.write(msg.getBytes());
                    fos.write(NEWLINE.getBytes());
                    fos.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void info(String msg) {
        msg = SmartcardLogger.appender(msg);
        if (level >= 3) {
            System.out.println(msg);
            if (fos != null) {
                try {
                    fos.write(msg.getBytes());
                    fos.write(NEWLINE.getBytes());
                    fos.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void warn(String msg) {
        msg = SmartcardLogger.appender(msg);
        if (level >= 2) {
            System.out.println(msg);
            if (fos != null) {
                try {
                    fos.write(msg.getBytes());
                    fos.write(NEWLINE.getBytes());
                    fos.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void error(String msg) {
        msg = SmartcardLogger.appender(msg);
        if (level >= 1) {
            System.out.println(msg);
            if (fos != null) {
                try {
                    fos.write(msg.getBytes());
                    fos.write(NEWLINE.getBytes());
                    fos.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void stackTrace(Exception e) {
        if (level >= 4) {
            StackTraceElement[] elements;
            for (StackTraceElement ele : elements = e.getStackTrace()) {
                String msg = SmartcardLogger.appender(ele.toString());
                System.out.println(msg);
                if (fos == null) continue;
                try {
                    fos.write(msg.getBytes());
                    fos.write(NEWLINE.getBytes());
                    fos.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static String appender(String msg) {
        return "[" + SmartcardLogger.getCurrentTime() + "]:" + Thread.currentThread().toString() + ":" + msg;
    }

    private static String getCurrentTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        Date creationDate = new Date(System.currentTimeMillis());
        return formatter.format(creationDate);
    }

    static {
        fos = null;
    }
}

