/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.smartcard;

import com.cisco.dcbu.sme.smartcard.Smartcard;
import com.cisco.dcbu.sme.smartcard.SmartcardLogger;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class SmartcardRSA {
    RSAPublicKey rsaPublicKey;
    RSAPrivateKey rsaPrivateKey;

    public RSAPrivateKey getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public void setRsaPrivateKey(RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public RSAPublicKey getRsaPublicKey() {
        return this.rsaPublicKey;
    }

    public void setRsaPublicKey(RSAPublicKey rsaPublicKey) {
        this.rsaPublicKey = rsaPublicKey;
    }

    public SmartcardRSA(RSAPublicKey rsaPublicKey, RSAPrivateKey rsaPrivateKey) {
        this.setRsaPublicKey(rsaPublicKey);
        this.setRsaPrivateKey(rsaPrivateKey);
    }

    public byte[] getPublicKeySpec() {
        RSAPublicKey exportableRsaPublicKey = this.rsaPublicKey;
        BigInteger modulus = new BigInteger(1, exportableRsaPublicKey.getModulus().getByteArrayValue());
        BigInteger publicExponent = new BigInteger(1, exportableRsaPublicKey.getPublicExponent().getByteArrayValue());
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            java.security.interfaces.RSAPublicKey javaRsaPublicKey = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(rsaPublicKeySpec);
            X509EncodedKeySpec x509EncodedPublicKey = keyFactory.getKeySpec(javaRsaPublicKey, X509EncodedKeySpec.class);
            return x509EncodedPublicKey.getEncoded();
        }
        catch (Exception e) {
            SmartcardLogger.warn(" Failed to get key specifications:" + e.getMessage());
            return null;
        }
    }

    public String getPublicKeyEncoded(boolean pem) {
        StringBuffer pemBuf = new StringBuffer();
        if (pem) {
            pemBuf.append("-----BEGIN PUBLIC KEY-----\n");
        }
        pemBuf.append(new String(Base64.encodeBase64Chunked((byte[])this.getPublicKeySpec())));
        if (pem) {
            pemBuf.append("-----END PUBLIC KEY-----\n");
        }
        return pemBuf.toString();
    }

    public static byte[] getPublicKeySpec(String encodedPublicKey) {
        if (encodedPublicKey != null) {
            String[] splitString = encodedPublicKey.split("-----BEGIN PUBLIC KEY-----", 2);
            String pemBuf = splitString.length > 1 ? splitString[1] : splitString[0];
            splitString = pemBuf.split("-----END PUBLIC KEY-----", 2);
            return Base64.decodeBase64((byte[])splitString[0].getBytes());
        }
        return new byte[0];
    }

    public byte[] wrapKey(Smartcard smartcard, byte[] key, byte[] peerRSAPublicKeySpec) {
        X509EncodedKeySpec x509EncodedPublicKey = new X509EncodedKeySpec(peerRSAPublicKeySpec);
        try {
            Session session = smartcard.getSession();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            java.security.interfaces.RSAPublicKey javaRsaPublicKey = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(x509EncodedPublicKey);
            RSAPublicKey rsaPublicKeyTemplate = new RSAPublicKey();
            rsaPublicKeyTemplate.getPublicExponent().setByteArrayValue(javaRsaPublicKey.getPublicExponent().toByteArray());
            byte[] modulus = Util.unsignedBigIntergerToByteArray(javaRsaPublicKey.getModulus());
            rsaPublicKeyTemplate.getModulus().setByteArrayValue(modulus);
            rsaPublicKeyTemplate.getModulusBits().setLongValue(new Long(javaRsaPublicKey.getModulus().bitLength()));
            rsaPublicKeyTemplate.getToken().setBooleanValue(Boolean.TRUE);
            rsaPublicKeyTemplate.getVerify().setBooleanValue(Boolean.TRUE);
            rsaPublicKeyTemplate.getEncrypt().setBooleanValue(Boolean.TRUE);
            RSAPublicKey peerRSAPublicKey = (RSAPublicKey)session.createObject(rsaPublicKeyTemplate);
            session.encryptInit(Mechanism.RSA_PKCS, peerRSAPublicKey);
            byte[] encryptedKey = session.encrypt(key);
            session.destroyObject(peerRSAPublicKey);
            return encryptedKey;
        }
        catch (Exception e) {
            SmartcardLogger.warn(" Failed to wrap key:" + e.getMessage());
            return null;
        }
    }

    public byte[] unwrapKey(Smartcard smartcard, byte[] encryptedKey) {
        try {
            Session session = smartcard.getSession();
            session.decryptInit(Mechanism.RSA_PKCS, this.rsaPrivateKey);
            byte[] key = session.decrypt(encryptedKey);
            return key;
        }
        catch (Exception e) {
            SmartcardLogger.warn(" Failed to unwrap key:" + e.getMessage());
            return null;
        }
    }

    public static SmartcardRSA generateRSAKeyPair(Smartcard smartcard) {
        Mechanism keyPairGenerationMechanism = Mechanism.RSA_PKCS_KEY_PAIR_GEN;
        RSAPublicKey rsaPublicKeyTemplate = new RSAPublicKey();
        RSAPrivateKey rsaPrivateKeyTemplate = new RSAPrivateKey();
        RSAPublicKey generatedRSAPublicKey = null;
        RSAPrivateKey generatedRSAPrivateKey = null;
        rsaPublicKeyTemplate.getModulusBits().setLongValue(new Long(1024L));
        byte[] publicExponentBytes = new byte[]{1, 0, 1};
        rsaPublicKeyTemplate.getPublicExponent().setByteArrayValue(publicExponentBytes);
        rsaPublicKeyTemplate.getToken().setBooleanValue(Boolean.TRUE);
        byte[] id = new byte[20];
        new Random().nextBytes(id);
        rsaPublicKeyTemplate.getId().setByteArrayValue(id);
        rsaPrivateKeyTemplate.getSensitive().setBooleanValue(Boolean.TRUE);
        rsaPrivateKeyTemplate.getToken().setBooleanValue(Boolean.TRUE);
        rsaPrivateKeyTemplate.getPrivate().setBooleanValue(Boolean.TRUE);
        rsaPrivateKeyTemplate.getId().setByteArrayValue(id);
        rsaPrivateKeyTemplate.getSign().setBooleanValue(Boolean.TRUE);
        rsaPrivateKeyTemplate.getDecrypt().setBooleanValue(Boolean.TRUE);
        rsaPublicKeyTemplate.getVerify().setBooleanValue(Boolean.TRUE);
        rsaPublicKeyTemplate.getEncrypt().setBooleanValue(Boolean.TRUE);
        rsaPublicKeyTemplate.getKeyType().setPresent(false);
        rsaPublicKeyTemplate.getObjectClass().setPresent(false);
        rsaPrivateKeyTemplate.getKeyType().setPresent(false);
        rsaPrivateKeyTemplate.getObjectClass().setPresent(false);
        try {
            KeyPair generatedKeyPair = smartcard.getSession().generateKeyPair(keyPairGenerationMechanism, rsaPublicKeyTemplate, rsaPrivateKeyTemplate);
            generatedRSAPublicKey = (RSAPublicKey)generatedKeyPair.getPublicKey();
            generatedRSAPrivateKey = (RSAPrivateKey)generatedKeyPair.getPrivateKey();
        }
        catch (Exception e) {
            SmartcardLogger.stackTrace(e);
        }
        return new SmartcardRSA(generatedRSAPublicKey, generatedRSAPrivateKey);
    }
}

