/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.xmltool;

import com.cisco.dcbu.sme.xmltool.Data;
import com.cisco.dcbu.sme.xmltool.EnumList;
import com.cisco.dcbu.sme.xmltool.IO;

public class SimpleType {
    private String name;
    private String type;
    private int minLength = 0;
    private int maxLength = 1;
    private String defineName;
    private boolean enumeration = false;
    private EnumList[] enumList = new EnumList[256];
    private int enumindex = 0;
    private boolean shouldDefine = true;
    private boolean hidden = false;
    private final String TAB = "     ";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void print() {
        System.out.println("ElementName: " + this.getName() + " ElementType: " + this.getType() + " MinLength: " + this.getMinLength() + " maxLength: " + this.getMaxLength() + "DefineName: " + this.defineName);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public String getDefineName() {
        return this.defineName;
    }

    public void setDefineName(String defineName) {
        this.defineName = defineName;
    }

    public boolean isEnumeration() {
        return this.enumeration;
    }

    public void setEnumeration(boolean enumeration) {
        this.enumeration = enumeration;
    }

    public EnumList[] getEnumList() {
        return this.enumList;
    }

    public void setEnumList(EnumList enumItem) {
        this.enumList[this.enumindex++] = enumItem;
    }

    public boolean isShouldDefine() {
        return this.shouldDefine;
    }

    public void setShouldDefine(boolean shouldDefine) {
        this.shouldDefine = shouldDefine;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void generateSimpleTypeDefs(IO io) {
        if (this.type.equalsIgnoreCase("xsd:string")) {
            if (!this.enumeration) {
                io.writetofile("typedef char " + this.name.toLowerCase() + "[" + (this.defineName.length() > 0 ? this.defineName : "" + this.maxLength) + " + 1];");
            }
        } else if (this.type.equalsIgnoreCase("xsd:byte")) {
            io.writetofile("typedef int8 " + this.name.toLowerCase() + ";");
        } else if (this.type.equalsIgnoreCase("xsd:short")) {
            io.writetofile("typedef int16 " + this.name.toLowerCase() + ";");
        } else if (this.type.equalsIgnoreCase("xsd:integer") || this.type.equalsIgnoreCase("xsd:int")) {
            io.writetofile("typedef int32 " + this.name.toLowerCase() + ";");
        } else if (this.type.equalsIgnoreCase("xsd:long")) {
            io.writetofile("typedef int64 " + this.name.toLowerCase() + ";");
        } else if (this.type.equalsIgnoreCase("xsd:unsignedByte")) {
            io.writetofile("typedef uint8 " + this.name.toLowerCase() + ";");
        } else if (this.type.equalsIgnoreCase("xsd:unsignedShort")) {
            io.writetofile("typedef uint16 " + this.name.toLowerCase() + ";");
        } else if (this.type.equalsIgnoreCase("xsd:unsignedInt")) {
            io.writetofile("typedef uint32 " + this.name.toLowerCase() + ";");
        } else if (this.type.equalsIgnoreCase("xsd:unsignedLong")) {
            io.writetofile("typedef uint64 " + this.name.toLowerCase() + ";");
        } else if (this.type.equalsIgnoreCase("xsd:boolean")) {
            io.writetofile("typedef boolean " + this.name.toLowerCase() + ";");
        }
    }

    public String EndianFunction(boolean ntoh) {
        if (!this.shouldDefine) {
            String f = this.name.toLowerCase();
            f = f + (ntoh ? "_ntoh" : "_hton");
            return f;
        }
        if (this.isEnumeration()) {
            return ntoh ? "ntohl" : "htonl";
        }
        if (this.type.equalsIgnoreCase("xsd:string") || this.type.equalsIgnoreCase("xsd:byte") || this.type.equalsIgnoreCase("xsd:unsignedByte") || this.type.equalsIgnoreCase("xsd:string")) {
            return null;
        }
        if (this.type.equalsIgnoreCase("xsd:short") || this.type.equalsIgnoreCase("xsd:unsignedShort")) {
            return ntoh ? "ntohs" : "htons";
        }
        if (this.type.equalsIgnoreCase("xsd:integer") || this.type.equalsIgnoreCase("xsd:int") || this.type.equalsIgnoreCase("xsd:unsignedInt") || this.type.equalsIgnoreCase("xsd:boolean") || this.type.equalsIgnoreCase("xsd:bool")) {
            return ntoh ? "ntohl" : "htonl";
        }
        if (this.type.equalsIgnoreCase("xsd:long") || this.type.equalsIgnoreCase("xsd:unsignedLong")) {
            return ntoh ? "ntoh64" : "hton64";
        }
        return null;
    }

    public void sortEnumLists() {
        if (this.enumindex > 0) {
            for (int i = 0; i < this.enumindex; ++i) {
                this.enumList[i].setValue("" + (i + 1));
            }
        }
    }

    public void generateCEnums(IO io, Data data) {
        if (this.enumindex > 0) {
            io.writetofile("__enum_begin(" + this.name.toLowerCase() + ")");
            for (int i = 0; i < this.enumindex; ++i) {
                if (i < this.enumindex - 1) {
                    io.writetofile("     __enum_entry(" + this.enumList[i].getLable() + "," + this.enumList[i].getValue() + ")");
                    continue;
                }
                io.writetofile("     __enum_last_entry(" + this.enumList[i].getLable() + "," + this.enumList[i].getValue() + ")");
            }
            io.writetofile("__enum_end(" + this.name.toLowerCase() + ");");
            io.writetofile(" ");
        }
    }
}

