/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.client.cim;

import com.cisco.dcbu.smis.client.CIMBase;
import com.cisco.dcbu.smis.client.cim.CIM_DHCPSettingData;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;
import javax.wbem.provider.ProviderHandle;

public class DHCPSettingData
extends CIMBase
implements CIM_DHCPSettingData {
    private static final String mClassVersion = "2.19.0";
    private static final String[] mKeys = new String[]{"InstanceID"};
    private static final String CPN_ADDRESSORIGIN = "AddressOrigin";
    private static final String CPN_REQUESTEDIPV4ADDRESS = "RequestedIPv4Address";
    private static final String CPN_REQUESTEDLEASETIME = "RequestedLeaseTime";
    private static final String CPN_CLIENTIDENTIFIER = "ClientIdentifier";
    private static final String CPN_VENDORCLASSIDENTIFIER = "VendorClassIdentifier";
    private static final String CPN_REQUESTEDOPTIONS = "RequestedOptions";
    private static final String CPN_REQUIREDOPTIONS = "RequiredOptions";
    private static final String CPN_INSTANCEID = "InstanceID";
    private static final String CPN_ELEMENTNAME = "ElementName";
    private static final String CPN_CAPTION = "Caption";
    private static final String CPN_DESCRIPTION = "Description";

    public DHCPSettingData(WBEMClient pWBEMClient, CIMInstance pCIMInstance) {
        super(pWBEMClient, pCIMInstance);
        if (pWBEMClient.toString().contains("WSManClient")) {
            this.typeConversion(pCIMInstance);
        } else {
            this.setCIMInstance(pCIMInstance);
        }
    }

    @Override
    public String getClassVersion() {
        return mClassVersion;
    }

    @Override
    public String[] getKeyPropertyNames() {
        return mKeys;
    }

    @Override
    public void setAddressOrigin(UnsignedInteger16 pAddressOrigin) throws IllegalArgumentException {
        if (pAddressOrigin == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ADDRESSORIGIN, CIMDataType.UINT16_T, pAddressOrigin);
    }

    @Override
    public UnsignedInteger16 getAddressOrigin() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_ADDRESSORIGIN);
    }

    @Override
    public void setRequestedIPv4Address(String pRequestedIPv4Address) throws IllegalArgumentException {
        if (pRequestedIPv4Address == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_REQUESTEDIPV4ADDRESS, CIMDataType.STRING_T, pRequestedIPv4Address);
    }

    @Override
    public String getRequestedIPv4Address() {
        return (String)this.mCimInstance.getPropertyValue(CPN_REQUESTEDIPV4ADDRESS);
    }

    @Override
    public void setRequestedLeaseTime(UnsignedInteger32 pRequestedLeaseTime) throws IllegalArgumentException {
        if (pRequestedLeaseTime == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_REQUESTEDLEASETIME, CIMDataType.UINT32_T, pRequestedLeaseTime);
    }

    @Override
    public UnsignedInteger32 getRequestedLeaseTime() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_REQUESTEDLEASETIME);
    }

    @Override
    public void setClientIdentifier(String pClientIdentifier) throws IllegalArgumentException {
        if (pClientIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CLIENTIDENTIFIER, CIMDataType.STRING_T, pClientIdentifier);
    }

    @Override
    public String getClientIdentifier() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CLIENTIDENTIFIER);
    }

    @Override
    public void setVendorClassIdentifier(String pVendorClassIdentifier) throws IllegalArgumentException {
        if (pVendorClassIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_VENDORCLASSIDENTIFIER, CIMDataType.STRING_T, pVendorClassIdentifier);
    }

    @Override
    public String getVendorClassIdentifier() {
        return (String)this.mCimInstance.getPropertyValue(CPN_VENDORCLASSIDENTIFIER);
    }

    @Override
    public void setRequestedOptions(UnsignedInteger16[] pRequestedOptions) throws IllegalArgumentException {
        if (pRequestedOptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_REQUESTEDOPTIONS, CIMDataType.UINT16_ARRAY_T, pRequestedOptions);
    }

    @Override
    public UnsignedInteger16[] getRequestedOptions() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_REQUESTEDOPTIONS);
    }

    @Override
    public void setRequiredOptions(UnsignedInteger16[] pRequiredOptions) throws IllegalArgumentException {
        if (pRequiredOptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_REQUIREDOPTIONS, CIMDataType.UINT16_ARRAY_T, pRequiredOptions);
    }

    @Override
    public UnsignedInteger16[] getRequiredOptions() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_REQUIREDOPTIONS);
    }

    @Override
    public void setInstanceID(String pInstanceID) throws IllegalArgumentException {
        if (pInstanceID == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_INSTANCEID, CIMDataType.STRING_T, pInstanceID);
    }

    @Override
    public String getInstanceID() {
        return (String)this.mCimInstance.getPropertyValue(CPN_INSTANCEID);
    }

    @Override
    public void setElementName(String pElementName) throws IllegalArgumentException {
        if (pElementName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ELEMENTNAME, CIMDataType.STRING_T, pElementName);
    }

    @Override
    public String getElementName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_ELEMENTNAME);
    }

    @Override
    public void setCaption(String pCaption) throws IllegalArgumentException {
        if (pCaption == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CAPTION, CIMDataType.STRING_T, pCaption);
    }

    @Override
    public String getCaption() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CAPTION);
    }

    @Override
    public void setDescription(String pDescription) throws IllegalArgumentException {
        if (pDescription == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_DESCRIPTION, CIMDataType.STRING_T, pDescription);
    }

    @Override
    public String getDescription() {
        return (String)this.mCimInstance.getPropertyValue(CPN_DESCRIPTION);
    }

    public void initialize(ProviderHandle pHandle) throws WBEMException {
    }

    private void typeConversion(CIMInstance pInstance) {
        CIMProperty[] propList = new CIMProperty[]{new CIMProperty(CPN_ADDRESSORIGIN, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_ADDRESSORIGIN)), new CIMProperty(CPN_REQUESTEDLEASETIME, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_REQUESTEDLEASETIME)), new CIMProperty(CPN_REQUESTEDOPTIONS, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_REQUESTEDOPTIONS)), new CIMProperty(CPN_REQUIREDOPTIONS, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_REQUIREDOPTIONS))};
        CIMInstance tempInst = pInstance.deriveInstance(propList);
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty(CPN_INSTANCEID, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_INSTANCEID))};
        CIMObjectPath op = pInstance.getObjectPath();
        CIMObjectPath derivedOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), keyProps, op.getXmlSchemaName());
        this.setCIMInstance(tempInst.deriveInstance(derivedOP));
    }

    private UnsignedInteger16 getUnsignedInteger16Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger16 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger16) {
                propertyValue = (UnsignedInteger16)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger16(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger32 getUnsignedInteger32Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger32 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger32) {
                propertyValue = (UnsignedInteger32)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger32(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger16[] getUnsignedInteger16ArrValue(CIMInstance pInstance, String pPropName) {
        UnsignedInteger16[] propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger16[]) {
                propertyValue = (UnsignedInteger16[])property.getValue();
            } else {
                try {
                    if (property.getValue() instanceof String[]) {
                        String[] strValueArr = (String[])property.getValue();
                        if (strValueArr != null) {
                            propertyValue = new UnsignedInteger16[strValueArr.length];
                            for (int ndx = 0; ndx < propertyValue.length; ++ndx) {
                                propertyValue[ndx] = new UnsignedInteger16(strValueArr[ndx]);
                            }
                        }
                    } else {
                        String strValue = (String)property.getValue();
                        propertyValue = new UnsignedInteger16[]{new UnsignedInteger16(strValue)};
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private String getStringValue(CIMInstance pInstance, String pPropName) {
        String propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            try {
                propertyValue = (String)property.getValue();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return propertyValue;
    }
}

