/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.client.cim;

import com.cisco.dcbu.smis.client.CIMBase;
import com.cisco.dcbu.smis.client.cim.CIM_TokenRingAdapter;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;
import javax.wbem.provider.ProviderHandle;

public class TokenRingAdapter
extends CIMBase
implements CIM_TokenRingAdapter {
    private static final String mClassVersion = "2.10.0";
    private static final String[] mKeys = new String[]{"SystemCreationClassName", "SystemName", "CreationClassName", "DeviceID"};
    private static final String CPN_NETWORKADDRESSES = "NetworkAddresses";
    private static final String CPN_MAXDATASIZE = "MaxDataSize";
    private static final String CPN_CAPABILITIES = "Capabilities";
    private static final String CPN_CAPABILITYDESCRIPTIONS = "CapabilityDescriptions";
    private static final String CPN_ENABLEDCAPABILITIES = "EnabledCapabilities";
    private static final String CPN_RINGSTATUS = "RingStatus";
    private static final String CPN_RINGSTATE = "RingState";
    private static final String CPN_RINGOPENSTATUS = "RingOpenStatus";
    private static final String CPN_RINGSPEED = "RingSpeed";
    private static final String CPN_BURSTERRORS = "BurstErrors";
    private static final String CPN_ACERRORS = "ACErrors";
    private static final String CPN_ABORTTRANSERRORS = "AbortTransErrors";
    private static final String CPN_INTERNALERRORS = "InternalErrors";
    private static final String CPN_LOSTFRAMEERRORS = "LostFrameErrors";
    private static final String CPN_RECEIVECONGESTIONS = "ReceiveCongestions";
    private static final String CPN_FRAMECOPIEDERRORS = "FrameCopiedErrors";
    private static final String CPN_TOKENERRORS = "TokenErrors";
    private static final String CPN_SOFTERRORS = "SoftErrors";
    private static final String CPN_HARDERRORS = "HardErrors";
    private static final String CPN_SIGNALLOSSCOUNT = "SignalLossCount";
    private static final String CPN_TRANSMITTEDBEACONS = "TransmittedBeacons";
    private static final String CPN_RECOVERYS = "Recoverys";
    private static final String CPN_LOBEWIRES = "LobeWires";
    private static final String CPN_REMOVES = "Removes";
    private static final String CPN_SINGLES = "Singles";
    private static final String CPN_FREQUENCYERRORS = "FrequencyErrors";
    private static final String CPN_PERMANENTADDRESS = "PermanentAddress";
    private static final String CPN_SPEED = "Speed";
    private static final String CPN_MAXSPEED = "MaxSpeed";
    private static final String CPN_FULLDUPLEX = "FullDuplex";
    private static final String CPN_AUTOSENSE = "AutoSense";
    private static final String CPN_OCTETSTRANSMITTED = "OctetsTransmitted";
    private static final String CPN_OCTETSRECEIVED = "OctetsReceived";
    private static final String CPN_SYSTEMCREATIONCLASSNAME = "SystemCreationClassName";
    private static final String CPN_SYSTEMNAME = "SystemName";
    private static final String CPN_CREATIONCLASSNAME = "CreationClassName";
    private static final String CPN_DEVICEID = "DeviceID";
    private static final String CPN_POWERMANAGEMENTSUPPORTED = "PowerManagementSupported";
    private static final String CPN_POWERMANAGEMENTCAPABILITIES = "PowerManagementCapabilities";
    private static final String CPN_AVAILABILITY = "Availability";
    private static final String CPN_STATUSINFO = "StatusInfo";
    private static final String CPN_LASTERRORCODE = "LastErrorCode";
    private static final String CPN_ERRORDESCRIPTION = "ErrorDescription";
    private static final String CPN_ERRORCLEARED = "ErrorCleared";
    private static final String CPN_OTHERIDENTIFYINGINFO = "OtherIdentifyingInfo";
    private static final String CPN_POWERONHOURS = "PowerOnHours";
    private static final String CPN_TOTALPOWERONHOURS = "TotalPowerOnHours";
    private static final String CPN_IDENTIFYINGDESCRIPTIONS = "IdentifyingDescriptions";
    private static final String CPN_ADDITIONALAVAILABILITY = "AdditionalAvailability";
    private static final String CPN_MAXQUIESCETIME = "MaxQuiesceTime";
    private static final String CPN_ENABLEDSTATE = "EnabledState";
    private static final String CPN_OTHERENABLEDSTATE = "OtherEnabledState";
    private static final String CPN_REQUESTEDSTATE = "RequestedState";
    private static final String CPN_ENABLEDDEFAULT = "EnabledDefault";
    private static final String CPN_TIMEOFLASTSTATECHANGE = "TimeOfLastStateChange";
    private static final String CPN_INSTALLDATE = "InstallDate";
    private static final String CPN_NAME = "Name";
    private static final String CPN_OPERATIONALSTATUS = "OperationalStatus";
    private static final String CPN_STATUSDESCRIPTIONS = "StatusDescriptions";
    private static final String CPN_STATUS = "Status";
    private static final String CPN_HEALTHSTATE = "HealthState";
    private static final String CPN_INSTANCEID = "InstanceID";
    private static final String CPN_CAPTION = "Caption";
    private static final String CPN_DESCRIPTION = "Description";
    private static final String CPN_ELEMENTNAME = "ElementName";

    public TokenRingAdapter(WBEMClient pWBEMClient, CIMInstance pCIMInstance) {
        super(pWBEMClient, pCIMInstance);
        if (pWBEMClient.toString().contains("WSManClient")) {
            this.typeConversion(pCIMInstance);
        } else {
            this.setCIMInstance(pCIMInstance);
        }
    }

    @Override
    public String getClassVersion() {
        return mClassVersion;
    }

    @Override
    public String[] getKeyPropertyNames() {
        return mKeys;
    }

    @Override
    public void setNetworkAddresses(String[] pNetworkAddresses) throws IllegalArgumentException {
        if (pNetworkAddresses == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_NETWORKADDRESSES, CIMDataType.STRING_ARRAY_T, pNetworkAddresses);
    }

    @Override
    public String[] getNetworkAddresses() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_NETWORKADDRESSES);
    }

    @Override
    public void setMaxDataSize(UnsignedInteger32 pMaxDataSize) throws IllegalArgumentException {
        if (pMaxDataSize == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_MAXDATASIZE, CIMDataType.UINT32_T, pMaxDataSize);
    }

    @Override
    public UnsignedInteger32 getMaxDataSize() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_MAXDATASIZE);
    }

    @Override
    public void setCapabilities(UnsignedInteger16[] pCapabilities) throws IllegalArgumentException {
        if (pCapabilities == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CAPABILITIES, CIMDataType.UINT16_ARRAY_T, pCapabilities);
    }

    @Override
    public UnsignedInteger16[] getCapabilities() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_CAPABILITIES);
    }

    @Override
    public void setCapabilityDescriptions(String[] pCapabilityDescriptions) throws IllegalArgumentException {
        if (pCapabilityDescriptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CAPABILITYDESCRIPTIONS, CIMDataType.STRING_ARRAY_T, pCapabilityDescriptions);
    }

    @Override
    public String[] getCapabilityDescriptions() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_CAPABILITYDESCRIPTIONS);
    }

    @Override
    public void setEnabledCapabilities(UnsignedInteger16[] pEnabledCapabilities) throws IllegalArgumentException {
        if (pEnabledCapabilities == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ENABLEDCAPABILITIES, CIMDataType.UINT16_ARRAY_T, pEnabledCapabilities);
    }

    @Override
    public UnsignedInteger16[] getEnabledCapabilities() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_ENABLEDCAPABILITIES);
    }

    @Override
    public void setRingStatus(UnsignedInteger32 pRingStatus) throws IllegalArgumentException {
        if (pRingStatus == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_RINGSTATUS, CIMDataType.UINT32_T, pRingStatus);
    }

    @Override
    public UnsignedInteger32 getRingStatus() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_RINGSTATUS);
    }

    @Override
    public void setRingState(UnsignedInteger16 pRingState) throws IllegalArgumentException {
        if (pRingState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_RINGSTATE, CIMDataType.UINT16_T, pRingState);
    }

    @Override
    public UnsignedInteger16 getRingState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_RINGSTATE);
    }

    @Override
    public void setRingOpenStatus(UnsignedInteger16 pRingOpenStatus) throws IllegalArgumentException {
        if (pRingOpenStatus == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_RINGOPENSTATUS, CIMDataType.UINT16_T, pRingOpenStatus);
    }

    @Override
    public UnsignedInteger16 getRingOpenStatus() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_RINGOPENSTATUS);
    }

    @Override
    public void setRingSpeed(UnsignedInteger16 pRingSpeed) throws IllegalArgumentException {
        if (pRingSpeed == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_RINGSPEED, CIMDataType.UINT16_T, pRingSpeed);
    }

    @Override
    public UnsignedInteger16 getRingSpeed() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_RINGSPEED);
    }

    @Override
    public void setBurstErrors(UnsignedInteger32 pBurstErrors) throws IllegalArgumentException {
        if (pBurstErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_BURSTERRORS, CIMDataType.UINT32_T, pBurstErrors);
    }

    @Override
    public UnsignedInteger32 getBurstErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_BURSTERRORS);
    }

    @Override
    public void setACErrors(UnsignedInteger32 pACErrors) throws IllegalArgumentException {
        if (pACErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ACERRORS, CIMDataType.UINT32_T, pACErrors);
    }

    @Override
    public UnsignedInteger32 getACErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_ACERRORS);
    }

    @Override
    public void setAbortTransErrors(UnsignedInteger32 pAbortTransErrors) throws IllegalArgumentException {
        if (pAbortTransErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ABORTTRANSERRORS, CIMDataType.UINT32_T, pAbortTransErrors);
    }

    @Override
    public UnsignedInteger32 getAbortTransErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_ABORTTRANSERRORS);
    }

    @Override
    public void setInternalErrors(UnsignedInteger32 pInternalErrors) throws IllegalArgumentException {
        if (pInternalErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_INTERNALERRORS, CIMDataType.UINT32_T, pInternalErrors);
    }

    @Override
    public UnsignedInteger32 getInternalErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_INTERNALERRORS);
    }

    @Override
    public void setLostFrameErrors(UnsignedInteger32 pLostFrameErrors) throws IllegalArgumentException {
        if (pLostFrameErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_LOSTFRAMEERRORS, CIMDataType.UINT32_T, pLostFrameErrors);
    }

    @Override
    public UnsignedInteger32 getLostFrameErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_LOSTFRAMEERRORS);
    }

    @Override
    public void setReceiveCongestions(UnsignedInteger32 pReceiveCongestions) throws IllegalArgumentException {
        if (pReceiveCongestions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_RECEIVECONGESTIONS, CIMDataType.UINT32_T, pReceiveCongestions);
    }

    @Override
    public UnsignedInteger32 getReceiveCongestions() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_RECEIVECONGESTIONS);
    }

    @Override
    public void setFrameCopiedErrors(UnsignedInteger32 pFrameCopiedErrors) throws IllegalArgumentException {
        if (pFrameCopiedErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_FRAMECOPIEDERRORS, CIMDataType.UINT32_T, pFrameCopiedErrors);
    }

    @Override
    public UnsignedInteger32 getFrameCopiedErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_FRAMECOPIEDERRORS);
    }

    @Override
    public void setTokenErrors(UnsignedInteger32 pTokenErrors) throws IllegalArgumentException {
        if (pTokenErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TOKENERRORS, CIMDataType.UINT32_T, pTokenErrors);
    }

    @Override
    public UnsignedInteger32 getTokenErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_TOKENERRORS);
    }

    @Override
    public void setSoftErrors(UnsignedInteger32 pSoftErrors) throws IllegalArgumentException {
        if (pSoftErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SOFTERRORS, CIMDataType.UINT32_T, pSoftErrors);
    }

    @Override
    public UnsignedInteger32 getSoftErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_SOFTERRORS);
    }

    @Override
    public void setHardErrors(UnsignedInteger32 pHardErrors) throws IllegalArgumentException {
        if (pHardErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_HARDERRORS, CIMDataType.UINT32_T, pHardErrors);
    }

    @Override
    public UnsignedInteger32 getHardErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_HARDERRORS);
    }

    @Override
    public void setSignalLossCount(UnsignedInteger32 pSignalLossCount) throws IllegalArgumentException {
        if (pSignalLossCount == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SIGNALLOSSCOUNT, CIMDataType.UINT32_T, pSignalLossCount);
    }

    @Override
    public UnsignedInteger32 getSignalLossCount() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_SIGNALLOSSCOUNT);
    }

    @Override
    public void setTransmittedBeacons(UnsignedInteger32 pTransmittedBeacons) throws IllegalArgumentException {
        if (pTransmittedBeacons == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TRANSMITTEDBEACONS, CIMDataType.UINT32_T, pTransmittedBeacons);
    }

    @Override
    public UnsignedInteger32 getTransmittedBeacons() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_TRANSMITTEDBEACONS);
    }

    @Override
    public void setRecoverys(UnsignedInteger32 pRecoverys) throws IllegalArgumentException {
        if (pRecoverys == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_RECOVERYS, CIMDataType.UINT32_T, pRecoverys);
    }

    @Override
    public UnsignedInteger32 getRecoverys() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_RECOVERYS);
    }

    @Override
    public void setLobeWires(UnsignedInteger32 pLobeWires) throws IllegalArgumentException {
        if (pLobeWires == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_LOBEWIRES, CIMDataType.UINT32_T, pLobeWires);
    }

    @Override
    public UnsignedInteger32 getLobeWires() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_LOBEWIRES);
    }

    @Override
    public void setRemoves(UnsignedInteger32 pRemoves) throws IllegalArgumentException {
        if (pRemoves == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_REMOVES, CIMDataType.UINT32_T, pRemoves);
    }

    @Override
    public UnsignedInteger32 getRemoves() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_REMOVES);
    }

    @Override
    public void setSingles(UnsignedInteger32 pSingles) throws IllegalArgumentException {
        if (pSingles == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SINGLES, CIMDataType.UINT32_T, pSingles);
    }

    @Override
    public UnsignedInteger32 getSingles() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_SINGLES);
    }

    @Override
    public void setFrequencyErrors(UnsignedInteger32 pFrequencyErrors) throws IllegalArgumentException {
        if (pFrequencyErrors == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_FREQUENCYERRORS, CIMDataType.UINT32_T, pFrequencyErrors);
    }

    @Override
    public UnsignedInteger32 getFrequencyErrors() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_FREQUENCYERRORS);
    }

    @Override
    public void setPermanentAddress(String pPermanentAddress) throws IllegalArgumentException {
        if (pPermanentAddress == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_PERMANENTADDRESS, CIMDataType.STRING_T, pPermanentAddress);
    }

    @Override
    public String getPermanentAddress() {
        return (String)this.mCimInstance.getPropertyValue(CPN_PERMANENTADDRESS);
    }

    @Override
    public void setSpeed(UnsignedInteger64 pSpeed) throws IllegalArgumentException {
        if (pSpeed == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SPEED, CIMDataType.UINT64_T, pSpeed);
    }

    @Override
    public UnsignedInteger64 getSpeed() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_SPEED);
    }

    @Override
    public void setMaxSpeed(UnsignedInteger64 pMaxSpeed) throws IllegalArgumentException {
        if (pMaxSpeed == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_MAXSPEED, CIMDataType.UINT64_T, pMaxSpeed);
    }

    @Override
    public UnsignedInteger64 getMaxSpeed() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_MAXSPEED);
    }

    @Override
    public void setFullDuplex(Boolean pFullDuplex) throws IllegalArgumentException {
        if (pFullDuplex == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_FULLDUPLEX, CIMDataType.BOOLEAN_T, pFullDuplex);
    }

    @Override
    public Boolean getFullDuplex() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_FULLDUPLEX);
    }

    @Override
    public void setAutoSense(Boolean pAutoSense) throws IllegalArgumentException {
        if (pAutoSense == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_AUTOSENSE, CIMDataType.BOOLEAN_T, pAutoSense);
    }

    @Override
    public Boolean getAutoSense() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_AUTOSENSE);
    }

    @Override
    public void setOctetsTransmitted(UnsignedInteger64 pOctetsTransmitted) throws IllegalArgumentException {
        if (pOctetsTransmitted == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OCTETSTRANSMITTED, CIMDataType.UINT64_T, pOctetsTransmitted);
    }

    @Override
    public UnsignedInteger64 getOctetsTransmitted() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_OCTETSTRANSMITTED);
    }

    @Override
    public void setOctetsReceived(UnsignedInteger64 pOctetsReceived) throws IllegalArgumentException {
        if (pOctetsReceived == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OCTETSRECEIVED, CIMDataType.UINT64_T, pOctetsReceived);
    }

    @Override
    public UnsignedInteger64 getOctetsReceived() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_OCTETSRECEIVED);
    }

    @Override
    public void setSystemCreationClassName(String pSystemCreationClassName) throws IllegalArgumentException {
        if (pSystemCreationClassName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SYSTEMCREATIONCLASSNAME, CIMDataType.STRING_T, pSystemCreationClassName);
    }

    @Override
    public String getSystemCreationClassName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_SYSTEMCREATIONCLASSNAME);
    }

    @Override
    public void setSystemName(String pSystemName) throws IllegalArgumentException {
        if (pSystemName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SYSTEMNAME, CIMDataType.STRING_T, pSystemName);
    }

    @Override
    public String getSystemName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_SYSTEMNAME);
    }

    @Override
    public void setCreationClassName(String pCreationClassName) throws IllegalArgumentException {
        if (pCreationClassName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CREATIONCLASSNAME, CIMDataType.STRING_T, pCreationClassName);
    }

    @Override
    public String getCreationClassName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CREATIONCLASSNAME);
    }

    @Override
    public void setDeviceID(String pDeviceID) throws IllegalArgumentException {
        if (pDeviceID == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_DEVICEID, CIMDataType.STRING_T, pDeviceID);
    }

    @Override
    public String getDeviceID() {
        return (String)this.mCimInstance.getPropertyValue(CPN_DEVICEID);
    }

    @Override
    public void setPowerManagementSupported(Boolean pPowerManagementSupported) throws IllegalArgumentException {
        if (pPowerManagementSupported == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERMANAGEMENTSUPPORTED, CIMDataType.BOOLEAN_T, pPowerManagementSupported);
    }

    @Override
    public Boolean getPowerManagementSupported() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_POWERMANAGEMENTSUPPORTED);
    }

    @Override
    public void setPowerManagementCapabilities(UnsignedInteger16[] pPowerManagementCapabilities) throws IllegalArgumentException {
        if (pPowerManagementCapabilities == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERMANAGEMENTCAPABILITIES, CIMDataType.UINT16_ARRAY_T, pPowerManagementCapabilities);
    }

    @Override
    public UnsignedInteger16[] getPowerManagementCapabilities() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_POWERMANAGEMENTCAPABILITIES);
    }

    @Override
    public void setAvailability(UnsignedInteger16 pAvailability) throws IllegalArgumentException {
        if (pAvailability == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_AVAILABILITY, CIMDataType.UINT16_T, pAvailability);
    }

    @Override
    public UnsignedInteger16 getAvailability() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_AVAILABILITY);
    }

    @Override
    public void setStatusInfo(UnsignedInteger16 pStatusInfo) throws IllegalArgumentException {
        if (pStatusInfo == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUSINFO, CIMDataType.UINT16_T, pStatusInfo);
    }

    @Override
    public UnsignedInteger16 getStatusInfo() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_STATUSINFO);
    }

    @Override
    public void setLastErrorCode(UnsignedInteger32 pLastErrorCode) throws IllegalArgumentException {
        if (pLastErrorCode == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_LASTERRORCODE, CIMDataType.UINT32_T, pLastErrorCode);
    }

    @Override
    public UnsignedInteger32 getLastErrorCode() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_LASTERRORCODE);
    }

    @Override
    public void setErrorDescription(String pErrorDescription) throws IllegalArgumentException {
        if (pErrorDescription == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ERRORDESCRIPTION, CIMDataType.STRING_T, pErrorDescription);
    }

    @Override
    public String getErrorDescription() {
        return (String)this.mCimInstance.getPropertyValue(CPN_ERRORDESCRIPTION);
    }

    @Override
    public void setErrorCleared(Boolean pErrorCleared) throws IllegalArgumentException {
        if (pErrorCleared == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ERRORCLEARED, CIMDataType.BOOLEAN_T, pErrorCleared);
    }

    @Override
    public Boolean getErrorCleared() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_ERRORCLEARED);
    }

    @Override
    public void setOtherIdentifyingInfo(String[] pOtherIdentifyingInfo) throws IllegalArgumentException {
        if (pOtherIdentifyingInfo == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OTHERIDENTIFYINGINFO, CIMDataType.STRING_ARRAY_T, pOtherIdentifyingInfo);
    }

    @Override
    public String[] getOtherIdentifyingInfo() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_OTHERIDENTIFYINGINFO);
    }

    @Override
    public void setPowerOnHours(UnsignedInteger64 pPowerOnHours) throws IllegalArgumentException {
        if (pPowerOnHours == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERONHOURS, CIMDataType.UINT64_T, pPowerOnHours);
    }

    @Override
    public UnsignedInteger64 getPowerOnHours() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_POWERONHOURS);
    }

    @Override
    public void setTotalPowerOnHours(UnsignedInteger64 pTotalPowerOnHours) throws IllegalArgumentException {
        if (pTotalPowerOnHours == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TOTALPOWERONHOURS, CIMDataType.UINT64_T, pTotalPowerOnHours);
    }

    @Override
    public UnsignedInteger64 getTotalPowerOnHours() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_TOTALPOWERONHOURS);
    }

    @Override
    public void setIdentifyingDescriptions(String[] pIdentifyingDescriptions) throws IllegalArgumentException {
        if (pIdentifyingDescriptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_IDENTIFYINGDESCRIPTIONS, CIMDataType.STRING_ARRAY_T, pIdentifyingDescriptions);
    }

    @Override
    public String[] getIdentifyingDescriptions() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_IDENTIFYINGDESCRIPTIONS);
    }

    @Override
    public void setAdditionalAvailability(UnsignedInteger16[] pAdditionalAvailability) throws IllegalArgumentException {
        if (pAdditionalAvailability == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ADDITIONALAVAILABILITY, CIMDataType.UINT16_ARRAY_T, pAdditionalAvailability);
    }

    @Override
    public UnsignedInteger16[] getAdditionalAvailability() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_ADDITIONALAVAILABILITY);
    }

    @Override
    public void setMaxQuiesceTime(UnsignedInteger64 pMaxQuiesceTime) throws IllegalArgumentException {
        if (pMaxQuiesceTime == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_MAXQUIESCETIME, CIMDataType.UINT64_T, pMaxQuiesceTime);
    }

    @Override
    public UnsignedInteger64 getMaxQuiesceTime() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_MAXQUIESCETIME);
    }

    @Override
    public void setEnabledState(UnsignedInteger16 pEnabledState) throws IllegalArgumentException {
        if (pEnabledState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ENABLEDSTATE, CIMDataType.UINT16_T, pEnabledState);
    }

    @Override
    public UnsignedInteger16 getEnabledState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_ENABLEDSTATE);
    }

    @Override
    public void setOtherEnabledState(String pOtherEnabledState) throws IllegalArgumentException {
        if (pOtherEnabledState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OTHERENABLEDSTATE, CIMDataType.STRING_T, pOtherEnabledState);
    }

    @Override
    public String getOtherEnabledState() {
        return (String)this.mCimInstance.getPropertyValue(CPN_OTHERENABLEDSTATE);
    }

    @Override
    public void setRequestedState(UnsignedInteger16 pRequestedState) throws IllegalArgumentException {
        if (pRequestedState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_REQUESTEDSTATE, CIMDataType.UINT16_T, pRequestedState);
    }

    @Override
    public UnsignedInteger16 getRequestedState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_REQUESTEDSTATE);
    }

    @Override
    public void setEnabledDefault(UnsignedInteger16 pEnabledDefault) throws IllegalArgumentException {
        if (pEnabledDefault == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ENABLEDDEFAULT, CIMDataType.UINT16_T, pEnabledDefault);
    }

    @Override
    public UnsignedInteger16 getEnabledDefault() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_ENABLEDDEFAULT);
    }

    @Override
    public void setTimeOfLastStateChange(CIMDateTime pTimeOfLastStateChange) throws IllegalArgumentException {
        if (pTimeOfLastStateChange == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TIMEOFLASTSTATECHANGE, CIMDataType.DATETIME_T, pTimeOfLastStateChange);
    }

    @Override
    public CIMDateTime getTimeOfLastStateChange() {
        return (CIMDateTime)this.mCimInstance.getPropertyValue(CPN_TIMEOFLASTSTATECHANGE);
    }

    @Override
    public void setInstallDate(CIMDateTime pInstallDate) throws IllegalArgumentException {
        if (pInstallDate == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_INSTALLDATE, CIMDataType.DATETIME_T, pInstallDate);
    }

    @Override
    public CIMDateTime getInstallDate() {
        return (CIMDateTime)this.mCimInstance.getPropertyValue(CPN_INSTALLDATE);
    }

    @Override
    public void setName(String pName) throws IllegalArgumentException {
        if (pName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_NAME, CIMDataType.STRING_T, pName);
    }

    @Override
    public String getName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_NAME);
    }

    @Override
    public void setOperationalStatus(UnsignedInteger16[] pOperationalStatus) throws IllegalArgumentException {
        if (pOperationalStatus == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OPERATIONALSTATUS, CIMDataType.UINT16_ARRAY_T, pOperationalStatus);
    }

    @Override
    public UnsignedInteger16[] getOperationalStatus() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_OPERATIONALSTATUS);
    }

    @Override
    public void setStatusDescriptions(String[] pStatusDescriptions) throws IllegalArgumentException {
        if (pStatusDescriptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUSDESCRIPTIONS, CIMDataType.STRING_ARRAY_T, pStatusDescriptions);
    }

    @Override
    public String[] getStatusDescriptions() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_STATUSDESCRIPTIONS);
    }

    @Override
    public void setStatus(String pStatus) throws IllegalArgumentException {
        if (pStatus == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUS, CIMDataType.STRING_T, pStatus);
    }

    @Override
    public String getStatus() {
        return (String)this.mCimInstance.getPropertyValue(CPN_STATUS);
    }

    @Override
    public void setHealthState(UnsignedInteger16 pHealthState) throws IllegalArgumentException {
        if (pHealthState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_HEALTHSTATE, CIMDataType.UINT16_T, pHealthState);
    }

    @Override
    public UnsignedInteger16 getHealthState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_HEALTHSTATE);
    }

    @Override
    public void setInstanceID(String pInstanceID) throws IllegalArgumentException {
        if (pInstanceID == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_INSTANCEID, CIMDataType.STRING_T, pInstanceID);
    }

    @Override
    public String getInstanceID() {
        return (String)this.mCimInstance.getPropertyValue(CPN_INSTANCEID);
    }

    @Override
    public void setCaption(String pCaption) throws IllegalArgumentException {
        if (pCaption == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CAPTION, CIMDataType.STRING_T, pCaption);
    }

    @Override
    public String getCaption() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CAPTION);
    }

    @Override
    public void setDescription(String pDescription) throws IllegalArgumentException {
        if (pDescription == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_DESCRIPTION, CIMDataType.STRING_T, pDescription);
    }

    @Override
    public String getDescription() {
        return (String)this.mCimInstance.getPropertyValue(CPN_DESCRIPTION);
    }

    @Override
    public void setElementName(String pElementName) throws IllegalArgumentException {
        if (pElementName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ELEMENTNAME, CIMDataType.STRING_T, pElementName);
    }

    @Override
    public String getElementName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_ELEMENTNAME);
    }

    public void initialize(ProviderHandle pHandle) throws WBEMException {
    }

    private void typeConversion(CIMInstance pInstance) {
        CIMProperty[] propList = new CIMProperty[]{new CIMProperty(CPN_MAXDATASIZE, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_MAXDATASIZE)), new CIMProperty(CPN_CAPABILITIES, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_CAPABILITIES)), new CIMProperty(CPN_ENABLEDCAPABILITIES, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_ENABLEDCAPABILITIES)), new CIMProperty(CPN_RINGSTATUS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_RINGSTATUS)), new CIMProperty(CPN_RINGSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_RINGSTATE)), new CIMProperty(CPN_RINGOPENSTATUS, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_RINGOPENSTATUS)), new CIMProperty(CPN_RINGSPEED, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_RINGSPEED)), new CIMProperty(CPN_BURSTERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_BURSTERRORS)), new CIMProperty(CPN_ACERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_ACERRORS)), new CIMProperty(CPN_ABORTTRANSERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_ABORTTRANSERRORS)), new CIMProperty(CPN_INTERNALERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_INTERNALERRORS)), new CIMProperty(CPN_LOSTFRAMEERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_LOSTFRAMEERRORS)), new CIMProperty(CPN_RECEIVECONGESTIONS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_RECEIVECONGESTIONS)), new CIMProperty(CPN_FRAMECOPIEDERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_FRAMECOPIEDERRORS)), new CIMProperty(CPN_TOKENERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_TOKENERRORS)), new CIMProperty(CPN_SOFTERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_SOFTERRORS)), new CIMProperty(CPN_HARDERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_HARDERRORS)), new CIMProperty(CPN_SIGNALLOSSCOUNT, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_SIGNALLOSSCOUNT)), new CIMProperty(CPN_TRANSMITTEDBEACONS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_TRANSMITTEDBEACONS)), new CIMProperty(CPN_RECOVERYS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_RECOVERYS)), new CIMProperty(CPN_LOBEWIRES, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_LOBEWIRES)), new CIMProperty(CPN_REMOVES, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_REMOVES)), new CIMProperty(CPN_SINGLES, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_SINGLES)), new CIMProperty(CPN_FREQUENCYERRORS, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_FREQUENCYERRORS)), new CIMProperty(CPN_SPEED, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_SPEED)), new CIMProperty(CPN_MAXSPEED, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_MAXSPEED)), new CIMProperty(CPN_FULLDUPLEX, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_FULLDUPLEX)), new CIMProperty(CPN_AUTOSENSE, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_AUTOSENSE)), new CIMProperty(CPN_OCTETSTRANSMITTED, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_OCTETSTRANSMITTED)), new CIMProperty(CPN_OCTETSRECEIVED, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_OCTETSRECEIVED)), new CIMProperty(CPN_POWERMANAGEMENTSUPPORTED, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_POWERMANAGEMENTSUPPORTED)), new CIMProperty(CPN_POWERMANAGEMENTCAPABILITIES, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_POWERMANAGEMENTCAPABILITIES)), new CIMProperty(CPN_AVAILABILITY, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_AVAILABILITY)), new CIMProperty(CPN_STATUSINFO, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_STATUSINFO)), new CIMProperty(CPN_LASTERRORCODE, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_LASTERRORCODE)), new CIMProperty(CPN_ERRORCLEARED, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_ERRORCLEARED)), new CIMProperty(CPN_POWERONHOURS, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_POWERONHOURS)), new CIMProperty(CPN_TOTALPOWERONHOURS, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_TOTALPOWERONHOURS)), new CIMProperty(CPN_ADDITIONALAVAILABILITY, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_ADDITIONALAVAILABILITY)), new CIMProperty(CPN_MAXQUIESCETIME, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_MAXQUIESCETIME)), new CIMProperty(CPN_ENABLEDSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_ENABLEDSTATE)), new CIMProperty(CPN_REQUESTEDSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_REQUESTEDSTATE)), new CIMProperty(CPN_ENABLEDDEFAULT, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_ENABLEDDEFAULT)), new CIMProperty(CPN_TIMEOFLASTSTATECHANGE, CIMDataType.DATETIME_T, (Object)this.getCIMDateTimeAbsoluteValue(pInstance, CPN_TIMEOFLASTSTATECHANGE)), new CIMProperty(CPN_INSTALLDATE, CIMDataType.DATETIME_T, (Object)this.getCIMDateTimeAbsoluteValue(pInstance, CPN_INSTALLDATE)), new CIMProperty(CPN_OPERATIONALSTATUS, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_OPERATIONALSTATUS)), new CIMProperty(CPN_HEALTHSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_HEALTHSTATE))};
        CIMInstance tempInst = pInstance.deriveInstance(propList);
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty(CPN_SYSTEMCREATIONCLASSNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_SYSTEMCREATIONCLASSNAME)), new CIMProperty(CPN_SYSTEMNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_SYSTEMNAME)), new CIMProperty(CPN_CREATIONCLASSNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_CREATIONCLASSNAME)), new CIMProperty(CPN_DEVICEID, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_DEVICEID))};
        CIMObjectPath op = pInstance.getObjectPath();
        CIMObjectPath derivedOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), keyProps, op.getXmlSchemaName());
        this.setCIMInstance(tempInst.deriveInstance(derivedOP));
    }

    private UnsignedInteger32 getUnsignedInteger32Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger32 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger32) {
                propertyValue = (UnsignedInteger32)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger32(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger16[] getUnsignedInteger16ArrValue(CIMInstance pInstance, String pPropName) {
        UnsignedInteger16[] propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger16[]) {
                propertyValue = (UnsignedInteger16[])property.getValue();
            } else {
                try {
                    if (property.getValue() instanceof String[]) {
                        String[] strValueArr = (String[])property.getValue();
                        if (strValueArr != null) {
                            propertyValue = new UnsignedInteger16[strValueArr.length];
                            for (int ndx = 0; ndx < propertyValue.length; ++ndx) {
                                propertyValue[ndx] = new UnsignedInteger16(strValueArr[ndx]);
                            }
                        }
                    } else {
                        String strValue = (String)property.getValue();
                        propertyValue = new UnsignedInteger16[]{new UnsignedInteger16(strValue)};
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger16 getUnsignedInteger16Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger16 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger16) {
                propertyValue = (UnsignedInteger16)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger16(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger64 getUnsignedInteger64Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger64 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger64) {
                propertyValue = (UnsignedInteger64)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger64(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private Boolean getBooleanValue(CIMInstance pInstance, String pPropName) {
        Boolean propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof Boolean) {
                propertyValue = (Boolean)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new Boolean(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private String getStringValue(CIMInstance pInstance, String pPropName) {
        String propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            try {
                propertyValue = (String)property.getValue();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return propertyValue;
    }

    private CIMDateTimeAbsolute getCIMDateTimeAbsoluteValue(CIMInstance pInstance, String pPropName) {
        CIMDateTimeAbsolute propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof CIMDateTimeAbsolute) {
                propertyValue = (CIMDateTimeAbsolute)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new CIMDateTimeAbsolute(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    @Override
    public UnsignedInteger32 setPowerState(UnsignedInteger16 pPowerState, CIMDateTime pTime) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "SetPowerState", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 reset() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "Reset", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 enableDevice(Boolean pEnabled) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "EnableDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 onlineDevice(Boolean pOnline) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "OnlineDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 quiesceDevice(Boolean pQuiesce) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "QuiesceDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 saveProperties() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "SaveProperties", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 restoreProperties() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "RestoreProperties", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 requestStateChange(UnsignedInteger16 pRequestedState, CIMObjectPath pJob, CIMDateTime pTimeoutPeriod) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "RequestStateChange", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }
}

