/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.client.cim;

import com.cisco.dcbu.smis.client.CIMBase;
import com.cisco.dcbu.smis.client.cim.CIM_USBDevice;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;
import javax.wbem.provider.ProviderHandle;

public class USBDevice
extends CIMBase
implements CIM_USBDevice {
    private static final String mClassVersion = "2.6.0";
    private static final String[] mKeys = new String[]{"SystemCreationClassName", "SystemName", "CreationClassName", "DeviceID"};
    private static final String CPN_USBVERSION = "USBVersion";
    private static final String CPN_CLASSCODE = "ClassCode";
    private static final String CPN_SUBCLASSCODE = "SubclassCode";
    private static final String CPN_PROTOCOLCODE = "ProtocolCode";
    private static final String CPN_NUMBEROFCONFIGS = "NumberOfConfigs";
    private static final String CPN_CURRENTCONFIGVALUE = "CurrentConfigValue";
    private static final String CPN_CURRENTALTERNATESETTINGS = "CurrentAlternateSettings";
    private static final String CPN_SYSTEMCREATIONCLASSNAME = "SystemCreationClassName";
    private static final String CPN_SYSTEMNAME = "SystemName";
    private static final String CPN_CREATIONCLASSNAME = "CreationClassName";
    private static final String CPN_DEVICEID = "DeviceID";
    private static final String CPN_POWERMANAGEMENTSUPPORTED = "PowerManagementSupported";
    private static final String CPN_POWERMANAGEMENTCAPABILITIES = "PowerManagementCapabilities";
    private static final String CPN_AVAILABILITY = "Availability";
    private static final String CPN_STATUSINFO = "StatusInfo";
    private static final String CPN_LASTERRORCODE = "LastErrorCode";
    private static final String CPN_ERRORDESCRIPTION = "ErrorDescription";
    private static final String CPN_ERRORCLEARED = "ErrorCleared";
    private static final String CPN_OTHERIDENTIFYINGINFO = "OtherIdentifyingInfo";
    private static final String CPN_POWERONHOURS = "PowerOnHours";
    private static final String CPN_TOTALPOWERONHOURS = "TotalPowerOnHours";
    private static final String CPN_IDENTIFYINGDESCRIPTIONS = "IdentifyingDescriptions";
    private static final String CPN_ADDITIONALAVAILABILITY = "AdditionalAvailability";
    private static final String CPN_MAXQUIESCETIME = "MaxQuiesceTime";
    private static final String CPN_ENABLEDSTATE = "EnabledState";
    private static final String CPN_OTHERENABLEDSTATE = "OtherEnabledState";
    private static final String CPN_REQUESTEDSTATE = "RequestedState";
    private static final String CPN_ENABLEDDEFAULT = "EnabledDefault";
    private static final String CPN_TIMEOFLASTSTATECHANGE = "TimeOfLastStateChange";
    private static final String CPN_INSTALLDATE = "InstallDate";
    private static final String CPN_NAME = "Name";
    private static final String CPN_OPERATIONALSTATUS = "OperationalStatus";
    private static final String CPN_STATUSDESCRIPTIONS = "StatusDescriptions";
    private static final String CPN_STATUS = "Status";
    private static final String CPN_HEALTHSTATE = "HealthState";
    private static final String CPN_INSTANCEID = "InstanceID";
    private static final String CPN_CAPTION = "Caption";
    private static final String CPN_DESCRIPTION = "Description";
    private static final String CPN_ELEMENTNAME = "ElementName";

    public USBDevice(WBEMClient pWBEMClient, CIMInstance pCIMInstance) {
        super(pWBEMClient, pCIMInstance);
        if (pWBEMClient.toString().contains("WSManClient")) {
            this.typeConversion(pCIMInstance);
        } else {
            this.setCIMInstance(pCIMInstance);
        }
    }

    @Override
    public String getClassVersion() {
        return mClassVersion;
    }

    @Override
    public String[] getKeyPropertyNames() {
        return mKeys;
    }

    @Override
    public void setUSBVersion(UnsignedInteger16 pUSBVersion) throws IllegalArgumentException {
        if (pUSBVersion == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_USBVERSION, CIMDataType.UINT16_T, pUSBVersion);
    }

    @Override
    public UnsignedInteger16 getUSBVersion() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_USBVERSION);
    }

    @Override
    public void setClassCode(UnsignedInteger8 pClassCode) throws IllegalArgumentException {
        if (pClassCode == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CLASSCODE, CIMDataType.UINT8_T, pClassCode);
    }

    @Override
    public UnsignedInteger8 getClassCode() {
        return (UnsignedInteger8)this.mCimInstance.getPropertyValue(CPN_CLASSCODE);
    }

    @Override
    public void setSubclassCode(UnsignedInteger8 pSubclassCode) throws IllegalArgumentException {
        if (pSubclassCode == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SUBCLASSCODE, CIMDataType.UINT8_T, pSubclassCode);
    }

    @Override
    public UnsignedInteger8 getSubclassCode() {
        return (UnsignedInteger8)this.mCimInstance.getPropertyValue(CPN_SUBCLASSCODE);
    }

    @Override
    public void setProtocolCode(UnsignedInteger8 pProtocolCode) throws IllegalArgumentException {
        if (pProtocolCode == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_PROTOCOLCODE, CIMDataType.UINT8_T, pProtocolCode);
    }

    @Override
    public UnsignedInteger8 getProtocolCode() {
        return (UnsignedInteger8)this.mCimInstance.getPropertyValue(CPN_PROTOCOLCODE);
    }

    @Override
    public void setNumberOfConfigs(UnsignedInteger8 pNumberOfConfigs) throws IllegalArgumentException {
        if (pNumberOfConfigs == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_NUMBEROFCONFIGS, CIMDataType.UINT8_T, pNumberOfConfigs);
    }

    @Override
    public UnsignedInteger8 getNumberOfConfigs() {
        return (UnsignedInteger8)this.mCimInstance.getPropertyValue(CPN_NUMBEROFCONFIGS);
    }

    @Override
    public void setCurrentConfigValue(UnsignedInteger8 pCurrentConfigValue) throws IllegalArgumentException {
        if (pCurrentConfigValue == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CURRENTCONFIGVALUE, CIMDataType.UINT8_T, pCurrentConfigValue);
    }

    @Override
    public UnsignedInteger8 getCurrentConfigValue() {
        return (UnsignedInteger8)this.mCimInstance.getPropertyValue(CPN_CURRENTCONFIGVALUE);
    }

    @Override
    public void setCurrentAlternateSettings(UnsignedInteger8[] pCurrentAlternateSettings) throws IllegalArgumentException {
        if (pCurrentAlternateSettings == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CURRENTALTERNATESETTINGS, CIMDataType.UINT8_ARRAY_T, pCurrentAlternateSettings);
    }

    @Override
    public UnsignedInteger8[] getCurrentAlternateSettings() {
        return (UnsignedInteger8[])this.mCimInstance.getPropertyValue(CPN_CURRENTALTERNATESETTINGS);
    }

    @Override
    public void setSystemCreationClassName(String pSystemCreationClassName) throws IllegalArgumentException {
        if (pSystemCreationClassName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SYSTEMCREATIONCLASSNAME, CIMDataType.STRING_T, pSystemCreationClassName);
    }

    @Override
    public String getSystemCreationClassName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_SYSTEMCREATIONCLASSNAME);
    }

    @Override
    public void setSystemName(String pSystemName) throws IllegalArgumentException {
        if (pSystemName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_SYSTEMNAME, CIMDataType.STRING_T, pSystemName);
    }

    @Override
    public String getSystemName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_SYSTEMNAME);
    }

    @Override
    public void setCreationClassName(String pCreationClassName) throws IllegalArgumentException {
        if (pCreationClassName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CREATIONCLASSNAME, CIMDataType.STRING_T, pCreationClassName);
    }

    @Override
    public String getCreationClassName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CREATIONCLASSNAME);
    }

    @Override
    public void setDeviceID(String pDeviceID) throws IllegalArgumentException {
        if (pDeviceID == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_DEVICEID, CIMDataType.STRING_T, pDeviceID);
    }

    @Override
    public String getDeviceID() {
        return (String)this.mCimInstance.getPropertyValue(CPN_DEVICEID);
    }

    @Override
    public void setPowerManagementSupported(Boolean pPowerManagementSupported) throws IllegalArgumentException {
        if (pPowerManagementSupported == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERMANAGEMENTSUPPORTED, CIMDataType.BOOLEAN_T, pPowerManagementSupported);
    }

    @Override
    public Boolean getPowerManagementSupported() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_POWERMANAGEMENTSUPPORTED);
    }

    @Override
    public void setPowerManagementCapabilities(UnsignedInteger16[] pPowerManagementCapabilities) throws IllegalArgumentException {
        if (pPowerManagementCapabilities == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERMANAGEMENTCAPABILITIES, CIMDataType.UINT16_ARRAY_T, pPowerManagementCapabilities);
    }

    @Override
    public UnsignedInteger16[] getPowerManagementCapabilities() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_POWERMANAGEMENTCAPABILITIES);
    }

    @Override
    public void setAvailability(UnsignedInteger16 pAvailability) throws IllegalArgumentException {
        if (pAvailability == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_AVAILABILITY, CIMDataType.UINT16_T, pAvailability);
    }

    @Override
    public UnsignedInteger16 getAvailability() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_AVAILABILITY);
    }

    @Override
    public void setStatusInfo(UnsignedInteger16 pStatusInfo) throws IllegalArgumentException {
        if (pStatusInfo == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUSINFO, CIMDataType.UINT16_T, pStatusInfo);
    }

    @Override
    public UnsignedInteger16 getStatusInfo() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_STATUSINFO);
    }

    @Override
    public void setLastErrorCode(UnsignedInteger32 pLastErrorCode) throws IllegalArgumentException {
        if (pLastErrorCode == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_LASTERRORCODE, CIMDataType.UINT32_T, pLastErrorCode);
    }

    @Override
    public UnsignedInteger32 getLastErrorCode() {
        return (UnsignedInteger32)this.mCimInstance.getPropertyValue(CPN_LASTERRORCODE);
    }

    @Override
    public void setErrorDescription(String pErrorDescription) throws IllegalArgumentException {
        if (pErrorDescription == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ERRORDESCRIPTION, CIMDataType.STRING_T, pErrorDescription);
    }

    @Override
    public String getErrorDescription() {
        return (String)this.mCimInstance.getPropertyValue(CPN_ERRORDESCRIPTION);
    }

    @Override
    public void setErrorCleared(Boolean pErrorCleared) throws IllegalArgumentException {
        if (pErrorCleared == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ERRORCLEARED, CIMDataType.BOOLEAN_T, pErrorCleared);
    }

    @Override
    public Boolean getErrorCleared() {
        return (Boolean)this.mCimInstance.getPropertyValue(CPN_ERRORCLEARED);
    }

    @Override
    public void setOtherIdentifyingInfo(String[] pOtherIdentifyingInfo) throws IllegalArgumentException {
        if (pOtherIdentifyingInfo == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OTHERIDENTIFYINGINFO, CIMDataType.STRING_ARRAY_T, pOtherIdentifyingInfo);
    }

    @Override
    public String[] getOtherIdentifyingInfo() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_OTHERIDENTIFYINGINFO);
    }

    @Override
    public void setPowerOnHours(UnsignedInteger64 pPowerOnHours) throws IllegalArgumentException {
        if (pPowerOnHours == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_POWERONHOURS, CIMDataType.UINT64_T, pPowerOnHours);
    }

    @Override
    public UnsignedInteger64 getPowerOnHours() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_POWERONHOURS);
    }

    @Override
    public void setTotalPowerOnHours(UnsignedInteger64 pTotalPowerOnHours) throws IllegalArgumentException {
        if (pTotalPowerOnHours == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TOTALPOWERONHOURS, CIMDataType.UINT64_T, pTotalPowerOnHours);
    }

    @Override
    public UnsignedInteger64 getTotalPowerOnHours() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_TOTALPOWERONHOURS);
    }

    @Override
    public void setIdentifyingDescriptions(String[] pIdentifyingDescriptions) throws IllegalArgumentException {
        if (pIdentifyingDescriptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_IDENTIFYINGDESCRIPTIONS, CIMDataType.STRING_ARRAY_T, pIdentifyingDescriptions);
    }

    @Override
    public String[] getIdentifyingDescriptions() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_IDENTIFYINGDESCRIPTIONS);
    }

    @Override
    public void setAdditionalAvailability(UnsignedInteger16[] pAdditionalAvailability) throws IllegalArgumentException {
        if (pAdditionalAvailability == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ADDITIONALAVAILABILITY, CIMDataType.UINT16_ARRAY_T, pAdditionalAvailability);
    }

    @Override
    public UnsignedInteger16[] getAdditionalAvailability() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_ADDITIONALAVAILABILITY);
    }

    @Override
    public void setMaxQuiesceTime(UnsignedInteger64 pMaxQuiesceTime) throws IllegalArgumentException {
        if (pMaxQuiesceTime == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_MAXQUIESCETIME, CIMDataType.UINT64_T, pMaxQuiesceTime);
    }

    @Override
    public UnsignedInteger64 getMaxQuiesceTime() {
        return (UnsignedInteger64)this.mCimInstance.getPropertyValue(CPN_MAXQUIESCETIME);
    }

    @Override
    public void setEnabledState(UnsignedInteger16 pEnabledState) throws IllegalArgumentException {
        if (pEnabledState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ENABLEDSTATE, CIMDataType.UINT16_T, pEnabledState);
    }

    @Override
    public UnsignedInteger16 getEnabledState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_ENABLEDSTATE);
    }

    @Override
    public void setOtherEnabledState(String pOtherEnabledState) throws IllegalArgumentException {
        if (pOtherEnabledState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OTHERENABLEDSTATE, CIMDataType.STRING_T, pOtherEnabledState);
    }

    @Override
    public String getOtherEnabledState() {
        return (String)this.mCimInstance.getPropertyValue(CPN_OTHERENABLEDSTATE);
    }

    @Override
    public void setRequestedState(UnsignedInteger16 pRequestedState) throws IllegalArgumentException {
        if (pRequestedState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_REQUESTEDSTATE, CIMDataType.UINT16_T, pRequestedState);
    }

    @Override
    public UnsignedInteger16 getRequestedState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_REQUESTEDSTATE);
    }

    @Override
    public void setEnabledDefault(UnsignedInteger16 pEnabledDefault) throws IllegalArgumentException {
        if (pEnabledDefault == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ENABLEDDEFAULT, CIMDataType.UINT16_T, pEnabledDefault);
    }

    @Override
    public UnsignedInteger16 getEnabledDefault() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_ENABLEDDEFAULT);
    }

    @Override
    public void setTimeOfLastStateChange(CIMDateTime pTimeOfLastStateChange) throws IllegalArgumentException {
        if (pTimeOfLastStateChange == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_TIMEOFLASTSTATECHANGE, CIMDataType.DATETIME_T, pTimeOfLastStateChange);
    }

    @Override
    public CIMDateTime getTimeOfLastStateChange() {
        return (CIMDateTime)this.mCimInstance.getPropertyValue(CPN_TIMEOFLASTSTATECHANGE);
    }

    @Override
    public void setInstallDate(CIMDateTime pInstallDate) throws IllegalArgumentException {
        if (pInstallDate == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_INSTALLDATE, CIMDataType.DATETIME_T, pInstallDate);
    }

    @Override
    public CIMDateTime getInstallDate() {
        return (CIMDateTime)this.mCimInstance.getPropertyValue(CPN_INSTALLDATE);
    }

    @Override
    public void setName(String pName) throws IllegalArgumentException {
        if (pName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_NAME, CIMDataType.STRING_T, pName);
    }

    @Override
    public String getName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_NAME);
    }

    @Override
    public void setOperationalStatus(UnsignedInteger16[] pOperationalStatus) throws IllegalArgumentException {
        if (pOperationalStatus == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_OPERATIONALSTATUS, CIMDataType.UINT16_ARRAY_T, pOperationalStatus);
    }

    @Override
    public UnsignedInteger16[] getOperationalStatus() {
        return (UnsignedInteger16[])this.mCimInstance.getPropertyValue(CPN_OPERATIONALSTATUS);
    }

    @Override
    public void setStatusDescriptions(String[] pStatusDescriptions) throws IllegalArgumentException {
        if (pStatusDescriptions == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUSDESCRIPTIONS, CIMDataType.STRING_ARRAY_T, pStatusDescriptions);
    }

    @Override
    public String[] getStatusDescriptions() {
        return (String[])this.mCimInstance.getPropertyValue(CPN_STATUSDESCRIPTIONS);
    }

    @Override
    public void setStatus(String pStatus) throws IllegalArgumentException {
        if (pStatus == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_STATUS, CIMDataType.STRING_T, pStatus);
    }

    @Override
    public String getStatus() {
        return (String)this.mCimInstance.getPropertyValue(CPN_STATUS);
    }

    @Override
    public void setHealthState(UnsignedInteger16 pHealthState) throws IllegalArgumentException {
        if (pHealthState == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_HEALTHSTATE, CIMDataType.UINT16_T, pHealthState);
    }

    @Override
    public UnsignedInteger16 getHealthState() {
        return (UnsignedInteger16)this.mCimInstance.getPropertyValue(CPN_HEALTHSTATE);
    }

    @Override
    public void setInstanceID(String pInstanceID) throws IllegalArgumentException {
        if (pInstanceID == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_INSTANCEID, CIMDataType.STRING_T, pInstanceID);
    }

    @Override
    public String getInstanceID() {
        return (String)this.mCimInstance.getPropertyValue(CPN_INSTANCEID);
    }

    @Override
    public void setCaption(String pCaption) throws IllegalArgumentException {
        if (pCaption == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_CAPTION, CIMDataType.STRING_T, pCaption);
    }

    @Override
    public String getCaption() {
        return (String)this.mCimInstance.getPropertyValue(CPN_CAPTION);
    }

    @Override
    public void setDescription(String pDescription) throws IllegalArgumentException {
        if (pDescription == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_DESCRIPTION, CIMDataType.STRING_T, pDescription);
    }

    @Override
    public String getDescription() {
        return (String)this.mCimInstance.getPropertyValue(CPN_DESCRIPTION);
    }

    @Override
    public void setElementName(String pElementName) throws IllegalArgumentException {
        if (pElementName == null) {
            throw new IllegalArgumentException();
        }
        this.setPropertyValue(CPN_ELEMENTNAME, CIMDataType.STRING_T, pElementName);
    }

    @Override
    public String getElementName() {
        return (String)this.mCimInstance.getPropertyValue(CPN_ELEMENTNAME);
    }

    public void initialize(ProviderHandle pHandle) throws WBEMException {
    }

    private void typeConversion(CIMInstance pInstance) {
        CIMProperty[] propList = new CIMProperty[]{new CIMProperty(CPN_USBVERSION, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_USBVERSION)), new CIMProperty(CPN_CLASSCODE, CIMDataType.UINT8_T, (Object)this.getUnsignedInteger8Value(pInstance, CPN_CLASSCODE)), new CIMProperty(CPN_SUBCLASSCODE, CIMDataType.UINT8_T, (Object)this.getUnsignedInteger8Value(pInstance, CPN_SUBCLASSCODE)), new CIMProperty(CPN_PROTOCOLCODE, CIMDataType.UINT8_T, (Object)this.getUnsignedInteger8Value(pInstance, CPN_PROTOCOLCODE)), new CIMProperty(CPN_NUMBEROFCONFIGS, CIMDataType.UINT8_T, (Object)this.getUnsignedInteger8Value(pInstance, CPN_NUMBEROFCONFIGS)), new CIMProperty(CPN_CURRENTCONFIGVALUE, CIMDataType.UINT8_T, (Object)this.getUnsignedInteger8Value(pInstance, CPN_CURRENTCONFIGVALUE)), new CIMProperty(CPN_CURRENTALTERNATESETTINGS, CIMDataType.UINT8_ARRAY_T, (Object)this.getUnsignedInteger8ArrValue(pInstance, CPN_CURRENTALTERNATESETTINGS)), new CIMProperty(CPN_POWERMANAGEMENTSUPPORTED, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_POWERMANAGEMENTSUPPORTED)), new CIMProperty(CPN_POWERMANAGEMENTCAPABILITIES, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_POWERMANAGEMENTCAPABILITIES)), new CIMProperty(CPN_AVAILABILITY, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_AVAILABILITY)), new CIMProperty(CPN_STATUSINFO, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_STATUSINFO)), new CIMProperty(CPN_LASTERRORCODE, CIMDataType.UINT32_T, (Object)this.getUnsignedInteger32Value(pInstance, CPN_LASTERRORCODE)), new CIMProperty(CPN_ERRORCLEARED, CIMDataType.BOOLEAN_T, (Object)this.getBooleanValue(pInstance, CPN_ERRORCLEARED)), new CIMProperty(CPN_POWERONHOURS, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_POWERONHOURS)), new CIMProperty(CPN_TOTALPOWERONHOURS, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_TOTALPOWERONHOURS)), new CIMProperty(CPN_ADDITIONALAVAILABILITY, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_ADDITIONALAVAILABILITY)), new CIMProperty(CPN_MAXQUIESCETIME, CIMDataType.UINT64_T, (Object)this.getUnsignedInteger64Value(pInstance, CPN_MAXQUIESCETIME)), new CIMProperty(CPN_ENABLEDSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_ENABLEDSTATE)), new CIMProperty(CPN_REQUESTEDSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_REQUESTEDSTATE)), new CIMProperty(CPN_ENABLEDDEFAULT, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_ENABLEDDEFAULT)), new CIMProperty(CPN_TIMEOFLASTSTATECHANGE, CIMDataType.DATETIME_T, (Object)this.getCIMDateTimeAbsoluteValue(pInstance, CPN_TIMEOFLASTSTATECHANGE)), new CIMProperty(CPN_INSTALLDATE, CIMDataType.DATETIME_T, (Object)this.getCIMDateTimeAbsoluteValue(pInstance, CPN_INSTALLDATE)), new CIMProperty(CPN_OPERATIONALSTATUS, CIMDataType.UINT16_ARRAY_T, (Object)this.getUnsignedInteger16ArrValue(pInstance, CPN_OPERATIONALSTATUS)), new CIMProperty(CPN_HEALTHSTATE, CIMDataType.UINT16_T, (Object)this.getUnsignedInteger16Value(pInstance, CPN_HEALTHSTATE))};
        CIMInstance tempInst = pInstance.deriveInstance(propList);
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty(CPN_SYSTEMCREATIONCLASSNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_SYSTEMCREATIONCLASSNAME)), new CIMProperty(CPN_SYSTEMNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_SYSTEMNAME)), new CIMProperty(CPN_CREATIONCLASSNAME, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_CREATIONCLASSNAME)), new CIMProperty(CPN_DEVICEID, CIMDataType.STRING_T, (Object)this.getStringValue(pInstance, CPN_DEVICEID))};
        CIMObjectPath op = pInstance.getObjectPath();
        CIMObjectPath derivedOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), keyProps, op.getXmlSchemaName());
        this.setCIMInstance(tempInst.deriveInstance(derivedOP));
    }

    private UnsignedInteger16 getUnsignedInteger16Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger16 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger16) {
                propertyValue = (UnsignedInteger16)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger16(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger8 getUnsignedInteger8Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger8 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger8) {
                propertyValue = (UnsignedInteger8)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger8(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger8[] getUnsignedInteger8ArrValue(CIMInstance pInstance, String pPropName) {
        UnsignedInteger8[] propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger8[]) {
                propertyValue = (UnsignedInteger8[])property.getValue();
            } else {
                try {
                    if (property.getValue() instanceof String[]) {
                        String[] strValueArr = (String[])property.getValue();
                        if (strValueArr != null) {
                            propertyValue = new UnsignedInteger8[strValueArr.length];
                            for (int ndx = 0; ndx < propertyValue.length; ++ndx) {
                                propertyValue[ndx] = new UnsignedInteger8(strValueArr[ndx]);
                            }
                        }
                    } else {
                        String strValue = (String)property.getValue();
                        propertyValue = new UnsignedInteger8[]{new UnsignedInteger8(strValue)};
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private String getStringValue(CIMInstance pInstance, String pPropName) {
        String propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            try {
                propertyValue = (String)property.getValue();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return propertyValue;
    }

    private Boolean getBooleanValue(CIMInstance pInstance, String pPropName) {
        Boolean propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof Boolean) {
                propertyValue = (Boolean)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new Boolean(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger16[] getUnsignedInteger16ArrValue(CIMInstance pInstance, String pPropName) {
        UnsignedInteger16[] propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger16[]) {
                propertyValue = (UnsignedInteger16[])property.getValue();
            } else {
                try {
                    if (property.getValue() instanceof String[]) {
                        String[] strValueArr = (String[])property.getValue();
                        if (strValueArr != null) {
                            propertyValue = new UnsignedInteger16[strValueArr.length];
                            for (int ndx = 0; ndx < propertyValue.length; ++ndx) {
                                propertyValue[ndx] = new UnsignedInteger16(strValueArr[ndx]);
                            }
                        }
                    } else {
                        String strValue = (String)property.getValue();
                        propertyValue = new UnsignedInteger16[]{new UnsignedInteger16(strValue)};
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger32 getUnsignedInteger32Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger32 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger32) {
                propertyValue = (UnsignedInteger32)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger32(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private UnsignedInteger64 getUnsignedInteger64Value(CIMInstance pInstance, String pPropName) {
        UnsignedInteger64 propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof UnsignedInteger64) {
                propertyValue = (UnsignedInteger64)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new UnsignedInteger64(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    private CIMDateTimeAbsolute getCIMDateTimeAbsoluteValue(CIMInstance pInstance, String pPropName) {
        CIMDateTimeAbsolute propertyValue = null;
        CIMProperty property = pInstance.getProperty(pPropName);
        if (null != property) {
            if (property.getValue() instanceof CIMDateTimeAbsolute) {
                propertyValue = (CIMDateTimeAbsolute)property.getValue();
            } else {
                try {
                    String strValue = (String)property.getValue();
                    propertyValue = new CIMDateTimeAbsolute(strValue);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        return propertyValue;
    }

    @Override
    public UnsignedInteger32 getDescriptor(UnsignedInteger8 pRequestType, UnsignedInteger16 pRequestValue, UnsignedInteger16 pRequestIndex, UnsignedInteger16 pRequestLength, UnsignedInteger8[] pBuffer) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "GetDescriptor", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 setPowerState(UnsignedInteger16 pPowerState, CIMDateTime pTime) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "SetPowerState", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 reset() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "Reset", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 enableDevice(Boolean pEnabled) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "EnableDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 onlineDevice(Boolean pOnline) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "OnlineDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 quiesceDevice(Boolean pQuiesce) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "QuiesceDevice", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 saveProperties() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "SaveProperties", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 restoreProperties() throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "RestoreProperties", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }

    @Override
    public UnsignedInteger32 requestStateChange(UnsignedInteger16 pRequestedState, CIMObjectPath pJob, CIMDateTime pTimeoutPeriod) throws WBEMException {
        try {
            CIMArgument[] inParams = null;
            CIMArgument[] outParams = null;
            Object obj = null;
            obj = this.mWBEMClient.invokeMethod(this.mCimInstance.getObjectPath(), "RequestStateChange", inParams, outParams);
            return (UnsignedInteger32)obj;
        }
        catch (Throwable t) {
            throw new WBEMException(1);
        }
    }
}

