/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.base;

import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.provider.common.Config;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.common.SubscriptionTypeEnum;
import com.cisco.dcbu.smis.provider.security.SessionFactory;
import com.cisco.dcbu.smis.provider.subscription.EventHandler;
import com.cisco.dcbu.smis.provider.subscription.Subscription;
import javax.cim.CIMArgument;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.jms.TopicSubscriber;
import javax.wbem.CloseableIterator;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.IndicationProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.provider.ProviderHandle;

public class CISCO_ProviderBase
implements InstanceProvider,
Authorizable,
MethodProvider,
AssociatorProvider,
IndicationProvider {
    protected ProviderHandle mProviderHandle;
    private TopicSubscriber _subScriber = null;
    private EventHandler _eventHandler = null;
    protected String token = null;
    static LogLevel _logger = new LogLevel();

    public void initialize(ProviderHandle pHandle) throws SMISException {
        String name1 = pHandle.getProperty("javax.wbem.provider.Principal");
        this.mProviderHandle = pHandle;
        String name2 = this.mProviderHandle.getProperty("javax.wbem.provider.Principal");
        String check = "hello";
    }

    public void close() throws SMISException {
    }

    protected void checkAccess(ProviderHandle pHandle) throws SMISException {
        String userName = pHandle.getProperty("javax.wbem.provider.Principal");
        String roleName = pHandle.getProperty("javax.wbem.provider.Role");
        String clientHost = pHandle.getProperty("javax.wbem.provider.ClientHost");
        this.token = SessionFactory.getInstance().getToken(pHandle, userName);
        if (this.token == null) {
            String s = "Failed to validate the request for user: " + userName + " from client: " + clientHost;
            LogLevel.log(30000, s);
            throw new SMISException(2, s);
        }
        if (this.token != null) {
            LogLevel.log(10000, "user: " + userName + " token: " + this.token);
        }
    }

    public CIMObjectPath createInstance(CIMInstance pCi) throws SMISException {
        throw new SMISException(7);
    }

    public void deleteInstance(CIMObjectPath pOp) throws SMISException {
        throw new SMISException(7);
    }

    public CloseableIterator enumerateInstanceNames(CIMObjectPath pOp) throws SMISException {
        throw new SMISException(7);
    }

    public CloseableIterator enumerateInstances(CIMObjectPath pOp, boolean pLocalOnly, boolean pIncludeClassOrigin, String[] pPropertyList) throws SMISException {
        throw new SMISException(7);
    }

    public CloseableIterator execQuery(CIMObjectPath pOp, String pQuery, String pQl) throws SMISException {
        throw new SMISException(7);
    }

    public CIMInstance getInstance(CIMObjectPath pOp, boolean pLocalOnly, boolean pIncludeClassOrigin, String[] pPropertyList) throws SMISException {
        CIMInstance oRet = new CIMInstance(pOp, null);
        throw new SMISException(7);
    }

    public void modifyInstance(CIMInstance pCi, String[] pPropertyList) throws SMISException {
        throw new SMISException(7);
    }

    public CloseableIterator associatorNames(CIMObjectPath pAssocName, CIMObjectPath pObjectName, String pResultClass, String pRole, String pResultRole) throws SMISException {
        throw new SMISException(7);
    }

    public CloseableIterator associators(CIMObjectPath pAssocName, CIMObjectPath pObjectName, String pResultClass, String pRole, String pResultRole, boolean pIncludeClassOrigin, String[] pPropertyList) throws SMISException {
        throw new SMISException(7);
    }

    public CloseableIterator referenceNames(CIMObjectPath pAssocName, CIMObjectPath pObjectName, String pRole) throws SMISException {
        throw new SMISException(7);
    }

    public CloseableIterator references(CIMObjectPath pAssocName, CIMObjectPath pObjectName, String pRole, boolean pIncludeClassOrigin, String[] pPropertyList) throws SMISException {
        throw new SMISException(7);
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws SMISException {
        throw new SMISException(7);
    }

    protected void checkClassIdentity(CIMObjectPath cOp, String creationClassName) throws SMISException {
        String classNameFromcOp = cOp.getObjectName();
        String classNameFromKeys = cOp.getKey(creationClassName).getValue().toString();
        if (classNameFromcOp == null || "".equals(classNameFromcOp) || classNameFromKeys == null || "".equals(classNameFromKeys)) {
            String s = "Invalid CIM ObjectPath " + cOp;
            LogLevel.log(30000, s);
            throw new SMISException(5, s);
        }
        if (!classNameFromcOp.equalsIgnoreCase(classNameFromKeys)) {
            String s = "CIM ClassName in CIM Object Path  " + classNameFromcOp + " does not match with CreationClassName " + classNameFromKeys;
            LogLevel.log(30000, s);
            throw new SMISException(5, s);
        }
    }

    protected void setSubscriber(String filterQuery) throws SMISException {
        try {
            Config config = Config.getInstance();
            this._eventHandler = EventHandler.getInstance(config.getFmAddr(), config.getFmPort());
            LogLevel.log(30000, "Setting subscriber in event handler...");
        }
        catch (Exception e) {
            String s = "Failed to setup subscription. Reason: " + e.getMessage();
            LogLevel.log(30000, s, e);
            throw new SMISException(1, s, e);
        }
    }

    protected void removeSubscriber() throws SMISException {
        try {
            this._eventHandler.removeSubscriber(this._subScriber);
            System.out.println("Removing subscriber in event handler...");
        }
        catch (Exception e) {
            String s = "Failed to remove subscription. Reason: " + e.getMessage();
            LogLevel.log(30000, s, e);
            throw new SMISException(1, s, e);
        }
    }

    protected void setProviderHandle(SubscriptionTypeEnum type, ProviderHandle pHandle) {
        Subscription sub = Subscription.getInstance();
        if (sub != null) {
            sub.addSubscription(type, pHandle);
        }
    }

    protected void removeProviderHandle(SubscriptionTypeEnum type, ProviderHandle pHandle) {
        Subscription sub = Subscription.getInstance();
        sub.deleteSubscription(type, pHandle);
    }

    public void activateFilter(CIMInstance pFilter, CIMInstance pDestination, CIMInstance pSubscription, String[] pSubFilters, CIMObjectPath[] pClassPath, String[] pEventType) throws SMISException {
        throw new SMISException(7);
    }

    public void authorizeFilter(CIMInstance pFilter, CIMInstance pListener, CIMInstance pSubscription, String[] pSubFilters, CIMObjectPath[] pClassPath, String[] pEventType) throws SMISException {
    }

    public void deActivateFilter(CIMInstance pFilter, CIMInstance pDestination, CIMInstance pSubscription, String[] pSubFilters, CIMObjectPath[] pClassPath, String[] pEventType) throws SMISException {
        throw new SMISException(7);
    }
}

