/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.client;

import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.jaxws.ep.Inventory;
import com.cisco.dcbu.smis.jaxws.ep.InventoryServiceLocator;
import com.cisco.dcbu.smis.jaxws.ep.InventoryServiceSoapBindingStub;
import com.cisco.dcbu.smis.jaxws.ep.Logon;
import com.cisco.dcbu.smis.jaxws.ep.LogonServiceLocator;
import com.cisco.dcbu.smis.jaxws.ep.Protocol;
import com.cisco.dcbu.smis.jaxws.ep.ProtocolServiceLocator;
import com.cisco.dcbu.smis.jaxws.ep.ProtocolServiceSoapBindingStub;
import com.cisco.dcbu.smis.jaxws.ep.San;
import com.cisco.dcbu.smis.jaxws.ep.SanServiceLocator;
import com.cisco.dcbu.smis.jaxws.ep.SanServiceSoapBindingStub;
import com.cisco.dcbu.smis.jaxws.ep.Statistics;
import com.cisco.dcbu.smis.jaxws.ep.StatisticsServiceLocator;
import com.cisco.dcbu.smis.jaxws.ep.StatisticsServiceSoapBindingStub;
import com.cisco.dcbu.smis.jaxws.ep.ZoneManager;
import com.cisco.dcbu.smis.jaxws.ep.ZoneManagerServiceLocator;
import com.cisco.dcbu.smis.jaxws.ep.ZoneManagerServiceSoapBindingStub;
import com.cisco.dcbu.smis.provider.client.ReferenceIf;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import java.rmi.RemoteException;
import org.apache.axis.message.SOAPHeaderElement;

class WSReference
implements ReferenceIf {
    private static WSReference _Instance = null;
    String _server;
    int _httpPort;
    boolean _useSSL;
    static LogLevel _logger = new LogLevel();

    static WSReference getInstance(String server, int httpPort, boolean useSSL) throws RemoteException {
        if (_Instance == null || !WSReference._Instance._server.equals(server) || WSReference._Instance._httpPort != httpPort || WSReference._Instance._useSSL != useSSL) {
            _Instance = new WSReference(server, httpPort, useSSL);
        }
        return _Instance;
    }

    static WSReference getNewInstance(String server, int httpPort, boolean useSSL) throws RemoteException {
        _Instance = new WSReference(server, httpPort, useSSL);
        return _Instance;
    }

    private WSReference(String server, int httpPort, boolean useSSL) throws RemoteException {
        this._server = server;
        this._httpPort = httpPort;
        this._useSSL = useSSL;
    }

    private String getURL() {
        String ret = this._useSSL ? "https" : "http";
        ret = ret + "://" + this._server + ":" + this._httpPort;
        LogLevel.log(10000, "ws URL:" + ret);
        return ret;
    }

    @Override
    public Logon getLogon() throws Exception {
        String loginServiceAddr = this.getURL() + "/LogonWSService/LogonWS";
        Logon _logon = null;
        LogonServiceLocator logonService = new LogonServiceLocator();
        try {
            logonService.setEndpointAddress("LogonPort", loginServiceAddr);
            _logon = logonService.getLogonPort();
            if (null == _logon) {
                LogLevel.log(30000, "Logon service not available");
                throw new SMISException("Logon service not available");
            }
            return _logon;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SMISException(e.getMessage(), e);
        }
    }

    @Override
    public San getSan(String token) throws Exception {
        String sanServiceAddr = this.getURL() + "/SanWSService/SanWS";
        SanServiceLocator sanService = new SanServiceLocator();
        try {
            sanService.setEndpointAddress("SanPort", sanServiceAddr);
            San _san = sanService.getSanPort();
            if (null == _san) {
                LogLevel.log(30000, "San service not available");
                throw new SMISException("San service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            SanServiceSoapBindingStub sService = (SanServiceSoapBindingStub)_san;
            sService.setHeader(hdrElement);
            return _san;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SMISException(e.getMessage(), e);
        }
    }

    private SOAPHeaderElement setSoapHeader(String token) {
        SOAPHeaderElement hdrElement = new SOAPHeaderElement("http://ep.cisco.dcbu.cisco.com", "token");
        hdrElement.setPrefix("m");
        hdrElement.setMustUnderstand(false);
        hdrElement.setValue(token);
        return hdrElement;
    }

    @Override
    public Inventory getInventory(String token) throws Exception {
        String inventoryServiceAddr = this.getURL() + "/InventoryWSService/InventoryWS";
        InventoryServiceLocator inventoryService = new InventoryServiceLocator();
        try {
            inventoryService.setEndpointAddress("InventoryPort", inventoryServiceAddr);
            Inventory _inventory = inventoryService.getInventoryPort();
            if (null == _inventory) {
                LogLevel.log(30000, "Inventory service not available");
                throw new SMISException("Inventory service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            InventoryServiceSoapBindingStub sService = (InventoryServiceSoapBindingStub)_inventory;
            sService.setHeader(hdrElement);
            return _inventory;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SMISException(e.getMessage(), e);
        }
    }

    @Override
    public Protocol getProtocol(String token) throws Exception {
        String protocolServiceAddr = this.getURL() + "/ProtocolWSService/ProtocolWS";
        ProtocolServiceLocator protocolService = new ProtocolServiceLocator();
        try {
            protocolService.setEndpointAddress("ProtocolPort", protocolServiceAddr);
            Protocol _protocol = protocolService.getProtocolPort();
            if (null == _protocol) {
                LogLevel.log(30000, "Protocol service not available");
                throw new SMISException("Protocol service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            ProtocolServiceSoapBindingStub sService = (ProtocolServiceSoapBindingStub)_protocol;
            sService.setHeader(hdrElement);
            return _protocol;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SMISException(e.getMessage(), e);
        }
    }

    @Override
    public Statistics getStatistics(String token) throws Exception {
        String statisticsServiceAddr = this.getURL() + "/StatisticsWSService/StatisticsWS";
        StatisticsServiceLocator statisticsService = new StatisticsServiceLocator();
        try {
            statisticsService.setEndpointAddress("StatisticsPort", statisticsServiceAddr);
            Statistics _statistics = statisticsService.getStatisticsPort();
            if (null == _statistics) {
                LogLevel.log(30000, "Statistics service not available");
                throw new SMISException("Statistics service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            StatisticsServiceSoapBindingStub sService = (StatisticsServiceSoapBindingStub)_statistics;
            sService.setHeader(hdrElement);
            return _statistics;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SMISException(e.getMessage(), e);
        }
    }

    @Override
    public ZoneManager getZoneManager(String token) throws Exception {
        String zoneServiceAddr = this.getURL() + "/ZoneManagerWSService/ZoneManagerWS";
        ZoneManagerServiceLocator zoneManagerService = new ZoneManagerServiceLocator();
        try {
            zoneManagerService.setEndpointAddress("ZoneManagerPort", zoneServiceAddr);
            ZoneManager _zone = zoneManagerService.getZoneManagerPort();
            if (null == _zone) {
                LogLevel.log(30000, "Zone Manager service not available");
                throw new SMISException("Zone Manager service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            ZoneManagerServiceSoapBindingStub zService = (ZoneManagerServiceSoapBindingStub)_zone;
            zService.setHeader(hdrElement);
            return _zone;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SMISException(e.getMessage(), e);
        }
    }
}

