/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.helper;

import com.cisco.dcbu.sm.common.event.smis.TempChange;
import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.common.SubscriptionTypeEnum;
import com.cisco.dcbu.smis.provider.helper.IndicationProviderHelper;
import com.cisco.dcbu.smis.provider.helper.MappingHelper;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;

public class CISCO_TempAlertHelper
extends IndicationProviderHelper {
    private static final int NUM_KEYS = 1;
    private static final String CLS_TEMPALERT = "CISCO_TempAlert";

    @Override
    public final String cimClassName() {
        return CLS_TEMPALERT;
    }

    public final int numKeys() {
        return 1;
    }

    @Override
    public void deliverEvent(Object eventObj) {
        if (eventObj instanceof TempChange) {
            TempChange event = (TempChange)eventObj;
            try {
                CIMInstance inst = this.getInstance(event);
                this.deliverEvent(SubscriptionTypeEnum.TempAlert, inst);
            }
            catch (SMISException e) {
                String s = "Failed to deliver event: " + e.getMessage();
                LogLevel.log(30000, s, (Throwable)((Object)e));
            }
        } else {
            LogLevel.log(30000, "Invalid Event Type");
        }
    }

    @Override
    public CIMObjectPath getPath() throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            CIMProperty[] keyProps = new CIMProperty[]{};
            CIMObjectPath opNew = new CIMObjectPath(CLS_TEMPALERT, this._namespace, keyProps);
            return opNew;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage(), e);
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    @Override
    public CIMInstance getInstance(Object obj) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            TempChange event = (TempChange)obj;
            String swWwn = MappingHelper.smisWwnFormat(event.getSwWwn());
            int phyIndex = event.getPhyIndex();
            String fabric = event.getFabricName();
            int sensorValue = event.getSensorValue();
            int thresholdIndex = event.getThresholdIndex();
            int threshfoldValue = event.getThreshfoldValue();
            String description = "Switch " + swWwn + " has environmental Temperature sensor failure in Fabric " + fabric + " (Status: " + sensorValue + ")";
            CIMObjectPath opNew = this.getPath();
            CIMProperty[] props = new CIMProperty[]{new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false, false, "CISCO_AlertIndication"), new CIMProperty("IndicationIdentifier", CIMDataType.STRING_T, (Object)Long.toString(CISCO_TempAlertHelper.getIndicationId()), false, false, "CISCO_AlertIndication"), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)swWwn, false, false, "CIM_AlertIndication"), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"CISCO_PhysicalComputerSystem", false, false, "CIM_AlertIndication"), new CIMProperty("AlertingElementFormat", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(2), false, false, "CIM_AlertIndication"), new CIMProperty("AlertingAdminDomain", CIMDataType.STRING_T, (Object)fabric, false, false, "CISCO_AlertIndication"), new CIMProperty("AlertingManagedElement", CIMDataType.STRING_T, (Object)this.getPhysicalComputerSystemObjectPath(swWwn), true, false, "CIM_AlertIndication"), new CIMProperty("AlertType", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(6), false, false, "CISCO_AlertIndication"), new CIMProperty("PerceivedSeverity", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(4), false, false, "CISCO_AlertIndication"), new CIMProperty("OtherAlertType", CIMDataType.STRING_T, (Object)"Environment Alert", false, false, "CISCO_AlertIndication"), new CIMProperty("ProbableCause", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(1), true, false, "CISCO_AlertIndication"), new CIMProperty("DebugLevel", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(5), false, false, "CISCO_AlertIndication"), new CIMProperty("ProviderName", CIMDataType.STRING_T, (Object)"CISCO_TempAlertProvider", false, false, "CIM_AlertIndication"), new CIMProperty("Description", CIMDataType.STRING_T, (Object)description, false, false, "CISCO_AlertIndication"), new CIMProperty("PhysicalIndex", CIMDataType.UINT32_T, (Object)mappingHelper.intToUnsignedInteger32(phyIndex), false, false, CLS_TEMPALERT), new CIMProperty("SensorValue", CIMDataType.UINT32_T, (Object)mappingHelper.intToUnsignedInteger32(sensorValue), false, false, CLS_TEMPALERT), new CIMProperty("SensorThresholdIndex", CIMDataType.UINT32_T, (Object)mappingHelper.intToUnsignedInteger32(thresholdIndex), false, false, CLS_TEMPALERT), new CIMProperty("SensorThresholdValue", CIMDataType.UINT32_T, (Object)mappingHelper.intToUnsignedInteger32(threshfoldValue), false, false, CLS_TEMPALERT)};
            CIMInstance newInst = new CIMInstance(opNew, props);
            return newInst;
        }
        catch (ClassCastException cce) {
            String s = "Error: Unknown object type: " + cce.getMessage();
            LogLevel.log(30000, s, cce);
            throw new SMISException(1, s, cce);
        }
        catch (SMISException se) {
            throw se;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage(), e);
            throw new SMISException(1, e.getMessage(), e);
        }
    }
}

