/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.helper;

import com.cisco.dcbu.sm.common.event.smis.SwitchChange;
import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.jaxws.ep.EndPort;
import com.cisco.dcbu.smis.jaxws.ep.VsanFcID;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.common.SubscriptionTypeEnum;
import com.cisco.dcbu.smis.provider.helper.MappingHelper;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.provider.ProviderHandle;

public abstract class IndicationProviderHelper {
    static LogLevel _logger = new LogLevel();
    static long indicationId = 1L;
    private static final String CLS_ENDPORT = "CISCO_EndPort";
    protected String _token = null;
    protected String _namespace = "cimv2";

    public abstract String cimClassName();

    public abstract CIMObjectPath getPath() throws SMISException;

    public abstract CIMInstance getInstance(Object var1) throws SMISException;

    public abstract void deliverEvent(Object var1);

    public void setToken(String tok) {
        this._token = tok;
    }

    public void deliverEvent(SubscriptionTypeEnum type, CIMInstance inst) {
    }

    public void deliverEvent(ProviderHandle pHandle, SubscriptionTypeEnum type) {
        try {
            pHandle.deliverEvent(this.getInstance((Object)type));
        }
        catch (SMISException e) {
            e.printStackTrace();
        }
    }

    public void setNamespace(String ns) {
        this._namespace = ns;
    }

    protected static synchronized long getIndicationId() {
        return indicationId++;
    }

    protected int getPortnumberFromIfIndex(int ifIndex) {
        if (this.ifIndex2Card(ifIndex) > -1) {
            return (this.ifIndex2Card(ifIndex) + 1) * 100 + (this.ifIndex2Port(ifIndex) + 1);
        }
        return 0;
    }

    protected String getEndPortPath(EndPort port) throws SMISException {
        try {
            MappingHelper helper = new MappingHelper();
            String id = MappingHelper.smisWwnFormat(port.getKey().getWwn().getValue());
            LogLevel.info("EndPort ID: " + id + " VsanID: " + port.getVsanId());
            String hostwwn = MappingHelper.smisWwnFormat(port.getNWwn().getValue());
            CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)id, true, false, "CIM_LogicalDevice"), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)CLS_ENDPORT, true, false, "CIM_LogicalDevice"), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"CISCO_HostComputerSystem", true, false, "CIM_LogicalDevice"), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)hostwwn, true, false, "CIM_LogicalDevice")};
            CIMObjectPath opNew = new CIMObjectPath(CLS_ENDPORT, this._namespace, keyProps);
            return opNew.toString();
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage());
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    protected CIMInstance getEndPortInstance(EndPort fcport) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            String ename = fcport.getSymPortName();
            if (ename == null) {
                ename = fcport.getIfName();
            }
            String comp = null;
            comp = fcport.isHost() ? "CISCO_HostComputerSystem" : "CISCO_StorageComputerSystem";
            int portNumber = this.getPortnumberFromIfIndex(fcport.getFPortKey().getIndex());
            int portType = mappingHelper.getPortType(fcport.getOperMode(), this.getType(fcport.getFPortKey().getIndex()));
            String hostwwn = MappingHelper.smisWwnFormat(fcport.getNWwn().getValue());
            CIMProperty[] cIMPropertyArray = new CIMProperty[4];
            cIMPropertyArray[0] = new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)MappingHelper.smisWwnFormat(fcport.getKey().getWwn().getValue()), true, false, "CIM_LogicalDevice");
            cIMPropertyArray[1] = new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)CLS_ENDPORT, true, false, "CIM_LogicalDevice");
            cIMPropertyArray[2] = new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)comp, true, false, "CIM_LogicalDevice");
            cIMPropertyArray[3] = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)hostwwn, true, false, "CIM_LogicalDevice");
            CIMProperty[] keyProps = cIMPropertyArray;
            CIMObjectPath opNew = new CIMObjectPath(CLS_ENDPORT, this._namespace, keyProps);
            CIMProperty[] cIMPropertyArray2 = new CIMProperty[21];
            cIMPropertyArray2[0] = new CIMProperty("Caption", CIMDataType.STRING_T, (Object)fcport.getDisplayName(), false, false, "CIM_ManagedElement");
            cIMPropertyArray2[1] = new CIMProperty("Description", CIMDataType.STRING_T, (Object)fcport.getDisplayName(), false, false, "CIM_ManagedElement");
            cIMPropertyArray2[2] = new CIMProperty("Name", CIMDataType.STRING_T, (Object)fcport.getIfName(), false, false, "CIM_ManagedSystemElement");
            cIMPropertyArray2[3] = new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)mappingHelper.mapOperationalStatus(fcport.getIfOperStatus()), false, false, "CIM_ManagedSystemElement");
            cIMPropertyArray2[4] = new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(2), false, false, "CIM_EnabledLogicalElement");
            cIMPropertyArray2[5] = new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(2), false, false, "CIM_EnabledLogicalElement");
            cIMPropertyArray2[6] = new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(5), false, false, "CIM_EnabledLogicalElement");
            cIMPropertyArray2[7] = new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"CISCO_HostComputerSystem", true, false, "CIM_LogicalDevice");
            cIMPropertyArray2[8] = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)hostwwn, true, false, "CIM_LogicalDevice");
            cIMPropertyArray2[9] = new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)CLS_ENDPORT, true, false, "CIM_LogicalDevice");
            cIMPropertyArray2[10] = new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)MappingHelper.smisWwnFormat(fcport.getKey().getWwn().getValue()), true, false, "CIM_LogicalDevice");
            cIMPropertyArray2[11] = new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)ename, false, false, "CIM_ManagedElement");
            cIMPropertyArray2[12] = new CIMProperty("PortType", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(portType), false, false, "CISCO_FCPort");
            cIMPropertyArray2[13] = new CIMProperty("Speed", CIMDataType.UINT64_T, (Object)mappingHelper.longToUnsignedInteger64(fcport.getSpeed()), false, false, "CIM_NetworkPort");
            cIMPropertyArray2[14] = new CIMProperty("LinkTechnology", CIMDataType.UINT16_T, (Object)mappingHelper.intToUnsignedInteger16(4), false, false, "CIM_NetworkPort");
            cIMPropertyArray2[15] = new CIMProperty("NetworkAddresses", CIMDataType.STRING_ARRAY_T, (Object)this.mapVsanFcIdstoStringArray(fcport.getVsanFcIds()), false, false, "CIM_NetworkPort");
            cIMPropertyArray2[16] = new CIMProperty("SupportedCOS", CIMDataType.UINT16_ARRAY_T, (Object)mappingHelper.intToUnsignedInteger16Array(2), false, false, "CIM_FCPort");
            cIMPropertyArray2[17] = new CIMProperty("SupportedFC4Types", CIMDataType.UINT16_ARRAY_T, (Object)mappingHelper.intToUnsignedInteger16Array(17), false, false, "CIM_FCPort");
            cIMPropertyArray2[18] = new CIMProperty("ActiveFC4Types", CIMDataType.UINT16_ARRAY_T, (Object)mappingHelper.intToUnsignedInteger16Array(17), false, false, "CIM_FCPort");
            cIMPropertyArray2[19] = new CIMProperty("PermanentAddress", CIMDataType.STRING_T, (Object)MappingHelper.smisWwnFormat(fcport.getFWwn().getValue()), false, false, "CIM_NetworkPort");
            cIMPropertyArray2[20] = new CIMProperty("PortNumber", CIMDataType.UINT16_T, (Object)(portNumber > 0 ? mappingHelper.intToUnsignedInteger16(portNumber) : null), false, false, "CIM_NetworkPort");
            CIMProperty[] props = cIMPropertyArray2;
            CIMInstance newInst = new CIMInstance(opNew, props);
            return newInst;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage(), e);
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    protected String getPhysicalComputerSystemObjectPath(String swWwn) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            CIMProperty[] cIMPropertyArray = new CIMProperty[2];
            cIMPropertyArray[0] = new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"CISCO_PhysicalComputerSystem", true, false, "CIM_LogicalDevice");
            cIMPropertyArray[1] = new CIMProperty("Name", CIMDataType.STRING_T, (Object)MappingHelper.smisWwnFormat(swWwn), true, false, "CIM_LogicalDevice");
            CIMProperty[] keyProps = cIMPropertyArray;
            CIMObjectPath opNew = new CIMObjectPath("CISCO_PhysicalComputerSystem", this._namespace, keyProps);
            return opNew.toString();
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage());
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    protected CIMInstance getPhysicalComputerSystemInstance(SwitchChange eventObj) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            CIMProperty[] cIMPropertyArray = new CIMProperty[2];
            cIMPropertyArray[0] = new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"CISCO_PhysicalComputerSystem", true, false, "CIM_LogicalDevice");
            cIMPropertyArray[1] = new CIMProperty("Name", CIMDataType.STRING_T, (Object)MappingHelper.smisWwnFormat(eventObj.getSwWwn()), true, false, "CIM_LogicalDevice");
            CIMProperty[] keyProps = cIMPropertyArray;
            CIMObjectPath opNew = new CIMObjectPath("CISCO_PhysicalComputerSystem", this._namespace, keyProps);
            String name = null;
            name = eventObj.getSwichState() == 0 ? MappingHelper.smisWwnFormat(eventObj.getSwWwn()) + "is Added in to fabric" : MappingHelper.smisWwnFormat(eventObj.getSwWwn()) + "is Removed in the fabric";
            UnsignedInteger16[] dedicated = new UnsignedInteger16[]{new UnsignedInteger16(5), new UnsignedInteger16(0)};
            String[] dedicatedDesc = new String[]{new String("Switch"), new String("Not Dedicated")};
            CIMProperty[] props = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"CISCO_PhysicalComputerSystem", true, false, "CIM_System"), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)name, false, false, "CIM_ManagedElement"), new CIMProperty("Description", CIMDataType.STRING_T, (Object)name, false, false, "CIM_ManagedElement"), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)name, false, false, "CIM_ManagedElement"), new CIMProperty("InstallDate", CIMDataType.DATETIME_T, null, false, false, "CIM_ManagedSystemElement"), new CIMProperty("StatusDescriptions", CIMDataType.STRING_T, null, false, false, "CIM_ManagedSystemElement"), new CIMProperty("Status", CIMDataType.STRING_T, null, false, false, "CIM_ManagedSystemElement"), new CIMProperty("OtherEnabledState", CIMDataType.STRING_T, null, false, false, "CIM_EnabledLogicalElement"), new CIMProperty("TimeOfLastStateChange", CIMDataType.DATETIME_T, null, false, false, "CIM_ManagedSystemElement"), new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true, false, "CIM_System"), new CIMProperty("PrimaryOwnerName", CIMDataType.STRING_T, null, false, false, "CIM_System"), new CIMProperty("PrimaryOwnerContact", CIMDataType.STRING_T, null, false, false, "CIM_System"), new CIMProperty("Roles", CIMDataType.STRING_T, null, false, false, "CIM_System"), new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)"WWN", false, false, "CIM_ComputerSystem"), new CIMProperty("ResetCapability", CIMDataType.UINT16_T, null, false, false, "CIM_ComputerSystem"), new CIMProperty("IpAddress", CIMDataType.STRING_T, (Object)eventObj.getIpAddress(), false, false, "CIM_ManagedElement"), new CIMProperty("Dedicated", CIMDataType.UINT16_ARRAY_T, (Object)dedicated, false, false, "CIM_ComputerSystem"), new CIMProperty("OtherDedicatedDescriptions", CIMDataType.STRING_ARRAY_T, (Object)dedicatedDesc, false, false, "CIM_ComputerSystem")};
            CIMInstance newInst = new CIMInstance(opNew, props);
            return newInst;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage(), e);
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    protected String getLogicalModuleObjectPath(String swWwn, int phyIndex) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            CIMProperty[] cIMPropertyArray = new CIMProperty[4];
            cIMPropertyArray[0] = new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)mappingHelper.intToString(phyIndex), true, false, "CIM_LogicalDevice");
            cIMPropertyArray[1] = new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"CISCO_PhysicalComputerSystem", true, false, "CIM_LogicalDevice");
            cIMPropertyArray[2] = new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"CISCO_LogicalModule", true, false, "CIM_LogicalDevice");
            cIMPropertyArray[3] = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)MappingHelper.smisWwnFormat(swWwn), true, false, "CIM_LogicalDevice");
            CIMProperty[] keyProps = cIMPropertyArray;
            CIMObjectPath opNew = new CIMObjectPath("CISCO_LogicalModule", this._namespace, keyProps);
            return opNew.toString();
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage());
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    protected String getFcPortObjectPath(String swWwn, int ifIndex) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            CIMProperty[] cIMPropertyArray = new CIMProperty[4];
            cIMPropertyArray[0] = new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)mappingHelper.intToString(ifIndex), true, false, "CIM_LogicalDevice");
            cIMPropertyArray[1] = new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"CISCO_PhysicalComputerSystem", true, false, "CIM_LogicalDevice");
            cIMPropertyArray[2] = new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"CISCO_FcPort", true, false, "CIM_LogicalDevice");
            cIMPropertyArray[3] = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)MappingHelper.smisWwnFormat(swWwn), true, false, "CIM_LogicalDevice");
            CIMProperty[] keyProps = cIMPropertyArray;
            CIMObjectPath opNew = new CIMObjectPath("CISCO_FcPort", this._namespace, keyProps);
            return opNew.toString();
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage());
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    public String getPortObjectPath(String swWwn, int ifIndex) throws SMISException {
        Object cop = null;
        int type = this.getType(ifIndex);
        if (type == 2 || type == 5 || type == 11 || type == 22 || type == 26) {
            return this.getEthernetPortObjectPath(swWwn, ifIndex);
        }
        return this.getFcPortObjectPath(swWwn, ifIndex);
    }

    protected String getEthernetPortObjectPath(String swWwn, int ifIndex) throws SMISException {
        try {
            MappingHelper mappingHelper = new MappingHelper();
            CIMProperty[] cIMPropertyArray = new CIMProperty[4];
            cIMPropertyArray[0] = new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)mappingHelper.intToString(ifIndex), true, false, "CIM_LogicalDevice");
            cIMPropertyArray[1] = new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"CISCO_PhysicalComputerSystem", true, false, "CIM_LogicalDevice");
            cIMPropertyArray[2] = new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"CISCO_EthernetPort", true, false, "CIM_LogicalDevice");
            cIMPropertyArray[3] = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)MappingHelper.smisWwnFormat(swWwn), true, false, "CIM_LogicalDevice");
            CIMProperty[] keyProps = cIMPropertyArray;
            CIMObjectPath opNew = new CIMObjectPath("CISCO_EthernetPort", this._namespace, keyProps);
            return opNew.toString();
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage());
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    public int getType(int ifIndex) {
        return ifIndex >> 24;
    }

    protected int ifIndex2Card(int ifIndex) {
        int type = this.getType(ifIndex);
        if (type == 10 || type == 4 || type == 5) {
            return -1;
        }
        if (type == 31 || type == 30) {
            return ifIndex >> 12 & 0xF;
        }
        return ifIndex >> 19 & 0x1F;
    }

    protected int ifIndex2Port(int ifIndex) {
        int type = this.getType(ifIndex);
        if (type == 31 || type == 30) {
            return ifIndex >> 6 & 0x3F;
        }
        return ifIndex >> 12 & 0x7F;
    }

    private String[] mapVsanFcIdstoStringArray(VsanFcID[] vsanFcids) {
        if (vsanFcids != null) {
            String[] fcids = new String[vsanFcids.length];
            for (int i = 0; i < vsanFcids.length; ++i) {
                fcids[i] = Integer.toHexString(vsanFcids[i].getFcID()).toUpperCase();
            }
            return fcids;
        }
        return null;
    }
}

