/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.helper;

import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.jaxws.ep.InetAddressType;
import com.cisco.dcbu.smis.provider.common.Config;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.helper.MappingUtil;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

public class MappingHelper
extends MappingUtil {
    static LogLevel _logger = new LogLevel();

    public int fabricManagedToHealthState(boolean managed) {
        return managed ? 5 : 10;
    }

    public UnsignedInteger8 intToUnsignedInteger8(int in) {
        UnsignedInteger8 out = new UnsignedInteger8(Integer.toString(in));
        return out;
    }

    public UnsignedInteger8[] intArrayToUnsignedInteger8Array(int[] in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger8[] out = new UnsignedInteger8[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = new UnsignedInteger8(Integer.toString(in[i]));
        }
        return out;
    }

    public UnsignedInteger8[] intToUnsignedInteger8Array(int in) {
        UnsignedInteger8[] out = new UnsignedInteger8[]{new UnsignedInteger8(Integer.toString(in))};
        return out;
    }

    public UnsignedInteger16 intToUnsignedInteger16(int in) {
        UnsignedInteger16 out = new UnsignedInteger16(Integer.toString(in));
        return out;
    }

    public int unsignedInteger16ToInt(UnsignedInteger16 in) {
        int out = in.intValue();
        return out;
    }

    public UnsignedInteger16[] intArrayToUnsignedInteger16Array(int[] in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger16[] out = new UnsignedInteger16[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = new UnsignedInteger16(Integer.toString(in[i]));
        }
        return out;
    }

    public UnsignedInteger16[] integerArrayToUnsignedInteger16Array(Integer[] in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger16[] out = new UnsignedInteger16[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = new UnsignedInteger16(Integer.toString(in[i]));
        }
        return out;
    }

    public UnsignedInteger16[] intToUnsignedInteger16Array(int in) {
        UnsignedInteger16[] out = new UnsignedInteger16[]{new UnsignedInteger16(Integer.toString(in))};
        return out;
    }

    public UnsignedInteger32 intToUnsignedInteger32(int in) {
        Long ln = 0xFFFFFFFFL & (long)in;
        UnsignedInteger32 out = new UnsignedInteger32(Long.toString(ln));
        return out;
    }

    public UnsignedInteger32[] intArrayToUnsignedInteger32Array(int[] in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger32[] out = new UnsignedInteger32[in.length];
        for (int i = 0; i < in.length; ++i) {
            long ln = 0xFFFFFFFFL & (long)in[i];
            out[i] = new UnsignedInteger32(Long.toString(ln));
        }
        return out;
    }

    public UnsignedInteger32[] intToUnsignedInteger32Array(int in) {
        UnsignedInteger32[] out = new UnsignedInteger32[1];
        long ln = 0xFFFFFFFFL & (long)in;
        out[0] = new UnsignedInteger32(Long.toString(ln));
        return out;
    }

    public UnsignedInteger64[] longArrayToUnsignedInteger64Array(Long[] in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger64[] out = new UnsignedInteger64[in.length];
        for (int i = 0; i < in.length; ++i) {
            BigInteger bi = new BigInteger(1, ByteBuffer.allocate(8).putLong(in[i]).array());
            out[i] = new UnsignedInteger64(bi.toString());
        }
        return out;
    }

    public UnsignedInteger64 longToUnsignedInteger64(long in) {
        UnsignedInteger64 out = new UnsignedInteger64(new BigInteger(1, ByteBuffer.allocate(8).putLong(in).array()));
        return out;
    }

    public UnsignedInteger16 shortToUnsignedInteger16(Short in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger16 out = new UnsignedInteger16(in.toString());
        return out;
    }

    public UnsignedInteger64[] longArrayToUnsignedInteger64Array(long[] in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger64[] out = new UnsignedInteger64[in.length];
        for (int i = 0; i < in.length; ++i) {
            BigInteger bi = new BigInteger(1, ByteBuffer.allocate(8).putLong(in[i]).array());
            out[i] = new UnsignedInteger64(bi);
        }
        return out;
    }

    public UnsignedInteger64[] longToUnsignedInteger64Array(long in) {
        UnsignedInteger64[] out = new UnsignedInteger64[]{new UnsignedInteger64(new BigInteger(1, ByteBuffer.allocate(8).putLong(in).array()))};
        return out;
    }

    public CIMDateTimeAbsolute longToCIMDateTimeAbsolute(long in) {
        Long longIn = new Long(in);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSSSSS");
        Date date = new Date(longIn);
        int offset = TimeZone.getDefault().getOffset(longIn);
        int offsetTime = offset / 1000 / 60;
        String offsetValue = null;
        if (offset > 0) {
            offsetValue = String.valueOf(offsetTime);
            offsetValue = "+".concat(offsetValue);
        } else {
            offsetValue = String.valueOf(offsetTime);
        }
        String str_date = df.format(date);
        str_date = str_date.concat(offsetValue);
        int length = str_date.length();
        if (length < 25) {
            str_date = str_date.concat("0");
        }
        CIMDateTimeAbsolute out = new CIMDateTimeAbsolute(str_date);
        return out;
    }

    public CIMDateTimeInterval longToCIMDateTimeInterval(long in) {
        CIMDateTimeInterval out = new CIMDateTimeInterval(in);
        return out;
    }

    public CIMDateTimeAbsolute[] longArrayToCIMDateTimeAbsoluteArray(long[] in) {
        if (in == null) {
            return null;
        }
        CIMDateTimeAbsolute[] out = new CIMDateTimeAbsolute[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = this.longToCIMDateTimeAbsolute(in[i]);
        }
        return out;
    }

    public CIMDateTimeInterval[] longArrayToCIMDateTimeIntervalArray(long[] in) {
        if (in == null) {
            return null;
        }
        CIMDateTimeInterval[] out = new CIMDateTimeInterval[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = this.longToCIMDateTimeInterval(in[i]);
        }
        return out;
    }

    public String VsanOperStatus(byte status) {
        String OPER_UP = "OK";
        String OPER_DOWN = "Degraded";
        String conv_Status = "Invalid Status";
        if (status == 1) {
            conv_Status = "OK";
        } else if (status == 2) {
            conv_Status = "Degraded";
        }
        return conv_Status;
    }

    public UnsignedInteger16[] VsanOperState(byte status) {
        UnsignedInteger16[] out = new UnsignedInteger16[]{status == 1 ? new UnsignedInteger16(2) : (status == 2 ? new UnsignedInteger16(6) : new UnsignedInteger16(0))};
        return out;
    }

    public Boolean getFCPortSettingsAutoSenseSpeed(long speed) {
        Boolean conv_speed = Boolean.FALSE;
        if (speed == 0L) {
            conv_speed = Boolean.TRUE;
        } else if (speed != 0L) {
            conv_speed = Boolean.FALSE;
        }
        return conv_speed;
    }

    public Boolean getSACKSupport(int selectiveACK) {
        if (selectiveACK == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getVsanInteropMode(byte interopMode) {
        String Mode2 = "";
        if (interopMode == 0) {
            Mode2 = "Default";
        } else if (interopMode == 1) {
            Mode2 = "Interop-1";
        } else if (interopMode == 2) {
            Mode2 = "Interop-2";
        } else if (interopMode == 3) {
            Mode2 = "Interop-3";
        } else if (interopMode == 4) {
            Mode2 = "Interop-4";
        }
        return Mode2;
    }

    public String getVsanLoadBalancingType(byte loadBalancingType) {
        String type = "";
        if (loadBalancingType == 1) {
            type = "src-id/dst-id";
        } else if (loadBalancingType == 2) {
            type = "src-id/dst-id/ox-id";
        }
        return type;
    }

    public String getElementName(String VersionString) {
        if (VersionString != null) {
            return VersionString.charAt(0) <= '3' ? "SAN OS" : "NX-OS";
        }
        return null;
    }

    public static boolean isCOPKeyNull(CIMObjectPath cop, String propertyName) {
        boolean isNull = true;
        if (cop.getKey(propertyName) != null && cop.getKey(propertyName).getValue() != null) {
            isNull = false;
        }
        return isNull;
    }

    public String AdminDomainStatus(boolean status) {
        String OPER_UP = "Up";
        String OPER_DOWN = "Down";
        String conv_Status = "Invalid Status";
        if (status) {
            conv_Status = "Up";
        } else if (!status) {
            conv_Status = "Down";
        }
        return conv_Status;
    }

    public static ArrayList<String> getFMValuesFromCopKey(CIMObjectPath cOp, String keyName) throws SMISException {
        String keyValue = "";
        String fmvalue = "";
        ArrayList<String> tokens = new ArrayList<String>();
        String delimiter = "\\";
        String delvalue = Config.getInstance().getDelimiter();
        if (delvalue != null) {
            delimiter = delvalue;
        }
        if (!MappingHelper.isCOPKeyNull(cOp, keyName)) {
            keyValue = (String)cOp.getKey(keyName).getValue();
            StringTokenizer st = new StringTokenizer(keyValue, delimiter);
            while (st.hasMoreElements()) {
                fmvalue = st.nextToken();
                if (fmvalue == null || "".equals(fmvalue)) {
                    String s = "Null FM value from COP Key by name " + keyName;
                    throw new SMISException(1, s);
                }
                tokens.add(fmvalue);
            }
        }
        return tokens;
    }

    public UnsignedInteger16 stringToUnsignedInteger16(String in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger16 out = new UnsignedInteger16(in);
        return out;
    }

    public UnsignedInteger16[] stringToUnsignedInteger16Array(String in) {
        if (in == null) {
            return null;
        }
        UnsignedInteger16[] out = new UnsignedInteger16[]{new UnsignedInteger16(in)};
        return out;
    }

    public UnsignedInteger32 longToUnsignedInteger32(long in) {
        UnsignedInteger32 out = new UnsignedInteger32(Long.toString(in));
        return out;
    }

    public UnsignedInteger16[] requestedStates(String[] in) {
        UnsignedInteger16[] out = new UnsignedInteger16[in.length];
        if (in != null) {
            for (int i = 0; i < in.length; ++i) {
                if (in[i].equals("Enabled")) {
                    out[i] = new UnsignedInteger16(2);
                    continue;
                }
                if (in[i].equals("Disabled")) {
                    out[i] = new UnsignedInteger16(3);
                    continue;
                }
                if (!in[i].equals("Reset")) continue;
                out[i] = new UnsignedInteger16(11);
            }
        }
        return out;
    }

    public UnsignedInteger16[] principalPriorities(String[] in) {
        UnsignedInteger16[] out = new UnsignedInteger16[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i].equals("Principal") ? new UnsignedInteger16(2) : (in[i].equals("Subordinate") ? new UnsignedInteger16(3) : (in[i].equals("Any") ? new UnsignedInteger16(4) : new UnsignedInteger16(5)));
        }
        return out;
    }

    public UnsignedInteger16[] getOperationalStatus(boolean value) {
        if (value) {
            return this.stringToUnsignedInteger16Array("2");
        }
        return this.stringToUnsignedInteger16Array("6");
    }

    public UnsignedInteger16[] getOperationalStatus(String value) {
        if (value.equalsIgnoreCase("UP")) {
            return this.stringToUnsignedInteger16Array("2");
        }
        if (value.equalsIgnoreCase("OK")) {
            return this.stringToUnsignedInteger16Array("2");
        }
        if (value.equalsIgnoreCase("Degraded")) {
            return this.stringToUnsignedInteger16Array("3");
        }
        return this.stringToUnsignedInteger16Array("6");
    }

    public UnsignedInteger16 statusMapper(String in) {
        if (in != null) {
            if (in.equals("up")) {
                return new UnsignedInteger16(5);
            }
            if (in.equals("down")) {
                return new UnsignedInteger16(3);
            }
            return new UnsignedInteger16(1);
        }
        return null;
    }

    public UnsignedInteger16 getInfoFormat(InetAddressType inetAddrType) {
        UnsignedInteger16 type = null;
        type = inetAddrType == InetAddressType.IPV4 ? new UnsignedInteger16(3) : (inetAddrType == InetAddressType.IPV6 ? new UnsignedInteger16(4) : (inetAddrType == InetAddressType.DNS ? new UnsignedInteger16(2) : new UnsignedInteger16(1)));
        return type;
    }

    public UnsignedInteger32 inetAddressType(InetAddressType in) {
        if (in != null && in.getValue() != null) {
            String type = in.getValue();
            if (type.equals("IPV4")) {
                return new UnsignedInteger32(1L);
            }
            if (type.equals("IPV6")) {
                return new UnsignedInteger32(2L);
            }
            if (type.equals("DNS")) {
                return new UnsignedInteger32(0L);
            }
            return new UnsignedInteger32(0L);
        }
        return null;
    }

    public UnsignedInteger16[] mapOperationalStatus(int status) {
        switch (status) {
            case 1: {
                return this.intToUnsignedInteger16Array(2);
            }
            case 2: {
                return this.intToUnsignedInteger16Array(6);
            }
            case 3: {
                return this.intToUnsignedInteger16Array(0);
            }
            case 4: {
                return this.intToUnsignedInteger16Array(0);
            }
            case 5: {
                return this.intToUnsignedInteger16Array(6);
            }
            case 6: {
                return this.intToUnsignedInteger16Array(6);
            }
            case 7: {
                return this.intToUnsignedInteger16Array(6);
            }
        }
        return this.intToUnsignedInteger16Array(0);
    }

    public UnsignedInteger16[] mapJobOperStatus(int status) {
        switch (status) {
            case 3: {
                return this.intArrayToUnsignedInteger16Array(new int[]{2, 8});
            }
            case 4: {
                return this.intToUnsignedInteger16Array(2);
            }
            case 7: {
                return this.intArrayToUnsignedInteger16Array(new int[]{2, 17});
            }
            case 8: {
                return this.intToUnsignedInteger16Array(10);
            }
        }
        return this.intToUnsignedInteger16Array(0);
    }

    public int getJobStatustoSMIS(String status) {
        int jobStatus = 0;
        if (status.equals("STARTED")) {
            jobStatus = 3;
        } else if (status.equals("RUNNING")) {
            jobStatus = 4;
        } else if (status.equals("ENDED")) {
            jobStatus = 7;
        } else if (status.equals("TERMINATED")) {
            jobStatus = 8;
        }
        return jobStatus;
    }

    public UnsignedInteger16 mapEthernetPortType(int ifType, long ifSpeed) {
        UnsignedInteger16 type = new UnsignedInteger16(0);
        if (ifType == 117) {
            type = ifSpeed == 1000000000L ? new UnsignedInteger16(53) : (ifSpeed == 1410065408L ? new UnsignedInteger16(55) : new UnsignedInteger16(53));
        }
        if (ifType == 135) {
            type = ifSpeed == 100000000L ? new UnsignedInteger16(52) : (ifSpeed == 1000000000L ? new UnsignedInteger16(53) : (ifSpeed == 1410065408L ? new UnsignedInteger16(55) : new UnsignedInteger16(53)));
        } else if (ifType == 6) {
            type = ifSpeed == 100000000L ? new UnsignedInteger16(52) : (ifSpeed == 1000000000L ? new UnsignedInteger16(53) : new UnsignedInteger16(52));
        } else if (ifType == 62) {
            type = ifSpeed == 100000000L ? new UnsignedInteger16(52) : (ifSpeed == 1000000000L ? new UnsignedInteger16(53) : new UnsignedInteger16(52));
        }
        return type;
    }

    public UnsignedInteger32 getAdminStatus(int adminStatus) {
        if (adminStatus == 1) {
            return this.intToUnsignedInteger32(2);
        }
        if (adminStatus == 2) {
            return this.intToUnsignedInteger32(3);
        }
        if (adminStatus == 3) {
            return this.intToUnsignedInteger32(7);
        }
        return null;
    }

    public int fmzonememtypetoSMIS(int fmtype) {
        int smistype = fmtype;
        if (fmtype == 1) {
            smistype = 2;
        } else if (fmtype == 2) {
            smistype = 4;
        } else if (fmtype == 4) {
            smistype = 7;
        } else if (fmtype == 7) {
            smistype = 11;
        } else if (fmtype == 5) {
            smistype = 12;
        } else if (fmtype == 10) {
            smistype = 13;
        }
        return smistype;
    }

    public int smiszonememtypetoFM(int smistype) {
        int fmtype = smistype;
        if (smistype == 2) {
            fmtype = 1;
        } else if (smistype == 4) {
            fmtype = 2;
        } else if (smistype == 7) {
            fmtype = 4;
        } else if (smistype == 11) {
            fmtype = 7;
        } else if (smistype == 12) {
            fmtype = 5;
        } else if (smistype == 13) {
            fmtype = 10;
        }
        return fmtype;
    }

    public static long getSmisSpeed(long speed) {
        int s = (int)(speed / 1000000000L);
        return (long)s * 1062500000L;
    }

    public int getAdminstatus(int value) {
        int retvalue = 0;
        retvalue = value == 1 ? 2 : (value == 2 ? 3 : (value == 3 ? 7 : 0));
        return retvalue;
    }

    public Object intToUnsignedInteger64(long in) {
        UnsignedInteger64 out = new UnsignedInteger64(new BigInteger(1, ByteBuffer.allocate(8).putLong(in).array()));
        return out;
    }

    public Object intToUnsignedInteger64(int in) {
        UnsignedInteger64 out = new UnsignedInteger64(new BigInteger(1, ByteBuffer.allocate(4).putInt(in).array()));
        return out;
    }

    public int getportavailability(int value) {
        int retvalue = 0;
        switch (value) {
            case 1: {
                retvalue = 0;
                break;
            }
            case 2: 
            case 10: 
            case 12: {
                retvalue = 1;
                break;
            }
            case 3: {
                retvalue = 2;
                break;
            }
            case 29: {
                retvalue = 3;
                break;
            }
            case 30: {
                retvalue = 4;
                break;
            }
            default: {
                retvalue = 0;
            }
        }
        return retvalue;
    }

    public int getPortType(int mode, int if_type) {
        boolean IF_INDEX_TYPE_PHY_FC_PORT = true;
        int IF_INDEX_TYPE_PORT_CHANNEL = 4;
        int IF_INDEX_TYPE_FCIP_INTF = 10;
        int IF_INDEX_TYPE_ISCSI_INTF = 11;
        int IF_INDEX_TYPE_VFC = 30;
        int OPER_MODE_F = 2;
        int OPER_MODE_FL = 3;
        int OPER_MODE_E = 4;
        int OPER_MODE_FX = 6;
        int OPER_MODE_N = 9;
        int OPER_MODE_NL = 10;
        int OPER_MODE_NX = 11;
        int OPER_MODE_TE = 12;
        int OPER_MODE_NP = 16;
        int OPER_MODE_TF = 17;
        int OPER_MODE_TNP = 18;
        switch (if_type) {
            case 4: 
            case 10: {
                return 16000 + if_type;
            }
            case 11: {
                return 16011;
            }
            case 1: 
            case 30: {
                switch (mode) {
                    case 9: {
                        return 10;
                    }
                    case 10: {
                        return 11;
                    }
                    case 11: {
                        return 13;
                    }
                    case 4: 
                    case 12: {
                        return 14;
                    }
                    case 2: 
                    case 6: 
                    case 17: {
                        return 15;
                    }
                    case 3: {
                        return 16;
                    }
                    case 16: 
                    case 18: {
                        return 19;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public int getRequestedType(int mode, int if_type) {
        boolean IF_INDEX_TYPE_PHY_FC_PORT = true;
        int IF_INDEX_TYPE_PORT_CHANNEL = 4;
        int IF_INDEX_TYPE_FCIP_INTF = 10;
        int IF_INDEX_TYPE_ISCSI_INTF = 11;
        int OPER_MODE_F = 2;
        int OPER_MODE_FL = 3;
        int OPER_MODE_E = 4;
        int OPER_MODE_FX = 6;
        int OPER_MODE_N = 9;
        int OPER_MODE_NL = 10;
        int OPER_MODE_NX = 11;
        int OPER_MODE_TE = 12;
        int OPER_MODE_B = 5;
        int OPER_MODE_NP = 16;
        switch (if_type) {
            case 4: 
            case 10: {
                return 16000 + if_type;
            }
            case 11: {
                return 16011;
            }
            case 1: {
                switch (mode) {
                    case 9: {
                        return 10;
                    }
                    case 10: {
                        return 9;
                    }
                    case 11: {
                        return 8;
                    }
                    case 4: 
                    case 12: {
                        return 4;
                    }
                    case 5: {
                        return 7;
                    }
                    case 2: {
                        return 5;
                    }
                    case 6: {
                        return 6;
                    }
                    case 3: {
                        return 16003;
                    }
                    case 16: {
                        return 16004;
                    }
                }
                return 0;
            }
        }
        return 0;
    }
}

