/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.helper;

import java.util.Calendar;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;

public class MappingUtil {
    public static String fmWwnFormat(String wwn) {
        StringBuffer sb = new StringBuffer();
        if (wwn != null) {
            int sz = wwn.length();
            wwn = wwn.toLowerCase();
            int i = 0;
            while (true) {
                sb.append(wwn.charAt(i));
                if (++i == sz) break;
                if (i % 2 != 0) continue;
                sb.append(':');
            }
        }
        return sb.toString();
    }

    public static String smisWwnFormat(String wwn) {
        StringBuffer sb = new StringBuffer();
        if (wwn != null) {
            int sz = wwn.length();
            wwn = wwn.toUpperCase();
            for (int i = 0; i < sz; ++i) {
                char c = wwn.charAt(i);
                if (c == ':') continue;
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public Integer[] intArrayToIntegerArray(int[] in) {
        if (in == null) {
            return null;
        }
        Integer[] out = new Integer[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = new Integer(in[i]);
        }
        return out;
    }

    public Integer[] intToIntegerArray(int in) {
        Integer[] out = new Integer[]{new Integer(in)};
        return out;
    }

    public String[] intToStringArray(int in) {
        String[] out = new String[]{Integer.toString(in)};
        return out;
    }

    public String[] hexToStringArray() {
        String[] out = new String[]{Integer.toHexString(0).toUpperCase()};
        return out;
    }

    public String[] intArrayToStringArray(int[] in) {
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = Integer.toString(in[i]);
        }
        return out;
    }

    public Long[] longArrayToLongArray(long[] in) {
        if (in == null) {
            return null;
        }
        Long[] out = new Long[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = new Long(in[i]);
        }
        return out;
    }

    public Long[] longToLongArray(long in) {
        Long[] out = new Long[]{new Long(in)};
        return out;
    }

    public String intToString(int in) {
        String out = Integer.toString(in);
        return out;
    }

    public String[] stringToStringarray(String in) {
        if (in == null) {
            return null;
        }
        String[] out = new String[]{new String(in)};
        return out;
    }

    public String stripLableOfWwn(String w) {
        int len = w.length();
        if (len > 23) {
            return w.substring(len - 23, len);
        }
        return w;
    }

    public CIMDateTime stringToDateTime(String in) {
        CIMDateTimeAbsolute date_time = null;
        try {
            String datatime_separator = "-";
            String date_separator = "/";
            String time_separator = ":";
            String padded_zeros = ".000000";
            String[] datendtime = in.split(datatime_separator);
            String[] date = datendtime[0].split(date_separator);
            String[] time = datendtime[1].split(time_separator);
            StringBuilder outstring = new StringBuilder();
            for (String o : date) {
                outstring.append(o);
            }
            for (String o : time) {
                outstring.append(o);
            }
            outstring.append(padded_zeros);
            Calendar clientCalender = Calendar.getInstance();
            int timezoneOffset = (clientCalender.get(15) + clientCalender.get(16)) / 60000;
            if (timezoneOffset < 0) {
                outstring.append(timezoneOffset);
            } else {
                outstring.append("+" + timezoneOffset);
            }
            date_time = new CIMDateTimeAbsolute(outstring.toString());
            return date_time;
        }
        catch (Exception exception) {
            return date_time;
        }
    }

    public String toHexString(byte[] inputByte) {
        char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (inputByte == null || inputByte.length == 0) {
            return null;
        }
        StringBuffer outputstr = new StringBuffer(inputByte.length * 3);
        for (int i = 0; i < inputByte.length; ++i) {
            int n = inputByte[i] & 0xFF;
            outputstr.append(HEX_DIGIT[n >> 4 & 0xF]);
            outputstr.append(HEX_DIGIT[n & 0xF]);
            if (i + 1 >= inputByte.length) continue;
            outputstr.append(':');
        }
        return outputstr.toString();
    }

    public byte[] fromHexString(String hexStr, boolean hasColon) throws NumberFormatException {
        hexStr = hexStr.toLowerCase();
        int len = hexStr.length();
        byte[] bytes = new byte[hasColon ? len / 3 + 1 : len / 2];
        int sPos = 0;
        int bPos = 0;
        try {
            while (sPos < len) {
                char a = hexStr.charAt(sPos);
                char b = hexStr.charAt(sPos + 1);
                if (hasColon && (a == ':' || b == ':')) {
                    throw new NumberFormatException("bad Hex format");
                }
                int v1 = Character.digit(a, 16);
                int v2 = Character.digit(b, 16);
                if (v1 < 0 || v2 < 0) {
                    throw new NumberFormatException("bad Hex format");
                }
                int v3 = v1 * 16 + v2;
                bytes[bPos] = (byte)v3;
                sPos += hasColon ? 3 : 2;
                ++bPos;
            }
        }
        catch (Exception ex) {
            throw new NumberFormatException("bad Hex format");
        }
        if (bPos < bytes.length) {
            throw new NumberFormatException("bad Hex format");
        }
        return bytes;
    }
}

