/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.security;

import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.helper.AuthenticationHelper;
import com.cisco.dcbu.smis.provider.security.Session;
import com.cisco.dcbu.smis.provider.security.SessionFactory;
import com.wbemsolutions.wbem.jserver.VerificationService;
import javax.wbem.client.WBEMClient;
import javax.wbem.provider.ProviderHandle;

public final class FMAuthenticationProvider
implements VerificationService {
    static LogLevel _logger = new LogLevel();
    private static Long TOKEN_EXPIRATION = 100000000L;
    private static ProviderHandle pHandle = null;

    public void initialize(WBEMClient paramWBEMClient) throws SMISException {
        pHandle = (ProviderHandle)paramWBEMClient;
    }

    public boolean authenticateUser(String userName, String password) throws SMISException {
        String token = null;
        AuthenticationHelper helper = new AuthenticationHelper();
        try {
            token = helper.login(userName, password, TOKEN_EXPIRATION);
            if (token != null) {
                LogLevel.fine("user: " + userName + " token: " + token);
                Session session = new Session(userName, password, token, TOKEN_EXPIRATION);
                SessionFactory.getInstance().addSession(pHandle, session);
                return true;
            }
            return false;
        }
        catch (SMISException se) {
            throw se;
        }
        catch (Exception e) {
            LogLevel.log(30000, e.getMessage());
            throw new SMISException(1, e.getMessage(), e);
        }
    }

    public boolean authenticateRole(String paramString1, String paramString2, String paramString3) throws SMISException {
        throw new SMISException(7);
    }
}

