/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.subscription;

import com.cisco.dcbu.sm.common.event.smis.EndPortChange;
import com.cisco.dcbu.sm.common.event.smis.FRUChange;
import com.cisco.dcbu.sm.common.event.smis.FanChange;
import com.cisco.dcbu.sm.common.event.smis.LinkStateChange;
import com.cisco.dcbu.sm.common.event.smis.NameServerDBChange;
import com.cisco.dcbu.sm.common.event.smis.PowerChange;
import com.cisco.dcbu.sm.common.event.smis.SwitchChange;
import com.cisco.dcbu.sm.common.event.smis.TempChange;
import com.cisco.dcbu.sm.common.event.smis.UserChange;
import com.cisco.dcbu.sm.common.event.smis.VsanChange;
import com.cisco.dcbu.sm.common.event.smis.ZoneChange;
import com.cisco.dcbu.sm.common.event.smis.ZoneSetChange;
import com.cisco.dcbu.smis.exception.SMISException;
import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.common.SubscriptionTypeEnum;
import com.cisco.dcbu.smis.provider.helper.CISCO_FanAlertHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_LinkDownHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_LinkUpHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_MediaFRUChangedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_MediaFRUInsertedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_MediaFRURemovedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_NameServerDatabaseChangeHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_PortAddedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_PortRemovedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_PowerAlertHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_SwitchAddedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_SwitchRemovedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_TempAlertHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_UserAddedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_UserLoginFailedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_UserModifiedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_UserRemovedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_VsanChangedHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_ZoneAlertHelper;
import com.cisco.dcbu.smis.provider.helper.CISCO_ZoneSetAlertHelper;
import com.cisco.dcbu.smis.provider.helper.IndicationProviderHelper;
import com.cisco.dcbu.smis.provider.security.SessionFactory;
import com.cisco.dcbu.smis.provider.subscription.Subscription;
import java.util.Enumeration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.cim.CIMInstance;
import javax.wbem.provider.ProviderHandle;

final class DispatchThread
extends Thread {
    private static final long DISPATCH_TIMEOUT = 60000L;
    private static int _Count = 0;
    private final BlockingQueue<Object> _eventQ;
    private EventHandler _handler;
    static LogLevel _logger = new LogLevel();

    DispatchThread(BlockingQueue<Object> eventQ) {
        super("EventDispatcher");
        this._eventQ = eventQ;
        this._handler = new EventHandler("EventHandler-" + ++_Count);
        this._handler.start();
    }

    @Override
    public void run() {
        Object event = null;
        try {
            while (true) {
                if (event == null) {
                    event = this._eventQ.take();
                }
                if (this._handler._queue.offer(event, 60000L, TimeUnit.MILLISECONDS)) {
                    event = null;
                    continue;
                }
                this._handler.stopHandler();
                this._handler = new EventHandler("EventHandler-" + ++_Count);
                this._handler.start();
            }
        }
        catch (InterruptedException iex) {
            String s = "EventDispatcher stopped. Reason: " + iex.getMessage();
            LogLevel.log(30000, s, iex);
            return;
        }
    }

    class EventHandler
    extends Thread {
        private static final int SWITCH_ADDED = 0;
        private static final int SWITCH_REMOVED = 1;
        private static final int ENDPORT_ADDED = 0;
        private static final int ENDPORT_REMOVED = 1;
        SynchronousQueue<Object> _queue;
        boolean _stop;

        EventHandler(String name) {
            super(name);
            this._queue = new SynchronousQueue();
        }

        void stopHandler() {
            this._stop = true;
            this.interrupt();
        }

        @Override
        public void run() {
            this._stop = false;
            LogLevel.log(20000, this.getName() + " started");
            Object event = null;
            while (!this._stop) {
                try {
                    event = this._queue.take();
                }
                catch (InterruptedException iex) {
                    break;
                }
                try {
                    if (event instanceof LinkStateChange) {
                        this.linkStateChangeEventReceived((LinkStateChange)event);
                        continue;
                    }
                    if (event instanceof FanChange) {
                        this.fanChangeEventReceived((FanChange)event);
                        continue;
                    }
                    if (event instanceof FRUChange) {
                        this.fruChangeEventReceived((FRUChange)event);
                        continue;
                    }
                    if (event instanceof NameServerDBChange) {
                        this.nameServerDBChangeEventReceived((NameServerDBChange)event);
                        continue;
                    }
                    if (event instanceof PowerChange) {
                        this.powerChangeEventReceived((PowerChange)event);
                        continue;
                    }
                    if (event instanceof TempChange) {
                        this.tempChangeEventReceived((TempChange)event);
                        continue;
                    }
                    if (event instanceof UserChange) {
                        this.userChangeEventReceived((UserChange)event);
                        continue;
                    }
                    if (event instanceof VsanChange) {
                        this.vsanChangeEventReceived((VsanChange)event);
                        continue;
                    }
                    if (event instanceof ZoneChange) {
                        this.zoneChangeEventReceived((ZoneChange)event);
                        continue;
                    }
                    if (event instanceof ZoneSetChange) {
                        this.zoneSetChangeEventReceived((ZoneSetChange)event);
                        continue;
                    }
                    if (event instanceof SwitchChange) {
                        this.switchChangeEventReceived((SwitchChange)event);
                        continue;
                    }
                    if (event instanceof EndPortChange) {
                        this.portChangeEventReceived((EndPortChange)event);
                        continue;
                    }
                    if (event == null) continue;
                    System.out.println("unexpected event received: " + event);
                }
                catch (Exception e) {
                    String s = "Failed to dispatch event. Reason: " + e.getMessage();
                    LogLevel.log(30000, s, e);
                }
            }
            LogLevel.log(20000, this.getName() + " stopped: " + event);
        }

        protected String checkAccess(ProviderHandle pHandle, String userName) throws SMISException {
            String token = SessionFactory.getInstance().getToken(pHandle, userName);
            if (token != null) {
                LogLevel.log(10000, "user: " + userName + " token: " + token);
            }
            return token;
        }

        private void portChangeEventReceived(EndPortChange event) {
            LogLevel.log(20000, " portChangeEventReceived event processing ");
            block2 : switch (event.getPortState()) {
                case 0: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.PortAdded);
                    String usr = null;
                    try {
                        if (pHandle != null) {
                            ConcurrentHashMap<String, Integer> eventMap = Subscription.getEndportAddMap();
                            Enumeration<String> users = eventMap.keys();
                            while (users.hasMoreElements()) {
                                usr = users.nextElement();
                                String tkn = null;
                                tkn = this.checkAccess(pHandle, usr);
                                if (tkn != null) {
                                    CISCO_PortAddedHelper helper = new CISCO_PortAddedHelper();
                                    helper.setToken(tkn);
                                    CIMInstance inst = ((IndicationProviderHelper)helper).getInstance(event);
                                    pHandle.deliverEvent(inst);
                                    break block2;
                                }
                                LogLevel.log(30000, "authentication failed with user " + usr);
                            }
                            break;
                        }
                        LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    }
                    catch (SMISException e1) {
                        String s = "Failed to validate the request for user: " + usr;
                        LogLevel.log(30000, s);
                    }
                    break;
                }
                case 1: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.PortRemoved);
                    String endUsr = null;
                    try {
                        if (pHandle != null) {
                            ConcurrentHashMap<String, Integer> eventMap = Subscription.getEndportRemMap();
                            Enumeration<String> users = eventMap.keys();
                            while (users.hasMoreElements()) {
                                endUsr = users.nextElement();
                                String tkn = null;
                                tkn = this.checkAccess(pHandle, endUsr);
                                if (tkn != null) {
                                    CISCO_PortRemovedHelper helper = new CISCO_PortRemovedHelper();
                                    helper.setToken(tkn);
                                    CIMInstance inst = ((IndicationProviderHelper)helper).getInstance(event);
                                    pHandle.deliverEvent(inst);
                                    break block2;
                                }
                                LogLevel.log(30000, "authentication failed with user " + endUsr);
                            }
                            break;
                        }
                        LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    }
                    catch (SMISException e1) {
                        String s = "Failed to validate the request for user: " + endUsr;
                        LogLevel.log(30000, s);
                    }
                    break;
                }
                default: {
                    LogLevel.log(20000, "Invalid Port state change event received ");
                }
            }
        }

        private void switchChangeEventReceived(SwitchChange event) {
            LogLevel.log(20000, " switchChangeEventReceived event processing ");
            switch (event.getSwichState()) {
                case 0: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.SwitchAdded);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event SwitchAdded ");
                        String name = pHandle.getProperty("javax.wbem.provider.Principal");
                        CISCO_SwitchAddedHelper helper = new CISCO_SwitchAddedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                case 1: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.SwitchRemoved);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event SwitchRemoved ");
                        CISCO_SwitchRemovedHelper helper = new CISCO_SwitchRemovedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                default: {
                    LogLevel.log(20000, "Invalid Switch state change event received ");
                }
            }
        }

        private void linkStateChangeEventReceived(LinkStateChange event) {
            LogLevel.log(20000, " LinkStateChange event processing ");
            switch (event.getLinkState()) {
                case 0: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.Linkup);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event Linkup ");
                        CISCO_LinkUpHelper helper = new CISCO_LinkUpHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                case 1: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.LinkDown);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event LinkDown ");
                        CISCO_LinkDownHelper helper = new CISCO_LinkDownHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                default: {
                    LogLevel.log(20000, "Invalid Link state change event received ");
                }
            }
        }

        private void fanChangeEventReceived(FanChange event) {
            LogLevel.log(20000, " fanChangeEvent event processing ");
            ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.FanAlert);
            if (pHandle != null) {
                LogLevel.log(20000, "some subscriber is interested in the event FanAlert ");
                CISCO_FanAlertHelper helper = new CISCO_FanAlertHelper();
                try {
                    pHandle.deliverEvent(helper.getInstance(event));
                }
                catch (SMISException e) {
                    String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                    LogLevel.log(30000, s, (Throwable)((Object)e));
                }
            } else {
                LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
            }
        }

        private void fruChangeEventReceived(FRUChange event) {
            LogLevel.log(20000, " LinkStateChange event processing ");
            switch (event.getOperType()) {
                case 0: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.MediaFRUInserted);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event MediaFRUInserted ");
                        CISCO_MediaFRUInsertedHelper helper = new CISCO_MediaFRUInsertedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                case 1: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.MediaFRURemoved);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event MediaFRURemoved ");
                        CISCO_MediaFRURemovedHelper helper = new CISCO_MediaFRURemovedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                case 2: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.MediaFRUChanged);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event MediaFRUChanged ");
                        CISCO_MediaFRUChangedHelper helper = new CISCO_MediaFRUChangedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                default: {
                    LogLevel.log(20000, "Invalid Media FRU change event received ");
                }
            }
        }

        private void nameServerDBChangeEventReceived(NameServerDBChange event) {
            LogLevel.log(20000, " NameServerDBChange event processing ");
            ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.NameServerDBChanged);
            if (pHandle != null) {
                LogLevel.log(20000, "some subscriber is interested in the event NameServerDBChanged ");
                CISCO_NameServerDatabaseChangeHelper helper = new CISCO_NameServerDatabaseChangeHelper();
                try {
                    pHandle.deliverEvent(helper.getInstance(event));
                }
                catch (SMISException e) {
                    String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                    LogLevel.log(30000, s, (Throwable)((Object)e));
                }
            } else {
                LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
            }
        }

        private void powerChangeEventReceived(PowerChange event) {
            LogLevel.log(20000, " PowerAlert event processing ");
            ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.PowerAlert);
            if (pHandle != null) {
                LogLevel.log(20000, "some subscriber is interested in the event PowerAlert ");
                CISCO_PowerAlertHelper helper = new CISCO_PowerAlertHelper();
                try {
                    pHandle.deliverEvent(helper.getInstance(event));
                }
                catch (SMISException e) {
                    String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                    LogLevel.log(30000, s, (Throwable)((Object)e));
                }
            } else {
                LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
            }
        }

        private void tempChangeEventReceived(TempChange event) {
            LogLevel.log(20000, " TempAlert event processing ");
            ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.TempAlert);
            if (pHandle != null) {
                LogLevel.log(20000, "some subscriber is interested in the event TempAlert ");
                CISCO_TempAlertHelper helper = new CISCO_TempAlertHelper();
                try {
                    pHandle.deliverEvent(helper.getInstance(event));
                }
                catch (SMISException e) {
                    String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                    LogLevel.log(30000, s, (Throwable)((Object)e));
                }
            } else {
                LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
            }
        }

        private void userChangeEventReceived(UserChange event) {
            LogLevel.log(20000, " userChangeEventReceived event processing ");
            switch (event.getOperType()) {
                case 1: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.UserAdded);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event UserAdded ");
                        CISCO_UserAddedHelper helper = new CISCO_UserAddedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                case 2: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.UserRemoved);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event UserRemoved ");
                        CISCO_UserRemovedHelper helper = new CISCO_UserRemovedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                case 3: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.UserModified);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event UserModified ");
                        CISCO_UserModifiedHelper helper = new CISCO_UserModifiedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                case 4: {
                    ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.UserLoginFailed);
                    if (pHandle != null) {
                        LogLevel.log(20000, "some subscriber is interested in the event UserLoginFailed ");
                        CISCO_UserLoginFailedHelper helper = new CISCO_UserLoginFailedHelper();
                        try {
                            pHandle.deliverEvent(((IndicationProviderHelper)helper).getInstance(event));
                        }
                        catch (SMISException e) {
                            String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                            LogLevel.log(30000, s, (Throwable)((Object)e));
                        }
                        break;
                    }
                    LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
                    break;
                }
                default: {
                    LogLevel.log(20000, "Invalid User event received ");
                }
            }
        }

        private void vsanChangeEventReceived(VsanChange event) {
            LogLevel.log(20000, " VsanChanged event processing ");
            ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.VsanChanged);
            if (pHandle != null) {
                LogLevel.log(20000, "some subscriber is interested in the event VsanChanged ");
                CISCO_VsanChangedHelper helper = new CISCO_VsanChangedHelper();
                try {
                    pHandle.deliverEvent(helper.getInstance(event));
                }
                catch (SMISException e) {
                    String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                    LogLevel.log(30000, s, (Throwable)((Object)e));
                }
            } else {
                LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
            }
        }

        private void zoneChangeEventReceived(ZoneChange event) {
            LogLevel.log(20000, " ZoneAlert event processing ");
            ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.ZoneAlert);
            if (pHandle != null) {
                LogLevel.log(20000, "some subscriber is interested in the event ZoneAlert ");
                CISCO_ZoneAlertHelper helper = new CISCO_ZoneAlertHelper();
                try {
                    pHandle.deliverEvent(helper.getInstance(event));
                }
                catch (SMISException e) {
                    String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                    LogLevel.log(30000, s, (Throwable)((Object)e));
                }
            } else {
                LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
            }
        }

        private void zoneSetChangeEventReceived(ZoneSetChange event) {
            LogLevel.log(20000, " ZoneSetAlert event processing ");
            ProviderHandle pHandle = Subscription.getInstance().getHandler(SubscriptionTypeEnum.ZoneSetAlert);
            if (pHandle != null) {
                LogLevel.log(20000, "some subscriber is interested in the event ZoneSetAlert ");
                CISCO_ZoneSetAlertHelper helper = new CISCO_ZoneSetAlertHelper();
                try {
                    pHandle.deliverEvent(helper.getInstance(event));
                }
                catch (SMISException e) {
                    String s = "error occured while deleivering the event to CIMOM " + e.getMessage();
                    LogLevel.log(30000, s, (Throwable)((Object)e));
                }
            } else {
                LogLevel.log(30000, "dropping the event with out initiating the helper class, as none of the subscriber is interested.");
            }
        }
    }
}

