/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.provider.subscription;

import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.provider.subscription.EventDispatcher;
import java.io.EOFException;
import java.io.Serializable;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

public class EventHandler
implements MessageListener,
ExceptionListener {
    private static final long serialVersionUID = 1L;
    private static final String TOPIC_SMIS = "jms/topic/smisTopic";
    private final int _port;
    static LogLevel _logger = new LogLevel();
    private TopicConnection _conn = null;
    private TopicSession _session = null;
    private Topic _topic = null;
    private static EventHandler _eventHandler = null;
    private boolean _connectionIsUp = false;
    String _serverHost;

    protected EventHandler() {
        this._port = -1;
    }

    private EventHandler(String host, int port) throws RemoteException, JMSException {
        this._port = port;
        this._serverHost = host;
        LogLevel.log(10000, "EventHandle init server host:" + this._serverHost + ":" + this._port);
        this.setupPubSub();
        this.setSubscriber("");
    }

    public void setupPubSub() throws RemoteException {
        if (this._connectionIsUp) {
            return;
        }
        ClassLoader prevCl1 = this.getClass().getClassLoader();
        ClassLoader prevCl2 = Thread.currentThread().getContextClassLoader();
        LogLevel.log(40000, "ClassLoader prevCl1: " + prevCl1);
        LogLevel.log(40000, "ClassLoader prevCl2: " + prevCl2);
        try {
            this.stop();
            Thread.currentThread().setContextClassLoader(prevCl1);
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming:org.jnp.interfaces");
            String serverUrl = "remote://" + this._serverHost + ":" + this._port;
            properties.put("java.naming.provider.url", serverUrl);
            InitialContext _context = new InitialContext(properties);
            Object tmp = _context.lookup("jms/RemoteConnectionFactory");
            TopicConnectionFactory tcf = (TopicConnectionFactory)tmp;
            this._conn = tcf.createTopicConnection();
            this._topic = (Topic)_context.lookup(TOPIC_SMIS);
            this._session = this._conn.createTopicSession(false, 1);
            this._conn.start();
            this._conn.setExceptionListener((ExceptionListener)this);
            this._connectionIsUp = true;
        }
        catch (Exception e) {
            String s = "Failed to init jms client. Reason: " + e.getMessage();
            LogLevel.log(30000, s, e);
            throw new RemoteException(e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl2);
        }
    }

    public TopicSubscriber setSubscriber(String messageSelector) throws JMSException {
        TopicSubscriber subScriber = null;
        this._session = this._conn.createTopicSession(false, 1);
        subScriber = this._session.createSubscriber(this._topic, messageSelector, false);
        subScriber.setMessageListener((MessageListener)this);
        return subScriber;
    }

    public void removeSubscriber(TopicSubscriber subScriber) throws JMSException {
        if (subScriber != null) {
            subScriber.close();
            subScriber = null;
        }
    }

    public static EventHandler getInstance(String host, int port) throws RemoteException, JMSException {
        if (_eventHandler == null) {
            _eventHandler = new EventHandler(host, port);
        }
        return _eventHandler;
    }

    public void onException(JMSException ex) {
        if (this._connectionIsUp) {
            if (ex.getCause() instanceof SocketException || ex.getCause() instanceof EOFException) {
                this._connectionIsUp = false;
            }
            String s = "EventHandle receive JMS Exception. Reason: " + ex.getMessage();
            LogLevel.log(30000, s, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        ClassLoader prevCl1 = this.getClass().getClassLoader();
        ClassLoader prevCl2 = Thread.currentThread().getContextClassLoader();
        LogLevel.log(40000, "ClassLoader prevCl1: " + prevCl1);
        LogLevel.log(40000, "ClassLoader prevCl2: " + prevCl2);
        ObjectMessage om = (ObjectMessage)msg;
        Serializable event = null;
        try {
            Thread.currentThread().setContextClassLoader(prevCl1);
            event = om.getObject();
            LogLevel.log(10000, "Processing event. " + event.toString());
            EventDispatcher.getInstance().enqueue(event);
        }
        catch (Exception e) {
            String s = "Failed to process event. " + om.toString() + " Reason: " + e.getMessage();
            LogLevel.log(30000, s, e);
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl2);
        }
    }

    public void stop() throws JMSException {
        try {
            if (this._session != null) {
                this._session.close();
                this._session = null;
            }
            if (this._conn != null) {
                this._conn.stop();
                this._conn = null;
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this._connectionIsUp = false;
    }

    public void remove() {
        _eventHandler = null;
    }

    public int getClientPort() throws RemoteException {
        return this._port;
    }
}

