/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.test.cimparser;

import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.test.cimparser.CIMDataTypeUtil;
import com.cisco.dcbu.smis.test.cimparser.CimAsssocObjectPathInfo;
import com.cisco.dcbu.smis.test.cimparser.CimKeysInfo;
import com.cisco.dcbu.smis.test.cimparser.CimLocalInstancePathkeyinfo;
import com.cisco.dcbu.smis.test.cimparser.CimObjectPathInfo;
import com.cisco.dcbu.smis.test.cimparser.ProviderMethodInfo;
import com.cisco.dcbu.smis.test.cimparser.ProviderMethodParamInfo;
import com.cisco.dcbu.smis.test.exceptions.XmlParserException;
import com.cisco.dcbu.smis.test.util.TestConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

public class CimXmlRequestParser {
    static LogLevel trace = new LogLevel();
    public static final String GI = "GI";
    public static final String EI = "EI";
    public static final String NI = "NI";
    public static final String AGI = "AGI";
    public static final String AEI = "AEI";
    public static final String ANI = "ANI";
    public static final String AN = "AN";
    public static final String A = "A_AC";
    private final String CIM_XML_REQUESTPARSER_RULES_FILE = TestConfiguration.getParserRulesPath() + "CimXmlRequestParserRules.xml";
    private final String CIM_XML_REQUESTPARSER_RULES_FILE_AGI = TestConfiguration.getParserRulesPath() + "CimXmlRequestParserRules_AGI.xml";
    private String inputFileName;
    private List<ProviderMethodInfo> provMethodInfoList = new ArrayList<ProviderMethodInfo>();
    public static final String CLASS_NAME = "ClassName";
    public static final String INSTANCE_NAME = "InstanceName";
    public static final String LOCAL_ONLY = "LocalOnly";
    public static final String INCLUDE_CLASS_ORIGIN = "IncludeClassOrigin";
    public static final String PROPERTY_LIST = "PropertyList";
    public static final String OBJECT_NAME = "ObjectName";
    public static final String ASSOCIATION_CLASS = "AssocClass";
    public static final String RESULT_CLASS = "ResultClass";
    public static final String ROLE = "Role";
    public static final String RESULT_ROLE = "ResultRole";

    public CimXmlRequestParser(String cimXmlRequestFileName) throws XmlParserException {
        if (cimXmlRequestFileName == null || "".equals(cimXmlRequestFileName)) {
            LogLevel.log(20000, "Failed to read " + cimXmlRequestFileName);
            throw new XmlParserException("No such file with name : " + cimXmlRequestFileName);
        }
        String xmlRequestPath = TestConfiguration.getXMLRequestPath();
        this.readProviderMethodInfo(xmlRequestPath + cimXmlRequestFileName);
    }

    public CimXmlRequestParser() {
    }

    public void readProviderMethodInfo(String cimXmlRequestFileName) throws XmlParserException {
        URL rulesURL = null;
        rulesURL = cimXmlRequestFileName.contains("_AGI_Request") ? CimXmlRequestParser.class.getClassLoader().getResource(this.CIM_XML_REQUESTPARSER_RULES_FILE_AGI) : CimXmlRequestParser.class.getClassLoader().getResource(this.CIM_XML_REQUESTPARSER_RULES_FILE);
        Digester digester = DigesterLoader.createDigester((URL)rulesURL);
        InputStream fileStream = CimXmlRequestParser.class.getClassLoader().getResourceAsStream(cimXmlRequestFileName);
        if (fileStream == null) {
            LogLevel.log(20000, "Failed to read " + cimXmlRequestFileName);
            throw new XmlParserException("Failed to read " + cimXmlRequestFileName);
        }
        try {
            CimXmlRequestParser cimXmlRequestParser = (CimXmlRequestParser)digester.parse(fileStream);
        }
        catch (SAXException se) {
            LogLevel.log(20000, "SAXException while parsing" + cimXmlRequestFileName);
            se.printStackTrace();
            throw new XmlParserException("SAXException while parsing");
        }
        catch (IOException ie) {
            LogLevel.log(20000, "IOException while parsing" + cimXmlRequestFileName);
            ie.printStackTrace();
            throw new XmlParserException("IOException while parsing");
        }
    }

    public static void main(String[] args) {
    }

    public void printProviderMethodInfo() throws XmlParserException {
        List<ProviderMethodInfo> provMethodInfoList = this.getProvMethodInfoList();
        for (int i = 0; i < provMethodInfoList.size(); ++i) {
            ProviderMethodInfo prMethInfo = provMethodInfoList.get(i);
            LogLevel.log(20000, "The name of the provider method [" + i + "] is : " + prMethInfo.getMethodName());
            List<CIMObjectPath> cIMObjectPaths = this.getCIMObjectPath();
            LogLevel.log(20000, "The cIMObjectPath[" + i + "] is : " + cIMObjectPaths.get(i).toString());
            LogLevel.log(20000, "The namespace[" + i + "] is : " + cIMObjectPaths.get(i).getNamespace());
            List<Boolean> localOnlyFlags = this.getLocalOnly();
            for (Boolean b : localOnlyFlags) {
                System.out.println("The The localOnlyFlag is : " + b.toString());
            }
            List<Boolean> includeClassOrigin = this.getIncludeClassOrigin();
            for (Boolean b : includeClassOrigin) {
                LogLevel.log(20000, "The The includeClassOrigin is : " + b.toString());
            }
            if (this.getPropertyList().size() <= 0) continue;
            List<String> propertyList = this.getPropertyList().get(i);
            for (String s : propertyList) {
                LogLevel.log(20000, "The Property is : " + s);
            }
        }
    }

    public List<String> getMethodName() {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            methodNames.add(pmi.getMethodName());
        }
        return methodNames;
    }

    public List<CIMObjectPath> getCIMObjectPath() throws XmlParserException {
        LogLevel.log(20000, "Inside CimXmlRequestParser === getCIMObjectPath");
        ArrayList<CIMObjectPath> cimObjectPaths = new ArrayList<CIMObjectPath>();
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            String className;
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = null;
            if (this.inputFileName.contains(AGI) || this.inputFileName.contains(GI)) {
                pmpi = pmi.getProviderMethodParamInfo(INSTANCE_NAME);
            } else if (this.inputFileName.contains(AEI) || this.inputFileName.contains(ANI) || this.inputFileName.contains(EI) || this.inputFileName.contains(NI)) {
                pmpi = pmi.getProviderMethodParamInfo(CLASS_NAME);
            } else if (this.inputFileName.contains(AN) || this.inputFileName.contains(A)) {
                pmpi = pmi.getProviderMethodParamInfo(OBJECT_NAME);
            }
            if (pmpi == null) {
                throw new XmlParserException("No Provider found for the file input request : " + this.inputFileName);
            }
            CimObjectPathInfo copi = null;
            Object copOfAssoc = null;
            Object objPath = null;
            if (this.inputFileName.contains(AGI)) {
                List<CimAsssocObjectPathInfo> copAssoc = pmpi.getCimObjectPathForAssociationInfoList();
                for (CimAsssocObjectPathInfo copa : copAssoc) {
                    String className2 = copa.getClassName();
                    Collection<CimLocalInstancePathkeyinfo> cimLocalInstancePathKeyInfoList = copa.getAllCimLocalInstancePathKeyInfo();
                    if (cimLocalInstancePathKeyInfoList.size() > 0) {
                        CIMProperty[] keys = new CIMProperty[cimLocalInstancePathKeyInfoList.size()];
                        int j = 0;
                        for (CimLocalInstancePathkeyinfo cimKeysInfo : cimLocalInstancePathKeyInfoList) {
                            String name = cimKeysInfo.getsuperkeyName();
                            List<CIMObjectPath> value = cimKeysInfo.getValueReference();
                            keys[j++] = new CIMProperty(name, CIMDataType.STRING_T, (Object)value.get(0).toString());
                        }
                        cimObjectPaths.add(new CIMObjectPath(className2, "/cimv2", keys));
                        continue;
                    }
                    cimObjectPaths.add(new CIMObjectPath(className2, "/cimv2"));
                }
                return cimObjectPaths;
            }
            if (this.inputFileName.contains(GI) || this.inputFileName.contains(AN) || this.inputFileName.contains(A)) {
                copi = pmpi.getCimObjectPathInfo();
                className = copi.getClassName();
                Collection<CimKeysInfo> cimKeysInfoList = copi.getAllCimKeysInfo();
                CIMProperty[] keys = new CIMProperty[cimKeysInfoList.size()];
                int j = 0;
                for (CimKeysInfo cimKeysInfo : cimKeysInfoList) {
                    String name = cimKeysInfo.getKeyName();
                    String value = cimKeysInfo.getKeyValue();
                    CIMDataType dataType = CIMDataTypeUtil.getCIMDataType(cimKeysInfo.getKeyValueType(), false);
                    keys[j++] = new CIMProperty(name, dataType, (Object)value);
                }
                cimObjectPaths.add(new CIMObjectPath(className, pmi.getNamespaceName(), keys));
                continue;
            }
            if (!this.inputFileName.contains(AEI) && !this.inputFileName.contains(ANI) && !this.inputFileName.contains(EI) && !this.inputFileName.contains(NI)) continue;
            className = pmpi.getClassName();
            cimObjectPaths.add(new CIMObjectPath(className, pmi.getNamespaceName()));
        }
        return cimObjectPaths;
    }

    public List<Boolean> getLocalOnly() {
        ArrayList<Boolean> localOnlyFlags = new ArrayList<Boolean>();
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = pmi.getProviderMethodParamInfo(LOCAL_ONLY);
            if (pmpi == null) continue;
            localOnlyFlags.add((boolean)new Boolean(pmpi.getMethodParamValue()));
        }
        return localOnlyFlags;
    }

    public List<Boolean> getIncludeClassOrigin() {
        ArrayList<Boolean> includeClassOrigin = new ArrayList<Boolean>();
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = pmi.getProviderMethodParamInfo(INCLUDE_CLASS_ORIGIN);
            if (pmpi == null) continue;
            includeClassOrigin.add((boolean)new Boolean(pmpi.getMethodParamValue()));
        }
        return includeClassOrigin;
    }

    public List<List<String>> getPropertyList() {
        ArrayList<List<String>> propertyList = new ArrayList<List<String>>(this.provMethodInfoList.size());
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = pmi.getProviderMethodParamInfo(PROPERTY_LIST);
            if (pmpi == null) continue;
            propertyList.add(pmpi.getPropertyList());
        }
        return propertyList;
    }

    public static void printClasspath() {
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            LogLevel.log(20000, urls[i].getFile());
        }
    }

    public void setProviderMethodInfo(ProviderMethodInfo providerMethodInfo) {
        this.provMethodInfoList.add(providerMethodInfo);
    }

    public List<ProviderMethodInfo> getProvMethodInfoList() {
        return this.provMethodInfoList;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public List<CIMObjectPath> getCIMObjectPathforAssocName() {
        ArrayList<CIMObjectPath> CIMObjectPathforAssocName = new ArrayList<CIMObjectPath>();
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = pmi.getProviderMethodParamInfo(ASSOCIATION_CLASS);
            if (pmpi == null) continue;
            String className = pmpi.getClassName();
            CIMObjectPathforAssocName.add(new CIMObjectPath(className, "/cimv2"));
        }
        return CIMObjectPathforAssocName;
    }

    public String getpResultClass() {
        String pResultClass = null;
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = pmi.getProviderMethodParamInfo(RESULT_CLASS);
            if (pmpi == null) continue;
            pResultClass = pmpi.getClassName();
        }
        return pResultClass;
    }

    public String getpRole() {
        String pRole = null;
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = pmi.getProviderMethodParamInfo(ROLE);
            if (pmpi == null) continue;
            pRole = pmpi.getClassName();
        }
        return pRole;
    }

    public String getpResultRole() {
        String pResultRole = null;
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = pmi.getProviderMethodParamInfo(RESULT_ROLE);
            if (pmpi == null) continue;
            pResultRole = pmpi.getClassName();
        }
        return pResultRole;
    }

    public List<String> getAssocName() {
        ArrayList<String> assocName = new ArrayList<String>();
        for (int i = 0; i < this.provMethodInfoList.size(); ++i) {
            ProviderMethodInfo pmi = this.provMethodInfoList.get(i);
            ProviderMethodParamInfo pmpi = pmi.getProviderMethodParamInfo(ASSOCIATION_CLASS);
            if (pmpi == null) continue;
            String className = pmpi.getClassName();
            assocName.add(className);
        }
        return assocName;
    }
}

