/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.smis.test.cimparser;

import com.cisco.dcbu.smis.provider.common.LogLevel;
import com.cisco.dcbu.smis.test.cimparser.CIMAssociationName;
import com.cisco.dcbu.smis.test.cimparser.CIMDataTypeUtil;
import com.cisco.dcbu.smis.test.cimparser.CIMInstanceInfo;
import com.cisco.dcbu.smis.test.cimparser.CIMInstanceInfoForAssociation;
import com.cisco.dcbu.smis.test.cimparser.CimAssociationNameInfo;
import com.cisco.dcbu.smis.test.cimparser.CimAsssocObjectPathInfo;
import com.cisco.dcbu.smis.test.cimparser.CimKeysInfo;
import com.cisco.dcbu.smis.test.cimparser.CimLocalInstancePathkeyinfo;
import com.cisco.dcbu.smis.test.cimparser.CimObjectPathInfo;
import com.cisco.dcbu.smis.test.cimparser.CimPropertyForAssociationInfo;
import com.cisco.dcbu.smis.test.cimparser.CimPropertyInfo;
import com.cisco.dcbu.smis.test.exceptions.XmlParserException;
import com.cisco.dcbu.smis.test.util.TestConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

public class CimXmlResponseParser {
    static LogLevel trace = new LogLevel();
    public static final String GI = "GI";
    public static final String EI = "EI";
    public static final String NI = "NI";
    public static final String XML_RESPONSE_PATH = TestConfiguration.getXMLResponsePath();
    public static final String PARSER_RULES_PATH = TestConfiguration.getParserRulesPath();
    private static final String CIM_XML_RESPONSE_PARSER_RULES_FILE_EI = PARSER_RULES_PATH + "CimXmlResponseParserRules_EI.xml";
    private static final String CIM_XML_RESPONSE_PARSER_RULES_FILE_NI = PARSER_RULES_PATH + "CimXmlResponseParserRules_NI.xml";
    private static final String CIM_XML_RESPONSE_PARSER_RULES_FILE_GI = PARSER_RULES_PATH + "CimXmlResponseParserRules_GI.xml";
    private static final String CIM_XML_RESPONSE_PARSER_RULES_FILE_ANI = PARSER_RULES_PATH + "CimXmlResponseParserRules_ANI.xml";
    private static final String CIM_XML_RESPONSE_PARSER_RULES_FILE_AEI = PARSER_RULES_PATH + "CimXmlResponseParserRules_AEI.xml";
    private static final String CIM_XML_RESPONSE_PARSER_RULES_FILE_AGI = PARSER_RULES_PATH + "CimXmlResponseParserRules_AGI.xml";
    private static final String CIM_XML_RESPONSE_PARSER_RULES_FILE_ASSOCIATION = PARSER_RULES_PATH + "CimXmlResponseParserRules_ASSOCIATION.xml";
    public static final String NAMESPACE = "/cimv2";
    private String prefixAssociationName = "CISCO";
    private String methodName;
    private List<CIMInstanceInfo> cimInstanceInfoList = new ArrayList<CIMInstanceInfo>();
    private List<CIMAssociationName> cimAssociationNameList = new ArrayList<CIMAssociationName>();
    private List<CIMInstanceInfoForAssociation> cimInstanceInfoForAssociationList = new ArrayList<CIMInstanceInfoForAssociation>();

    public CimXmlResponseParser(String cimXmlResponseFileName) throws XmlParserException {
        if (cimXmlResponseFileName == null || "".equals(cimXmlResponseFileName)) {
            throw new RuntimeException("No such file with name : " + cimXmlResponseFileName);
        }
        this.parseCIMResponseInfo(XML_RESPONSE_PATH + cimXmlResponseFileName);
    }

    public CimXmlResponseParser() {
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public CimXmlResponseParser parseCIMResponseInfo(String cimXmlResponseFileName) throws XmlParserException {
        CimXmlResponseParser parser = null;
        URL rulesURL = null;
        if (cimXmlResponseFileName.contains("_NI_Response")) {
            rulesURL = CimXmlResponseParser.class.getClassLoader().getResource(CIM_XML_RESPONSE_PARSER_RULES_FILE_NI);
        } else if (cimXmlResponseFileName.contains("_EI_Response")) {
            rulesURL = CimXmlResponseParser.class.getClassLoader().getResource(CIM_XML_RESPONSE_PARSER_RULES_FILE_EI);
        } else if (cimXmlResponseFileName.contains("_GI_Response")) {
            rulesURL = CimXmlResponseParser.class.getClassLoader().getResource(CIM_XML_RESPONSE_PARSER_RULES_FILE_GI);
        } else if (cimXmlResponseFileName.contains("_ANI_Response")) {
            rulesURL = CimXmlResponseParser.class.getClassLoader().getResource(CIM_XML_RESPONSE_PARSER_RULES_FILE_ANI);
        } else if (cimXmlResponseFileName.contains("_AEI_Response")) {
            rulesURL = CimXmlResponseParser.class.getClassLoader().getResource(CIM_XML_RESPONSE_PARSER_RULES_FILE_AEI);
        } else if (cimXmlResponseFileName.contains("_AGI_Response")) {
            rulesURL = CimXmlResponseParser.class.getClassLoader().getResource(CIM_XML_RESPONSE_PARSER_RULES_FILE_AGI);
        } else if (cimXmlResponseFileName.contains("ASSOCIATION")) {
            rulesURL = CimXmlResponseParser.class.getClassLoader().getResource(CIM_XML_RESPONSE_PARSER_RULES_FILE_ASSOCIATION);
        }
        Digester digester = DigesterLoader.createDigester((URL)rulesURL);
        InputStream fileStream = CimXmlResponseParser.class.getClassLoader().getResourceAsStream(cimXmlResponseFileName);
        if (fileStream == null) {
            System.out.println("Failed to read " + cimXmlResponseFileName);
            throw new XmlParserException("Failed to read " + cimXmlResponseFileName);
        }
        try {
            parser = (CimXmlResponseParser)digester.parse(fileStream);
        }
        catch (SAXException se) {
            LogLevel.log(20000, "SAXException while parsing" + cimXmlResponseFileName);
            se.printStackTrace();
            throw new XmlParserException("SAXException while parsing");
        }
        catch (IOException ie) {
            LogLevel.log(20000, "IOException while parsing" + cimXmlResponseFileName);
            ie.printStackTrace();
            throw new XmlParserException("IOException while parsing");
        }
        return parser;
    }

    public static void main(String[] args) throws XmlParserException {
    }

    public void printProviderMethodInfoForEIGI(CimXmlResponseParser parser) throws XmlParserException {
        System.out.println("The name of the provider method is : " + parser.getMethodName());
        List<CIMInstance> cimInstnacesList = parser.getCIMInstances();
        for (CIMInstance cimInstance : cimInstnacesList) {
            CIMObjectPath cop = cimInstance.getObjectPath();
            System.out.println("The cIMObjectPath is : " + cop.toString());
            for (int j = 0; j < cimInstance.getPropertyCount(); ++j) {
                CIMProperty cimProperty = cimInstance.getProperty(j);
                System.out.println("The CIMProperty is : " + cimProperty.toString());
            }
        }
    }

    public void printProviderMethodInfoForNI(CimXmlResponseParser parser) throws XmlParserException {
        List<CIMInstanceInfo> cimInstanceInfoList = parser.getCIMInstanceInfoList();
        System.out.println("The name of the provider method is : " + parser.getMethodName());
        List<CIMObjectPath> cops = parser.getCIMObjectPath();
        for (CIMObjectPath cop : cops) {
            System.out.println("The cIMObjectPath is : " + cop.toString());
        }
    }

    public void printProviderMethodInfoForANI(CimXmlResponseParser parser) throws XmlParserException {
        List<CIMInstanceInfoForAssociation> cimInstanceInfoList = parser.getcimInstanceInfoForAssociationList();
        System.out.println("The name of the provider method is : " + parser.getMethodName());
        List<CIMObjectPath> cops = parser.getCIMObjectPath();
        for (CIMObjectPath cop : cops) {
            System.out.println("The cIMObjectPath is : " + cop.toString());
        }
    }

    public List<String> getAssociationClassList() throws XmlParserException {
        ArrayList<String> associationClassList = new ArrayList<String>();
        for (CIMAssociationName cimAssName : this.cimAssociationNameList) {
            List<CimAssociationNameInfo> associnfoList = cimAssName.getCimAssociationNameInfoList();
            for (CimAssociationNameInfo cimAssInfo : associnfoList) {
                String assClass = cimAssInfo.getassociationclassName();
                if (!assClass.startsWith(this.prefixAssociationName)) continue;
                associationClassList.add(assClass);
            }
        }
        return associationClassList;
    }

    public List<CIMObjectPath> getCIMObjectPath() throws XmlParserException {
        ArrayList<CIMObjectPath> cimObjectPaths = new ArrayList<CIMObjectPath>();
        for (CIMInstanceInfo cimInstInfo : this.cimInstanceInfoList) {
            List<CimObjectPathInfo> copis = cimInstInfo.getCimObjectPathInfoList();
            for (CimObjectPathInfo copi : copis) {
                String className = copi.getClassName();
                Collection<CimKeysInfo> cimKeysInfoList = copi.getAllCimKeysInfo();
                if (cimKeysInfoList.size() > 0) {
                    CIMProperty[] keys = new CIMProperty[cimKeysInfoList.size()];
                    int j = 0;
                    for (CimKeysInfo cimKeysInfo : cimKeysInfoList) {
                        String name = cimKeysInfo.getKeyName();
                        String value = cimKeysInfo.getKeyValue();
                        CIMDataType dataType = CIMDataTypeUtil.getCIMDataType(cimKeysInfo.getKeyValueType(), false);
                        keys[j++] = new CIMProperty(name, dataType, (Object)value);
                    }
                    cimObjectPaths.add(new CIMObjectPath(className, NAMESPACE, keys));
                    continue;
                }
                cimObjectPaths.add(new CIMObjectPath(className, NAMESPACE));
            }
        }
        return cimObjectPaths;
    }

    public List<CIMObjectPath> getCIMObjectPathForAssociationClass() throws XmlParserException {
        ArrayList<CIMObjectPath> cimObjectPaths = new ArrayList<CIMObjectPath>();
        for (CIMInstanceInfoForAssociation cimInstInfo : this.cimInstanceInfoForAssociationList) {
            List<CimAsssocObjectPathInfo> copis = cimInstInfo.getCimObjectPathForAssociationInfoList();
            for (CimAsssocObjectPathInfo copi : copis) {
                String className = copi.getClassName();
                Collection<CimLocalInstancePathkeyinfo> cimLocalInstancePathKeyInfoList = copi.getAllCimLocalInstancePathKeyInfo();
                if (cimLocalInstancePathKeyInfoList.size() > 0) {
                    CIMProperty[] keys = new CIMProperty[cimLocalInstancePathKeyInfoList.size()];
                    int j = 0;
                    for (CimLocalInstancePathkeyinfo cimKeysInfo : cimLocalInstancePathKeyInfoList) {
                        String name = cimKeysInfo.getsuperkeyName();
                        List<CIMObjectPath> value = cimKeysInfo.getValueReference();
                        keys[j++] = new CIMProperty(name, CIMDataType.STRING_T, (Object)value.get(0).toString());
                    }
                    cimObjectPaths.add(new CIMObjectPath(className, NAMESPACE, keys));
                    continue;
                }
                cimObjectPaths.add(new CIMObjectPath(className, NAMESPACE));
            }
        }
        return cimObjectPaths;
    }

    public List<CIMInstance> getCIMInstancesForAssociationClass() throws XmlParserException {
        ArrayList<CIMInstance> cimInstnaces = new ArrayList<CIMInstance>();
        List<CIMObjectPath> cimObjectPaths = this.getCIMObjectPathForAssociationClass();
        List<CIMInstanceInfoForAssociation> cimInstanceInfoList = this.getcimInstanceInfoForAssociationList();
        for (int i = 0; i < cimInstanceInfoList.size(); ++i) {
            Collection<CimPropertyForAssociationInfo> cimPropertyInfoColn = cimInstanceInfoList.get(i).getAllCimPropertiesForAssociation();
            ArrayList<CIMProperty> cimPropertiesList = new ArrayList<CIMProperty>();
            for (CimPropertyForAssociationInfo cimProperty : cimPropertyInfoColn) {
                String name = cimProperty.getPropertyName();
                List<CIMObjectPath> value = cimProperty.getValueReference();
                cimPropertiesList.add(new CIMProperty(name, CIMDataType.STRING_T, (Object)value.get(0).toString()));
            }
            CIMProperty[] cimProperties = cimPropertiesList.toArray(new CIMProperty[0]);
            CIMInstance cimInst = new CIMInstance(cimObjectPaths.get(i), cimProperties);
            cimInstnaces.add(cimInst);
        }
        return cimInstnaces;
    }

    public List<CIMInstance> getCIMInstances() throws XmlParserException {
        ArrayList<CIMInstance> cimInstnaces = new ArrayList<CIMInstance>();
        List<CIMObjectPath> cimObjectPaths = this.getCIMObjectPath();
        List<CIMInstanceInfo> cimInstanceInfoList = this.getCIMInstanceInfoList();
        for (int i = 0; i < cimInstanceInfoList.size(); ++i) {
            Collection<CimPropertyInfo> cimPropertyInfoColn = cimInstanceInfoList.get(i).getAllCimProperties();
            ArrayList<CIMProperty> cimPropertiesList = new ArrayList<CIMProperty>();
            for (CimPropertyInfo cimProperty : cimPropertyInfoColn) {
                String name = cimProperty.getPropertyName();
                CIMDataType dataType = cimProperty.getCIMDataType();
                if (cimProperty.isArrayDataType()) {
                    this.computeArrayTypes(cimProperty, cimPropertiesList, cimProperty.getCIMDataType(), name);
                    continue;
                }
                String value = cimProperty.getPropertyValue();
                if (null == value) {
                    cimPropertiesList.add(new CIMProperty(name, dataType, (Object)value));
                    continue;
                }
                switch (dataType.getType()) {
                    case 0: {
                        UnsignedInteger8 uint8 = new UnsignedInteger8(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)uint8.intValue()));
                        break;
                    }
                    case 1: {
                        Byte sint8 = new Byte(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)sint8));
                        break;
                    }
                    case 2: {
                        UnsignedInteger16 uint16 = new UnsignedInteger16(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)uint16));
                        break;
                    }
                    case 3: {
                        Short sint16 = new Short(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)sint16));
                        break;
                    }
                    case 4: {
                        UnsignedInteger32 uint32 = new UnsignedInteger32(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)uint32));
                        break;
                    }
                    case 5: {
                        Integer sint32 = new Integer(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)sint32));
                        break;
                    }
                    case 6: {
                        UnsignedInteger64 uint64 = new UnsignedInteger64(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)uint64));
                        break;
                    }
                    case 7: {
                        Long sint64 = new Long(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)sint64));
                        break;
                    }
                    case 8: {
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)value));
                        break;
                    }
                    case 9: {
                        Boolean bool = new Boolean(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)bool));
                        break;
                    }
                    case 10: {
                        Float floatVal = new Float(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)floatVal));
                        break;
                    }
                    case 11: {
                        Double doubleVal = new Double(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)doubleVal));
                        break;
                    }
                    case 12: {
                        CIMDateTimeAbsolute dateTime = new CIMDateTimeAbsolute(value);
                        cimPropertiesList.add(new CIMProperty(name, dataType, (Object)dateTime));
                        break;
                    }
                }
            }
            CIMProperty[] cimProperties = cimPropertiesList.toArray(new CIMProperty[0]);
            CIMInstance cimInst = new CIMInstance(cimObjectPaths.get(i), cimProperties);
            cimInstnaces.add(cimInst);
        }
        return cimInstnaces;
    }

    private void computeArrayTypes(CimPropertyInfo cimProperty, List<CIMProperty> cimPropertiesList, CIMDataType dataType, String name) {
        List<String> value = cimProperty.getPropertyValueList();
        if (null == value) {
            cimPropertiesList.add(new CIMProperty(name, dataType, value));
        } else {
            switch (dataType.getType()) {
                case 2: {
                    UnsignedInteger16[] intValue = new UnsignedInteger16[value.size()];
                    for (int i = 0; i < value.size(); ++i) {
                        intValue[i] = new UnsignedInteger16(Integer.parseInt(value.get(i)));
                    }
                    cimPropertiesList.add(new CIMProperty(name, dataType, (Object)intValue));
                    break;
                }
                case 8: {
                    String[] finalValue = new String[value.size()];
                    finalValue = value.toArray(new String[0]);
                    cimPropertiesList.add(new CIMProperty(name, dataType, (Object)finalValue));
                    break;
                }
            }
        }
    }

    public static void printClasspath() {
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)sysClassLoader).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println(urls[i].getFile());
        }
    }

    public void addCimInstanceInfo(CIMInstanceInfo cimInstanceInfo) {
        this.cimInstanceInfoList.add(cimInstanceInfo);
    }

    public void addCIMAssociationName(CIMAssociationName cIMAssociationName) {
        this.cimAssociationNameList.add(cIMAssociationName);
    }

    public List<CIMAssociationName> getCimAssociationNameInfoList() {
        return this.cimAssociationNameList;
    }

    public List<CIMInstanceInfo> getCIMInstanceInfoList() {
        return this.cimInstanceInfoList;
    }

    public void addCIMInstanceInfoForAssociation(CIMInstanceInfoForAssociation cimInstanceInfoForAssociation) {
        this.cimInstanceInfoForAssociationList.add(cimInstanceInfoForAssociation);
    }

    public List<CIMInstanceInfoForAssociation> getcimInstanceInfoForAssociationList() {
        return this.cimInstanceInfoForAssociationList;
    }
}

